package fuku.skk4j.im;

/**
 * ޻̾Ѵ饹<BR>
 * (: Υ޻Ϥ٤ƾʸϤɬפ)
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
class Converter implements RomanKanaTable {

    /**
     * ǥեȥ󥹥ȥ饯
     *
     */
    private Converter() {
        super();
    }


    /**
     * Ѵޤ
     *
     * @param str Ѵʸ
     * @param type ɽ
     *             0:̼ʤ1:̼ꤢꡢ2:۵
     * @return Ѵʸ (ͤ礭null)
     */
    static String num2kanji(String str, int type) {
        StringBuffer buf = new StringBuffer();
        String num_str = str;
        String[] kanji = KANJI_NUM;
        String[] kurai = KANJI_KURAI;
        if (type == 2) {
            kanji = KANJI_NUM_OLD;
            kurai = KANJI_KURAI_OLD;
        }
        // ̼
        if (type > 0) {
            int len = str.length();
            if (len > 20) { // ѴǤΤ20()ޤ
                return null;
            }
            if (str.charAt(len-1) != '0') {
                buf.append(str.charAt(len-1)); // ΰ
            }
            for (int i=len-2; i>=0; i--) {
                char ch = str.charAt(i);
                if (ch == '0') {
                    continue;
                }
                int p = len-i-1;
                if (p%4 == 0) { // ///ΰ
                    buf.append(kurai[p/4+2]);
                    buf.append(ch);
                } else { // /ɴ/ΰ
                    buf.append(kurai[p%4-1]);
                    if (ch == '1') { // ʳ1Ϥʤ
                        if (buf.toString().endsWith("") || type == 2) {
                            buf.append(ch);
                        }
                    } else {
                        if (ch != '0') { // 0Ϥʤ
                            buf.append(ch);
                        }
                    }
                }
            }
            num_str = buf.reverse().toString();
            buf.delete(0, buf.length());
        }
        // Ѵ
        int num = -1;
        int len = num_str.length();
        for (int i=0; i<len; i++) {
            try {
                num = Integer.parseInt(String.valueOf(num_str.charAt(i)));
            } catch (NumberFormatException e) {
                num = -1;
            }
            if (num != -1) {
                buf.append(kanji[num]);
            } else {
                buf.append(num_str.charAt(i));
            }
        }
        return buf.toString();
    }

    /**
     * 򾭴ǻѤɽѴޤ
     *
     * @param str Ѵʸ
     * @return Ѵʸ
     */
    static String num2shogi(String str) {
        if (str.length() != 2) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(narrow2wide(str.substring(0,1)));
        buf.append(num2kanji(str.substring(1,2),0));
        return buf.toString();
    }

    /**
     * ʿ̾Ҳ̾Ѵޤ
     *
     * @param str Ѵʸ
     * @return Ѵʸ
     */
    static String hiragana2katakana(String str) {
        StringBuffer buf = new StringBuffer(str);
        int vu;
        while ((vu=buf.toString().indexOf("")) != -1) {
            buf.replace(vu, vu+2, "");
        }
        String tmp = buf.toString();

        buf.delete(0, buf.length());
        int len = tmp.length();
        for (int i=0; i<len; i++) {
            int ch = tmp.charAt(i);
            if (ch > 0x3040 && ch < 0x3094) {
                ch = ch + 0x60;
            }
            buf.append((char)ch);
        }
        return buf.toString();
    }

    /**
     * Ҳ̾ʿ̾Ѵޤ
     *
     * @param str Ѵʸ
     * @return Ѵʸ
     */
    static String katakana2hiragana(String str) {
        StringBuffer buf = new StringBuffer();
        int len = str.length();
        for (int i=0; i<len; i++) {
            int ch = str.charAt(i);
            if (ch > 0x30a0 && ch < 0x30f4) {
                ch = ch - 0x60;
            }
            buf.append((char)ch);
        }

        int vu;
        while ((vu=buf.toString().indexOf("")) != -1) {
            buf.replace(vu, vu+1, "");
        }
        return buf.toString();
    }

    /**
     * ޻̾ѴԤޤ
     *
     * @param roman ޻
     * @param hiragana ʿ̾/Ҳ̾
     * @return ̾ʸ
     */
    static String roman2kana(String roman, boolean hiragana) {
        int i;
        if ((i=_searchKana(roman)) != -1) {
            if (hiragana) {
                return KANA_TABLE[i][1];
            } else {
                return KANA_TABLE[i][2];
            }
        }
        return null;
    }

    /**
     * ʸȾʸʸѴޤ
     *
     * @param narrow Ⱦʸޤʸ
     * @return ʸѴ줿ʸ
     */
    static String narrow2wide(String narrow) {
        StringBuffer buf = new StringBuffer();
        int len = narrow.length();
        for (int i=0; i<len; i++) {
            char ch = narrow.charAt(i);
            int j = narrow2wide(ch, false);
            if (j != -1) {
                buf.append((char)j);
            } else {
                buf.append(ch);
            }
        }
        return buf.toString();
    }

    /**
     * ȾѴԤޤ
     *
     * @param narrow Ⱦʸ
     * @param flag Ѵơ֥Ȥɤ
     * @return ʸ
     */
    static int narrow2wide(char narrow, boolean flag) {
        int ch = -1;
        if (flag) {
            int i = _searchSym(narrow);
            if (i != -1) {
                ch = SYM_TABLE[i][1];
            }
        } else {
            switch (narrow) {
                case ' ':
                    ch = 0x3000;
                    break;
                case '\'':
                    ch = 0x2019;
                    break;
                case '"':
                    ch = 0x201d;
                    break;
                default:
                    if (narrow >= 0x21 && narrow <= 0x7e) {
                        ch = narrow + 0xfee0;
                    }
                    break;
            }
        }
        return ch;
    }

    /**
     * ޻ΰǤ뤫ɤȽ̤ޤ
     *
     * @param roman Ƚ̤ʸ
     * @return Ƚ̷
     */
    static boolean checkRoman(String roman) {
        int i = 0;
        int j = KANA_TABLE.length - 1;
        int x;

        while (i < j) {
            x = (i + j) / 2;
            if (KANA_TABLE[x][0].startsWith(roman)) {
                return true;
            }
            int comp = KANA_TABLE[x][0].compareTo(roman);
            if (comp < 0) {
                i = x + 1;
            } else {
                j = x;
            }
        }
        return false;
    }


    /**
     * ޻Ѵơ֥뤫鸡ޤ
     *
     * @param key 
     * @return ơ֥Υǥå
     */
    private static int _searchKana(String key) {
        int i = 0;
        int j = KANA_TABLE.length - 1;
        int x;

        while (i < j) {
            x = (i + j) / 2;
            int comp = KANA_TABLE[x][0].compareTo(key);
            if (comp == 0) {
                return x;
            } else if (comp < 0) {
                i = x + 1;
            } else {
                j = x;
            }
        }
        return -1;
    }

    /**
     * ȾʸѴơ֥뤫鸡ޤ
     *
     * @param key 
     * @return ơ֥Υǥå
     */
    private static int _searchSym(char key) {
        int i = 0;
        int j = SYM_TABLE.length - 1;
        int x;

        while (i < j) {
            x = (i + j) / 2;
            int comp = SYM_TABLE[x][0] - key;
            if (comp == 0) {
                return x;
            } else if (comp < 0) {
                i = x + 1;
            } else {
                j = x;
            }
        }
        return -1;
    }
}

// end of Converter.java
