package fuku.skk4j.im;

import java.util.*;

/**
 * Ѵ䥯饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
class Candidate {

    /**  */
    private SKKDictionary _dic = null;

    /** Ѵ褦ȤƤñɤ (:"ʤˤ") */
    private String _yomi = null;
    /** ߤμ񸡺 (:"ʤˤk ") */
    private String _key = null;
    /** Ϥ줿겾̾ (:"") */
    private String _okuri = null;
    /** ñϿɽɤ (:"ʤˤ*") */
    private String _label = null;
    /** ѴͤΥꥹ */
    private List _num = null;
    /** 䴰Υꥹ */
    private List _comp = null;

    /** ѴΥꥹ (/1/2/.../n/) */
    private String _candidateList = null;
    /** ѴΥꥹ (/KEY/1/2/.../n/) */
    private List _candidateNumList = null;

    /** Ѵ */
    private String _candidate = null;
    /** οѴ */
    private String _candidateNum = null;

    /** ѴꥹȤΥǥå */
    private int _index = 0;
    /** Ѵο */
    private int _maxCount = 0;
    /** 䴰ꥹȤΥǥå */
    private int _compIndex = 0;

    /** 䴰⡼ɤǤ뤳Ȥ򼨤ե饰 */
    private boolean _compMode = false;


    /**
     * 󥹥ȥ饯(䴰)
     *
     * @param dic 
     * @param yomi ʬɤ (ʤnull)
     */
    Candidate(SKKDictionary dic, String yomi) {
        super();
        _dic = dic;
        _dic.reset();

        String key = null;
        if (yomi != null) {
            key = _replaceNum(yomi);
        }

        _comp = _dic.complement(key);
        if (_comp == null) {
            _yomi = yomi;
            _key = key + " ";
            _label = yomi;
        }
        _compMode = true;
    }

    /**
     * 󥹥ȥ饯(̾Ѵ)
     *
     * @param dic 
     * @param yomi ʬɤ
     * @param okuriStr 겾̾ (겾̾ʤnull)
     * @param okuriChar 겾̾λҲ (겾̾ʤ-1)
     */
    Candidate(SKKDictionary dic, String yomi,
                        String okuriStr, int okuriChar) {
        super();
        _dic = dic;
        _dic.reset();
        _yomi = yomi;
        _okuri = okuriStr;

        _key = _replaceNum(_yomi);
        if (_okuri == null) {
            _label = _key;
        } else {
            _label = _key + "*" + _okuri;
        }
        if (okuriChar == -1) {
            _key = _key + " ";
        } else {
            _key = _key + String.valueOf((char)okuriChar) + " ";
        }

        if (_num == null) {
            _setup(_dic.searchNext(_key));
        } else {
            _setup(_dic.search(_key));
        }
    }


    /**
     * ߤѴޤ
     *
     */
    void delete() {
        if (_candidate == null) {
            return;
        }
        if (_okuri == null) {
            _dic.delete(_key, _candidate);
        } else {
            _dic.delete(_key, _candidate, _okuri);
        }
    }

    /**
     * ѴϿޤ
     *
     * @param candidate ϿѴ
     */
    void regist(String candidate) {
        _candidateList = _candidateList + candidate + "/";
        _candidate = candidate;
        if (_num != null) {
            String str = _dic.replaceNum(candidate, _num);
            if (_candidateNumList == null) {
                _candidateNumList = new ArrayList();
            }
            _candidateNumList.add("/" + candidate + str);
            StringTokenizer st = new StringTokenizer(str, "/");
            _maxCount = _maxCount + st.countTokens();
            _candidateNum = st.nextToken();
        }
        _index++;
    }

    /**
     * 򤵤ƤѴϿޤ
     *
     */
    void regist() {
        if (_candidate == null) {
            return;
        }
        if (_okuri == null) {
            _dic.regist(_key, _candidate);
        } else {
            _dic.regist(_key, _candidate, _okuri);
        }

        // Ѵʤʤ齪λ
        if (_num == null) {
            return;
        }

        // Ѵ䤬ʤнλ
        if (_candidateNum == null) {
            return;
        }

        // "#4"ִǳꤷʸϿ
        int idx1 = _candidate.indexOf("#4");
        int idx2 = _candidate.indexOf('#');
        int max = _num.size();
        int cnt = 0;
        int pnt = 0;
        while (idx1 != -1) { // "#4"ʤнλ
            while (idx1 != idx2) { // "#4"ˤ"#N"򥫥
                char ch = _candidate.charAt(idx2+1);
                if (ch >= '0' && ch <= '9') {
                    cnt++;
                }
                idx2 = _candidate.indexOf('#', idx2+1);
            }
            if (cnt >= max) {
                break;
            }
            String key = (String)_num.get(cnt) + " ";
            String word = null;
            String a = _candidate.substring(0, idx1); // "#4"
            String b = _candidate.substring(idx1+2); // "#4"ʸ
            int i = 0;
            if ((i=a.lastIndexOf('#')) != -1) { // "#" a "#4"
                char ch = a.charAt(i+1);
                if (ch >= '0' && ch <= '9') {
                    a = a.substring(i+2, a.length());
                } else {
                    a = a.substring(i+1, a.length());
                }
            }
            if ((i=b.indexOf('#')) != -1) { // "#4" b "#"
                b = b.substring(0, i);
            }
            // a,bڤФǤʤä齪λ ("#4#1"ʤ)
            // "#4"Ѵ줿ʸȽ̤Ǥʤ
            if (a.length() < 1 || b.length() < 1) {
                break;
            }
            // ab˶ޤ줿ʬʸ
            if ((i=_candidateNum.indexOf(a, pnt)) != -1
                && (pnt=_candidateNum.indexOf(b, i+a.length())) != -1 ) {
                word = _candidateNum.substring(i+a.length(), pnt);
            }
            if (word != null && word.length() > 0) {
                _dic.regist(key, word);
            }
            idx1 = _candidate.indexOf("#4", idx1+1);
        }
    }

    /**
     * Ѵ֤ޤ
     *
     * @return Ѵ (ʤnull)
     */
    String getNextCandidate() {
        StringTokenizer st;
        if (_index >= _maxCount) { // Ѵ䤬ʤи
            if (_num == null) {
                _candidateList = _dic.searchNext(_key, _candidateList);
                st = new StringTokenizer(_candidateList, "/");
                _maxCount = st.countTokens();
                if (_index >= _maxCount) {
                    return null;
                }
            } else {
                return null;
            }
        }

        if (_num == null) {
            st = new StringTokenizer(_candidateList, "/");
            for (int i=_index; i>0; i--) {
                st.nextToken();
            }
            _candidate = st.nextToken();
            _candidateNum = null;
        } else { // Ѵ
            int size = _candidateNumList.size();
            int i = 0;
            for (int n=0; n<size; n++) {
                st = new StringTokenizer((String)_candidateNumList.get(n), "/");
                int j = st.countTokens() - 1;
                if ((i+j) > _index) {
                    _candidate = st.nextToken();
                    for (; i<_index; i++) {
                        st.nextToken();
                    }
                    _candidateNum = st.nextToken();
                    break;
                }
                i = i + j;
            }
        }
        _index++;
        if (_candidateNum != null) {
            return LispEmu.analyze(_candidateNum, _num);
        }
        return LispEmu.analyze(_candidate);
    }

    /**
     * Ѵ֤ޤ
     *
     * @return Ѵ (ʤnull)
     */
    String getPrevCandidate() {
        if (_index < 2) {
            return null;
        }
        StringTokenizer st;
        if (_num == null) {
            st = new StringTokenizer(_candidateList, "/");
            for (int i=_index-2; i>0; i--) {
                st.nextToken();
            }
            _candidate = st.nextToken();
            _candidateNum = null;
        } else {
            int size = _candidateNumList.size();
            int i = 0;
            for (int n=0; n<size; n++) {
                st = new StringTokenizer((String)_candidateNumList.get(n), "/");
                int j = st.countTokens() - 1;
                if ((i+j) > _index-2) {
                    _candidate = st.nextToken();
                    for (; i<_index-2; i++) {
                        st.nextToken();
                    }
                    _candidateNum = st.nextToken();
                    break;
                }
                i = i + j;
            }
        }
        _index--;
        if (_candidateNum != null) {
            return LispEmu.analyze(_candidateNum, _num);
        }
        return LispEmu.analyze(_candidate);
    }

    /**
     * 䴰Ԥޤ
     *
     * @return 䴰ʸ (ʤnull)
     */
    String getNextComplement() {
        if (_comp == null) {
            return null;
        }
        if (_comp.size() <= _compIndex) {
            return null;
        }
        String entry = (String)_comp.get(_compIndex);
        int i = entry.indexOf(' ');
        _yomi = entry.substring(0, i);
        if (_num != null) { // ᤹ͤ
            StringBuffer buf = new StringBuffer(_yomi);
            int idx = _yomi.indexOf('#');
            int size = _num.size();
            for (int j=0; j<size; j++) {
                buf.replace(idx, idx+1, (String)_num.get(j));
                idx = buf.toString().indexOf('#');
            }
            _yomi = buf.toString();
        }
        _key = entry.substring(0, i+1);
        _label = _yomi;
        _compIndex++;
        return _yomi;
    }

    /**
     * 䴰Ԥޤ
     *
     * @return 䴰ʸ (ʤnull)
     */
    String getPrevComplement() {
        if (_compIndex < 2) {
            return null;
        }
        String entry = (String)_comp.get(_compIndex-2);
        int i = entry.indexOf(' ');
        _yomi = entry.substring(0, i);
        if (_num != null) { // ᤹ͤ
            StringBuffer buf = new StringBuffer(_yomi);
            int idx = _yomi.indexOf('#');
            int size = _num.size();
            for (int j=0; j<size; j++) {
                buf.replace(idx, idx+1, (String)_num.get(j));
                idx = buf.toString().indexOf('#');
            }
            _yomi = buf.toString();
        }
        _key = entry.substring(0, i+1);
        _label = _yomi;
        _compIndex--;
        return _yomi;
    }

    /**
     * ߤѴ֤ޤ
     *
     * @return ߤѴ
     */
    String getCandidate() {
        if (_candidateNum != null) {
            return _candidateNum;
        }
        return _candidate;
    }

    /**
     * ĤѴ֤ޤ
     *
     * @return Ѵ
     */
    int getCount() {
        return _maxCount - _index;
    }

    /**
     * Ѵ򤷤ޤ
     *
     * @param index ѴΥǥåֹ
     */
    void setIndex(int index) {
        _index = index - 1;
        getNextCandidate();
    }

    /**
     * Ѵ֤ޤ
     *
     * @return Ѵ
     */
    int getIndex() {
        return _index;
    }

    /**
     * Ĥμ֤ޤ
     *
     * @return 
     */
    int getDicCount() {
        if (_candidateNumList != null) {
            return 0;
        }
        return _dic.countDics();
    }

    /**
     * Ѵ䤬뤫ɤȽ̤ޤ
     *
     * @return Ѵ䤬뤫ɤ
     */
    boolean hasCandidate() {
        // 䴰⡼ɤǥ֥ȤƤѴԤ
        if (_compMode) {
            _dic.reset();
            if (_comp == null) {
                _setup(_dic.searchNext(_key));
            } else {
                if (_num == null) {
                    String entry = (String)_comp.get(_compIndex-1);
                    int i = entry.indexOf(' ');
                    _setup(entry.substring(i+1));
                } else {
                    _setup(_dic.search(_key));
                }
            }
        }

        if (_maxCount > 0) {
            return true;
        }
        return false;
    }

    /**
     * Ѵ䤬뤫ɤȽ̤ޤ
     *
     * @return Ѵ䤬뤫ɤ
     */
    boolean hasNextCandidate() {
        if (_maxCount > _index) {
            return true;
        }

        if (_num == null && _maxCount > 0) {
            _candidateList = _dic.searchNext(_key, _candidateList);
            StringTokenizer st = new StringTokenizer(_candidateList, "/");
            _maxCount = st.countTokens();
            if (_maxCount > _index) {
                return true;
            }
        }
        return false;
    }

    /**
     * Ѵ䤬뤫ɤȽ̤ޤ
     *
     * @return Ѵ䤬뤫ɤ
     */
    boolean hasPrevCandidate() {
        if (_index > 1) {
            return true;
        }
        return false;
    }

    /**
     * 䴰뤫ɤȽ̤ޤ
     *
     * @return 䴰뤫ɤ
     */
    boolean hasNextComplement() {
        if (_comp == null) {
            return false;
        }
        if (_comp.size() > _compIndex) {
            return true;
        }
        return false;
    }

    /**
     * 䴰뤫ɤȽ̤ޤ
     *
     * @return 䴰뤫ɤ
     */
    boolean hasPrevComplement() {
        if (_compIndex > 1) {
            return true;
        }
        return false;
    }

    /**
     * ɤߤ֤ޤ
     *
     * @return ɤ
     */
    String getYomi() {
        return _yomi;
    }

    /**
     * ñϿɥɽ٥ʸ֤ޤ
     *
     * @return ɤ
     */
    String getLabel() {
        return _label;
    }


    /**
     * ʸοʬ'#'ִ_num˳Ǽޤ
     *
     * @param str ִʸ
     * @return ִʸ
     */
    private String _replaceNum(String str) {
        StringBuffer buf = new StringBuffer();
        StringBuffer numbuf = new StringBuffer();
        _num = new ArrayList();
        boolean flag = true;
        int len = str.length();
        for (int i=0; i<len; i++) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') {
                numbuf.append(ch);
                if (flag) {
                    buf.append('#');
                }
                flag = false;
            } else {
                if (numbuf.length() > 0) {
                    _num.add(numbuf.toString());
                    numbuf.delete(0, numbuf.length());
                }
                buf.append(ch);
                flag = true;
            }
        }
        if (numbuf.length() > 0) {
            _num.add(numbuf.toString());
        }
        if (_num.isEmpty()) {
            _num = null;
        }
        return buf.toString();
    }

    /**
     * ѴԤޤ
     *
     * @param candidate Ѵꥹ
     */
    private void _setup(String candidate) {
        _candidateList = candidate;
        _index = 0;
        StringTokenizer st = null;
        if (_candidateList != null) {
            st = new StringTokenizer(candidate, "/");
            _maxCount = st.countTokens();
        } else {
            _maxCount = 0;
        }
        if (_num != null && st != null) {
            _candidateNumList = new ArrayList();
            _maxCount = 0;
            while (st.hasMoreTokens()) {
                String key = st.nextToken();
                String str = _dic.replaceNum(key, _num);
                _candidateNumList.add("/" + key + str);
                StringTokenizer st2 = new StringTokenizer(str, "/");
                _maxCount = _maxCount + st2.countTokens();
            }
        }
    }
}

// end of Candidate.java
