package fuku.skk4j.dic;

import java.util.*;

/**
 * ʣ缭񥯥饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.1
 */
public class CollectedDic implements SKKDic {

    /** ʣμ */
    private SKKDic[] _dic = null;
    /** ߤθ */
    private int _dicIndex = 0;
    /** ߤθ */
    private String _curKey = null;


    /**
     * 󥹥ȥ饯
     *
     * @param dic ʣ缭Ȥư
     */
    public CollectedDic(SKKDic[] dic) {
        super();
        _dic = dic;
    }


    /**
     * ٤ƤμĤޤ
     *
     */
    public void close() {
        if (_dic != null) {
            for (int i=0; i<_dic.length; i++) {
                _dic[i].close();
            }
        }
    }

    /**
     * 뼭򼭽ꥹȤκǽꤷޤ
     *
     */
    public void reset() {
        _dicIndex = 0;
    }

    /**
     * 뼭񤬤ޤ뤫ɤȽ̤ޤ
     *
     * @return ޤǽɤ
     */
    public boolean hasMoreDics() {
        if (_dicIndex < _dic.length) {
            return true;
        }
        return false;
    }

    /**
     * ̤μο֤ޤ
     *
     * @return ̤μ
     */
    public int countDics() {
        return _dic.length - _dicIndex;
    }

    /**
     * ٤Ƥμ񤫤򸡺ޤ
     *
     * @param key  (Ф+" ")
     * @return Ѵ (ʤnull)
     */
    public String search(String key) {
        int i = _dicIndex;
        _dicIndex = 0;
        String result = null;
        while (_dicIndex < _dic.length) {
            result = searchNext(key, result);
        }
        _dicIndex = i;
        return result;
    }

    /**
     * ̤μ񤫤򸡺ޤ
     *
     * @param key  (Ф+" ")
     * @return Ѵ (ʤnull)
     */
    public String searchNext(String key) {
        if (_curKey == null) {
            _curKey = key;
        } else {
            if (!_curKey.equals(key)) {
                reset();
            }
        }
        return searchNext(key, null);
    }

    /**
     * ̤μ񤫤鿷ʸ򸡺θ˲äޤ
     *
     * @param key  (Ф+" ")
     * @param list Ѵ
     * @return Ѵ
     */
    public String searchNext(String key, String list) {
        // 뼭񤬤ʤ
        if (_dicIndex >= _dic.length) {
            return list;
        }

        SKKDic searchDic = _dic[_dicIndex];
        String candidate = searchDic.search(key);
        if (searchDic instanceof UserDic) {
            if (candidate != null) { // 겾̾θ̩ʥޥåԤʤ
                int i = candidate.indexOf("/[");
                if (i != -1) {
                    candidate = candidate.substring(0, i+1);
                }
            }
        }
        if (candidate != null) { // (annotation)̵뤹
            StringBuffer buf = new StringBuffer(candidate);
            int idx1 = candidate.indexOf(';');
            int idx2;
            while (idx1 != -1) {
                idx2 = buf.toString().indexOf('/', idx1+1);
                buf.delete(idx1, idx2);
                idx1 = buf.toString().indexOf(';', idx1);
            }
            candidate = buf.toString();
        }
        _dicIndex++;

        boolean flag = false; // 䤬줿ɤ
        String candidateList = list;
        if (candidate != null) {
            if (list == null) {
                return candidate;
            }

            // ʣκ
            StringTokenizer st = new StringTokenizer(candidate, "/");
            while (st.hasMoreTokens()) {
                String str = "/" + st.nextToken() + "/";
                int i = candidateList.indexOf(str);
                if (i == -1) {
                    candidateList = candidateList.concat(str.substring(1));
                    flag = true;
                }
            }
        }
        if (!flag) { // ʸ䤬դޤǺƵŪ˸
            candidateList = searchNext(key, candidateList);
        }
        return candidateList;
    }
}

// end of CollectedDic.java
