/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.util.ArrayIterator;
import org.apache.velocity.util.EnumerationIterator;
import org.apache.velocity.util.introspection.IntrospectionCacheData;

public class Foreach
extends Directive {
    private static final int UNKNOWN = -1;
    private static final int INFO_ARRAY = 1;
    private static final int INFO_ITERATOR = 2;
    private static final int INFO_MAP = 3;
    private static final int INFO_COLLECTION = 4;
    private static final int INFO_ENUMERATION = 5;
    private String counterName;
    private int counterInitialValue;
    private String elementKey;

    public String getName() {
        return "foreach";
    }

    public int getType() {
        return 1;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws Exception {
        super.init(rs, context, node);
        this.counterName = this.rsvc.getString("directive.foreach.counter.name");
        this.counterInitialValue = this.rsvc.getInt("directive.foreach.counter.initial.value");
        this.elementKey = node.jjtGetChild((int)0).getFirstToken().image.substring(1);
    }

    private Iterator getIterator(InternalContextAdapter context, Node node) throws MethodInvocationException {
        Object listObject = node.jjtGetChild(2).value(context);
        if (listObject == null) {
            return null;
        }
        int type = -1;
        IntrospectionCacheData icd = context.icacheGet(this);
        Class<?> c = listObject.getClass();
        if (icd != null && icd.contextData == c) {
            type = (Integer)icd.thingy;
        }
        if (type == -1) {
            if (listObject instanceof Object[]) {
                type = 1;
            } else if (listObject instanceof Collection) {
                type = 4;
            } else if (listObject instanceof Map) {
                type = 3;
            } else if (listObject instanceof Iterator) {
                type = 2;
            } else if (listObject instanceof Enumeration) {
                type = 5;
            }
            if (type != -1) {
                icd = new IntrospectionCacheData();
                icd.thingy = new Integer(type);
                icd.contextData = c;
                context.icachePut(this, icd);
            }
        }
        switch (type) {
            case 4: {
                return ((Collection)listObject).iterator();
            }
            case 2: {
                this.rsvc.warn("Warning! The reference " + node.jjtGetChild((int)2).getFirstToken().image + " is an Iterator in the #foreach() loop at [" + this.getLine() + "," + this.getColumn() + "]" + " in template " + context.getCurrentTemplateName() + ". Because it's not resetable," + " if used in more than once, this may lead to" + " unexpected results.");
                return (Iterator)listObject;
            }
            case 5: {
                this.rsvc.warn("Warning! The reference " + node.jjtGetChild((int)2).getFirstToken().image + " is an Enumeration in the #foreach() loop at [" + this.getLine() + "," + this.getColumn() + "]" + " in template " + context.getCurrentTemplateName() + ". Because it's not resetable," + " if used in more than once, this may lead to" + " unexpected results.");
                return new EnumerationIterator((Enumeration)listObject);
            }
            case 1: {
                return new ArrayIterator((Object[])listObject);
            }
            case 3: {
                return ((Map)listObject).values().iterator();
            }
        }
        this.rsvc.warn("Could not determine type of iterator in #foreach loop for " + node.jjtGetChild((int)2).getFirstToken().image + " at [" + this.getLine() + "," + this.getColumn() + "]" + " in template " + context.getCurrentTemplateName());
        return null;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, MethodInvocationException, ResourceNotFoundException, ParseErrorException {
        Iterator i = this.getIterator(context, node);
        if (i == null) {
            return false;
        }
        int counter = this.counterInitialValue;
        Object o = context.get(this.elementKey);
        Object ctr = context.get(this.counterName);
        while (i.hasNext()) {
            context.put(this.counterName, new Integer(counter));
            context.put(this.elementKey, i.next());
            node.jjtGetChild(3).render(context, writer);
            ++counter;
        }
        if (ctr != null) {
            context.put(this.counterName, ctr);
        } else {
            context.remove(this.counterName);
        }
        if (o != null) {
            context.put(this.elementKey, o);
        } else {
            context.remove(this.elementKey);
        }
        return true;
    }
}

