/* *******************************************************************
** Copyright (c) 2002-2015 Seiji Kaneko. All rights reserved.
** Everyone is permitted to use this program in source and binary
** form, with or without modification if and only if the following
** conditions are met:
** 1. Redistributions of source code must retain the above copyright
**   notice, copyright notice written in source code, additional list
**   of conditions and the following disclaimer.
** 2. Redistributions in machine readable form must reproduce the 
**   above copyright notice and the following disclaimer in the
**   documentation or other material provided with the distribution.
** 3. Neither the name of the copyright holders nor the names of its 
**   contributors may be used to endorse or promote products derived from 
**   this software without specific prior written permission.
**********************************************************************
** Disclaimer: This software is provided and distributed AS iS, 
**	without any implicit or explicit warranties, and not
**	guaranteed to be error-free. In no event shall the author be
**	liable for any direct, indirect or incidental damages,
**	including, but not limited to, loss of data, use or profits
**	responsibility for any direct or indirect damages or results
**	arising by using whole or a part of this software.
**********************************************************************
** out_code_table.c: output various code table and its handler
** $Id: out_code_table.c,v 1.135 2016/06/14 14:55:50 seiji Exp seiji $
**
**********************************************************************
** Notice for limitation of these converter programming.
**  Since these routine is called from output converters, these
**  converter may not use ambiguous characters(i.e. not strict
**  ascii nor X0208).
*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <stddef.h>

#include "skf.h"
#include "skf_fileio.h"
#include "convert.h"
#include "oconv.h"
#include "in_code_table.h"

#include "uni_table.c"

#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if	!defined(OUTPUT_DYNAMIC_TABLE)
#include "out_table_defs.h"
#endif

#ifdef HAVE_LANGINFO_H
#include <langinfo.h>
#define LANGNAME_LIMIT 64
#else
#define LANGNAME_LIMIT 64
#endif

void output_codeset_fix_table P_ ((const long *));

#if  defined(HAVE_LOCALE_H) && !defined(OUTPUT_DYNAMIC_TABLE)
static const char *localemod = "cjknarrow";
#endif

/* --------------------------------------------------------------- */
int	cns11643_defined_code = 3;    /* cns11643-1,2,3 is defined */
/* --------------------------------------------------------------- */
/* conversion tables						   */
/* --------------------------------------------------------------- */
/* tables							   */
/* --------------------------------------------------------------- */
/* ascii table without LF/CR/^Z					   */
/*  (CR/LF/FF/BS/SUB/^Z in FOLD SUPPORT)			   */
/* --------------------------------------------------------------- */
unsigned short o_ascii_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x0000,0x000b,0x000c,0x0000,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x0000,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,

  0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f,
  0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f
};

/* Note: sentence clip - sentence is terminated by '.', ':',
	';', '?' or '<'. For handling SGML, > is also delimiter.
*/
#ifdef FOLD_SUPPORT
const unsigned short o_ascii_entity[128] = {
  0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
  O_IS_TAIL,(unsigned short)(O_IS_DELIM | O_IS_ADELIM),O_IS_TAIL,
   0x0000,O_IS_TAIL,O_IS_TAIL,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
  O_IS_TAIL,0x0000,O_IS_DELIM,0x0000, 0x0000,0x0000,0x0000,0x0000,

  (unsigned short)(O_IS_DELIM | O_IS_ADELIM),
  	(unsigned short)(O_IS_ADELIM | O_YAKU_BURASA),
	O_IS_ALPHANUM,O_IS_DELIM,
  (unsigned short)(O_IS_DELIM | O_YAKU_OIDASH),
  	(unsigned short)(O_IS_DELIM | O_YAKU_OIDASH),
  	(unsigned short)(O_IS_DELIM | O_YAKU_OIDASH),O_IS_ALPHANUM,
  (unsigned short)(O_IS_DELIM | O_YAKU_OIDASH),O_YAKU_BURASA,
  	O_IS_DELIM,(unsigned short)(O_IS_DELIM | O_YAKU_OIDASH),
  (unsigned short)(O_IS_ADELIM | O_YAKU_BURASA),
  	(unsigned short)(O_IS_ADELIM | O_YAKU_BURASA),
  	(unsigned short)(O_IS_ADELIM | O_YAKU_BURASA | O_IS_SDELIM),
	O_IS_DELIM,

  O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,
  O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,
  O_IS_ALPHANUM,O_IS_ALPHANUM,
  	(unsigned short)(O_IS_ADELIM | O_YAKU_BURASA | O_IS_SDELIM),
  	(unsigned short)(O_IS_ADELIM | O_YAKU_BURASA | O_IS_SDELIM),
	O_IS_DELIM,O_IS_DELIM,
	(unsigned short)(O_IS_DELIM),
  	(unsigned short)(O_IS_ADELIM | O_YAKU_BURASA | O_IS_SDELIM),

  O_IS_DELIM,O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,
  O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,
  O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,
  O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,

  O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,
  O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,
  O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,
  	(unsigned short)(O_IS_DELIM | O_YAKU_OIDASH),
  O_IS_DELIM,O_YAKU_BURASA,O_IS_DELIM,O_IS_ALPHANUM,

  O_IS_DELIM,O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,
  O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,
  O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,
  O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,

  O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,
  O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,
  O_IS_ALPHANUM,O_IS_ALPHANUM,O_IS_ALPHANUM,
  	(unsigned short)(O_IS_DELIM | O_YAKU_OIDASH),
  O_IS_DELIM,O_YAKU_BURASA,
  	(unsigned short)(O_IS_DELIM | O_YAKU_OIDASH),0x0000
};
#endif

/* JIS X-0201 left side			*/
unsigned short o_x201_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x005b,0x2140,0x005d,0x005e,0x005f,
  0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x2141,0x007f
};

unsigned short o_gb_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x0023,0x00a5,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f,
  0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x007f
};

/* KS X-1003 */
unsigned short o_kr_uni_byte[128] = {
  0x0000,0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
  0x0008,0x0009,0x000a,0x000b,0x000c,0x000d,0x000e,0x000f,
  0x0010,0x0011,0x0012,0x0013,0x0014,0x0015,0x0016,0x0017,
  0x0018,0x0019,0x001a,0x001b,0x001c,0x001d,0x001e,0x001f,
  0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x005b,0x20a9,0x005d,0x005e,0x005f,
  0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x203e,0x007f
};

/* --------------------------------------------------------------- */
/* Unic*de 0300-036f, 0x591-0x5c7				   */
/* combining order table					   */
/* --------------------------------------------------------------- */
const int uni_f_s_10a[63] = {
        0,  0,  0, 255,  0,  0,255, 255,255,255,255,   0,220,  0,230,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 230,  1,220,255, 255,255,255,  9
};
const int uni_f_s_1d1[71] = {
                                 1,   1,  1,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,220, 220,220,220,220,
  220,220,220,255, 255,230,230,230, 230,230,220,220, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,255,255, 255,255,255,255,
  255,255,255,255, 255,255,255,255, 255,255,230,230, 230,230
};
/* --------------------------------------------------------------- */
/* Unic*de 2100-21ff						   */
/* --------------------------------------------------------------- */
const char *uni_f_s_21[128] = {
    "a/c", "a/s", "C", "Cel", NULL, "c/o", "c/u", NULL,
    NULL, "degF", NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, "l", NULL, "N", "No", NULL,
    NULL, "P", "Q", NULL, NULL, "R", NULL, NULL,

    "SM", "TEL", "TM", NULL, "Z", NULL, "Ohm", "Mho",
    NULL, NULL, NULL, "Ang", NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, "i", NULL, "FAX", NULL, NULL, NULL, NULL,

    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, "1/3", "2/3", "1/5", "2/5", "3/5",
    "4/5", "1/6", "5/6", "1/8", "3/8", "5/8", "7/8", "1/",

    "I","II","III","IV","V","VI","VII","VIII",
    "IX","X","XI","XII","L","C","D","M",
    "i","ii","iii","iv","v","vi","vii","viii",
    "ix","x","xi","xii","l","c","d","m"
};

/* moji-keisen conversion table                                    */
const unsigned short moji_kei[128] = {
 0xff0d,0xff0d,0xff5c,0xff5c, 0xff0d,0xff0d,0xff5c,0xff5c,
 0xff0d,0xff0d,0xff5c,0xff5c, 0xff0b,0xff0b,0xff0b,0xff0b,
 0xff0b,0xff0b,0xff0b,0xff0b, 0xff0b,0xff0b,0xff0b,0xff0b,
 0xff0b,0xff0b,0xff0b,0xff0b, 0xff0b,0xff0b,0xff0b,0xff0b,

 0xff0b,0xff0b,0xff0b,0xff0b, 0xff0b,0xff0b,0xff0b,0xff0b,
 0xff0b,0xff0b,0xff0b,0xff0b, 0xff0b,0xff0b,0xff0b,0xff0b,
 0xff0b,0xff0b,0xff0b,0xff0b, 0xff0b,0xff0b,0xff0b,0xff0b,
 0xff0b,0xff0b,0xff0b,0xff0b, 0xff0b,0xff0b,0xff0b,0xff0b,

 0xff0b,0xff0b,0xff0b,0xff0b, 0xff0b,0xff0b,0xff0b,0xff0b,
 0xff0b,0xff0b,0xff0b,0xff0b, 0xff0d,0xff0d,0xff5c,0xff5c,
 0xff0d,0xff5c,0xff0b,0xff0b, 0xff0b,0xff0b,0xff0b,0xff0b,
 0xff0b,0xff0b,0xff0b,0xff0b, 0xff0d,0xff0d,0xff5c,0xff5c,

 0xff0b,0xff0b,0xff0b,0xff0b, 0xff0b,0xff0b,0xff0b,0xff0b,
 0xff0b,0xff0b,0xff0b,0xff0b, 0xff0b,0xff0b,0xff0b,0xff0b,
 0xff0b,0xff0f,0xff3c,0xff38, 0xff0d,0xff5c,0xff0d,0xff5c,
 0xff0d,0xff5c,0xff0d,0xff5c, 0xff0d,0xff5c,0xff0d,0xff5c
};

unsigned short uni_f_chart[128] = {
0x2821,0x282c,0x2822,0x282d,0x2821,0x282c,0x2822,0x282d,
0x2821,0x282c,0x2822,0x282d,0x2823,0x282e,0x282e,0x282e,
0x2824,0x282f,0x282f,0x282f,0x2826,0x2831,0x2831,0x2831,
0x2825,0x2830,0x2830,0x2830,0x2827,0x283c,0x2837,0x2837,
0x2837,0x2832,0x2832,0x2832,0x2829,0x283e,0x2839,0x2839,
0x2839,0x2834,0x2834,0x2834,0x2828,0x2838,0x2838,0x2838,
0x283d,0x2833,0x2833,0x2833,0x282a,0x283a,0x283a,0x283a,
0x283f,0x2835,0x2835,0x2835,0x282b,0x283b,0x283b,0x283b,
0x2840,0x2840,0x2840,0x2836,0x2836,0x2836,0x2836,0x2836,
0x2836,0x2836,0x2836,0x2836,0x2821,0x282c,0x2822,0x282d,
0x2821,0x2822,0x2823,0x2823,0x2823,0x2824,0x2824,0x2824,
0x2826,0x2826,0x2826,0x2825,0x2825,0x2825,0x283c,0x2837,
0x2832,0x283e,0x2839,0x2834,0x2838,0x283d,0x2833,0x283a,
0x283f,0x2835,0x283b,0x2840,0x2836,0x0000,0x0000,0x0000,
0x0000,0x213f,0x2140,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

/* --------------------------------------------------------------- */
/* Unic*de 3000-33ff	(Unicode 4.0 based)			   */
/* --------------------------------------------------------------- */
unsigned short uni_f_kana[KANA_TABLE_LEN] = { 
    0x2121,0x2122,0x2123,0x2137, 0x2138,0x2139,0x213a,0x213b,
    0x2152,0x2153,0x2154,0x2155, 0x2156,0x2157,0x2158,0x2159,
    0x215a,0x215b,0x2229,0x222e, 0x214c,0x214d,0x215a,0x215b,
    0x214c,0x214d,0x2150,0x2151, 0x2141,0x2148,0x2149,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x2421,0x2422,0x2423, 0x2424,0x2425,0x2426,0x2427,
    0x2428,0x2429,0x242a,0x242b, 0x242c,0x242d,0x242e,0x242f,
    0x2430,0x2431,0x2432,0x2433, 0x2434,0x2435,0x2436,0x2437,
    0x2438,0x2439,0x243a,0x243b, 0x243c,0x243d,0x243e,0x243f,
    0x2440,0x2441,0x2442,0x2443, 0x2444,0x2445,0x2446,0x2447,
    0x2448,0x2449,0x244a,0x244b, 0x244c,0x244d,0x244e,0x244f,
    0x2450,0x2451,0x2452,0x2453, 0x2454,0x2455,0x2456,0x2457,
    0x2458,0x2459,0x245a,0x245b, 0x245c,0x245d,0x245e,0x245f,
    0x2460,0x2461,0x2462,0x2463, 0x2464,0x2465,0x2466,0x2467,
    0x2468,0x2469,0x246a,0x246b, 0x246c,0x246d,0x246e,0x246f,
    0x2470,0x2471,0x2472,0x2473, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x212b,0x212c,0x212b, 0x212c,0x2135,0x2136,0x0000,
    0x0000,0x2521,0x2522,0x2523, 0x2524,0x2525,0x2526,0x2527,
    0x2528,0x2529,0x252a,0x252b, 0x252c,0x252d,0x252e,0x252f,
    0x2530,0x2531,0x2532,0x2533, 0x2534,0x2535,0x2536,0x2537,
    0x2538,0x2539,0x253a,0x253b, 0x253c,0x253d,0x253e,0x253f,
    0x2540,0x2541,0x2542,0x2543, 0x2544,0x2545,0x2546,0x2547,
    0x2548,0x2549,0x254a,0x254b, 0x254c,0x254d,0x254e,0x254f,
    0x2550,0x2551,0x2552,0x2553, 0x2554,0x2555,0x2556,0x2557,
    0x2558,0x2559,0x255a,0x255b, 0x255c,0x255d,0x255e,0x255f,
    0x2560,0x2561,0x2562,0x2563, 0x2564,0x2565,0x2566,0x2567,
    0x2568,0x2569,0x256a,0x256b, 0x256c,0x256d,0x256e,0x256f,
    0x2570,0x2571,0x2572,0x2573, 0x2574,0x2575,0x2576,0x0000,
    0x0000,0x0000,0x0000,0x2126, 0x213c,0x2133,0x2134,0x0000,

    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,

    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,

    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,

    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000
};

/* --------------------------------------------------------------- */
/* Unic*de f900-ffff	(Unicode 4.0 based)			   */
/* --------------------------------------------------------------- */

unsigned short uni_f_compat[CPT_TABLE_LEN] = {
    0x6c31,0x3939,0x3c56,0x6c4b, 0x336a,0x367a,0x3667,0x737d,
    0x737d,0x3740,0x3662,0x5349, 0x4660,0x5871,0x617a,0x4d65,
    0x6947,0x4d66,0x4d67,0x6e36, 0x5c5b,0x4d6c,0x5f60,0x6064,
    0x4d6e,0x4d6f,0x7151,0x502c, 0x4d71,0x4d73,0x6025,0x4d76,
    0x7342,0x4d72,0x4d74,0x4d75, 0x6b22,0x5947,0x6744,0xdb78,
    0x4f2d,0x4f2f,0x4f32,0x4f35, 0x4f3a,0x5054,0x4e64,0x5229,
    0xc121,0x4f26,0x6024,0x623a, 0x4f37,0x6943,0x4e3a,0x4f29,
    0x4f2a,0x4f25,0x3a6d,0x6271, 0x6333,0x4e50,0xd838,0x4f3f,

    0x3c2f,0x4f40,0x5462,0x4f2e, 0x6446,0x4f38,0x4f34,0x627d,
    0x4f28,0x4d6b,0x545e,0xba7a, 0x5c6c,0x4e5e,0x4f33,0x4e5f,
    0x655f,0x6f7b,0x7055,0x4f3e, 0x7425,0x4e3f,0x4e47,0x303d,
    0x4929,0x4e4d,0x6c26,0x593c, 0x5c5b,0x427a,0x4330,0x472b,
    0x455c,0x4e28,0x305b,0x4b4c, 0xd03a,0x4a58,0x497c,0x4954,
    0x4867,0x5a4b,0x3a77,0x5254, 0x3a49,0x3e4a,0x4d55,0x4062,
    0x3b26,0x4324,0x4440,0x3d26, 0x3c63,0x4e2b,0x4e2c,0x4e3c,
    0x5140,0x515a,0x4e42,0x4e48, 0x4e49,0x4e4a,0x4e4c,0x522f,

    0x4f24,0x3d77,0x572a,0x4e39, 0x5f4e,0x626a,0x6f63,0x716b,
    0x4e6f,0x7355,0x4e4f,0x4e71, 0x4e72,0x6d60,0x472f,0x4e79,
    0x5878,0x4732,0x4e7a,0x4e7b, 0xcc50,0xd078,0x4f23,0x4e7e,
    0x6d53,0x4f21,0x4f22,0x4f23, 0x4e73,0x4e74,0x3076,0x4e75,
    0x4e76,0x4062,0x4e77,0x4730, 0x4731,0xc62e,0x4e7c,0x605a,
    0x4e61,0x537a,0x472b,0x4e66, 0x4e67,0x4e68,0x6072,0x6639,
    0x6659,0x4e6b,0x4e6d,0x704d, 0x4e4e,0x4e63,0x6339,0x6e54,
    0x7031,0x5828,0x4e3b,0x4e3d, 0x4e40,0x4722,0x4e41,0x5c5b,

    0x5f79,0x4e45,0x687a,0x4e4b, 0x4e36,0x5a74,0x6f76,0x4e2d,
    0xc326,0x4c78,0x4e2e,0x4e2f, 0x4e30,0x4e31,0x4e32,0x4933,
    0x4e60,0x4f3b,0x5924,0x4e26, 0x4e51,0x5646,0x5e4d,0x4e58,
    0x4e28,0x584b,0x372a,0x4e28, 0x4e34,0x4d78,0x4d79,0x4d7a,
    0x3057,0x4d7b,0x4d7c,0x4525, 0x4d7d,0x4e21,0x586d,0x4e22,
    0x4e23,0x4e24,0x4e25,0x463f, 0x452e,0x5267,0x4e55,0xcc55,
    0x6942,0x4e59,0x4e5a,0x4e5b, 0x4e53,0x4e54,0x4e57,0x4e29,
    0x335e,0x4e33,0x3e75,0x5f55, 0x3c31,0x3d3a,0x4363,0x3b49,
    /* FA00- */
    0x405a,0x4559,0x4273,0x457c, 0x4270,0x4636,0x4b3d,0x6d55,
    0x3954,0x395f,0x382b,0x3347, 0x513a,0x5d57,0x0000,0x0000,
    0x444d,0x3a6a,0x4032,0x0000, 0x5d30,0xb328,0x4376,0x0000,
    0x4e69,0x3f40,0x3e4d,0x4a21, 0x4c77,0x403a,0x3129,0x6745,
    0x0000,0x0000,0x3d74,0x6c62, 0x4a56,0x306f,0x4554,0x0000,
    0x0000,0xe668,0x4853,0x3b74, 0x345b,0x4461,0x0000,0x0000,
    0x496e,0x414e,0x4c48,0x4a59, 0x3650,0x485c,0x3365,0x4332,
    0x346f,0x4a3d,0x0000,0x4158, 0x5625,0x3279,0x3334,0x417e,

    0x4428,0x4952,0x347b,0x3d6b, 0x475f,0x3324,0x3d6d,0x3441,
    0x3c51,0xca48,0x4276,0x486a, 0x3c52,0x3527,0x3b63,0x4d34,
    0x4144,0x3d4b,0x3252,0x4477, 0x3972,0x464d,0x4061,0x4e7d,
    0x6556,0x484b,0x3d70,0x3c54, 0x3d2d,0x0000,0x0000,0x4378,
    0x336c,0x3b6b,0x315a,0x3660, 0x4950,0x4223,0xe134,0x306f,
    0x4671,0x3641,0x4951,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,

    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    /* FB00- */
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,

    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    /* FC00- */
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,

    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    /* FD00- */
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,

    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    /* FE00- */
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,

    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
    /* FF00- */
    0x0000,0x212a,0x212b,0x2174,0x2170,0x2173,0x2175,0x212d,
    0x214a,0x214b,0x2176,0x215c,0x2124,0x215d,0x2125,0x213f,
    0x2330,0x2331,0x2332,0x2333,0x2334,0x2335,0x2336,0x2337,
    0x2338,0x2339,0x2127,0x2128,0x2163,0x2161,0x2164,0x2129,
    0x2177,0x2341,0x2342,0x2343,0x2344,0x2345,0x2346,0x2347,
    0x2348,0x2349,0x234a,0x234b,0x234c,0x234d,0x234e,0x234f,
    0x2350,0x2351,0x2352,0x2353,0x2354,0x2355,0x2356,0x2357,
    0x2358,0x2359,0x235a,0x214e,0x2140,0x214f,0x2130,0x2132,

    0x212e,0x2361,0x2362,0x2363,0x2364,0x2365,0x2366,0x2367,
    0x2368,0x2369,0x236a,0x236b,0x236c,0x236d,0x236e,0x236f,
    0x2370,0x2371,0x2372,0x2373,0x2374,0x2375,0x2376,0x2377,
    0x2378,0x2379,0x237a,0x2150,0x2143,0x2151,0x2141,0x0000,
    0x0000,0x00a1,0x00a2,0x00a3,0x00a4,0x00a5,0x00a6,0x00a7,
    0x00a8,0x00a9,0x00aa,0x00ab,0x00ac,0x00ad,0x00ae,0x00af,
    0x00b0,0x00b1,0x00b2,0x00b3,0x00b4,0x00b5,0x00b6,0x00b7,
    0x00b8,0x00b9,0x00ba,0x00bb,0x00bc,0x00bd,0x00be,0x00bf,

    0x00c0,0x00c1,0x00c2,0x00c3,0x00c4,0x00c5,0x00c6,0x00c7,
    0x00c8,0x00c9,0x00ca,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf,
    0x00d0,0x00d1,0x00d2,0x00d3,0x00d4,0x00d5,0x00d6,0x00d7,
    0x00d8,0x00d9,0x00da,0x00db,0x00dc,0x00dd,0x00de,0x00df,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x2171,0x2172,0x224c,0x2131,0x0000,0x216f,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
    0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

/* --- enclosed CJK letters and ideograph conversion table ------- */
const unsigned short uni_k_enl[36] = {
    0x4e00,0x4e8c,0x4e09,0x56db, 0x4e94,0x516d,0x4e03,0x516b,
    0x4e5d,0x5341,0x6708,0x706b, 0x6c34,0x6728,0x91d1,0x571f,
    0x65e5,0x682a,0x6709,0x793e, 0x540d,0x7279,0x8ca1,0x795d,
    0x52b4,0x4ee3,0x547c,0x5b66, 0x76e3,0x4f01,0x8cc7,0x5354,
    0x796d,0x4f11,0x81ea,0x81f3
};

const unsigned short uni_k_cil[24] = {
    0x79d8,0x7537,0x5973,0x9069, 0x512a,0x5370,0x6ce8,0x9805,
    0x4f11,0x5199,0x6b63,0x4e0a, 0x4e2d,0x4e0b,0x5de6,0x53f3,
    0x533b,0x5b97,0x5b66,0x76e3, 0x4f01,0x8cc7,0x5354,0x591c
};

const unsigned short uni_ibm_nec_excg[16] = {
    0x0000,0x0000,0xfa40,0xfa41, 0xfa42,0xfa43,0xfa44,0xfa45,
    0xfa46,0xfa47,0xfa48,0xfa49, 0xfa54,0xfa55,0xfa56,0xfa57
};
/* --------------------------------------------------------------- */
/* --- keis/jef output ------------------------------------------- */
/* special character never comes here. Same as EUC --------------- */

/* tables */
unsigned short KEISOUT1[128] = {	/* control field	   */
    0x00,0x01,0x02,0x03,0x37,0x2d,0x2e,0x2f,
    0x16,0x05,0x15,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x10,0x11,0x00,0x12,0x3c,0x3d,0x32,0x26,
    0x18,0x19,0x3f,0x27,0x22,0x1d,0x35,0x1f,
    0x40,0x4f,0x7f,0x7b,0x5b,0x6c,0x50,0x7d,
    0x4d,0x5d,0x5c,0x4e,0x6b,0x60,0x4b,0x61,
    0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,
    0xf8,0xf9,0x7a,0x5e,0x4c,0x7e,0x6e,0x6f,
    0x7c,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,
    0xc8,0xc9,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,
    0xd7,0xd8,0xd9,0xe2,0xe3,0xe4,0xe5,0xe6,
    0xe7,0xe8,0xe9,0x4a,0xe0,0x5a,0x5f,0x6d,
    0x79,0x59,0x62,0x63,0x64,0x65,0x66,0x67,
    0x68,0x69,0x70,0x71,0x72,0x73,0x74,0x75,
    0x76,0x77,0x78,0x80,0x8b,0x9b,0x9c,0xa0,
    0xab,0xb0,0xb1,0xc0,0x6a,0xd0,0xa1,0x07
};

const unsigned char KEISOUT3[63] = {
         0x41,0x42,0x42,0x44,0x45,0x46,0x47,0x48,0x49,0x51,0x52,
    0x53,0x54,0x55,0x56,0x57,0x81,0x82,0x83,0x84,0x85,0x86,0x87,
    0x88,0x89,0x8a,0x8c,0x8d,0x8e,0x8f,0x90,0x91,0x92,0x93,0x94,
    0x95,0x96,0x97,0x98,0x99,0x9a,0x9d,0x9e,0x9f,0xa2,0xa3,0xa4,
    0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xac,0xad,0xae,0xaf,0xba,0xbb,
    0xbc,0xbd,0xbe,0xbf
};

const unsigned short uni_f_math_jef[160] = {
0x7fdc,0x0000,0x7fe1,0x7fdd,0x0000,0x0000,0x0000,0x7fe2,
0x7fd0,0x0000,0x0000,0x7fd1,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x7fe5,0x0000,0x0000,0x7fe7,0x0000,0x0000,

0x7fde,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7fd8,
0x7fd9,0x7fd7,0x7fd6,0x7fe8,0x7fe9,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x7fe6,0x0000,0x0000,

0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x7fe3,0x7fe4,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

0x0000,0x0000,0x7fd4,0x7fd5,0x0000,0x0000,0x7fd2,0x7fd3,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x7fdf,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

/* --------------------------------------------------------------- */
const unsigned char EBCDICOUT[128] = { /* generic IBM-EBCDIC		   */
    0x00,0x01,0x02,0x03,0x37,0x2d,0x2e,0x2f,
    0x16,0x05,0x15,0x0b,0x0c,0x0d,0x0e,0x0f,
    0x10,0x11,0x00,0x12,0x3c,0x3d,0x32,0x26,
    0x18,0x19,0x3f,0x27,0x22,0x1d,0x35,0x1f,
    0x40,0x5a,0x7f,0x7b,0xe0,0x6c,0x50,0x7d,
    0x4d,0x5d,0x5c,0x4e,0x6b,0x60,0x4b,0x61,
    0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,
    0xf8,0xf9,0x7a,0x5e,0x4c,0x7e,0x6e,0x6f,
    0x7c,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,
    0xc8,0xc9,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,
    0xd7,0xd8,0xd9,0xe2,0xe3,0xe4,0xe5,0xe6,
    0xe7,0xe8,0xe9,0xba,0xb2,0xbb,0xb0,0x6d,
    0x79,0x81,0x82,0x83,0x84,0x85,0x86,0x87,
    0x88,0x89,0x91,0x92,0x93,0x94,0x95,0x96,
    0x97,0x98,0x99,0xa2,0xa3,0xa4,0xa5,0xa6,
    0xa7,0xa8,0xa9,0xc0,0x4f,0xd0,0xa1,0x07
};

/* --------------------------------------------------------------- */
#if UNICODE_1
/* Used only in Unic*de 1.0 */
/* bracketed kana ligatures... iroha-ordered			   */
/* the person who chose that order should be brain-damaged	   */
const unsigned short uni_k_iroha[47] = {
	0x24,0x6d,0x4f,0x4b,0x5b,0x58,0x48,0x41,0x6a,0x4c,0x6b,0x72,
	0x6f,0x2b,0x68,0x3f,0x6c,0x3d,0x44,0x4d,0x4a,0x69,0x60,0x26,
	0x70,0x4e,0x2a,0x2f,0x64,0x5e,0x31,0x55,0x33,0x28,0x46,0x22,
	0x35,0x2d,0x66,0x61,0x5f,0x37,0x28,0x52,0x62,0x3b,0x39
};

#endif

/* -------------------------------------------------------------- */
/* windows filename limitation hooker				  */
/* -------------------------------------------------------------- */
const char	charname_conv[63] = {
  '@','A','B','C','D','E','F','G', 'H','I','J','K','L','M','N','O',
  'P','Q','R','S','T','U','V','W', 'X','Y','Z','0','1','2','3','4',
  '5','a','b','c','d','e','f','g', 'h','i','j','k','l','m','n','o',
  'p','q','r','s','t','u','v','w', 'x','y','z','6','7','8','9'
};

const char	charname_priv_conv[16] = {
  '0','1','2','3','4','5','6','7', '8','9','@','A','B','C','D','%'
};

#if	!defined(OUTPUT_DYNAMIC_TABLE)
/* --------------------------------------------------------------- */
/* output codeset define tables 				   */
/* --------------------------------------------------------------- */
/* Note: referring table is for codeset feature referenece. 	   */
/* --------------------------------------------------------------- */
#define OI_ASCI_ASCII	0
#define OI_ASCI_X201	1
#define OI_ASCI_GB1988	2
#define OI_ASCI_VISCII	3
#define OI_ASCI_KSX1003	4
#define OI_ASCI_IBM930	5
#define OI_ASCI_IBM931	6
#define OI_ASCI_IBM933	7
#define OI_ASCI_IBM935	8
#define OI_ASCI_IBM937	9
#define OI_ASCI_KEIS	10

struct out_codetbl_defs o_iso_ascii_defs[] = {
  {'B',128,o_ascii_uni_byte},
  {'J',128,o_x201_uni_byte},
  {'T',128,o_gb_uni_byte},
  {0x76,128,o_ascii_uni_byte},
  {0x56,128,o_kr_uni_byte},
  {0x4a,128,ot_ibm930S},
  {0x4d,128,ot_ibm931S},
  {0x46,128,ot_ibm933S},
  {0x45,128,ot_ibm935S},
  {0x44,128,ot_ibm937S},
  {0x21,128,KEISOUT1},
  {0,0,NULL}
};

#define OI_LATN_ISO8859_1 	0
#define OI_LATN_ISO8859_15 	1
#define OI_LATN_X208 		2
#define OI_LATN_KSX		3
#define OI_LATN_KOI8		4
#define OI_LATN_CP1251		5
#define OI_LATN_GB		6
#define OI_LATN_BIG5		7
#define OI_LATN_X213		8
#define OI_LATN_X213C		9
#define OI_LATN_OX208		10
#define OI_LATN_GB12345		11
#define OI_LATN_JOHAB		12
#define OI_LATN_CNS11643	13
#define OI_LATN_BIG5H		14
#define OI_LATN_BIG5MS		15
#define OI_LATN_ISOCNC		16
#define OI_LATN_ISOCNG		17
#define OI_LATN_CP932		18
#define OI_LATN_CP943		19
#define OI_LATN_VISCII		20
#define OI_LATN_GBK		21
#define OI_LATN_ISO8859_2 	22
#define OI_LATN_ISO8859_3 	23
#define OI_LATN_ISO8859_4 	24
#define OI_LATN_ISO8859_5 	25
#define OI_LATN_ISO8859_6 	26
#define OI_LATN_ISO8859_7 	27
#define OI_LATN_ISO8859_8 	28
#define OI_LATN_ISO8859_9 	29
#define OI_LATN_ISO8859_10 	30
#define OI_LATN_ISO8859_11 	31
#define OI_LATN_ISO8859_13 	32
#define OI_LATN_ISO8859_14 	33
#define OI_LATN_ISO8859_16 	34
#define OI_LATN_BIG5P		35
#define OI_LATN_GB2K		36
#define OI_LATN_IBM930		37
#define OI_LATN_IBM933		38
#define OI_LATN_IBM935		39
#define OI_LATN_IBM937		40
#define OI_LATN_BIG52003	41
#define OI_LATN_BIG5UAO		42
#define OI_LATN_CP932W		43
#define OI_LATN_UHC		44
#define OI_LATN_IBM931		45
#define OI_LATN_CELN		46
#define OI_LATN_CELA		47
#define OI_LATN_CELS		48
#define OI_LATN_NYUKAN		49
#define OI_LATN_KOI8U		50

struct out_codetbl_defs o_iso_latin_defs[] = {
  {'A',LATIN_TABLE_LEN,ot_iso8859_1L},
  {'b',LATIN_TABLE_LEN,ot_iso8859_15L},
  {'B',LATIN_TABLE_LEN,uni_f_latin},
  {'C',LATIN_TABLE_LEN,ot_ksx1001L},
  {0x51,LATIN_TABLE_LEN,ot_koi_8L},
  {0x55,LATIN_TABLE_LEN,ot_cp1251L},
  {'A',LATIN_TABLE_LEN,ot_gb2312L},
  {0x42,LATIN_TABLE_LEN,ot_big5_etenL},
  {'O',LATIN_TABLE_LEN,ot_iso2022_jp_2000L},
  {'P',LATIN_TABLE_LEN,ot_iso2022_jp_2000cL},
  {'@',LATIN_TABLE_LEN,ot_oldjisL},
  {'H',LATIN_TABLE_LEN,ot_gb12345L},
  {'O',LATIN_TABLE_LEN,ot_ks_johabL},
  {'G',LATIN_TABLE_LEN,ot_cns11643L},
  {0x47,LATIN_TABLE_LEN,ot_big5_hkuL},
  {CP950CH,LATIN_TABLE_LEN,ot_big5_cp950L},
  {'J',LATIN_TABLE_LEN,ot_iso2022_cncL},
  {'I',LATIN_TABLE_LEN,ot_iso2022_cngL},
  {'b',LATIN_TABLE_LEN,ot_cp932L},
  {'i',LATIN_TABLE_LEN,ot_cp943L},
  {0x76,LATIN_TABLE_LEN,ot_visciiL},
  {0x4e,LATIN_TABLE_LEN,ot_gbkL},
  {'B',LATIN_TABLE_LEN,ot_iso8859_2L},
  {'C',LATIN_TABLE_LEN,ot_iso8859_3L},
  {'D',LATIN_TABLE_LEN,ot_iso8859_4L},
  {'L',LATIN_TABLE_LEN,ot_iso8859_5L},
  {'G',LATIN_TABLE_LEN,ot_iso8859_6L},
  {'F',LATIN_TABLE_LEN,ot_iso8859_7L},
  {'H',LATIN_TABLE_LEN,ot_iso8859_8L},
  {'M',LATIN_TABLE_LEN,ot_iso8859_9L},
  {'V',LATIN_TABLE_LEN,ot_iso8859_10L},
  {'T',LATIN_TABLE_LEN,ot_iso8859_11L},
  {'Y',LATIN_TABLE_LEN,ot_iso8859_13L},
  {'_',LATIN_TABLE_LEN,ot_iso8859_14L},
  {'f',LATIN_TABLE_LEN,ot_iso8859_16L},
  {0x4b,LATIN_TABLE_LEN,ot_big5_plusL},
  {0x4c,LATIN_TABLE_LEN,ot_gb2kL},
  {0x4a,LATIN_TABLE_LEN,ot_ibm930L},
  {0x46,LATIN_TABLE_LEN,ot_ibm933L},
  {0x45,LATIN_TABLE_LEN,ot_ibm935L},
  {0x44,LATIN_TABLE_LEN,ot_ibm937L},
  {0x50,LATIN_TABLE_LEN,ot_big5_2003L},
  {0x51,LATIN_TABLE_LEN,ot_big5_uaoL},
  {'j',LATIN_TABLE_LEN,ot_cp932wL},
  {0x67,LATIN_TABLE_LEN,ot_cp949L},
  {0x4d,LATIN_TABLE_LEN,ot_ibm931L},
  {0x6a,LATIN_TABLE_LEN,ot_sjis_docomo_phoneL},
  {0x6b,LATIN_TABLE_LEN,ot_sjis_au_phoneL},
  {0x6c,LATIN_TABLE_LEN,ot_sjis_sbnk_phoneL},
  {0x6d,LATIN_TABLE_LEN,ot_iso2022_houmu_582L},
  {0x6e,LATIN_TABLE_LEN,ot_koi_8_uL},
  {0,0,NULL}
};

#define OI_SYMBL_X208		0
#define OI_SYMBL_X213		1
#define OI_SYMBL_X213C		2
#define OI_SYMBL_KSX		3
#define OI_SYMBL_GB		4
#define OI_SYMBL_BIG5		5
#define OI_SYMBL_OX208		6
#define OI_SYMBL_GB12345	7
#define OI_SYMBL_JOHAB		8
#define OI_SYMBL_CNS11643	9
#define OI_SYMBL_BIG5H		10
#define OI_SYMBL_BIG5MS		11
#define OI_SYMBL_KOI8		12
#define OI_SYMBL_ISOCNC		13
#define OI_SYMBL_ISOCNG		14
#define OI_SYMBL_CP932		15
#define OI_SYMBL_CP943		16
#define OI_SYMBL_VISCII		17
#define OI_SYMBL_CP1251		18
#define OI_SYMBL_GBK		19
#define OI_SYMBL_BIG5P		20
#define OI_SYMBL_GB2K		21
#define OI_SYMBL_IBM930		22
#define OI_SYMBL_IBM933		23
#define OI_SYMBL_IBM935		24
#define OI_SYMBL_IBM937		25
#define OI_SYMBL_BIG52003	26
#define OI_SYMBL_BIG5UAO	27
#define OI_SYMBL_UHC		28
#define OI_SYMBL_IBM931		29
#define OI_SYMBL_CELN		30
#define OI_SYMBL_CELA		31
#define OI_SYMBL_CELS		32
#define OI_SYMBL_NYUKAN		33
#define OI_SYMBL_KOI8U		34

struct out_codetbl_defs o_iso_symbol_defs[] = {
  {'B',GLYPH_TABLE_LEN,uni_f_symbol},
  {'O',GLYPH_TABLE_LEN,ot_iso2022_jp_2000G},
  {'P',GLYPH_TABLE_LEN,ot_iso2022_jp_2000cG},
  {'C',GLYPH_TABLE_LEN,ot_ksx1001G},
  {'A',GLYPH_TABLE_LEN,ot_gb2312G},
  {0x42,GLYPH_TABLE_LEN,ot_big5_etenG},
  {'@',GLYPH_TABLE_LEN,ot_oldjisG},
  {0x48,GLYPH_TABLE_LEN,ot_gb12345G},
  {0x4f,GLYPH_TABLE_LEN,ot_ks_johabG},
  {'G',GLYPH_TABLE_LEN,ot_cns11643G},
  {0x47,GLYPH_TABLE_LEN,ot_big5_hkuG},
  {CP950CH,GLYPH_TABLE_LEN,ot_big5_cp950G},
  {0x51,GLYPH_TABLE_LEN,ot_koi_8G},
  {'J',GLYPH_TABLE_LEN,ot_iso2022_cncG},
  {'I',GLYPH_TABLE_LEN,ot_iso2022_cngG},
  {'b',GLYPH_TABLE_LEN,ot_cp932G},
  {'i',GLYPH_TABLE_LEN,ot_cp943G},
  {0x76,GLYPH_TABLE_LEN,ot_visciiG},
  {0x55,GLYPH_TABLE_LEN,ot_cp1251G},
  {0x4e,GLYPH_TABLE_LEN,ot_gbkG},
  {0x4b,GLYPH_TABLE_LEN,ot_big5_plusG},
  {0x4c,GLYPH_TABLE_LEN,ot_gb2kG},
  {0x4a,GLYPH_TABLE_LEN,ot_ibm930G},
  {0x46,GLYPH_TABLE_LEN,ot_ibm933G},
  {0x45,GLYPH_TABLE_LEN,ot_ibm935G},
  {0x44,GLYPH_TABLE_LEN,ot_ibm937G},
  {0x50,GLYPH_TABLE_LEN,ot_big5_2003G},
  {0x51,GLYPH_TABLE_LEN,ot_big5_uaoG},
  {0x67,GLYPH_TABLE_LEN,ot_cp949G},
  {0x4d,GLYPH_TABLE_LEN,ot_ibm931G},
  {0x6a,GLYPH_TABLE_LEN,ot_sjis_docomo_phoneG},
  {0x6b,GLYPH_TABLE_LEN,ot_sjis_au_phoneG},
  {0x6c,GLYPH_TABLE_LEN,ot_sjis_sbnk_phoneG},
  {0x6d,GLYPH_TABLE_LEN,ot_sjis_sbnk_phoneG},
  {0x6d,GLYPH_TABLE_LEN,ot_iso2022_houmu_582G},
  {0x6e,GLYPH_TABLE_LEN,ot_koi_8_uG},
  {0,0,NULL}
};

#define OI_KANA_X208		0
#define OI_KANA_KSX		1
#define OI_KANA_GB		2
#define OI_KANA_BIG5		3
#define OI_KANA_X213		4
#define OI_KANA_X213C		5
#define OI_KANA_OX208		6
#define OI_KANA_GB12345		7
#define OI_KANA_JOHAB		8
#define OI_KANA_CNS11643	9
#define OI_KANA_BIG5H		10
#define OI_KANA_BIG5MS		11
#define OI_KANA_ISOCNC		12
#define OI_KANA_ISOCNG		13
#define OI_KANA_CP932		14
#define OI_KANA_CP943		15
#define OI_KANA_GBK		16
#define OI_KANA_BIG5P		17
#define OI_KANA_GB2K		18
#define OI_KANA_IBM930		19
#define OI_KANA_IBM933		20
#define OI_KANA_IBM935		21
#define OI_KANA_IBM937		22
#define OI_KANA_BIG52003	23
#define OI_KANA_BIG5UAO		24
#define OI_KANA_UHC		25
#define OI_KANA_CELN		26
#define OI_KANA_CELA		27
#define OI_KANA_CELS		28
#define OI_KANA_NYUKAN		29

struct out_codetbl_defs o_iso_kana_defs[] = {
  {'B',KANA_TABLE_LEN,uni_f_kana},
  {'C',KANA_TABLE_LEN,ot_ksx1001N},
  {'A',KANA_TABLE_LEN,ot_gb2312N},
  {0x42,KANA_TABLE_LEN,ot_big5_etenN},
  {'O',KANA_TABLE_LEN,ot_iso2022_jp_2000N},
  {'P',KANA_TABLE_LEN,ot_iso2022_jp_2000cN},
  {'@',KANA_TABLE_LEN,ot_oldjisN},
  {0x48,KANA_TABLE_LEN,ot_gb12345N},
  {0x4f,KANA_TABLE_LEN,ot_ks_johabN},
  {'G',KANA_TABLE_LEN,ot_cns11643N},
  {0x47,KANA_TABLE_LEN,ot_big5_hkuN},
  {CP950CH,KANA_TABLE_LEN,ot_big5_cp950N},
  {'J',KANA_TABLE_LEN,ot_iso2022_cncN},
  {'I',KANA_TABLE_LEN,ot_iso2022_cngN},
  {'b',KANA_TABLE_LEN,ot_cp932N},
  {'i',KANA_TABLE_LEN,ot_cp943N},
  {0x4e,KANA_TABLE_LEN,ot_gbkN},
  {0x4b,KANA_TABLE_LEN,ot_big5_plusN},
  {0x4c,KANA_TABLE_LEN,ot_gb2kN},
  {0x4a,KANA_TABLE_LEN,ot_ibm930N},
  {0x46,KANA_TABLE_LEN,ot_ibm933N},
  {0x45,KANA_TABLE_LEN,ot_ibm935N},
  {0x44,KANA_TABLE_LEN,ot_ibm937N},
  {0x50,KANA_TABLE_LEN,ot_big5_2003N},
  {0x51,KANA_TABLE_LEN,ot_big5_uaoN},
  {0x67,KANA_TABLE_LEN,ot_cp949N},
  {0x6a,KANA_TABLE_LEN,ot_sjis_docomo_phoneN},
  {0x6b,KANA_TABLE_LEN,ot_sjis_au_phoneN},
  {0x6c,KANA_TABLE_LEN,ot_sjis_sbnk_phoneN},
  {0x6d,KANA_TABLE_LEN,ot_iso2022_houmu_582N},
  {0,0,NULL}
};

#define OI_CJK_A_X213C		0
#define OI_CJK_A_X213		1
#define OI_CJK_A_BIG5		2
#define OI_CJK_A_CNS11643	3
#define OI_CJK_A_ISOCNC		4
#define OI_CJK_A_ISOCNG		5
#define OI_CJK_A_GBK		6
#define OI_CJK_A_BIG5P		7
#define OI_CJK_A_GB2K		8
#define OI_CJK_A_BIG5UAO	9
#define OI_CJK_A_NYUKAN		10

struct out_codetbl_defs o_iso_cjk_a_defs[] = {
  {'P',CJK_A_TABLE_LEN,ot_iso2022_jp_2000cA},
  {'O',CJK_A_TABLE_LEN,ot_iso2022_jp_2000A},
  {0x42,CJK_A_TABLE_LEN,NULL},
  {'G',CJK_A_TABLE_LEN,ot_cns11643A},
  {'J',CJK_A_TABLE_LEN,ot_iso2022_cncA},
  {'I',CJK_A_TABLE_LEN,ot_iso2022_cngA},
  {0x4e,CJK_A_TABLE_LEN,ot_gbkA},
  {0x4b,CJK_A_TABLE_LEN,ot_big5_plusA},
  {0x4c,CJK_A_TABLE_LEN,ot_gb2kA},
  {0x51,CJK_A_TABLE_LEN,ot_big5_uaoA},
  {0x6d,CJK_A_TABLE_LEN,ot_iso2022_houmu_582A},
  {0,0,NULL}
};

#define OI_KANJI_X208		0
#define OI_KANJI_X213C		1
#define OI_KANJI_X213		2
#define OI_KANJI_KSX		3
#define OI_KANJI_GB		4
#define OI_KANJI_BIG5		5
#define OI_KANJI_OX208		6
#define OI_KANJI_BIG5H		7
#define OI_KANJI_GB12345	8
#define OI_KANJI_JOHAB		9
#define OI_KANJI_CNS11643	10
#define OI_KANJI_BIG5MS		11
#define OI_KANJI_ISOCNC		12
#define OI_KANJI_ISOCNG		13
#define OI_KANJI_CP932		14
#define OI_KANJI_CP943		15
#define OI_KANJI_X213N		16
#define OI_KANJI_GBK		17
#define OI_KANJI_BIG5P		18
#define OI_KANJI_GB2K		19
#define OI_KANJI_IBM930		20
#define OI_KANJI_IBM933		21
#define OI_KANJI_IBM935		22
#define OI_KANJI_IBM937		23
#define OI_KANJI_BIG52003	24
#define OI_KANJI_BIG5UAO	25
#define OI_KANJI_UHC		26
#define OI_KANJI_X208NJ		27
#define OI_KANJI_NYUKAN		28

struct out_codetbl_defs o_iso_cjk_defs[] = {
  {'B',CJK_TABLE_LEN,uni_f_4e},
  {'P',CJK_TABLE_LEN,ot_iso2022_jp_2000cK},
  {'O',CJK_TABLE_LEN,ot_iso2022_jp_2000K},
  {'C',CJK_TABLE_LEN,ot_ksx1001K},
  {'A',CJK_TABLE_LEN,ot_gb2312K},
  {0x42,CJK_TABLE_LEN,ot_big5_etenK},
  {'@',CJK_TABLE_LEN,ot_oldjisK},
  {0x47,CJK_TABLE_LEN,ot_big5_hkuK},
  {0x48,CJK_TABLE_LEN,ot_gb12345K},
  {0x4f,CJK_TABLE_LEN,ot_ks_johabK},
  {'G',CJK_TABLE_LEN,ot_cns11643K},
  {CP950CH,CJK_TABLE_LEN,ot_big5_cp950K},
  {'J',CJK_TABLE_LEN,ot_iso2022_cncK},
  {'I',CJK_TABLE_LEN,ot_iso2022_cngK},
  {'b',CJK_TABLE_LEN,ot_cp932K},
  {'i',CJK_TABLE_LEN,ot_cp943K},
  {'Q',CJK_TABLE_LEN,ot_iso2022_jp_2004K},
  {0x4e,CJK_TABLE_LEN,ot_gbkK},
  {0x4b,CJK_TABLE_LEN,ot_big5_plusK},
  {0x4c,CJK_TABLE_LEN,ot_gb2kK},
  {0x4a,CJK_TABLE_LEN,ot_ibm930K},
  {0x46,CJK_TABLE_LEN,ot_ibm933K},
  {0x45,CJK_TABLE_LEN,ot_ibm935K},
  {0x44,CJK_TABLE_LEN,ot_ibm937K},
  {0x50,CJK_TABLE_LEN,ot_big5_2003K},
  {0x51,CJK_TABLE_LEN,ot_big5_uaoK},
  {0x67,CJK_TABLE_LEN,ot_cp949K},
  {0x63,CJK_TABLE_LEN,ot_iso2022_jpnjK},
  {0x6d,CJK_TABLE_LEN,ot_iso2022_houmu_582K},
  {0,0,NULL}
};

struct out_codetbl_defs o_iso_y_defs[] = {
  {0,0,NULL}
};

#define OI_HNGL_KSX	0
#define OI_HNGL_JOHAB	1
#define OI_HNGL_IBM933	2
#define OI_HNGL_UHC	3
struct out_codetbl_defs o_iso_hngl_defs[] = {
  {'C',HNGL_TABLE_LEN,ot_ksx1001H},
  {0x4f,HNGL_TABLE_LEN,ot_ks_johabH},
  {0x46,HNGL_TABLE_LEN,ot_ibm933H},
  {0x67,HNGL_TABLE_LEN,ot_cp949H},
  {0,0,NULL}
};

#define OI_CMP_X208	0
#define OI_CMP_X213C	1
#define OI_CMP_X213	2
#define OI_CMP_KSX	3
#define OI_CMP_GB	4
#define OI_CMP_BIG5	5
#define OI_CMP_OX208	6
#define OI_CMP_GB12345	7
#define OI_CMP_JOHAB	8
#define OI_CMP_CNS11643	9
#define OI_CMP_BIG5H	10
#define OI_CMP_BIG5MS	11
#define OI_CMP_ISOCNC	12
#define OI_CMP_ISOCNG	13
#define OI_CMP_CP932	14
#define OI_CMP_CP943	15
#define OI_CMP_GBK	16
#define OI_CMP_BIG5P	17
#define OI_CMP_GB2K	18
#define OI_CMP_IBM930	19
#define OI_CMP_IBM933	20
#define OI_CMP_IBM935	21
#define OI_CMP_IBM937	22
#define OI_CMP_BIG52003	23
#define OI_CMP_BIG5UAO	24
#define OI_CMP_UHC	25
#define OI_CMP_IBM931	26
#define OI_CMP_NYUKAN	27

struct out_codetbl_defs o_iso_compat_defs[] = {
  {'B',CPT_TABLE_LEN,uni_f_compat},
  {'P',CPT_TABLE_LEN,ot_iso2022_jp_2000cC},
  {'O',CPT_TABLE_LEN,ot_iso2022_jp_2000C},
  {'C',CPT_TABLE_LEN,ot_ksx1001C},
  {'A',CPT_TABLE_LEN,ot_gb2312C},
  {0x42,CPT_TABLE_LEN,ot_big5_etenC},
  {'@',CPT_TABLE_LEN,ot_oldjisC},
  {0x48,CPT_TABLE_LEN,ot_gb12345C},
  {0x4f,CPT_TABLE_LEN,ot_ks_johabC},
  {'G',CPT_TABLE_LEN,ot_cns11643C},
  {0x47,CPT_TABLE_LEN,ot_big5_hkuC},
  {CP950CH,CPT_TABLE_LEN,ot_big5_cp950C},
  {'J',CPT_TABLE_LEN,ot_iso2022_cncC},
  {'I',CPT_TABLE_LEN,ot_iso2022_cngC},
  {'b',CPT_TABLE_LEN,ot_cp932C},
  {'i',CPT_TABLE_LEN,ot_cp943C},
  {0x4e,CPT_TABLE_LEN,ot_gbkC},
  {0x4b,CPT_TABLE_LEN,ot_big5_plusC},
  {0x4c,CPT_TABLE_LEN,ot_gb2kC},
  {0x4a,CPT_TABLE_LEN,ot_ibm930C},
  {0x46,CPT_TABLE_LEN,ot_ibm933C},
  {0x45,CPT_TABLE_LEN,ot_ibm935C},
  {0x44,CPT_TABLE_LEN,ot_ibm937C},
  {0x50,CPT_TABLE_LEN,ot_big5_2003C},
  {0x51,CPT_TABLE_LEN,ot_big5_uaoC},
  {0x67,CPT_TABLE_LEN,ot_cp949C},
  {0x4d,CPT_TABLE_LEN,ot_ibm931C},
  {0x6d,CPT_TABLE_LEN,ot_iso2022_houmu_582C},
  {0,0,NULL}
};

#define OI_CJK_B_X213C		0
#define OI_CJK_B_X213		1
#define OI_CJK_B_CNS11643	2
#define OI_CJK_B_X213N		3
#define OI_CJK_B_BIG5P		4
#define OI_CJK_B_X208NJ		5
#define OI_CJK_B_NYUKAN		6

struct out_codetbl_defs o_iso_cjk_b_defs[] = {
  {'P',CJK_B_TABLE_LEN,ot_iso2022_jp_2000cB},
  {'O',CJK_B_TABLE_LEN,ot_iso2022_jp_2000B},
  {'G',CJK_B_TABLE_LEN,NULL},
  {'Q',CJK_B_TABLE_LEN,ot_iso2022_jp_2004B},
  {0x4b,CJK_B_TABLE_LEN,ot_big5_plusB},
  {0x63,CJK_B_TABLE_LEN,ot_iso2022_jpnjB},
  {0x6d,CJK_B_TABLE_LEN,ot_iso2022_houmu_582B},
  {0,0,NULL}
};

#define OI_CJK_C_X213C		0
#define OI_CJK_C_X213		1
#define OI_CJK_C_CNS11643	2
#define OI_CJK_C_BIG5P		3
#define OI_CJK_C_NYUKAN		4

struct out_codetbl_defs o_iso_cjk_c_defs[] = {
  {'P',CJK_C_TABLE_LEN,ot_iso2022_jp_2000cX},
  {'O',CJK_C_TABLE_LEN,ot_iso2022_jp_2000X},
  {'G',CJK_C_TABLE_LEN,NULL},
  {0x4b,CJK_C_TABLE_LEN,ot_big5_plusX},
  {0x6d,CJK_C_TABLE_LEN,ot_iso2022_houmu_582X},
  {0,0,NULL}
};

#define OI_PRV_X208	0
#define OI_PRV_BIG5P	1
#define OI_PRV_CEL	2
#define OI_PRV_CP932	3
#define OI_PRV_CP943	4
#define OI_PRV_GBK	5
#define OI_PRV_GB2K	6
#define OI_PRV_IBM930	7
#define OI_PRV_IBM933	8
#define OI_PRV_IBM935	9
#define OI_PRV_IBM937	10
#define OI_PRV_BIG52003	11
#define OI_PRV_BIG5UAO	12
#define OI_PRV_UHC	13
#define OI_PRV_NYUKAN	14

struct out_codetbl_defs o_iso_prv_defs[] = {
  {'B',PRV_TABLE_LEN,NULL},
  {0x4b,PRV_TABLE_LEN,ot_big5_plusP},
  {0x37,PRV_TABLE_LEN,ot_sjis_celP},
  {'b',PRV_TABLE_LEN,NULL},
  {'i',PRV_TABLE_LEN,NULL},
  {0x4e,PRV_TABLE_LEN,ot_gbkP},
  {0x4c,PRV_TABLE_LEN,ot_gb2kP},
  {0x4a,PRV_TABLE_LEN,ot_ibm930P},
  {0x46,PRV_TABLE_LEN,ot_ibm933P},
  {0x45,PRV_TABLE_LEN,ot_ibm935P},
  {0x44,PRV_TABLE_LEN,ot_ibm937P},
  {0x50,PRV_TABLE_LEN,ot_big5_2003P},
  {0x51,PRV_TABLE_LEN,ot_big5_uaoP},
  {0x67,PRV_TABLE_LEN,ot_cp949P},
  {0x6d,PRV_TABLE_LEN,ot_iso2022_houmu_582P},
  {0,0,NULL}
};

#define OI_NOT_CELN	0
#define OI_NOT_CELA	1
#define OI_NOT_CELS	2

struct out_codetbl_defs o_iso_note_defs[] = {
  {0x6a,NOTE_TABLE_LEN,ot_sjis_docomo_phoneO},
  {0x6b,NOTE_TABLE_LEN,ot_sjis_au_phoneO},
  {0x6c,NOTE_TABLE_LEN,ot_sjis_sbnk_phoneO},
  {0,0,NULL}
};

struct out_codetbl_defs o_iso_hist_defs[] = {
  {0,0,NULL}
};

struct out_codetbl_defs o_iso_upmisc_defs[] = {
  {0,0,NULL}
};

struct out_codetbl_defs o_iso_upkana_defs[] = {
  {0,0,NULL}
};

/* --- converter anchor ------------------------------------------ */
/* --------------------------------------------------------------- */
/* codeset patches						   */
/*  format: [Unic*de, target_code,] -1 				   */
/* --------------------------------------------------------------- */
const long o_patch_x201_208[] = {
  0x00a5,0x005c, 0x00af,0x007e, 0x005c,0x2140, 0x007e,0x2141,
  0
};

const long o_patch_cp932[] = {
  0x00a5,0x005c, 0x00a6,0x007c, 0x00af,0x2131,
  0
};

const long o_patch_cp51932[] = {
  0x00a5,0x005c, 0x00a6,0x007c, 0x00af,0x2131, 
  0x00a1,0, 0x00a4,0, 0x00b8,0, 0x00bf,0,
  0x00ad,0x002d, 0x00ae,0,
  0x00ff,0, 0x0114,0, 0x0115,0, 0x0123,0,
  0x012c,0, 0x012d,0, 0x0131,0, 0x01f5,0,
  0
};

const long o_patch_xkr_1003[] = {
  0x20a9,0x005c, 0x00af,0x007e, 0x005c,0x212c, 0x007e,0x212d,
  0
};

const long o_patch_gb_1988[] = {
  0x0024,0x2167, 0x00a5,0x0024, 0x00af,0x007e, 0x007e,0x212b,
  0
};

const long o_patch_jis90_to_83[] = {
  0x51dc,0x515b, 0x7199,0x5f66,
  0
};

/* --------------------------------------------------------------- */
/* codeset definition: define set of code			   */
/*   ... i_codeset and o_codeset is merged in 1.92a5g		   */
/* --------------------------------------------------------------- */
/* list order must be same as charset_option_codeset - 1000	   */
/*  in skf.c							   */
/* --------------------------------------------------------------- */
struct in_codeset_defs i_codeset[] = {
  {SKF_JIS,0,				/* Nr.0 dummy		   */
    {ub_uni_index,ascii_index}, 
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,L_US,NULL,NULL},
  {SKF_JIS,0, 				/* Nr.1 ascii		   */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_8859_index,iso8859_1_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS,L_US,"ANSI X3.4-1968","us-ascii"},
  {SKF_JIS,0, 				/* Nr.2 x-0208(rfc1496)	   */
    {ub_uni_index,x0201_index},
    {ub_3db_index,x0208_index},{ub_uni_index,x0201r_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0212_index},
    {ub_uni_index,x0201r_index},OMAP_NSG,
    OI_ASCI_X201,OI_LATN_X208,OI_SYMBL_X208,OI_KANA_X208,-1,
    OI_KANJI_X208,-1,-1,OI_CMP_X208,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_x201_208,SKF_JIS | SKF_COD_MB,
    L_JA,"iso-2022-jp (rfc1496)","iso-2022-jp"},
  {SKF_JIS,0,				/* Nr.3 rfc1554		   */
    {ub_uni_index,ascii_index}, 
    {ub_3db_index,x0208_index},{ub_uni_index,x0201r_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0212_index},
    {ub_8859_index,iso8859_6_index},OMAP_NSG,
    OI_ASCI_X201,OI_LATN_X208,OI_SYMBL_X208,OI_KANA_X208,-1,
    OI_KANJI_X208,-1,-1,OI_CMP_X208,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_x201_208,SKF_JIS | SKF_COD_MB | SKF_USE_ISO8859,
    L_JA,"iso-2022-jp-2 (rfc1554)","iso-2022-jp-2"},
  {SKF_JIS,0, 				/* Nr.4 x-0208(rfc1554kr)  */
    {ub_uni_index,ascii_index},
    {ub_3db_index,x0208_index},{ub_4db_index,ksc5601_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0212_index},
    {ub_uni_index,x0201r_index},OMAP_NSG,
    OI_ASCI_X201,OI_LATN_X208,OI_SYMBL_X208,OI_KANA_X208,-1,
    OI_KANJI_X208,-1,OI_HNGL_KSX,OI_CMP_X208,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_x201_208,SKF_JIS | SKF_COD_MB | SKF_USE_ISO8859,
    L_JA,"iso-2022-jp-2-kr (rfc1554)","iso-2022-jp-2-kr"},
  {SKF_JIS | SKF_JIS_213,0, 		/* Nr.5 x-0213		   */
    {ub_uni_index,x0201_index},
    {ub_4db_index,x0213_1_index},{ub_uni_index,x0201r_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0213_2_index},
    {ub_uni_index,x0201r_index},OMAP_NSG,
    OI_ASCI_X201,OI_LATN_X213,OI_SYMBL_X213,OI_KANA_X213,
    OI_CJK_A_X213,OI_KANJI_X213,-1,-1,OI_CMP_X213,OI_CJK_B_X213,
    -1,-1,-1,-1,-1,-1,-1,NULL,o_patch_x201_208,
    SKF_JIS | SKF_USE_X0212 | SKF_JIS_213 | SKF_COD_MB,
    L_JA,"iso-2022-jp-3 (X 0213:2000)","iso-2022-jp-3"},
  {SKF_JIS | SKF_JIS_213,0,		/* Nr.6 x-0213-strict	   */
    {ub_uni_index,x0201_index}, 
    {ub_3db_index,x0208_index},{ub_uni_index,x0201r_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0213_1_index},
    {ub_uni_index,x0201r_index},OMAP_NSG,
    OI_ASCI_X201,OI_LATN_X213C,OI_SYMBL_X213C,OI_KANA_X213C,
    OI_CJK_A_X213C,OI_KANJI_X213C,-1,-1,OI_CMP_X213C,OI_CJK_B_X213C,
    -1,-1,-1,-1,-1,-1,-1,NULL,o_patch_x201_208,
    SKF_JIS | SKF_USE_X0212 | SKF_JIS_213 | SKF_COD_MB,L_JA,
    "iso-2022-jp-3-strict (X 0213:2000)","iso-2022-jp-3-strict"},
  {SKF_JIS,0, 				/* Nr.7 x-0208(jis78)	   */
    {ub_uni_index,x0201_index},
    {ub_3db_index,x0208_o_index},{ub_uni_index,x0201r_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0212_index},
    {ub_uni_index,x0201r_index},OMAP_NSG,
    OI_ASCI_X201,OI_LATN_OX208,OI_SYMBL_OX208,OI_KANA_OX208,-1,
    OI_KANJI_OX208,-1,-1,OI_CMP_OX208,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_x201_208,SKF_JIS | SKF_COD_MB,
    L_JA,"old-jis (JIS C6226:1978)","oldjis"},
  {SKF_JIS | SKF_JIS_213N,0, 		/* Nr.8 x-0213:2004	   */
    {ub_uni_index,x0201_index},
    {ub_4db_index,x0213_1n_index},{ub_uni_index,x0201r_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0213_2_index},
    {ub_uni_index,x0201r_index},OMAP_NSG,
    OI_ASCI_X201,OI_LATN_X213,OI_SYMBL_X213,OI_KANA_X213,OI_CJK_A_X213,
    OI_KANJI_X213N,-1,-1,OI_CMP_X213,OI_CJK_B_X213N,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_x201_208,
    SKF_JIS | SKF_JIS_213N | SKF_COD_MB | SKF_USE_X0212,
    L_JA,"iso-2022-jp-3:2004","iso-2022-jp-3-2004"},
  {SKF_EUC7 | SKF_EUC7_V,0,	/* Nr.9 iso-2022-kr(euc7-kr)	   */
    {ub_misc_index,ksx1003_index},{-1,-1}, 
    {ub_4db_index,ksc5601_index},{-1,-1},{-1,-1},{-1,-1},OMAP_7BIT,
    OI_ASCI_KSX1003,OI_LATN_KSX,OI_SYMBL_KSX,OI_KANA_KSX,-1,
    OI_KANJI_KSX,-1,OI_HNGL_KSX,OI_CMP_KSX,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_xkr_1003,
    SKF_EUC7 | SKF_EUC7_V | SKF_ADD_ANNON | SKF_COD_MB,
    L_KO,"ks_x_1001(7bit EUC)","iso-2022-kr"},
  {SKF_EUC7 | SKF_EUC7_V,0, 	/* Nr.10 gb-2312(euc7-cn)	   */
    {ub_uni_index,ascii_index},{-1,-1},{ub_4db_index,gb2312_index},
    {-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_GB,OI_SYMBL_GB,OI_KANA_GB,-1,OI_KANJI_GB,
    -1,-1,OI_CMP_GB,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_EUC7 | SKF_COD_MB | SKF_ADD_ANNON | SKF_EUC7_V,
    L_ZH,"gb2312(7bit EUC)","euc7-cn"},	
  {SKF_EUC,0,{ub_uni_index,ascii_index}, /* Nr.11 x-0208(eucJP)	   */
    {-1,-1},{ub_3db_index,x0208_index},{ub_uni_index,x0201r_index},
    {ub_4db_index,x0212_index},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_X208,OI_SYMBL_X208,OI_KANA_X208,-1,
    OI_KANJI_X208,-1,-1,OI_CMP_X208,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_EUC | SKF_COD_MB,L_JA,"euc-jp.open","euc-jp"},
  {SKF_EUC | SKF_EUC_213,0, 		/* Nr.12 x-0213:2000(euc)  */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_4db_index,x0213_1_index},{ub_uni_index,x0201r_index},
    {ub_4db_index,x0213_2_index},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_X213,OI_SYMBL_X213,OI_KANA_X213,OI_CJK_A_X213,
    OI_KANJI_X213,-1,-1,OI_CMP_X213,OI_CJK_B_X213,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_EUC | SKF_EUC_213 | SKF_COD_MB | SKF_USE_X0212,
    L_JA,"euc-x0213:2000","euc-x0213"},
  {SKF_EUC | SKF_EUC_213N,0,		/* Nr.13 euc-jp-0213:2004 */
    {ub_uni_index,ascii_index},{-1,-1},{ub_4db_index,x0213_1n_index},
    {ub_uni_index,x0201r_index},{ub_4db_index,x0213_2_index},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_X213,OI_SYMBL_X213,OI_KANA_X213,OI_CJK_A_X213,
    OI_KANJI_X213N,-1,-1,OI_CMP_X213,OI_CJK_B_X213N,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_EUC | SKF_EUC_213N | SKF_COD_MB | SKF_USE_X0212,
    L_JA,"euc-jp-x0213:2004","euc-jis-2004"},
  {SKF_EUC,0,{ub_misc_index,ksx1003_index},/* Nr.14 ksx1001(eucKR) */
    {-1,-1},{ub_4db_index,ksc5601_index},
    {ub_8859_index,iso8859_1_index},{-1,-1},{-1,-1},0,
    OI_ASCI_KSX1003,OI_LATN_KSX,OI_SYMBL_KSX,OI_KANA_KSX,-1,
    OI_KANJI_KSX,-1,OI_HNGL_KSX,OI_CMP_KSX,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_xkr_1003,SKF_EUC | SKF_COD_MB,
    L_KO,"euc-kr","euc-kr"},
  {SKF_EUC,0,{ub_uni_index,ascii_index},  /* Nr.15 gb2312(eucCN)   */
    {-1,-1},{ub_4db_index,gb2312_index},
    {ub_8859_index,iso8859_1_index},{-1,-1},{-1,-1},0,
    OI_ASCI_GB1988,OI_LATN_GB,OI_SYMBL_GB,OI_KANA_GB,-1,
    OI_KANJI_GB,-1,-1,OI_CMP_GB,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_gb_1988,SKF_EUC | SKF_COD_MB,L_ZH,"euc-cn","euc-cn"},
  {SKF_EUC | SKF_EUC_CNS,0, 		/* Nr.16 EUC-TW		   */
    {ub_uni_index,ascii_index},
    {ub_4db_index,cns11643_3_index},{ub_4db_index,cns11643_1_index},
    {ub_4db_index,cns11643_2_index},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_CNS11643,OI_SYMBL_CNS11643,OI_KANA_CNS11643,
    -1,OI_KANJI_CNS11643,-1,-1,OI_CMP_CNS11643,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_EUC | SKF_EUC_CNS | SKF_COD_MB,
    L_ZH,"EUC Taiwan(cns 11643)","euc-tw"},
  {SKF_GBKR | SKF_GBKR_HZ,0,		/* Nr.17 gb2312(HZ)	   */
    {ub_uni_index,ascii_index},{-1,-1},{ub_4db_index,gb2312_index},
    {ub_8859_index,iso8859_1_index},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_GB,OI_SYMBL_GB,OI_KANA_GB,-1,
    OI_KANJI_GB,-1,-1,OI_CMP_GB,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_GBKR | SKF_GBKR_HZ | SKF_COD_MB,
    L_ZH,"gb2312-HZ","hz-gb-2312"},
  {SKF_GBKR | SKF_GBKR_ZW,0,		/* Nr.18 gb2312(zW)	   */
    {ub_uni_index,ascii_index},{-1,-1},{ub_4db_index,gb2312_index},
    {ub_8859_index,iso8859_1_index},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_GB,OI_SYMBL_GB,OI_KANA_GB,-1,
    OI_KANJI_GB,-1,-1,OI_CMP_GB,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_GBKR | SKF_GBKR_ZW | SKF_COD_MB | COD_HIDE,
    L_ZH,"gb2312-zW","zw-gb-2312"},
  {SKF_MS,0,{ub_uni_index,x0201_index}, /* Nr.19 SJIS		   */
    {ub_uni_index,x0201r_index},{ub_3db_index,x0208_index},
    {ub_8859_index,iso8859_1_index},{-1,-1},
    {ub_uni_index,x0201r_index},0,
    OI_ASCI_X201,OI_LATN_X208,OI_SYMBL_X208,OI_KANA_X208,-1,
    OI_KANJI_X208,-1,-1,OI_CMP_X208,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,
    o_patch_x201_208,SKF_MS | SKF_COD_MB,L_JA,"Shift_JIS","shift_jis"},
  {SKF_MS | SKF_MS_213,0, 		/* Nr.20 x-0213(SJIS)	   */
    {ub_uni_index,x0201_index},
    {ub_uni_index,x0201r_index},{ub_4db_index,x0213_1_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0213_2_index},
    {ub_uni_index,x0201r_index},0,
    OI_ASCI_X201,OI_LATN_X213,OI_SYMBL_X213,OI_KANA_X213,
    OI_CJK_A_X213,OI_KANJI_X213,-1,-1,OI_CMP_X213,OI_CJK_B_X213,
    -1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_x201_208,
    SKF_MS | SKF_MS_213 | SKF_COD_MB | SKF_USE_X0212,
    L_JA,"iso-2022-jp-3(SJIS:2000)","sjis-x0213"},
  {SKF_MS | SKF_MS_213N,0, 		/* Nr.21 SJIS x-0213:2004  */
    {ub_uni_index,x0201_index},{ub_uni_index,x0201r_index},
    {ub_4db_index,x0213_1n_index},{ub_8859_index,iso8859_1_index},
    {-1,-1},{ub_uni_index,x0201r_index},0,
    OI_ASCI_X201,OI_LATN_X213,OI_SYMBL_X213,OI_KANA_X213,OI_CJK_A_X213,
    OI_KANJI_X213N,-1,-1,OI_CMP_X213,OI_CJK_B_X213N,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_x201_208,
    SKF_MS | SKF_MS_213N | SKF_COD_MB | SKF_USE_X0212,
    L_JA,"sjis-x0213:2004","sjis-x0213-2004"},
  {SKF_MS | SKF_MS_932 | SKF_MS_COMPAT | SKF_HAS_PRIVATE,0,
    {ub_uni_index,ascii_index}, 	/* Nr.22 SJIS(cp932)	   */
    {ub_uni_index,x0201r_index},{ub_3db_index,cp932_index},
    {ub_8859_index,iso8859_1_index},{-1,-1},
    {ub_uni_index,x0201r_index},0,
    OI_ASCI_ASCII,OI_LATN_CP932,OI_SYMBL_CP932,OI_KANA_CP932,-1,
    OI_KANJI_CP932,-1,-1,OI_CMP_CP932,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_cp932,
    SKF_MS | SKF_MS_932 | SKF_MS_COMPAT | SKF_HAS_PRIVATE | SKF_COD_MB
    | EIGHTBIT, L_JA,"MS cp932","windows-31j"},
  {SKF_MS | SKF_MS_943 ,0,		/* Nr.23 SJIS(cp943)	   */
    {ub_uni_index,x0201_index},
    {ub_uni_index,x0201r_index},{ub_3db_index,cp943_index},
    {ub_8859_index,iso8859_1_index},{-1,-1},
    {ub_uni_index,x0201r_index},0,
    OI_ASCI_X201,OI_LATN_CP943,OI_SYMBL_CP943,OI_KANA_CP943,-1,
    OI_KANJI_CP943,-1,-1,OI_CMP_CP943,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_x201_208,SKF_MS | SKF_MS_943 | SKF_COD_MB | EIGHTBIT,
    L_JA,"IBM cp943","cp943"},
  {SKF_MS,0,			/* Nr.24 cp942(sjis78)		   */
    {ub_uni_index,x0201_index},{ub_uni_index,x0201r_index},
    {ub_3db_index,x0208_o_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0212_index},
    {ub_uni_index,x0201r_index},0,
    OI_ASCI_X201,OI_LATN_OX208,OI_SYMBL_OX208,OI_KANA_OX208,-1,
    OI_KANJI_OX208,-1,-1,OI_CMP_OX208,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_x201_208,SKF_MS | SKF_COD_MB,
    L_JA,"old-sjis (JIS C6226:1978)","oldsjis"},
  {SKF_MS | SKF_MS_NTT,0, 	/* Nr.25 SJIS(DoCoMo-phone)	   */
    {ub_uni_index,x0201_index},{ub_uni_index,x0201r_index},
    {ub_3db_index,cp932_index},{ub_ovlay_index,nttemot_index},
    {-1,-1}, {ub_uni_index,x0201r_index},0,
    OI_ASCI_X201,OI_LATN_CELN,OI_SYMBL_CELN,OI_KANA_CELN,-1,
    OI_KANJI_X208,-1,-1,OI_CMP_X208,-1,-1,-1,-1,OI_NOT_CELN,
    -1,-1,-1,NULL,o_patch_x201_208,
    SKF_MS | SKF_MS_NTT | SKF_COD_MB | SKF_MS_COMPAT,
    L_JA,"Shift_JIS (DoCoMo-glyph)","sjis-docomo"},
  {SKF_MS | SKF_MS_932 | SKF_MS_COMPAT | SKF_HAS_PRIVATE,0,
	/* Nr.26 SJIS(cp932_WideCharToMultiByte API compat.)	  */
    {ub_uni_index,ascii_index},
    {ub_uni_index,x0201r_index},{ub_3db_index,cp932_index},
    {ub_8859_index,iso8859_1_index},{-1,-1},
    {ub_uni_index,x0201r_index},0,
    OI_ASCI_ASCII,OI_LATN_CP932W,OI_SYMBL_CP932,OI_KANA_CP932,-1,
    OI_KANJI_CP932,-1,-1,OI_CMP_CP932,-1,-1,OI_PRV_CP932,-1,-1,-1,-1,-1,
    NULL,o_patch_cp932, SKF_MS | SKF_MS_932 | SKF_MS_COMPAT |
    SKF_HAS_PRIVATE | SKF_COD_MB | EIGHTBIT,L_JA,
    "MS cp932(WideCharToMultiByte compat)","cp932w"},
  {SKF_EUC | SKF_EUC_51932 | SKF_MS_COMPAT,0,
				/* Nr.27 (eucJP_cp51932)	   */
    {ub_uni_index,ascii_index},{-1,-1},{ub_3db_index,cp932_index},
    {ub_uni_index,x0201r_index},{ub_4db_index,x0212_index},
    {-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_CP932,OI_SYMBL_CP932,OI_KANA_CP932,-1,
    OI_KANJI_CP932,-1,-1,OI_CMP_CP932,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_cp51932,
    SKF_EUC | SKF_EUC_51932 | SKF_MS_COMPAT | SKF_COD_MB,
    L_JA,"MS cp51932","cp51932"},
  {SKF_JIS | SKF_JIS_220,0,	/* Nr.28 (jis_x0208_cp5022x) 	   */
    {ub_uni_index,ascii_index},
    {ub_3db_index,x0208_index},{ub_uni_index,x0201r_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0212_index},
    {ub_uni_index,x0201r_index},(OMAP_NSG),
    OI_ASCI_ASCII,OI_LATN_CP932,OI_SYMBL_CP932,OI_KANA_CP932,-1,
    OI_KANJI_CP932,-1,-1,OI_CMP_CP932,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_cp51932,
    SKF_JIS | SKF_JIS_220 | SKF_COD_MB | SKF_MS_COMPAT,
    L_JA,"MS cp50220","cp50220"},
  {SKF_JIS | SKF_JIS_221,0,	/* Nr.29 (jis_x0208_cp50221) 	   */
    {ub_uni_index,ascii_index},
    {ub_3db_index,x0208_index},{ub_uni_index,x0201r_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0212_index},
    {ub_uni_index,x0201r_index},(OMAP_NSG),
    OI_ASCI_ASCII,OI_LATN_CP932,OI_SYMBL_CP932,OI_KANA_CP932,-1,
    OI_KANJI_CP932,-1,-1,OI_CMP_CP932,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_cp51932,
    SKF_JIS | SKF_JIS_221 | SKF_COD_MB | SKF_MS_COMPAT | KANA_CALL,
    L_JA,"MS cp50221","cp50221"},
  {SKF_JIS | SKF_JIS_222,0,	/* Nr.30 (jis_x0208_cp50222) 	   */
    {ub_uni_index,ascii_index},
    {ub_3db_index,x0208_index},{ub_uni_index,x0201r_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0212_index},
    {ub_uni_index,x0201r_index},(OMAP_NSG),
    OI_ASCI_ASCII,OI_LATN_CP932,OI_SYMBL_CP932,OI_KANA_CP932,-1,
    OI_KANJI_CP932,-1,-1,OI_CMP_CP932,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_cp51932,
    SKF_JIS | SKF_JIS_222 | SKF_COD_MB | SKF_MS_COMPAT | SI_ENBL,
    L_JA,"MS cp50222","cp50222"},
  {SKF_EUC | SKF_EUC_20932,0,	/* Nr.31 (eucJP_cp20932)	   */
    {ub_uni_index,ascii_index}, {ub_4db_index,x0212_index},
    {ub_3db_index,cp932_index},{ub_uni_index,x0201r_index}, {-1,-1},
    {-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_CP932,OI_SYMBL_CP932,OI_KANA_CP932,-1,
    OI_KANJI_CP932,-1,-1,OI_CMP_CP932,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,
    SKF_EUC | SKF_EUC_20932 | COD_HIDE | SKF_COD_MB | EIGHTBIT,
    L_JA,"MS cp20932","cp20932"},
  {SKF_UCS | SKF_UCS_UTF16,0,	/* Nr.32 UTF-16-LE		   */
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
   OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   NULL,NULL,SKF_UCS | SKF_UCS_UTF16 | SKF_ADD_BOM | SKF_NOT_ASCII,
   L_NU,"Unicode(TM) UTF-16LE-BOM","utf-16le-bom"},
  {SKF_UCS | SKF_UCS_UTF16,0,	/* Nr.33 UTF-16-BE		   */
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
   OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   NULL,NULL,
   SKF_UCS | SKF_UCS_UTF16 | SKF_BIG_ENDIAN | SKF_ADD_BOM | SKF_NOT_ASCII,
   L_NU,"Unicode(TM) UTF-16BE-BOM","utf-16be-bom"},
  {SKF_UCS | SKF_UCS_UTF8,0,	/* Nr.34 UTF8			   */
   {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
   OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   NULL,NULL,SKF_UCS | SKF_UCS_UTF8,L_NU,"Unicode(TM) UTF-8","utf-8"},
  {SKF_UCS | SKF_UCS_UTF7,0,	/* Nr.35 UTF7			   */
   {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
   OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   NULL,NULL,SKF_UCS | SKF_UCS_UTF7,L_NU,"Unicode(TM) UTF-7","utf-7"},
  {SKF_CDSP | SKF_CDSP_BRGT,0,	/* Nr.36 B-Right/V		   */
    {ub_uni_index,ascii_index},{ub_3db_index,x0208_index},
    {ub_4db_index,ksc5601_index},{ub_4db_index,gb2312_index},
    {ub_4db_index,x0212_index},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_X208,OI_SYMBL_X208,OI_KANA_X208,-1,
    OI_KANJI_X208,-1,OI_HNGL_KSX,OI_CMP_X208,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_CDSP | SKF_CDSP_BRGT | COD_HIDE | SKF_COD_MB,
    L_JA,"B-Right/V-jp","b/right"},
/* BIG5 and its variants */
  {SKF_BIG5,0,			/* Nr.37 BIG5 (ETEN)		   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_miscm_index,big5_index},{-1,-1},{-1,-1},
    {-1,-1},(OMAP_RAW | OMAP_MAP),
    OI_ASCI_ASCII,OI_LATN_BIG5,OI_SYMBL_BIG5,OI_KANA_BIG5,-1,
    OI_KANJI_BIG5,-1,-1,OI_CMP_BIG5,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_BIG5 | SKF_COD_MB | EIGHTBIT,L_ZH,"Big5(ETen)","big5"},
  {SKF_BIG5 | SKF_B5_HKU,0,
    {ub_uni_index,ascii_index},	/* Nr.38 BIG5 (HKU)		   */
    {-1,-1},{ub_miscm_index,big5hku_index},{-1,-1},{-1,-1},
    {-1,-1},(OMAP_RAW | OMAP_MAP),
    OI_ASCI_ASCII,OI_LATN_BIG5H,OI_SYMBL_BIG5H,OI_KANA_BIG5H,-1,
    OI_KANJI_BIG5H,-1,-1,OI_CMP_BIG5H,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,(SKF_BIG5 | SKF_B5_HKU | EIGHTBIT | SKF_COD_MB),L_ZH,
    "Big5(HKU)","big5-hku"},
  {SKF_BIG5 | SKF_B5_CP950,0,
    {ub_uni_index,ascii_index},	/* Nr.39 BIG5 (cp950)	   */
    {-1,-1},{ub_miscm_index,big5cp950_index},{-1,-1},{-1,-1},
    {-1,-1},(OMAP_RAW | OMAP_MAP),
    OI_ASCI_ASCII,OI_LATN_BIG5MS,OI_SYMBL_BIG5MS,OI_KANA_BIG5MS,-1,
    OI_KANJI_BIG5MS,-1,-1,OI_CMP_BIG5MS,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_BIG5 | SKF_B5_CP950 | EIGHTBIT | SKF_COD_MB,
    L_ZH,"Big5(MS cp950)","cp950"},
  {SKF_BIG5 | SKF_B5_2003,0, 	 /* Nr.40 BIG5-2003	   */
    {ub_uni_index,ascii_index},{-1,-1},{ub_miscm_index,big5_2003_index},
    {-1,-1},{-1,-1},{-1,-1},(OMAP_RAW | OMAP_MAP),
    OI_ASCI_ASCII,OI_LATN_BIG52003,OI_SYMBL_BIG52003,
    OI_KANA_BIG52003,-1,OI_KANJI_BIG52003,-1,-1,
    OI_CMP_BIG52003,-1,-1,OI_PRV_BIG52003,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_BIG5 | SKF_B5_2003 | EIGHTBIT | SKF_COD_MB,
    L_ZH,"BIG5-2003","big5-2003"},
  {SKF_BIG5 | SKF_B5_UAO,0,	/* Nr.41 BIG5-Unicode at on	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_miscm_index,big5_uao_index},{-1,-1},{-1,-1},
    {-1,-1},(OMAP_RAW | OMAP_MAP),
    OI_ASCI_ASCII,OI_LATN_BIG5UAO,OI_SYMBL_BIG5UAO,OI_KANA_BIG5UAO,
    OI_CJK_A_BIG5UAO,OI_KANJI_BIG5UAO,-1,-1,
    OI_CMP_BIG5UAO,-1,-1,OI_PRV_BIG5UAO,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_BIG5 | SKF_B5_UAO | EIGHTBIT | SKF_COD_MB,
    L_ZH,"BIG5 Unicode-at-on","big5-uao"},
  {SKF_BIG5 | SKF_B5_GCSS,0, 	 /* Nr.42 BIG5plus		   */
    {ub_uni_index,ascii_index},{-1,-1},{ub_miscm_index,big5p_index},
    {-1,-1},{-1,-1},{-1,-1},(OMAP_RAW | OMAP_MAP),
    OI_ASCI_ASCII,OI_LATN_BIG5P,OI_SYMBL_BIG5P,OI_KANA_BIG5P,
    OI_CJK_A_BIG5P,OI_KANJI_BIG5P,-1,-1,OI_CMP_BIG5P,
    OI_CJK_B_BIG5P,OI_CJK_C_BIG5P,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_BIG5 | SKF_B5_GCSS | EIGHTBIT | SKF_COD_MB,
    L_ZH,"BIG5(HKSCS)","big5-hkscs"},
/* Other uncommon codesets */
  {SKF_BIG5 | SKF_B5_GBK,0,  	/* Nr.43 GBK		   */
    {ub_uni_index,ascii_index},{-1,-1},{ub_miscm_index,gbk_index},
    {-1,-1},{-1,-1},{-1,-1},(OMAP_RAW | OMAP_MAP),
    OI_ASCI_ASCII,OI_LATN_GBK,OI_SYMBL_GBK,OI_KANA_GBK,OI_CJK_A_GBK,
    OI_KANJI_GBK,-1,-1,OI_CMP_GBK,-1,-1,OI_PRV_GBK,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_BIG5 | SKF_B5_GBK | SKF_COD_MB | HAVE_HHK,
    L_ZH,"GBK(MS cp936)","gbk"},
  {SKF_GBKR | SKF_GBKR_JOHAB,0,		/* Nr.44 Johab		   */
    {ub_uni_index,ascii_index},{ub_4db_index,ksc5601_index},
    {ub_miscm_index,johab_index},{-1,-1},{-1,-1},
    {-1,-1},(OMAP_RAW | OMAP_MAP),
    OI_ASCI_ASCII,OI_LATN_JOHAB,OI_SYMBL_JOHAB,OI_KANA_JOHAB,-1,
    OI_KANJI_JOHAB,-1,OI_HNGL_JOHAB,OI_CMP_JOHAB,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_GBKR | SKF_GBKR_JOHAB | SKF_COD_MB,L_KO,
    "KS X1001(johab)","johab"},
  {SKF_BIG5 | SKF_B5_GB8,0,		/* Nr.45 GB18030	   */
    {ub_uni_index,ascii_index},
    {ub_ovlay_index,gb18030_a5_index},{ub_miscm_index,gb18030_index},
    {-1,-1},{-1,-1},{-1,-1},(OMAP_RAW | OMAP_MAP),
    OI_ASCI_ASCII,OI_LATN_GB2K,OI_SYMBL_GB2K,OI_KANA_GB2K,
    OI_CJK_A_GB2K,OI_KANJI_GB2K,-1,-1,OI_CMP_GB2K,-1,-1,OI_PRV_GB2K,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_BIG5 | SKF_B5_GB8 | SKF_COD_MB | HAVE_HHK,
    L_ZH,"GB 18030","gb18030"},
  {SKF_EUC | SKF_EUC_NISO,0, 	/* Nr.46 gb12345(eucCN)		   */
    {ub_uni_index,ascii_index},{-1,-1},{ub_miscm_index,gb12345_index},
    {ub_8859_index,iso8859_1_index},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_GB12345,OI_SYMBL_GB12345,
    OI_KANA_GB12345,-1,OI_KANJI_GB12345,-1,-1,OI_CMP_GB12345,
    -1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,
    SKF_EUC | SKF_COD_MB | SKF_EUC_NISO,L_ZH,"gb12345","gb12345"},
  {SKF_GBKR | SKF_GBKR_UHC, 	/* Nr.47 Windows-949(UHC)	   */
    0,{ub_uni_index,ascii_index},{-1,-1},
    {ub_miscm_index,cp949_index},{ub_8859_index,iso8859_1_index},
    {-1,-1},{-1,-1},(OMAP_RAW | OMAP_MAP),
    OI_ASCI_ASCII,OI_LATN_UHC,OI_SYMBL_UHC,OI_KANA_UHC,-1,OI_KANJI_UHC,
    -1,OI_HNGL_UHC,OI_CMP_UHC,-1,-1,OI_PRV_UHC,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_GBKR | SKF_GBKR_UHC | SKF_COD_MB,
    L_KO,"UHC (MS cp949)","windows-949"},
  {SKF_EUC | SKF_EUC_GCN,0,	/* Nr.48 iso-2022-cn(gb) 	  */
    {ub_uni_index,ascii_index},
    {ub_4db_index,gb2312_index},{ub_4db_index,cns11643_1_index},
    {ub_4db_index,cns11643_2_index},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_ISOCNG,OI_SYMBL_ISOCNG,OI_KANA_ISOCNG,
    OI_CJK_A_ISOCNG,OI_KANJI_ISOCNG,-1,-1,OI_CMP_ISOCNG,
    -1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_EUC | SKF_EUC_GCN  | SKF_COD_MB,
    L_ZH,"iso-2022-cn(cns11643 preferred)","iso-2022-cn"},
  {SKF_EUC | SKF_EUC_TCN,0,	/* Nr.49 iso-2022-cn(cns)	  */
    {ub_uni_index,ascii_index},
    {ub_4db_index,cns11643_1_index},{ub_4db_index,gb2312_index},
    {ub_4db_index,cns11643_2_index},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_ISOCNC,OI_SYMBL_ISOCNC,OI_KANA_ISOCNC,
    OI_CJK_A_ISOCNC,OI_KANJI_ISOCNC,-1,-1,OI_CMP_ISOCNC,
    -1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_EUC | SKF_EUC_TCN | SKF_COD_MB ,
    L_ZH,"iso-2022-cn(gb2312 preferred)","iso-2022-cnc"},
  {SKF_JIS | SKF_USE_8BIT,0, 	/* Nr.50 KOI-8-r		   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_misc_index,koi8_index},{-1,-1},{-1,-1},
    {ub_misc_index,koi8_index},0,
    OI_ASCI_ASCII,OI_LATN_KOI8,OI_SYMBL_KOI8,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,L_RU,"US ascii+KOI8-R","koi8-r"},
  {SKF_NNISO | SKF_NISO_VISC,0,	/* Nr.51 VISCII			   */
    {ub_misc_index,viscii_index}, 
    {-1,-1},{ub_misc_index,visciir_index},{-1,-1},{-1,-1},
    {ub_misc_index,visciiq_index},OMAP_RAW | OMAP_MAP,
    OI_ASCI_VISCII,OI_LATN_VISCII,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_NNISO | SKF_NISO_VISC,
    L_VI,"VISCII (rfc1456)","viscii"},
  {SKF_NNISO | SKF_NISO_VSQR,0,	  /* Nr.52 VIQR			   */
    {ub_misc_index,viscii_index}, {ub_misc_index,visciiq_index},
    {ub_misc_index,visciir_index},{-1,-1},{-1,-1},
    {-1,-1},OMAP_RAW | OMAP_MAP,
    OI_ASCI_VISCII,OI_LATN_VISCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,
    NULL,NULL,SKF_NNISO | SKF_NISO_VSQR,
    L_VI,"VISCII (VIQR)","viqr"},
  {SKF_NNISO | SKF_NISO_VIMN,0, /* Nr.53 VSCII-MNEM		   */
    {ub_misc_index,viscii_index}, {ub_misc_index,visciiq_index},
    {ub_misc_index,visciir_index},{-1,-1},{-1,-1},
    {ub_misc_index,visciiq_index},OMAP_RAW | OMAP_MAP,
    OI_ASCI_VISCII,OI_LATN_VISCII,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_NNISO | SKF_NISO_VIMN,
    L_VI,"VISCII (VISCII-MNEM)","viscii-mnem"},
  {SKF_NNISO | SKF_NISO_VNI,0,	/* Nr.54 VNI			   */
    {ub_uni_index,ascii_index},{-1,-1},{ub_misc_index,vni_index},
    {-1,-1},{-1,-1},{ub_ovlay_index,vni_ex_prv_index},
    OMAP_RAW | OMAP_MAP,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,
    SKF_NNISO | SKF_NISO_VNI | COD_HIDE,L_VI,"Vietnamese VNI","vni"},
  {SKF_NNISO | SKF_NISO_VM ,0, 	/* Nr.55 vps			   */
    {ub_misc_index,vpsl_index},{-1,-1},{ub_misc_index,vpsr_index},
    {-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,
    SKF_NNISO | SKF_NISO_VM | COD_HIDE,L_VI,"vps","vps"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.56 iso_8859_1	   */
    {ub_uni_index,ascii_index},{-1,-1},{ub_8859_index,iso8859_1_index},
    {-1,-1},{-1,-1},{ub_8859_index,iso8859_1_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS|SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-1","iso-8859-1"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.57 iso_8859_2	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_8859_index,iso8859_2_index},{-1,-1},{-1,-1},
    {ub_8859_index,iso8859_2_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS|SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-2","iso-8859-2"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.58 iso_8859_3	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_8859_index,iso8859_3_index},{-1,-1},{-1,-1},
    {ub_8859_index,iso8859_3_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-3","iso-8859-3"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.59 iso_8859_4	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_8859_index,iso8859_4_index},{-1,-1},{-1,-1},
    {ub_8859_index,iso8859_4_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-4","iso-8859-4"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.60 iso_8859_5	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_8859_index,iso8859_5_index},{-1,-1},{-1,-1},
    {ub_8859_index,iso8859_5_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-5","iso-8859-5"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.61 iso_8859_6	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_8859_index,iso8859_6_index},{-1,-1},{-1,-1},
    {ub_8859_index,iso8859_6_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-6","iso-8859-6"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.62 iso_8859_7	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_8859_index,iso8859_7_index},{-1,-1},{-1,-1},
    {ub_8859_index,iso8859_7_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-7","iso-8859-7"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.63 iso_8859_8	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_8859_index,iso8859_8_index},{-1,-1},{-1,-1},
    {ub_8859_index,iso8859_8_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-8","iso-8859-8"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.64 iso_8859_9	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_8859_index,iso8859_9_index},{-1,-1},{-1,-1},
    {ub_8859_index,iso8859_9_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-9","iso-8859-9"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.65 iso_8859_10	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_8859_index,iso8859_10_index},{-1,-1},{-1,-1},
    {ub_8859_index,iso8859_10_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-10","iso-8859-10"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.66 iso_8859_11	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_8859_index,iso8859_11_index},{-1,-1},{-1,-1},
    {ub_8859_index,iso8859_11_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-11","iso-8859-11"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.67 iso_8859_13	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_8859_index,iso8859_13_index},{-1,-1},{-1,-1},
    {ub_8859_index,iso8859_13_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_13,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-13","iso-8859-13"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.68 iso_8859_14	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_8859_index,iso8859_14_index},{-1,-1},{-1,-1},
    {ub_8859_index,iso8859_14_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_14,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-14","iso-8859-14"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.69 iso_8859_15	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_8859_index,iso8859_15_index},{-1,-1},{-1,-1},
    {ub_8859_index,iso8859_15_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_15,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-15","iso-8859-15"},
  {SKF_JIS | SKF_USE_8BIT,0, 		/* Nr.70 iso_8859_16	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_8859_index,iso8859_16_index},{-1,-1},{-1,-1},
    {ub_8859_index,iso8859_16_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_16,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,
    L_EN,"US ASCII+iso-8859-16","iso-8859-16"},
/* MVS and its variants DCBS codesets */
  {SKF_KEIS | SKF_DBCS, 0,		/* Nr.71 IBM DBCS	   */
    {-1,-1},{ub_misc_index,ebcdic_index},
    {ub_miscm_index,ibmdbcs_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_IBM930,OI_LATN_IBM930,OI_SYMBL_IBM930,OI_KANA_IBM930,-1,
    OI_KANJI_IBM930,-1,-1,OI_CMP_IBM930,-1,-1,OI_PRV_IBM930,-1,-1,
    -1,-1,-1,
    NULL,NULL,SKF_KEIS | SKF_DBCS | SKF_COD_MB | SKF_NOT_ASCII,
    L_JA,"IBM DBCS Japanese IBM930","ibm930"},
  {SKF_KEIS | SKF_DBCS, 0,		/* Nr.72 IBM ibmcp931	   */
    {-1,-1},{ub_misc_index,ebcdice_index},
    {ub_miscm_index,ibmdbcs_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_IBM930,OI_LATN_IBM930,OI_SYMBL_IBM930,OI_KANA_IBM930,-1,
    OI_KANJI_IBM930,-1,-1,OI_CMP_IBM930,-1,-1,OI_PRV_IBM930,-1,-1,
    -1,-1,-1,
    NULL,NULL,SKF_KEIS | SKF_DBCS | SKF_COD_MB | SKF_NOT_ASCII ,
    L_JA,"IBM DBCS ibm931","ibm931"},
  {SKF_KEIS | SKF_DBCST, 0,		/* Nr.73 IBM ibmcp933	   */
    {-1,-1},{ub_misc_index,ebcdick_index},
    {ub_miscm_index,ibmdbcsk_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_IBM933,OI_LATN_IBM933,OI_SYMBL_IBM933,OI_KANA_IBM933,-1,
    OI_KANJI_IBM933,-1,-1,OI_CMP_IBM933,-1,-1,OI_PRV_IBM933,-1,-1,
    -1,-1,-1,
    NULL,NULL,SKF_KEIS | SKF_DBCST | SKF_COD_MB | SKF_NOT_ASCII,
    L_KO,"IBM DBCS ibm933","ibm933"},
  {SKF_KEIS | SKF_DBCS, 0,		/* Nr.74 IBM ibmcp935	   */
    {-1,-1},{ub_misc_index,ebcdicz_index},
    {ub_miscm_index,ibmdbcsz_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_IBM935,OI_LATN_IBM935,OI_SYMBL_IBM935,OI_KANA_IBM935,-1,
    OI_KANJI_IBM935,-1,-1,OI_CMP_IBM935,-1,-1,OI_PRV_IBM935,-1,-1,
    -1,-1,-1,
    NULL,NULL,SKF_KEIS | SKF_DBCS | SKF_COD_MB | SKF_NOT_ASCII ,
    L_ZH,"IBM DBCS ibm935","ibm935"},
  {SKF_KEIS | SKF_DBCST, 0,		/* Nr.75 IBM ibmcp937	   */
    {-1,-1},{ub_misc_index,ebcdict_index},
    {ub_miscm_index,ibmdbcst_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_IBM937,OI_LATN_IBM937,OI_SYMBL_IBM937,OI_KANA_IBM937,-1,
    OI_KANJI_IBM937,-1,-1,OI_CMP_IBM937,-1,-1,OI_PRV_IBM937,-1,-1,
    -1,-1,-1,
    NULL,NULL,SKF_KEIS | SKF_DBCST | SKF_COD_MB | SKF_NOT_ASCII ,
    L_TW,"IBM DBCS ibm937","ibm937"},
  {SKF_KEIS,0,			/* Nr.76 KEIS			   */
    {ub_ovlay_index,keis_host_index},{ub_misc_index,ebcdik_index},
    {ub_3db_index,x0208_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_KEIS,OI_LATN_X208,OI_SYMBL_X208,OI_KANA_X208,-1,
    OI_KANJI_X208,-1,-1,OI_CMP_X208,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_KEIS | SKF_COD_MB | SKF_NOT_ASCII,
    L_JA,"Hitachi KEIS83/90","keis"},
  {SKF_KEIS | SKF_JEF,0, 	/* Nr.77 JEF			   */
    {ub_ovlay_index,jef_host_index},{ub_misc_index,ebcdic_index},
    {ub_3db_index,x0208_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_OX208,OI_SYMBL_OX208,OI_KANA_OX208,-1,
    OI_KANJI_OX208,-1,-1,OI_CMP_OX208,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_KEIS | SKF_JEF | SKF_COD_MB | SKF_NOT_ASCII,
    L_JA,"Fujitsu JEF","jef"},
  {SKF_KEIS | SKF_JEF_S,0,	/* Nr.78 JEF(latin)		   */
    {ub_ovlay_index,jef_host_index},{ub_misc_index,ebcdics_index},
    {ub_3db_index,x0208_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_X208,OI_SYMBL_X208,OI_KANA_X208,-1,
    OI_KANJI_X208,-1,-1,OI_CMP_X208,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,
    SKF_KEIS | SKF_JEF_S | COD_HIDE | SKF_COD_MB | SKF_NOT_ASCII,
    L_JA,"JEF LATIN","jef-latin"},
  {SKF_KEIS | SKF_NECH,0,	/* Nr.79 NEC DBCS		   */
    {ub_misc_index,ebcdicn_index},{ub_misc_index,jef_host_index},
    {ub_uni_index,x0201_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_X208,OI_SYMBL_X208,OI_KANA_X208,-1,
    OI_KANJI_X208,-1,-1,OI_CMP_X208,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,
    SKF_KEIS | SKF_NECH | COD_HIDE | SKF_COD_MB | SKF_NOT_ASCII,
    L_JA,"NEC DBCS","nec-dbcs"},
  {SKF_JIS | SKF_JIS_NATS,0,	  /* Nr.80 NATS_finland/Sweden	   */
    {ub_uni_index,nats_f_a_index},{-1,-1},
    {ub_uni_index,nats_a_index},{-1,-1},{-1,-1},
    {ub_uni_index,nats_a_index},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_JIS_NATS | COD_HIDE,
    L_EU,"NATS for Finland/Sweden","nats_finland"},
  {SKF_JIS | SKF_JIS_NATS,0,	  /* Nr.81 NATS_Denmark/Norway	   */
    {ub_uni_index,nats_d_a_index},
    {-1,-1},{ub_uni_index,nats_ad_index},{-1,-1},{-1,-1},
    {ub_uni_index,nats_ad_index},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_JIS_NATS | COD_HIDE,
    L_EU,"NATS for Denmark/Norway","nats_denmark"},
  {SKF_JIS,0,{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1}, /* Nr.82 resv */
    {ub_8859_index,iso8859_1_index},0,
    OI_ASCI_ASCII,OI_LATN_ISO8859_1,OI_SYMBL_X208,OI_KANA_X208,-1,
    OI_KANJI_X208,-1,OI_HNGL_KSX,OI_CMP_X208,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,L_EN,"iso-2022-jp-2-latin",NULL},
  {SKF_JIS,0,			/* Nr.83 CP1250			   */
    {ub_uni_index,ascii_index},{-1,-1},{ub_misc_index,cp1250_index},
    {-1,-1},{-1,-1},{ub_misc_index,cp1250_index},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,
    SKF_JIS | USE_JIS8 | COD_HIDE,L_BG,"MS cp1250","cp1250"},
  {SKF_JIS,0,			/* Nr.84 CP1251			   */
    {ub_uni_index,ascii_index},{-1,-1},{ub_misc_index,ms_cp1251_index},
    {-1,-1},{-1,-1},{ub_misc_index,ms_cp1251_index},0,
    OI_ASCI_ASCII,OI_LATN_CP1251,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | USE_JIS8,L_BG,"MS cp1251","cp1251"},
  {SKF_JIS,0,		 		/* Nr.85 bs4730		   */
    {ub_uni_index,bs4730_index},{-1,-1},{-1,-1},
    {-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS,L_EN,"BS 4730","bs4730"},
  {SKF_JIS ,0,		 		/* Nr.86 NF Z 62 010	   */
    {ub_uni_index,nfz62010_index},{-1,-1},{-1,-1},
    {-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS,M_FR,"NF Z 62 010","nfz62010"},
  {SKF_JIS ,0,		 		/* Nr.87 din66083	   */
    {ub_uni_index,din66083_index},{-1,-1},{-1,-1},
    {-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS,M_DE,"DIN 66083","din66083"},
  {SKF_JIS ,0,		 		/* Nr.88 Mac roman	   */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_misc_index,mac_roman_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,L_HE,"Mac_roman","Mac_roman"},
  {SKF_JIS ,0,		 		/* Nr.89 MacCE	  	   */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_cp_index,macce_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,L_CS,"Mac_CE","x-mac-ce"},
  {SKF_JIS ,0,		 		/* Nr.90 Mac Devanagari	   */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_cp_index,macdeva_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,
    L_HI,"Mac_Devanagari","x-mac-devanagari"},
  {SKF_JIS ,0,		 		/* Nr.91 Mac Cyrillic	   */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_cp_index,maccyri_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,L_RU,"Mac_cyrillic","x-mac-cyrillic"},
  {SKF_JIS ,0,		 		/* Nr.92 Mac Turkish	   */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_cp_index,macturk_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,
    SKF_JIS | COD_HIDE,L_TR,"Mac_Turkish","x-mac-turkish"},
  {SKF_JIS ,0,		 		/* Nr.93 Mac Greek	   */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_cp_index,macgreek_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,L_EL,"Mac_Greek","x-mac-greek"},
  {SKF_JIS ,0,		 		/* Nr.94 Mac Icelandic	   */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_cp_index,maciceln_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,L_IS,"Mac_Icelandic","x-mac-icelandic"},
  {SKF_JIS ,0,		 		/* Nr.95 Mac Gujarati	   */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_cp_index,macguj_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,
    L_GU,"Mac_gujarati","x-mac-gujarati"},
  {SKF_JIS ,0,		 	/* Nr.96 Mac Gurmukhi(Panjabi)	   */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_cp_index,macgrm_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,L_PA,"Mac_Gurmukhi","x-mac-gurmukhi"},
  {SKF_JIS ,0,		 	/* Nr.97 Mac Croatian		   */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_cp_index,maccroa_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,L_HR,"Mac_croatian","x-mac-croatian"},
  {SKF_JIS ,0,		 	/* Nr.98 Mac Romanian		   */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_cp_index,macromani_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,L_RO,"Mac_Romanian","x-mac-romanian"},
  {SKF_JIS ,0,		 	/* Nr.99 Armscii-8		   */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_misc_index,armiscii_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,
    L_HY,"Armenian Armiscii-8","armiscii-8"},
  {SKF_JIS ,0,		 	/* Nr.100 Gursian geostd8	  */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_misc_index,geostd_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,L_KA,"Georgian Geostd8","geostd8"},
  {SKF_GBKR | SKF_GBKR_IS ,0, 		/* Nr.101 ISCII base(de)   */
    {ub_uni_index,ascii_index},{-1,-1},
    {ub_cp_index,iscii_de_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_GBKR | SKF_GBKR_IS | COD_HIDE,L_HI,
    "Indian IS13194:1991(ISCII-91)","x-iscii-de"},
  {SKF_UCS | SKF_UCS_TRANS,0, 	/* Nr.102 TRANS			   */
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_UCS | SKF_UCS_TRANS | COD_HIDE ,
    L_NU,"Transparent mode","transparent"},
  {SKF_JIS | SKF_JIS_VAR,0,	/* Nr.103 latin-variable	   */
    {ub_uni_index,x0201_index},{ub_3db_index,x0208_index},
    {ub_8859_index,iso8859_1_index},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_JIS_VAR | COD_HIDE,
    L_US,"Variable codeset",NULL},
  {SKF_NNISO | SKF_NISO_GSM,0,	/* Nr.104 GSM 03.38		   */
    {ub_misc_index,gsm0338_index},{ub_ovlay_index,gsm0338a_index},
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_NNISO | SKF_NISO_GSM | COD_HIDE,
    L_NU,"GSM 03.38","gsm"},
  {SKF_JIS,0,			/* Nr.105 URI			   */
   {ub_uni_index,ascii_index},
   {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
   OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   NULL,NULL,SKF_UCS | SKF_UCS_URI,L_NU,"Unicode(TM) URI notation",
   "uri"},
  {SKF_JIS,0,			/* Nr.106 Punycode		   */
   {ub_uni_index,ascii_index},
   {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
   OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   NULL,NULL,SKF_UCS | SKF_UCS_PUNY,L_NU,"Unicode(TM) Punycode",
   "punycode"},
  {SKF_JIS,0,			/* Nr.107 cp437			   */
   {ub_uni_index,ascii_index},{-1,-1},{ub_misc_index,cp437_index},
   {-1,-1},{-1,-1},{-1,-1},0,
   OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   NULL,NULL,SKF_JIS | USE_JIS8 | COD_HIDE,
   L_NU,"Microsoft(TM) codepage 437","cp437"},
  {SKF_JIS,0,			/* Nr.108 CP1252		   */
    {ub_uni_index,ascii_index},{-1,-1},{ub_misc_index,cp1252_index},
    {-1,-1},{-1,-1},{ub_misc_index,cp1250_index},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | USE_JIS8 | COD_HIDE,
    L_BG,"MS cp1252","cp1252"},
  {SKF_UCS | SKF_UCS_UTF8,0,	/* Nr.109 UTF8-BOM		   */
   {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
   OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   NULL,NULL,SKF_UCS | SKF_BIG_ENDIAN | SKF_UCS_UTF8 | SKF_ADD_BOM,
   L_NU,"Unicode(TM) UTF-8-BOM","utf-8-bom"},
  {SKF_UCS | SKF_UCS_UTF16,0,	/* Nr.110 UTF-16-LE wo BOM	   */
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
   OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   NULL,NULL,SKF_UCS | SKF_UCS_UTF16 | SKF_NOT_ASCII,
   L_NU,"Unicode(TM) UTF-16LE","utf-16le"},
  {SKF_UCS | SKF_UCS_UTF16,0,	/* Nr.111 UTF-16-BE wo BOM	   */
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
   OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   NULL,NULL,SKF_UCS | SKF_UCS_UTF16 | SKF_BIG_ENDIAN | SKF_NOT_ASCII,
   L_NU,"Unicode(TM) UTF-16BE","utf-16be"},
  {SKF_JIS,0,				/* Nr.112 iso2022-jp-1	   */
    {ub_uni_index,x0201_index}, 
    {ub_3db_index,x0208_index},{ub_uni_index,x0201r_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0212_index},
    {-1,-1},OMAP_NSG,
    OI_ASCI_X201,OI_LATN_X208,OI_SYMBL_X208,OI_KANA_X208,-1,
    OI_KANJI_X208,-1,-1,OI_CMP_X208,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_x201_208,SKF_JIS | SKF_COD_MB | SKF_USE_X0212,
    L_JA,"iso-2022-jp-1 (rfc1554)","iso-2022-jp-1"},
  {SKF_UCS | SKF_UCS_UTF32,0,	/* Nr.113 UTF-32-LE		   */
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
   OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   NULL,NULL,SKF_UCS | SKF_UCS_UTF32 | SKF_ADD_BOM | SKF_NOT_ASCII,
   L_NU,"Unicode(TM) UTF-32LE-BOM","utf-32le-bom"},
  {SKF_UCS | SKF_UCS_UTF32,0,	/* Nr.114 UTF-32-BE		   */
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
   OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   NULL,NULL,
   SKF_UCS | SKF_UCS_UTF32 | SKF_BIG_ENDIAN | SKF_ADD_BOM | SKF_NOT_ASCII,
   L_NU,"Unicode(TM) UTF-32BE-BOM","utf-32be-bom"},
  {SKF_UCS | SKF_UCS_UTF32,0,	/* Nr.115 UTF-32-LE-NOBOM	   */
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
   OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   NULL,NULL,SKF_UCS | SKF_UCS_UTF32 | SKF_NOT_ASCII,
   L_NU,"Unicode(TM) UTF-32LE","utf-32le"},
  {SKF_UCS | SKF_UCS_UTF32,0,	/* Nr.116 UTF-32-BE-NOBOM	   */
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
   OI_ASCI_ASCII,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
   NULL,NULL,SKF_UCS | SKF_UCS_UTF32 | SKF_BIG_ENDIAN | SKF_NOT_ASCII,
   L_NU,"Unicode(TM) UTF-32BE","utf-32be"},
  {SKF_MS,0, 			/* Nr.117 x-0208(cp932 base)	   */
  	/* canonical name should be registered one here, for mime  */
	/*  use this one.					   */
    {ub_uni_index,ascii_index},
    {ub_3db_index,cp932_index},{ub_uni_index,x0201r_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0212_index},
    {ub_uni_index,x0201r_index},OMAP_NSG,
    OI_ASCI_ASCII,OI_LATN_CP932,OI_SYMBL_CP932,OI_KANA_CP932,-1,
    OI_KANJI_CP932,-1,-1,OI_CMP_CP932,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,o_patch_cp932,SKF_JIS | SKF_JIS_932 | SKF_COD_MB | COD_HIDE,
    L_JA,"iso-2022-jp (cp932)","iso-2022-jp"},
  {SKF_MS ,0, 		/* Nr.118 x-0208:new-jyoyou-kanji	   */
    {ub_uni_index,ascii_index}, {ub_uni_index,x0201r_index},
    {ub_miscm_index,x0208nj_index},
    {ub_8859_index,iso8859_1_index},{ub_4db_index,x0212_index},
    {ub_uni_index,x0201r_index},OMAP_NSG,
    OI_ASCI_ASCII,OI_LATN_X208,OI_SYMBL_X208,OI_KANA_X208,-1,
    OI_KANJI_X208NJ,-1,-1,OI_CMP_X208,OI_CJK_B_X208NJ,-1,-1,-1,-1,
    -1,-1,-1,
    NULL,NULL, SKF_MS | SKF_COD_MB | SKF_USE_X0212 | COD_HIDE,
    L_JA,"New-Jyouyou-kanji(x0208 based)","jis-x0208-nj"},
  {SKF_MS | SKF_MS_NTT,0, 	/* Nr.119 SJIS(KDD*-phone)	   */
    {ub_uni_index,x0201_index},{ub_uni_index,x0201r_index},
    {ub_3db_index,cp932_index},{ub_ovlay_index,auemot_index},
    {-1,-1}, {ub_uni_index,x0201r_index},0,
    OI_ASCI_X201,OI_LATN_CELA,OI_SYMBL_CELA,OI_KANA_CELA,-1,
    OI_KANJI_X208,-1,-1,OI_CMP_X208,-1,-1,-1,-1,OI_NOT_CELA,
    -1,-1,-1,NULL,o_patch_x201_208,
    SKF_MS | SKF_MS_NTT | SKF_COD_MB | SKF_MS_COMPAT,
    L_JA,"Shift_JIS (AU-glyph)","sjis-au"},
  {SKF_MS | SKF_MS_NTT,0, 	/* Nr.120 SJIS(SoftB*nk-phone)	   */
    {ub_uni_index,x0201_index},{ub_uni_index,x0201r_index},
    {ub_3db_index,cp932_index},{ub_ovlay_index,sbemot_index},
    {-1,-1}, {ub_uni_index,x0201r_index},0,
    OI_ASCI_X201,OI_LATN_CELS,OI_SYMBL_CELS,OI_KANA_CELS,-1,
    OI_KANJI_X208,-1,-1,OI_CMP_X208,-1,-1,-1,-1,OI_NOT_CELS,
    -1,-1,-1,NULL,o_patch_x201_208,
    SKF_MS | SKF_MS_NTT | SKF_COD_MB | SKF_MS_COMPAT,
    L_JA,"Shift_JIS (SoftBank-glyph)","sjis-softbank"},
  {SKF_MS | SKF_MS_NTT,0, 	/* Nr.121 SJIS(OLD-DoC*mo-phone)   */
    {ub_uni_index,x0201_index},{ub_uni_index,x0201r_index},
    {ub_3db_index,cp932_index}, {ub_ovlay_index,nttgrc1_index},
    {-1,-1}, {ub_uni_index,x0201r_index},0,
    OI_ASCI_X201,OI_LATN_X208,OI_SYMBL_X208,OI_KANA_X208,-1,
    OI_KANJI_X208,-1,-1,OI_CMP_X208,-1,-1,-1,-1,OI_NOT_CELS,
    -1,-1,-1,NULL,o_patch_x201_208,
    SKF_MS | SKF_MS_NTT | SKF_COD_MB | SKF_MS_COMPAT,
    L_JA,"Shift_JIS (oldntt-glyph)","sjis-oldntt"},
  {SKF_UCS | SKF_UCS_UTF8,0, 	/* Nr.122 NYUKAN GAIJI(UTF8)	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_NYUKAN,OI_SYMBL_NYUKAN,OI_KANA_NYUKAN,
    OI_CJK_A_NYUKAN,OI_KANJI_NYUKAN,-1,-1,OI_CMP_NYUKAN,OI_CJK_B_NYUKAN,
    OI_CJK_C_NYUKAN,OI_PRV_NYUKAN,-1,-1,-1,-1,-1,NULL,NULL,
    SKF_UCS | SKF_UCS_UTF8,
    M_JP,"NYUKAN GAIJI UTF-8","nyukan-utf-8"},
  {SKF_UCS | SKF_UCS_UTF16,0,	/* Nr.123 NYUKAN GAIJI(UTF16)	   */
    {ub_uni_index,ascii_index},
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_NYUKAN,OI_SYMBL_NYUKAN,OI_KANA_NYUKAN,
    OI_CJK_A_NYUKAN,OI_KANJI_NYUKAN,-1,-1,OI_CMP_NYUKAN,OI_CJK_B_NYUKAN,
    OI_CJK_C_NYUKAN,OI_PRV_NYUKAN,-1,-1,-1,-1,-1,NULL,NULL,
    SKF_UCS | SKF_UCS_UTF16 | SKF_ADD_BOM | SKF_NOT_ASCII | SKF_BIG_ENDIAN,
    M_JP,"NYUKAN GAIJI UTF-16BE","nyukan-utf-16"},
  {SKF_JIS | SKF_USE_8BIT,0, 	/* Nr.124 KOI-8-u		   */
    {ub_uni_index,ascii_index},
    {-1,-1},{ub_misc_index,koi8_u_index},{-1,-1},{-1,-1},
    {ub_misc_index,koi8_u_index},0,
    OI_ASCI_ASCII,OI_LATN_KOI8U,OI_SYMBL_KOI8U,-1,-1,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | SKF_USE_8BIT,L_UK,"US ascii+KOI8-U","koi8-u"},
  {SKF_JIS ,0, 			/* Nr.125 ASCII-8BIT		   */
    {ub_uni_index,ascii_index},{ub_uni_index,x0201r_index},
    {-1,-1}, {-1,-1},
    {-1,-1}, {-1,-1},0,
    OI_ASCI_ASCII,OI_LATN_X208,OI_SYMBL_X208,OI_KANA_X208,-1,
    OI_KANJI_X208,-1,-1,OI_CMP_X208,-1,-1,-1,-1,-1,
    -1,-1,-1,NULL,o_patch_x201_208,
    SKF_JIS,
    L_JA,"8bit BINARY","8bit-binary"},
  {SKF_JIS,0,			/* Nr.126 locale(dummy)		   */
    {ub_uni_index,ascii_index}, 
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_JIS | COD_HIDE,L_US,"Locale","locale"},
#ifdef ARIB_SUPPORT
  {SKF_MS,0,			/* Nr.127 ARIB-B24-SI(SJIS)	   */
    {ub_uni_index,ascii_index}, 
    {-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},0,
    OI_ASCI_ASCII,-1,-1,-1,-1,
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_MS | COD_HIDE,M_JP,"arib-b24-si","arib-b24-si"},
#endif
  {SKF_COD_INVALID,0,{-1,-1},{-1,-1},{-1,-1},{-1,-1},{-1,-1},
    {-1,-1},0,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
    NULL,NULL,SKF_COD_INVALID,L_US,NULL,NULL}	/* tail		   */
};

/* --------------------------------------------------------------- */
/* Unicode to output coding tables				   */
/* --------------------------------------------------------------- */
unsigned short *uni_o_ascii = NULL;
unsigned short *uni_o_latin = NULL;
unsigned short *uni_o_symbol = NULL;
unsigned short *uni_o_kana = NULL;
unsigned short *uni_o_cjk_a = NULL;
unsigned short *uni_o_kanji = NULL;
unsigned short *uni_o_y = NULL;
unsigned short *uni_o_hngl = NULL;
unsigned short *uni_o_compat = NULL;
unsigned short *uni_o_cjk_b = NULL;
unsigned short *uni_o_cjk_c = NULL;
unsigned short *uni_o_upkana = NULL;
unsigned short *uni_o_prv = NULL;
unsigned short *uni_o_hist = NULL;
unsigned short *uni_o_note = NULL;
unsigned short *uni_o_upmisc = NULL;

struct out_codetbl_defs *uni_o_ascii_defs = NULL;
struct out_codetbl_defs *uni_o_latin_defs = NULL;
struct out_codetbl_defs *uni_o_symbol_defs = NULL;
struct out_codetbl_defs *uni_o_kana_defs = NULL;
struct out_codetbl_defs *uni_o_cjk_a_defs = NULL;
struct out_codetbl_defs *uni_o_kanji_defs = NULL;
struct out_codetbl_defs *uni_o_y_defs = NULL;
struct out_codetbl_defs *uni_o_hngl_defs = NULL;
struct out_codetbl_defs *uni_o_compat_defs = NULL;
struct out_codetbl_defs *uni_o_cjk_b_defs = NULL;
struct out_codetbl_defs *uni_o_cjk_c_defs = NULL;
struct out_codetbl_defs *uni_o_upkana_defs = NULL;
struct out_codetbl_defs *uni_o_prv_defs = NULL;
struct out_codetbl_defs *uni_o_hist_defs = NULL;
struct out_codetbl_defs *uni_o_note_defs = NULL;
struct out_codetbl_defs *uni_o_upmisc_defs = NULL;

/* --------------------------------------------------------------- */
/* --- Note - for configuration reason, supported charset is	   */
/*  iso2022-jp-1, iso2022-jp-2, iso2022-jp-3, ks-x-1001, gb-2312   */
/* --------------------------------------------------------------- */

#if !defined(OUTPUT_DYNAMIC_TABLE) 
/*@-kepttrans@*/ /*@-immediatetrans@*/ /*@-unqualifiedtrans@*/
/*@-globstate@*/
void skf_output_table_set()
{
    int i;
/* --- codeset table setupper ------------------------------------ */
    if (sup_jis90) output_codeset_fix_table(o_patch_jis90_to_83);
    if ((uni_o_symbol != NULL) && chart_dsbl) {
	for (i=0;i<0x80;i++) {	/* wipe out definitions  */
	    uni_o_symbol[0x500+i] = 0;
	};
    };
    if (enable_cellconvert && is_ucs_ufam(conv_cap)) {
    	if (ovlay_byte_defs[unicode_p2m_index].uniltbl == NULL) {
	    in_tablefault(SKF_TBLUNDEF,"unicode_p2m");
	} else;
    } else;
}

/* --------------------------------------------------------------- */
/* codeset specific table patcher				   */
/* --------------------------------------------------------------- */
/*@-globstate@*/
void output_codeset_fix_table(fixt)
const long	*fixt;
{
    long	fixb;
    unsigned short fixu;

    if (fixt != NULL) {	/* if fixtable exist			   */
	while (*fixt > 0) {
	    fixb = *(fixt++); fixu = (unsigned short) (*(fixt++));
	    if ((fixb >= 0x00) && (fixb <= A_DEL)) {
		uni_o_ascii[fixb] = fixu;
	    } else if ((fixb >= LATIN_TBL_START) && (fixb < GLYPH_TBL_START)) {
		if (uni_o_latin != NULL) {
		    uni_o_latin[fixb - LATIN_TBL_START] = fixu;
		};
	    } else if ((fixb >= GLYPH_TBL_START) && (fixb < KANA_TBL_START)) {
		if (uni_o_symbol != NULL) {
		    uni_o_symbol[fixb - GLYPH_TBL_START] = fixu;
		};
	    } else if ((fixb >= KANA_TBL_START) && (fixb < CJK_A_TBL_START)) {
		if (uni_o_kana != NULL) {
		    uni_o_kana[fixb - KANA_TBL_START] = fixu;
		};
	    } else if ((fixb >= CJK_A_TBL_START) && (fixb < CJK_TBL_START)) {
		if (uni_o_cjk_a != NULL) {
		    uni_o_cjk_a[fixb - CJK_A_TBL_START] = fixu;
		};
	    } else if ((fixb >= CJK_TBL_START) && (fixb < Y_TBL_START)) {
		if (uni_o_kanji != NULL) {
		    uni_o_kanji[fixb - CJK_TBL_START] = fixu;
		};
	    } else if ((fixb >= Y_TBL_START) && (fixb < HNGL_TBL_START)) {
		if (uni_o_y != NULL) {
		    uni_o_y[fixb - Y_TBL_START] = fixu;
		};
	    } else if ((fixb >= HNGL_TBL_START) && (fixb <= HNGL_TBL_END)) {
		if (uni_o_hngl != NULL) {
		    uni_o_hngl[fixb - HNGL_TBL_START] = fixu;
		};
	    } else if ((fixb >= PRV_TBL_START) && (fixb < CPT_TBL_START)) {
		if (uni_o_prv != NULL) {
		    uni_o_prv[fixb - PRV_TBL_START] = fixu;
		};
	    } else if ((fixb >= CPT_TBL_START) && (fixb <= CPT_TBL_END)) {
		if (uni_o_compat != NULL) {
		    uni_o_compat[fixb - CPT_TBL_START] = fixu;
		};
	    } else if ((fixb >= HIST_TBL_START) && (fixb <= HIST_TBL_END)) {
		if (uni_o_hist != NULL) {
		    uni_o_hist[fixb - HIST_TBL_START] = fixu;
		};
	    } else if ((fixb >= UPMISC_TBL_START) && (fixb <= UPMISC_TBL_END)) {
		if (uni_o_upmisc != NULL) {
		    uni_o_upmisc[fixb - UPMISC_TBL_START] = fixu;
		};
	    } else if ((fixb >= UPKANA_TBL_START) && (fixb <= UPKANA_TBL_END)) {
		if (uni_o_upkana != NULL) {
		    uni_o_upkana[fixb - UPKANA_TBL_START] = fixu;
		};
	    } else if ((fixb >= NOTE_TBL_START) && (fixb <= NOTE_TBL_END)) {
		if (uni_o_note != NULL) {
		    uni_o_note[fixb - NOTE_TBL_START] = fixu;
		};
	    } else if ((fixb >= CJK_B_TBL_START) && (fixb <= CJK_B_TBL_END)) {
		if (uni_o_cjk_b != NULL) {
		    uni_o_cjk_b[fixb - CJK_B_TBL_START] = fixu;
		};
	    } else if ((fixb >= CJK_C_TBL_START) && (fixb <= CJK_C_TBL_END)) {
		if (uni_o_cjk_c != NULL) {
		    uni_o_cjk_c[fixb - CJK_C_TBL_START] = fixu;
		};
	    } else {
		skferr(SKF_OUTPATCHERR,(long)fixb,(long)fixu);
		skf_exit(EXIT_FAILURE);
	    };
	};
    };

    if (use_htmlsanitize && !(use_latin2tex)) {
	uni_o_ascii[0x22] = 0;	/* &quot;	*/
	uni_o_ascii[0x23] = 0;	/* &num;	*/
	uni_o_ascii[0x24] = 0;	/* &dollar;	*/
	uni_o_ascii[0x25] = 0;	/* &perc;	*/
	uni_o_ascii[0x26] = 0;	/* &amp;	*/
	uni_o_ascii[0x27] = 0;	/* &apostoroph;	*/
	uni_o_ascii[0x28] = 0;	/* &lpar;	*/
	uni_o_ascii[0x29] = 0;	/* &rpar;	*/
	uni_o_ascii[0x2f] = 0;	/* &sol;	*/
	uni_o_ascii[0x3a] = 0;	/* &colon;	*/
	uni_o_ascii[0x3b] = 0;	/* &semi;	*/
	uni_o_ascii[0x3c] = 0;	/* &lt;		*/
	uni_o_ascii[0x3e] = 0;	/* &gt;		*/
	uni_o_ascii[0x3f] = 0;	/* &quest;	*/
	uni_o_ascii[0x5c] = 0;	/* &sbsol;	*/
    };
}

/* --------------------------------------------------------------- */
/* Output table loader						   */
/* --------------------------------------------------------------- */
#define OTBL_ISO	1
#define OTBL_NISO	0

#define OTBL_MUL	1
#define OTBL_SNG	0

/*@-nullret@*/ /*@-nullpass@*/ /* Both seems to be OK */
/*@+boolint@*/ /*@+ignorequals@*/ /*@-nullderef@*/
/*@-paramuse@*//*@-usereleased@*/
unsigned short *skf_otable_loader(defschar,id,iso,set,siz)
char	defschar,id;
int	iso,set;
long	siz;
{
    unsigned short	*utable = NULL;
#if defined(DYNAMIC_LOADING) && !defined(SWIG_EXT)
    char	*table_name;
    char	*magic;
    int 	i,j,k,fail = 0;
    FILE	*table;
    char	ch;

    if ((table_name = calloc(SKF_TABLE_PATH,sizeof(char))) == NULL) {
	skferr(SKF_MALLOCERR,(long)SKF_TABLE_PATH,0);
	skf_exit(EXIT_FAILURE);
    };
    ch = ((iso) && (defschar >= '@')) ? 
		(charname_conv[defschar-0x40]) : defschar;
#if	defined(_WIN32) || defined(__MINGW32__) || defined(SKF_MINGW)
    if ((snprintf(table_name,SKF_TABLE_PATH-2,"%s\\o%cM%c%c%c.stb",
#else
    if ((snprintf(table_name,SKF_TABLE_PATH-2,"%s/o%cM%c%c%c.stb",
#endif
		skf_ext_table,
		(iso ?	'I' : 'N'),
    /* call letter capitalize, for windows are case insensitive	   */
		(((ch >= 'a') && (ch <= 'z')) ?
		(set ?	'N' : 'T') : 
		(set ?	'M' : 'S')), SKFtoupper(ch),
		id)) < 0) {
					/* truncated due to size   */
	skferr(SKF_TBLALLOCERR,(long)ch,0);
	skf_exit(EXIT_FAILURE);
    };
#ifdef SKFDEBUG
    if (is_vv_debug)
	fprintf(stderr," - loading table:%s (%ldByte)",table_name,
		siz+siz+12);	/* 12 is length of header	   */
#endif

    if ((table = fopen(table_name,SKF_INMODE)) == NULL) {
				/* failed to open		   */
	in_tablefault(SKF_TBLBROKN,table_name);
	fail = 1;
    } else {			/* can open. Then test magic	   */
	i = 0;
	magic = skf_table_magic;
	while (*magic != '\0') {
	    if (*magic++ != getc(table)) {
		if (disp_warn) {in_tablefault(SKF_TBLINCNSIS,table_name);};
		fail = 1; break;
	    };
	};
	if ((utable = calloc((size_t)siz,sizeof(unsigned short)))
		== NULL) {
	    skferr(SKF_TBLALLOCERR,(long)siz,0);
	    skf_exit(EXIT_FAILURE);
	};
    };


    if (fail == 0) {
      for (i=0;i<siz; i++) {
	/* table is stored using big endian			   */
	if ((j = getc(table)) == EOF) {
	    fail = 1; free(utable); break;
	};
	if ((k = getc(table)) == EOF) {
	    fail = 1; free(utable); break;
	};
	utable[i] = (unsigned short)(((j << 8) + k) & 0xffff);
      }; 
    };
    if (fail != 0) {
	in_tablefault(SKF_TBLSHORT,table_name);
	if (utable != NULL) free(utable);
	free(table_name);
	return(NULL);
#ifdef SKFDEBUG
    } else {
	if (is_vv_debug) fprintf(stderr,"... finished\n");
#endif
    };
    free(table_name); 

#endif	/* DYNAMIC LOADING */
    return(utable);
}

/* --------------------------------------------------------------- */
/* Output table presetter					   */
/* --------------------------------------------------------------- */
/* Note :							   */
/*  skf can hold at most 4+1 charset per a codeset. Each area in   */
/*  table can have 4 charset, but override with following priority */
/*  latin < cjk < kanji < hangle. Other definitions are ignored.   */
/* --------------------------------------------------------------- */
/* input: parse - output codeset index in ocodeset		   */
/* output: none (ignored if failed)				   */
/* side_effect: g*_table_mod, g*_* are set, conv_cap is set	   */
/* --------------------------------------------------------------- */
static char mid_defs_char[] = {0x28,0x2c,0x21,'$','$',0,0};
static char midl_defs_char[] = {0,0,0x28,0,'(',0,0};

/*@-globstate@*/ /* yes. it may use null-param */
void skf_charset_parser(parse)
int	parse;
{
    struct in_codeset_defs *ocodeset;

    unsigned long	rcodeset;	/* raw value		   */
    int		ti,ii;

#ifdef SKFDEBUG
    if (is_vvv_debug) {
    	fprintf(stderr,"-SKF_CODESET(%d):",parse);
    };
#endif
    ocodeset = NULL;

/* --- codeset decoder ------------------------------------------- */
    if (parse < codeset_end) {
	out_codeset = parse;
    } else {
	error_code_option(parse);
	out_codeset = DEFAULT_O;
    };

/* --- kicks some unsupported codesets --------------------------- */
    if (out_codeset == codeset_jef) {
    	out_tablefault(SKF_NOOUT);
	skf_exit(EXIT_FAILURE);
    } else if ((out_codeset == codeset_transp) 
    	|| (out_codeset == codeset_var)) {
    	out_tablefault(SKF_NOOUT);
	skf_exit(EXIT_FAILURE);
    } else;

/* --------------------------------------------------------------- */
/* nkf compatibility fix.					   */
/* --------------------------------------------------------------- */
    if (is_nkf_compat) {
#ifdef SHIFTJIS_CP932
	if (is_cp932_ext) {
	    if (out_codeset == codeset_sjis) {
		out_codeset = codeset_cp932;
	    } else if (out_codeset == codeset_eucjp) {
		out_codeset = codeset_cp51932;
	    } else if (out_codeset == codeset_jis) {
		out_codeset = codeset_jisms;
	    } else;
	} else;
#endif
	if (is_nocp932_ext) {
	    if (out_codeset == codeset_cp932) {
		out_codeset = codeset_sjis;
	    } else if (out_codeset == codeset_cp51932) {
		out_codeset = codeset_cp20932;
	    } else if (out_codeset == codeset_jisms) {
		out_codeset = codeset_jis;
	    } else;
	} else;
	/* nkf only supports jis x-0213(2004). These canonical name */
	/* is not the right one, but a bug also is a spec anyway.  */
	if (out_codeset == codeset_euc_213) {
	    out_codeset = codeset_euc_213a;
	} else if (out_codeset == codeset_x0213) {
	    out_codeset = codeset_x213a;
	} else if (out_codeset == codeset_sj_0213) {
	    out_codeset = codeset_sj_213a;
	} else;
    } else;
/* --------------------------------------------------------------- */
    /* some encoding override parsed codeset			   */

    ocodeset = &(i_codeset[out_codeset]);
/* -- show what I got -------------------------------------------- */
    /* temporal patch */
    if (ocodeset != NULL) {

/* --------------------------------------------------------------- */
/* setting table for output codeset				   */
/* --------------------------------------------------------------- */
      rcodeset = (ocodeset->oconv_type);
      set_ocode_codeset((ocodeset->oconv_type));/* conv_cap	   */
      skf_output_lang = ocodeset->oconv_lang;	/* language	   */

#ifdef SKFDEBUG
      if (is_vv_debug) { 
	if (is_ucs_ufam(conv_cap)) {
	  fprintf(stderr," unicode family\n");
	} else {
	  fprintf(stderr," %d %d %d %d",
		  ocodeset->o_iso_ascii_index,
		  ocodeset->o_iso_latin_index,
		  ocodeset->o_iso_symbol_index,
		  ocodeset->o_iso_kana_index);
	  fprintf(stderr," %d %d %d %d",ocodeset->o_iso_cjk_a_index,
		  ocodeset->o_iso_kanji_index,
		  ocodeset->o_iso_y_index,
		  ocodeset->o_iso_hngl_index);
	  fprintf(stderr," %d %d %d %d",ocodeset->o_iso_compat_index,
		  ocodeset->o_iso_cjk_b_index,
		  ocodeset->o_iso_cjk_c_index,
		  ocodeset->o_iso_prv_index);
	  fprintf(stderr," %d %d %d %d\n",ocodeset->o_iso_his_index,
		  ocodeset->o_iso_note_index,
		  ocodeset->o_iso_upkana_index,
		  ocodeset->o_iso_upmisc_index);
	  }; 
      }; 
#endif
/* --------------------------------------------------------------- */
/* after this point, we can use conv_cap value as codeset features */
/* --------------------------------------------------------------- */
/* set paramters for fifth quadrant				   */
/* --------------------------------------------------------------- */
      ti = ocodeset->g0def.tbl_index;
      ii = ocodeset->g0def.index;
      if (use_g0ascii) {	/* swap g0 to ascii		   */
	ti = ub_uni_index;
	ii = ascii_index;
      };
      if (ti >= 0) {
	  if (k_out != 0) {
	      g0_char = k_out;
	  } else {	/* force swap g0_char for user order	   */
	      g0_char = iso_ubytedef_table[ti].ientry[ii].defschar;
	  };
	  g0_typ = iso_ubytedef_table[ti].ientry[ii].is_kana;
	  g0_mid = mid_defs_char[ti];
	  g0_midl = midl_defs_char[ti];
      };
#ifdef SKFDEBUG
      if ((is_v_debug) && !is_ucs_ufam(conv_cap)) 
	fprintf(stderr,"G0 charset: %s  ",
	 ((ti < 0) ?  "-" : iso_ubytedef_table[ti].ientry[ii].desc));
#endif
      ti = ocodeset->g0adef.tbl_index;
      ii = ocodeset->g0adef.index;
      if (ti >= 0) {
      	  if (k_in != 0) {
	      ag0_char = k_in;
          } else if (out_codeset == codeset_jisms) {
	      ag0_char = 'B';
	  } else {
	      ag0_char = iso_ubytedef_table[ti].ientry[ii].defschar;
	  };
	  ag0_typ = iso_ubytedef_table[ti].ientry[ii].is_kana;
	  if (is_jis_jis(conv_cap) && is_quad_char)
		ag0_typ |= COD_MB_4;
	  ag0_mid = mid_defs_char[ti];
	  ag0_midl = midl_defs_char[ti];
      };
#ifdef SKFDEBUG
      if ((is_v_debug) && !is_ucs_ufam(conv_cap)) 
	fprintf(stderr,"G0A charset: %s\n", 
	 ((ti < 0) ?  "-" : iso_ubytedef_table[ti].ientry[ii].desc));
#endif
      ti = ocodeset->g1def.tbl_index;
      ii = ocodeset->g1def.index;
      if (ti >= 0) {
	  g1_char = iso_ubytedef_table[ti].ientry[ii].defschar;
	  g1_typ = iso_ubytedef_table[ti].ientry[ii].is_kana;
	  g1_mid = mid_defs_char[ti];
	  g1_midl = midl_defs_char[ti];
      };
#ifdef SKFDEBUG
      if ((is_v_debug) && !is_ucs_ufam(conv_cap)) 
	fprintf(stderr,"G1 charset: %s  ", 
	 ((ti < 0) ?  "-" : iso_ubytedef_table[ti].ientry[ii].desc));
#endif
      ti = ocodeset->g2def.tbl_index;
      ii = ocodeset->g2def.index;
      if (ti >= 0) {
	  g2_char = iso_ubytedef_table[ti].ientry[ii].defschar;
	  g2_typ = iso_ubytedef_table[ti].ientry[ii].is_kana;
	  g2_mid = mid_defs_char[ti];
	  g2_midl = midl_defs_char[ti];
      };
#ifdef SKFDEBUG
      if ((is_v_debug) && !is_ucs_ufam(conv_cap)) 
	fprintf(stderr,"G2 charset: %s\n", 
	 ((ti < 0) ?  "-" : iso_ubytedef_table[ti].ientry[ii].desc));
#endif
      ti = ocodeset->g3def.tbl_index;
      ii = ocodeset->g3def.index;
      if (ti >= 0) {
	  g3_char = iso_ubytedef_table[ti].ientry[ii].defschar;
	  g3_typ = iso_ubytedef_table[ti].ientry[ii].is_kana;
	  g3_mid = mid_defs_char[ti];
	  g3_midl = midl_defs_char[ti];
      };
#ifdef SKFDEBUG
      if ((is_v_debug) && !is_ucs_ufam(conv_cap)) 
	fprintf(stderr,"G3 charset: %s  ", 
	 ((ti < 0) ?  "-" : iso_ubytedef_table[ti].ientry[ii].desc));
#endif
      ti = ocodeset->ogldef.tbl_index;
      ii = ocodeset->ogldef.index;
      if (ti >= 0) {
	  g4_char = iso_ubytedef_table[ti].ientry[ii].defschar;
	  g4_typ = iso_ubytedef_table[ti].ientry[ii].is_kana;
	  g4_mid = mid_defs_char[ti];
	  g4_midl = midl_defs_char[ti];
      };
#ifdef SKFDEBUG
      if ((is_v_debug) && !is_ucs_ufam(conv_cap)) 
	fprintf(stderr,"ALT charset: %s\n", 
	 ((ti < 0) ?  "-" : iso_ubytedef_table[ti].ientry[ii].desc));
#endif

      if (ocodeset->hook != NULL) {	/* table generation	   */
	  (ocodeset->hook)();
      };

/* -- main table loader ------------------------------------------ */
/*  fill undefined code tables with external tables.		   */
/* {'N','K','C','L','G','H','A','B','Y','X','P','S','I','O','-','-'} */

      if (use_g0ascii || (ocodeset->o_iso_ascii_index >= 0)) {
	  if (use_g0ascii)
	      uni_o_ascii_defs = &(o_iso_ascii_defs[OI_ASCI_ASCII]);
	  else	/* ocodeset->o_iso_ascii_index >= 0 */
	      uni_o_ascii_defs = 
	      	&(o_iso_ascii_defs[ocodeset->o_iso_ascii_index]);
	  if ((uni_o_ascii = uni_o_ascii_defs->otbl) == NULL) {
		uni_o_ascii_defs->otbl = 
		    skf_otable_loader(uni_o_ascii_defs->defschar,'S',
		      is_cod_iso(rcodeset),
		      is_cod_mb(rcodeset),
		      uni_o_ascii_defs->tbl_len);
	  };
	  if ((uni_o_ascii = uni_o_ascii_defs->otbl) == NULL) {
		in_tablefault(SKF_OTBLINCNSIS,"ascii");
	  };
      } else;	/* o_iso_ascii_index = -1 and !use_g0ascii */

      if (ocodeset->o_iso_latin_index >= 0) {
	uni_o_latin_defs = 
		&(o_iso_latin_defs[ocodeset->o_iso_latin_index]);
	if ((uni_o_latin = uni_o_latin_defs->otbl) == NULL) {
	    uni_o_latin_defs->otbl = 
		skf_otable_loader(uni_o_latin_defs->defschar,'L',
		  is_cod_iso(rcodeset),
		  is_cod_mb(rcodeset),
		  uni_o_latin_defs->tbl_len);
	    if ((uni_o_latin = uni_o_latin_defs->otbl) == NULL) {
		in_tablefault(SKF_OTBLINCNSIS,"latin");
	    };
	};
      };
      if (ocodeset->o_iso_symbol_index >= 0) {
	uni_o_symbol_defs = 
		&(o_iso_symbol_defs[ocodeset->o_iso_symbol_index]);
	if ((uni_o_symbol = uni_o_symbol_defs->otbl) == NULL) {
	    uni_o_symbol_defs->otbl = 
		skf_otable_loader(uni_o_symbol_defs->defschar,'G',
		  is_cod_iso(rcodeset),
		  is_cod_mb(rcodeset),
		  uni_o_symbol_defs->tbl_len);

	    if ((uni_o_symbol = uni_o_symbol_defs->otbl) == NULL) {
		in_tablefault(SKF_OTBLINCNSIS,"symbol");
	    };
	} else uni_o_symbol = uni_o_symbol_defs->otbl;
      };
      if (ocodeset->o_iso_kana_index >= 0) {
	uni_o_kana_defs = 
		&(o_iso_kana_defs[ocodeset->o_iso_kana_index]);
	if ((uni_o_kana = uni_o_kana_defs->otbl) == NULL) {
	    uni_o_kana_defs->otbl = 
		skf_otable_loader(uni_o_kana_defs->defschar,'N',
		  is_cod_iso(rcodeset),
		  is_cod_mb(rcodeset),
		  uni_o_kana_defs->tbl_len);

	    if ((uni_o_kana = uni_o_kana_defs->otbl) == NULL) {
		in_tablefault(SKF_OTBLINCNSIS,"kana");
	    };
	} else uni_o_kana = uni_o_kana_defs->otbl;
      };
      if (ocodeset->o_iso_kanji_index >= 0) {
	uni_o_kanji_defs =
		&(o_iso_cjk_defs[ocodeset->o_iso_kanji_index]);
	if ((uni_o_kanji = uni_o_kanji_defs->otbl) == NULL) {
	    uni_o_kanji_defs->otbl = 
		skf_otable_loader(uni_o_kanji_defs->defschar,'K',
		  is_cod_iso(rcodeset),
		  is_cod_mb(rcodeset),
		  uni_o_kanji_defs->tbl_len);

	    if ((uni_o_kanji = uni_o_kanji_defs->otbl) == NULL) {
		in_tablefault(SKF_OTBLINCNSIS,"kanji");
	    };
	};
      };
      if (ocodeset->o_iso_cjk_a_index >= 0) {
	uni_o_cjk_a_defs = 
		&(o_iso_cjk_a_defs[ocodeset->o_iso_cjk_a_index]);
	if ((uni_o_cjk_a = uni_o_cjk_a_defs->otbl) == NULL) {
	    uni_o_cjk_a_defs->otbl = 
		skf_otable_loader(uni_o_cjk_a_defs->defschar,'A',
		  is_cod_iso(rcodeset),
		  is_cod_mb(rcodeset),
		  uni_o_cjk_a_defs->tbl_len);

	    if ((uni_o_cjk_a = uni_o_cjk_a_defs->otbl) == NULL) {
		in_tablefault(SKF_OTBLINCNSIS,"cjk_a");
	    };
	};
      };
      if (ocodeset->o_iso_cjk_b_index >= 0) {
	uni_o_cjk_b_defs = 
		&(o_iso_cjk_b_defs[ocodeset->o_iso_cjk_b_index]);
	if ((uni_o_cjk_b = uni_o_cjk_b_defs->otbl) == NULL) {
	    uni_o_cjk_b_defs->otbl = 
		skf_otable_loader(uni_o_cjk_b_defs->defschar,'B',
		  is_cod_iso(rcodeset),
		  is_cod_mb(rcodeset),
		  uni_o_cjk_b_defs->tbl_len);

	    if ((uni_o_cjk_b = uni_o_cjk_b_defs->otbl) == NULL) {
		in_tablefault(SKF_OTBLINCNSIS,"cjk_b");
	    };
	};
      };
      if (ocodeset->o_iso_cjk_c_index >= 0) {
	uni_o_cjk_c_defs = 
		&(o_iso_cjk_c_defs[ocodeset->o_iso_cjk_c_index]);
	if ((uni_o_cjk_c = uni_o_cjk_c_defs->otbl) == NULL) {
	    uni_o_cjk_c_defs->otbl = 
		skf_otable_loader(uni_o_cjk_c_defs->defschar,'X',
		  is_cod_iso(rcodeset),
		  is_cod_mb(rcodeset),
		  uni_o_cjk_c_defs->tbl_len);

	    if ((uni_o_cjk_c = uni_o_cjk_c_defs->otbl) == NULL) {
		in_tablefault(SKF_OTBLINCNSIS,"cjk_ex");
	    };
	};
      };
      if (ocodeset->o_iso_hngl_index >= 0) {
	uni_o_hngl_defs =
		&(o_iso_hngl_defs[ocodeset->o_iso_hngl_index]);
	if ((uni_o_hngl = uni_o_hngl_defs->otbl) == NULL) {
	    uni_o_hngl_defs->otbl = 
		skf_otable_loader(uni_o_hngl_defs->defschar,'H',
		  is_cod_iso(rcodeset),
		  is_cod_mb(rcodeset),
		  uni_o_hngl_defs->tbl_len);

	    if ((uni_o_hngl = uni_o_hngl_defs->otbl) == NULL) {
		in_tablefault(SKF_OTBLINCNSIS,"hangul");
	    };
	};
      };
      if (ocodeset->o_iso_y_index >= 0) {
	uni_o_y_defs = &(o_iso_y_defs[ocodeset->o_iso_y_index]);
	if ((uni_o_y = uni_o_y_defs->otbl) == NULL) {
	    uni_o_y_defs->otbl = 
		skf_otable_loader(uni_o_y_defs->defschar,'Y',
		  is_cod_iso(rcodeset),
		  is_cod_mb(rcodeset),
		  uni_o_y_defs->tbl_len);

	    if ((uni_o_y = uni_o_y_defs->otbl) == NULL) {
		in_tablefault(SKF_OTBLINCNSIS,"Yi");
	    };
	};
      };
      if (ocodeset->o_iso_prv_index >= 0) {
	uni_o_prv_defs =
		&(o_iso_prv_defs[ocodeset->o_iso_prv_index]);
	if ((uni_o_prv = uni_o_prv_defs->otbl) == NULL) {
	    uni_o_prv_defs->otbl = 
		skf_otable_loader(uni_o_prv_defs->defschar,'P',
		  is_cod_iso(rcodeset),
		  is_cod_mb(rcodeset),
		  uni_o_prv_defs->tbl_len);

	    if ((uni_o_prv = uni_o_prv_defs->otbl) == NULL) {
		in_tablefault(SKF_OTBLINCNSIS,"private");
	    };
	};
      };
      if (ocodeset->o_iso_compat_index >= 0) {
	uni_o_compat_defs =
		&(o_iso_compat_defs[ocodeset->o_iso_compat_index]);
	if ((uni_o_compat = uni_o_compat_defs->otbl) == NULL) {
	    uni_o_compat_defs->otbl = 
		skf_otable_loader(uni_o_compat_defs->defschar,'C',
		  is_cod_iso(rcodeset),
		  is_cod_mb(rcodeset),
		  uni_o_compat_defs->tbl_len);

	    if ((uni_o_compat = uni_o_compat_defs->otbl) == NULL) {
		in_tablefault(SKF_OTBLINCNSIS,"compat");
	    };
	};
      };
      if (ocodeset->o_iso_his_index >= 0) {
	uni_o_hist_defs =
		&(o_iso_hist_defs[ocodeset->o_iso_his_index]);
	if ((uni_o_hist = uni_o_hist_defs->otbl) == NULL) {
	    uni_o_hist_defs->otbl = 
		skf_otable_loader(uni_o_hist_defs->defschar,'I',
		  is_cod_iso(rcodeset),
		  is_cod_mb(rcodeset),
		  uni_o_hist_defs->tbl_len);

	    if ((uni_o_hist = uni_o_hist_defs->otbl) == NULL) {
		in_tablefault(SKF_OTBLINCNSIS,"hist");
	    };
	};
      };
      if (ocodeset->o_iso_note_index >= 0) {
	uni_o_note_defs =
		&(o_iso_note_defs[ocodeset->o_iso_note_index]);
	if ((uni_o_note = uni_o_note_defs->otbl) == NULL) {
	    uni_o_note_defs->otbl = 
		skf_otable_loader(uni_o_note_defs->defschar,'O',
		  is_cod_iso(rcodeset),
		  is_cod_mb(rcodeset),
		  uni_o_note_defs->tbl_len);

	    if ((uni_o_note = uni_o_note_defs->otbl) == NULL) {
		in_tablefault(SKF_OTBLINCNSIS,"note");
	    };
	};
      };
    };

/* At last process, apply codeset specific translation patch */
    if (!use_g0ascii) {	/*@-nullderef@*/
	output_codeset_fix_table(ocodeset->o_patch);
    } else {
	output_codeset_fix_table(NULL);
    };
}
#endif
/* --------------------------------------------------------------- */
/* test_out_char: test whether given character can output.	   */
/*  	ch : utf32 character					   */
/* 	return: 1 - can output					   */
/* 		0 - can't output				   */
/* --------------------------------------------------------------- */
int test_out_char(ch)
skf_ucode ch;
{
    if (ch < 0x80) return(1);
    else if (ch < LATIN_TBL_START) return(0);
    else if (ch < GLYPH_TBL_START) {
	if ((uni_o_latin == NULL) 
		|| (uni_o_latin[ch - LATIN_TBL_START] == 0)) return(0);
	else return(1);
    } else if (ch < KANA_TBL_START) {
	if ((uni_o_symbol == NULL)
		|| (uni_o_symbol[ch - GLYPH_TBL_START] == 0)) return(0);
	else return(1);
    } else if (ch < CJK_A_TBL_START) {
	if ((uni_o_kana == NULL)
		|| (uni_o_kana[ch - KANA_TBL_START] == 0)) return(0);
	else return(1);
    } else if (ch < CJK_TBL_START) {
	if ((uni_o_cjk_a == NULL)
		|| (uni_o_cjk_a[ch - CJK_A_TBL_START] == 0)) return(0);
	else return(1);
    } else if (ch < Y_TBL_START) {
	if ((uni_o_kanji == NULL)
		|| (uni_o_kanji[ch - CJK_TBL_START] == 0)) return(0);
	else return(1);
    } else if (ch < HNGL_TBL_START) {
	if ((uni_o_y == NULL) || (uni_o_y[ch - Y_TBL_START] == 0)) return(0);
	else return(1);
    } else if (ch <= HNGL_TBL_END) {
	if ((uni_o_hngl == NULL)
		|| (uni_o_hngl[ch - HNGL_TBL_START] == 0)) return(0);
	else return(1);
    } else if (ch < PRV_TBL_START) { return(0);
    		/* surrogate pair	*/
    } else if (ch < CPT_TBL_START) {
	if ((uni_o_prv == NULL) || (uni_o_prv[ch - PRV_TBL_START] == 0)) return(0);
	else return(1);
    } else if (ch <= CPT_TBL_END) {
	if ((uni_o_compat == NULL) || (uni_o_compat[ch - CPT_TBL_START] == 0)) return(0);
	else return(1);
    } else if (ch <= HIST_TBL_END) {
	if ((uni_o_hist == NULL) || (uni_o_hist[ch - 0x10000] == 0)) return(0);
	else return(1);
    } else if (ch < UPMISC_TBL_START) { return(0);
    } else if (ch <= UPMISC_TBL_END) { 
	if ((uni_o_upmisc == NULL) || (uni_o_upmisc[ch - UPMISC_TBL_START] == 0)) return(0);
	else return(1);
    } else if (ch < UPKANA_TBL_START) { return(0);
    } else if (ch <= UPKANA_TBL_END) {
	if ((uni_o_note == NULL) || (uni_o_upkana[ch - UPKANA_TBL_START] == 0)) return(0);
	else return(1);
    } else if (ch <NOTE_TBL_START) { return(0);
    } else if (ch < CJK_B_TBL_START) {
	if ((uni_o_note == NULL) || (uni_o_note[ch - NOTE_TBL_START] == 0)) return(0);
	else return(1);
    } else if (ch <= CJK_B_TBL_END) {
	if ((uni_o_cjk_b == NULL) || (uni_o_cjk_b[ch - CJK_B_TBL_START] == 0)) return(0);
	else return(1);
    } else if (ch < CJK_C_TBL_START) { return(0);
    } else if (ch < CJK_C_TBL_END) { 
	if ((uni_o_cjk_c == NULL) || (uni_o_cjk_c[ch - CJK_C_TBL_START] == 0)) return(0);
	else return(1);
    } else return(0);
}

#ifdef UNI_DECOMPOSE
/* --------------------------------------------------------------- */
int get_combine_strength(ch)
skf_ucode ch;
{
    if ((ch < 65536) && (ch >= 0)) {
	return((nkd_strmap[ch] & NKD_STRMAP_STRMASK));
    } else if ((ch >= 0x10a01) && (ch <= 0x10a3f)) {
    	return(uni_f_s_10a[ch - 0x10a01]);
    } else if ((ch >= 0x1d167) && (ch <= 0x1d1ad)) {
    	return(uni_f_s_1d1[ch - 0x1d167]);
    } else if ((ch >= 0x1d242) && (ch <= 0x1d244)) {
    	return(230);
    } else return(255);
}
#endif

#ifndef SWIG_EXT
#ifdef HAVE_LOCALE_H
/* --------------------------------------------------------------- */
/* default locale for each codeset				   */
/* --------------------------------------------------------------- */
static struct locale_codeset_name lang_defcode[] = {
    {L_JA,codeset_utf8},
    {L_EN,codeset_utf8},
    {L_FR,codeset_8859_1},
    {L_KO,codeset_euckr},
    {L_HE,codeset_8859_8},
    {L_RU,codeset_koi8r},
    {0x0, 0}
};

static struct locale_codeset_name loc_defcode[] = {
    {N_JAJP,codeset_eucjp},	/* ja_JP 	*/
    {N_ENUS,codeset_utf8},	/* en_US	*/
    {N_KOKR,codeset_euckr},	/* ko_KR	*/
    {N_PTBR,codeset_8859_1},	/* pt_BR	*/
    {N_RURU,codeset_8859_5},	/* ru_RU	*/
    {N_RUUA,codeset_utf8},	/* ru_UA	*/
    {N_THTH,codeset_8859_11},	/* th_TH	*/
    {N_VIVN,codeset_utf8},	/* vi_VN	*/
    {N_ZHCN,codeset_euccn},	/* zh_CN	*/
    {N_ZHTW,codeset_big5},	/* zh_TW	*/
    {0x0, 0}
};
#endif

/* --------------------------------------------------------------- */
/*@-mustfreefresh@*//*@-compdef@*/
int get_output_locale()
{
#ifdef HAVE_LOCALE_H
    int	localename = -1;
    char *ob_locale;
#if defined(HAVE_LANGINFO_CODESET)
    char *oc_locale;
#endif
    char *dotpos;
    char *atpos;
    char extr_cset[LANGNAME_LIMIT + 1];
    int	i,j;
    int	sy;
    int	langn,nationn;

#if defined(HAVE_LANGINFO_CODESET)
    if ((oc_locale = nl_langinfo((nl_item)CODESET)) != NULL) {
#ifdef SKFDEBUG
	if (is_vv_debug) {
	    fprintf(stderr,"OL:%s#",oc_locale);
	} else;
#endif
    	localename = skf_search_cname_w_alias(oc_locale);
    } else;

    if ((localename < 0) && ((ob_locale = setlocale(LC_ALL,"")) != NULL)) {
#else
    if ((ob_locale = setlocale(LC_ALL,"")) != NULL) {
#endif
#ifdef SKFDEBUG
	if (is_vv_debug) {
	    fprintf(stderr,"OB:%s#",ob_locale);
	} else;
#endif
    	/* actually locale return chacaters are infinitely long in */
	/* RFC5646, but let us cut the stuff into 5 + codeset_name */
    	dotpos = strchr(ob_locale,'.');
	if (dotpos != NULL) {
	    dotpos++; /* next to period. */
	    if (*dotpos == '\0') return(-1);
	    atpos = strchr(ob_locale,'@');
	    if (atpos == NULL) atpos = dotpos + 16;
	    for (i=0;(*dotpos != '\0') && (dotpos < atpos) 
	    		&& (i<LANGNAME_LIMIT);
		    dotpos++, i++) {
		extr_cset[i] = *dotpos;
	    };
	    if (i<16) extr_cset[i] = '\0';
	    else extr_cset[15] = '\0';

	    if (atpos != NULL) {
		atpos++;	/* skip '@'				   */
		if (strncmp(atpos,localemod,(size_t)10) == 0) {
		/* cjknarrow defined: following is not correct, */
		/* but this might be best for charset converter.   */
		    res_sup_space_conv; set_spconv_1;
		    set_o_prefer_ascii; set_kanaconv_x0201;
		} else;
	    } else;
	    localename = skf_search_cname_w_alias(extr_cset);
	} else {	/* does not have specific codeset name		   */
	    for (i=0;i<LANGNAME_LIMIT;i++) {
	    	sy = *(ob_locale + i);
	    	extr_cset[i] = SKFtoupper(sy);
		if ((sy == '\0') || (sy == '.')) break;
	    };
	    extr_cset[i] = '\0';
	    if (((i == 1) && (extr_cset[0] == 'C')) ||
	        ((i == 5) && (extr_cset[0] == 'P') && (extr_cset[1] == 'O')
		  && (extr_cset[2] == 'S') && (extr_cset[4] == 'I')
		  && (extr_cset[5] == 'X'))) {	/* POSIX LOCALE		   */
		localename = codeset_ascii;
	    } else if ((i >= 2) &&
	    	(((extr_cset[0] == 'I') && (extr_cset[1] == '-')) ||
		 ((extr_cset[0] == 'X') && (extr_cset[1] == '-')))){
		  	/* reserved or private use (rfc5646)		   */
		return -1; /* we don't know anything about these stuffs... */
	    } else;
	    if (i > 1) {
		langn = ((extr_cset[0] & 0x7f) << 8) + (extr_cset[1] & 0x7f);
		nationn = ((extr_cset[3] & 0x7f) << 8) + (extr_cset[4] & 0x7f);
		if (i >= 5) {
		    nationn = ((extr_cset[3] & 0x7f) << 8) + (extr_cset[4] & 0x7f);
		    langn = (langn << 16) + nationn;
		    for (j=0; loc_defcode[j].langnat != 0;j++) {
		    	if (loc_defcode[j].langnat == langn) {
			    localename = loc_defcode[j].codename;
			    break;
			} else;
		    };
	    	} else;
		if (localename < 0) {
		    for (j=0; lang_defcode[j].langnat != 0;j++) {
		    	if (lang_defcode[j].langnat == nationn) {
			    localename = lang_defcode[j].codename;
			    break;
			} else;
		    };
		} else;
	    } else;
	};
    } else;
#endif
    if (localename >= 0) {
    	if (localename == codeset_ascii) return CODESET_POSIX;
	else return localename;
    } else return -1;
    /*@NOTREACHED@*/
}
#endif

/* --------------------------------------------------------------- */
#endif	/* !OUTPUT_DYNAMIC_TABLE */
