<?php
  session_start();
  date_default_timezone_set('Asia/Tokyo');

  $thisFile = basename($_SERVER['PHP_SELF']);

  //$_path = dirname($_SERVER["PATH_SELF"]);
  $_path = dirname($_SERVER["SCRIPT_NAME"]);

  $inc_path = get_include_path();
  set_include_path(get_include_path() . PATH_SEPARATOR . $_path."/programs" . PATH_SEPARATOR . $_path."/programs/lib");


 if(!defined('PHP_VERSION_ID')){
   $version = PHP_VERSION;
   define('PHP_VERSION_ID',($version{0}*10000+$version{2}*100+$version{4}));
 }
  
 $_SIWIKI['description'] = "Simple Wiki System";

 if(!isset($_SESSION['lang']) || !$_SESSION['lang']){
   $_SESSION['lang'] = 'jp';
 }

 $today=date("Y-m-d");

 include_once("etc/siwiki.conf");
 include_once("programs/lib/wiki.func.php");
 include_once("programs/lib/wiki_body.php");
 include_once("programs/lib/wp-theme.php");


 if(class_exists('PDO')){
   include("programs/lib/PDO_SQLite.class.php");
 }else  if(function_exists('sqlite_open')){
   include("programs/lib/SQLite.class.php");
 }else{
   print "Sorry, SQLite interface is required.";
   exit();
 }

 ChkVal($site, 'site', 'default');
 $_SIWIKI['site'] = $_SESSION['site'] = $site;

 $_SIWIKI['show_navi'] = false;
// $_SIWIKI['NoHome'] = true;
// $_SIWIKI['show_category'] = true;
// $_SIWIKI['menu_on_footer'] = 1;


 load_plugins();
 load_config();

 $a_posts = array();

 $topLogo = $_SIWIKI['topLogo'];

 $content_navi = "";
 $content = "";
 if(!isset($default_lang)){
   $default_lang = "";
 }

 ChkVal($fname, 'file', 'index');
 ChkVal($category, 'category', 'Home');
 ChkVal($sub, 'sub', '');
 ChkVal($lang, 'lang', $default_lang);

 if($_SIWIKI['theme']){
 
   if(file_exists($_SIWIKI['siwiki_dir']."/themes/".$_SIWIKI['theme']."/".$_SIWIKI['theme'])){
     define('TEMPLATEPATH', "themes/".$_SIWIKI['theme']."/".$_SIWIKI['theme']);
   }else if(file_exists($_SIWIKI['siwiki_dir']."/themes/".$_SIWIKI['theme'])){
     define('TEMPLATEPATH', "themes/".$_SIWIKI['theme']);
   }else{
     define('TEMPLATEPATH', "themes/default");
   }
   $_SIWIKI['template'] = getTemplateScript();
 }

 if(file_exists( $_SIWIKI['siwiki_dir']."/".TEMPLATEPATH."/404.html")){
   $error404 = $_SIWIKI['siwiki_dir']."/".TEMPLATEPATH."/404.html";
 }else{
   $error404 = $_SIWIKI['siwiki_dir']."/themes/default/404.html";
 }

 if(file_exists( $_SIWIKI['siwiki_dir']."/".TEMPLATEPATH."/401.html")){
   $error401 = $_SIWIKI['siwiki_dir']."/".TEMPLATEPATH."/401.html";
 }else{
   $error401 = $_SIWIKI['siwiki_dir']."/themes/default/401.html";
 }

 if($lang) $_SESSION['lang'] = $lang;
 if(!$_SESSION['lang']){
   $default_langs = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
   $default_lang = $default_langs[0];
   if(!strncmp($default_lang, 'en', 2)) $default_lang = "en";
   if(!strncmp($default_lang, 'jp', 2)) $default_lang = "ja";
   $_SESSION['lang'] = $default_lang;
 }

 if($_SESSION['lang'] == "jp"){ $_SESSION['lang'] = "ja"; }
 $_SIWIKI['category'] = $_SESSION['category'] = $category;

 $fname = rawurlencode($fname);
 $dir_name = str_replace('%', '',$fname);
 $_SIWIKI['pagename'] = $dir_name;

 $_SIWIKI['filename'] = $_SIWIKI['wiki_dir']."/documents/".$_SIWIKI['category']."/".$dir_name."/content.".$_SESSION['lang'].".txt";
 $_SIWIKI['dirname'] = $_SIWIKI['wiki_dir']."/documents/".$_SIWIKI['category']."/".$dir_name;

 if(PHP_VERSION_ID > 50100){
   date_default_timezone_set("Asia/Tokyo");
 }


?>
