<?php
include_once('wiki.func.php');

 if(!defined('PHP_VERSION_ID')){
    $version = explode('.', PHP_VERSION);
    define('PHP_VERSION_ID',($version[0]*10000+$version[2]*100+$version[3]));
 }

 function push_back(&$tree, $val){
  if(PHP_VERSION_ID < 50000){
    $tree[] = $val;
  }else{
    array_push($tree, $val);
  }
}



/*
 Wiki Class
*/
class Body{
  var $wiki_top="/";
  var $lines;
  var $tree;
  var $title;
  var $lang;
  var $update;
  var $body;
  var $last = null;

  function Body(&$lines){
   $this->lines =& $lines;
   $this->tree = array();
  }

  function getTitle(){
    $lines = $this->lines;

    while($lines){
      $line = array_shift($lines);
      if(!strncmp('TITLE:', $line, 6)) return trim(str_replace('TITLE:','',$line));
    }
    return 0;
  }

  function parse(){
    $stat = "Body";
    $pstat = "Body";

    $lines = $this->lines;
    $this->body = array();

    while($lines){
      $line = array_shift($lines);
      if(strncmp('TITLE:', $line, 6) &&
         strncmp('LANG:', $line, 5) &&
         strncmp('UPDATE:', $line, 7)
      ){ $this->body[] = $line; } 

      $head = $line{0};

      if(!$line || $line{0} == "\r" || $line{0} == "\n"){
        $this->last = new Div($line);
        $this->last->content = array();
        $this->last->type = "P";
        push_back($this->tree, $this->last);
	$stat == "Div";

      }else if(strncmp('TITLE:', $line, 6) == 0){
        $this->title = trim(str_replace('TITLE:','',$line));

      }else if(strncmp('UPDATE:', $line, 7) == 0){
        $this->update = trim(str_replace('UPDATE:','',$line));

      }else if(strncmp('LANG:', $line, 5) == 0){
        $this->lang = trim(str_replace('LANG:','',$line));


      }else if(preg_match('/^(LEFT:|RIGHT:|CENTER:)(.*)/', $line, $match) > 0){
        $this->last = new Div(substr($line,strpos($line, ":")+1));
        $this->last->type = $match[1];
 //       array_push($this->tree, $this->last);
        $this->tree[] = $this->last;

      }else if($head == '#'){
        $this->last = new Cmd($line);
        $this->last->body = &$this;
//        array_push($this->tree, $this->last);
        $this->tree[] = $this->last;

        $stat = "Cmd";

      }else if($head == '*'){
        $this->last = new Heading($line);
//        array_push($this->tree, $this->last);
        $this->tree[] = $this->last;

        $stat = "Heading";

      }else if(strncmp("-------", $line, 7) == 0|| strncmp("#hr",$line, 3) == 0 ){
        $this->last = new HR($line);
//        array_push($this->tree, $this->last);
        $this->tree[] = $this->last;

        $stat = "HR";
      
      }else{
        //if($this->last instanceof Div)
        if(is_a($this->last,'Div'))
	{
//          $this->last->append($line);
          $last = array_pop($this->tree);
          $last->append($line);
          array_push($this->tree, $last);

        }else{
          $this->last = new Div($line);
//          array_push($this->tree, $this->last);
          $this->tree[] = $this->last;
        }
        $stat = "Div";
      }
    }
  }

  function toString(){
   $str = "";

   foreach($this->tree as $ele){
     if(is_a($ele, 'Div')) $ele->parse();
     $str .= $ele->toString();
   }
   return $str;
  }

  function toHTML(){
    $res =<<<_HTML
<html>
 <head>
   <title>$this->title</title>
 </head>
 <body>

_HTML;

    $res .= $this->toString();
    $res .=<<<_HTML
 </body>
</html>
_HTML;
    return $res;

  }

  function getContents(){
    foreach($this->tree as $itm){
//      if($itm instanceof Heading)
      if(is_a($itm, 'Heading'))
      {
         $str .= $itm->mkIndex();
      }
    }
    return $str;
  }
}

/*
 *   Elements
 */
class Element{
  var $line;
  var $content;
  var $wikiname;
  

  function Element(&$line){
//    if($line{0} == '~') $line = "<br />".substr($line,1);
    $this->line = $this->content = trim($line);
  }

  function setWikiname($name){
    $this->wikiname=$name;
  }

  function append(&$line){
     $this->line .= "\n".$line;
     $this->content .= "\n".$line;
  }

  function replace_inline_func(&$content){
   $pattern = '/&amp;([\w]+)\(([あ-ん\w\,\s#]+)\)\{([^{}]+)*\};/';

   $count = preg_match_all($pattern , $content, $match);

   if( $count > 0){
     for($i=0;$i < $count;$i++){

       switch($match[1][$i]){
         case "color":
            $colors = explode(",",$match[2][$i]);
            $bgc = "";
            if (count($colors) > 1) $bgc .= ";background-color:".$colors[1];
            $str = "<span style=\"color:".$colors[0].$bgc."\">".$match[3][$i]."</span>";
            break;
         case "size":
            $str = "<span style=\"font-size:".$match[2][$i]."pt\">".$match[3][$i]."</span>";
            break;
         case "shift":
            $str = "<div style=\"margin-left:".$match[2][$i]."px\">".$match[3][$i]."</div>";
            break;
         case "aname":
            $str = "<a name=\"".$match[2][$i]."\">".$match[3][$i]."</a>";
            break;
         case "ruby":
            $str = "<RUBY><RB>".$match[3][$i]."<RP>[<RT>".$match[2][$i]."<RP>]</RUBY>";
            break;
         default:
            $str = "";
            break;
       }
       $content = str_replace($match[0][$i], $str, $content);
     }
   }
   return $count;
 }  

  function replace_inline_func2(&$content){
   global $_SIWIKI;
   $pattern = '/&amp;([\w]+)\(([\:\w\.\/\,\"\=\-]+)\);/';

   $count = preg_match_all($pattern , $content, $match);

   if( $count > 0){
     for($i=0;$i < $count;$i++){
       switch($match[1][$i]){
         case "ref":
            $ref = $match[2][$i];
	    $refs=explode(',',$ref);
            $fname=$refs[0];
            $opt =$refs[1];
            $count=preg_match('/((.png)|(.jpg)|(.jpeg)|(.gif))$/', $fname);
	    

            if($count > 0){
              $img_file = mkReferenceUrl($fname, "images");
              $str = "<img src=\"$img_file\" $opt />";
            }else{
              $ref_file = mkReferenceUrl($fname,"attachments");
	      if($opt)
                $str="<a href=\"$ref_file/download\" >$opt</a>";
	      else
                $str="<a href=\"$ref_file/download\" >$fname</a>";
            }

            break;
         case "aname":
            $name = $match[2][$i];
            $str = "<a name=\"".$name."\"></a>";
            break;
         case "u":
            $name = $match[2][$i];
            $str = "&#".$name;
            break;
         case "ux":
            $name = $match[2][$i];
            $str = "&#x".$name;
            break;
         case "counter":
            $arg = $match[2][$i];
            $str = access_counter($_SIWIKI['dirname'], $arg);
            break;
         default:
            $str = "";
            break;
       }
        $content = str_replace($match[0][$i], $str, $content);
     }
   }
   return $count;
  }

  function replace_inline_func3(&$content){
   global $UPDATE;
   global $_SIWIKI;
   $pattern = '/&amp;([_\w]+);/';

   $res = $count = preg_match_all($pattern , $content, $match);

   if( $count > 0){
     for($i=0;$i < $count;$i++){
       switch($match[1][$i]){
         case "now":
            $str = date('Y-m-d H:i:s',$UPDATE);
            break;
         case "date":
            $str = date('Y-m-d',$UPDATE);
            break;
         case "time":
            $str = date('H:i:s',$UPDATE);
            break;
         case "_now":
            $str = date('Y-m-d H:i:s');
            break;
         case "_date":
            $str = date('Y-m-d');
            break;
         case "_time":
            $str = date('H:i:s');
            break;
         case "heart":
            $str = "<img src=\"".$_SIWIKI['top']."/images/face/heart.png\" alt=\"[heart]\"/>";
            break;
         case "smile":
            $str = "<img src=\"".$_SIWIKI['top']."/images/face/smile.png\" alt=\"[smile]\"/>";
            break;
         case "bigsmile":
            $str = "<img src=\"".$_SIWIKI['top']."/images/face/bigsmile.png\" alt=\"[bigsmile]\"/>";
            break;
         case "huh":
            $str = "<img src=\"".$_SIWIKI['top']."/images/face/huh.png\" alt=\"[huh]\"/>";
            break;
         case "oh":
            $str = "<img src=\"".$_SIWIKI['top']."/images/face/oh.png\" alt=\"[oh]\"/>";
            break;
         case "wink":
            $str = "<img src=\"".$_SIWIKI['top']."/images/face/wink.png\" alt=\"[wink]\"/>";
            break;
         case "sad":
            $str = "<img src=\"".$_SIWIKI['top']."/images/face/sad.png\" alt=\"[sad]\"/>";
            break;
         case "worried":
            $str = "<img src=\"".$_SIWIKI['top']."/images/face/worried.png\" alt=\"[worried]\"/>";
            break;
         default:
            $str = "";
	    $res -= 1;
            break;
       }
       if($str) $content = str_replace($match[0][$i], $str, $content);
     }
   }
   return $res;
 }

 function replace_inline_code(&$content){
   $pattern = '/&amp;#([x,0-9]+);/';

   $count = preg_match_all($pattern , $content, $match);

   if( $count > 0){
     for($i=0;$i < $count;$i++){
        $str ="&#".$match[1][$i];
        $content = str_replace($match[0][$i], $str, $content);
     }
   }
   return $count;
 }  

 function replace_inline_amp(&$content){
   $pattern = '/&amp;amp;/';

   $count = preg_match_all($pattern , $content, $match);

   if( $count > 0){
     for($i=0;$i < $count;$i++){
        $str ="&amp;";
        $content = str_replace($match[0][$i], $str, $content);
     }
   }
   return $count;
 }  


 function split_cmd(){
   $pattern = '/&([\w]+)\(([\w\,\s]+)\);/';

   $count = preg_match_all($pattern , $content, $match);

   while( $count ){
   $count--;
   }
  }  

  function replace_i_tag(&$content){
    while(($str = get_inline_tag("'''", "'''", $content)) != "" ){
      $content = str_replace("'''".$str."'''", "<I>".$str."</I>", $content);
    }
  }

  function replace_b_tag(&$content){
    while(($str = get_inline_tag("''", "''", $content)) != "" ){
      $content = str_replace("''".$str."''", "<B>".$str."</B>", $content);
    }
  }

  function replace_s_tag(&$content){
    while(($str = get_inline_tag("%%", "%%", $content)) != "" ){
      $content = str_replace("%%".$str."%%", "<S>".$str."</S>", $content);
    }
  }

  function replace_rem_tag(&$content){
    while(($str = get_inline_tag("((", "))", $content)) != "" ){
      $id=md5($str);
      $content = str_replace("((".$str."))", "<sup><a onClick=\"javascript:toggle_rem('$id')\"><font color=\"#440000\"><b>*</b></font></a></sup><div class=\"rem\" id=\"$id\">".$str."</div>", $content);
    }
  }

  function replace_a_tag(&$content){
    global $_SIWIKI;

    while(($str = get_inline_tag("[[", "]]", $content)) != "" ){
    /*
      $str = str_replace('&amp;','&',$str);
      $str = str_replace('&quot;','"',$str);
      $str = str_replace('&lt;','<',$str);
      */
      $opt = ""; 
      $pos = strpos($str, "&gt;");
      if($pos === false) $pos2 = $pos = strpos($str, ":");
      else $pos2 = $pos+3;

      $strs = explode(',',$str);
      if(count($strs) > 0){
        $opt = $strs[1];
        $opt = str_replace('&quot;','"', $opt);
      }
      if($pos === false){
	if(isURL($str)){
	  if(count($strs) > 0){
	     $page = $strs[0];
	  }else{
	    $page = $str;
	  }
	}else{
	  if(count($strs) >1){
             $page = getStaticPage($_SESSION['lang'], $_SESSION['category'], $strs[0]);
	  }else{
            $page = getStaticPage($_SESSION['lang'], $_SESSION['category'], $str);
	  }
          $page = str_replace("%23", "#", $page);
        }
        $content = str_replace("[[".$str."]]", "<a href=\"".$page."\" $opt>".$strs[0]."</a>", $content);
      }else{
	if(count($strs) >1){
          $page = substr($strs[0], $pos2+1);
	}else{
          $page = substr($str, $pos2+1);
	}
        if(substr($str,0, $pos) == "http"){
          $content = str_replace("[[".$str."]]", "<a href=\"".$strs[0]."\" $opt >".$strs[0]."</a>", $content);
        }else{
          if(!isURL($page)){ 
            if($page == "/"){
              $page = getStaticPage($_SESSION['lang'], $_SESSION['category'], 'index');
            }else{
    	    if($page[0]!="#"){
              $page = getStaticPage($_SESSION['lang'], $_SESSION['category'], $page);
              $page = str_replace("%23", "#", $page);
            }
            }
          }else if($page{0} == '/'){
              $page = $_SIWIKI['top']."/_".$_SESSION['site']."/".$_SESSION['lang'].$page.".html";
          }
          $content = str_replace("[[".$str."]]", "<a href=\"".$page."\" $opt>".substr($str,0, $pos) ."</a>", $content);
	  
        }
      }

    }
  }

  function toString(){
   $content = htmlspecialchars($this->content);
   if($content{0} == "~") $content = "<br />".substr($content,1);

   $this->replace_rem_tag($content);
   $this->replace_a_tag($content);

   $this->replace_i_tag($content);
   $this->replace_b_tag($content);
   $this->replace_s_tag($content);

 
   $content = str_replace("&amp;br;", "<br/>", $content);
   $content = preg_replace('/~$/', "<br/>", $content);

   while( $this->replace_inline_func($content) > 0);
   while( $this->replace_inline_func2($content) > 0);
   while( $this->replace_inline_func3($content) > 0);
   while( $this->replace_inline_amp($content) > 0);

   return $content;
 }
}

/*
 *   Block
 */
class Block{
  var $line;
  var $lines;
  var $content;
  var $wikiname;
  var $tree;
  var $last = null;

  function Block(&$line){
    $this->line = $line;
    $this->lines[] = $line;
    $this->content = array(new Element($line));
    $this->tree = array();
  }

  function setWikiname($name){
    $this->wikiname=$name;
  }

  function append(&$line){
    $this->line .= $line;
    array_push($this->content, new Element($line));
    $this->lines[] = $line;
  }

  function toString(){
    $str = "";

    if(count($this->tree) > 0){
      foreach($this->tree as $ele){
       if(is_string($ele)){
           $str .= htmlspecialchars($ele);
           
       }else{
         if(is_a($ele, 'Div') || is_a($ele,'Blockquote')) $ele->parse();
         $str .= $ele->toString();
       }
      }
    }else{
      foreach($this->content as $ele){
        $str .= $ele->toString();
      }
    }
    return $str;
  }

  function parse(){
    $stat = "Block";
    $lines = $this->lines;
    $blockquote = false;

    while($lines){
      $line = array_shift($lines);
      

      $head = $line{0};

      if(strncmp('//', $line, 2) == 0){ continue; }

      if(strncmp('>', $line, 1) == 0){ 
        $line = substr($line,1);
	$blockquote = true;
      }
      if($line{0} =='<'){
        if($line{1} != '<'){ 
	  $blockquote = false;
        }
        $line = substr($line,1);
      }

      if($blockquote){

//        if($this->last instanceof Blockquote)
        if(is_a($this->last, 'Blockquote'))
	{
          //$this->last->append($line, $head);
          $last = array_pop($this->tree);
          $last->append($line, $head);
          array_push($this->tree, $last);
        }else{
          $this->last = new Blockquote($line);
          array_push($this->tree, $this->last);
        }
        $stat = "BLOCKQUITE";

      }else if($head == ' '){
        //if($this->last instanceof Pre)
        if(is_a($this->last,'Pre'))
	{
          //$this->last->append($line);
          $last = array_pop($this->tree);
          $last->append($line);
          array_push($this->tree, $last);

        }else{
          $this->last = new Pre($line);
          array_push($this->tree, $this->last);
        }
        $stat = "PRE";

      }else if($head == '|'){
//        if($this->last instanceof Table)
        if(is_a($this->last,'Table'))
	{
          //$this->last->append($line);
          $last = array_pop($this->tree);
          $last->append($line);
          array_push($this->tree, $last);
        }else{
          $this->last = new Table($line);
          array_push($this->tree, $this->last);
        }
        $stat = "TABLE";
      }else if($head == ','){
//        if($this->last instanceof CsvTable)
        if(is_a($this->last,'CsvTable'))
	{
          //$this->last->append($line);
          $last = array_pop($this->tree);
          $last->append($line);
          array_push($this->tree, $last);
        }else{
          $this->last = new CsvTable($line);
          array_push($this->tree, $this->last);
        }
        $stat = "CSV_TABLE";
      }else if($head == '-'){
//        if($this->last instanceof ListElement && $this->last->type == $head)
        if(is_a($this->last, 'ListElement') && $this->last->type == $head)
	{
          //$this->last->append($line, $head);
          $last = array_pop($this->tree);
          $last->append($line, $head);
          array_push($this->tree, $last);
        }else{
          $this->last = new ListElement($line, $head);
          array_push($this->tree, $this->last);
        }
        $stat = "LIST";
      }else if($head == '+'){
//        if($this->last instanceof ListElement && $this->last->type == $head)
        if(is_a($this->last, 'ListElement') && $this->last->type == $head)
	{
          //$this->last->append($line, $head);
          $last = array_pop($this->tree);
          $last->append($line, $head);
          array_push($this->tree, $last);
        }else{
          $this->last = new ListElement($line, $head);
          array_push($this->tree, $this->last);
        }
        $stat = "NLIST";
      }else if($head == ':'){
//        if($this->last instanceof ListElement && $this->last->type == $head)
        if(is_a($this->last,'ListElement') && $this->last->type == $head)
	{
          //$this->last->append($line, $head);
          $last = array_pop($this->tree);
          $last->append($line, $head);
          array_push($this->tree, $last);
        }else{
          $this->last = new ListElement($line, $head);
          array_push($this->tree, $this->last);
        }
        $stat = "DLIST";
      }else if($head == '~'){
        if(is_a($this->last, 'ListElement'))
	{
          $last = array_pop($this->tree);
          $last->append($line, $head);
          array_push($this->tree, $last);
	 }else{
           array_push($this->tree, new Element($line));
	 }
      }else{
        array_push($this->tree, new Element($line));
      }
    }

  }
}

/*
 *   Div
 */
class Div extends Block{
  var $type;

  function toString(){
    $res = parent::toString();
    $id=md5($res);

    switch($this->type){
      case "P":
        return "<div class=\"p\">\n".$res."</div>\n";
      case "LEFT:":
        $align = " align=left ";
        //$res = substr($res, 5);
        break;
      case "CENTER:":
        $align = " align=center ";
        //$res = substr($res, 7);
        break;
      case "RIGHT:":
        $align = " align=right ";
        //$res = substr($res, 6);
        break;
      default:
        $align = "";
        break;
    }
    return "<div".$align." id=\"$id\">\n".$res."</div>\n";
  }
}

/*

*/
class Blockquote extends Block{
  var $level;

  function toString(){
    $res = parent::toString();
    $id=md5($res);

    return "<blockquote>\n".$res."</blockquote>\n";
  }
}
/*
 *   Table
 */
class Table extends Block{
  var $type;
  var $trs;

  function Table(&$line){
    $this->line = $line;
    $this->content = array(new Element($line));
  }

  function append(&$line){
     $this->line .= $line;
     array_push($this->content, new Element($line));
  }

  function content2array(){
    for($j=0; $j < count($this->content); $j++){
      $line = $this->content[$j];
 
      $tds = explode("|", $line->toString());
      $td_cols = array();

      array_shift($tds); 
      $this->type[] = trim(array_pop($tds));

      for($i=0; $i <count($tds); $i++){
        $td = trim($tds[$i]);
        if($td == "&gt;"){
          $td_cols[$i] += 1;
          $td_cols[$i+1] = $td_cols[$i];
        }else{
          $td_cols[$i] += 1;
        }
      }
      $this->trs[] = $tds;
      $cols[] = $td_cols;
    }
    return  $cols;
  }

  function check_rowspan(){
    $rows = array();
    $i=count($this->trs) -1;
    for(;$i >= 0; $i--){
      for($j=0; $j < count($this->trs[$i]) ;$j++){
        $td = trim($this->trs[$i][$j]);
        if($td == "~"){
          $rows[$i][$j] += 1;
          $rows[$i-1][$j] = $rows[$i][$j];
        }else{
          $rows[$i][$j] += 1;
        }
      }
    }
    return $rows;
  }

  function parse_td($td, &$ss){
     $res = array();
    foreach($td as $x){
//      if(is_numeric($x)){
      if(!strncmp($x,"WIDTH(", 6)){
        $x=substr($x,6,-1);
        $ss['width'] = $x;
      }else if(!strncmp($x,"COLOR(", 6)){
        $x=substr($x,6,-1);
        $ss['color'] = $x;
      }else if(!strncmp($x,"BGCOLOR(", 8)){
	$x=substr($x,8,-1);
        $ss['background-color'] = $x;
      }else if(!strncmp($x,"SIZE(", 5)){
        $x=substr($x,5,-1);
        $ss['font-size'] = $x;
      }else if(!strncmp($x,"LEFT", 4)){
        $ss['text-align'] = "left";
      }else if(!strncmp($x,"RIGHT", 5)){
        $ss['text-align'] = "right";
      }else if(!strncmp($x,"CENTER", 6)){
        $ss['text-align'] = "center";
      }else{
	  array_push($res, $x);
      }
    }
     return $res;
  }

  function toString(){
    $res ="";

    $cols = $this->content2array();
    $rows = $this->check_rowspan();

    for($i=0;$i < count($this->trs); $i++){
      for($j=0; $j < count($this->trs[$i]) ;$j++){
          if($cols[$i][$j] > 1){
            $colspan[$i][$j] = "colspan=\"".$cols[$i][$j]." \" ";
          }else{
            $colspan[$i][$j] = "";
          }
          if($rows[$i][$j] > 1){
            $rowspan[$i][$j] = "rowspan=\"".$rows[$i][$j]." \" ";
          }else{
            $rowspan[$i][$j] = "";
          }
      }
    }

    for($i=0;$i < count($this->trs); $i++){
      $str="";

      for($j=0; $j < count($this->trs[$i]) ;$j++){
        $td_data = trim($this->trs[$i][$j]);
  
        if($td_data != "&gt;" && $td_data != "~"){
          $td = explode(":",$td_data);
          if($this->type[$i] != "c") $val = array_pop($td);

          $ss = style2array($td_style[$j]);

          $vals = $this->parse_td($td, $ss);
          $style= array2style($ss);

	  if($vals){
	    $val = implode(":",$vals).":".$val;
	  }

          $opt="";
          if($colspan[$i][$j]) $opt .= $colspan[$i][$j];
          if($rowspan[$i][$j]) $opt .= " ".$rowspan[$i][$j];
          if($style) $opt .= " style=\"".$style."\"";
           
          if($this->type[$i] == "h"){
            $str .= "<th $opt>".$val."</th>";
          }else if($this->type[$i] == "c"){
            $td_style[$j] .= $style;
          }else{
            if($val[0] == "~") $str .= "<th $opt>".substr($val,1)."</th>";
            else $str .= "<td $opt>".$val."</td>";
          }
        }
      }

      if($this->type[$i] == "h"){
       if($str) $res .= "<thead><tr>".$str."</tr></thead>\n";
      }else if($this->type[$i] == "f"){
       if($str) $res .= "<tfoot><tr>".$str."</tr></tfoot>\n";
      }else if(!$this->type[$i]){
       if($str) $res .= "<tr>".$str."</tr>\n";
      }
    }
    $layout = false; 
    foreach($this->type as $ly){
      if($ly == "C") {$layout = "center";}
      if($ly == "L") {$layout = "left";}
      if($ly == "R") {$layout = "right";}
    }
    $tbl = "<table>\n".$res."</table>\n";
    if($layout){
       $tbl = "<div align=\"$layout\">".$tbl."</div>";
    }
    return $tbl;
  }
}

class CsvTable extends Table{
  var $type;
  var $trs;

  function CsvTable(&$line){
    $this->line = $line;
    $this->content = array(new Element($line));
  }

  function append(&$line){
     $this->line .= $line;
     array_push($this->content, new Element($line));
  }

  function parseCSV($line){
    $is_string=false;
    $i=0;
    $len = strlen($line);

    $res=array();
    $str = array();
    if($line{$i} != ',') return $res;

    for($i=1;$i<$len;$i++){
      if(!$is_string && $line{$i} == ','){
        $res[]=implode('',$str);
        $str=array();
        continue;
      }
      if($line{$i} == '\\'){
        $i++;
	$str[] = $line{$i};
        continue;
      }
      if($line{$i} === '"'){
        if($line{$i+1} === '"'){
	  $str[] = '"';
          $i++;
        }else{
          $is_string = !$is_string;
        }
      }else
        $str[] = $line{$i}; 
    }
    $res[]=implode('',$str);
    return $res;
  }

  function content2array(){
    for($j=0; $j < count($this->content); $j++){
      $line = $this->content[$j];
 
      //$tds = explode(",", $line->toString());

      $lstr = str_replace('&quot;', '"', $line->toString());
      $tds = $this->parseCSV($lstr);
      $td_cols = array();

//      array_shift($tds); 
//      $this->type[] = trim(array_pop($tds));

      $i = count($tds) - 1;
      for(; $i >= 0; $i--){
        $td = $tds[$i];
        if(trim($td) == "=="){
          $td_cols[$i] += 1;
          $td_cols[$i-1] = $td_cols[$i];
        }else{
          $td_cols[$i] += 1;
        }
      }
      $this->trs[] = $tds;
      $cols[] = $td_cols;
    }
    return  $cols;
  }

  function toString(){
    $res ="";

    $cols = $this->content2array();
    $rows = $this->check_rowspan();

    for($i=0;$i < count($this->trs); $i++){
      for($j=0; $j < count($this->trs[$i]) ;$j++){
          if($cols[$i][$j] > 1){
            $colspan[$i][$j] = "colspan=\"".$cols[$i][$j]." \" ";
          }else{
            $colspan[$i][$j] = "";
          }
          if($rows[$i][$j] > 1){
            $rowspan[$i][$j] = "rowspan=\"".$rows[$i][$j]." \" ";
          }else{
            $rowspan[$i][$j] = "";
          }
      }
    }

    for($i=0;$i < count($this->trs); $i++){
      $str="";

      for($j=0; $j < count($this->trs[$i]) ;$j++){
        $td_data = $this->trs[$i][$j];
  
        if(trim($td_data) != "==" && trim($td_data) != "~"){
          $last = strlen($td_data) -1;
          $val = trim($td_data);
	  if($td_data{0} == ' '){
            if( $td_data{$last} == ' '){
              $ss['text-align'] = "center";
            }else{
              $ss['text-align'] = "right";
            }
          }
          $style= array2style($ss);

          $opt="";
          if($colspan[$i][$j]) $opt .= $colspan[$i][$j];
          if($rowspan[$i][$j]) $opt .= " ".$rowspan[$i][$j];
          if($style) $opt .= " style=\"".$style."\"";
          if($val[0] == "~") $str .= "<th $opt>".substr($val,1)."</th>";
          else $str .= "<td $opt>".$val."</td>";

        }
      }
      if($str) $res .= "<tr>".$str."</tr>\n";
    }
    $tbl = "<table>\n".$res."</table>\n";
    return $tbl;
  }
}



/*
 *   Headings
 */
class Heading extends Block{
  var $rank=1;

  function Heading(&$line){
    $this->line = trim($line);
    $rank=0;
    while($this->line{$rank} == "*") $rank++;
    $content = str_replace('*','',$this->line);
    $this->content = array(new Element($content));
    $this->rank = min(6, $rank);
  }

  function mkIndex(){
    $res = parent::toString();
    $id=md5($res);
    for($i=0, $str="";$i <$this->rank;$i++){
       $str .= "-";
    }
    return $str."[[".$res.":#$id]]\n";
  }

  function toString(){
    $res = parent::toString();
    $id=md5($res);
    $x=$this->rank +1 ;
    return "<h".$x." id=\"$id\">".$res."</h".$x.">\n";
  }
}

/*
 *   Horizontal Ruler
 */
class HR extends Element{
  function toString(){
    return "<hr>\n";
  }
}

/*
 *   Cmd
 */
class Cmd extends Block{
  var $name;
  var $body;

  function Cmd(&$line){
    $this->line = $line;
    if(strncmp($line, "#ref", 4)==0){
      $this->name = "REF";
      $this->content = substr($line, 5, strrpos($line, ")")-1);
    }else if(strncmp($line, "#contents", 9)==0){
      $this->name = "CONTENTS";
    }else if(strncmp($line, "#page_navi", 10)==0){
      $this->name = "PAGE_NAVI";
    }else if(strncmp($line, "#include_html", 13)==0){
      $this->name = "INCLUDE_HTML";
    }else{
      $this->name = "UNKNOWN";
    }
  }

  function toString(){
    global $_SIWIKI;

    switch($this->name){
      case "REF":
        $ref = $this->content;
        $pattern = '/([\w\.\/\,\"\=\%]+)\)/';
        $c = preg_match($pattern, $ref, $match);
        $fnames=split(',',$match[1]);
        $fname = array_shift($fnames);
        $count=preg_match('/((.png)|(.jpg)|(.jpeg)|(.gif))$/', $fname);
        $count2=preg_match('/((.swf)|(.flv))$/', $fname);

        if($count > 0){ // images
          $option = "";
          $refname = "";
          $noaround = true;
          $wrapimage = "";
          $iscenter = true;
          $haslink = true;
          foreach($fnames as $opt){
             switch(trim($opt)){
               case "left":
                  $option = " align=\"left\" ";
          	  $iscenter = false;
                  break;
               case "center":
                  $option = " align=\"center\" ";
                  break;
               case "right":
                  $option = " align=\"right\" ";
          	  $iscenter = false;
                  break;
               case "around":
                  $noaround = false;
                  break;
               case "wrap":
                  $wrapimage = " style=\"border-style:solid\"";
                  break;
               case "nowrap":
                  $wrapimage = "";
                  break;
               case "nolink":
                  $haslink = false;
                  break;
               default:
		  if(strncmp($opt, "width=",6) && strncmp($opt, "length=",7)){
                    $refname = "alt=\"$opt\"";
		  }else{
                    $option .= $opt;
		  }
                  break;
             }
          }
          $str = "";
          if($iscenter)$str .= "<center>";

          $img_file = mkReferenceUrl($fname,"images");
          if($haslink) $str .= "<a href=\"$img_file\">";

          $str .= "<img src=\"$img_file\" $option $wrapimage $refname />";

          if($haslink)$str .="</a>";
          if($noaround) $str .="<br clear=\"all\" />";
          if($iscenter)$str .="</center>";

        }else if($count2 > 0){ // videos
          $option = "";
          $noaround = true;
          foreach($fnames as $opt){
             switch(trim($opt)){
               case "left":
                  $option = " align=\"left\" ";
                  break;
               case "center":
                  $option = " align=\"center\" ";
                  break;
               case "right":
                  $option = " align=\"right\" ";
                  break;
               default:
                  break;
             }
          }
          $video_file = mkReferenceUrl($fname,"videos");

          $str = "<div $option>";
          $str .=<<<_HTML
<embed src="$video_file" type="application/x-shockwave-flash" width="640" height="480"></embed>
<noembed> Please download FLASH Plug-in </noembed>
_HTML;
          $str .= "</div>";

        }else{ // attachments
          $refname = "";
          foreach($fnames as $opt){
             switch(trim($opt)){
               case "nolink":
                  $haslink = false;
                  break;
               default:
                  $refname = $opt;
                  break;
             }
          }

          $ref_file = mkReferenceUrl($fname,"attachments");
          $str = "<p>添付ファイル：";
	  if($refname) $str .= "<a href=\"$ref_file/download\" >$refname</a>";
          else $str .= "<a href=\"$ref_file/download\" >$fname</a>";
          $str .= " &nbsp; <a href=\"$ref_file/delete_file\" >[DEL]</a>";
        }
        return $str;

      case "CONTENTS":
        $str = $this->body->getContents();
        return "<div class=\"content_list\"><hr>".siwiki($str)."<hr></div>";

      default:
        $ref = $this->line;
        $pattern = '/#([\w]+)\(([\ \>\:\w\.\/\,\"\=\-]+)\)/';
        $c = preg_match($pattern, $ref, $match);
	if(!$c){
          $pattern = '/#([\w]+)/';
          $c = preg_match($pattern, $ref, $match);
	}
        $cmd=$match[1];
        $args=split(',',$match[2]);
	if(function_exists("plugin_".$cmd)){
          return call_user_func_array("plugin_".$cmd, $args);
        }else{
          return $this->line;
	}
    }
  }
}

/*
 *   PRE
 */
class Pre extends Block{
  function toString(){
  $res = $this->line;
   return "<pre>\n".htmlspecialchars($res)."</pre>\n";
  }
}

/*
 *   List
 */
class ListElement extends Block{
  var $rank;
  var $clist;
  var $type;

  function ListElement(&$line, $type){
    $this->line = $line;
    $this->content = array();
    $cont = count_chr($type, $line);
    $this->type = $type;
    
    str_shift($line);
    if($cont > 1){
      array_push($this->content,  new ListElement($line, $type));
    }else{
      array_push($this->content,  new ListItemElement($line, $this->type));
    }
  }

  function append(&$line, $type){
    $this->line .= $line;
    $cont = count_chr($type, $line);
    str_shift($line);

    if($type == '~'){
      $last = $this->content[count($this->content) -1]; 
      if(is_a($last, 'ListItemElement')){
        $x = array_pop($this->content);
        $x->append($type);
        $x->append($line);
        array_push($this->content, $x);
      }else{
        array_push($this->content, new ListItemElement($line, $this->type));
      }

    }else{

    if($cont > 1){
      $last = $this->content[count($this->content) -1]; 
//      if($last instanceof ListElement)
      if(is_a($last, 'ListElement'))
      {
//        $last->append($line, $type);
        $x = array_pop($this->content);
        $x->append($line, $type);
        array_push($this->content, $x);
      }else{
       array_push($this->content, new ListElement($line, $type));
      }
    }else{
        array_push($this->content, new ListItemElement($line, $this->type));
    }
    }
  }


  function toString(){
    switch($this->type){
      case '+':
        $tag = "ol";
        break;
      case ':':
        $tag = "dl";
        break;
      default:
        $tag = "ul";
        break;
    }
    $res =  "<$tag>\n";
    foreach($this->content as $content){ $res .= $content->toString(); }
    $res .=  "</$tag>\n";
    return $res;
  }
}

class ListItemElement extends Block{
  var $type;

  function ListItemElement(&$line, $type){
    $this->line = $line;
    $this->content = array(new Element($line));
    $this->type = $type;
  }

  function toString(){
    //$content = htmlspecialchars(parent::toString());
    $content = parent::toString();
    switch($this->type){
      case ':':
        $lst = explode('|',$content);
        if(count($lst) > 1){
          return "<dt>".$lst[0]."</dt>\n<dd>".$lst[1]."</dd>\n";
        }else{
          return "<dd>".$content."</dd>\n";
        }
        break;
      default:
        return "<li>".$content."</li>\n";
    }
  }
}

?>
