<?php
/*********************************************

 WISH(Web based Infomation SHaring system)
      =         =          ==  

   Copyright (C) 2003
        Isao Hara, Japan
                'All rights recieved.

 *********************************************/

class PDO_SQLite_db
{
  var $con;
  var $dbname, $passwd, $username, $topdir ;

  function PDO_SQLite_db($name, $top="./db"){
    $this->dbname = $name;
    $this->username = "root";
    $this->passwd = "";
    $this->topdir= $top;
  }

  function setDB($db){ $this->dbname = $db; }
  function setPasswd($p){ $this->passwd = $p; }
  function setTopDir($p){ $this->topdir = $p; }

  function connect(){
    try{
      $this->con = new PDO("sqlite:".$this->topdir."/".$this->dbname, null, null);
      return $this->con;
    }catch(PDOException $e){
      $this->con = "";
      return false;
    }
  }
  
/*********** Close DB ********/
  function close(){
    $this->con = null;
  }

  function begin(){ return $this->con->beginTransaction(); }
  function rollback(){ return $this->con->rollBack(); }
  function commit(){ return $this->con->commit(); }
  function end(){ return true; }

  function exec($str){ return $this->con->exec($str); }

  function sql_request($sqlstr, $alert=1){
   return new DB_Result($this->con, $sqlstr, $alert);
  }

  function createTable($name, $table){
    $query = "CREATE TABLE $name (";
    $query .= $table;
    $query .=")";

    try{
     $this->con->query($query);
    }catch(PDOException $exception){
      echo $exception->getMessage();
      return false;
    }
    return true;
  }

  function dropTable($name){
    $query = "DROP TABLE $name;";

    try{
     $this->con->query($query);
    }catch(PDOException $exception){
      echo $exception->getMessage();
      return false;
    }
    return true;
  }

  function getTableList(){
    $sql ="select name from sqlite_master where type='table' order by name;";
    try{
      $result = $this->con->query($sql);
    }catch(PDOException $exception){
       print "Error";
      return NULL;
    }
    if (!$result) {
       print "No data";
      return NULL;
    }
    $data = $result->fetchAll(PDO::FETCH_ASSOC);
    $res = array();
    foreach($data as $x){
       $res[] = $x['name'];
    }
    return $res;
  }

  function tableExists2($tbl){
    $tbls = $this->getTableList();
    foreach($tbls as $x){
      if($tbl == $x) return true;
    }
    return false;
  }

  function tableExists($tbl){
    $sql ="select * from sqlite_master where type='table' and name='$tbl';";

    try{
      $result = $this->con->query($sql);
    }catch(PDOException $exception){
       print "Error";
      return NULL;
    }
    if (!$result) {
      return NULL;
    }
    $data = $result->fetchAll(PDO::FETCH_ASSOC);
    return count($data);
  }

  function mkTable($name, $table){
    if($this->tableExists($name)) return true;
    return $this->createTable($name,$table);
  }
}

/***** SQL Query Result *********/

Class DB_Result{
  var $num, $val, $data;

  function DB_Result($conn, $sqlstr, $alert=1){
    if(!$conn) return NULL;
    $result = $conn->query($sqlstr);
    if (!$result) {
      if($alert){
        print "$sqlstr <br>";
        echo "<Script language=\"JavaScript\">\n";
        echo "alert('Fail to SQLite Query')\n";
        echo "</Script>\n";
      }
      return NULL;
    }
    $this->val = $result;
    $this->data = $result->fetchAll(PDO::FETCH_ASSOC);
    $this->num = count($this->data);
  }

  function getValue($n, $colname){
    if ($n < $this->num){
      if($colname == "oid") $colname="rowid";
      return $this->data[$n][$colname];
    }
    return NULL;
  }

  function clear(){
    $this->val =NULL;
    $this->data = NULL;
    $this->num = 0;
  }

  function fetchArray($n, $val=""){
    if ($n < $this->num){
      if( array_key_exists("rowid", $this->data[$n])){
        $this->data[$n]["oid"] = $this->data[$n]["rowid"];
      }else{
        $this->data[$n]["oid"] = 0;
      }
      return $this->data[$n];
    }
    return NULL;
  }

}

/************************************************
  DB access
************************************************/

function OpenDB($dbname, $dir = "./db"){
  $_db = new PDO_SQLite_db($dbname);
  $_db->setTopDir($dir);

  if(!$_db->connect()){
    throw new Exception("Error in access database :".$dbname);
  }
  return $_db;
}

function CreateTable($db, $tbl_name, $tbl_schema){
  $res = $db->sql_request("select * from ".$tbl_name.";",0);
  if(!$res->val){
     $db->createTable($tbl_name, $tbl_schema);
  }
}
?>
