<?php
/*
 SiWiki

 Copyright(C) 2007-2013, Isao Hara
*/


include("siwiki.header.php");

ChkVal($_SIWIKI['page'], 'page','');
checkValue($title, "");

if(!file_exists(".htaccess")){
  print <<<_HTML
<html>
<head>
<meta http-equiv="Content-Type" content="text/html">
<title>Jump to Install.php</title>
<meta http-equiv="REFRESH" content="0;URL=install.php">

</head>
</html> 
_HTML;
   exit;
}

$jscripts="";

$langLink = otherLangPage($_SIWIKI['langs'], $_SESSION['lang'], $_SIWIKI['category'], $fname, $sub);

$flg_file = file_exists($_SIWIKI['filename']);

if($thisFile == "index.php") $is_admin = false;
else $is_admin = true;
if($thisFile == "ajax.php") $is_ajax = true;
else $is_ajax = false;

$is_user = $is_admin = false;
if(isset($_SESSION['uid'])){
  $chk_user = get_user_level($_SESSION['uid']);
}else{
  $chk_user = get_user_level("guest");
}

if($chk_user >POWER_USER ){
  $is_admin = true;
  $is_user = true;
} else{
  if($chk_user > GUEST_USER){
    $is_user = true;
  }
}

if(!isset($_SIWIKI['member_only'])){
  $_SIWIKI['member_only'] = false;
}


if($_SIWIKI['member_only'] && $is_user == false) {
    $content = "<div id=\"wiki\">";
    $content.= "Member only, please login...";
    $content .= "</div>";

}else{

  if(!$sub){
    if(!$flg_file){
      if(!file_exists($_SIWIKI['wiki_dir'])){
        $site = $_SIWIKI['site'];
        $top = $_SIWIKI['top'];
        $content = file_get_contents($error404);
        $content .= "<div id=\"wiki\">";
        $content .= "<h2>No such Site</h2>";
        if(is_system_admin()){
          $content.= "<br> If you want to create a new site, '$site', <p> Click <a href=\"$top/_$site/install.php\">here</a>.";
        }else{
          $content.= "<br> If you want to create a new site, '$site', <p> Please contact to the system administrator.";
        }
        $content .= "</div>";
      }else{
        $filename = $_SIWIKI['filename'];
        $content = file_get_contents($error404);
        $content .= "<div id=\"wiki\">";
        $content .= "<h2>No such Document</h2>";
        $content .= "<b> Filename : </b>". $fname.".html";
        
        if(isset($_SERVER['HTTP_REFERER'])){
          $parent = str_replace('%','',basename($_SERVER['HTTP_REFERER']));
          $parent = str_replace('.html','',$parent);
        }else{
          $parent = "NoReferer";
        }
        
        $self=getStaticPage($_SESSION['lang'], $_SESSION['category'], $fname);

        if($chk_user){
          $content.= "<br> If you want to create a new file, '$fname', <p>Click <a href=\"$self/edit&cmd=new&parent=$parent\">here</a>.";
        }

        $content .= "</div>";
      }
    }else{

      $data = load_contexts_tree();
      $cont = file_get_contents($_SIWIKI['filename']);
      $UPDATE = filemtime($_SIWIKI['filename']);
  
      $wiki_body = convert_to_body($cont);
      record_access_count($_SIWIKI['dirname']);

      if(!isset($subtitle)) $subtitle = "";
      $subtitle .= $wiki_body->title;
      if(!isset($title)) $title = "";
      $title .= $wiki_body->title;
      
      $content_navi .= "<div style=\"font-size:10pt;color:#884444;\">";
      $content_navi .= getContentTree($data, $_SIWIKI['pagename']);
      $content_navi .="</div>\n";

      $content = "<div id=\"wiki\">";
      $content .= $wiki_body->toString();
      $content .= "</div>";

    }
  }else if($sub=="download"){
    $title .= "Wiki: File Download";
    include("programs/wiki/download.php");
  }else if($sub=="image" || $sub == "images"){
    include("programs/wiki/image.php");
  }else if($sub=="video" || $sub == "videos"){
    include("programs/wiki/video.php");
  }else{
    include($error404);
  }
}

if($is_ajax){
  print $content;

}else{


  if(!isset($_SIWIKI['member_only']) || !$_SIWIKI['member_only'] || $is_user) {
    $menu=getMenu(); 
    $categorylist = mkCategoryList();
  }

  if(file_exists($_SIWIKI['siwiki_dir']."/".TEMPLATEPATH . "/functions.php")){
    include(TEMPLATEPATH . "/functions.php");
  }

  include($_SIWIKI['template']);
}
?>
