/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;

public class Toy
extends Obj
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final int BALL = 0;
    private static final int SHADOW = 1;
    private static final int NUM_OF_BALL_IMG = 2;
    private static int toysize = 16;
    private static Image[] images = new Image[2];
    private Body owner = null;
    private static int value = 100;

    public static void loadImages(ClassLoader loader, String path) throws IOException {
        path = String.valueOf(path) + "toy/";
        Toy.images[0] = ImageIO.read(loader.getResourceAsStream(String.valueOf(path) + "ball.png"));
        Toy.images[1] = ImageIO.read(loader.getResourceAsStream(String.valueOf(path) + "shadow.png"));
        int i = 0;
        while (i < 2) {
            Toy.images[i] = images[i].getScaledInstance(toysize, toysize, 16);
            ++i;
        }
    }

    @Override
    public Image getImage() {
        return images[0];
    }

    @Override
    public Image getShadowImage() {
        return images[1];
    }

    @Override
    public int getSize() {
        return toysize;
    }

    public static int getSizeS() {
        return toysize;
    }

    @Override
    public void grab() {
        this.owner = null;
        this.grabbed = true;
    }

    @Override
    public void kick() {
        this.kick(0, -8, -4);
    }

    public void setOwner(Body b) {
        this.owner = b;
    }

    public Body getOwner() {
        return this.owner;
    }

    public boolean isOwned(Body b) {
        return this.owner == b;
    }

    @Override
    public int getPrice(Obj.Price priceType) {
        if (priceType == Obj.Price.SELLING) {
            return value / 2;
        }
        return value;
    }

    public Toy(int initX, int initY) {
        this.objType = Obj.Type.TOY;
        this.x = initX;
        this.y = initY;
        this.z = 0;
        this.removed = false;
    }
}

