<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
//                   This module; Copyright (c) 2005 suin                    //
//                          <http://www.suin.jp>                             //
//  ------------------------------------------------------------------------ //
include( '../../mainfile.php' );

//⥸塼̾
$mydirname = basename( dirname( __FILE__ ) ) ;
$myurl  = XOOPS_URL . '/modules/' . $mydirname ;
$mypath = XOOPS_ROOT_PATH . '/modules/' . $mydirname ;

//˥ɤ߹
$myts =& MyTextSanitizer::getInstance();

//ڥ졼
$op = isset( $_REQUEST['op'] ) ? $_REQUEST['op'] : 'default';

//
$tkhConf = $xoopsModuleConfig;

//2000h饹
require_once( $mypath. '/class/2kh.php' );
require_once( $mypath. '/class/2kh_user.php' );
require_once( $mypath. '/class/2kh_comment.php' );

//GåȥƥƤӽФ
include_once( $mypath. '/include/gtickets.php' );

$comment = isset( $_POST['comment'] ) ? $myts->stripSlashesGPC( $myts->htmlSpecialChars( $_POST['comment'] ) ) : "" ;

switch($op){
case 'default':
default:

	//uid̵
	$uid = isset($_REQUEST['uid']) ? intval($_REQUEST['uid']) : 0 ;
	if ($uid <= 0) {
		redirect_header($myurl, 3, _MD_SELECTNG);
		exit();
	}

	//XoopsUser饹
	$member_handler =& xoops_gethandler('member');
	$thisUser =& $member_handler->getUser($uid);
	
	//桼¸ߤʤ
	if (!is_object($thisUser) || !$thisUser->isActive()) {
		redirect_header($myurl, 3, _MD_USER_NOT_EXISTS);
		exit();
	}

	//ƥץ졼
	$xoopsOption['template_main'] = '2kh_user.html';
	
	require_once( XOOPS_ROOT_PATH.'/header.php' );

	//ʥ
	$navi    = "" ;
	$limit   = $tkhConf['2kh_records_user_page'];
	$numrows = Twokh::getCountByUid($uid);
	$start   = isset( $_GET['start'] ) ? intval( $_GET['start'] ) : 0 ;
	if( $numrows > $limit) {
		require_once( $mypath.'/class/pagenav.php' );
		$nav = new SuinPageNav($numrows,$limit,$start, 'start', 'uid='.$uid);
		$navi = $nav->renderNavPreNxt();
	}

	//ꥹȼ
	$criteria = array('uid='.$uid);
	$log_arr =& Twokh::getAll($criteria, true, 'time DESC', $limit, $start);

	//äƤʤ桼ξ
	if ( empty( $log_arr[0] ) || !is_object( $log_arr[0] ) ){
		redirect_header($myurl, 3, _MD_NONE_ENGRGE_USER);
		exit();
	}
	
	//ϿŸ
	$count = count($log_arr);
	for ( $i = 0; $i < $count; $i++ ) {
		$logs = array();

		$min     = $log_arr[$i]->getHours();
		$time    = $log_arr[$i]->getDate($tkhConf['2kh_date_format']);
		$total   = $log_arr[$i]->getTotalAsHours();
		$average = $log_arr[$i]->getAvarageAsHours();
		$cons    = $log_arr[$i]->getConstant();

		$logs['min']      = sprintf( _MD_HOURS, $min );
		$logs['date']     = $time;
		$logs['total']    = sprintf( _MD_HOURS, $total );
		$logs['average']  = sprintf( _MD_HOURS, $average );
		$logs['constant'] = sprintf( _MD_X_PAR_DAY, $cons );

		$xoopsTpl->append('logs', $logs);
	}

	//ȥʥ
	$navi       = "" ;
	$comlimit   = $tkhConf['2kh_records_user_page'];
	$numrows    = TkwComment::getCountByUid($uid);
	$comstart   = isset( $_GET['start'] ) ? intval( $_GET['comstart'] ) : 0 ;
	if( $numrows > $limit) {
		require_once( $mypath.'/class/pagenav.php' );
		$nav = new SuinPageNav($numrows,$comlimit,$comstart, 'comstart', 'uid='.$uid);
		$navi = $nav->renderNavPreNxt();
	}

	//ꥹȼ
	$com_criteria = array('pid='.$uid);
	$com_arr =& TkwComment::getAll($com_criteria, true, 'time DESC', $comlimit, $comstart);

	//Ÿ
	$c_count = count($com_arr);
	for ( $i = 0; $i < $c_count; $i++ ) {
		$logs = array();

		$coms['id']      = $com_arr[$i]->getVar('id');
		$coms['uname']   = $com_arr[$i]->getUname();
		$coms['uid']     = $com_arr[$i]->getVar('uid');
		$coms['comment'] = $com_arr[$i]->getVar('comment');
		$coms['time']    = $com_arr[$i]->getTime('m/d H:i');

		$xoopsTpl->append('coms', $coms);
	}

	//Х
	$avatar = $thisUser->getVar('user_avatar');
	if( $avatar == 'blank.gif' || empty($avatar) ){
		$xoopsTpl->assign('exists_avatar', false);
	}else{
		$xoopsTpl->assign('exists_avatar', true);
	}

	//
	$newest_arr =& Twokh::getAll($criteria, true, 'time DESC', 1, 0);

	//ɸ
	$tkw_user =& new TkwUsers($uid);
	$goal  = ( is_object( $tkw_user ) ) ? $tkw_user->getGoalDate($tkhConf['2kh_date_format']) : "" ;
	$days  = ( is_object( $tkw_user ) ) ? $tkw_user->getUntilGoalDate(_MD_DAYS) : "" ;
	$hoad  = ( is_object( $tkw_user ) ) ? $tkw_user->getHoursADay($newest_arr[0]->getLeftHours($tkhConf['2kh_goal'])) : "" ;
	$ardor = ( is_object( $tkw_user ) ) ? $tkw_user->getVar('ardor') : "" ;
	$comme = ( is_object( $tkw_user ) ) ? $tkw_user->getVar('comment') : 0 ;
	$comme = ( $comme == 0 ) ? _MD_COMMENT_DESC0 : _MD_COMMENT_DESC1 ;

	//
	$average = $newest_arr[0]->getAvarageAsHours();
	$frequen = $newest_arr[0]->getConstant();
	$leftday = $newest_arr[0]->getExpectLeftDays($tkhConf['2kh_goal']);
	$findate = $newest_arr[0]->getExpectFinDate($tkhConf['2kh_goal'], _MD_DATE_FORMAT2);
	$bf_arr = array('{AVERAGE}','{FREQ}','{HOURS}','{DAYS}','{DATE}');
	$af_arr = array($average,$frequen, $tkhConf['2kh_goal'], $leftday, $findate);
	$user_note = str_replace($bf_arr, $af_arr, _MD_INVESTIGATE);

	if( !empty($goal) ){
		$bf_arr = array('{GOAL}','{HOURSADAY}');
		$af_arr = array($goal,$hoad);
		$user_note .= str_replace($bf_arr, $af_arr, _MD_INVESTIGATE2);
	}

	//
	$xoopsTpl->assign('lang_record', sprintf(_MD_X_RECORD,$thisUser->getVar('uname')));
	$xoopsTpl->assign('lang_no_logs', _MD_NO_RECORDS);
	$xoopsTpl->assign('lang_user', _MD_USER);
	$xoopsTpl->assign('lang_date', _MD_DATE);
	$xoopsTpl->assign('lang_min', _MD_MIN);
	$xoopsTpl->assign('lang_total', _MD_TOTAL);
	$xoopsTpl->assign('lang_average', _MD_AVERAGE);
	$xoopsTpl->assign('lang_start', _MD_START);
	$xoopsTpl->assign('lang_constant', _MD_CONSTANT);
	$xoopsTpl->assign('lang_hours', sprintf(_MD_X_Y_HOURS,$thisUser->getVar('uname'), $tkhConf['2kh_goal']));
	$xoopsTpl->assign('lang_status', _MD_STATUS);
	$xoopsTpl->assign('lang_goal', _MD_GOAL);
	$xoopsTpl->assign('lang_left', _MD_LEFT);
	$xoopsTpl->assign('lang_countdown', _MD_COUNTDOWN);
	$xoopsTpl->assign('lang_parcent', _MD_PARCENT);
	$xoopsTpl->assign('lang_note', _MD_NOTE);
	$xoopsTpl->assign('lang_ardor', _MD_ARDOR);
	$xoopsTpl->assign('lang_comment', _MD_COMMENTS);
	$xoopsTpl->assign('lang_confirm', _MD_CONFIRM_S);
	$xoopsTpl->assign('lang_comment_desc', sprintf( $comme, $thisUser->getVar('uname') ) );
	$xoopsTpl->assign('lang_delete', _DELETE );

	$xoopsTpl->assign('user_name', sprintf(_MD_SAN,$thisUser->getVar('uname')));
	$xoopsTpl->assign('user_avatar', XOOPS_UPLOAD_URL.'/'.$avatar);
	$xoopsTpl->assign('user_id', $uid);
	$xoopsTpl->assign('user_start', $newest_arr[0]->getBegunDate($tkhConf['2kh_date_format']));
	$xoopsTpl->assign('user_goal', $goal);
	$xoopsTpl->assign('user_left', sprintf( _MD_HOURS, $newest_arr[0]->getLeftHours($tkhConf['2kh_goal']) ) );
	$xoopsTpl->assign('user_countdown', $days);
	$xoopsTpl->assign('user_parcent', sprintf(_MD_PAR, $newest_arr[0]->getRate($tkhConf['2kh_goal'])));
	$xoopsTpl->assign('user_note', $user_note);
	$xoopsTpl->assign('user_ardor', $ardor);
	$xoopsTpl->assign('myurl', $myurl);
	$xoopsTpl->assign('navi', $navi);
	$xoopsTpl->assign('comment', $comment);
	$xoopsTpl->assign('credit', '<a href="http://www.suin.jp/" target="_blank">2kh</a>');

	require_once( XOOPS_ROOT_PATH.'/footer.php' );

	break;

case 'comment_conf':

	//uid̵
	$uid = isset($_POST['uid']) ? intval($_POST['uid']) : 0 ;
	if ($uid <= 0) {
		redirect_header($myurl, 3, _MD_SELECTNG);
		exit();
	}

	//Ȥ
	if( empty($comment) ){
		redirect_header($myurl.'/records.php?uid='.$uid, 5, _MD_NO_COMMENT);
		exit();
	}

	//桼̵
	if ( !$xoopsUser ) {
		redirect_header($myurl.'/records.php?uid='.$uid, 3, _NOPERM);
		exit();
	}

	//XoopsUser饹
	$member_handler =& xoops_gethandler('member');
	$thisUser =& $member_handler->getUser($uid);
	$tkw_user =& new TkwUsers($uid);
	$comme = ( is_object( $tkw_user ) ) ? $tkw_user->getVar('comment') : 0 ;
	
	//桼¸ߤʤ
	if (!is_object($thisUser) || !$thisUser->isActive()) {
		redirect_header($myurl.'/', 3, _MD_USER_NOT_EXISTS);
		exit();
	}

	//ܿͤΤߤʤΤ¾ͤΥ桼ξ
	if( $xoopsUser->getVar('uid') != $uid && $comme == 0 ){
		redirect_header($myurl.'/records.php?uid='.$uid, 3, _MD_UNABLE_COMMENT);
		exit();
	}

	//ƥץ졼
	$xoopsOption['template_main'] = '2kh_confirm.html';

	require_once( XOOPS_ROOT_PATH.'/header.php' );

	$conf_arr = array( 'caption' => _MD_COMMENTS, 'content' => $comment, 'name' => 'comment', 'value' => $comment );
	$xoopsTpl->append('confirm', $conf_arr);

	//
	$xoopsTpl->assign('lang_confirm_title', _MD_CONFIRM_FORM);
	$xoopsTpl->assign('lang_submit', _MD_CREATE);
	$xoopsTpl->assign('lang_correction', _MD_CORRECT);
	$xoopsTpl->assign('op_value', 'comment_post');
	$xoopsTpl->assign('action_url', $myurl.'/records.php');
	$xoopsTpl->assign('myurl', $myurl);
	//åȯ
	$xoopsTpl->assign('hiddenelements', $xoopsGTicket->getTicketHtml( __LINE__ ).'<input type="hidden" name="uid" value="'.$uid.'" />');
	$xoopsTpl->assign("xoops_module_header", $xoopsTpl->get_template_vars("xoops_module_header") . '<script language="JavaScript" src="'.XOOPS_URL.'/modules/' .$mydirname. '/include.js"></script>');

	require_once( XOOPS_ROOT_PATH.'/footer.php' );

	break;

case 'comment_post':

	$comment = isset( $_POST['comment'] ) ? $myts->addSlashes( $_POST['comment'] ) : "" ;

	//uid̵
	$uid = isset($_POST['uid']) ? intval($_POST['uid']) : 0 ;
	if ($uid <= 0) {
		redirect_header($myurl, 3, _MD_SELECTNG);
		exit();
	}

	//Ȥ
	if( empty($comment) ){
		redirect_header($myurl.'/records.php?uid='.$uid, 5, _MD_NO_COMMENT);
		exit();
	}

	//桼̵
	if ( !$xoopsUser ) {
		redirect_header($myurl.'/records.php?uid='.$uid, 3, _NOPERM);
		exit();
	}

	//XoopsUser饹
	$member_handler =& xoops_gethandler('member');
	$thisUser =& $member_handler->getUser($uid);
	$tkw_user =& new TkwUsers($uid);
	$comme = ( is_object( $tkw_user ) ) ? $tkw_user->getVar('comment') : 0 ;
	
	//桼¸ߤʤ
	if (!is_object($thisUser) || !$thisUser->isActive()) {
		redirect_header($myurl, 3, _MD_USER_NOT_EXISTS);
		exit();
	}

	//ܿͤΤߤʤΤ¾ͤΥ桼ξ
	if( $xoopsUser->getVar('uid') != $uid && $comme == 0 ){
		redirect_header($myurl.'/records.php?uid='.$uid, 3, _MD_UNABLE_COMMENT);
		exit();
	}

	//¸
	$new_comm =& new TkwComment();
	$new_comm->setVar('uid', $xoopsUser->getVar('uid'));
	$new_comm->setVar('pid', $uid);
	$new_comm->setVar('comment', $comment);
	$new_comm->setVar('time', time());

	if( !$new_comm->store() ){
		redirect_header($myurl.'/records.php?uid='.$uid, 10, _MD_DB_FAILUE);
		exit();
	}
	redirect_header($myurl.'/records.php?uid='.$uid, 3, _MD_DB_UPDATE);
	exit();

	break;

case 'comment_del':

	//uid̵
	$pid = isset($_GET['pid']) ? intval($_GET['pid']) : 0 ;
	if ($pid <= 0) {
		redirect_header($myurl, 3, _MD_SELECTNG);
		exit();
	}

	//id̵
	$id = isset($_GET['id']) ? intval($_GET['id']) : 0 ;
	if ($id <= 0) {
		redirect_header($myurl.'/records.php?uid='.$pid, 3, _MD_SELECTNG);
		exit();
	}

	//桼̵
	if ( !$xoopsUser ) {
		redirect_header($myurl.'/records.php?uid='.$pid, 3, _NOPERM);
		exit();
	}

	//ʡǤʤ
	if( $xoopsUser->getVar('uid') != $pid ){
		redirect_header($myurl.'/records.php?uid='.$pid, 3, _MD_UNABLE_DEL_COMMENT);
		exit();
	}

	require_once( XOOPS_ROOT_PATH.'/header.php' );

	xoops_confirm(array('op' => 'comment_delete', 'id' => $id, 'pid' => $pid), 'records.php', _MD_DEL_COMMENT);

	require_once( XOOPS_ROOT_PATH.'/footer.php' );

	break;

case 'comment_delete':

	//uid̵
	$pid = isset($_POST['pid']) ? intval($_POST['pid']) : 0 ;
	if ($pid <= 0) {
		redirect_header($myurl, 3, _MD_SELECTNG);
		exit();
	}

	//id̵
	$id = isset($_POST['id']) ? intval($_POST['id']) : 0 ;
	if ($id <= 0) {
		redirect_header($myurl.'/records.php?uid='.$pid, 3, _MD_SELECTNG);
		exit();
	}

	//桼̵
	if ( !$xoopsUser ) {
		redirect_header($myurl.'/records.php?uid='.$pid, 3, _NOPERM);
		exit();
	}

	//ʡǤʤ
	if( $xoopsUser->getVar('uid') != $pid ){
		redirect_header($myurl.'/records.php?uid='.$pid, 3, _MD_SELECTNG);
		exit();
	}

	$del_comment = new TkwComment($id);

	if( !$del_comment->delete() ){
		redirect_header($myurl.'/records.php?uid='.$pid, 10, _MD_DB_FAILUE);
		exit();
	}
	redirect_header($myurl.'/records.php?uid='.$pid, 3, _MD_DB_UPDATE);
	exit();

	break;

}
?>