<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;

require_once( XOOPS_ROOT_PATH.'/class/xoopsformloader.php' );

class SuinFormDate extends XoopsFormElementTray
{

	function SuinFormDate($caption, $name, $value=0, $past=2, $future=2)
	{

		if( is_array( $value ) ){

			$year  = ( isset( $value['y'] ) ) ? intval( $value['y'] ) : date('Y', $value) ;
			$month = ( isset( $value['m'] ) ) ? intval( $value['m'] ) : date('n', $value) ;
			$day   = ( isset( $value['d'] ) ) ? intval( $value['d'] ) : date('j', $value) ;

		}elseif( is_long( $value ) && !empty( $value ) ){

			$year  = date('Y', $value);
			$month = date('n', $value);
			$day   = date('j', $value);

		}else{
			$value = time();
			$year  = date('Y', $value);
			$month = date('n', $value);
			$day   = date('j', $value);
		}

		$year_array  = array();
		$month_array = array();
		$day_array   = array();

		$this->XoopsFormElementTray($caption, '');
		$yearselect  = new XoopsFormSelect('',        $name.'[y]', $year);
		$monthselect = new XoopsFormSelect(_XF_YEAR,  $name.'[m]', $month);
		$dayselect   = new XoopsFormSelect(_XF_MONTH, $name.'[d]', $day);
		$daydummy    = new XoopsFormLabel(_XF_DAY, '<br />');

		$Y = date('Y');
		for($i=$Y-$past;$i<=$Y+$future;$i++) $year_array[$i]  = $i;
		for($i=1;$i<=12;$i++)      $month_array[$i] = $i;
		for($i=1;$i<=31;$i++)      $day_array[$i]   = $i;

		$yearselect->addOptionArray($year_array);
		$monthselect->addOptionArray($month_array);
		$dayselect->addOptionArray($day_array);
		$this->addElement($yearselect);
		$this->addElement($monthselect);
		$this->addElement($dayselect);
		$this->addElement($daydummy);
	}
}
?>