<?php
if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;

require_once( XOOPS_ROOT_PATH."/class/xoopsobject.php" );

define("DB_TABLE2", "2kh_users");

class TkwUsers extends XoopsObject{

	var $db;

	function TkwUsers($id=null)
	{
		// * key	string	
		// * data-type	int	
		//   +  1 - XOBJ_DTYPE_TXTBOX | 2 - XOBJ_DTYPE_TXTAREA | 3 - XOBJ_DTYPE_INT
		//   +  4 - XOBJ_DTYPE_URL    | 5 - XOBJ_DTYPE_EMAIL   | 6 - XOBJ_DTYPE_ARRAY
		//   +  7 - XOBJ_DTYPE_OTHER  | 8 - XOBJ_DTYPE_SOURCE  | 9 - XOBJ_DTYPE_STIME
		//   +  10 - XOBJ_DTYPE_MTIME | 11 - XOBJ_DTYPE_LTIME
		// * value	mixed	
		// * required	bool	require html form input?
		// * maxlength	int 	for XOBJ_DTYPE_TXTBOX type only.
		// * options	string	does this data have any select options?

		$this->db =& Database::getInstance();
		$this->initVar("id",         XOBJ_DTYPE_INT,     null, false );
		$this->initVar("goal",       XOBJ_DTYPE_INT,     null, false );
		$this->initVar("ardor",      XOBJ_DTYPE_TXTAREA, null, false, 250 );
		$this->initVar("comment",    XOBJ_DTYPE_INT,     null, false );

		if ( !empty($id) ) {
			if ( is_array($id) ) {
				$this->assignVars($id);
			} else {
				$this->load(intval($id));
			}
		}
	}

	function load($id)
	{
		$sql = "SELECT * FROM ".$this->db->prefix(DB_TABLE2)." WHERE id=".$id."";
		$myrow = $this->db->fetchArray($this->db->query($sql));
		if( empty($myrow) ) return false;
		$this->assignVars($myrow);
	}

	function store()
	{
		if ( !$this->cleanVars() ) {
			return false;
		}

		$ins_into = "" ;
		$ins_set  = "" ;
		$upd_set  = "" ;
		foreach ( $this->cleanVars as $k=>$v ) {
			$$k = $v;
			$ins_into .= "$k, " ;
			$ins_set .= $this->db->quoteString($v)." ," ;
			$upd_set .= $k."=".$this->db->quoteString($v).", " ;
		}
		$ins_into = substr($ins_into, 0, -2);
		$ins_set  = substr($ins_set, 0, -2);
		$upd_set  = substr($upd_set, 0, -2);

		if ( !$this->isExists() ) {
			$id = $this->db->genId($this->db->prefix(DB_TABLE2)."_id_seq");
			$sql = "INSERT INTO ".$this->db->prefix(DB_TABLE2)." (".$ins_into.") VALUES (".$ins_set.")";
		} else {
			$sql ="UPDATE ".$this->db->prefix(DB_TABLE2)." SET ".$upd_set." WHERE id=".$this->getVar('id');
		}

		//echo $sql;

		if ( !$result = $this->db->query($sql) ) {
			$this->setErrors("Could not store data in the database.");
			return false;
		}

	        if (empty($id)) {
			$id = $this->db->getInsertId();
	        }

	        $this->assignVar('id', $id);

	        return true;
	}

	function delete()
	{
		$sql = sprintf("DELETE FROM %s WHERE id = %u", $this->db->prefix(DB_TABLE2), $this->getVar("id"));
        	if ( !$this->db->query($sql) ) {
			return false;
		}
		return true;
	}

	function &getAll($criteria=array(), $asobject=true, $orderby="id DESC", $limit=0, $start=0)
	{
		$db =& Database::getInstance();
		$ret = array();
		$where_query = "";
		if ( is_array($criteria) && count($criteria) > 0 ) {
			$where_query = " WHERE";
			foreach ( $criteria as $c ) {
				$where_query .= " $c AND";
			}
			$where_query = substr($where_query, 0, -4);
		}
		if ( !$asobject ) {
			$sql = "SELECT id FROM ".$db->prefix(DB_TABLE2)."$where_query ORDER BY $orderby";
			$result = $db->query($sql,intval($limit),intval($start));
			while ( $myrow = $db->fetchArray($result) ) {
				$ret[] = $myrow['id'];
			}
		} else {
			$sql = "SELECT * FROM ".$db->prefix(DB_TABLE2)."".$where_query." ORDER BY $orderby";
			$result = $db->query($sql,$limit,$start);
			while ( $myrow = $db->fetchArray($result) ) {
				$ret[] = new TkwUsers($myrow);
			}
		}
		//echo $sql;
		return $ret;
	}

	function isExists(){
		$sql = sprintf("SELECT COUNT(*) FROM %s WHERE id=%u", $this->db->prefix(DB_TABLE2), $this->getVar('id'));
		list($count) = $this->db->fetchRow($this->db->query($sql));
		if( $count == 0 ){
			return false;
		}else{
			return true;
		}
	}

	function getGoalDate($timeformat = "Y-m-d")
	{
		if( ( $goal = $this->getVar('goal') ) == 0 ) return false;
		return date($timeformat, $goal);
	}

	function getUntilGoalDate($timeformat = "%udays")
	{
		if( ( $goal = $this->getVar('goal') ) == 0 ) return false;
		$days = sprintf($timeformat , ceil( ( $goal - time() ) / ( 60 * 60 * 24 ) ) );
		return $days;
	}

	function getHoursADay($left)
	{
		if( ( $goal = $this->getVar('goal') ) == 0 ) return false;
		return ceil( 1999 / ceil( ( $goal - time() ) / ( 60 * 60 * 24 ) ) ) ;
	}

}
?>