<?php
if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;

require_once( XOOPS_ROOT_PATH."/class/xoopsobject.php" );

define("DB_TABLE1", "2kh_log");

class Twokh extends XoopsObject{

	var $db;

	function Twokh($id=null)
	{
		// * key	string	
		// * data-type	int	
		//   +  1 - XOBJ_DTYPE_TXTBOX | 2 - XOBJ_DTYPE_TXTAREA | 3 - XOBJ_DTYPE_INT
		//   +  4 - XOBJ_DTYPE_URL    | 5 - XOBJ_DTYPE_EMAIL   | 6 - XOBJ_DTYPE_ARRAY
		//   +  7 - XOBJ_DTYPE_OTHER  | 8 - XOBJ_DTYPE_SOURCE  | 9 - XOBJ_DTYPE_STIME
		//   +  10 - XOBJ_DTYPE_MTIME | 11 - XOBJ_DTYPE_LTIME
		// * value	mixed	
		// * required	bool	require html form input?
		// * maxlength	int 	for XOBJ_DTYPE_TXTBOX type only.
		// * options	string	does this data have any select options?

		$this->db =& Database::getInstance();
		$this->initVar("id",         XOBJ_DTYPE_INT,     null, false );
		$this->initVar("min",        XOBJ_DTYPE_INT,     null, false );
//		$this->initVar("total",      XOBJ_DTYPE_INT,     null, false );
		$this->initVar("time",       XOBJ_DTYPE_INT,     null, false );
		$this->initVar("date",       XOBJ_DTYPE_TXTBOX,  null, false, 10 );
		$this->initVar("uid",        XOBJ_DTYPE_INT,     null, false );

		if ( !empty($id) ) {
			if ( is_array($id) ) {
				$this->assignVars($id);
			} else {
				$this->load(intval($id));
			}
		}
	}

	function load($id)
	{
		$sql = "SELECT * FROM ".$this->db->prefix(DB_TABLE1)." WHERE id=".$id."";
		$myrow = $this->db->fetchArray($this->db->query($sql));
		$this->assignVars($myrow);
	}

	function store()
	{
		if ( !$this->cleanVars() ) {
			return false;
		}

		$ins_into = "" ;
		$ins_set  = "" ;
		$upd_set  = "" ;
		foreach ( $this->cleanVars as $k=>$v ) {
			$$k = $v;
			if( $k == 'id' ) continue;
			$ins_into .= "$k, " ;
			$ins_set .= $this->db->quoteString($v)." ," ;
			$upd_set .= $k."=".$this->db->quoteString($v).", " ;
		}
		$ins_into = substr($ins_into, 0, -2);
		$ins_set  = substr($ins_set, 0, -2);
		$upd_set  = substr($upd_set, 0, -2);

		if ( empty($id) ) {
			$id = $this->db->genId($this->db->prefix(DB_TABLE1)."_id_seq");
			$sql = "INSERT INTO ".$this->db->prefix(DB_TABLE1)." (".$ins_into.") VALUES (".$ins_set.")";
		} else {
			$sql ="UPDATE ".$this->db->prefix(DB_TABLE1)." SET ".$upd_set." WHERE id=".$this->getVar('id');
		}

		//echo $sql;

		if ( !$result = $this->db->query($sql) ) {
			$this->setErrors("Could not store data in the database.");
			return false;
		}

	        if (empty($id)) {
			$id = $this->db->getInsertId();
	        }

	        $this->assignVar('id', $id);

	        return true;
	}

	function delete()
	{
		$sql = sprintf("DELETE FROM %s WHERE id = %u", $this->db->prefix(DB_TABLE1), $this->getVar("id"));
        	if ( !$this->db->query($sql) ) {
			return false;
		}
		return true;
	}

	function &getAll($criteria=array(), $asobject=true, $orderby="id DESC", $limit=0, $start=0)
	{
		$db =& Database::getInstance();
		$ret = array();
		$where_query = "";
		if ( is_array($criteria) && count($criteria) > 0 ) {
			$where_query = " WHERE";
			foreach ( $criteria as $c ) {
				$where_query .= " $c AND";
			}
			$where_query = substr($where_query, 0, -4);
		}
		if ( !$asobject ) {
			$sql = "SELECT id FROM ".$db->prefix(DB_TABLE1)."$where_query ORDER BY $orderby";
			$result = $db->query($sql,intval($limit),intval($start));
			while ( $myrow = $db->fetchArray($result) ) {
				$ret[] = $myrow['id'];
			}
		} else {
			$sql = "SELECT * FROM ".$db->prefix(DB_TABLE1)."".$where_query." ORDER BY $orderby";
			$result = $db->query($sql,$limit,$start);
			while ( $myrow = $db->fetchArray($result) ) {
				$ret[] = new Twokh($myrow);
			}
		}
		//echo $sql;
		return $ret;
	}

	function getBegunDate($timeformat = "Y-m-d")
	{
		$sql = "SELECT time FROM ".$this->db->prefix(DB_TABLE1)." WHERE uid=".$this->getVar('uid')." ORDER BY `time` ASC  LIMIT 0 , 1";
		list( $time ) = $this->db->fetchRow($this->db->query($sql));
		return date($timeformat, $time);
	}

	function getDate($timeformat = "Y-m-d")
	{
		return date($timeformat, $this->getVar('time'));
	}

	function getAvarage()
	{
		$sql = "SELECT COUNT(*) FROM ".$this->db->prefix(DB_TABLE1)." WHERE uid=".$this->getVar('uid')." AND time<=". $this->getVar('time');
		list( $count ) = $this->db->fetchRow($this->db->query($sql));
		return round( $this->getTotal() / $count, 1 );
	}

	function getAvarageAsHours()
	{
		return round( $this->getAvarage() / 60, 1 );
	}

	function getHours()
	{
		return round( $this->getVar('min') / 60, 1 );
	}

	function getTotal()
	{
		$sql = "SELECT sum(min) FROM ".$this->db->prefix(DB_TABLE1)." WHERE uid=".$this->getVar('uid')." AND time<=". $this->getVar('time');
		list( $total ) = $this->db->fetchRow($this->db->query($sql));
		return $total;
	}

	function getTotalAsHours()
	{
		return round( $this->getTotal() / 60, 1 );
	}

	function getLeftHours($norm=0)
	{
		return  $norm - $this->getTotalAsHours();
	}

	function getExpectLeftDays($norm=0)
	{
		return ceil( ( $norm - $this->getTotalAsHours() ) / $this->getAvarageAsHours() ) ;
	}

	function getExpectFinDate($norm=0, $timeformat='Y-m-d')
	{
		return date( $timeformat, time() + ( $this->getExpectLeftDays($norm) * 60 * 60 * 24 ) );
	}

	function getRate($norm=0)
	{
		return  round( ( $this->getTotalAsHours() / $norm ) * 100 , 3 );
	}

	function getTotalByUid($uid)
	{
		$db =& Database::getInstance();
		$sql = "SELECT sum(min) FROM ".$db->prefix(DB_TABLE1)." WHERE uid=".$uid;
		list( $total ) = $db->fetchRow($db->query($sql));
		return $total;
	}

	function getUname()
	{
		//XoopsUser饹
		$member_handler =& xoops_gethandler('member');
		$thisUser =& $member_handler->getUser($this->getVar('uid'));

		$uname = $GLOBALS['xoopsConfig']['anonymous'];
		//桼¸ߤ
		if (is_object($thisUser) && $thisUser->isActive()) {
			$uname = $thisUser->getVar('uname');
		}
		return $uname;
	}

	function getConstant()
	{
		$sql = "SELECT time FROM ".$this->db->prefix(DB_TABLE1)." WHERE uid=".$this->getVar('uid')." ORDER BY `time` ASC  LIMIT 0 , 1";
		list( $time ) = $this->db->fetchRow($this->db->query($sql));

		$sql = "SELECT COUNT(*) FROM ".$this->db->prefix(DB_TABLE1)." WHERE uid=".$this->getVar('uid')." AND time<=". $this->getVar('time');
		list( $count ) = $this->db->fetchRow($this->db->query($sql));

		$count = ( $count > 1 ) ? $count : 2 ;

		return round( ( ( $this->getVar('time') - $time ) / ( 60 * 60 * 24 ) ) / ($count - 1), 1) ;

	}

	function isNewUser($uid)
	{
		$sql = "SELECT COUNT(*) FROM ".$this->db->prefix(DB_TABLE1)." WHERE uid=".$uid;
		list( $count ) = $this->db->fetchRow($this->db->query($sql));
		if( $count > 0 ){
			return false;
		}
		return true;
	}

	function getCountByUid($uid)
	{
		$db =& Database::getInstance();
		$sql = "SELECT COUNT(*) FROM ".$db->prefix(DB_TABLE1)." WHERE uid=".$uid;
		list( $count ) = $db->fetchRow($db->query($sql));
		return $count;
	}

}
?>