<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
//            This module; ThemeChanger Copyright (c) 2005 suin              //
//                          <http://www.suin.jp>                             //
//  ------------------------------------------------------------------------ //

$dir = basename(dirname(__FILE__));
if( !file_exists(XOOPS_CACHE_PATH."/theme_changer_routine.php") ){
	global $xoopsModule, $xoopsDB;
	$id = 0;
	$talbe = $xoopsDB->prefix("ctem_pagelink");
	
	if ( preg_replace( '/\/$/', '', $_SERVER['DOCUMENT_ROOT'] ).$_SERVER['SCRIPT_NAME'] == XOOPS_ROOT_PATH.'/index.php'){
		$id = 1;
		$talbe = $xoopsDB->prefix("ctem_pagelink");
	}elseif ( is_object($xoopsModule) ){
		$id = $xoopsModule->getVar('mid');
		$talbe = $xoopsDB->prefix("ctem_link");
		
		// bug fix 05-03-01.
		$sql = "SELECT COUNT(*) FROM $talbe WHERE lid='$id'";
		list($count) = $xoopsDB->fetchRow( $xoopsDB->query($sql) );
		if( $count == 0 ){
			$id = 0;
			$talbe = $xoopsDB->prefix("ctem_pagelink");
		}
	}
	$sql = "SELECT theme, title, subtitle, metakey, metadesc FROM $talbe WHERE lid='$id'";
	$result = $xoopsDB->query($sql);
	list($theme, $title, $subtitle, $metakey, $metadesc) = $xoopsDB->fetchRow($result);
	
	if( $theme!=$dir && file_exists( XOOPS_THEME_PATH.'/'.$theme."/theme.html" ) ){
		$myts =& MyTextSanitizer::getInstance();
		$style = xoops_getcss($theme);
		$this->assign('temaname', $theme.'/theme.html');
		$this->assign('xoops_theme', $theme);
		$this->assign('xoops_themecss', $style);
		$this->assign('xoops_imageurl', XOOPS_THEME_URL.'/'.$theme.'/');
		if( !empty( $title ) )    $this->assign('xoops_sitename', $myts->stripSlashesGPC($myts->htmlSpecialChars($title)) );
		if( !empty( $subtitle ) ) $this->assign('xoops_pagetitle', $myts->stripSlashesGPC($myts->htmlSpecialChars($subtitle)) );
		if( !empty( $metakey ) )  $this->assign('xoops_meta_keywords', $myts->stripSlashesGPC($myts->htmlSpecialChars($metakey)) );
		if( !empty( $metadesc ) ) $this->assign('xoops_meta_description', $myts->stripSlashesGPC($myts->htmlSpecialChars($metadesc)) );
	}

	$tpl = '<?php
//Generated date : %s
	switch($id){
%s
	}
?>';

	$memo = "";

	$rule_tpl = '
	case "%s": // %s
		$theme    = "%s";
		$title    = "%s";
		$subtitle = "%s";
		$metakey  = "%s";
		$metadesc = "%s";
		break;
';

	$myts =& MyTextSanitizer::getInstance();

	$sql = "SELECT lid, pagename, theme, title, subtitle, metakey, metadesc FROM ".$xoopsDB->prefix("ctem_pagelink");
	$result = $xoopsDB->query($sql);
	while( list($lid, $pagename, $theme, $title, $subtitle, $metakey, $metadesc) = $xoopsDB->fetchRow($result) ){
		$pagename .= ($lid == 0) ? "\n\tdefault:" : "" ;
		$memo .= sprintf($rule_tpl, $lid, $pagename, $theme, $myts->stripSlashesGPC($myts->htmlSpecialChars($title)), $myts->stripSlashesGPC($myts->htmlSpecialChars($subtitle)), $myts->stripSlashesGPC($myts->htmlSpecialChars($metakey)), $myts->stripSlashesGPC($myts->htmlSpecialChars($metadesc)));
	}

	$sql = "SELECT c.lid, c.theme, c.title, c.subtitle, c.metakey, c.metadesc, m.name FROM ".$xoopsDB->prefix("ctem_link")." c, ".$xoopsDB->prefix("modules")." m WHERE c.lid=m.mid";

	$result = $xoopsDB->query($sql);
	while( list($lid, $theme, $title, $subtitle, $metakey, $metadesc, $modname) = $xoopsDB->fetchRow($result) ){
		$memo .= sprintf($rule_tpl, $lid, $modname, $theme, $myts->stripSlashesGPC($myts->htmlSpecialChars($title)), $myts->stripSlashesGPC($myts->htmlSpecialChars($subtitle)), $myts->stripSlashesGPC($myts->htmlSpecialChars($metakey)), $myts->stripSlashesGPC($myts->htmlSpecialChars($metadesc)));
	}

	$data = sprintf($tpl, date('Y-m-d H:i:s'), $memo);

	$fp = fopen( XOOPS_CACHE_PATH."/theme_changer_routine.php" , "w" );
	fwrite($fp, $data);
	fclose($fp);

	$this->assign('theme_sql', $sql );

}else{

	global $xoopsModule;

	$id = 0;
	
	if ( preg_replace( '/\/$/', '', $_SERVER['DOCUMENT_ROOT'] ).$_SERVER['SCRIPT_NAME'] == XOOPS_ROOT_PATH.'/index.php'){
		$id = 1;
	}elseif( is_object($xoopsModule) ){
		$id = $xoopsModule->getVar('mid');
	}

	require( XOOPS_CACHE_PATH."/theme_changer_routine.php" );

	if( $theme!=$dir && file_exists( XOOPS_THEME_PATH.'/'.$theme."/theme.html" ) ){
		$style = xoops_getcss($theme);
		$this->assign('temaname', $theme.'/theme.html');
		$this->assign('xoops_theme', $theme);
		$this->assign('xoops_themecss', $style);
		$this->assign('xoops_imageurl', XOOPS_THEME_URL.'/'.$theme.'/');
		if( !empty( $title ) )    $this->assign('xoops_sitename', $title);
		if( !empty( $subtitle ) ) $this->assign('xoops_pagetitle', $subtitle);
		if( !empty( $metakey ) )  $this->assign('xoops_meta_keywords', $metakey);
		if( !empty( $metadesc ) ) $this->assign('xoops_meta_description', $metadesc);
	}

}
?>