<?php
if( !defined( 'MAX_PAGES' ) )
  define( 'MAX_PAGES', 10 );

if( !defined( 'P_PREFIX' ) )
  define( 'P_PREFIX', '' );

if( !defined( 'LANG_YES_SHORT' ) )
  define( 'LANG_YES_SHORT', 'Tak' );

if( !defined( 'LANG_NO_SHORT' ) )
  define( 'LANG_NO_SHORT', 'Nie' );

if( !defined( 'LANG_PAGE_PREV' ) )
  define( 'LANG_PAGE_PREV', '&laquo; Poprzednia' );

if( !defined( 'LANG_PAGE_NEXT' ) )
  define( 'LANG_PAGE_NEXT', 'Nastna &raquo;' );

if( !defined( 'MAX_STR_LEN' ) )
  define( 'MAX_STR_LEN', 40 );


/**
* Library with all kind functions
* @version 0.6.1
* @date 2007-05-22 10:43:25
*/

/**
* Function return HTML select
* @return string
* @param int    $nr
*/
function throwYesNoSelect( $nr ){
  for( $l = 0; $l < 2; $l++ ){
    if( is_numeric( $nr ) && $nr == $l ) 
      $select[$l] = 'selected="selected"';
    else		
      $select[$l] = '';
  } // end for

  $option =  '<option value="1" '.$select[1].'>'.LANG_YES_SHORT.'</option>';
  $option .= '<option value="0" '.$select[0].'>'.LANG_NO_SHORT.'</option>';

  return $option;
} // end function throwYesOrNoSelect

/**
* Function return HTML checkbox and it will be selected
* when $iYesNo will be 1
* @return string
* @param string $sBoxName
* @param int    $iYesNo
*/
function throwYesNoBox( $sBoxName, $iYesNo = 0 ){
  if( $iYesNo == 1 )
    $sChecked = 'checked="checked"';
  else
    $sChecked = null;

  return '<input type="checkbox" '.$sChecked.' name="'.$sBoxName.'" value="1" />';
} // end function throwYesNoBox

/**
* Return Yes if $nr will be 1
* @return string
* @param int $nr
*/
function throwYesNoTxt( $nr = 0 ){
  if( $nr == 1 )
    return LANG_YES_SHORT;
  else
    return LANG_NO_SHORT;
} // end function throwYesNoTxt

/**
* Function change recieved string
* @return string
* @param string $sContent
* @param mixed  $sOption
*/
function changeTxt( $sContent, $sOption = null ){

  if( preg_match( '/tag/i', $sOption ) )
    $sContent = changeHtmlEditorTags( $sContent );

  if( preg_match( '/h/i', $sOption ) )
    $sContent = htmlspecialchars( $sContent );

  $sContent = changeSpecialChars( $sContent );

  if( !preg_match( '/nds/i', $sOption ) ){
    $aSea[] = '"';
    $aRep[] = '&quot;';
  }

  if( preg_match( '/sl/i', $sOption ) )
    $sContent = addslashes( $sContent );
  else
    $sContent = stripslashes( $sContent );

  $sContent = ereg_replace( "\r", '', $sContent );

  if( preg_match( '/len/i', $sOption ) )
    $sContent = checkLengthOfTxt( $sContent );

  if( preg_match( '/nl/i', $sOption ) ){
    $aSea[] = "\n";
    $aRep[] = null;
    $aSea[] = '|n|';
    $aRep[] = "\n";
  }
  else{
    if( preg_match( '/br/i', $sOption ) ){
      $aSea[] = "\n";
      $aRep[] = '<br />';
    }
    else{
      $aSea[] = "\n";
      $aRep[] = '|n|';
    }
  }

  if( preg_match( '/space/i', $sOption ) ){
    $aSea[] = ' ';
    $aRep[] = null;
  }

  if( isset( $aSea ) )
    $sContent = str_replace( $aSea, $aRep, $sContent );

  return $sContent;
} // end function changeTxt

/**
* Change all array values using changeTxt function
* @return array
* @param array  $aData
* @param string $sOption
* 1. $aData = changeMassTxt( $aData, 'sl' );
* 2. $aData = changeMassTxt( $aData, 'sl', Array( 'index1', 'Nds' ), Array( 'index2', 'SlNds' ) );
*/
function changeMassTxt( $aData, $sOption = null ){
  $iParams = func_num_args( );
  if( $iParams > 2 ){
    $aParam = func_get_args( );
    for( $i = 2; $i < $iParams; $i++ ){
      $aData[$aParam[$i][0]] =    changeTxt( $aData[$aParam[$i][0]], $aParam[$i][1] );
      $aDontDo[$aParam[$i][0]] =  true;
    } // end for
  }
    
  foreach( $aData as $mKey => $mValue )
    if( !isset( $aDontDo[$mKey] ) && !is_numeric( $mValue ) && !is_array( $mValue ) )
      $aData[$mKey] = changeTxt( $mValue, $sOption );
  return $aData;
} // end function changeMassTxt

/**
* Check string length and add space if string is longer then defined limit
* dlugosc
* @return string
* @param string $sContent
*/
function checkLengthOfTxt( $sContent ){
  return wordwrap( $sContent, MAX_STR_LEN, ' ', 1 );
} // end function checkLengthOfTxt

/**
* Check string length and return true/false if it is longer/shorter then $iLength
* @return boolean
* @param string $sContent
* @param int    $length
*/
function checkLength( $sContent, $iLength = 3 ){
  if( throwStrLen( $sContent ) > $iLength )
    return true;
  else
    return false;
} // end function checkLength

/**
* Return UNIX time from defined date
* @return int
* @param string $date
* @param string $time
* @param string $dateFormat
* @param string $sepDate
* @param string $sepTime
*/
function dateToTime( $date, $time = null, $dateFormat = 'ymd', $sepDate = '-', $sepTime = ':' ){
  
  if( $dateFormat == 'dmy' ){
    $y	= 2;
    $m	= 1;
    $d	= 0;
  }
  else{
    $y	= 0;
    $m	= 1;
    $d	= 2;
  }

  $exp =		@explode( $sepDate, $date );
  $year =		$exp[$y];
  $month =	sprintf( '%01.0f', $exp[$m] );
  $day =		sprintf( '%01.0f', $exp[$d] );

  if( empty( $time ) )
    $time = '00'.$sepTime.'00'.$sepTime.'00';
  
  $exp =		@explode( $sepTime, $time );
  $hour=		sprintf( '%01.0f', $exp[0] );
  $minute=	sprintf( '%01.0f', $exp[1] );

  if( count( $exp ) == 3 )
    $second=	sprintf( '%01.0f', $exp[2] );
  else
    $second=	0;

  return @mktime( $hour, $minute, $second, $month, $day, $year );
} // end function dateToTime

/**
* Count pages by defined positions / max positions per page
* @return string
* @param int    $iMax
* @param int    $iMaxPerPage
* @param int    $iPage
* @param string $sAddress
* @param string $sSeparator
* @param int    $iMaxPagesPerPage
* @param string $sUrlName
*/
function countPages( $iMax, $iMaxPerPage, $iPage, $sAddress, $sSeparator = '|', $iMaxPagesPerPage = MAX_PAGES, $sUrlName = 'iPage' ){

  $iPage = (int) $iPage;
  $iSubPages= ceil( $iMax / $iMaxPerPage ); 
  $sPages   = null;
  
  if( $iSubPages > $iPage ) 
    $iNext = 1; 
  else  
    $iNext = 0; 

  $iMax = ceil( $iPage + ( $iMaxPagesPerPage / 2 ) );
  $iMin = ceil( $iPage - ( $iMaxPagesPerPage / 2 ) );
  if( $iMin < 0 )
    $iMax += -( $iMin );
  if( $iMax > $iSubPages )
    $iMin -= $iMax - $iSubPages;

  $l['min'] = 0;
  $l['max'] = 0;
  for ( $i = 1; $i <= $iSubPages; $i++ ) { 
    if( $i >= $iMin && $i <= $iMax ) {
      if ( $i == $iPage ) 
        $sPages .= $sSeparator.' <strong>'.$i.'</strong> '; 
      else 
        $sPages .= $sSeparator.' <a href="?p='.P_PREFIX.$sAddress.'&amp;'.$sUrlName.'='.$i.'">'.$i.'</a> '; 
    }
    elseif( $i < $iMin ) {
      if( $i == 1 )
        $sPages .= $sSeparator.' <a href="?p='.P_PREFIX.$sAddress.'&amp;'.$sUrlName.'='.$i.'">'.$i.'</a> '; 
      else{
        if( $l['min'] == 0 ){
          $sPages .= $sSeparator.' ... '; 
          $l['min'] = 1;
        }
      }
    }
    elseif( $i > $iMin ) {
      if( $i == $iSubPages ){
        $sPages .= $sSeparator.' <a href="?p='.P_PREFIX.$sAddress.'&amp;'.$sUrlName.'='.$i.'">'.$i.'</a> '; 
      }
      else{
        if( $l['max'] == 0 ){
          $sPages .= $sSeparator.' ... '; 
          $l['max'] = 1;
        }
      }
    }
  } // end for
  $sPages .= $sSeparator;

  if( $iPage > 1 )
    $sPrev = '<a href="?p='.P_PREFIX.$sAddress.'&amp;'.$sUrlName.'='.($iPage-1).'" class="pPrev">'.LANG_PAGE_PREV.'</a> ';
  else
    $sPrev = null;
  if( $iNext == 1 )
    $sNext = ' <a href="?p='.P_PREFIX.$sAddress.'&amp;'.$sUrlName.'='.($iPage+1).'" class="pNext">'.LANG_PAGE_NEXT.'</a>';
  else
    $sNext = null;
  $sPages = $sPrev.$sPages.$sNext;

  return $sPages;
} // end function countPages

/**
* Validate string using preg_match. Example:
* $sContent = 'jpg', $sCheck = 'jpg|gif|jpeg'
* @return boolean
* @param string $sContent
* @param string $sCheck
*/
function checkCorrect( $sContent, $sCheck ){
  return preg_match( '/'.$sCheck.'/', $sContent );
} // end function checkCorrect

/**
* Change polish letters to not polish 
* @return string
* @param string $sContent
*/
function changePolishToNotPolish( $sContent ){
/* for japanese. I guess this replase cause character broken.
  $aStr[] = '';
  $aStr[] = ';
  $aStr[] = '';
  $aStr[] = '';
  $aStr[] = ';
  $aStr[] = '
  $aStr[] = ';
  $aStr[] = ';
  $aStr[] = ';
  $aStr[] = ';
  $aStr[] = ';
  $aStr[] = ';
  $aStr[] = ';
  $aStr[] = ';
  $aStr[] = 'ѧ;
  $aStr[] = ';
  $aStr[] = 'Ƨ;
  $aStr[] = ';
  $aStr[] = 'ʧ;
  $aStr[] = ';
  $aStr[] = ';
  $aStr[] = ';
  $aStr[] = 'ӧ;
  $aStr[] = ';

  $aRep[] = 's';
  $aRep[] = 'a';
  $aRep[] = 'z';
  $aRep[] = 'S';
  $aRep[] = 'A';
  $aRep[] = 'Z';
  $aRep[] = 's';
  $aRep[] = 'S';
  $aRep[] = 'a';
  $aRep[] = 'A';
  $aRep[] = 'z';
  $aRep[] = 'Z';
  $aRep[] = 'Z';
  $aRep[] = 'z';
  $aRep[] = 'N';
  $aRep[] = 'n';
  $aRep[] = 'C';
  $aRep[] = 'c';
  $aRep[] = 'e';
  $aRep[] = 'e';
  $aRep[] = 'L';
  $aRep[] = 'l';
  $aRep[] = 'O';
  $aRep[] = 'o';
*/
  return str_replace( $aStr, $aRep, $sContent );
} // end function changePolishToNotPolish

/**
* Changes charset to default iso-8859-2
* @return string
* @param string $sContent
*/
function changeCharset( $sContent ){
/* for japanese. I guess this replase cause character broken.
  $aStr[] = '';
  $aStr[] = ';
  $aStr[] = '';
  $aStr[] = '';
  $aStr[] = ';
  $aStr[] = '

  $aRep[] = ';
  $aRep[] = ';
  $aRep[] = ';
  $aRep[] = ';
  $aRep[] = ';
  $aRep[] = ';
*/
  return str_replace( $aStr, $aRep, $sContent );
} // end function changeCharset

/**
* Change '$' to '&#36;'
* @return string
* @param string $sTxt
*/
function changeSpecialChars( $sTxt ){
  return str_replace( '$', '&#36;', $sTxt );
} // end function changeSpecialChars

/**
* Check that date format is correct
* @return boolean
* @param string $date
* @param string $format
* @param string $separator
*/
function is_date( $date, $format='ymd', $separator='-' ){

  $f['y'] = 4;
  $f['m'] = 2;
  $f['d'] = 2;

  if ( ereg( "([0-9]{".$f[$format[0]]."})".$separator."([0-9]{".$f[$format[1]]."})".$separator."([0-9]{".$f[$format[2]]."})", $date ) ){
    
    $y =    strpos( $format, 'y' );
    $m =    strpos( $format, 'm' );
    $d =    strpos( $format, 'd' );
    $dates= explode( $separator, $date );

    return  checkdate( $dates[$m], $dates[$d], $dates[$y] );
  }
  else
    return false;
} // end function is_date

/**
* Return string length
* @return int
* @param string $sContent
*/
function throwStrLen( $sContent ){
  return strlen( trim( changeTxt( $sContent, 'hBrSpace' ) ) );
} // end function throwStrLen

/**
* Return microtime
* @return float
*/
function throwMicroTime( ){ 
  $exp =  explode( " ", microtime( ) ); 
  return  ( (float) $exp[0] + (float) $exp[1] ); 
} // end function throwMicroTime

/**
* Return HTML select from defined array
* @return string
* @param array  $aData
* @param mixed  $mData
*/
function throwSelectFromArray( $aData, $mData = null ){
  $sOption  = null;

  foreach( $aData as $iKey => $mValue ){
    if( isset( $mData ) && $mData == $iKey )
      $sSelected = 'selected="selected"';
    else
      $sSelected = null;

    $sOption .= '<option value="'.$iKey.'" '.$sSelected.'>'.$mValue.'</option>';  
  }

  return $sOption;
} // end function throwSelectFromArray

/**
* Get file name from $p parameter
* @return string
* @param string   $p
* @param string   $sDir
*/
function getAction( $p, $sDir ){
  global $a, $aActions, $sActionFile;

  $iStrlen = strlen( $p );

  if( $iStrlen > 0 ){
    $aActions['g']  = null;
    $aActions['a']  = null;

    for( $i = 0; $i < $iStrlen; $i++ ){

      if( ereg( "[a-z_]", $p[$i] ) && $aActions['a'] == '' )
        $aActions['g'] .= $p[$i];
      else
        $aActions['a'] .= $p[$i];

    } // end for

    $a            = $aActions['a'];
    $sActionFile  = $sDir.$aActions['g'].'.php';
  }
  else{
    $a            = null;
    $sActionFile  = null;
  }
} // end function getAction

/**
* Change string parameter to url name
* @return string
* @param string $sContent
*/
function change2Url( $sContent ){
  $aFrom = array( ' ', '&raquo;', '/', '$', '\'', '"', '~', '\\', '?', '#', '%', '+', '^', '*', '>', '<', '@', '|', '&quot;', '%', ':', '--', '--', '&', ',' );
  $aTo   = array( '-', '',        '-', '-', '',   '',  '-', '-',  '-', '-', '-', '-', '-', '-', '-', '-', '-', '-', '-',      '-', '-', '-',  '-',  '',  '-' );
  return strtolower( changePolishToNotPolish( str_replace( $aFrom, $aTo, trim( $sContent ) ) ) );
} // end function change2Url
?>