<?php 
if( !function_exists( 'saveProduct' ) ){
  /**
  * Save product
  * @return void
  * @param array  $aForm
  */
  function saveProduct( $aForm ){
  
    if( is_numeric( $aForm['iProduct'] ) ){
      if( isset( $aForm['aFilesDescriptionChange'] ) && is_array( $aForm['aFilesDescriptionChange'] ) ){
        foreach( $aForm['aFilesDescriptionChange'] as $iKey => $sValue ){
          dbChangeFileData( Array( $iKey, $aForm['iProduct'], $aForm['aFilesNameChange'][$iKey], changeTxt( ereg_replace( '\'', '', $sValue ) ), $aForm['aFilesType'][$iKey], $aForm['aFilesPositionChange'][$iKey] ), 1 );
        } // end foreach
      }
      $bExist = true;
    }
    else{
      $bExist = null;
      $aForm['iProduct'] = throwLastId( ) + 1;
    }

    if( !isset( $aForm['iPosition'] ) || !is_numeric( $aForm['iPosition'] ) || $aForm['iPosition'] < -99 || $aForm['iPosition'] > 999 )
      $aForm['iPosition'] = 0;

    $aForm['sDescriptionShort'] = JcodeConvert(changeTxt( $aForm['sDescriptionShort'], 'Nds' ),0,1);		//for japanese
    $aForm['sDescriptionFull'] = JcodeConvert(changeTxt( $aForm['sDescriptionFull'], 'Nds' ),0,1);		//for japanese

    $aForm['sName']  = JcodeConvert(changeTxt( $aForm['sName'] ),0,1);		//for japanese
    $aForm['fPrice'] = tPrice( $aForm['fPrice'] );

    if( isset( $aForm['aDelFiles'] ) && is_array( $aForm['aDelFiles'] ) ){
      $iCount = count( $aForm['aDelFiles'] );
      for( $i = 0; $i < $iCount; $i++ )
        delFile( $aForm['aDelFiles'][$i], 1 );
    }

    if( isset( $aForm['aCategories'] ) && is_array( $aForm['aCategories'] ) ){
      $bErase = true;
      $iCount = count( $aForm['aCategories'] );
      for( $i = 0; $i < $iCount; $i++ ){
        if( is_numeric( $aForm['aCategories'][$i] ) ){
          dbAddCategoriesProduct( $aForm['aCategories'][$i], $aForm['iProduct'], $bErase );
          $bErase = null;
        }
      } // end for
    }

    addFiles( $aForm, $aForm['iProduct'], PRODUCTS_PHOTO_SIZE, 1 );
    dbAddProductExtensions( Array( $aForm['iProduct'], $aForm['sDescriptionFull'] ) );
    dbSaveProduct( $aForm, $bExist );
  } // end function saveProduct
}

if( !function_exists( 'delProduct' ) ){
  /**
  * Delete product
  * @return void
  * @param int  $iProduct
  */
  function delProduct( $iProduct ){
    delFiles( $iProduct, 1 );
    dbDelProduct( $iProduct );
  } // end function delProduct
}
?>