<?php
if( !function_exists( 'listFiles' ) ){
  /**
  * Returns all files and photos of product or category etc
  * @return array
  * @param int    $iLink
  * @param string $sFile
  * @param int    $iType
  */
  function listFiles( $iLink, $sFile = null, $iType = 1 ){
    global $aList, $oFF, $tpl;

    $sDir   = DIR_FILES;
    $aData  = dbListFiles( $iLink, $iType );
    
    if( isset( $aData[0] ) && is_array( $aData[0] ) ){
      $aExt   = throwIconsFromExt( );
      $iCount = count( $aData[0] );

      for( $i = 0; $i < $iCount; $i++ ){
        list( $aList['iFile'], $aList['iLink'], $aList['sFile'], $aList['sDescription'], $aList['iType'], $aList['iPosition'] ) = $aData[0][$i];
        
        if( is_file( $sDir.$aList['sFile'] ) ){
         
          $aName = $oFF->throwNameExtOfFile( $aList['sFile'] );
          
          if( !isset( $aExt[$aName[1]] ) )
            $aExt[$aName[1]] = 'nn';
          
          $aList['sIcon'] = 'ico_'.$aExt[$aName[1]];

          $aList['sStyle'] = ( $i == ( $iCount - 1 ) ) ? 'L': $i + 1;

          if( !isset( $aReturn['sFiles'] ) )
            $aReturn['sFiles'] = $tpl->tbHtml( $sFile, 'FILES_HEAD' );

          $aReturn['sFiles'] .= $tpl->tbHtml( $sFile, 'FILES_LIST' );
          
        }
      } // end for

      if( isset( $aReturn['sFiles'] ) )
        $aReturn['sFiles'] .= $tpl->tbHtml( $sFile, 'FILES_FOOT' );
    }

    if( isset( $aData[1] ) && is_array( $aData[1] ) ){

      $iCount = count( $aData[1] );

      for( $i = 0; $i < $iCount; $i++ ){
        list( $aList['iFile'], $aList['iLink'], $aList['sFile'], $aList['sDescription'], $aList['iType'], $aList['iPosition'] ) = $aData[1][$i];

        if( is_file( $sDir.$aList['sFile'] ) ){

          $aName = $oFF->throwNameExtOfFile( $aList['sFile'] );
          $aList['sPhotoSmall'] = $sDir.$aName[0].'_m.'.$aName[1];
          $aList['sPhotoBig']   = $sDir.$aList['sFile'];
          $aList['iPhoto']      = $i+1;

          $aList['sStyle'] = ( $i == ( $iCount - 1 ) ) ? 'L': $i + 1;

          if( isset( $aReturn['sPhotosDefault'] ) ){
            if( !isset( $aReturn['sPhotos'] ) )
              $aReturn['sPhotos'] = $tpl->tbHtml( $sFile, 'PHOTOS_HEAD' );

            $aReturn['sPhotos'] .= $tpl->tbHtml( $sFile, 'PHOTOS_LIST' );            
            if( isset( $aList['sPhotosDefault'] ) )
              $aList['sPhotosDefault'] = null;
          }
          else{
            $aReturn['sPhotosDefault'] = $tpl->tbHtml( $sFile, 'PHOTOS_DEFAULT' );
            $aList['sPhotosDefault'] = $aReturn['sPhotosDefault'];
          }
          
        }
      } // end for
      
      if( $iType == 2 && !isset( $aReturn['sPhotos'] ) && isset( $aList['sPhotosDefault'] ) ){
        if( !isset( $aReturn['sPhotos'] ) )
          $aReturn['sPhotos'] = $tpl->tbHtml( $sFile, 'PHOTOS_HEAD' );
      }
            
      if( isset( $aReturn['sPhotos'] ) )
        $aReturn['sPhotos'] .= $tpl->tbHtml( $sFile, 'PHOTOS_FOOT' );
    }
  
    if( isset( $aReturn ) )
      return $aReturn;
  } // end function listFiles
}

if( !function_exists( 'throwFirstPhoto' ) ){
  /**
  * Return first photos of products, categories etc
  * @return array
  * @param int  $iType
  */
  function throwFirstPhoto( $iType ){
    $aData  = dbThrowFirstPhoto( $iType );
    $iCount = count( $aData );
    $aPhoto  = null;

    for( $i = 0; $i < $iCount; $i++ ){
      list( $aPhoto[$aData[$i][1]]['iFile'], $aPhoto[$aData[$i][1]]['iLink'], $aPhoto[$aData[$i][1]]['sPhoto'], $aPhoto[$aData[$i][1]]['sDescription'] ) = $aData[$i];
    } // end for
    return $aPhoto;
  } // end function throwFirstPhoto
}

if( !function_exists( 'showPhotosGalleryPopup' ) ){
  /**
  * Show photos gallery
  * @return array
  * @param int    $iLink
  * @param string $sFile
  * @param int    $iPhoto
  * @param int    $iType
  */
  function showPhotosGalleryPopup( $iLink, $sFile, $iPhoto, $iType ){
    global $aList, $oFF, $tpl;

    $sDir     = DIR_FILES;
    $aData    = dbListFiles( $iLink, $iType );
    $content  = null;

    if( isset( $aData[1] ) && is_array( $aData[1] ) ){

      $iCount = count( $aData[1] );
      for( $i = 0; $i < $iCount; $i++ ){
        list( $aList['iFile'], $aList['iLink'], $aList['sFile'], $aList['sDescription'], $aList['iType'], $aList['iPosition'] ) = $aData[1][$i];

        if( is_file( $sDir.$aList['sFile'] ) && $i == $iPhoto-1 ){
          $aName = $oFF->throwNameExtOfFile( $aList['sFile'] );
          $aList['sPhotoSmall'] = $sDir.$aName[0].'_m.'.$aName[1];
          $aList['sPhotoBig']   = $sDir.$aList['sFile'];
          $aList['sStyle'] = ( $i == ( $iCount - 1 ) ) ? 'L': $i + 1;
          if( !empty( $aList['sDescription'] ) )
            $aList['sDescription'] = $tpl->tbHtml( $sFile, 'PHOTO_DESCRIPTION' );
          $content .= $tpl->tbHtml( $sFile, 'PHOTO_SHOW' );
        }
      } // end for

      if( isset( $content ) ){
        $aList['sPages'] = countPages( $i, 1, $iPhoto, 'galleryGalleryShow&amp;iType='.$iType.'&amp;iIdLink='.$iLink, null, MAX_PAGES, 'iPhoto' );
        return $tpl->tbHtml( $sFile, 'PHOTO_HEAD' ).$content.$tpl->tbHtml( $sFile, 'PHOTO_FOOT' );
      }
    }
  } // end function showPhotosGalleryPopup
}
?>