/* Copyright (c) 2020-2022 The Creators of Simphone

   See the file COPYING.LESSER.txt for copying permission.
*/

#ifndef CHATWINDOW_H
#define CHATWINDOW_H

#include "../simcore/simapi.h"

#include <QMainWindow>

namespace Ui {
class ChatWindow;
}

class ChatWindow : public QMainWindow
{
  Q_OBJECT

  typedef QMainWindow Parent;

public:
  explicit ChatWindow(QWidget * parent = 0);
  ~ChatWindow() Q_DECL_OVERRIDE;

  void setQuitting() { m_doQuit = true; }

  void closeEvent(QCloseEvent * event) Q_DECL_OVERRIDE;
  void changeEvent(QEvent * event) Q_DECL_OVERRIDE;

  void recalcTitle();

  void saveSettings(simtype params);
  void readSettings();

  void detachFrame();
  void attachFrame(class ChatFrame * frame);

  void blinkWindow();

public slots:
  void onSignalContactChanged(unsigned id);
  void onSignalContactStatusChanged(unsigned id, int, int);

private:
  Ui::ChatWindow * ui;
  class ChatFrame * m_frame;
  bool m_saved;
  bool m_doQuit;

  int m_icon;  // value of ui.chat.icon
  int m_title; // value of ui.chat.title
};

#endif
