/**
    calculate the number of buckets a hash table must have to be collision-free.
    each line of stdin contains all key names of one table, separated by spaces

    See the file COPYING.LESSER.txt for copying permission.
**/

#include "logger.h"
#include "table.h"

#include <string.h>
#include <stdio.h>

int main (int argc, char **argv) {
  static char buffer[BUFSIZ];
  static char *tokens[BUFSIZ / 2];
  simtype table;
  log_init_ ();
  while (gets (buffer)) {
    int i, n = 0, l;
    char *s = string_copy (buffer).ptr;
    while ((s = strchr (tokens[n++] = s, ' ')) != NULL)
      *s++ = 0;
    l = n;
    for (i = 0; i < n; i++) {
      for (s = tokens[i]; *s; s++)
        if (*s == '.')
          *s = ' ';
      if (tokens[i][0] == ' ' && ! tokens[i][1])
        tokens[i][0] = 0;
    }
    do {
      struct _simelement *elem = (table = table_new (l)).tbl;
      for (i = 0; i < n; i++)
        if (table_add_number (table, tokens[i], 1).typ != SIMNIL) {
#ifdef DONOT_DEFINE
          i = l = 0;
          break;
#endif
        }
      if (l++ > 0)
        for (i = l; --i && ! (++elem)->next;) {}
      table_free (table);
    } while (i);
    printf ("%d:%d %s\n", n, --l, buffer);
  }
  return 0;
}
