/* Copyright (c) 2020-2021 The Creators of Simphone

   See the file COPYING.LESSER.txt for copying permission.
*/

#ifndef SOUNDS_H
#define SOUNDS_H

#include <QSet>

class SoundEffects
{
public:
  enum E_SoundType {
    sound_none,
    sound_call,
    sound_ring,
    sound_connect,
    sound_nSounds
  };

  SoundEffects();

  static void stopSound(int contactId, const char * name, E_SoundType sound);
  static void playSound(int contactId, const char * name, E_SoundType sound);

  static void playIncomingCallSound(int contactId);
  static void playOutgoingCallSound(int contactId);
  static void playOutgoingConnectSound(int contactId);

  static void playLogonSound(int contactId);
  static void playLogoffSound(int contactId);

  static void playMsgSound(int contactId, bool focused);
  static void playMsgNotsentSound(int contactId);
  static void playMsgResentSound(int contactId);

  static void playBusySound(int contactId);
  static void playFailedSound(int contactId);

  static void playDisconnectSound(int contactId);
  static void playHangupSound(int contactId);

  static void playNewContactSound(int contactId);
  static void playKeygenSound(int contactId);

  static void playFakeKeySound(int contactId);
  static void playProtocolSound(int contactId, int count = 1);

  static void playUpSound(bool init);
  static void playDownSound(bool init);

  static void stopIncomingCallSound(int contactId);
  static void stopOutgoingCallSound(int contactId);
  static void stopOutgoingConnectSound(int contactId);
  static void stopSounds(int contactId); // stop all repeating sounds

  static void stopInvisibleSound(const char * name);
  static void stopInvisibleSound();
  static bool checkVisibleSound(const char * name);

  static bool checkSound(int contactId, const char * name);
  static bool checkErrorSound(const char * name);

protected:
  static QSet<QString> mc_noSoundMap;
  static QHash<int, E_SoundType> mc_soundMap;
  static int mc_soundCount[sound_nSounds];
};

#endif
