/* Copyright (c) 2020-2021 The Creators of Simphone

   See the file COPYING.LESSER.txt for copying permission.
*/

#ifndef SHOWSEED_H
#define SHOWSEED_H

#include "logindialog.h"

namespace Ui {
class ShowSeed;
}

class ShowSeed : public LoginDialog
{
  Q_OBJECT

  typedef LoginDialog Parent;

public:
  explicit ShowSeed(QWidget * parent, const QString & seed0, const QString & seed1);
  ~ShowSeed();

  QString getSeed(int format);

  void changeEvent(QEvent * event) Q_DECL_OVERRIDE;

private slots:
  void on_formatButton_clicked();
  void on_loginButton_clicked();

  void on_actionQuit_triggered() { Parent::on_actionQuit_triggered(); }
  void on_actionConsole_triggered() { Parent::on_actionConsole_triggered(); }
  void on_actionAudioDevices_triggered() { Parent::on_actionAudioDevices_triggered(); }

  void on_actionEnglish_triggered();
  void on_actionFrench_triggered();
  void on_actionGerman_triggered();
  void on_actionUserManual_triggered() { Parent::on_actionUserManual_triggered(); }
  void on_actionAbout_triggered() { Parent::on_actionAbout_triggered(); }

  void onCustomContextMenu(const QPoint & pos);

private:
  bool eventFilter(QObject * obj, QEvent * event) Q_DECL_OVERRIDE;

  Ui::ShowSeed * ui;

  int m_format;
  int m_seedSize;
  QString m_seed[2];
};

#endif
