#!/bin/sh

if ! test -f ../build/make_installer.sh; then
  echo "Please run this script from the 'build' subdirectory."
  exit 1
fi
if ! test -d ../qtbase; then
  echo "Please copy Qt source code to the '../qtbase' subdirectory."
  exit 1
fi
if ! shar --version >/dev/null 2>/dev/null; then
  echo "Please install the 'shar' program."
  exit 1
fi

cd ..
if ! autoconf; then
  echo "Please install the 'autoconf' program."
  exit 1
fi
rm -rf ../simphone_installer
cd build
autoconf
SIMVERS=`grep AC_INIT configure.ac | cut -d '['  -f 3 | cut -d ']' -f 1`
cp -a .. ../../simphone_installer
find .. -type f -exec touch -a -t200202020202 '{}' ';'

sh ./build_qt -install-make
if test $? -ne 0; then
  exit 1
fi

sh ./build_simphone --without-makedepend
if test $? -ne 0; then
  exit 1
fi
cd ..

find . -type f -atime 0 | grep -v "\.hg/" | grep -v cryptopp/ | grep -v build/makedepend/ | grep -v doc/global/template/ > ../files
find speex speexdsp portaudio expat cares npth -name '*.m4' >> ../files
find speex speexdsp portaudio expat cares npth -name configure.ac >> ../files
find speex speexdsp portaudio expat cares npth -name Makefile.in >> ../files
find speex speexdsp portaudio expat cares npth -name Makefile.am >> ../files
for f in simcore/simc.c npth/src/libnpth.vers; do
  echo $f >> ../files
done
for f in GNUmakefile aes.h algebra.cpp algebra.h algparam.cpp algparam.h argnames.h asn.cpp asn.h authenc.cpp authenc.h basecode.cpp basecode.h; do
  echo cryptopp/$f >> ../files
done
for f in camellia.cpp camellia.h cast.cpp cast.h casts.cpp cbcmac.cpp cbcmac.h ccm.h channels.h cmac.cpp cmac.h config.h cpu.cpp cpu.h cryptlib.cpp; do
  echo cryptopp/$f >> ../files
done
for f in cryptlib.h des.cpp des.h dessp.cpp dh.cpp dh.h dll.cpp dll.h dsa.h eax.cpp eax.h ec2n.cpp ec2n.h eccrypto.cpp eccrypto.h ecp.cpp ecp.h; do
  echo cryptopp/$f >> ../files
done
for f in emsa2.cpp emsa2.h eprecomp.cpp eprecomp.h esign.cpp esign.h fhmqv.h files.h filters.cpp filters.h fips140.cpp fips140.h fltrimpl.h; do
  echo cryptopp/$f >> ../files
done
for f in gcm.h gf2n.cpp gf2n.h gfpcrypt.cpp gfpcrypt.h hex.cpp hex.h hkdf.h hmac.cpp hmac.h hmqv.h hrtimer.cpp hrtimer.h idea.cpp idea.h integer.cpp; do
  echo cryptopp/$f >> ../files
done
for f in integer.h iterhash.cpp iterhash.h mars.cpp mars.h marss.cpp misc.cpp misc.h modarith.h modes.cpp modes.h modexppc.h mqueue.cpp mqueue.h; do
  echo cryptopp/$f >> ../files
done
for f in mqv.cpp mqv.h nbtheory.cpp nbtheory.h oaep.cpp oaep.h oids.h osrng.cpp osrng.h pch.h pkcspad.cpp pkcspad.h pssr.h pubkey.cpp pubkey.h pwdbased.h; do
  echo cryptopp/$f >> ../files
done
for f in queue.cpp queue.h randpool.cpp randpool.h rc6.cpp rc6.h rdtables.cpp rijndael.cpp rijndael.h ripemd.cpp ripemd.h rng.cpp rng.h rsa.cpp rsa.h; do
  echo cryptopp/$f >> ../files
done
for f in rw.h secblock.h seckey.h serpent.cpp serpent.h serpentp.h sha3.cpp sha3.h sha.cpp sha.h simple.h skipjack.h smartptr.h stdcpp.h; do
  echo cryptopp/$f >> ../files
done
for f in in strciphr.cpp strciphr.h tftables.cpp trap.h trdlocal.cpp trdlocal.h twofish.cpp twofish.h whrlpool.cpp whrlpool.h words.h; do
  echo cryptopp/$f >> ../files
done
for f in expat/conftools/install-sh cares/install-sh npth/build-aux/install-sh speex/install-sh speexdsp/install-sh portaudio/install-sh; do
  echo $f >> ../files
done
for f in cares/compile npth/build-aux/compile speex/compile speexdsp/compile; do
  echo $f >> ../files
done
for f in bfin.h cb_search_arm4.h cb_search_bfin.h cb_search_sse.h filters_arm4.h filters_bfin.h filters_sse.h; do
  echo speex/libspeex/$f >> ../files
done
for f in fixed_generic.h fixed_arm4.h fftwrap.h fixed_arm5e.h fixed_bfin.h fixed_debug.h; do
  echo speex/libspeex/$f >> ../files
done
for f in lpc_bfin.h ltp_arm4.h ltp_bfin.h ltp_sse.h misc_bfin.h vq_arm4.h vq_bfin.h vq_sse.h lsp_bfin.h quant_lsp_bfin.h smallft.h vorbis_psy.h; do
  echo speex/libspeex/$f >> ../files
done
for f in bfin.h fixed_arm4.h fixed_arm5e.h fixed_bfin.h fixed_debug.h misc_bfin.h fixed_generic.h resample_neon.h resample_sse.h stack_alloc.h; do
  echo speexdsp/libspeexdsp/$f >> ../files
done
#for f in objects/objects.txt objects/obj_mac.num objects/obj_xref.txt
for f in crypto/mem_clr.c external/perl/transfer/Getopt/Long.pm; do
  echo openssl/$f >> ../files
done
for f in arm_arch.h ppc_arch.h sparc_arch.h mips_arch.h s390x_arch.h ppccap.c armcap.c s390xcap.c sparcv9cap.c; do
  echo openssl/crypto/$f >> ../files
done
for f in bn/rsaz_exp.c bn/asm/x86_64-gcc.c; do
  echo openssl/crypto/$f >> ../files
done
find openssl/crypto -name '*.pl' >> ../files
find openssl/crypto -name '*.S' >> ../files
find openssl/crypto -name '*.s' >> ../files
for f in corelib/doc/qtcore.qdocconf network/doc/qtnetwork.qdocconf sql/doc/qtsql.qdocconf concurrent/doc/qtconcurrent.qdocconf; do
  echo qtbase/src/$f >> ../files
done
for f in xml/doc/qtxml.qdocconf gui/doc/qtgui.qdocconf platformheaders/doc/qtplatformheaders.qdocconf widgets/doc/qtwidgets.qdocconf; do
  echo qtbase/src/$f >> ../files
done
for f in dbus/doc/qtdbus.qdocconf testlib/doc/qttestlib.qdocconf printsupport/doc/qtprintsupport.qdocconf; do
  echo qtbase/src/$f >> ../files
done
for f in corelib/io/qfilesystemwatcher_kqueue.cpp platformsupport/devicediscovery/qdevicediscovery_dummy.cpp; do
  echo qtbase/src/$f >> ../files
done
for f in gui/image/qimage_sse2.cpp gui/painting/qdrawhelper_sse2.cpp; do
  echo qtbase/src/$f >> ../files
done
for f in config.tests/common/sse2/sse2.cpp config.tests/common/sse2/sse2.pro; do
  echo qtbase/$f >> ../files
done
for f in config.tests/common/c++1z/c++1z.cpp config.tests/common/c++1z/c++1z.pro; do
  echo qtbase/$f >> ../files
done
for f in qmake/doc/qmake.qdocconf config.tests/qpa/xcb-syslibs/xcb.cpp config.tests/qpa/xcb-syslibs/xcb-syslibs.pro; do
  echo qtbase/$f >> ../files
done
for f in configure installer.sh uudecode.pl; do
  echo build/$f >> ../files
done

cd ../simphone_installer
tar -T ../files -cf ../simphone.tar 2>/dev/null

rm -rf ../installer_simphone
mkdir ../installer_simphone
cd ../installer_simphone
tar -xf ../simphone.tar

find . -name '*.qm' -exec sh -c "uuencode '{}' '{}' > '{}'.uue" ';'
find . -name '*.qm' -exec rm -f '{}' ';'
find . -name '*.bin' -exec sh -c "uuencode '{}' '{}' > '{}'.uue" ';'
find . -name '*.bin' -exec rm -f '{}' ';'
find . -name '*.ico' -exec sh -c "uuencode '{}' '{}' > '{}'.uue" ';'
find . -name '*.ico' -exec rm -f '{}' ';'
find . -name '*.png' -exec sh -c "uuencode '{}' '{}' > '{}'.uue" ';'
find . -name '*.png' -exec rm -f '{}' ';'
#find . -name '*.jpg' -exec sh -c "uuencode '{}' '{}' > '{}'.uue" ';'
#find . -name '*.jpg' -exec rm -f '{}' ';'
#find . -name '*.gif' -exec sh -c "uuencode '{}' '{}' > '{}'.uue" ';'
#find . -name '*.gif' -exec rm -f '{}' ';'
for f in QtGui/headers.pri QtCore/headers.pri QtWidgets/headers.pri; do
  uuencode ./qtbase/include/$f ./qtbase/include/$f > qtbase/include/$f.uue
  rm -f qtbase/include/$f
done
for f in mkspecs/features/win32/rtti_off.prf src/corelib/mimetypes/mime/packages/freedesktop.org.xml; do
  uuencode ./qtbase/$f ./qtbase/$f > qtbase/$f.uue
  rm -f qtbase/$f
done
cd ..

find installer_simphone -type f | sort | shar -S -m -T -n "the Simphone $SIMVERS Installer" -s SiMPHoNE --no-character-count -x -Q --no-i18n -q | sed 's/^if rm -fr \${lock_dir}$/installer_simphone\/build\/installer.sh \$\*; RET=$?; if rm -fr \${lock_dir}/' | sed 's/^exit 0$/exit $RET/' | grep -av '# Made on.*SiMPHoNE' > simphone_installer.shar
chmod +x simphone_installer.shar
