require 'runit/testcase'
require 'amrita/parser'
require 'amrita/xml'
require 'amrita/testsupport'
include Amrita

PATH_V1=ENV['AMRITA_V1_HOME'] || %Q[#{ENV['HOME']}/cvswork/amrita_stable]
PATH_V2=ENV['AMRITA_V2_HOME'] || %Q[#{ENV['HOME']}/cvswork/amrita]
INC_V1=%Q[-I#{PATH_V1}/lib]
INC_V2=%Q[-I#{PATH_V2}/lib -r amrita/v1api]
INC_V2_EXT=%Q[-I#{PATH_V2}/lib -I#{PATH_V2}/ext -r amrita/v1api]

#RUBY=%Q[/usr/bin/ruby]
RUBY=%Q[/usr/local/bin/ruby]

class TestV2 < RUNIT::TestCase
  def remove_not_compare(x)
    x.gsub!(/init_amrita_accel\s*\n/, "")
    x.gsub!(/installing amrita accelerator to Amrita\s*\n/, "")
    x.gsub!(/can't load amrita_accelerator\s*\n/, "") #'
    x
  end


  def exec_script(f, ruby, inc)
    cmd = %Q[#{ruby} #{inc} #{f}]
    ret = IO::popen(cmd) do |p|
      src = remove_not_compare(p.read)
      #puts "cmd=#{cmd} result=#{src}"
      $PARSER_FOR_TEST::parse_text(src)
    end
    ret
  end

  def compare_html(a, b)
    assert_equal_node(a,b)
  end

  def check_amrita(f)
    a = exec_script(f, RUBY, INC_V1)
    b = exec_script(f, RUBY, INC_V2)

    compare_html(a, b)

    c = exec_script(f, RUBY, INC_V2_EXT)
    compare_html(a, c)
  end

  def test_hello
    Dir::chdir %Q[#{PATH_V1}/sample/hello]
    check_amrita('hello.rb')
    check_amrita('list.rb')
    check_amrita('table.rb')
    check_amrita('conditional.rb')
  end

  def test_tour
    Dir::chdir %Q[#{PATH_V1}/sample/tour]
    
    check_amrita('time.rb')
    check_amrita('sanitizer.rb')
    check_amrita('makeurl.rb')
    # check_amrita('makeurl2.rb') # not compatible
    check_amrita('xml1.rb')
    check_amrita('xml2.rb')
    #check_amrita('xhtml.rb')
  end
end


#--- main program ----
if __FILE__ == $0
  require 'runit/cui/testrunner'
  if ARGV.size == 0
    RUNIT::CUI::TestRunner.run(TestV2.suite)
  else
    ARGV.each do |method|
      RUNIT::CUI::TestRunner.run(TestV2.new(method))
    end
  end
end

