# from sample code by Narushima Hironori posted at [walrus-users:00478]
require 'amrita/amulet'
include Amrita

parts = TemplateText.new <<END
  <span id="position_item">
    &gt; <a href="@href"><span id="data">data</span></a>
  </span>
END

parts.define_amulet(:position_item)

t = TemplateText.new <<END
  <body>
    <div>
      <span id="start">start</span>
      <span id="chapter">chapter</span>
      <span id="section">selection</span>
      <span id="subsection">subsection</span>
      <span id="subsubsection">subsubsection</span>
    </div>
  </body>
END


data = {
  :start => parts[:position_item][
    :href => '../../../',
    :data => 'Walrus Project'
  ],
  :chapter => parts[:position_item][
    :href => '../../',
    :data => 'Amrita Project'
  ],
  :section => parts[:position_item][
    :href => '../',
    :data => 'Documentation'
  ],
  :subsection => parts[:position_item][
    :href => 'index.html',
    :data => 'How to Write a Template'
  ],
  :subsubsection => 'text of subsubsection'
}

#tmpl.debug_compiler = true
t.expand(STDOUT, data)
