# from the sample code by Bruce Williams posted at [amrita-users:00121]
require 'amrita/amulet'
include Amrita

parts = TemplateText.new <<END
<span id=one>
  <span id='phrase'>Something to say</span>, <b id='corollary'>and this too</b>
</span>
<span id=two>
  <b id='interjection'>Something</b>
</span>
<span id=three>
  <i>from $stdin</i>..."<span id='input'>some text</span>"
</span>
END
#"

class AmuletProc
  include Amulet
  def initialize(&block)
    @proc_ = block
  end

  def amulet_data
    @proc_.call
  end
end

parts.define_amulet(:one, :two, :three=>AmuletProc)

t = TemplateText.new <<END
<div id='main'>Well, I'd like to say the following...
  <ul>
    <li id='saying'></li>
  </ul>
</div>
END
#'

data = [
  parts.create_amulet(:one, :phrase => 'Amrita is really flexible', :corollary => 'and powerful, too!' ),
  parts.create_amulet(:two, :interjection => 'Yes!'),
  parts.create_amulet(:three) do
    print 'What do you want to say?> '
    { :input => gets.strip } 
  end                      
]

t.expand(STDERR, :main=>{:saying => data})
