require 'open3'
require 'amrita/template'

load 'tasks.rb'

TIME_CMD='/usr/bin/time -f "%S %U" '

def do_bench1(cmd)
  i,o,e = *Open3.popen3(TIME_CMD + cmd)
  i.close
  result = o.read
  # p result
  ret = e.read
  if ret =~ /([\d\.]+)\s*([\d\.]+)/
    [$1.to_f, $2.to_f]
  else
    raise "unexpected result #{ret}"
  end
end


def do_bench(n)
  puts "start bench #{n} times"
  ENV["CNT"] = n.to_s
  $tasks.collect do |title, cmd|
    print "start #{title}..."
    STDOUT.flush
    if ENV["CNT"] != "1"
      ENV["CNT"] = "1"
      ret1 = do_bench1(cmd)
      print "..."
    else
      ret1 = [0,0]
    end
    STDOUT.flush
    ENV["CNT"] = n.to_s
    ret = do_bench1(cmd)
    p ret
    {
      :title=>title,
      :system=>sprintf("%4.2f", ret[0]),
      :user=>sprintf("%4.2f", ret[1]),
      :total=>sprintf("%4.2f", (ret[0] + ret[1])),
      :one_tran=>sprintf("%4.2f", ((ret[0] + ret[1])*1000)/n.to_f),
      :total_x=>sprintf("%4.2f", ((ret[0]+ret[1]) - (ret1[0]+ret1[1]))),
      :one_tran_x=>sprintf("%4.2f", (((ret[0]+ret[1]) - (ret1[0]+ret1[1]))*1000)/n.to_f)
    }
  end
end

def report(data)
  tmpl = Amrita::TemplateText.new <<-END
  <html>
    <body>
      <h1>amrita benchmark</h1>
      <table>
        <tr><th>title<th>system<th>user<th>total<th>one transaction(MS)<th>total*1<th>one tran*1
        <tr id=data><td id=title><td id=system align=right><td id=user align=right>
        <td id=total align=right><td id=one_tran align=right>
        <td id=total_x align=right><td id=one_tran_x align=right>
      </table>

    <p>*1...total time(N times) - total time(1 time)... means pure running cost without start up load</p>
    </body>
  </html>
  END

  IO.popen("w3m -T text/html -dump", "w") do |f|
    tmpl.expand(f, data)
  end
end

ret = do_bench(ARGV.shift || 10)
report(:data=>ret)
