require "amrita/template"
require "amrita/cc"
include Amrita

Dir::mkdir 'ext' unless FileTest::directory? 'ext'

def time(&block)
  t = Time.now
  yield 
  Time.now - t
end

$compiler = Compiler.new
$vm = VirtualMachine.new


def test(tmpl_text)
  puts tmpl_text[0..200]
  tmpl = HtmlParser::parse_text tmpl_text
  iset = nil
  ctime = time do
    iset = $compiler.compile(tmpl)
  end
  p ctime

  $vm.load_bytecode(iset)
  otime = time do
    iset.prepare($vm, {:optimize => true })
  end
  p otime

  amcc = Amcc.new('ext', "amccout", "Bench", "../../ext")
  t  = TemplateText.new tmpl_text
  amcc.add_template('amrita_template_pragma.html', t) 

  cctime = time do
    amcc.make_ext
  end
  p cctime

  src = File::open("ext/amccout.c").readlines
  p src.size
  
end

test '<!-- amrita_pragma: ScalarData --><span id=aaa></span>'
test '<span id=aaa></span>'
test '<span id=aaa><span id=bbb></span></span>'
test '<span id=aaa><!-- amrita_pragma: ScalarData --><span id=bbb></span></span>'
test '<!-- amrita_pragma: HashData --><span id=aaa><span id=bbb></span></span>'

test '<!-- amrita_pragma: HashData --><span id=aaa><span id=bbb></span><span id=ccc></span></span>'
test '<span id=aaa><span id=bbb></span><span id=ccc></span></span>'
test '<!-- amrita_pragma: HashData --><span id=aaa><span id=bbb><span id=ccc></span></span></span>'
test '<!-- amrita_pragma: HashData --><span id=aaa><span id=bbb><span id=ccc></span></span></span>'
test '<!-- amrita_pragma: HashData --><span id=aaa><!-- amrita_pragma: HashData --><span id=bbb><span id=ccc><span id=ddd></span></span></span></span>'
test File::open('amrita_template_pragma.html').read
test File::open('amrita_complex_pragma.html').read
#test File::open('amrita_template.html').read

