require "amrita/template"
require "amrita/cc"
include Amrita

load 'make_data.rb'

template_file = ARGV.shift || 'amrita_template.html'

case template_file
when "compile"
  require 'amrita/cc'
  Dir::mkdir 'ext' unless FileTest::directory? 'ext'

  amcc = Amcc.new('ext', "amccout", "Bench", "../../ext")

  t = TemplateFile.new 'amrita_template.html'
  t.setup
  t.vm.optimize_bytecode = true
  amcc.add_template('amrita_template.html', t) 

  t = TemplateFile.new 'amrita_template_pragma.html'
  t.setup
  t.vm.optimize_bytecode = true
  amcc.add_template('amrita_template_pragma.html', t) 

  #t = TemplateFile.new 'amrita_template_attr.html'
  #t.setup
  #t.vm.optimize_bytecode = true
  #amcc.add_template('amrita_template_attr.html', t) 

  #t = TemplateFile.new 'amrita_complex_pragma.html'
  #t.setup
  #t.vm.optimize_bytecode = true
  #amcc.add_template('amrita_complex_pragma.html', t) 

  amcc.make_ext
  src = File::open("ext/amccout.c").read
  #print src

  raise "compile error" unless system "cd ext ;ruby extconf.rb; make"
  
else
  require 'ext/amccout.so'
  $data[:table].each do |item|
    if item[:webpage_name] and item[:webpage_name] != ""
      if item[:url] and item[:url] != ""
        item[:webpage] = e(:a, :href=>item[:url]) { item[:webpage_name] }
      else
        item[:webpage] = item[:webpage_name] 
      end
    else
      item[:webpage] = nil
    end
  end

  tmpl = Bench::Templates[template_file]

  $cnt.times  do
    tmpl.expand(STDOUT, $data)  # without compiling
  end
end


