module Amrita
  def warn(msg)
    return unless $VERBOSE
    STDERR.puts "Amrita V2.0 warning: #{msg}"
  end

  class Template
    def prettyprint=(x)
      warn "prettyprint is not supported"
    end

    def compact_space=(x)
      warn "compact_space is not supported"
    end

    def pre_format=(x)
      warn "pre_format is not supported"
    end

    def expand_attr=(x)
      warn "expand_attr is always on"
    end

    def set_hint_by_sample_data(data)
      warn "set_hint_by_sample_data is not supported"
    end
  end

  def noescape(&block)
    x = yield
    case x
    when Node
      x = DefaultElementProcessor.format_node(x)
    else
      x = x.to_s
    end
    SanitizedString[x]
  end

  def pre(&block)
    e(:pre, &block)
  end
  module_function :pre

  class TemplateFileWithCache
    def TemplateFileWithCache::[](path)
      TemplateManager.instance.get_template(path)
    end
    def TemplateFileWithCache::set_cache_dir(path)
      TemplateManager.instance.set_cache_dir(path)
    end
  end
end
