require 'amrita/amulet'

module Amrita
  class PartsAmuletSeed < AmuletSeed
    def initialize(template, element, spec)
      element.delete_attr!(:class)
      super(template, element, spec)
    end
  end

  class Template
    def need_update?
      true
    end

    def install_parts_to(mod)
      setup_template
      self.amulet_attr = 'class'
      classes = template.collect do |ee|
        c = ee[:class]
        if c and c =~ /^[A-Z]/
          {
            c.intern=> {
              :seedclass => PartsAmuletSeed, 
              :placeholder => e(:span, :id=>ee[:id] || ee[:class])
            }
          }
        end
      end.compact
      define_amulet(*classes)
      amulet_seeds.each do |key, seed|
        install_parts_template(mod, key, seed)
      end
      if path and auto_save
        expand('', {})
        TemplateManager.instance.save_template(self) 
      end
    end

    def install_parts_template(mod, cls_name, seed)
      parts_mod = nil
      if mod.const_defined?(cls_name)
        parts_mod = mod.const_get(cls_name)
        raise "#{cls_name} is not a Module but [#{parts_mod.type}]" unless parts_mod.kind_of?(Module)
      else
        parts_mod = Module.new
        mod.const_set(cls_name, parts_mod)
      end

      parts_mod.const_set(:AmuletSeed, seed)
      parts_mod.module_eval <<-END
        include Amulet
        def amulet_iset
          AmuletSeed.iset
        end
      END
    end
  end
end
