

#include "amrita_common.c"

/*
 *   for amrita/node.rb
 */

static void
amrita_attr_mark(data)
amrita_attr_t *data ;
{
    rb_gc_mark((VALUE) data->value);
}

static VALUE
amrita_attr_s_new(argc, argv, class)
int argc;
VALUE* argv;
VALUE class;
{
    amrita_attr_t *attr;
    VALUE obj;

    obj = Data_Make_Struct(class, amrita_attr_t, amrita_attr_mark, 0, attr);
    memset(&attr, sizeof(attr), 0) ;
    attr->key = 0 ;
    attr->value = Qnil ;
    rb_obj_call_init(obj, argc, argv);
    return obj;
}

static VALUE
amrita_attr_init(self, key, value)
VALUE self;
VALUE key;
VALUE value;
{
    amrita_attr_t *data ;

    Data_Get_Struct(self, amrita_attr_t, data) ;
    data->key = obj2id(key) ;
    switch(TYPE(value)) {
    case T_NIL:
    case T_FALSE:
    case T_TRUE:
        data->value = value ;
        break ;
    default:
        data->value = (VALUE) obj2fstr(value) ;
    }
    return self;
}

static VALUE
amrita_attr_key_symbol(self)
VALUE self;
{
    amrita_attr_t *data ;

    Data_Get_Struct(self, amrita_attr_t, data) ;
    return (VALUE) ID2SYM(data->key) ;
}

static VALUE
amrita_attr_key(self)
VALUE self;
{
    amrita_attr_t *data ;

    Data_Get_Struct(self, amrita_attr_t, data) ;
    return (VALUE) obj2fstr(ID2SYM(data->key)) ;
}

static VALUE
amrita_attr_value(self)
VALUE self;
{
    amrita_attr_t *data ;

    Data_Get_Struct(self, amrita_attr_t, data) ;
    return data->value ;
}

static VALUE
amrita_attr_asign_value(self, newvalue)
VALUE self, newvalue;
{
    amrita_attr_t *data ;

    Data_Get_Struct(self, amrita_attr_t, data) ;
    switch(TYPE(newvalue)) {
    case T_NIL:
    case T_FALSE:
    case T_TRUE:
        data->value = newvalue ;
        break ;
    default:
        data->value = (VALUE) obj2fstr(newvalue) ;
    }
    return data->value ;
}

static void
amrita_attrarray_mark(data)
amrita_attrarray_t *data;
{
    rb_gc_mark((VALUE)data->array) ;
    rb_gc_mark(data->body) ;
}

static VALUE
amrita_attrarray_s_new(argc, argv, class)
int argc;
VALUE* argv;
VALUE class;
{
    amrita_attrarray_t *data;
    VALUE obj;

    obj = Data_Make_Struct(class, amrita_attrarray_t, amrita_attrarray_mark, 0, data);
    data->shared = Qfalse ;
    data->array = (struct RArray*) rb_ary_new() ;
    data->body = cNull ;
    rb_obj_call_init(obj, argc, argv);

    return obj;
}

static VALUE
amrita_attrarray_add(VALUE self, VALUE x);

static VALUE
amrita_attrarray_addsub(x, self)
VALUE x, self ;
{
    VALUE a, key, value ;
    
    if (rb_obj_is_kind_of(x, cAttr)) {
        return amrita_attrarray_add(self, x) ;
    }
    Check_Type(x, T_ARRAY) ;
    switch(RARRAY(x)->len) {
    case 1:
        rb_raise(rb_eTypeError, "not valid value for AttrArray");
    case 2:
        a  = amrita_attr_s_new(2, RARRAY(x)->ptr, cAttr) ;
        return amrita_attrarray_add(self, a) ;
    default:
        rb_raise(rb_eTypeError, "not valid value for AttrArray");
    }
}

static VALUE
amrita_attrarray_add(self, x)
VALUE self, x ;
{
    amrita_attrarray_t *data ;
    VALUE class = CLASS_OF(x) ;
    int i;

    //DEBUGOBJ(x) ;

    Data_Get_Struct(self, amrita_attrarray_t, data) ;
    if (rb_obj_is_kind_of(x, cAttr)) {
	rb_ary_push((VALUE)data->array, x) ;
        return x ;
    }

    if (class == rb_cArray) {
        for (i=0; i<RARRAY(x)->len; i++) {
            amrita_attrarray_add(self, RARRAY(x)->ptr[i]) ;
        }
        return x ;
    }
    if (rb_obj_is_kind_of(x, cAttrArray)) {
        rb_iterate(rb_each, x, amrita_attrarray_addsub, self) ;
        return x ;
    }
    if (class == rb_cHash) {
        rb_iterate(rb_each, x, amrita_attrarray_addsub, self) ;
        return x ;
    }
    rb_raise(rb_eTypeError, "not valid value for AttrArray");
}

static VALUE
amrita_attrarray_init(argc, argv, self)
int argc;
VALUE *argv;
VALUE self;
{
    amrita_attrarray_t *data ;
    int i;

    Data_Get_Struct(self, amrita_attrarray_t, data) ;

    for (i=0; i<argc; i++) {
        amrita_attrarray_add(self, argv[i]) ;
    }

    if (rb_block_given_p()) {
        data->body = rb_yield(Qnil) ;
    }
    return self;
}

static VALUE
amrita_attrarray_array(self)
VALUE self ;
{
    amrita_attrarray_t *data ;

    Data_Get_Struct(self, amrita_attrarray_t, data) ;
    return (VALUE)data->array ;
}

static VALUE
amrita_attrarray_body(self)
VALUE self ;
{
    amrita_attrarray_t *data ;

    Data_Get_Struct(self, amrita_attrarray_t, data) ;
    return (VALUE)data->body ;
}

static VALUE
amrita_attrarray_shared(self)
VALUE self ;
{
    amrita_attrarray_t *data ;

    Data_Get_Struct(self, amrita_attrarray_t, data) ;
    return (VALUE)data->shared ;
}

static VALUE
amrita_attrarray_shared_assign(self, x)
VALUE self, x;
{
    amrita_attrarray_t *data ;

    Data_Get_Struct(self, amrita_attrarray_t, data) ;
    if (RTEST(x)) {
        data->shared = Qtrue ;
    } else {
        data->shared = Qfalse ;
    }
    return data->shared ;
}

static void
amrita_element_mark(data)
amrita_element_t *data;
{
    rb_gc_mark((VALUE)data->attrs) ;
    rb_gc_mark((VALUE)data->body) ;
}

static VALUE
amrita_element_s_new(argc, argv, class)
int argc;
VALUE* argv;
VALUE class;
{
    amrita_element_t *data;
    VALUE obj;

    obj = Data_Make_Struct(class, amrita_element_t, amrita_element_mark, 0, data);
    data->attrs = Qnil ;
    data->flags = 0 ;
    data->body = cNull ;
    rb_obj_call_init(obj, argc, argv);

    return obj;
}

static VALUE
amrita_element_init_body(self)
VALUE self;
{
    amrita_element_t *data ;
    VALUE v; 

    Data_Get_Struct(self, amrita_element_t, data) ;
    if (rb_block_given_p()) {
        v = rb_yield(Qnil) ;
        data->body = rb_funcall(mNode, id_to_node, 1, v) ;
    } else {
        data->body = cNull ;
    }
    return self ;
}

static VALUE
amrita_element_init_from_element(self, element)
VALUE self, element;
{
    amrita_element_t *data ;
    amrita_element_t *data2 ;
    amrita_attrarray_t *attrs ;
    VALUE v; 

    Data_Get_Struct(self, amrita_element_t, data) ;
    Data_Get_Struct(element, amrita_element_t, data2) ;
    data->tag = data2->tag ;
    data->attrs = data2->attrs ;

    Data_Get_Struct(data->attrs, amrita_attrarray_t, attrs) ;
    attrs->shared = Qtrue ;

    if (rb_block_given_p()) {
        v = rb_yield(Qnil) ;
        data->body = rb_funcall(mNode, id_to_node, 1, v) ;
    } else {
        data->body = data2->body ;
    }
    return self ;
}

static VALUE
amrita_element_init_from_symbol(self, symbol, argc, argv)
VALUE self, symbol;
int argc ;
VALUE *argv ;
{
    amrita_element_t *data ;
    amrita_attrarray_t *attrs ;

    Data_Get_Struct(self, amrita_element_t, data) ;
    data->tag = SYM2ID(symbol) ;
    // data->attrs = amrita_attrarray_s_new(argc, argv, cAttrArray) ;
    data->attrs = rb_funcall2(cAttrArray, rb_intern("new"), argc, argv) ;
    amrita_element_init_body(self) ;
    return self ;
}

static VALUE
amrita_element_init(argc, argv, self)
int argc;
VALUE *argv;
VALUE self;
{
    VALUE x ;

    if (argc < 1) {
        rb_raise(rb_eArgError, "not enogh parameter for Element");
    }
    x = argv[0] ;
    if (rb_obj_is_kind_of(x, cElement)) {
        if (argc > 1) {
            rb_raise(rb_eArgError, "too many parameter for Element");
        }
        return amrita_element_init_from_element(self, x) ;
    } else {
        return amrita_element_init_from_symbol(self, obj2sym(x), argc-1, argv+1) ;
    }
}

static VALUE
amrita_element_tag_symbol(self)
VALUE self;
{
    amrita_element_t *data ;

    Data_Get_Struct(self, amrita_element_t, data) ;
    return ID2SYM(data->tag) ;
}

static VALUE
amrita_element_set_tag(self, x)
VALUE self, x;
{
    amrita_element_t *data ;

    Data_Get_Struct(self, amrita_element_t, data) ;
    data->tag = obj2id(x) ;
    return x;
}

static VALUE
amrita_element_hide_amrita_id(self)
VALUE self;
{
    amrita_element_t *data ;

    Data_Get_Struct(self, amrita_element_t, data) ;
    if ((data->flags) & AMRITA_ELEM_HIDEHID) {
        return Qtrue ;
    } else {
        return Qfalse ;
    } 
}

static VALUE
amrita_element_hide_amrita_id_bang(self)
VALUE self;
{
    amrita_element_t *data ;

    Data_Get_Struct(self, amrita_element_t, data) ;
    (data->flags) |= AMRITA_ELEM_HIDEHID ;
    return self ;
}

static VALUE
amrita_element_attrs(self)
VALUE self;
{
    amrita_element_t *data ;

    Data_Get_Struct(self, amrita_element_t, data) ;
    return data->attrs ;
}

static VALUE
amrita_element_set_attrs(self, x)
VALUE self, x;
{
    amrita_element_t *data ;

    if (!rb_obj_is_kind_of(x, cAttrArray)) {
        rb_raise(rb_eArgError, "invalid parameter for Element#attrs");
    }
    Data_Get_Struct(self, amrita_element_t, data) ;
    data->attrs = x ;
    return x;
}

static VALUE
amrita_element_body(self)
VALUE self;
{
    amrita_element_t *data ;

    Data_Get_Struct(self, amrita_element_t, data) ;
    return data->body ;
}

/*
 * ElementProcessorCommon
 */

static void
amrita_element_processor_mark(data)
amrita_element_processor_t *data;
{
    rb_gc_mark(data->tagdict) ;
}

static VALUE
amrita_element_processor_s_new(argc, argv, class)
int argc;
VALUE* argv;
VALUE class;
{
    amrita_element_processor_t *data;
    VALUE obj;

    obj = Data_Make_Struct(class, amrita_element_processor_t, amrita_element_processor_mark, 0, data);
    data->tagdict = Qnil ;
    data->flags = AMRITA_EP_DELETE_ID | AMRITA_EP_DELETE_ID_ON_COPY | AMRITA_EP_DELETE_PRAGMA ;
    data->amrita_id = data->escaped_id = 0 ;
    rb_obj_call_init(obj, argc, argv);

    return obj;
}

static VALUE
amrita_element_processor_init(argc, argv, self)
int argc ;
VALUE *argv ;
VALUE self;
{
    amrita_element_processor_t *data ;

    Data_Get_Struct(self, amrita_element_processor_t, data) ;
    if (argc > 0) {
        data->tagdict = *argv++ ;
    } else {
        data->tagdict = rb_const_get(mAmrita, rb_intern("DefaultHtmlTagInfo")) ;

    }
    return self;
}

static VALUE
amrita_element_processor_tagdict(self)
VALUE self;
{
    amrita_element_processor_t *data ;

    Data_Get_Struct(self, amrita_element_processor_t, data) ;
    return data->tagdict ;
}

static VALUE
amrita_element_processor_amrita_id(self)
VALUE self;
{
    amrita_element_processor_t *data ;

    Data_Get_Struct(self, amrita_element_processor_t, data) ;
    if (data->amrita_id) {
        return ID2SYM(data->amrita_id) ;
    } else {
        return Qnil ;
    }
}

static VALUE
amrita_element_processor_amrita_id_assign(self, x)
VALUE self;
{
    amrita_element_processor_t *data ;

    Data_Get_Struct(self, amrita_element_processor_t, data) ;
    if (RTEST(x)) {
        if (data->escaped_id) {
            rb_raise(rb_eRuntimeError, "can't set escpaed_id and amrita_id both at once");
        }
        if (obj2id(x) == id___id__) {
            rb_raise(rb_eRuntimeError, "can't use '__id__' as amrita_id ") ;
        }
        data->escaped_id = id___id__ ;
        data->amrita_id = obj2id(x) ;
    } else {
        data->amrita_id = 0 ;
    }
    return x ;
}

static VALUE
amrita_element_processor_escaped_id(self)
VALUE self;
{
    amrita_element_processor_t *data ;

    Data_Get_Struct(self, amrita_element_processor_t, data) ;
    if (data->escaped_id) {
        return ID2SYM(data->escaped_id) ;
    } else {
        return Qnil ;
    }
}

static VALUE
amrita_element_processor_escaped_id_assign(self, x)
VALUE self;
{
    amrita_element_processor_t *data ;

    Data_Get_Struct(self, amrita_element_processor_t, data) ;
    if (RTEST(x)) {
        if (data->amrita_id) {
            rb_raise(rb_eRuntimeError, "can't set escpaed_id and amrita_id both at once");
        }
        data->escaped_id = obj2id(x) ;
    } else {
        data->escaped_id = 0 ;
    }
    return x ;
}

static VALUE
amrita_element_processor_delete_id(self)
VALUE self;
{
    amrita_element_processor_t *data ;

    Data_Get_Struct(self, amrita_element_processor_t, data) ;
    if (FLAG_TEST(data->flags, AMRITA_EP_DELETE_ID)) {
        return Qtrue ;
    } else {
        return Qfalse ;
    }
}

static VALUE
amrita_element_processor_delete_id_assign(self, x)
VALUE self, x;
{
    amrita_element_processor_t *data ;

    Data_Get_Struct(self, amrita_element_processor_t, data) ;
    if (RTEST(x)) {
        FLAG_SET(data->flags, AMRITA_EP_DELETE_ID) ;
    } else {
        FLAG_RESET(data->flags, AMRITA_EP_DELETE_ID) ;
    }
    return x ;
}

static VALUE
amrita_element_processor_delete_id_on_copy(self)
VALUE self;
{
    amrita_element_processor_t *data ;

    Data_Get_Struct(self, amrita_element_processor_t, data) ;
    if (FLAG_TEST(data->flags, AMRITA_EP_DELETE_ID_ON_COPY)) {
        return Qtrue ;
    } else {
        return Qfalse ;
    }
}

static VALUE
amrita_element_processor_delete_id_on_copy_assign(self, x)
VALUE self, x;
{
    amrita_element_processor_t *data ;

    Data_Get_Struct(self, amrita_element_processor_t, data) ;
    if (RTEST(x)) {
        FLAG_SET(data->flags, AMRITA_EP_DELETE_ID_ON_COPY) ;
    } else {
        FLAG_RESET(data->flags, AMRITA_EP_DELETE_ID_ON_COPY) ;
    }
    return x ;
}

static VALUE
amrita_element_processor_delete_pragma(self)
VALUE self;
{
    amrita_element_processor_t *data ;

    Data_Get_Struct(self, amrita_element_processor_t, data) ;
    if (FLAG_TEST(data->flags, AMRITA_EP_DELETE_PRAGMA)) {
        return Qtrue ;
    } else {
        return Qfalse ;
    }
}

static VALUE
amrita_element_processor_delete_pragma_assign(self, x)
VALUE self, x;
{
    amrita_element_processor_t *data ;

    Data_Get_Struct(self, amrita_element_processor_t, data) ;
    if (RTEST(x)) {
        FLAG_SET(data->flags, AMRITA_EP_DELETE_PRAGMA) ;
    } else {
        FLAG_RESET(data->flags, AMRITA_EP_DELETE_PRAGMA) ;
    }
    return x ;
}



static VALUE
amrita_element_processor_attr_flag(attr, taginfo)
VALUE attr, taginfo ;
{
    amrita_attr_t * a;
	
    if (!RTEST(taginfo)) {
        return Qfalse ;
    }
    Data_Get_Struct(attr, amrita_attr_t, a) ;

    return rb_funcall(taginfo, id_url_attr2, 1, ID2SYM(a->key)) ;
}

static VALUE
amrita_element_processor_attr_ext(str, attr, flag, delete_id, amrita_id)
VALUE str, attr, flag ;
int delete_id ;
ID amrita_id ;
{
    amrita_attr_t * a;
    ID key ;
	
    Data_Get_Struct(attr, amrita_attr_t, a) ;
    key = a->key ;
    if (key == id___id__) {
        key = id_id ;
    } else if (key == id_id) {
        if (delete_id) {
            return Qfalse ;
        }
        if (amrita_id) {
            key = amrita_id ;
        }
    }

    rb_str_cat2(str, rb_id2name(key)) ;
    switch(TYPE(a->value)) {
    case T_TRUE:
        rb_str_cat2(str, "=true") ;
        break ;
    case T_FALSE:
        rb_str_cat2(str, "=false") ;
        break ;
    case T_NIL:
        break ;
    default:
        rb_str_cat2(str, "=\"") ;
        if (RTEST(flag)) {
            output(str, a->value, id_amrita_sanitize_as_url) ;
        } else {
            output(str, a->value, id_amrita_sanitize_as_attribute) ;
        }
        rb_str_cat2(str, "\"") ;
        break ;
    }
    return Qtrue ;
}

static VALUE
amrita_element_processor_format_attrs(self, attrarray, taginfo)
VALUE self, attrarray, taginfo ;
{
    amrita_element_processor_t *data ;
    amrita_attrarray_t *aa ;
    int i, delete_id, cnt ;
    VALUE v, str ;

    if (! rb_obj_is_kind_of(attrarray, cAttrArray)) {
        rb_raise(rb_eArgError, "invalid parameter for ElementProcessor#format_attrs");
    }
    Data_Get_Struct(attrarray, amrita_attrarray_t, aa) ;
	
    if (aa->array->len == 0) {
        return Qnil ;
    }

    str = rb_str_new2("") ;
    Data_Get_Struct(self, amrita_element_processor_t, data) ;
    delete_id = FLAG_TEST(data->flags, AMRITA_EP_DELETE_ID) ;

    if (aa->array->len == 1) {
        // return rb_funcall(self, id_format_attr, 2, aa->array->ptr[0], amrita_element_processor_attr_flag(aa->array->ptr[0], taginfo)) ;
        v = amrita_element_processor_attr_flag(aa->array->ptr[0], taginfo) ;
        v = amrita_element_processor_attr_ext(str, aa->array->ptr[0], v, delete_id, data->amrita_id) ;
        if (RTEST(v)) {
            return str ;
        } else {
            return Qnil ;
        }
    }

    cnt = 0 ;
    for(i=0 ; i<aa->array->len; i++) {
        v = amrita_element_processor_attr_flag(aa->array->ptr[i], taginfo) ;
        v = amrita_element_processor_attr_ext(str, aa->array->ptr[i], v, delete_id, data->amrita_id) ;
        if (RTEST(v)) {
            cnt++ ;
        }
        if (RTEST(v) && i < aa->array->len - 1) {
            rb_str_cat2(str, " ") ;
        }
    }
    if (cnt > 0) {
        return str ;
    } else {
        return Qnil ;
    }
}

static VALUE
amrita_element_processor_do_copy(self)
VALUE self ;
{
    amrita_element_processor_t *data ;
    int delete_id_save ;

    Data_Get_Struct(self, amrita_element_processor_t, data) ;
    delete_id_save = FLAG_TEST(data->flags,AMRITA_EP_DELETE_ID) ;
    if (FLAG_TEST(data->flags, AMRITA_EP_DELETE_ID_ON_COPY)) {
        FLAG_SET(data->flags, AMRITA_EP_DELETE_ID) ;
    }
    rb_yield(Qnil) ;
    if (delete_id_save) {
        FLAG_SET(data->flags, AMRITA_EP_DELETE_ID) ;
    } else {
        FLAG_RESET(data->flags, AMRITA_EP_DELETE_ID) ;
    }
    return self ;
}

void
init_node()
{
    VALUE v ;

    cAttr = rb_define_class_under(mAmritaAccelerator, "Attr", rb_cObject) ;
    v = rb_const_get(mAmrita, rb_intern("AttrCommon")) ;
    rb_include_module(cAttr, v) ;
    rb_define_singleton_method(cAttr, "new", amrita_attr_s_new, -1);
    rb_define_method(cAttr, "initialize", amrita_attr_init, 2);
    rb_define_method(cAttr, "key", amrita_attr_key, 0);
    rb_define_method(cAttr, "key_symbol", amrita_attr_key_symbol, 0);
    rb_define_method(cAttr, "value", amrita_attr_value, 0);
    rb_define_method(cAttr, "value=", amrita_attr_asign_value, 1);

    cAttrArray = rb_define_class_under(mAmritaAccelerator, "AttrArray", rb_cObject) ;
    v = rb_const_get(mAmrita, rb_intern("AttrArrayCommon")) ;
    rb_include_module(cAttrArray, v) ;
    rb_define_singleton_method(cAttrArray, "new", amrita_attrarray_s_new, -1);
    rb_define_method(cAttrArray, "initialize", amrita_attrarray_init, -1);
    rb_define_method(cAttrArray, "add", amrita_attrarray_add, 1);
    rb_define_method(cAttrArray, "<<", amrita_attrarray_add, 1);
    rb_define_method(cAttrArray, "array", amrita_attrarray_array, 0);
    rb_define_method(cAttrArray, "body", amrita_attrarray_body, 0);
    rb_define_method(cAttrArray, "shared", amrita_attrarray_shared, 0);
    rb_define_method(cAttrArray, "shared=", amrita_attrarray_shared_assign, 1);

    cElement = rb_define_class_under(mAmritaAccelerator, "Element", rb_cObject) ;
    v = rb_const_get(mAmrita, rb_intern("ElementCommon")) ;
    rb_include_module(cElement, v) ;
    rb_define_singleton_method(cElement, "new", amrita_element_s_new, -1);
    rb_define_method(cElement, "initialize", amrita_element_init, -1);
    rb_define_method(cElement, "tag_symbol", amrita_element_tag_symbol, 0);
    rb_define_method(cElement, "set_tag", amrita_element_set_tag, 1);
    rb_define_method(cElement, "hide_amrita_id", amrita_element_hide_amrita_id, 0);
    rb_define_method(cElement, "hide_amrita_id!", amrita_element_hide_amrita_id_bang, 0);
    rb_define_method(cElement, "attrs", amrita_element_attrs, 0);
    rb_define_method(cElement, "set_attrs", amrita_element_set_attrs, 1);
    rb_define_method(cElement, "body", amrita_element_body, 0);
    rb_define_method(cElement, "init_body", amrita_element_init_body, 0);

    cElementProcessor = rb_define_class_under(mAmritaAccelerator, "ElementProcessor", rb_cObject) ;
    v = rb_const_get(mAmrita, rb_intern("ElementProcessorCommon")) ;
    rb_include_module(cElementProcessor, v) ;
    rb_define_singleton_method(cElementProcessor, "new", amrita_element_processor_s_new, -1);
    rb_define_method(cElementProcessor, "initialize", amrita_element_processor_init, -1);
    rb_define_method(cElementProcessor, "tagdict", amrita_element_processor_tagdict, 0);
    rb_define_method(cElementProcessor, "delete_id", amrita_element_processor_delete_id, 0);
    rb_define_method(cElementProcessor, "delete_id=", amrita_element_processor_delete_id_assign, 1);
    rb_define_method(cElementProcessor, "delete_id_on_copy", amrita_element_processor_delete_id_on_copy, 0);
    rb_define_method(cElementProcessor, "delete_id_on_copy=", amrita_element_processor_delete_id_on_copy_assign, 1);
    rb_define_method(cElementProcessor, "delete_pragma", amrita_element_processor_delete_pragma, 0);
    rb_define_method(cElementProcessor, "delete_pragma=", amrita_element_processor_delete_pragma_assign, 1);
    rb_define_method(cElementProcessor, "amrita_id", amrita_element_processor_amrita_id, 0);
    rb_define_method(cElementProcessor, "amrita_id=", amrita_element_processor_amrita_id_assign, 1);
    rb_define_method(cElementProcessor, "escaped_id", amrita_element_processor_escaped_id, 0);
    rb_define_method(cElementProcessor, "escaped_id=", amrita_element_processor_escaped_id_assign, 1);
    rb_define_method(cElementProcessor, "format_attrs", amrita_element_processor_format_attrs, 2);
    rb_define_method(cElementProcessor, "do_copy", amrita_element_processor_do_copy, 0);
}


/*
 *   for amrita/vm.rb
 */

static void
amrita_instruction_mark(data)
amrita_instruction_t *data ;
{
    rb_gc_mark((VALUE) data->data);
    rb_gc_mark((VALUE) data->para1);
    rb_gc_mark((VALUE) data->para2);
}

static VALUE
amrita_instruction_s_new(argc, argv, class)
int argc;
VALUE* argv;
VALUE class;
{
    amrita_instruction_t *data;
    VALUE obj;

    obj = Data_Make_Struct(class, amrita_instruction_t, amrita_instruction_mark, 0, data);
    data->flags = 0 ;
    data->func = NULL ;
    data->data = data->para1 = data->para2 = Qnil ;
    rb_obj_call_init(obj, argc, argv);
    return obj;
}

static VALUE
amrita_instruction_init(argc, argv, self)
int argc ;
VALUE *argv ;
VALUE self;
{
    amrita_instruction_t *data ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;
    if (argc > 0) {
        data->data = *argv++ ;
        //DEBUGOBJ(data->data);
    }
    if (argc > 1) {
        data->para1 = *argv++ ;
        //DEBUGOBJ(data->para1);
    }
    if (argc > 2) {
        data->para2 = *argv++ ;
        //DEBUGOBJ(data->para2);
    }
    return self;
}

static VALUE
amrita_instruction_data(self)
VALUE self;
{
    amrita_instruction_t *data ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;
    return data->data ;
}

static VALUE
amrita_instruction_data_assign(self, x)
VALUE self, x;
{
    amrita_instruction_t *data ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;
    data->data = x ;
    return data->data ;
}

static VALUE
amrita_instruction_para1(self)
VALUE self;
{
    amrita_instruction_t *data ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;
    return data->para1 ;
}

static VALUE
amrita_instruction_para1_assign(self,x)
VALUE self, x;
{
    amrita_instruction_t *data ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;
    data->para1 = x ;
    return data->para1 ;
}

static VALUE
amrita_instruction_para2(self)
VALUE self;
{
    amrita_instruction_t *data ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;
    return data->para2 ;
}

/* 
 * this method will be called by Ruby and C(functions in this file) 
 */
static VALUE
amrita_instruction_execute_func(self, reg, stack_para, out, vm)
VALUE self, reg, stack_para, out, vm ;
{
    AMRITA_STACK_T stack = (AMRITA_STACK_T)stack_para ;
    amrita_instruction_t *data ;

    //DEBUGOBJ(self) ;
    Data_Get_Struct(self, amrita_instruction_t, data) ;
    return (*(data->func))(self, reg, stack, out, vm) ;
}

static VALUE
amrita_instruction_execute(self, data, reg, stack ,out, vm)
VALUE self, reg, stack, out, vm ;
amrita_instruction_t *data ;
{
    //DEBUGOBJ(self) ;
    if (data && data->func && ((data->flags & AMRITA_BYTECODE_DEBUG_MODE) == 0)) {
        reg = data->func(self, reg, RARRAY(stack), out, vm) ;
    } else {
        reg = rb_funcall(self, id_execute, 4, reg, stack, out, vm) ;
    }
    return reg ;
}

static VALUE
amrita_instruction_prepare(self, vm, opt, iset)
VALUE self, vm, opt, iset;
{
    amrita_instruction_t *data ;
    VALUE v ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;

    if (data->func) {
        rb_define_singleton_method(self, "execute_func", amrita_instruction_execute_func, 4);
    } 
    Check_Type(opt, T_HASH) ;
    if (st_lookup(RHASH(opt)->tbl, id_debug, &v)) {
        data->flags |= AMRITA_BYTECODE_DEBUG_MODE ;
    }
    return self ;
}

/*
 * NullInstruction
 */

static VALUE
amrita_nullinstruction_execute_func(self, reg, stack_para, out, vm)
VALUE self, reg, stack_para, out, vm ;
{
    AMRITA_STACK_T stack = (AMRITA_STACK_T)stack_para ;
    amrita_instruction_t *data ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;

    return reg ;
}

static VALUE
amrita_nullinstruction_init(argc, argv, self)
int argc ;
VALUE *argv ;
VALUE self;
{
    amrita_instruction_t *data ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;
    data->func = amrita_nullinstruction_execute_func ;
    return self;
}

/*
 * GetDataByKey
 */

static VALUE
amrita_getdatabykey_init(argc, argv, self)
int argc ;
VALUE *argv ;
VALUE self;
{
    amrita_instruction_t *data ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;
    if (argc > 0) {
        data->data = obj2sym(*argv++) ;
    }
    return self;
}

/*
 * PrintRegister
 */

static VALUE
amrita_printregister_execute_func(self, reg, stack_para, out, vm)
VALUE self, reg, stack_para, out, vm ;
{
    AMRITA_STACK_T stack = (AMRITA_STACK_T)stack_para ;
    amrita_instruction_t *data ;
    VALUE v ;

    // DEBUGSTR("PrintRegister#execute_func") ;
    // DEBUGOBJ(reg) ;

    if (rb_obj_is_kind_of(reg, mNode)) {
        v = rb_funcall(vm, id_ep, 0) ;
        v = rb_funcall(v, id_format_node, 1, reg) ;
        output(out, v, NULL) ;
        return reg ;
    }
    output(out, reg, id_amrita_sanitize) ;
    return reg ;
}

static VALUE
amrita_printregister_init(argc, argv, self)
int argc ;
VALUE *argv ;
VALUE self;
{
    amrita_instruction_t *data ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;
    data->func = amrita_printregister_execute_func ;
    return self;
}

/*
 * Sequence
 */

static VALUE
amrita_sequence_execute_func(self, reg, stack_para, out, vm)
VALUE self, reg, stack_para, out, vm ;
{
    AMRITA_STACK_T stack = (AMRITA_STACK_T)stack_para ;
    amrita_instruction_t *data ;
    VALUE v = reg ;
    struct RArray *a;
    int i ;
    
    //DEBUGSTR("Sequence#execute_func") ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;
    Check_Type(data->data, T_ARRAY) ;
    a = RARRAY(data->data) ;
    for(i = 0 ; i < a->len ; i++) {
        if (rb_obj_is_kind_of(a->ptr[i], cInstruction)) {
            Data_Get_Struct(a->ptr[i], amrita_instruction_t, data) ;
        } else {
            data = NULL ;
        }
        v = amrita_instruction_execute(a->ptr[i], data, v, stack, out, vm) ;
    }
    return v ;
}

static VALUE
amrita_sequence_init(argc, argv, self)
int argc ;
VALUE *argv ;
VALUE self;
{
    amrita_instruction_t *data ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;
    data->func = amrita_sequence_execute_func ;
    data->data = rb_ary_new4(argc, argv) ;
    return self;
}

static VALUE
amrita_sequence_each(self)
VALUE self ;
{
    int i ;
    amrita_instruction_t *data ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;
    for (i=0; i<RARRAY(data->data)->len; i++) {
        rb_yield(RARRAY(data->data)->ptr[i]);
    }
    return self ;
}

static VALUE
amrita_sequence_replace_instructions(self, x)
VALUE self, x;
{
    int i ;
    amrita_instruction_t *data ;

    Check_Type(x, T_ARRAY) ;
    Data_Get_Struct(self, amrita_instruction_t, data) ;
    data->data = x ;
    return x ;
}

/*
 * Loop
 */

static VALUE
amrita_loop_execute_funcsub(x, para) 
VALUE x, para ;
{
    VALUE self = RARRAY(para)->ptr[0] ;
    VALUE stack = RARRAY(para)->ptr[1] ;
    VALUE out = RARRAY(para)->ptr[2] ;
    VALUE vm = RARRAY(para)->ptr[3] ;
    amrita_instruction_t *data, *bodydata = NULL ;

    // DEBUGOBJ(x) ;
    Data_Get_Struct(self, amrita_instruction_t, data) ;
    if (rb_obj_is_kind_of(data->data, cInstruction)) {
        Data_Get_Struct(data->data, amrita_instruction_t, bodydata) ;
    }
    return amrita_instruction_execute(data->data, bodydata, x, stack, out, vm) ;
}

static VALUE
amrita_loop_execute_func(self, reg, stack_para, out, vm)
VALUE self, reg, stack_para, out, vm ;
{
    AMRITA_STACK_T stack = (AMRITA_STACK_T)stack_para ;
    amrita_instruction_t *data, *bodydata = NULL ;
    VALUE v = reg ;
    struct RArray *a;
    int i ;

    // DEBUGSTR("Loop#execute_func") ;
    Data_Get_Struct(self, amrita_instruction_t, data) ;
    // DEBUGOBJ(reg) ;
    if (rb_obj_is_kind_of(data->data, cInstruction)) {
        Data_Get_Struct(data->data, amrita_instruction_t, bodydata) ;
    }
    switch(TYPE(reg)) {
    case T_NIL:
        break ;
    case T_ARRAY:
        a = RARRAY(reg) ;
        for(i = 0 ; i < a->len ; i++) {
            v = amrita_instruction_execute(data->data, bodydata, a->ptr[i], stack, out, vm) ;
        }
        break ;
    default:
        rb_iterate(rb_each, reg, amrita_loop_execute_funcsub, rb_ary_new3(4, self, stack, out, vm)) ;
    }
		
    return v ;
}

static VALUE
amrita_loop_init(argc, argv, self)
int argc ;
VALUE *argv ;
VALUE self;
{
    amrita_instruction_t *data ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;
    data->func = amrita_loop_execute_func ;
    if (argc > 0) {
        data->data = *argv++ ;
    }
    return self;
}

/*
 * SelectByType
 */

static VALUE
amrita_selectbytype_init(argc, argv, self)
int argc ;
VALUE *argv ;
VALUE self;
{
    amrita_instruction_t *data ;

    Data_Get_Struct(self, amrita_instruction_t, data) ;
    data->data = rb_ary_new() ;
    return self;
}


/*
 * Init
 */

VALUE define_instruction_class(name, init_func)
char *name ;
VALUE (*init_func)() ;
{
    VALUE class = rb_define_class_under(mByteCode, name, cInstruction) ;
    VALUE mCommon = rb_const_get(mByteCodeCommon, rb_intern(name)) ;
    rb_define_singleton_method(class, "[]", amrita_instruction_s_new, -1);
    rb_include_module(class, mCommon) ;
    if (init_func) {
        rb_define_method(class, "initialize", init_func, -1);
    }
    return class ;
}

void
init_bytecode()
{
    VALUE v ;
    mByteCodeCommon = rb_const_get(mAmrita, rb_intern("ByteCodeCommon")) ;
    mByteCode = rb_define_module_under(mAmritaAccelerator, "ByteCode") ;

    cInstruction = rb_define_class_under(mByteCode, "Instruction", rb_cObject) ;
    rb_define_singleton_method(cInstruction, "new", amrita_instruction_s_new, -1);
    rb_define_method(cInstruction, "initialize", amrita_instruction_init, -1);
    rb_define_method(cInstruction, "prepare", amrita_instruction_prepare, 3);
    rb_define_method(cInstruction, "data", amrita_instruction_data, 0);
    rb_define_method(cInstruction, "para1", amrita_instruction_para1, 0);
    rb_define_method(cInstruction, "para2", amrita_instruction_para2, 0);

    define_instruction_class("NullInstruction", amrita_nullinstruction_init) ;

    v = define_instruction_class("GetDataByKey", amrita_getdatabykey_init) ;
    rb_define_method(v, "key", amrita_instruction_data, 0);

    v = define_instruction_class("ExtractData", amrita_instruction_init) ;
    rb_define_method(v, "keys", amrita_instruction_data, 0);

    define_instruction_class("PopData", NULL) ;

    define_instruction_class("SwapData", NULL) ;

    v = define_instruction_class("PrintStaticText", amrita_instruction_init) ;
    rb_define_method(v, "text", amrita_instruction_data, 0);

    v = define_instruction_class("PrintStaticNode", amrita_instruction_init) ;
    rb_define_method(v, "node", amrita_instruction_data, 0);
    rb_define_method(v, "text", amrita_instruction_para1, 0);
    rb_define_method(v, "text=", amrita_instruction_para1_assign, 1);

    define_instruction_class("PrintRegister", amrita_printregister_init) ;

    define_instruction_class("GetDataFromAttrArray", NULL) ;

    v = define_instruction_class("MergeElement", NULL) ;
    rb_define_method(v, "element", amrita_instruction_data, 0);

    v = define_instruction_class("Sequence", amrita_sequence_init) ;
    rb_define_method(v, "instructions", amrita_instruction_data, 0);
    rb_define_method(v, "each", amrita_sequence_each, 0);
    rb_define_method(v, "replace_instructions", amrita_sequence_replace_instructions, 1);

    v = define_instruction_class("PrintDynamicElement", amrita_instruction_init) ;
    rb_define_method(v, "body", amrita_instruction_data, 0);

    v = define_instruction_class("Loop", amrita_loop_init) ;
    rb_define_method(v, "body", amrita_instruction_data, 0);

    v = define_instruction_class("SelectByType", amrita_selectbytype_init) ;
    rb_define_method(v, "conds", amrita_instruction_data, 0);
    rb_define_method(v, "else_", amrita_instruction_para1, 0);
    rb_define_method(v, "else_=", amrita_instruction_para1_assign, 1);
}

void
Init_amrita_accel()
{
    VALUE v ;
    /* puts("init_amrita_accel") ; */

    mAmrita = rb_define_module("Amrita");
    mAmritaAccelerator = rb_define_module("AmritaAccelerator");
    init_static_constants() ;
    init_node() ;
    init_bytecode () ;
}
