#----------------------------------------------------------------------------
#   test_tool.rb
#----------------------------------------------------------------------------
#  Copyright (C) 2003 August Nowake(野分) nowake@fiercewinds.net
#  This program is free software; you can redistribute it and/or modify it 
#  under the terms of the GNU General Public License version 2 as published 
#  by the Free Software Foundation.
#  This program is distributed in the hope that it will be useful, but 
#     WITHOUT ANY WARRANTY;
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#  You should have received a copy of the GNU General Public License along 
#  with this program; if not, write to the Free Software Foundation, Inc., 
#  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#----------------------------------------------------------------------------
#  このプログラムはフリーソフトウェアです。あなたはこれを、フリーソフトウェア
#  財団によって発行された GNU一般公衆利用許諾契約書(バージョン2)の定める条件
#  の下で再頒布または改変することができます。
#  このプログラムは有用であることを願って頒布されますが、
#    *全くの無保証*
#  です。商業可能性の保証や特定の目的への適合性は、言外に示されたものも含め
#  全く存在しません。詳しくはGNU 一般公衆利用許諾契約書をご覧ください。
#  あなたはこのプログラムと共に、GNU 一般公衆利用許諾契約書の複製物を一部
#  受け取ったはずです。もし受け取っていなければ、フリーソフトウェア財団まで
#  請求してください。
#  (宛先は the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#  Boston, MA 02111-1307 USA)
#----------------------------------------------------------------------------

require '../tool'

class TC_TriDiff < Test::Unit::TestCase
  include SikiTool
  #def setup end
  #def teardown end
  def test_execute
    m1 = ""; m2 = ""; o = ""; e = "";
    assert_equal( e, TriDiff.new( o, m1, m2 ).integrate )
    m1 = "abcde"; m2 = "abcde"; o = "abcde"; e = "abcde";
    assert_equal( e, TriDiff.new( o, m1, m2 ).integrate )
    m1 = "abcde"; m2 = "a123bcdefg"; o = "abcde"; e = "a123bcdefg";
    assert_equal( e, TriDiff.new( o, m1, m2 ).integrate )
    m1 = "abcde"; m2 = "a123bcdefg"; o = "123abcde"; e = "123a123bcdefg";
    assert_equal( e, TriDiff.new( o, m1, m2 ).integrate )
    m1 = "abcdefghijk"; m2 = "4acej5kl";
    o = "123abcdefghijk"; e = "1234acej5kl";
    assert_equal( e, TriDiff.new( o, m1, m2 ).integrate )
    m1 = "abcdefghijklmn"; m2 = "abfgjklmn"; o = "abdefghikn"; e = "abfgkn";
    assert_equal( e, TriDiff.new( o, m1, m2 ).integrate )
    m1 = "abcdefghijklmnopurstuvwxyz"; m2 = "almnopurstuvwxyz1";
    o = "abcghijklmnopurstuvwxyz"; e = "almnopurstuvwxyz1";
    assert_equal( e, TriDiff.new( o, m1, m2 ).integrate )
    m1 = "abcdefghijklmnopurstuvwxyz"; m2 = "abcdefghilmnopurstuvwxyz1";
    o = "ajklmnopurstuvwxyz"; e = "almnopurstuvwxyz1";
    assert_equal( e, TriDiff.new( o, m1, m2 ).integrate )
    m1 = "abcdefghijklmnopurstuvwxyz"; m2 = "abcdefghijklm1";
    o = "amnopurstuvwxyz"; e = "am1";
    assert_equal( e, TriDiff.new( o, m1, m2 ).integrate )
    m1 = "abcdefghijklmnopurstuvwxyz"; m2 = "abcdefghijklm1";
    o = "amnopurstuvwxyz"; e = "am1";
    assert_equal( e, TriDiff.new( o, m1, m2 ).integrate )
    m1 = "アイウエオ。"
    m2 = "アイウエオテスト２"
    o = "アイウエオテスト１"
    e = "アイウエオテスト１テスト２"
    assert_equal( e, TriDiff.new( o, m1, m2 ).integrate )
    m1 = "aba"; m2 = "a"; o = "abba"; e = "ab"
    assert_equal( e, TriDiff.new( o, m1, m2 ).integrate )
  end
end


class TC_DiffResultControler < Test::Unit::TestCase
  include SikiTool
  #def setup end
  #def teardown end
  def test_delete
    m1 = "012359"; m2 = "0123456789"; n1 = "1359"; n2 = "13456789";
    assert_equal( Diff.diff( n1, n2 ),
        DiffResultControler.new( Diff.diff( m1, m2 ) ).
        delete( 1 ).advance( 1 ).delete( 1 ).diff )
    m1 = "01356789a"; m2 = "0123456789"; n1 = "13589a"; n2 = "1234589";
    assert_equal( Diff.diff( n1, n2 ),
        DiffResultControler.new( Diff.diff( m1, m2 ) ).
        delete( 1 ).advance( 3 ).delete( 2 ).diff )
    m1 = "0123456789"; m2 = "01245679"; n1 = "05789"; n2 = "0579";
    assert_equal( Diff.diff( n1, n2 ),
        DiffResultControler.new( Diff.diff( m1, m2 ) ).
        advance( 1 ).delete( 4 ).advance( 1 ).delete( 1 ).diff )
    m1 = "0123456789"; m2 = "01245ab679"; n1 = "05789"; n2 = "05ab79";
    assert_equal( Diff.diff( n1, n2 ),
        DiffResultControler.new( Diff.diff( m1, m2 ) ).
        advance( 1 ).delete( 4 ).advance( 1 ).delete( 1 ).diff )
    m1 = "0123456789"; m2 = "01245ab679"; n1 = "0789"; n2 = "0ab79";
    assert_equal( Diff.diff( n1, n2 ),
        DiffResultControler.new( Diff.diff( m1, m2 ) ).
        advance( 1 ).delete( 6 ).diff )
    m1 = "01234567890123456789"; m2 = "z012345678901245ab679c"
    n1 = "0789"; n2 = "z0ab79c";
    assert_equal( Diff.diff( n1, n2 ),
        DiffResultControler.new( Diff.diff( m1, m2 ) ).
        advance( 1 ).delete( 16 ).diff )
  end
  def test_add
    m1 = "0123456789"; m2 = "z01245ab679c"
    n1 = "01234567890123456789"; n2 = "0123456789z01245ab679c";
    assert_equal( Diff.diff( n1, n2 ),
        DiffResultControler.new( Diff.diff( m1, m2 ) ).
        add( 10 ).diff )
  end
end

