#----------------------------------------------------------------------------
#   save.rb
#----------------------------------------------------------------------------
#  Copyright (C) 2003 August Nowake(野分) nowake@fiercewinds.net
#  This program is free software; you can redistribute it and/or modify it 
#  under the terms of the GNU General Public License version 2 as published 
#  by the Free Software Foundation.
#  This program is distributed in the hope that it will be useful, but 
#     WITHOUT ANY WARRANTY;
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#  You should have received a copy of the GNU General Public License along 
#  with this program; if not, write to the Free Software Foundation, Inc., 
#  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#----------------------------------------------------------------------------
#  このプログラムはフリーソフトウェアです。あなたはこれを、フリーソフトウェア
#  財団によって発行された GNU一般公衆利用許諾契約書(バージョン2)の定める条件
#  の下で再頒布または改変することができます。
#  このプログラムは有用であることを願って頒布されますが、
#    *全くの無保証*
#  です。商業可能性の保証や特定の目的への適合性は、言外に示されたものも含め
#  全く存在しません。詳しくはGNU 一般公衆利用許諾契約書をご覧ください。
#  あなたはこのプログラムと共に、GNU 一般公衆利用許諾契約書の複製物を一部
#  受け取ったはずです。もし受け取っていなければ、フリーソフトウェア財団まで
#  請求してください。
#  (宛先は the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#  Boston, MA 02111-1307 USA)
#----------------------------------------------------------------------------

module Command
  class Save
    def initialize( variables )
      @variables = variables
    end
    def execute( node )
      write_node = Node::Accessor.new( node.name, @variables )
      original =
          @variables.cgi_value( Edit::PreEditData.base_name ) +
          @variables.cgi_value( Edit::OriginalData.base_name ) +
          @variables.cgi_value( Edit::PostEditData.base_name )
      original = CGI.unescapeHTML( original )
      edit =
          @variables.cgi_value( Edit::PreEditData.base_name ) +
          @variables.cgi_value( Edit::EditData.base_name ) +
          @variables.cgi_value( Edit::PostEditData.base_name )
      edit = CGI.unescapeHTML( edit )
      write_node.content = original, edit
      write_node.save
      fn = @variables.command_template_root + 'save.html'
      template = Amrita::TemplateText.new(
          File.open( fn, "r+b" ) do | f | f.read.untaint end )
      uri = @variables.cgi_uri + '?' + Command.base_name + '=' +
          Command::Show.base_name + ';' + Node::Target.base_name + '=' +
          node.escaped_name
      data = {
        :show_uri => uri
      }
      @variables.http_header_set['Location'] = uri
      template.expand( "", data )
    end
  end
end

