#----------------------------------------------------------------------------
#   lookback.rb
#----------------------------------------------------------------------------
#  Copyright (C) 2003 August Nowake(野分) nowake@fiercewinds.net
#  This program is free software; you can redistribute it and/or modify it 
#  under the terms of the GNU General Public License version 2 as published 
#  by the Free Software Foundation.
#  This program is distributed in the hope that it will be useful, but 
#     WITHOUT ANY WARRANTY;
#  without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#  You should have received a copy of the GNU General Public License along 
#  with this program; if not, write to the Free Software Foundation, Inc., 
#  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#----------------------------------------------------------------------------
#  このプログラムはフリーソフトウェアです。あなたはこれを、フリーソフトウェア
#  財団によって発行された GNU一般公衆利用許諾契約書(バージョン2)の定める条件
#  の下で再頒布または改変することができます。
#  このプログラムは有用であることを願って頒布されますが、
#    *全くの無保証*
#  です。商業可能性の保証や特定の目的への適合性は、言外に示されたものも含め
#  全く存在しません。詳しくはGNU 一般公衆利用許諾契約書をご覧ください。
#  あなたはこのプログラムと共に、GNU 一般公衆利用許諾契約書の複製物を一部
#  受け取ったはずです。もし受け取っていなければ、フリーソフトウェア財団まで
#  請求してください。
#  (宛先は the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#  Boston, MA 02111-1307 USA)
#----------------------------------------------------------------------------

module Command
  class Lookback
    module Datetime end
    def initialize( variables )
      @variables = variables
    end
    def execute( node )
      datetime = nil
      s = @variables.cgi_value( Datetime.base_name ).gsub!(" ", "+")
      if s and (s != "")
        datetime = DateTime.parse( s )
      else
        datetime = DateTime.now
      end
      node.backup_datetime = datetime
      m, d = *node.backup_modification
      content = ""
      m.each do | i |
        if i[0] == :+
          content <<
              "<ins class=\"insert\"><strong>" +
              CGI.escapeHTML( i[1] ).gsub( ' ', '&nbsp;' ) +
              "</strong></ins class=\"insert\">"
        elsif i[0] == :-
          content <<
              "<del class=\"delete\"><strong>" +
              CGI.escapeHTML( i[1] ).gsub( ' ', '&nbsp;' ) +
              "</strong></del class=\"delete\">"
        else
          content << CGI.escapeHTML( i[1] ).gsub( ' ', '&nbsp;' )
        end
      end
      content.gsub!( "\n", "<br />\n" )
      fn = @variables.command_template_root+'lookback.html'
      template = Amrita::TemplateText.new(
          File.open( fn, "r+b" ) do | f | f.read.untaint end )
      table = []
      uri_lookback =
          "#{@variables.cgi_uri}\?" +
          "#{Command.base_name}=#{Command::Lookback.base_name};" +
          "#{Node::Target.base_name}=#{node.escaped_name};" +
          "#{Datetime.base_name}="
      d.each do | i |
        table << { :datetime => i[0].to_s, :link => uri_lookback + i[0].to_s }
      end
      previous = DateTime.new(
          datetime.year, datetime.month, 1, 0, 0, 0, 0.375 ) - 0.0000001
      previous_link = uri_lookback + previous.to_s
      data = {
        :year => node.backup_datetime.year,
        :month => node.backup_datetime.month,
        :day => node.backup_datetime.day,
        :hour => node.backup_datetime.hour,
        :min => node.backup_datetime.min,
        :sec => node.backup_datetime.sec,
        :zone => node.backup_datetime.zone,
        :content => Amrita::SanitizedString[content],
        :table => table,
        :previous_month => previous.month,
        :previous_link => previous_link,
      }
      template.expand( "", data )
    end
  end
end

