/*SIE under the MIT Lisence
 *公式ページは http://sie.osdn.jp/
 */
/*
 *Copyright (c) 2008-2010 Pivotal Labs

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

describe("SMIL Animation Spec", function() {
  describe("$frame object", function() {
    var frame = base("$frame");
    beforeEach( function() {
        frame.timelines = [];
        frame.isPaused = false;
    } );
    afterEach( function() {
        frame.timelines = [];
    } );
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
      expect(typeof frame.setFrame).toBe("function");
      expect(frame.timelines.length).toBe(0);
      expect(frame.isBegin).toBeFalsy();
      expect(frame.startAnimation()).toBeUndefined();
      expect(frame.begin).toBe(-Number.MAX_VALUE);
      frame.setFrame();
      frame.setFrame(0);
      /*負の値も許される*/
      frame.setFrame(-1);
      
      expect(frame.addLine()).toBe(false);
      expect(frame.addLine({})).toBe(false);
      expect(frame.addLine({
        begin: 0
      })).toBe(false);
      expect(frame.addLine({
        activeTime: 1
      })).toBe(false);
      
      expect(frame.removeLine()).toBeUndefined();
      expect(frame.removeLine({})).toBeUndefined();
      
      frame.setFrame(0);
      expect(frame.currentFrame).toBe(0);
      frame.setFrame(1);
      expect(frame.currentFrame).toBe(1);
      
      expect(frame.isPaused).toBeFalsy();
      expect(frame.pauseAnimation()).toBeUndefined();
      expect(frame.isPaused).toBeTruthy();

    });
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      frame.setFrame(0);
      expect(frame.currentFrame).toBe(0);
      frame.startTime = Date.now();
      for (var i=0;i<100000;i++) {
        /*負荷をかけて、時間を進める*/
        1;
      }
      expect(frame.begin).toBe(-Number.MAX_VALUE);
      expect(frame.activeTime).toBe(Number.MAX_VALUE);
      frame.begin = 10;
      frame.setFrame(0);
      frame.begin = -10;
      frame.setFrame(0);

      expect(frame.addLine( {
        begin: 0,
        activeTime: 0
      })).toBe(true);
      expect(frame.addLine( {
        begin: null,
        activeTime: null
      })).toBe(false);
      expect(frame.addLine( {
        begin: 0,
        activeTime: null
      })).toBe(false);
      expect(frame.addLine( {
        begin: null,
        activeTime: 0
      })).toBe(false);
      
      expect(frame.timelines.length).toBe(1);
      var timeline = frame.timelines[0];
      expect(timeline.begin).toBe(0);
      expect(timeline.activeTime).toBe(0);
      /*timelineの再追加*/
      expect(frame.timelines[0]).toBe(timeline);
      frame.addLine({begin:1, activeTime:1});
      expect(frame.timelines[1]).not.toBe(timeline);
      frame.addLine(timeline);
      expect(frame.timelines[0]).not.toBe(timeline);
      expect(frame.timelines[1]).toBe(timeline);

      timeline = frame.timelines[0];
      frame.removeLine({});
      expect(frame.timelines[0]).toBe(timeline);
      frame.removeLine(timeline);
      expect(frame.timelines[0]).not.toBe(timeline);
      
      frame.addLine(frame.up().mix( {
        timelines: [] 
        } ));
      expect(frame.timelines).not.toBe(frame.$1.timelines);
      
      frame.timelines.length = 0;
      frame.addLine( {
        begin: 1,
        activeTime: 1
      } );
      frame.addLine( {
        begin: 1,
        activeTime: 1
      } );
      frame.addLine( {
        begin: 1,
        activeTime: 2
      } );
      expect(frame.timelines[2].activeTime).toBe(2);
    });
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
      expect(frame.addLine(12)).toBeFalsy();
      /*循環参照にならず、スタック領域不足にならない*/
      frame.addLine(frame);
      frame.setFrame(0);
    });
  } );
  describe("the $frame.$list object", function() {
    var frame;
    beforeEach( function() {
        frame = base("$frame").$list.up();
        frame.timelines = [];
        frame.isPaused = false;
        frame.state = frame.WAITING;
        frame.begin = 0;
    } );
    afterEach( function() {
        frame.timelines = [];
    } );
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
            
      expect(frame.WAITING).toBe(0);
      expect(frame.BEGINNING).toBe(1);
      expect(frame.PLAYING).toBe(2);
      expect(frame.ENDING).toBe(3);
      expect(frame.POSTWAITING).toBe(4);
      expect(frame.state).toBe(frame.WAITING);
      expect(frame.end).toBe(0);
      expect(frame.beginEnd).toBe(Number.MAX_VALUE);
      
      expect(frame.beginList).toEqual({
              next: null,
              value: Number.MAX_VALUE
            });
      expect(frame.endList).toEqual({
              next: null,
              value: Number.MAX_VALUE
            });
            
      expect(typeof frame.getMaxList).toBe("function");
      
      expect(typeof frame.updateState).toBe("function");
      expect(frame.updateState(0).state).toBe(frame.WAITING);
      expect(frame.state).toBe(frame.WAITING);
      expect(frame.updateState(0).state).toBe(frame.WAITING);
      expect(frame.state).toBe(frame.WAITING);
      expect(frame.updateState(0).state).toBe(frame.WAITING);
      expect(frame.state).toBe(frame.WAITING);
      expect(frame.updateState(0).state).toBe(frame.WAITING);
      expect(frame.state).toBe(frame.WAITING);
      
      frame.state = 100;
      expect(frame.updateState(0).state).toBe(frame.BEGINNING);
      expect(frame.state).toBe(frame.BEGINNING);
      expect(frame.updateState().state).toBe(frame.BEGINNING);
      expect(frame.state).toBe(frame.BEGINNING);
      
      expect(frame.beginList).toEqual({
          next: null,
          value: Number.MAX_VALUE
        });
      expect(frame.endList).toEqual({
          next: null,
          value: Number.MAX_VALUE
        });
        
      expect(frame.getMaxList(0, frame.beginList)).toBe(-Number.MAX_VALUE);
      expect(frame.getMaxList(0, frame.endList)).toBe(-Number.MAX_VALUE);
      
      frame.begin = 12;
      frame.init();
      expect(frame.state).toBe(frame.WAITING);
      expect(frame.begin).toBe(0);
      expect(frame.init()).toBe(frame);

    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      
      function appendBegin(num) {
        frame.state = frame.WAITING;
        frame.beginList = {
          value: num,
          next: frame.beginList
        };
      };
      appendBegin(0);
      expect(frame.getMaxList(0, frame.beginList)).toBe(0);
      expect(frame.updateState(0).state).toBe(frame.BEGINNING);
      expect(frame.begin).toBe(0);
      expect(frame.updateState(0).state).toBe(frame.PLAYING);
      expect(frame.state).toBe(frame.PLAYING);
      expect(frame.updateState(0).state).toBe(frame.PLAYING);
      expect(frame.state).toBe(frame.PLAYING);
      
      frame.state = frame.WAITING;
      expect(frame.getMaxList(0, frame.beginList)).toBe(0);
      expect(frame.updateState(0).state).toBe(frame.BEGINNING);
      expect(frame.state).toBe(frame.BEGINNING);
      expect(frame.updateState(1).state).toBe(frame.PLAYING);
      expect(frame.state).toBe(frame.PLAYING);
      expect(frame.updateState(2).state).toBe(frame.PLAYING);
      expect(frame.state).toBe(frame.PLAYING);
      expect(frame.updateState(3).state).toBe(frame.PLAYING);
      expect(frame.state).toBe(frame.PLAYING);
      expect(frame.updateState(4).state).toBe(frame.PLAYING);
      expect(frame.state).toBe(frame.PLAYING);
      
      appendBegin(1);
      expect(frame.getMaxList(1, frame.beginList)).toBe(1);
      expect(frame.updateState(0).state).toBe(frame.BEGINNING);
      expect(frame.updateState(0).state).toBe(frame.PLAYING);
      expect(frame.updateState(0).state).toBe(frame.PLAYING);
      expect(frame.updateState(1).state).toBe(frame.ENDING);
      expect(frame.updateState(1).state).toBe(frame.BEGINNING);
      expect(frame.state).toBe(frame.BEGINNING);
      expect(frame.updateState(1).state).toBe(frame.PLAYING);
      expect(frame.state).toBe(frame.PLAYING);
      expect(frame.updateState(1).state).toBe(frame.PLAYING);
      expect(frame.state).toBe(frame.PLAYING);
      expect(frame.updateState(2).state).toBe(frame.PLAYING);
      
      frame.begin = 0;
      frame.state = frame.WAITING;
      expect(frame.updateState(0).state).toBe(frame.BEGINNING);
      expect(frame.begin).toBe(0);
      expect(frame.updateState(0).state).toBe(frame.PLAYING);
      expect(frame.updateState(0).state).toBe(frame.PLAYING);
      expect(frame.begin).toBe(0);
      expect(frame.updateState(1).state).toBe(frame.ENDING);
      expect(frame.end).toBe(0);
      expect(frame.beginEnd).toBe(Number.MAX_VALUE);
      expect(frame.updateState(1).state).toBe(frame.BEGINNING);
      expect(frame.begin).toBe(1);
      expect(frame.updateState(1).state).toBe(frame.PLAYING);
      expect(frame.updateState(1).state).toBe(frame.PLAYING);
      
      function appendEnd(num) {
        frame.state = frame.WAITING;
        frame.begin = 0;
        frame.endList = {
            value: num,
            next: frame.endList
        };
      };
      appendEnd(3);
      expect(frame.updateState(1).state).toBe(frame.BEGINNING);
      expect(frame.state).toBe(frame.BEGINNING);
      expect(frame.updateState(2).state).toBe(frame.PLAYING);
      expect(frame.updateState(2).state).toBe(frame.PLAYING);
      expect(frame.state).toBe(frame.PLAYING);
      expect(frame.updateState(3).state).toBe(frame.ENDING);
      expect(frame.state).toBe(frame.ENDING);
      expect(frame.end).toBe(3);
      expect(frame.beginEnd).toBe(2);
      expect(frame.updateState(4).state).toBe(frame.POSTWAITING);
      expect(frame.state).toBe(frame.POSTWAITING);
      
      appendEnd(4);
      expect(frame.updateState(1).state).toBe(frame.BEGINNING);
      expect(frame.state).toBe(frame.BEGINNING);
      expect(frame.updateState(2).state).toBe(frame.PLAYING);
      expect(frame.updateState(2).state).toBe(frame.PLAYING);
      expect(frame.state).toBe(frame.PLAYING);
      expect(frame.updateState(3).state).toBe(frame.ENDING);
      expect(frame.state).toBe(frame.ENDING);
      expect(frame.end).toBe(3);
      expect(frame.beginEnd).toBe(2);
      expect(frame.updateState(4).state).toBe(frame.POSTWAITING);
      expect(frame.state).toBe(frame.POSTWAITING);
      expect(frame.updateState(4).state).toBe(frame.POSTWAITING);
      expect(frame.state).toBe(frame.POSTWAITING);
      
      appendEnd(1);
      expect(frame.updateState(1).state).toBe(frame.BEGINNING);
      expect(frame.updateState(1).state).toBe(frame.ENDING);
      expect(frame.end).toBe(1);
      expect(frame.beginEnd).toBe(0);
      expect(frame.updateState(1).state).toBe(frame.POSTWAITING);
    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
      expect(frame.updateState()).toBe(frame);
      expect(frame.updateState(null)).toBe(frame);
      
      function appendBegin(num) {
        frame.state = frame.WAITING;
        frame.beginList = {
          value: num,
          next: frame.beginList
        };
      };
      appendBegin(100);
      appendBegin(10000);
      expect(frame.updateState(0).state).toBe(frame.WAITING);
      expect(frame.updateState(99).state).toBe(frame.WAITING);
    });
    describe("the setFrame method (override)", function() {
      var frame = base("$frame").$list.up("$3");
      beforeEach( function() {
          frame.timelines = [];
          frame.isPaused = false;
          frame.state = frame.WAITING;
          frame.begin = 0;
      } );
      afterEach( function() {
          frame.timelines = [];
          frame.beginList = frame.$list.beginList;
          frame.endList = frame.$list.endList;
          frame.currentFrame = 0;
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(typeof frame.setFrame).toBe("function");
        expect(frame.currentFrame).toBe(0);
        
        frame.setFrame(0);
        expect(frame.state).toBe(frame.WAITING);
        expect(frame.currentFrame).toBe(0);
        frame.setFrame(1);
        expect(frame.state).toBe(frame.WAITING);
        expect(frame.currentFrame).toBe(1);
        
        expect(typeof frame.addEvent).toBe("function");
        expect(typeof frame.addBeginList).toBe("function");
        expect(typeof frame.addEndList).toBe("function");
        
        expect(frame.addBeginList(1).value).toBe(1);
        expect(frame.beginList.next.value).toBe(Number.MAX_VALUE);
        expect(frame.addEndList(1).value).toBe(1);
        expect(frame.endList.next.value).toBe(Number.MAX_VALUE);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        function appendBegin(num) {
          frame.state = frame.WAITING;
          frame.addBeginList(num);
        };
        appendBegin(0);
        expect(frame.currentFrame).toBe(0);
        frame.setFrame(0);
        expect(frame.currentFrame).toBe(0);
        expect(frame.state).toBe(frame.PLAYING);
        frame.setFrame(1);
        expect(frame.currentFrame).toBe(1);
        expect(frame.state).toBe(frame.PLAYING);
        
        frame.begin = 0;
        appendBegin(1);
        frame.setFrame(0);
        expect(frame.state).toBe(frame.PLAYING);
        frame.setFrame(1);
        expect(frame.state).toBe(frame.PLAYING);
        frame.setFrame(2);
        expect(frame.state).toBe(frame.PLAYING);
        
        function appendEnd(num) {
          frame.state = frame.WAITING;
          frame.begin = 0;
          frame.addEndList(num);
        };
        
        appendEnd(3);
        frame.setFrame(0);
        expect(frame.state).toBe(frame.PLAYING);
        frame.setFrame(1);
        expect(frame.state).toBe(frame.PLAYING);
        frame.setFrame(2);
        expect(frame.state).toBe(frame.PLAYING);
        frame.setFrame(3);
        expect(frame.state).toBe(frame.POSTWAITING);
        frame.setFrame(4);
        expect(frame.state).toBe(frame.POSTWAITING);
        
        appendBegin(5);
        frame.setFrame(0);
        expect(frame.state).toBe(frame.PLAYING);
        frame.setFrame(1);
        expect(frame.state).toBe(frame.PLAYING);
        frame.setFrame(2);
        expect(frame.state).toBe(frame.PLAYING);
        frame.setFrame(3);
        expect(frame.state).toBe(frame.POSTWAITING);
        frame.setFrame(4);
        expect(frame.state).toBe(frame.POSTWAITING);
        frame.setFrame(5);
        expect(frame.state).toBe(frame.PLAYING);
        frame.setFrame(6);
        expect(frame.state).toBe(frame.PLAYING);
        
        appendEnd(6);
        frame.setFrame(0);
        expect(frame.state).toBe(frame.PLAYING);
        expect(frame.currentFrame).toBe(0);
        frame.setFrame(1);
        expect(frame.state).toBe(frame.PLAYING);
        expect(frame.currentFrame).toBe(1);
        frame.setFrame(2);
        expect(frame.state).toBe(frame.PLAYING);
        expect(frame.currentFrame).toBe(2);
        frame.setFrame(3);
        expect(frame.state).toBe(frame.POSTWAITING);
        frame.setFrame(4);
        expect(frame.state).toBe(frame.POSTWAITING);
        frame.setFrame(5);
        expect(frame.state).toBe(frame.PLAYING);
        frame.setFrame(6);
        expect(frame.state).toBe(frame.POSTWAITING);
        expect(frame.currentFrame).toBe(6);
        
        /*負荷テスト*/
        for (var i=0;i<10000;++i) {
          frame.setFrame(i);
        }
        
        frame.beginList = base("$frame").$listbeginList;
        frame.endList = base("$frame").$list.endList;
        frame.state = frame.WAITING;
        frame.begin = 0;
        var obj = { name: "", value: 0};
        frame.addEvent("begin", function(evt) { obj.name = "a";});
        frame.beginList = {
            value: 0,
            next: frame.beginList
        };
        frame.setFrame(0);
        expect(frame.currentFrame).toBe(0);
        expect(frame.state).toBe(frame.PLAYING);
        expect(obj.name).toBe("a");
        frame.addEvent("play", function(evt) { obj.name = "b";});
        frame.setFrame(1);
        expect(frame.state).toBe(frame.PLAYING);
        expect(obj.name).toBe("b");
        frame.addEvent("end", function(evt) { obj.value = 1;});
        frame.endList = {
            value: 0,
            next: frame.endList
        };
        frame.setFrame(0);
        expect(frame.currentFrame).toBe(0);
        expect(frame.state).toBe(frame.POSTWAITING);
        expect(obj.value).toBe(1);
        var t = 0;
        frame.addEvent("begin", function(evt) {
          expect(evt.state).toBe(frame.BEGINNING);
          t = 1;
        });
        frame.addEvent("end", function(evt) {
          expect(evt.state).toBe(frame.ENDING);
          t = 2;
        });
        frame.addEvent("play", function(evt) {
          expect(evt.state).toBe(frame.PLAYING);
          t = 3;
        });
        frame.state = frame.WAITING;
        frame.setFrame(0);
        expect(frame.state).toBe(frame.POSTWAITING);
        expect(t).toBe(2);
        
        t=0;
        frame.begin = 0;
        frame.state = frame.WAITING;
        expect(frame.getMaxList(12, frame.endList)).toBe(0);
        frame.setFrame(12);
        expect(frame.state).toBe(frame.POSTWAITING);
        expect(t).toBe(2);
        
        /*addBeginListメソッドのチェックなど*/
        expect(frame.addBeginList(1).value).toBe(1);
        expect(frame.addBeginList(0).value).toBe(0);
        expect(frame.beginList.next.value).toBe(1);
        expect(frame.addBeginList(2).value).toBe(2);
        expect(frame.beginList.next.value).toBe(0);
        
        expect(frame.addEndList(1).value).toBe(1);
        expect(frame.addEndList(0).value).toBe(0);
        expect(frame.endList.next.value).toBe(1);
        expect(frame.addEndList(2).value).toBe(2);
        expect(frame.endList.next.value).toBe(0);
      } );
    } );
  } );
  describe("$begin object", function() {
    var begin = base("$frame").$begin.up();
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
      expect(begin.string).toBe("");
      expect(begin.isResolved).toBeFalsy();
      expect(begin.eventTarget).toBe(document.documentElement);
      expect(begin.eventOffset).toBe(0);
      expect(begin.repeat).toBe(0);
      expect(begin.accessKey).toBe("");
    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      begin.string = " hoge ";
      expect(begin.string).toBe(" hoge ");
      var $list = begin.$list;
      expect(begin.$list).toBe($list);
      expect(begin.updateList().$list).not.toBe($list);
    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
    } );
    
    describe("A trim method in $begin object", function() {
      /*境界条件を調べておく (limit value analysis)*/
      beforeEach( function() {
        begin.string = "";
      } );
      it("should be this for the value  (limit value analysis)", function() {
        delete begin.string;
        expect(begin.trim(" ")).toBe("");
        expect( function() {
          begin.trim();
        } ).toThrow();
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        expect(begin.trim(" hoge ")).toBe("hoge");
        expect(begin.trim(" h o g e ")).toBe("hoge");
        expect(begin.trim(" h  o  g     e ")).toBe("hoge");
        expect(begin.trim("   h  o  g    12 +  e   ")).toBe("hog12+e");
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        expect( function() {
          begin.trim(1);
        } ).toThrow();
        expect( function() {
          begin.trim({});
        } ).toThrow();
      } );
    } );

    describe("An offset method in $begin object", function() {
      beforeEach( function() {
        begin.string = "";
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(begin.offset(begin.trim(" "))).toBe(0);
        expect(begin.offset(begin.trim(" 0 "))).toBe(0);
        expect(begin.offset(begin.trim("+0ms"))).toBe(0);
        expect(begin.offset(begin.trim("-0ms"))).toBe(0);
        expect(begin.offset(begin.trim("1ms"))).toBe(1);
        expect(begin.offset(begin.trim("-1ms"))).toBe(-1);

        expect(begin.offset("+0s")).toBe(0);
        expect(begin.offset("-0s")).toBe(0);
        expect(begin.offset("1s")).toBe(1000);
        expect(begin.offset("-1s")).toBe(-1000);

        expect(begin.offset("+0min")).toBe(0);
        expect(begin.offset("-0min")).toBe(0);
        expect(begin.offset("1min")).toBe(60000);
        expect(begin.offset("-1min")).toBe(-60000);

        expect(begin.offset("+0h")).toBe(0);
        expect(begin.offset("-0h")).toBe(0);
        expect(begin.offset("1h")).toBe(60*60*1000);
        expect(begin.offset("-1h")).toBe(-3600000);

        expect(begin.offset("00:0")).toBe(0);
        expect(begin.offset("00:00:0.0")).toBe(0);
        expect(begin.offset("-00:0")).toBe(0);
        expect(begin.offset("-00:00:0.0")).toBe(0);
        expect(begin.offset("00:1")).toBe(1000);
        expect(begin.offset("-00:1")).toBe(-1000);
        expect(begin.offset("00:00:1")).toBe(1000);
        expect(begin.offset("-00:00:1")).toBe(-1000);

        expect(begin.offset()).toBe(0);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        expect(begin.offset(begin.trim(" + 0 ms"))).toBe(0);
        expect(begin.offset(begin.trim(" -1m s "))).toBe(-1);
        expect(begin.offset(begin.trim("1000ms"))).toBe(1000);
        expect(begin.offset(begin.trim(" -1212ms"))).toBe(-1212);

        expect(begin.offset("+100s")).toBe(100 * 1000);
        expect(begin.offset("-121s")).toBe(-121 * 1000);
        expect(begin.offset("1.25s")).toBe(1.25 * 1000);
        expect(begin.offset("-0.20s")).toBe(-0.20 * 1000);
        expect(begin.offset(".20s")).toBe(0.20 * 1000);

        expect(begin.offset("+100min")).toBe(100 * 60000);
        expect(begin.offset("-121min")).toBe(-121 * 60000);
        expect(begin.offset("1.25min")).toBe(1.25 * 60000);
        expect(begin.offset("-0.20min")).toBe(-0.20 * 60000);
        expect(begin.offset(".20min")).toBe(0.20 * 60000);

        expect(begin.offset("+100h")).toBe(100 * 3600000);
        expect(begin.offset("-121h")).toBe(-121 * 3600000);
        expect(begin.offset("1.25h")).toBe(1.25 * 3600000);
        expect(begin.offset("-0.20h")).toBe(-0.20 * 3600000);
        expect(begin.offset(".20h")).toBe(0.20 * 3600000);

        expect(begin.offset("01:0")).toBe(60000);
        expect(begin.offset("-01:0")).toBe(-60000);
        expect(begin.offset("00:00:1")).toBe(1000);
        expect(begin.offset("-00:00:1")).toBe(-1000);
        expect(begin.offset("00:01:0")).toBe(60000);
        expect(begin.offset("-00:01:0")).toBe(-60000);
        expect(begin.offset("01:00:0")).toBe(3600000);
        expect(begin.offset("-01:00:0")).toBe(-3600000);
        expect(begin.offset("00:10")).toBe(10000);
        expect(begin.offset("00:0.01")).toBe(10);
        expect(begin.offset("01:0.01")).toBe(60010);
        expect(begin.offset("10:0")).toBe(600000);
        expect(begin.offset("-00:10")).toBe(-10000);
        expect(begin.offset("-00:0.01")).toBe(-10);
        expect(begin.offset("-01:0.01")).toBe(-60010);
        expect(begin.offset("-10:0")).toBe(-600000);
        expect(begin.offset("00:00:20")).toBe(20000);
        expect(begin.offset("00:11:20")).toBe(11*60*1000 + 20000);
        expect(begin.offset("12:11:20")).toBe(12*60*60*1000 + 11*60*1000 + 20000);
        expect(begin.offset("-10:0")).toBe(-600000);
        expect(begin.offset("-01:01:0.1")).toBe(-1*60*60*1000 - 60000 - 100);
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        expect(begin.offset(begin.trim(" h  o  g     1e "))).toBe(0);
        expect(begin.offset("ms")).toBe(0);
        expect(begin.offset(".s")).toBe(0);
        expect(begin.offset("10:")).toBe(0);
        expect(begin.offset("::")).toBe(0);
        expect(begin.offset("-:0")).toBe(0);
        expect(begin.offset("-::0")).toBe(0);
      } );
    } );
    describe("An event method in $begin object", function() {
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        var evt = begin.event();
        expect(evt.id).toBe("");
        expect(evt.event).toBe("");
        evt = begin.event("");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("");
        evt = begin.event(".");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("");

        evt = begin.event("a");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("a");
        evt = begin.event("a.b");
        expect(evt.id).toBe("a");
        expect(evt.event).toBe("b");
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        var evt = begin.event("id.event");
        expect(evt.id).toBe("id");
        expect(evt.event).toBe("event");
        evt = begin.event("event");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("event");
        
        evt = begin.event("event+0s");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("event");
        evt = begin.event("event-0s");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("event");
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        evt = begin.event("...");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("");
        evt = begin.event(".event");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("");
        evt = begin.event("id.");
        expect(evt.id).toBe("");
        expect(evt.event).toBe("");
      } );
    } );
    
    describe("An parse method in $begin object", function() {
       beforeEach( function() {
        begin.string = "";
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(begin.parse().begin).toBe(0);
        expect(begin.isResolved).toBeTruthy();
        begin.string="+0";
        expect(begin.parse().begin).toBe(0);
        begin.string = "+1";
        expect(begin.parse().begin).toBe(1000*begin.fpms);
        begin.string = " ";
        expect(begin.parse().begin).toBe(0);
        begin.string = "1";
        expect(begin.parse().begin).toBe(1000*begin.fpms);
        begin.string = "+0ms";
        expect(begin.parse().begin).toBe(0);
        begin.string = "-0ms";
        expect(begin.parse().begin).toBe(0);
        begin.string = "-0ms;-0ms";
        expect(begin.parse().begin).toBe(0);
        begin.string = "-0ms;1";
        expect(begin.parse().begin).toBe(1000*begin.fpms);
        
        expect(begin.eventOffset).toBe(0);
        begin.string = "click";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        expect(begin.repeat).toBe(0);
        expect(begin.accessKey).toBe("");
        begin.string = "id.click";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        expect(begin.repeat).toBe(0);
        expect(begin.accessKey).toBe("");
        
        begin.string = "repeat";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        expect(begin.repeat).toBe(0);
        expect(begin.accessKey).toBe("");
        begin.string = "repeat(1)";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        expect(begin.repeat).toBe(1);
        expect(begin.accessKey).toBe("");
        
        begin.string = "accessKey(a)";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        expect(begin.repeat).toBe(0);
        expect(begin.accessKey).toBe("a");
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        begin.string = " 1 0 0 m s";
        expect(begin.parse().begin).toBe(Math.floor(100*begin.fpms));

        begin.string = "1ms";
        begin.isResolved = false;
        expect(begin.parse().begin).toBe(Math.floor(1*begin.fpms));
        expect(begin.isResolved).toBeTruthy();
        expect(begin.eventOffset).toBe(0);

        begin.string="click+0";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        expect(begin.isResolved).toBeFalsy();
        begin.string = "click+1";
        expect(begin.parse().begin).toBe(1000*begin.fpms);
        expect(begin.eventOffset).toBe(1000*begin.fpms);
        begin.string = " click ";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        begin.string = "click+0ms";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        expect(begin.isResolved).toBeFalsy();
        begin.string = "click-0ms";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        begin.string = "click+100ms";
        expect(begin.parse().begin).toBe(Math.floor(100*begin.fpms));
        expect(begin.eventOffset).toBe(Math.floor(100*begin.fpms));
        begin.string = "click-100ms";
        expect(begin.parse().begin).toBe(Math.floor(-100*begin.fpms));
        expect(begin.eventOffset).toBe(Math.floor(-100*begin.fpms));

        begin.string="id.click+0";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        expect(begin.isResolved).toBeFalsy();
        begin.string = "id.click+1";
        expect(begin.parse().begin).toBe(1000*begin.fpms);
        expect(begin.eventOffset).toBe(1000*begin.fpms);
        expect(begin.isResolved).toBeFalsy();
        begin.string = " id . click ";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        expect(begin.isResolved).toBeFalsy();
        begin.string = "id.click+0ms";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        begin.string = "id.click-0ms";
        expect(begin.parse().begin).toBe(0);
        expect(begin.eventOffset).toBe(0);
        begin.string = "id.click+100ms";
        expect(begin.parse().begin).toBe(Math.floor(100*begin.fpms));
        expect(begin.eventOffset).toBe(Math.floor(100*begin.fpms));
        begin.string = "id.click-100ms";
        expect(begin.parse().begin).toBe(Math.floor(-100*begin.fpms));
        expect(begin.eventOffset).toBe(Math.floor(-100*begin.fpms));
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        begin.string = "ms";
        begin.isResolved = false;
        expect(begin.parse().begin).toBe(0);
        expect(begin.isResolved).toBeFalsy();
        
        begin.isResolved = true;
        begin.string = "indefinite";
        expect(begin.parse().begin).toBe(Math.floor( Number.MAX_VALUE * begin.fpms));
        expect(begin.isResolved).toBeFalsy();
      } );
    } );
  } );
  describe("A $end object", function() {
    var end = base("$frame").$begin.$end.up();
    end.startTime = 0;
    beforeEach( function() {
      end.string = "";
      end.startTime = Date.now();
      end.setFrame(0);
    } );
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
      expect(end.up().call()).toBeNull();
      end.string = "0";
      expect(end.up().call()).toBe(0);
      end.string = "hoge";
      expect(end.up().call()).toBe("indefinite");
      
    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      end.string = "hoge+0";
      expect(end.up().call()).toBe("indefinite");
      end.string = "12ms";
      expect(end.up().call()).toBe(Math.floor(12*end.fpms));
      end.string = "hoge+12ms";
      expect(end.up().call()).toBe("indefinite");

    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
      end.string = null;
      expect(end.up().call()).toBeNull();
    } );
  } );
  describe("A $activate object", function() {
    var act = base("$frame").$begin.$activate.up();
     beforeEach( function() {
      act.dur = "indefinite";
      act.begin = 0;
      act.repeatCount = null;
      act.repeatDur = null;
      act.end = act.$begin.$end;
      act.simpleDur = base("$frame").$begin.$activate.simpleDur;
    } );
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
      expect(act.dur).toBe("indefinite");
      expect(typeof act.resolvedTime).toBe("function");
      expect(act.end).toBe(act.$begin.$end);
      expect(act.repeatCount).toBeNull();
      expect(act.repeatDur).toBeNull();
      expect(act.simpleDur()).toBeNull();
      expect(act.min).toBe("0");
      expect(act.max).toBe("indefinite");

      act.up("$a");
      expect(act.$a.call()).toBeNull();
      expect(act.$a.end).toBeNull();
    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      expect(act.resolvedTime()).not.toBe(0);

      /*Activate Duration = dur*/
      act.up("$b");
      act.$b.dur = "132ms";
      var abc = act.$b.call();
      expect(abc).toBe(Math.floor(132*act.fpms));
      expect(abc).toBe(act.$b.simpleDur);
      act.dur = null;
      expect(act.up().call()).toBeNull();

      act.up("$c");
      act.$c.mix( {
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: null,
        repeatDur: null
      } );
      expect(act.$c.call()).toBe(Math.floor(10000*act.fpms));
      expect(act.$c.call()).toBe(act.$c.simpleDur);
      act.$c.mix( {
        dur: "15",
        simpleDur: act.simpleDur,
        repeatCount: null,
        repeatDur: null
      } );
      expect(act.$c.call()).toBe(Math.floor(15000*act.fpms));

      /*AD = repeatCount*dur*/
      act.$c.mix( {
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: 2,
        repeatDur: null
      } );
      act.$c.call();
      expect(act.$c.simpleDur).toBe(Math.floor(10000*act.fpms));
      act.$c.mix( {
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: 1,
        repeatDur: null
      } );
      expect(act.$c.call()).toBe(Math.floor(10000*act.fpms));
      expect(act.$c.simpleDur).toBe(Math.floor(10000*act.fpms));

      /*AD = repeatDur*/
      act.$c.mix( {
        dur: "indefinite",
        simpleDur: act.simpleDur,
        repeatCount: 2,
        repeatDur: "15"
      } );
      act.$c.call();
      expect(act.$c.simpleDur).toBeNull();
      act.$c.mix( {
        dur: "indefinite",
        simpleDur: act.simpleDur,
        repeatCount: 2,
        repeatDur: "10"
      } );
      expect(act.$c.call()).toBe(Math.floor(10000*act.fpms));
      expect(act.$c.simpleDur).toBeNull();
      act.$c.mix( {
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: null,
        repeatDur: "15"
      } );
      act.$c.call();
      expect(act.$c.simpleDur).toBe(Math.floor(10000*act.fpms));
      act.$c.mix( {
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: null,
        repeatDur: "11"
      } );
      expect(act.$c.call()).toBe(Math.floor(11000*act.fpms));
      expect(act.$c.simpleDur).toBe(Math.floor(10000*act.fpms));
      
      /*AD = Min(repeatCount*d, repeatDur)*/
      act.$c.mix( {
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: 2,
        repeatDur: "15"
      } );
      act.$c.call();
      expect(act.$c.simpleDur).toBe(Math.floor(10000*act.fpms));
      act.$c.mix( {
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: 1,
        repeatDur: "15"
      } );
      expect(act.$c.call()).toBe(Math.floor(10000*act.fpms));
      expect(act.$c.simpleDur).toBe(Math.floor(10000*act.fpms));
      act.$c.mix( {
        dur: "11",
        simpleDur: act.simpleDur,
        repeatCount: 1,
        repeatDur: "9"
      } );
      expect(act.$c.call()).toBe(Math.floor(9000*act.fpms));
      expect(act.$c.simpleDur).toBe(Math.floor(11000*act.fpms));

      /*AD = repeatDur,*/
      act.$c.mix( {
        end: null,
        dur: "10",
        simpleDur: act.simpleDur,
        repeatCount: null,
        repeatDur: "15"
      } );
      expect(act.$c.call()).toBe(Math.floor(15000*act.fpms));
      expect(act.$c.simpleDur).toBe(Math.floor(10000*act.fpms));
      act.$c.mix( {
        dur: "indefinite",
        simpleDur: act.simpleDur,
        repeatCount: 2,
        repeatDur: "10"
      } );
      expect(act.$c.call()).toBe(Math.floor(10000*act.fpms));
      expect(act.$c.simpleDur).toBeNull();

      act.end.string = null;
      act.up("$cd").mix( {
        dur: "10",
        end: act.end,
        repeatCount: 2
      } );
      expect(act.$cd.call()).toBe(Math.floor(10000*act.fpms) * 2);
      
      act.$cd.end = act.end;
      act.$cd.repeatCount = null;
      act.$cd.repeatDur = "12";
      expect(act.$cd.call()).toBe(Math.floor(12000*act.fpms));
      
      act.up("$d").mix( {
        min: "2",
        max: "3",
        dur: "1",
        simpleDur: act.simpleDur
      } );
      expect(act.$d.call()).toBe(Math.floor(2000*act.fpms));
      act.up("$d").mix( {
        min: "1",
        max: "2",
        dur: "12",
        simpleDur: act.simpleDur
      } );
      expect(act.$d.call()).toBe(Math.floor(2000*act.fpms));
      
      /*endで0が指定されている場合*/
      act.begin = 0;
      act.end = 0;
      act.repeatDur = null;
      act.repeatCount = "indefinite";
      act.dur = "1";
      expect(act.call()).toBeNull();
      act.repeatCount = null;
      act.repeatDur = "indefinite";
      act.dur = "1";
      expect(act.call()).toBeNull();
      act.repeatDur = "indefinite";
      act.repeatCount = "indefinite";
      act.dur = "1";
      expect(act.call()).toBeNull();
    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
      /*min > max*/
      act.up("$d").mix( {
        min: "3",
        max: "2",
        dur: "1",
        simpleDur: act.simpleDur
      } );
      expect(act.$d.call()).toBe(Math.floor(1000*act.fpms));
      
      act.repeatDur = null;
      act.repeatCount = "indefinite";
      act.dur = "1";
      expect(act.call()).toBeNull();
      act.repeatCount = null;
      act.repeatDur = "indefinite";
      act.dur = "1";
      expect(act.call()).toBeNull();
      act.repeatDur = "indefinite";
      act.repeatCount = "indefinite";
      act.dur = "1";
      expect(act.call()).toBeNull();
    } );
  } );
  describe("A $from object", function() {
    var from = base("$from");
     beforeEach( function() {
       from = base("$from").up();
       from.from = from.from.up();
       from.string = "";
     } );
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
      expect(from.string).toBe("");
      expect(from.numList()).toEqual([]);
      expect(from.strList()).toBeNull();

      from.string = "0";
      expect(from.numList()[0]).toBe(0);
      expect(from.strList()).toBeNull();
      
      from.string = " 0 ";
      expect(from.numList()[0]).toBe(0);
      expect(from.strList().join("")).toBe("  ");

      from.string = "a";
      expect(from.numList()).toEqual([]);
      expect(from.strList()[0]).toBe("a");
      
      /*前後の空白を除去する処理をしない。なぜなら、文字列リストの空白は保持するのが望ましいから
       * 文字列リストの空白を除去した例: "M 20 20 M M" -> "M20 20 MM"となってしまう*/
      
      from.string = null;
      expect( function() {
        from.numList();
      } ).toThrow();
      expect( function() {
        from.strList();
      } ).toThrow();
      
      expect(from.additive[0]).toBe(0);
      expect(from.accumulate[0]).toBe(0);
    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      from.string = "0a";
      expect(from.numList()[0]).toBe(0);
      expect(from.strList()[0]).toBe("a");

      from.string = "a0";
      expect(from.numList()[0]).toBe(0);
      expect(from.strList()[0]).toBe("a");

      from.string = "0.1";
      expect(from.numList()[0]).toBe(0.1);
      expect(from.strList()).toBeNull();

      from.string = "+0.1";
      expect(from.numList()[0]).toBe(0.1);
      expect(from.strList()).toBeNull();

      from.string = "-0.1";
      expect(from.numList()[0]).toBe(-0.1);
      expect(from.strList()).toBeNull();

      from.string = "1e-1";
      expect(from.numList()[0]).toBe(1e-1);
      expect(from.strList()).toBeNull();

      from.string = "1E-1";
      expect(from.numList()[0]).toBe(1E-1);
      expect(from.strList()).toBeNull();

      from.string = "0,0";
      expect(from.numList().toString()).toBe("0,0");
      expect(from.strList().join("")).toBe(",");

      from.string = "a00a";
      expect(from.numList()[0]).toBe(0);
      expect(from.strList().join("")).toBe("aa");

      from.string = "a0b0a";
      expect(from.numList().toString()).toBe("0,0");
      expect(from.strList().join("")).toBe("aba");

      from.string = "0b0a";
      expect(from.numList().toString()).toBe("0,0");
      expect(from.strList().join("")).toBe("ba");

      from.string = "0b-1.0a";
      expect(from.numList()[1]).toBe(-1);
      expect(from.strList().join("")).toBe("ba");

      expect(from.up().call()).toBe(from.$1.numList);
      expect(from.$1.numList[1]).toBe(-1);
      expect(from.$1.strList.join("")).toBe("ba");

      from.string = "あ　0b-1.0a１２";
      expect(from.numList()[1]).toBe(-1);
      expect(from.strList().join("")).toBe("あ　ba１２");

      from.string = "0b-1.0a0";
      expect(from.numList().join(",")).toBe("0,-1,0");
      expect(from.strList().join("")).toBe("ba");

      from.string = "0b .1a";
      expect(from.numList()[1]).toBe(0.1);
      expect(from.strList().join("")).toBe("b a");
    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
      from.string = NaN;
      expect(function(){
        from.numList();
      } ).toThrow();
      expect(function(){
        from.strList();
      } ).toThrow();      
      
      from.string = "currentColor";
      expect(from.numList()).toEqual([]);
      expect(from.strList()[0]).toBe("currentColor");

      from.string = "eE";
      expect(from.numList()).toEqual([]);
      expect(from.strList()[0]).toBe("eE");
      expect(from.strList()[0]).toBe("eE");
    } )
  } );
  describe("A $to object", function() {
    var from = base("$from");
     beforeEach( function() {
       from = base("$from").up();
       from.up("$to");
       from.string = "";
     } );
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
      expect(from.$to instanceof from.constructor).toBeTruthy();
      expect(from.up().call()).toBe(from.$1.numList);
      expect(from.$to.up().call()).toBe(from.$to.$1.numList);
    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      from.up("$to");
      from.$to.from = from;
      from.$to.string = "12cm-7";
      expect(from.$to.numList().join(",")).toBe("12,-7");
      expect(from.$to.strList().toString()).toBe("cm");
      
      from.string = "7cm+8";
      from.$to.call();
      expect(from.call()).toBe(from.numList);
      expect(from.$to.numList.join(",")).toBe("12,-7");
      expect(from.$to.strList.join("")).toBe("cm");
      expect(from.numList.join(",")).toBe("7,8");
      expect(from.strList.join("")).toBe("cm");
      expect(from.$to.from).toBe(from.numList);

    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
      from.call();
      from.up("$to").mix( function() {
        this.string = "12cm";
        this.call();
        var arr = [];
        arr.string = this.string;
        expect(this.numList).toEqual(arr);
        expect(this.strList).toBeNull();
      } );
    } );
    
    describe("An advance method", function() {
      var from = base("$from");
       beforeEach( function() {
         from = base("$from").up();
         from.string = "";
         from.up("$to");
         from.$to.from = from;
       } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(from.advance()).toBe("");
        expect(from.$to.advance()).toBe("");
        expect(from.$to.advance(0)).toBe("");
        expect(from.$to.advance(1)).toBe("");
        expect(function(){
          from.$to.advance(1.01);
        }).toThrow("An Invalid Number Error");
        expect(function(){
          from.$to.advance(-0.01);
        }).toThrow("An Invalid Number Error");
        
        var arr = [];
        
        from = base("$from").up();
        from.up("$to");
        from.$to.from = from;
        arr.string = from.string = "0";
        from.$to.string = "1";
        expect(from.$to.call()).toBe(from.$to.numList);
        expect(from.$to.numList[0]).toBe(1);
        expect(from.$to.strList).toBeNull();
        expect(from.numList[0]).toBe(0);
        expect(from.strList).toBeNull();
        expect(from.advance(0)).toBe("");
        expect(from.$to.from).toBe(from.numList);
        expect(from.$to.advance(0)).toBe("0");       
        expect(from.call()).toBe(from.numList);
        
        from = base("$from").up();
        f(from.up(), "inline", "block");
        f(from.up(), " inline", " block ");
        function f(from, inline, block) {
          from.up("$to");
          from.$to.from = from;
          from.string = inline;
          arr.string = from.$to.string = block;
          expect(from.$to.call()).toBe(from.$to.numList);
          expect(from.$to.numList).toEqual(arr);
          expect(from.$to.strList).toEqual([block]);
          arr.string = from.string;
          expect(from.numList).toEqual(arr);
          expect(from.strList).toEqual([inline]);
          expect(from.advance(0)).toBe("");
          expect(from.$to.from).toBe(from.numList);
          expect(from.$to.advance(0)).toBe("inline");
          expect(from.$to.advance(1)).toBe("block");
          expect(from.call()).toBe(from.numList);
        }
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        var deg = 3;
        
        from.string = "0s";
        from.$to.string = "1s";
        expect(from.$to.call()).toBe(from.$to.numList);
        expect(from.$to.numList[0]).toBe(1);
        expect(from.$to.strList[0]).toBe("");
        expect(from.numList[0]).toBe(0);
        expect(from.strList[0]).toBe("");
        expect(from.advance(0)).toBe("");
        expect(from.$to.from).toBe(from.numList);
        expect(from.$to.advance(0)).toBe("0s");
        from.$to.degit = deg;
        for (var i=0;i<1;i+=0.01) {
          expect(from.$to.advance(i)).toBe(i.toFixed(deg)+"s");
        }
        expect(from.call()).toBe(from.numList);
        
        from = base("$from").up();
        from.up("$to");
        from.string = "a0S";
        from.$to.string = "a1S";
        from.$to.from = from;
        expect(from.$to.call()).toBe(from.$to.numList);
        expect(from.$to.numList[0]).toBe(1);
        expect(from.$to.strList[0]).toBe("a");
        expect(from.numList[0]).toBe(0);
        expect(from.strList[0]).toBe("a");
        expect(from.advance(0)).toBe("");
        expect(from.$to.from).toBe(from.numList);
        expect(from.$to.advance(0)).toBe("a0S");

        from.$to.degit = deg;
        for (var i=0;i<1;i+=0.01) {
          expect(from.$to.advance(i)).toBe("a" +i.toFixed(deg)+ "S");
        }
        expect(from.call()).toBe(from.numList);
        
        from = base("$from").up();
        f(from.up(), "a-10s1.5", "a10s-3");
        f(from.up(), " a-10s1.5", " a10s-3 ");
        function f(from, fromString, toString) {
          from.up("$to");
          from.string = fromString;
          from.$to.string = toString;
          from.$to.from = from;
          from.$to.call();
          from.$to.degit = 1;
          expect(from.$to.advance(0)).toBe("a-10.0s1.5");
          expect(from.$to.advance(0.4)).toBe("a-2.0s-0.3");
          expect(from.$to.advance(1)).toBe("a10.0s-3.0");

          from.$to.additive[0] = 1;
          from.$to.accumulate[1] = 2;
          expect(from.$to.advance(0.4)).toBe("a-1.0s1.7");
          from.$to.additive[0] = 0.5;
          from.$to.accumulate[1] = 0.8;
          expect(from.$to.advance(1)).toBe("a10.5s-2.2");
        }
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        expect(function(){
          from.$to.advance(10);
        }).toThrow("An Invalid Number Error");
        expect(function(){
          from.$to.advance(-10);
        }).toThrow("An Invalid Number Error");
      } );
    } )
  } );
  describe("A distance method", function() {
      var from = base("$from");
       beforeEach( function() {
         from = base("$from").up();
         from.string = "";
         from.up("$to");
       } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(from.distance()).toBe(0)
        expect(from.$to.distance()).toBe(0);
        
        from.string = "0";
        from.$to.string = "1";
        expect(from.distance()).toBe(0);
        expect(from.$to.distance(from)).toBe(1);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        from.string = "s 0 s 12";
        from.$to.string = "s 0 s 0";
        expect(from.distance()).toBe(0);
        expect(from.$to.distance(from)).toBe(12);
        expect(from.$to.distance(from)).toBe(12);
        expect(from.$to.distance(from.call())).toBe(12);
  
        from = base("$from").up();
        from.up("$to");
        from.string = "rgb(1, 0, 0)";
        from.$to.string = "rgb(0, 0, 1)";
        expect(from.distance()).toBe(0);
        expect(from.$to.distance(from)).toBe(Math.sqrt(2));
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        from.string = "s";
        from.$to.string = "s";
        expect(from.$to.distance(from)).toBe(0);
      } );
  } );
  describe("A setAdditive method", function() {
      var from = base("$from");
       beforeEach( function() {
         from = base("$from").up();
         from.string = "";
         from.up("$to");
       } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(from.setAdditive()).toBe(0);
        expect(from.setAdditive("")).toBe(0);
        expect(from.additive).toEqual([0]);
        var arr = [1];
        arr.string = "1";
        expect(from.setAdditive("1")).toEqual(arr);
        expect(from.additive).toEqual(arr);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        var arr = [1, 2, 3];
        arr.string = "1 2, 3";
        expect(from.setAdditive("1 2, 3")).toEqual(arr);
        expect(from.additive).toEqual(arr);
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
      } );
  } );
  describe("A setAccumulate method", function() {
      var from = base("$from");
       beforeEach( function() {
         from = base("$from").up();
         from.string = "0 1";
         from.up("$to");
         from.call();
       } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(from.setAccumulate()).toBe(0);
        expect(from.setAccumulate(0)).toBe(0);
        expect(from.accumulate).toEqual([0, 0]);
        expect(from.setAccumulate(1)).toEqual([0, 1]);
        expect(from.accumulate).toEqual([0, 1]);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        expect(from.setAccumulate(2)).toEqual([0, 2]);
        expect(from.accumulate).toEqual([0, 2]);
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {
        expect(from.setAccumulate(NaN)).toEqual(0);
      } );
  } );
  describe("A $calcMode object", function() {
    var calc = base("$calcMode"),
        to = calc.to,
        from;
     beforeEach( function() {
       calc = base("$calcMode").up();
       calc.to = base("$from").up().mix( {string: "1"} );
       from = calc.to.from = base("$from").up().mix( {string: "0"} );
     } );
    /*境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (limit value analysis)", function() {
      expect(calc.mode).toBe("linear");
      expect(calc.keyTime).toBe(1);
      expect(calc.keySplines).toBeNull();
      expect(calc.string).toBe("");

      expect(calc.call()(0)).toBe("0");
      expect(calc.keyTime).toBe(1);
      expect(calc.call()(1)).toBe("1");
      
      calc.keyTime = 0;
      expect(calc.call()(1)).toBe("0");
      
      /*paced mode*/
      calc.mode = "paced";
      expect(calc.norm).toBe(1);
      calc.to.from = from;
      expect(calc.call()(0)).toBe("0");
      expect(calc.keyTime).toBe(1);
      calc.to.from = from;
      expect(calc.call()(1)).toBe("1");
      
      calc.keyTime = 0;
      calc.to.from = from;
      expect(calc.call()(1)).toBe("1");
      
      /*discrete mode*/
      calc.mode = "discrete";
      calc.to.from = from;
      calc.keyTime = 1;
      expect(calc.call()(0)).toBe("0");
      expect(calc.call()(1)).toBe("1");
    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion)", function() {
      calc.mode = "linear";
      calc.keyTime = 0.5;
      calc.to.degit = 1;
      expect(calc.call()(0.2)).toBe("0.4");
      expect(calc.call()(0.3)).toBe("0.6");
      /*もう一度確かめる*/
      expect(calc.call()(0.2)).toBe("0.4");
      
      calc = base("$calcMode").up();
      calc.keyTime = 0.2;
      calc.to = base("$from").up();
      calc.to.from = base("$from").up();    
      calc.to.from.string = "0s";
      calc.to.string = "1s";
      calc.to.degit = 1;
      expect(calc.call()(0.1)).toBe("0.5s");

      calc = base("$calcMode").up();
      calc.keyTime = 0.5;
      calc.to = base("$from").up();
      calc.to.from = base("$from").up();    
      calc.to.from.string = "rgb(100, 20, 32)";
      calc.to.string = "rgb(0, 10, 50)";
      expect(calc.call()(0.25)).toBe("rgb(50, 15, 41)");
      
      /*paced mode*/
      calc.to = base("$from").up();
      calc.to.from = base("$from").up();    
      calc.mode = "paced";
      calc.norm = 100;
      calc.to.from.string = "0s";
      calc.to.string = "20s";
      calc.to.degit = 1;
      expect(calc.call()(0.1)).toBe("10.0s");
      expect(calc.keyTime).toBe(0.2);

      calc.to = base("$from").up();
      calc.to.from = base("$from").up();    
      calc.mode = "paced";
      calc.norm = 100;
      calc.to.from.string = "rgb(0, 0, 20)";
      calc.to.string = "rgb(0, 0, 0)";
      expect(calc.call()(0.1)).toBe("rgb(0, 0, 10)");
      expect(calc.keyTime).toBe(0.2);
      
      /*discrete mode*/
      calc.to = base("$from").up();
      calc.to.from = base("$from").up();    
      calc.mode = "discrete";
      calc.keyTime = 0.5;
      calc.to.degit = 1;
      calc.to.string = "1";
      calc.to.from.string = "0.5";
      expect(calc.call()(0.2)).toBe("0.5");
      expect(calc.call()(0.3)).toBe("0.5");
      /*もう一度確かめる*/
      expect(calc.call()(0.2)).toBe("0.5");
      
      calc.to = base("$from").up();
      calc.to.from = base("$from").up();    
      calc.mode = "discrete";
      calc.keyTime = 0.5;
      calc.to.degit = 1;
      calc.to.string = "block";
      calc.to.from.string = "inline";
      expect(calc.call()(0.2)).toBe("inline");
      expect(calc.call()(0.3)).toBe("inline");
      
      calc.to = base("$from").up();
      calc.to.from = base("$from").up();    
      calc.mode = "linear";
      calc.keyTime = 1;
      calc.to.degit = 1;
      calc.to.string = "1 1";
      calc.to.from.string = "0.0 1";
      expect(calc.call()(0.2)).toBe("0.2 1.0");
      expect(calc.call()(0.3)).toBe("0.3 1.0");
    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion)", function() {
      calc.keyTime = null;
      expect(calc.call()(1)).toBe(calc.string);
      
      calc.keyTime = void 0;
      expect(calc.call()(1)).toBe(calc.string);
      
      calc.keyTime = 1/0;
      expect(calc.call()(1)).toBe(calc.string);

      expect(calc.call()()).toBe(calc.string);

      calc = base("$calcMode").up();
      calc.mode = "paced";
      calc.to.from = from;
      expect(calc.call()()).toBe(calc.string);
      
      calc = base("$calcMode").up();
      calc.mode = "discrete";
      expect(calc.call()()).toBe(calc.string);
    } );
    
    /*splineモードの境界条件を調べておく (limit value analysis)*/
    it("should be this for the value  (spline mode limit value analysis)", function() {
      /*3次ベジェ曲線の数式はこのページを参考にした　http://opentype.jp/fontguide_doc3.htm*/
      var x = 0,
          y = 0,
          bezier = function (x1, y1, x2, y2, x3, y3, x4, y4) {
            return function (t) {
              x = (x4-3*(x3-x2)-x1)*t*t*t + 3*(x3-2*x2+x1)*t*t + 3*(x2-x1)*t + x1;
              y = (y4-3*(y3-y2)-y1)*t*t*t + 3*(y3-2*y2+y1)*t*t + 3*(y2-y1)*t + y1;
              return y;
            };
          };
      expect(calc.keySplines).toBeNull();
      calc.mode = "spline";
      expect( calc.call()("undef")).toBe(Math.PI);
      calc.keySplines = [0, 0, 1, 1];
      calc.to.degit = 1;
      calc.to.from = from;
      expect(calc.call()(0)).toBe(bezier(0,0, 0,0, 1,1, 1,1)(0)+".0");
      calc.to.from = from;
      expect(calc.call()(1)).toBe(bezier(0,0, 0,0, 1,1, 1,1)(1)+".0");
      calc.to.from = from;
      expect(calc.call()(0.5)).toBe(bezier(0,0, 0,0, 1,1, 1,1)(0.5)+"");
      
      df(0,0, 0,0, 1,1, 1,1, 0.1);
      df(0,0, 0,0, 1,1, 1,1, 0.5);
      df(0,0, 0,0, 1,1, 1,1, 0.8);
      df(0,0, 0,0, 1,1, 1,1, 0.9);
      df(0,0, 0.75,0, 0,0.75, 1,1, 0.1);
      df(0,0, 0.75,0, 0,0.75, 1,1, 0.5);
      df(0,0, 0.75,0, 0,0.75, 1,1, 0.8);
      df(0,0, 0.75,0, 0,0.75, 1,1, 0.9);
      function df (x1, y1, x2, y2, x3, y3, x4, y4, t) {
      /*自作のニュートン法*/
        var a = y4-3*(y3-y2)-y1,
            b = 3*(y3-2*y2+y1),
            c = 3*(y2-y1),
            d = y1 - bezier.apply(null, arguments)(t);
        expect(Math.abs(Math.qubicnewton(a, b, c, d, t) - t)).toBeLessThan(1e-5);
      };
    } );
    /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
    it("should be this for the value (the valid partion on a spline mode )", function() {
      var x = 0,
          y = 0,
          bezier = function (x1, y1, x2, y2, x3, y3, x4, y4) {
            return function (t) {
              return {
                  x: (x4-3*(x3-x2)-x1)*t*t*t + 3*(x3-2*x2+x1)*t*t + 3*(x2-x1)*t + x1,
                  y: (y4-3*(y3-y2)-y1)*t*t*t + 3*(y3-2*y2+y1)*t*t + 3*(y2-y1)*t + y1
                };
            };
          };
      calc.mode = "spline";
      calc.keySplines = [0, 0.5, 0.5, 1];
      calc.to.degit = 1;
      var b = bezier(0,0, 0,0.5, 0.5,1, 1,1);
      expect(calc.call()(0)).toBe(b(0).y+".0");
      calc.to.from = from;
      expect(calc.call()(1)).toBe(b(1).y+".0");
      calc.to.from = from;
      expect(calc.call()( b(0.5).x )).toBe(b(0.5).y.toFixed(1));
      
      var ff = function(k) {
        calc.keySplines = k;
        calc.to.degit = 10;
        var b = bezier(0,0, k[0],k[1], k[2],k[3], 1,1),
            epsilon = 1e-5; //誤差
        expect(calc.call()(0)).toBe(b(0).y.toFixed(10));
        calc.to.from = from;
        expect(calc.call()(1)).toBe(b(1).y.toFixed(10));
        calc.to.from = from;
        b = b(Math.random());
        expect(Math.abs(calc.call()(b.x) - b.y.toFixed(10))).toBeLessThan(epsilon);
      };
      for (var i=0;i<10000;++i) {
        var rand = [Math.random(), Math.random(), Math.random(), Math.random()].sort(function(a,b){return a-b;});
        ff(rand);
      }
    } );
    /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
    it("should be this for the value (the invalid partion on a spline mode )", function() {
      calc.mode = "spline";
      calc.keySplines = [0, NaN, 1, 1];
      calc.to.degit = 1;
      calc.to.from = from;
      expect( calc.up().call()("undef")).toBe(Math.PI);

      
      calc.keySplines = [0, 0, 1, 2];
      calc.to.degit = 1;
      calc.to.from = from;
      expect( calc.up().call()("undef")).toBe(Math.PI);
      
      calc.keySplines = null;
      calc.to.degit = 1;
      calc.to.from = from;
      expect( calc.up().call()("undef")).toBe(Math.PI);
    } );
  } );
  describe("A $attribute object", function() {
    describe("A push method", function() {
      var attr, s;
      beforeEach( function() {
        attr = base("$calcMode").$attribute.up("width");
        base("$frame").timelines.length = 0;
        s = document.createElementNS("http:///www.w3.org/2000/svg", "animate");
      } );
      afterEach( function() {
        attr.isCSS = false;
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(attr.element).toBeNull();
        expect(attr.push()).toBeNull();
        expect(attr.element).toBeNull();
        expect(attr.isCSS).toBeFalsy();
        expect(base("$frame").timelines.length).toBe(0);
        
        expect(attr.push(s)).toBeNull();
        expect(attr.element).toBeNull();
        expect(base("$frame").timelines.length).toBe(0);
        expect(attr.hasAttrValues()).toBeFalsy();
        
        var p = document.createElement("g");
        p.appendChild(s);
        expect(attr.push(s)).toBeNull();
        expect(attr.element).toBe(p);
        expect(base("$frame").timelines.length).toBe(0);
        
        s.setAttribute("end", "0");
        check("from", 1);
        check("to", 2);
        check("by", 3);
        check("values", 4);
        function check(attrName, num) {
          s.setAttribute(attrName, "1");
          expect(s.hasAttributeNS(null, attrName)).toBeTruthy();
          var fr = attr.push(s);
          expect(attr.element).toBe(p);
          var timelines = base("$frame").timelines;
          expect(timelines.length).toBe(num);
          var line = timelines[num-1];
          expect(line).not.toBe(fr);
          var act = fr.$activate;
          expect(act.dur).toBeNull();
          expect(act.repeatCount).toBeNull();
          expect(act.repeatDur).toBeNull();
          expect(act.min).toBe("0");
          expect(act.max).toBe("indefinite");
          expect(act.simpleDur).toBeNull();
          expect(attr.hasAttrValues()).toBeTruthy();
          
          s.removeAttribute(attrName);
          expect(s.hasAttributeNS(null, attrName)).toBeFalsy();
          attr.push(s);
          expect(attr.element).toBe(p);
          expect(timelines.length).toBe(num);
        };
          
        /*targetElement属性のサポート*/
        var p2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        document.documentElement.appendChild(p2);
        p2.setAttributeNS(null, "id", "p23");
        s.setAttributeNS(null, "targetElement", "p23");
        attr.push(s);
        expect(attr.element).toBe(p2);
        
        /*ハイパーリンクのサポート*/
        var p3 = document.createElementNS("http://www.w3.org/2000/svg", "a");
        document.documentElement.appendChild(p3);
        p3.setAttributeNS(null, "id", "p34");
        s.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#p34");
        attr.push(s);
        expect(attr.element).toBe(p3);
        
        /*attributeType属性のサポート*/
        s.setAttributeNS(null, "attributeType", "CSS");
        s.setAttributeNS(null, "values", "a;b;c");
        attr.push(s);
        expect(attr.isCSS).toBeTruthy();
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion )", function() {
        s.setAttribute("from", "1");
        var p = document.createElement("g");
        p.appendChild(s);
        var values = [ "0",
                      "0", null, null, null, 
                      "0", "indefinite", null
                    ];
        values[7] = 0;
        check2("dur", "0");
        check2("begin", "0");
        values[0] = "1";
        check2("begin", "1");
        values[2] = 0;
        check2("end", "0");
        values[3] = "0";
        check2("repeatCount", "0");
        values[4] = "0";
        check2("repeatDur", "0");
        values[5] = "0";
        check2("min", "0");
        values[6] = "0";
        check2("max", "0");
        values[0] = "12";
        check2("begin", "12");
        values[7] = 1000 * base("$frame").fpms;
        values[1] = "1";
        check2("dur", "1");
        function check2(attrName, value) {
          s.setAttribute(attrName, value);
          expect(s.hasAttributeNS(null, attrName)).toBeTruthy();
          var fr = attr.push(s);
          expect(attr.element).toBe(p);
          var timelines = base("$frame").timelines;
          var line = timelines[timelines.length-1];
          expect(fr.string).toBe(values[0]);
          var act = fr.$activate;
          expect(act.dur).toBe(values[1]);
          expect(act.repeatCount).toBe(values[3]);
          expect(act.repeatDur).toBe(values[4]);
          expect(act.min).toBe(values[5]);
          expect(act.max).toBe(values[6]);
          expect(act.simpleDur).toBe(values[7]);
        };
        
                
        var p4 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        document.documentElement.appendChild(p4);
        p4.appendChild(s);
        p4.setAttributeNS(null, "style", "display: none");
        attr.push(s);
        expect(attr.setAttribute()).toBeUndefined();
        expect(attr.setAttribute("block")).toBeUndefined();
        expect(p4.hasAttributeNS(null, "display")).toBeFalsy();
        expect(attr.isCSS).toBeFalsy();
        
        s.setAttributeNS(null, "attributeName", "display");
        attr.push(s);
        expect(attr.setAttribute("block")).toBeUndefined();
        expect(p4.hasAttributeNS(null, "display")).toBeFalsy();
        expect(attr.isCSS).toBeTruthy();
        expect(p4.style.getPropertyValue("display")).toBe("block");
        
        p4 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        document.documentElement.appendChild(p4);
        p4.appendChild(s);
        p4.setAttributeNS(null, "style", "display: none");
        attr.push(s);
        expect(attr.setAttribute("block")).toBeUndefined();
        expect(p4.hasAttributeNS(null, "display")).toBeFalsy();
        expect(p4.style.getPropertyValue("display")).toBe("block");
        expect(attr.removeAttribute()).toBeUndefined();
        expect(p4.hasAttributeNS(null, "display")).toBeFalsy();
        expect(p4.style.getPropertyValue("display")).toBe("none");
        
        /*attributeType属性のサポート*/
        s.setAttributeNS(null, "values", "a;b;c");
        s.setAttributeNS(null, "attributeName", "display");
        attr.isCSS = false;
        attr.push(s);
        expect(attr.isCSS).toBeTruthy();
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion )", function() {
        var p = document.createElement("g");
        p.appendChild(s);
        
        s.setAttributeNS(null, "begin", "1");
        attr.push(s);
        var timelines = base("$frame").timelines;
        expect(timelines.length).toBe(0);
        s.setAttributeNS(null, "from", "0");
        attr.push(s);
        expect(timelines.length).toBe(1);
        expect(attr.push(12)).toBeNull();
      } );
    } );
    describe("A setValues method", function() {
      var attr, s;
      beforeEach( function() {
        attr = base("$calcMode").$attribute.up("width");
        base("$frame").timelines.length = 0;
        s = document.createElement("animate");
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(attr.$from).not.toBeUndefined();
        expect(attr.setValues()).toBeNull();
        expect(attr.setValues("")).toBeNull();

        expect(attr.setValues("0;1")[0].to.string).toBe("1");
        expect(attr.setValues("0;1")[0].to.from.string).toBe("0");
        expect(attr.setValues("0;1", "0", "1", "1")[0].to.from.string).toBe("0");
        expect(attr.setValues("0;1", null, "1", "0")[0].to.from.string).toBe("0"); 
               
        /*from-to アニメーション*/
        expect(attr.setValues(null, "0", "1")[0].to.string).toBe("1");
        expect(attr.setValues(null, "0", "1")[0].to.from.string).toBe("0");
        
        /*from-by アニメーション*/
        expect(attr.setValues(null, "1", null, "1")[0].to.string).toBe("1");
        expect(attr.setValues(null, "1", null, "1")[0].to.from[0]).toBe(1);
        expect(attr.setValues(null, "1", null, "1")[0].to.numList[0]).toBe(2);
        
        /*fromなしto アニメーション*/
        expect(attr.setValues(null, null, "1")[0].to.string).toBe("1");
        expect(attr.setValues(null, null, "1")[0].to.from.string).toBe("0");
        var aset = attr.setValues(null, null, "1")[0].to;
        aset.call();
        expect(aset.from[0]).toBe(0);
        
        /*fromなしby アニメーション*/
        expect(attr.setValues(null, null, null, "1")[0].to.string).toBe("1");
        expect(attr.setValues(null, null, null, "1")[0].to.from[0]).toBe(0);
        var aset = attr.setValues(null, null, null, "1")[0].to;
        aset.call();
        expect(aset.from[0]).toBe(0);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion on a spline mode )", function() {
        attr.$from.degit = 1;
        var setv = attr.setValues("0;1")[0].call();
        expect(setv(0.5)).toBe("0.5");
        expect(setv(1)).toBe("1.0");
        
        setv = attr.setValues(" 0;1; 2 ")[0].call();
        expect(setv(0.5)).toBe("0.5");
        expect(setv(1)).toBe("1.0");
        setv = attr.setValues("0;1;2")[1].call();
        expect(setv(0.4)).toBe("1.4");
        expect(setv(1)).toBe("2.0");
        
        attr.$from.degit = 2;
        setv = attr.setValues("1;1;1;1 ;1;15.1")[4].call();
        expect(setv(0.5)).toBe("8.05");
        expect(setv(1)).toBe("15.10");
        
        var v = attr.setValues("1;1;2;1;1;15.1");
        setv = v[4].mix( {
         keyTime: 0.1
        } ).call();
        expect(setv(0.05)).toBe("8.05");
        expect(setv(0.1)).toBe("15.10");
        setv = v[3].mix( {
         keyTime: 0.1
        } ).call();
        expect(setv(0.01)).toBe("1.00");
        expect(setv(0.1)).toBe("1.00");
        setv = v[2].mix( {
         keyTime: 0.5
        } ).call();
        expect(setv(0.25)).toBe("1.50");
        expect(setv(0.5)).toBe("1.00");
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion on a spline mode )", function() {
        attr.$from.degit = 1;
        expect(attr.setValues("")).toBeNull();
        expect(attr.setValues(null, null, null, null)).toBeNull();
      } );
    } );
    describe("A setKey method", function() {
      var attr, s;
      beforeEach( function() {
        attr = base("$calcMode").$attribute.up("width");
        base("$frame").timelines.length = 0;
        s = document.createElement("animate");
        document.createElement("g").appendChild(s);
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect(attr.setKey(s)).toBeNull();
        
        s.setAttributeNS(null, "from", "0");
        attr.setKey(s);
        s.setAttributeNS(null, "to", "0");
        expect(attr.setKey(s)[0].to.from.string).toBe("0");
        expect(attr.setKey(s)[0].to.string).toBe("0");
        s.setAttributeNS(null, "by", "0");
        attr.setKey(s);
        s.setAttributeNS(null, "values", "0;2");
        expect(attr.setKey(s)[0].to.from.string).toBe("0");
        expect(attr.setKey(s)[0].to.string).toBe("2");
        
        s.setAttributeNS(null, "keyTimes", "0;0.1");
        expect(attr.setKey(s)[0].keyTime).toBe(0.1);
        
        s.setAttributeNS(null, "keySplines", "0,0.1,0.3,0.4");
        expect(attr.setKey(s)[0].keySplines[0]).toBe(0);
        expect(attr.setKey(s)[0].keySplines[1]).toBe(0.1);
        expect(attr.setKey(s)[0].keySplines[2]).toBe(0.3);
        expect(attr.setKey(s)[0].keySplines[3]).toBe(0.4);
        
        s.setAttributeNS(null, "keySplines", "0 0.1 0.3 0.4");
        expect(attr.setKey(s)[0].keySplines[0]).toBe(0);
        expect(attr.setKey(s)[0].keySplines[1]).toBe(0.1);
        expect(attr.setKey(s)[0].keySplines[2]).toBe(0.3);
        expect(attr.setKey(s)[0].keySplines[3]).toBe(0.4);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion on a spline mode )", function() {
        s.setAttributeNS(null, "values", "0;2;12;30");
        expect(attr.setKey(s)[0].keyTime.toFixed(3)).toBe("0.333");
        s.setAttributeNS(null, "keyTimes", "0;0.1;0.2;1");
        expect(attr.setKey(s)[0].keyTime).toBe(0.1);
        expect(attr.setKey(s)[1].keyTime).toBe(0.1);
        expect(attr.setKey(s)[2].keyTime).toBe(0.8);
        s.setAttributeNS(null, "values", " 0; 2;12 ;30 ");
        s.setAttributeNS(null, "keyTimes", " 0; 0.1; 0.2 ; 1 ");
        expect(attr.setKey(s)[0].keyTime).toBe(0.1);
        expect(attr.setKey(s)[1].keyTime).toBe(0.1);
        expect(attr.setKey(s)[2].keyTime).toBe(0.8);
        
        s.setAttributeNS(null, "keyTimes", " 0; .1; .2 ; 1 ");
        expect(attr.setKey(s)[0].keyTime).toBe(0.1);
        expect(attr.setKey(s)[1].keyTime).toBe(0.1);
        expect(attr.setKey(s)[2].keyTime).toBe(0.8);
        
        s.setAttributeNS(null, "keySplines", " 0,0.1,0.3,1; 0.1,0.4,0.5,0.7; 0.2,0.2,0.1  , 1 ;");
        f(0, 0,0.1,0.3,1);
        f(1, 0.1,0.4,0.5,0.7);
        f(2, 0.2,0.2,0.1,1);
        
        s.setAttributeNS(null, "keySplines", " 0,.1,.3,1; .1,.4, .5,.7; .2,  .2, .1  , 1 ;");
        f(0, 0,0.1,0.3,1);
        f(1, 0.1,0.4,0.5,0.7);
        f(2, 0.2,0.2,0.1,1);
        
        s.setAttributeNS(null, "keySplines", " 0 .1 .333,1; .1 .4  .5 .7; .2   .2  .1    1 ;");
        f(0, 0,0.1,0.333,1);
        f(1, 0.1,0.4,0.5,0.7);
        f(2, 0.2,0.2,0.1,1);
        function f (i, a, b, c, d) {
          var splines = attr.setKey(s)[i].keySplines;
          expect(splines[0]).toBe(a);
          expect(splines[1]).toBe(b);
          expect(splines[2]).toBe(c);
          expect(splines[3]).toBe(d);
        };
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion on a spline mode )", function() {
        s.setAttributeNS(null, "keyTimes", "0;0.1;0.2;1");
        expect(attr.setKey(s)).toBeNull();
        s.setAttributeNS(null, "values", "0;2;12");
        expect(attr.setKey(s)).toBeNull();
        s.setAttributeNS(null, "values", "0;2;12;20");
        s.setAttributeNS(null, "keyTimes", "0;0.1;0.2");
        expect(attr.setKey(s)).toBeNull();
      } );
    } );
  } );
  describe("A $setElement object", function() {
    describe("A timeline property", function() {
      var $set, ele, frame;
      beforeEach( function() {
        $set = base("$calcMode").$attribute.$setElement.up();
        var p = document.createElementNS("http://www.w3.org/2000/svg", "g");
        ele = document.createElementNS("http://www.w3.org/2000/svg", "set");
        p.appendChild(ele);
        frame = base("$frame");
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect($set.timeline).toBe(frame.$begin);
        
        $set.init();
        expect($set.timeline).toBe(frame.$begin);
        expect($set.element).toBeNull();
      } );
    } );
    
      describe("An init method", function() {
      var $set, ele, frame;
      beforeEach( function() {
        $set = base("$calcMode").$attribute.$setElement.up();
        var p = document.createElementNS("http://www.w3.org/2000/svg", "g");
        ele = document.createElementNS("http://www.w3.org/2000/svg", "set");
        p.appendChild(ele);
        frame = base("$frame");
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect($set.to).toBe("");
        expect($set.attrName).toBe("");
        expect($set.defaultValue).toBe("");
        expect($set.isDefault).toBeFalsy();
        expect($set.attrNameSpace).toBeNull();
        $set.init();
        expect($set.timeline).toBe(frame.$begin);
        $set.init(ele);
        expect($set.to).toBe("");
        expect($set.attrName).toBe("");
        expect($set.isDefault).toBeFalsy();
        expect($set.attrNameSpace).toBeNull();
        expect($set.timeline).toBe(frame.$begin);
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion  )", function() {
        ele.setAttributeNS(null, "to", "t1");
        $set.init(ele);
        expect($set.to).toBe("t1");
        expect($set.attrName).toBe("");
        expect($set.defaultValue).toBe("");

        ele.setAttributeNS(null, "attributeName", "tt1");
        $set.init(ele);
        expect($set.to).toBe("t1");
        expect($set.attrName).toBe("tt1");
        expect($set.defaultValue).toBe("");

        ele.parentNode.setAttributeNS(null, "tt1", "undef");
        $set.init(ele);
        expect($set.defaultValue).toBe("undef");
        expect($set.isDefault).toBeTruthy();

        ele.setAttributeNS(null, "attributeName", "font-size");
        ele.parentNode.style.setProperty("font-size", "12px");
        $set.init(ele);
        expect($set.defaultValue).toBe("12px");
        expect($set.isDefault).toBeFalsy();
        
        ele.setAttributeNS(null, "attributeName", "xlink:href");
        $set.init(ele);
        expect($set.to).toBe("t1");
        expect($set.attrName).toBe("xlink:href");
        expect($set.defaultValue).toBe("");
        ele.parentNode.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "undef");
        $set.init(ele);
        expect($set.attrNameSpace).toBe("http://www.w3.org/1999/xlink");
      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion on a spline mode )", function() {
        $set.init(null);
        expect($set.to).toBe("");
        expect($set.attrName).toBe("");
        expect($set.defaultValue).toBe("");

        $set.init(12);
        expect($set.to).toBe("");
        expect($set.attrName).toBe("");
        expect($set.defaultValue).toBe("");
      } );
    } );
    describe("Frame Set", function() {
      var $set, ele, frame;
      beforeEach( function() {
        $set = base("$calcMode").$attribute.$setElement.up();
        var p = document.createElementNS("http://www.w3.org/2000/svg", "g");
        ele = document.createElementNS("http://www.w3.org/2000/svg", "set");
        p.appendChild(ele);
        frame = base("$frame");
        frame.timelines.length = 0; //配列の初期化
        frame.startTime = Date.now();
        frame.setFrame(0);
      } );
      afterEach( function() {
        $set.isCSS = false;
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        expect($set.isEnd).toBeFalsy();
        ele.setAttributeNS(null, "dur", "1s");
        ele.setAttributeNS(null, "attributeName", "fill");
        ele.setAttributeNS(null, "to", "red");
        $set.init(ele);
        /*テストしやすくするために、CSSではなくXML属性として扱う*/
        $set.isCSS = false;
        expect($set.timeline).not.toBe(frame.$begin);
        frame.setFrame(0);
        expect(ele.parentNode.getAttributeNS(null, "fill")).toBe("red");
        
        var line = $set.timeline;
        expect(line.$list.state).toBe(line.$list.PLAYING);
        frame.setFrame(24);
        expect(line.$list.state).toBe(line.$list.POSTWAITING);
        expect(ele.parentNode.hasAttributeNS(null, "fill")).toBeFalsy();
      } );
      /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
      it("should be this for the value (the valid partion)", function() {
        ele.setAttributeNS(null, "begin", "1s");
        ele.setAttributeNS(null, "dur", "1s");
        ele.setAttributeNS(null, "attributeName", "fill");
        ele.setAttributeNS(null, "to", "red");
        $set.init(ele);
        /*テストしやすくするために、CSSではなくXML属性として扱う*/
        $set.isCSS = false;
        var f = function(num) {
          frame.setFrame(num);
          expect(ele.parentNode.getAttributeNS(null, "fill") || null).toBeNull();
        }
        f(0);
        f(1);
        f(23);
        frame.setFrame(24);
        expect(ele.parentNode.getAttributeNS(null, "fill")).toBe("red");
        frame.setFrame(25);
        expect(ele.parentNode.getAttributeNS(null, "fill")).toBe("red");
        f(48);
        f(49);
        
        ele.setAttributeNS(null, "fill", "freeze");
        $set.init(ele);
        $set.isCSS = false;
        f(0);
        f(1);
        f(23);
        frame.setFrame(24);
        expect(ele.parentNode.getAttributeNS(null, "fill")).toBe("red");
        frame.setFrame(25);
        expect(ele.parentNode.getAttributeNS(null, "fill")).toBe("red");
        frame.setFrame(48);
        expect(ele.parentNode.getAttributeNS(null, "fill") || null).toBe("red");
        frame.setFrame(49);
        expect(ele.parentNode.getAttributeNS(null, "fill") || null).toBe("red");
        ele.setAttributeNS(null, "begin", "1s");
        ele.setAttributeNS(null, "attributeName", "fill");
        ele.setAttributeNS(null, "to", "red");
        /*eleにはdur属性やendなどが設定されていなくとも、アニメーションが有効*/
        $set.init(ele);
        $set.isCSS = false;
        var f = function(num) {
          frame.setFrame(num);
          expect(ele.parentNode.getAttributeNS(null, "fill") || null).toBe("red");
        }
        f(0);
        f(1);
        f(23);
        f(24);
        f(25);
        f(48);      } );
      /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
      it("should be this for the value (the invalid partion)", function() {

      } );
    } );
  } );
    describe("A $animateElement object", function() {
      describe("An init method", function() {
        var $animate, ele, frame;
        beforeEach( function() {
          $animate = base("$calcMode").$attribute.$setElement.$animateElement.up();
          var p = document.createElementNS("http://www.w3.org/2000/svg", "g");
          ele = document.createElementNS("http://www.w3.org/2000/svg", "animate");
          p.appendChild(ele);
          frame = base("$frame");
          frame.pauseAnimation();
          frame.timelines.length = 0;
          frame.startTime = Date.now();
          frame.setFrame(0);
        } );
        /*境界条件を調べておく (limit value analysis)*/
        it("should be this for the value  (limit value analysis)", function() {
          expect(typeof $animate.getAdvanceEnd).toBe("function");
          $animate.init();
          
          ele.setAttributeNS(null, "begin", "1s");
          ele.setAttributeNS(null, "dur", "1s");
          ele.setAttributeNS(null, "attributeName", "d");
          ele.setAttributeNS(null, "from", "M20 0 L20 30");
          ele.setAttributeNS(null, "to", "M20 20 L10 30");
          $animate.init(ele);
          expect($animate.isCSS).toBeFalsy();
          frame.setFrame(0);
          var p = ele.parentNode;
          /*getAttributeNSメソッドは、IE11では空文字列を返す（DOM 2に準拠)のに対して、
           * 他のブラウザではnullを返すため、その対策をする*/
          expect(p.getAttributeNS(null, "d") || null).toBeNull();
          
          function f(fr, result) {
            frame.setFrame(fr);
            expect(p.getAttributeNS(null, "d") || "").toBe(result);
          };
          
          f(24, "M20.0 0.0 L20.0 30.0");
          f(36, "M20.0 10.0 L15.0 30.0");
          f(48, "");
                    
          ele.setAttributeNS(null, "fill", "freeze");
          $animate.init(ele);
          f(24, "M20.0 0.0 L20.0 30.0");
          f(36, "M20.0 10.0 L15.0 30.0");
          f(48, "M20.0 20.0 L10.0 30.0");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "calcMode", "discrete");
          $animate.init(ele);
          expect($animate.isCSS).toBeFalsy();
          expect($animate.mode).toBe("discrete");
          f(24, "M20.0 0.0 L20.0 30.0");
          f(25, "M20.0 0.0 L20.0 30.0");
          f(37, "M20.0 20.0 L10.0 30.0");
          f(48, "M20.0 20.0 L10.0 30.0");
          
          [ ["display", "inline", "none"],
            ["visibility", "hidden", "visible"],
            ["stroke-linecap", "round", "square"],
            ["font-style", "italic", "normal"]
          ].forEach( function(attr) {
            var attrName = attr[0],
                from = attr[1],
                to = attr[2];
            function g(fr, result) {
              frame.setFrame(fr);
              expect(p.style.getPropertyValue(attrName) || p.getAttribute(attrName) || "").toBe(result);
            };

            
            ele.setAttributeNS(null, "from", from);
            ele.setAttributeNS(null, "to", to);
            frame.timelines.length = 0;
            ele.setAttributeNS(null, "calcMode", "linear");
            ele.setAttributeNS(null, "attributeName", attrName);
            $animate.init(ele);
            expect($animate.mode).toBe("discrete");
            g(24, from);
            g(25, from);
            g(37, to);
            g(48, to);
          } );
        } );
        /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
        it("should be this for the value (the valid partion )", function() {
          /*24FPSが前提*/
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "dur", "100s");
          ele.setAttributeNS(null, "attributeName", "d");
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "from", "M20 0 L20 30");
          ele.setAttributeNS(null, "to", "M20 2400 L20 30");
          $animate.init(ele);
          
          var p = ele.parentNode;
          expect(p.getAttributeNS(null, "d") || null).toBeNull();
          
          function f(fr, result) {
            frame.setFrame(fr);
            expect(p.getAttributeNS(null, "d")).toBe(result);
          };
          
          for (var i=0;i<2400;++i) {
            f(i, "M20.0 " +i+ ".0 L20.0 30.0");
          }
          f(2401, "M20.0 2400.0 L20.0 30.0");
          
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "dur", "1s");
          ele.setAttributeNS(null, "repeatDur", "2s");
          ele.setAttributeNS(null, "attributeName", "d");
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "from", "M20 0 L20 30");
          ele.setAttributeNS(null, "to", "M20 24 L20 30");
          $animate.init(ele);
          f(23, "M20.0 23.0 L20.0 30.0");
          f(24, "M20.0 0.0 L20.0 30.0");
          f(25, "M20.0 1.0 L20.0 30.0");
          f(48, "M20.0 24.0 L20.0 30.0");

          frame.timelines.length = 0;
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "dur", "2s");
          ele.setAttributeNS(null, "attributeName", "d");
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "values", "M20 0 L20 30;M20 24 L20 30;M20 26.4 L20 30");
          $animate.init(ele);
          f(0, "M20.0 0.0 L20.0 30.0");
          f(1, "M20.0 1.0 L20.0 30.0");
          f(24, "M20.0 24.0 L20.0 30.0");
          f(25, "M20.0 24.1 L20.0 30.0");
          f(47, "M20.0 26.3 L20.0 30.0");
          f(48, "M20.0 26.4 L20.0 30.0");
          f(49, "M20.0 26.4 L20.0 30.0");
          f(50, "M20.0 26.4 L20.0 30.0");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "end", "2s");
          ele.removeAttributeNS(null, "dur"); //単純継続時間が設定されていない場合
          ele.removeAttributeNS(null, "repeatDur");
          ele.setAttributeNS(null, "attributeName", "d");
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "values", "M20 0 L20 30;M20 24 L20 30;M20 26.4 L20 30");
          $animate.init(ele);
          f(0, "M20.0 0.0 L20.0 30.0");
          f(1, "M20.0 0.0 L20.0 30.0");
          f(24, "M20.0 0.0 L20.0 30.0");
          f(25, "M20.0 0.0 L20.0 30.0");
          f(47, "M20.0 0.0 L20.0 30.0");
          f(48, "M20.0 0.0 L20.0 30.0");
          f(49, "M20.0 0.0 L20.0 30.0");
          f(50, "M20.0 0.0 L20.0 30.0");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "dur", "2s");
          ele.setAttributeNS(null, "fill", "remove");
          var attrValue = p.getAttributeNS(null, "d");
          $animate.init(ele);
          f(48, attrValue);
          
          frame.timelines.length = 0;
          p.removeAttributeNS(null, "d");
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "keyTimes", "0;0.1;1");
          $animate.init(ele);
          f(1, "M20.0 5.0 L20.0 30.0");
          f(48, "M20.0 26.4 L20.0 30.0");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "calcMode", "discrete");
          ele.setAttributeNS(null, "keyTimes", "0;0.5;0.6");
          $animate.init(ele);
          f(1, "M20.0 0.0 L20.0 30.0");
          f(4, "M20.0 0.0 L20.0 30.0");
          /*本来は24フレーム目で、変化するはずだが、不具合があるため、そうならない
           * 修正の余地あり*/
          f(24, "M20.0 24.0 L20.0 30.0");
          f(25, "M20.0 24.0 L20.0 30.0");
          f(29, "M20.0 26.4 L20.0 30.0");
          f(48, "M20.0 26.4 L20.0 30.0");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "calcMode", "spline");
          ele.removeAttributeNS(null, "keyTimes");
          ele.setAttributeNS(null, "keySplines", "0,0,1,1;0,0,1,1;.75,0,0,.75");
          ele.removeAttributeNS(null, "end");
          ele.setAttributeNS(null, "dur", "9s");
          ele.setAttributeNS(null, "values", "210;177;121;10");
          $animate.init(ele);
          f(0, "210.0");
          f(72, "177.0");
          f(144, "121.0");
          f(216, "10.0");
          f(300, "10.0");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "calcMode", "spline");
          ele.setAttributeNS(null, "keyTimes", "0;.25;.5;1");
          ele.setAttributeNS(null, "keySplines", "0,0,1,1;0,0,1,1;1,0,0,1");
          ele.setAttributeNS(null, "dur", "8s");
          ele.setAttributeNS(null, "values", "300;255;180;30");
          $animate.init(ele);
          f(0, "300.0");
          f(48, "255.0");
          f(96, "180.0");
          f(192, "30.0");
          f(300, "30.0");
          
          /*開始時刻が未解決の場合*/
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "begin", "click");
          ele.setAttributeNS(null, "calcMode", "spline");
          ele.setAttributeNS(null, "keyTimes", "0;.25;.5;1");
          ele.setAttributeNS(null, "keySplines", "0,0,1,1;0,0,1,1;1,0,0,1");
          ele.setAttributeNS(null, "dur", "8s");
          ele.setAttributeNS(null, "values", "300;255;180;30");
          ele.parentNode.setAttributeNS(null, "d", "300");
          $animate.init(ele);
          f(0, "300");
          f(48, "300");
          f(96, "300");
          f(192, "300");
          f(300, "300");
          
          ( function(attrName) {
            function g(fr, result) {
              frame.setFrame(fr);
              expect(p.style.getPropertyValue(attrName)).toBe(result);
            };

            frame.timelines.length = 0;
            ele.setAttributeNS(null, "begin", "0s");
            ele.setAttributeNS(null, "calcMode", "linear");
            ele.setAttributeNS(null, "attributeName", attrName);
            ele.setAttributeNS(null, "keyTimes", "0;.25;.5;1");
            ele.setAttributeNS(null, "keySplines", "0,0,1,1;0,0,1,1;1,0,0,1");
            ele.setAttributeNS(null, "dur", "8s");
            ele.setAttributeNS(null, "values", "inline;block;inline;block");
            $animate.init(ele);
            expect($animate.mode).toBe("discrete");
            g(0, "inline");
            g(48, "block");
            g(96, "inline");
            g(192, "block");
            g(300, "block");
            
            frame.timelines.length = 0;
            ele.setAttributeNS(null, "begin", "click");
            ele.setAttributeNS(null, "calcMode", "linear");
            ele.setAttributeNS(null, "attributeName", attrName);
            ele.setAttributeNS(null, "keyTimes", "0;.25;.5;1");
            ele.setAttributeNS(null, "keySplines", "0,0,1,1;0,0,1,1;1,0,0,1");
            ele.setAttributeNS(null, "dur", "8s");
            ele.setAttributeNS(null, "values", "inline;block;inline;block");
            $animate.init(ele);
            var evt = ele.ownerDocument.createEvent("MouseEvents");
            evt.initMouseEvent("click",true, true, window, 0, 0, 0, 0, 0, false, false, false, false,0, p);
            p.dispatchEvent(evt);
            var cur = base("$frame").currentFrame;
            expect($animate.mode).toBe("discrete");
            g(cur+0, "inline");
            g(cur+48, "block");
            g(cur+96, "inline");
            g(cur+192, "block");
            g(cur+300, "block");
          } )("display");
        } );
        /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
        it("should be this for the value (the invalid partion )", function() {
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "dur", "100s");
          ele.setAttributeNS(null, "attributeName", "d");
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "from", "M20 0 L20 30");
          ele.setAttributeNS(null, "to", "M20 2400 L20 30");
          ele.setAttributeNS(null, "keyTimes", "0;0.1;1");
          $animate.init(ele);
          
          var p = ele.parentNode;
          expect(p.getAttributeNS(null, "d") || null).toBeNull();
          
          function f(fr, result) {
            frame.setFrame(fr);
            expect(p.getAttributeNS(null, "d") || null).toBe(result);
          };
          f(0, null);
          f(1, null);
          
           frame.timelines.length = 0;
          /*keyTimes属性のリストの個数がvaluesリストと合致しない*/
          ele.setAttributeNS(null, "keyTimes", "0;0.1;0.5;1");
          ele.setAttributeNS(null, "values", "M20 0 L20 30;M20 24 L20 30;M20 26.4 L20 30");
          $animate.init(ele);
          f(0, null);
          f(1, null);
          
          /*keyTimes属性が0から始まっていない*/
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "keyTimes", "0.1;0.3;1");
          ff("linear");
          ff("splines");
          ff("discrete");
          function ff(mode) {
            ele.setAttributeNS(null, "calcMode", mode);
            $animate.init(ele);
            f(0, null);
            f(1, null);
          }
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "calcMode", "spline");
          $animate.init(ele);
          expect($animate.mode).toBe("spline");
          f(0, null);
          f(0.2, null);
          f(1, null); 
        } );
      } );
      describe("RGB Color", function() {
        var $animate, ele, frame, f;
        beforeEach( function() {
          $animate = base("$calcMode").$attribute.$setElement.$animateElement.up();
          var p = document.createElementNS("http://www.w3.org/2000/svg", "g");
          ele = document.createElementNS("http://www.w3.org/2000/svg", "animate");
          p.appendChild(ele);
          frame = base("$frame");
          frame.timelines.length = 0;
          
          f = function (fr, result, attr) {
            frame.setFrame(fr);
            expect(p.style.getPropertyValue(attr).replace(/\s/g, "")).toBe(result.replace(/\s/g, ""));
          };
        } );
        /*境界条件を調べておく (limit value analysis)*/
        it("should be this for the value  (limit value analysis)", function() {
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "dur", "1s");
          ele.setAttributeNS(null, "attributeName", "fill");
          ele.setAttributeNS(null, "fill", "remove");
          ele.setAttributeNS(null, "from", "rgb(0, 0, 0)");
          ele.setAttributeNS(null, "to", "rgb(10, 10, 1)");
          $animate.init(ele);
          
          f(0, "rgb(0, 0, 0)", "fill");
          f(23, "rgb(10, 10, 1)", "fill");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "attributeName", "stroke");
          $animate.init(ele);
          f(0, "rgb(0, 0, 0)", "stroke");
          f(23, "rgb(10, 10, 1)", "stroke");

          frame.timelines.length = 0;
          ele.setAttributeNS(null, "attributeName", "stop-color");
          $animate.init(ele);
          f(0, "rgb(0,0,0)", "stop-color");
          f(23, "rgb(10,10,1)", "stop-color");

          frame.timelines.length = 0;
          ele.setAttributeNS(null, "attributeName", "color");
          $animate.init(ele);
          f(0, "rgb(0,0,0)", "color");
          f(23, "rgb(10,10,1)", "color");
        } );
        /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
        it("should be this for the value (the valid partion )", function() {
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "dur", "1s");
          ele.setAttributeNS(null, "attributeName", "fill");
          ele.setAttributeNS(null, "fill", "remove");
          ele.setAttributeNS(null, "values", "rgb(0, 0, 0);rgb(24, 2.4, 1)");
          $animate.init(ele);
          
          f(0, "rgb(0, 0, 0)", "fill");
          f(1, "rgb(1, 0, 0)", "fill");
          f(23, "rgb(23, 2, 1)", "fill");

          frame.timelines.length = 0;
          ele.setAttributeNS(null, "values", "#00083C;#18203C");
          $animate.init(ele);
          /*rgb形式に変換*/
          
          f(0, "rgb(0, 8, 60)", "fill");
          f(1, "rgb(1, 9, 60)", "fill");
          f(23, "rgb(23, 31, 60)", "fill");
          
          frame.timelines.length = 0;
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "values", "black;white");
          $animate.init(ele);
          /*色キーワードをrgb形式に変換*/
          
          f(0, "rgb(0, 0, 0)", "fill");
          f(12, "rgb(128, 128, 128)", "fill");
          f(24, "rgb(255, 255, 255)", "fill");
        } );
        /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
        it("should be this for the value (the invalid partion )", function() {
          ele.setAttributeNS(null, "begin", "0s");
          ele.setAttributeNS(null, "dur", "1s");
          ele.setAttributeNS(null, "attributeName", "fi");
          ele.setAttributeNS(null, "fill", "remove");
          ele.setAttributeNS(null, "values", "#00083C;#00107C");
          $animate.init(ele);
          /*rgb形式に変換しない*/
          
          function f (fr, result, attr) {
            frame.setFrame(fr);
            expect(ele.parentNode.getAttributeNS(null,attr)).toBe(result);
          };
          f(0, "#83.0C", "fi");
          f(1, "#84.0C", "fi");
          f(23, "#106.0C", "fi");   
        } );
      } );
    describe("A $animateTransformElement object", function() {
      describe("An init method", function() {
        var $animate, ele, frame, p;
        beforeEach( function() {
          $animate = base("$calcMode").$attribute.$setElement.$animateElement.$animateTransformElement.up();
          /*ここでは、データ量を削るため、degitsプロパティを小数点以下1桁に設定*/
          $animate.degits = 1;
          p = document.createElementNS("http://www.w3.org/2000/svg", "g");
          ele = document.createElementNS("http://www.w3.org/2000/svg", "animateTransform");
          p.appendChild(ele);
          frame = base("$frame");
          frame.timelines.length = 0;
          frame.startTime = Date.now();
          frame.setFrame(0);
        } );
        afterEach( function() {
          $animate.numberOfList = -1;
        } );
        /*境界条件を調べておく (limit value analysis)*/
        it("should be this for the value  (limit value analysis)", function() {
          expect($animate.numberOfList).toBe(-1);
          expect($animate.type).toBe("translate");
          expect(p.__transformList).toBeUndefined();
          expect($animate.isCSS).toBeFalsy();
          expect($animate.isSum).toBeFalsy();
          expect($animate.attrName).toBe("transform");
          
          $animate.init();
          expect($animate.numberOfList).toBe(-1);
          expect(p.__transformList).toBeUndefined();
          expect($animate.isCSS).toBeFalsy();
          expect($animate.type).toBe("translate");
          expect($animate.attrName).toBe("transform");
          
          $animate.init(p);
          expect($animate.numberOfList).toBe(-1);
          expect(p.__transformList).toBeUndefined();
          expect($animate.isCSS).toBeFalsy();
          expect($animate.type).toBe("translate");
          expect($animate.attrName).toBe("transform");
          
          $animate.init(ele);
          expect($animate.numberOfList).toBe(-1);
          expect(p.__transformList).toEqual([]);
          expect($animate.isCSS).toBeFalsy();
          expect($animate.type).toBe("translate");
          expect($animate.attrName).toBe("transform");
          
          ele.setAttributeNS(null, "values", "0;1");
          ele.setAttributeNS(null, "attributeName", "");
          $animate.init(ele);
          expect($animate.isCSS).toBeFalsy();
          expect($animate.type).toBe("translate");
          expect($animate.type).toBe("translate");
          expect($animate.numberOfList).toBe(0);
          expect(p.__transformList).toEqual([ {isPlaying: false,
                                               value: "translate(0)",
                                               isSum: false
                                              } ]);
          
          ele.setAttributeNS(null, "type", "translate");
          $animate.init(ele);
          expect($animate.numberOfList).toBe(0);
          expect($animate.isCSS).toBeFalsy();
          expect($animate.type).toBe("translate");
          expect(p.__transformList).toEqual([ {isPlaying: false,
                                               value: "translate(0)",
                                               isSum: false
                                              } ]);
          $animate.tocall(0);
          expect(p.__transformList[0].isPlaying).toBeTruthy();
          
          ele.parentNode.appendChild(ele.cloneNode(true));
          $animate.numberOfList = -1;
          $animate.init(ele.parentNode.lastChild);
          expect($animate.numberOfList).toBe(1);
          expect(p.__transformList[0].isPlaying).toBeTruthy();
          expect(p.__transformList[1].isPlaying).toBeFalsy();

          expect($animate.type).toBe("translate");
          $animate.tocall(0);
          expect(p.__transformList[0].isPlaying).toBeTruthy();
          expect(p.__transformList[1].isPlaying).toBeTruthy();
          $animate._setEndFrame(1);
          expect(p.__transformList[0].isPlaying).toBeTruthy();
          expect(p.__transformList[1].isPlaying).toBeFalsy();
          
          delete p.__transformList;
          ele.setAttributeNS(null, "type", "scale");
          $animate.numberOfList = -1;
          $animate.init(ele);
          expect($animate.numberOfList).toBe(0);
          expect(p.__transformList).toEqual([ {isPlaying: false,
                                               value: "translate(0)",
                                               isSum: false
                                              } ]);
          expect($animate.type).toBe("scale");

          delete p.__transformList;
          $animate.numberOfList = -1;
          ele.setAttributeNS(null, "additive", "sum");
          ele.setAttributeNS(null, "fill", "freeze");
          $animate.init(ele);
          expect($animate.isSum).toBeTruthy();
          expect(p.__transformList).toEqual([ {isPlaying: false,
                                               value: "translate(0)",
                                               isSum: true
                                              } ]);
          delete p.__transformList;
          $animate.numberOfList = -1;
          ele.setAttributeNS(null, "additive", "replace");
          ele.setAttributeNS(null, "fill", "remove");
          $animate.init(ele);
          expect(p.__transformList).toEqual([ {isPlaying: false,
                                               value: "translate(0)",
                                               isSum: false
                                              } ]);
        } );
        /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
        it("should be this for the value (the valid partion )", function() {
          ele.setAttributeNS(null, "type", "scale");
          ele.setAttributeNS(null, "values", "0;1");
          $animate.init(ele);
          expect($animate.isCSS).toBeFalsy();
          expect($animate.numberOfList).toBe(0);
          expect($animate.tocall(0)).toBe("scale(0.0)");
          expect($animate.tocall(0.5)).toBe("scale(0.5)");
          expect($animate.tocall(0.9)).toBe("scale(0.9)");
          expect($animate.tocall(1)).toBe("scale(1.0)");

          ele.parentNode.appendChild(ele.cloneNode(true));
          $animate.numberOfList = -1;
          $animate.init(ele.parentNode.lastChild);
          expect($animate.numberOfList).toBe(1);
          expect($animate.tocall(0)).toBe("scale(0.0)");
          expect($animate.tocall(1)).toBe("scale(1.0)");
          
          ele.parentNode.appendChild(ele.cloneNode(true));
          $animate.up("$a").numberOfList = -1;
          ele.parentNode.setAttribute("transform", "matrix(0 0 0 0 0 0)");
          $animate.$a.init(ele.parentNode.lastChild);
          expect($animate.$a.numberOfList).toBe(2);
          expect($animate.$a.isDefault).toBeTruthy();
          expect($animate.$a.defaultValue).toBe("matrix(0 0 0 0 0 0)");
          expect($animate.$a.tocall(0)).toBe("scale(0.0)");
          expect($animate.$a.tocall(1)).toBe("scale(1.0)");
          $animate.defaultValue = $animate.$a.defaultValue;
          expect($animate.$a.tocall(0.1)).toBe("scale(0.1)");
          
          ele.setAttributeNS(null, "additive", "sum");
          var parentNode = ele.parentNode;
          parentNode.appendChild(ele.cloneNode(true));
          parentNode.__transformList = [];
          /*additive属性のsumとreplaceの混合を避けるため、eleを削除*/
          parentNode.removeChild(ele);
          $animate.numberOfList = -1;
          $animate.init(parentNode.lastChild);
          expect($animate.numberOfList).toBe(0);
          expect($animate.tocall(0)).toBe("matrix(0 0 0 0 0 0) scale(0.0)");
          expect($animate.tocall(1)).toBe("matrix(0 0 0 0 0 0) scale(1.0)");
          
          parentNode.appendChild(ele.cloneNode(true));
          $animate.up("$a").numberOfList = -1;
          parentNode.__transformList = [];
          parentNode.setAttribute("transform", "matrix(0 0 0 0 0 0)");
          $animate.$a.init(parentNode.lastChild);
          expect($animate.$a.numberOfList).toBe(0);
          expect($animate.$a.isDefault).toBeTruthy();
          expect($animate.$a.defaultValue).toBe("matrix(0 0 0 0 0 0)");
          expect($animate.$a.tocall(0)).toBe("matrix(0 0 0 0 0 0) scale(0.0)");
          expect($animate.$a.tocall(1)).toBe("matrix(0 0 0 0 0 0) scale(1.0)");
          $animate.defaultValue = $animate.$a.defaultValue;
          expect($animate.tocall(0.1)).toBe("matrix(0 0 0 0 0 0) scale(0.1)");
          
          ele.removeAttributeNS(null, "additive");
          ad("replace", "sum", "scale(0.0) translate(0)", "scale(0.0) scale(0.0)",
           "scale(1.0) scale(0.0)", "scale(1.0) scale(1.0)");
          ad("sum", "replace", "matrix(0 0 0 0 0 0) scale(0.0)", "scale(0.0)",
           "scale(0.0)", "scale(1.0)");
          function ad(first, second, a, b, c, d) {
            /*子要素を全部消す*/
            while (parentNode.firstChild) {
              parentNode.removeChild(parentNode.firstChild);
            }
            
            /*additive属性のreplaceとsumの混合*/
            ele.setAttributeNS(null, "additive", first);
            parentNode.appendChild(ele.cloneNode(true));
            ele.setAttributeNS(null, "additive", second);
            parentNode.appendChild(ele.cloneNode(true));
            parentNode.__transformList = [];
            $animate.numberOfList = -1;
            parentNode.setAttribute("transform", "matrix(0 0 0 0 0 0)");
            $animate.up("$first").init(parentNode.firstChild);
            $animate.up("$second").init(parentNode.lastChild);
            expect($animate.$first.numberOfList).toBe(0);
            expect($animate.$second.numberOfList).toBe(1);
            expect($animate.$first.tocall(0)).toBe(a);
            expect($animate.$second.tocall(0)).toBe(b);
            expect($animate.$first.tocall(1)).toBe(c);
            expect($animate.$second.tocall(1)).toBe(d);
          };
        } );
        /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
        it("should be this for the value (the invalid partion )", function() {
          $animate.init(ele);
          ele.parentNode.__transformList = null;
          expect( function () {
            $animate.tocall(0);
          } ).toThrow();
          
          $animate.numberOfList = -1;
          $animate.init(ele);
          $animate.numberOfList = -1;
          expect( function () {
            $animate.tocall(0);
          } ).toThrow();
        } );
      } );
    } );
    describe("A $motionElement object", function() {
      describe("An init method", function() {
        var $animate, ele, frame, p;
        beforeEach( function() {
          $animate = base("$calcMode").$attribute.$setElement.$animateElement.$animateTransformElement.$motionElement.up();
          /*ここでは、データ量を削るため、degitsプロパティを小数点以下1桁に設定*/
          $animate.degits = 1;
          p = document.createElementNS("http://www.w3.org/2000/svg", "g");
          ele = document.createElementNS("http://www.w3.org/2000/svg", "animateMotion");
          p.appendChild(ele);
          frame = base("$frame");
          frame.timelines.length = 0;
          frame.startTime = Date.now();
          frame.setFrame(0);
        } );
        afterEach( function() {
          $animate.numberOfList = -1;
          delete $animate.element;
          p.__transformList = null;
        } );
        /*境界条件を調べておく (limit value analysis)*/
        it("should be this for the value  (limit value analysis)", function() {
          expect($animate.type).toBe("translate");
          expect($animate.mode).toBe("paced");
          ele.setAttributeNS(null, "type", "scale");
          expect($animate.rotate).toBe("0");
          $animate.init(ele);
          expect($animate.type).toBe("translate");
          expect($animate.mode).toBe("paced");
          expect($animate.rotate).toBe("0");
          
          ele.setAttributeNS(null, "values", "0,0;1,0");
          $animate.up("$a").init(ele);
          expect($animate.$a.tocall(0)).toBe("translate(0.0,0.0)");
          expect($animate.$a.tocall(0.5)).toBe("translate(0.5,0.0)");
          expect($animate.$a.tocall(1)).toBe("translate(1.0,0.0)");
          
          var ec = ele.cloneNode(true);
          p.appendChild(ec);
          ec.removeAttributeNS(null, "values");
          ec.setAttributeNS(null, "from", "0,0");
          ec.setAttributeNS(null, "to", "1,0");
          $animate.up("$a").init(ec);
          expect($animate.$a.tocall(0)).toBe("translate(0.0,0.0)");
          expect($animate.$a.tocall(0.5)).toBe("translate(0.5,0.0)");
          expect($animate.$a.tocall(1)).toBe("translate(1.0,0.0)");
        } );
        /*無効同値クラスを調べておく (Equivalence partitioning, the following is the invalid partion)*/
        it("should be this for the value (the invalid partion )", function() {
          $animate.init();
        } );
      } );
      describe("A hasAttrValues method", function() {
        var $animate, ele, frame, p;
        beforeEach( function() {
          $animate = base("$calcMode").$attribute.$setElement.$animateElement.$animateTransformElement.$motionElement.up();
          /*ここでは、データ量を削るため、degitsプロパティを小数点以下1桁に設定*/
          $animate.degits = 1;
          p = document.createElementNS("http://www.w3.org/2000/svg", "g");
          ele = document.createElementNS("http://www.w3.org/2000/svg", "animateMotion");
          p.appendChild(ele);
          frame = base("$frame");
          frame.timelines.length = 0;
          frame.startTime = Date.now();
          frame.setFrame(0);
        } );
        afterEach( function() {
          $animate.numberOfList = -1;
          delete $animate.element;
          p.__transformList = null;
        } );
        /*境界条件を調べておく (limit value analysis)*/
        it("should be this for the value  (limit value analysis)", function() {
                    
          expect($animate.up("$a").hasAttrValues()).toBeFalsy();
          $animate.up("$a").init(ele);
          expect($animate.$a.hasAttrValues()).toBeFalsy();
          
          ele.setAttributeNS(null, "path", "M");
          expect($animate.$a.hasAttrValues()).toBeTruthy();
          $animate.$animateTransformElement.up("$b").init(ele);
          expect($animate.$animateTransformElement.$b.hasAttrValues()).toBeFalsy();
        } );
      } );
    } );
    describe("Event", function() {
      var $animate, ele, frame, p;
      beforeEach( function() {
        
        $animate = base("$calcMode").$attribute.$setElement.$animateElement.up();
        p = document.createElementNS("http://www.w3.org/2000/svg", "g");
        ele = document.createElementNS("http://www.w3.org/2000/svg", "animate");
        p.appendChild(ele);
        frame = base("$frame");
        frame.pauseAnimation();
        frame.timelines.length = 0; //配列の初期化
        frame.setFrame(0);
      } );
      /*境界条件を調べておく (limit value analysis)*/
      it("should be this for the value  (limit value analysis)", function() {
        ele.addEventListener("beginEvent", function(evt) {
          expect(evt.target).toBe(ele);
        } );
        var evt = ele.ownerDocument.createEvent("MouseEvents");
        evt.initMouseEvent("beginEvent",true, true, window, 0, 0, 0, 0, 0, false, false, false, false,0, ele);
        ele.dispatchEvent(evt);
        
        ele.setAttributeNS(null, "begin", "mousedown");
        ele.setAttributeNS(null, "dur", "1s");
        ele.setAttributeNS(null, "attributeName", "fill");
        ele.setAttributeNS(null, "fill", "freeze");
        ele.setAttributeNS(null, "from", "rgb(0,0,0)");
        ele.setAttributeNS(null, "to", "rgb(10,10,1)");
        $animate.init(ele);
        $animate.isCSS = false;
        expect(p.getAttributeNS(null, "fill") || null).toBeNull();
        evt = ele.ownerDocument.createEvent("MouseEvents");
        evt.initMouseEvent("beginEvent",true, true, window, 0, 0, 0, 0, 0, false, false, false, false,0, ele);
        p.dispatchEvent(evt);
        expect(p.getAttributeNS(null, "fill") || null).toBeNull();
        
        evt = ele.ownerDocument.createEvent("MouseEvents");
        evt.initMouseEvent("mousedown",true, true, window, 0, 0, 0, 0, 0, false, false, false, false,0, p);
        frame.setFrame(frame.currentFrame);
        expect($animate.isEnd).toBeFalsy();
        p.dispatchEvent(evt);
        frame.setFrame(frame.currentFrame + 1);
        frame.setFrame(frame.currentFrame + 24);
        expect(evt.target.getAttributeNS(null, "fill") || null).toBe("rgb(10, 10, 1)");
      } );
    } );
      describe("a beginElement method and an endElement method", function() {
        var $animate, ele, frame, p;
        beforeEach( function() {
          $animate = base("$calcMode").$attribute.$setElement.$animateElement.up();
          p = document.createElementNS("http://www.w3.org/2000/svg", "g");
          ele = document.createElementNS("http://www.w3.org/2000/svg", "animate");
          p.appendChild(ele);
          frame = base("$frame");
          frame.timelines.length = 0; //配列の初期化
          frame.setFrame(0);
          ele.setAttributeNS(null, "begin", "indefinite");
          ele.setAttributeNS(null, "dur", "1s");
          ele.setAttributeNS(null, "dur", "1s");
          ele.setAttributeNS(null, "attributeName", "fill");
          ele.setAttributeNS(null, "fill", "freeze");
          ele.setAttributeNS(null, "from", "rgb(0,0,0)");
          ele.setAttributeNS(null, "to", "rgb(10,10,1)");
          $animate.init(ele);
        } );
        /*境界条件を調べておく (limit value analysis)*/
        it("should be this for the value  (limit value analysis)", function() {
          expect(ele.beginElement()).toBeUndefined();
          var cur = frame.currentFrame,
              begin = frame.$begin.$1;
          expect(begin.string).toBe("indefinite");
          expect(begin.begin).toBe(cur);
          expect(ele.endElement()).toBeUndefined();
        } );
        /*同値分割をして、有効同値クラスを調べておく (Equivalence partitioning, the following is the valid partion)*/
        it("should be this for the value (the valid partion )", function() {
          ele.addEventListener("beginEvent", function(evt){
            expect(evt.target.nodeName).toBe("animate");
          }, false );
          ele.beginElement();
        } );
      });
    } );
} );
