/*SIE-SVG without Plugin under LGPL2.1 & GPL2.0 & Mozilla Public License
 *http://sie.sourceforge.jp/
 *Usage: <script defer="defer" type="text/javascript" src="sie.js"></script>
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla SVG Cairo Renderer project.
 *
 * The Initial Developer of the Original Code is IBM Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Parts of this file contain code derived from the following files(s)
 * of the Mozilla SVG project (these parts are Copyright (C) by their
 * respective copyright-holders):
 *    layout/svg/renderer/src/libart/nsSVGLibartBPathBuilder.cpp
 *
 * Contributor(s):DHRNAME revulo bellbind
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 */
if(!Object._create){Object._create=function(b){var c=function(){};c.prototype=b.prototype;b=void 0;return new c}}function DOMException(c){Error.apply(this,arguments);this.code=c;var b=["","Index Size Error","DOMString Size Error","Hierarchy Request Error","Wrong　Document　Error","Invalid　Character　Error","No Data Allowed　Error","No Modification Allowed Error","Not Found Error","Not Supported　Error","Inuse　Attribute　Error","Invalid State　Error","Syntax Error","Invalid Modification　Error","Namespace Error","Invalid Access Error"];this.message=b[c]}(function(b){b.prototype=new Error()})(DOMException);DOMImplementation={hasFeature:function(c,b){switch(c){case"CORE":case"XML":case"Events":case"StyleSheets":case"org.w3c.svg.static":case"org.w3c.dom.svg.static":return true;default:if(b==="2.0"){return true}else{return false}}},createDocumentType:function(d,e,b){var c=new Node();c.publicId=e;c.systemId=b;return c},createDocument:function(d,g,b){try{var c;if(d&&DOMImplementation[d]&&DOMImplementation[d].Document){c=new (DOMImplementation[d].Document);this._doc_&&(c._document_=this._doc_)}else{c=new Document()}c.implementation=this;c.doctype=b||null;c.documentElement=c.createElementNS(d,g);return c}catch(f){}},"http://www.w3.org/2000/xmlns":{}};function Node(){this.childNodes=[];this._capter=[]}Node.prototype={tar:null,firstChild:null,previousSibling:null,nextSibling:null,attributes:null,namespaceURI:null,localName:null,lastChild:null,prefix:null,ownerDocument:null,parentNode:null,replaceChild:function(b,d){this.insertBefore(b,d);var c=this.removeChild(d);return c},appendChild:function(b){this.insertBefore(b,null);return b},hasChildNodes:function(){if(this.childNodes.length>0){return true}else{return false}},cloneNode:function(b){var c;if(this.hasOwnProperty("ownerDocument")){c=this.ownerDocument.importNode(this,b)}else{c=new Node()}return c},normalize:function(){var g=this.childNodes;try{for(var c=g.length-1;c<0;--c){var f=g[c],b=f.nextSibling;if(b){if(f.nodeType===3&&b.nodeType===3){f.appendData(b.data);f.legnth=f.data.length;this.removeChild(b)}else{f.normalize()}}else{f.normalize()}}}catch(d){}},isSupported:function(c,b){return(this.ownerDocument.implementation.hasFeature(c+"",b+""))},hasAttributes:function(){if(this.attributes.length>0){return true}else{return false}}};Array.prototype.item=function(b){if(!this[b]){return null}return(this[b])};function NamedNodeMap(){}Array.prototype._copyNode=function __nnmp_c(e,c){for(var d=0,b=e.length;d<b;d++){this[d]=e[d].cloneNode(c)}};NamedNodeMap.prototype={length:0,getNamedItem:function(b){},setNamedItem:function(b){},removeNamedItem:function(b){},item:function(b){return this[b]},getNamedItemNS:function(e,d){var c;for(var f=0,b=this.length;f<b;f++){c=this[f];if(c.namespaceURI===e&&c.localName===d){this._num=f;return c}}f=c=void 0;return null},setNamedItemNS:function(b){var c=this.getNamedItemNS(b.namespaceURI,b.localName),d;if(c){d=this[this._num];this[this._num]=b;b=c=void 0;return d}else{if(b.ownerElement!==void 0){throw (new DOMException(10))}this[this.length]=b;this.length+=1;b=void 0;return null}},removeNamedItemNS:function(c,b){var d=this.getNamedItemNS(c,b);if(!d){throw (new DOMException(8))}else{var e=this[this._num];delete (this[this._num]);this.length-=1;tgas=void 0;return e}},_copyNode:Array.prototype._copyNode};function CharacterData(){}CharacterData.prototype=Object._create(Node);(function(b){b.length=0;b.childNodes=[];b._capter=[];b.substringData=function(e,d){if(e<0||d<0||e>this.length){throw (new DOMException(1))}if(e+d>this.length){d=this.length-e}var c=this.data.substr(e,d);return c};b.replaceData=function(e,d,c){if(e<0||d<0||e>this.length){throw (new DOMException(1))}this.deleteData(e,d);this.insertData(e,c)};b=void 0})(CharacterData.prototype);function Attr(){}Attr.prototype=Object._create(Node);(function(b){b.nodeType=2;b.nodeValue=null;b.childNodes=[];b._capter=[];b=void 0})(Attr.prototype);function Element(){Node.apply(this);this.attributes=new NamedNodeMap()}Element.prototype=Object._create(Node);(function(b){b.nodeType=1;b.nodeValue=null;b.getAttribute=function(c){return(this.getAttributeNS(null,c))};b.setAttribute=function(c,d){this.setAttributeNS(null,c,d)};b.removeAttribute=function(c){this.removeAttributeNS(null,c)};b.getAttributeNode=function(c){};b.setAttributeNode=function(c){};b.removeAttributeNode=function(c){var d=this.attributes.removeNamedItemNS(c.namespaceURI,c.localName);return d};b.getElementsByTagName=function(c){};b.getAttributeNS=function(d,c){var e=this.getAttributeNodeNS(d,c);if(!e){return null}else{return(e.nodeValue)}};b.setAttributeNS=function(c,f,d){var e=this.ownerDocument.createAttributeNS(c,f);e.nodeValue=d+"";e.value=d+"";this.setAttributeNodeNS(e)};b.removeAttributeNS=function(d,c){};b.getAttributeNodeNS=function(d,c){var e=this.attributes.getNamedItemNS(d,c);return e};b.getElementsByTagNameNS=function(c,g){var q=[],e=0,l=this.firstChild,k,j,p;if(l){if(c==="*"){k=true}if(g==="*"){j=true}}while(l){if(l.nodeType===1){if((j||(l.localName===g))&&(k||(l.namespaceURI===c))){q[e]=l;e++}if(l.firstChild){p=l.getElementsByTagNameNS(c,g);if(p){for(var h=0,o=p.length;h<o;++h){q[e]=p[h];e++}}}}l=l.nextSibling}c=g=l=p=j=k=void 0;if(e===0){q=e=void 0;return null}else{e=void 0;return q}};b.hasAttribute=function(c){return(this.hasAttributeNS(null,c))};b.hasAttributeNS=function(d,c){if(this.getAttributeNodeNS(d,c)){return true}else{return false}};b=void 0})(Element.prototype);function Text(){}Text.prototype=Object._create(CharacterData);(function(b){b.nodeType=3;b.nodeName="#text";b.splitText=function(f){var e=this.substringData(0,f-1);this.replaceData(0,this.length-1,e);var c="";if(this.length!==f){c=this.substringData(f,this.length-1)}var d=this.ownerDocument.createTextNode(c);if(this.parentNode){this.parentNode.insertBefore(d,this.nextSibling)}return d};b=void 0})(Text.prototype);function Comment(){}Comment.prototype=Object._create(CharacterData);Comment.prototype.nodeType=8;Comment.prototype.nodeName="#comment";function CDATASection(){this.nodeType=4;this.nodeName="#cdata-section"}CDATASection.prototype=Object._create(Text);function DocumentType(){Node.apply(this);this.name="";this.entities=new NamedNodeMap();this.notations=new NamedNodeMap();this.publicId="";this.systemId="";this.internalSubset="";this.nodeValue=null;this.nodeType=10}DocumentType.prototype=Object._create(Node);function Notation(){Node.apply(this);this.publicId=this.systemId=this.nodeValue=null;this.nodeType=12}Notation.prototype=Object._create(Node);function Entity(){Node.apply(this);this.publicId=this.systemId=this.notationName=null;this.nodeValue=null;this.nodeType=6}Entity.prototype=Object._create(Node);function EntityReference(){Node.apply(this);this.nodeValue=null;this.nodeType=5}EntityReference.prototype=Object._create(Node);function ProcessingInstruction(){Node.apply(this);this.nodeType=7}ProcessingInstruction.prototype=Object._create(Node);function DocumentFragment(){this.nodeName="#document-fragment";this.nodeValue=null;this.nodeType=11}DocumentFragment.prototype=Object._create(Node);function Document(){Node.apply(this);this.nodeName="#document";this.nodeValue=null;this.nodeType=9;this._id={}}Document.prototype=Object._create(Node);(function(d,c,b,f,e){d.createElement=function(g){};d.createDocumentFragment=function(){var g=new DocumentFragment();g.ownerDocument=this;return g};d.createTextNode=function(h){var g=new c();g.data=g.nodeValue=h+"";g.length=h.length;g.ownerDocument=this;return g};d.createComment=function(h){var g=new e();g.data=g.nodeValue=h;g.length=h.length;g.ownerDocument=this;return g};d.createCDATASection=function(h){var g=new CDATASection();g.data=g.nodeValue=h;g.length=h.length;g.ownerDocument=this;return g};d.createProcessingInstruction=function(i,h){var g=new ProcessingInstruction();g.target=g.nodeName=i;g.data=g.nodeValue=h;g.ownerDocument=this;return g};d.createAttribute=function(g){};d.createEntityReference=function(g){var h=new EntityReference();h.nodeName=g;h.ownerDocument=this;return h};d.getElementsByTagName=function(g){return this.getElementsByTagNameNS("*",g)};d.importNode=function(r,t){var v,h=r.nodeType,o,q,u,k,j,g;if(h===2){j=r.namespaceURI;j=(j==="")?null:j;v=this.createAttributeNS(j,r.nodeName);v.nodeValue=r.nodeValue}else{if(h===3){v=this.createTextNode(r.data)}else{if(h===1){v=this.createElementNS(r.namespaceURI,r.nodeName);o=r.attributes;for(var l=0;o[l];++l){g=o[l];j=g.namespaceURI;j=(j==="")?null:j;q=this.createAttributeNS(j,g.nodeName);q.nodeValue=g.nodeValue;v.setAttributeNodeNS(q)}if(t){u=r.firstChild;while(u){k=this.importNode(u,true);v.appendChild(k);u=u.nextSibling}}l=void 0}else{if(h===8){v=this.createComment(r.data)}else{if(h===11){v=this.createDocumentFragment();if(t){g=r.childNodes;for(var l=0,p=g.length;l<p;l++){k=this.importNode(g[l],true);v.appendChild(k)}}l=p=void 0}else{if(h===4){v=this.createCDATASection(r.data)}else{if(h===5){v=this.createEntityReference(r.nodeName);if(t){u=r.firstChild;while(u){k=this.importNode(u,true);v.appendChild(k);u=u.nextSibling}}}else{if(h===6){v=new Entity();v.publicId=r.publicId;v.systemId=r.systemId;v.notationName=r.notationName}else{if(h===7){v=this.createProcessingInstruction(r.nodeName,r.nodeValue)}else{if(h===12){v=new Notation();v.publicId=r.publicId;v.systemId=r.systemId}else{throw (new DOMException(9))}}}}}}}}}}r=t=h=o=q=u=k=j=g=void 0;return v};d.createElementNS=function(h,o){var k,j=null,g=null;if(!o){throw (new DOMException(5))}if(o.indexOf(":")!==-1){var l=o.split(":");j=l[0];g=l[1]}else{g=o}var q=false;if(h){var i=this.implementation;if(!!i[h]){if(!!i[h][g]){q=true}}}if(q){k=new (i[h][g])(this._document_)}else{k=new b()}k.namespaceURI=h;k.nodeName=k.tagName=o;k.localName=g;k.prefix=j;k.ownerDocument=this;i=h=o=j=g=q=void 0;return k};d._document_=document;d.createAttributeNS=function(h,j){var g=new f(),i;g.namespaceURI=h;g.nodeName=g.name=j;if(h&&(j.indexOf(":")!==-1)){i=j.split(":");g.prefix=i[0];g.localName=i[1]}else{g.prefix=null;g.localName=j}g.ownerDocument=this;i=j=void 0;return g};d.getElementsByTagNameNS=function(h,g){if((typeof h!=="string")||(typeof g!=="string")){throw new Error("Argument not string")}var j=this.documentElement,i=j.getElementsByTagNameNS(h,g);if(((g===j.localName)||(g==="*"))&&((h===j.namespaceURI)||(h==="*"))){if(i){i.unshift(j)}else{i=[j]}}j=void 0;return i};d.getElementById=function(g){g+="";var h=!!this._id[g]?this._id[g]:null;if(h&&(h.id!==g)){h=null}return h};d=void 0;Document._destroy=function(){c=b=f=e=void 0}})(Document.prototype,Text,Element,Attr,Comment);function EventException(){DOMException.call(this);if(this.code===0){this.message="Uuspecified Event Type Error"}}EventException.prototype=Object._create(DOMException);Node.prototype.addEventListener=function(e,g,b){this.removeEventListener(e,g,b);var d=new EventListener(b,e,g),c=e.charAt(0),f;this._capter.push(d);if((c!=="D")&&(c!=="S")&&(e!=="beginEvent")&&(e!=="endEvent")&&(e!=="repeatEvent")){f=this;f._tar&&f._tar.attachEvent("on"+e,(function(i,h){return function(){var j=i.ownerDocument.createEvent("MouseEvents");j.initMouseEvent(h,true,true,i.ownerDocument.defaultView,0);i.dispatchEvent(j);i.ownerDocument._window.event.cancelBubble=true;j=void 0}})(f,e))}e=g=b=d=c=f=void 0};Node.prototype.removeEventListener=function(e,g,b){var f=this._capter;for(var d=0,c=f.length;d<c;d++){if(f[d]._listener===g){f[d]=void 0}}d=c=f=void 0};Node.prototype.dispatchEvent=function(p){if(!p.type){throw new EventException(0)}var d=this,e=d.ownerDocument,i=p.timeStamp,r=p.type,s=p.bubbles,f,o,l=1,c="1",q="3",h;if(!e._isLoaded){if(!e._limit_time_){e._limit_time_=i}else{if((i-e._limit_time_)>1000){f=e.implementation._buffer_||[];o=f.length;f[o]=this;f[o+1]=p;e.implementation._buffer_=f;d=e=i=r=s=f=o=l=void 0;return true}}}p.target=d;p.eventPhase=1;e[q]=null;while(d.parentNode){d.parentNode[c]=d;d[q]=d.parentNode;d=d.parentNode}e[c]=d;d[q]=e;d=this;while(e){p.currentTarget=e;if(e===d){l=2}p.eventPhase=l;h=e._capter;for(var g=0,b=h.length;g<b;++g){if(h[g]&&(r===h[g]._type)){h[g].handleEvent(p)}}if(p._stop){break}if(e===d){if(!s){break}l=3}e=e[l]}var k=p._default;p=d=h=n=e=l=f=g=b=r=i=s=c=q=void 0;return k};function EventListener(b,c,d){this._cap=b;this._type=c;this._listener=d}EventListener.prototype={handleEvent:function(b){try{var f=b.eventPhase,c=this._cap;if(f===1){c=c?false:true}if(!c&&(b.type===this._type)){this._listener(b)}b=f=c=void 0}catch(d){}}};function Event(){}Event.prototype={timeStamp:0,type:null,target:null,currentTarget:null,eventPhase:1,bubbles:false,cancelable:false,_stop:false,_default:true,stopPropagation:function(){this._stop=true},preventDefault:function(){if(this.cancelable){this._default=false;this.target.ownerDocument._window.event.returnValue=false}},initEvent:function(b,d,c){this.type=b;this.bubbles=d;this.cancelable=c;b=d=c=void 0}};Document.prototype.createEvent=function(d){var b=this._cevent[d],c=b?new b():(d==="SVGEvents")?new SVGEvent():(d==="TimeEvents")?new TimeEvent():new Event();c.type=d;c.timeStamp=+(new Date());b=d=void 0;return c};function UIEvent(){this.view;this.detail=0}UIEvent.prototype=Object._create(Event);UIEvent.prototype.initUIEvent=function(c,f,e,d,b){this.initEvent(c,f,e);this.detail=b;this.view=d};function MouseEvent(b){UIEvent.apply(this,arguments);this.screenX;this.screenY;this.clientX=this.clientY=0;this.ctrlKey=this.shiftKey=this.altKey=this.metaKey=false;this.button;this.relatedTarget}MouseEvent.prototype=Object._create(UIEvent);MouseEvent.prototype.initMouseEvent=function(q,e,o,f,i,l,g,b,k,h,r,d,p,j,c){this.initUIEvent(q,e,o,f,i);this.screenX=l;this.screenY=g;this.clientX=b;this.clientY=k;this.ctrlKey=h;this.shiftKey=d;this.altKey=r;this.metaKey=p;this.button=j;this.relatedTarget=c};function MutationEvent(){}MutationEvent.prototype=Object._create(Event);(function(){this.initMutationEvent=function(b,g,f,c,i,d,e,h){this.initEvent(b,g,f);this.relatedNode=c;this.prevValue=i;this.newValue=d;this.attrName=e;this.attrChange=h;b=g=f=c=i=d=e=h=void 0};this.relatedNode=null;this.prevValue=this.newValue=this.attrName=null;this.attrChange=2}).apply(MutationEvent.prototype);Element.prototype.setAttributeNodeNS=function(d){if(d.ownerDocument!==this.ownerDocument){throw (new DOMException(4))}var c=this.attributes.setNamedItemNS(d);d.ownerElement=this;if((d.localName==="id")&&!this.ownerDocument._id[d.nodeValue]){this.ownerDocument._id[d.nodeValue]=this}var b=this.ownerDocument.createEvent("MutationEvents");if(!c){b.initEvent("DOMAttrModified",true,false);b.relatedNode=d;b.newValue=d.nodeValue;b.attrName=d.nodeName}else{b.initMutationEvent("DOMAttrModified",true,false,d,c.nodeValue,d.nodeValue,d.nodeName,1)}this.dispatchEvent(b);b=void 0;return c};Node.prototype.insertBefore=function(c,d){var q=this.parentNode,h,r,e=this,f=0,u,v,p,o;while(q){if(q===c){throw (new DOMException(3))}q=q.parentNode}if(this.ownerDocument!==c.ownerDocument){throw (new DOMException(4))}if(c.parentNode){c.parentNode.removeChild(c)}if(!d){if(!this.firstChild){this.firstChild=c}if(this.lastChild){c.previousSibling=this.lastChild;this.lastChild.nextSibling=c}this.lastChild=c;this.childNodes.push(c);c.nextSibling=null}else{if(d.parentNode!==this){throw (new DOMException(8))}u=this.firstChild;if(u===d){this.firstChild=c}while(u){if(u===d){this.childNodes.splice(f,1,c,d);break}++f;u=u.nextSibling}h=d.previousSibling;if(h){h.nextSibling=c}d.previousSibling=c;c.previousSibling=h;c.nextSibling=d}c.parentNode=this;if((c.nodeType===5)||(c.nodeType===11)){var b=c.childNodes.concat([]);for(var g=0,l=b.length;g<l;g++){this.insertBefore(b[g],c)}b=void 0}r=this.ownerDocument.createEvent("MutationEvents");r.initMutationEvent("DOMNodeInserted",true,false,this,null,null,null,null);c.dispatchEvent(r);do{v=e;e=e.parentNode}while(e);if(v!==this.ownerDocument.documentElement){r=p=q=h=e=v=o=void 0;return c}r=this.ownerDocument.createEvent("MutationEvents");r.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);c.dispatchEvent(r);if(!c.hasChildNodes()){return c}if(c.getElementsByTagNameNS){p=c.getElementsByTagNameNS("*","*")}else{p=c.childNodes}if(p){for(var g=0,k=p.length;g<k;++g){o=p[g];o.dispatchEvent(r);o=null}}r=p=q=h=f=u=e=v=o=void 0;return c};Node.prototype.removeChild=function(k){if(!(k instanceof Node)){throw (new Error())}if(k.parentNode!==this){throw (new DOMException(8))}if(k.ownerDocument!==this.ownerDocument){throw (new Error())}var b=this.ownerDocument.createEvent("MutationEvents"),f;b.initMutationEvent("DOMNodeRemovedFromDocument",false,false,null,null,null,null,null);k.dispatchEvent(b);if(k.getElementsByTagNameNS){f=k.getElementsByTagNameNS("*","*")}else{f=k.childNodes}if(f){b.initMutationEvent("DOMNodeRemovedFromDocument",false,false,null,null,null,null,null);for(var e=0,h=f.length;e<h;++e){var g=f[e];b.target=g;g.dispatchEvent(b);g=void 0}}b.initMutationEvent("DOMNodeRemoved",true,false,this,null,null,null,null);k.dispatchEvent(b);b=f=void 0;k.parentNode=null;var d=this.firstChild,c=0;while(d){if(d===k){this.childNodes.splice(c,1);break}++c;d=d.nextSibling}if(this.firstChild===k){this.firstChild=k.nextSibling}if(this.lastChild===k){this.lastChild=k.previousSibling}k.previousSibling&&(k.previousSibling.nextSibling=k.nextSibling);k.nextSibling&&(k.nextSibling.previousSibling=k.previousSibling);k.nextSibling=k.previousSibling=null;d=c=void 0;return k};CharacterData.prototype.appendData=function(b){var d=this.data,c;this.data+=b;this.length=this.data.length;c=this.ownerDocument.createEvent("MutationEvents");c.initMutationEvent("DOMCharacterDataModified",true,false,null,d,this.data,null,null);this.parentNode.dispatchEvent(c);c=b=d=void 0};CharacterData.prototype.insertData=function(g,b){var d=this.data,f=this.substring(0,g-1),e=this.substring(g,this.length-g),c;this.data=f+this.data+e;this.length=this.data.length;c=this.ownerDocument.createEvent("MutationEvents");c.initMutationEvent("DOMCharacterDataModified",true,false,null,d,this.data,null,null);this.parentNode.dispatchEvent(c);c=b=d=f=e=void 0};CharacterData.prototype.deleteData=function(d,c){var b=this.data;pre=this.substring(0,d-1),next=this.substring(d+c,this.length-1),evt;if(d+c>this.length){next=""}this.data=pre+next;this.length=this.data.length;evt=this.ownerDocument.createEvent("MutationEvents");evt.initMutationEvent("DOMCharacterDataModified",true,false,null,b,this.data,null,null);this.parentNode.dispatchEvent(evt);evt=b=void 0};Document.prototype._cevent={MutationEvents:MutationEvent,MouseEvents:MouseEvent,UIEvents:UIEvent};function StyleSheet(){this.type="text/css";this.disabled=false;this.ownerNode=null;this.parentStyleSheet=null;this.href=null;this.title="";this.media=new MediaList()}function MediaList(){this.mediaText="";this.length=0}MediaList.prototype={item:function(b){return(this[b])},deleteMedium:function(b){for(var c=0,d=this.length;c<d;++c){if(this[c]===b){delete this[c];--this.length;return}}throw (new DOMException(DOMException.NOT_FOUND_ERR))},appendMedium:function(b){this[this.length]=b;++this.length}};function LinkStyle(){this.sheet=new StyleSheet()}function DocumentStyle(){this.styleSheets=[]}function CSSRule(){this.cssText="";this.parentStyleSheet;this.parentRule=null}function CSSStyleRule(){CSSRule.call(this);this.type=1;this.selectorText="";this.style=new CSSStyleDeclaration();this.style.parentRule=null}CSSStyleRule.prototype=Object._create(CSSRule);function CSSMediaRule(){CSSRule.call(this);this.type=4;this.media=new MediaList();this.cssRules=[]}CSSMediaRule.prototype=Object._create(CSSRule);CSSMediaRule.prototype.insertRule=function(c,b){this.cssRules.splice(b,c,1);this.media.appendMedium(c);return this};CSSMediaRule.prototype.deleteRule=function(b){};function CSSFontFaceRule(){CSSRule.call(this);this.type=5;this.style}CSSFontFaceRule.prototype=Object._create(CSSRule);function CSSPageRule(){CSSRule.call(this);this.type=6;this.selectorText="";this.style}CSSPageRule.prototype=Object._create(CSSRule);function CSSImportRule(){CSSRule.call(this);this.type=3;this.href="";this.media=new MediaList();this.styleSheet=null}CSSImportRule.prototype=Object._create(CSSRule);function CSSCharsetRule(){CSSRule.call(this);this.type=2;this.encoding=""}CSSCharsetRule.prototype=Object._create(CSSRule);function CSSUnknownRule(){CSSRule.call(this);this.type=0}CSSUnknownRule.prototype=Object._create(CSSRule);function CSSStyleDeclaration(){this._list=[];this._list._fontSize=this._list._opacity=null}CSSStyleDeclaration.prototype={cssText:"",length:0,parentRule:null,_urlreg:/url\(#([^)]+)/,getPropertyValue:function(c){var d=this.getPropertyCSSValue(c);if(d){var b=d.cssText;return(b.slice(b.indexOf(":")+1))}else{return""}},getPropertyCSSValue:function(d){var h=d,f,b;d+=":";if(d===":"){return null}for(var e=0,c=this._list,g=c.length;e<g;++e){f=c[e];b=f.cssText;if(b.indexOf(d)>-1){f._empercents=c._fontSize;e=c=g=b=h=d=void 0;return f}}e=c=g=h=d=void 0;return null},removeProperty:function(b){var c=this.getPropertyCSSValue(b);if(c){this._list.splice(c._num,1);--this.length}},getPropertyPriority:function(b){var c=this.getPropertyCSSValue(b);if(c){return(c._priority)}else{return""}},_isFillStroke:{fill:1,stroke:1},_isColor:{color:1},_isStop:{"stop-color":1},_isRS:{r:1,"#":1},setProperty:function(g,k,j){var e=g,c=null,b,i,d=null,f=null,o,l,h;if(this[g]){c=this.getPropertyCSSValue(g)}e+=":";e+=k;if(this._isFillStroke[g]){b=c?c:new SVGPaint();i=(this._isRS[k.charAt(0)]||b._keywords[k])?1:(k==="none")?101:(this._urlreg.test(k))?107:(k==="currentColor")?102:0;if(i===1){f=k}else{if(i===107){d=RegExp.$1}}b.setPaint(i,d,f,null);i=d=f=void 0}else{if(this._isStop[g]){b=c?c:new SVGColor();if(k==="currentColor"){b.colorType=3}else{b.colorType=1;b.setRGBColor(k)}}else{b=c?c:new CSSPrimitiveValue()}}b._priority=j;b.cssText=e;if(!c){b._num=this._list.length;this._list[b._num]=b;this[g]=1;++this.length}if(k==="inherit"){b.cssValueType=0}else{if(g==="opacity"){this._list._opacity=+k}else{if(g==="font-size"){if(/(%|em|ex)/.test(k)){c="_"+RegExp.$1;b[c]=parseFloat(k)}else{this._em=this._ex=this["_%"]=null;this._list._fontSize=parseFloat(k)}}}}e=b=c=void 0},item:function(b){if(b>=this.length){var c=""}else{var c=this._list[b].cssText.substring(0,this._list[b].cssText.indexOf(":"))}return c}};function CSSValue(){}CSSValue.prototype={cssText:"",cssValueType:3,_isDefault:0};function CSSPrimitiveValue(){}(function(b){b.prototype=Object._create(CSSValue)})(CSSPrimitiveValue);(function(){this._n=[1,0.01,1,1,1,35.43307,3.543307,90,1.25,15,1,180/Math.PI,90/100,1,1000,1,1000,1];this.cssValueType=1;this.primitiveType=0;this._value=null;this._percent=0;this._empercent=0;this._em=this._ex=this["_%"]=null;this.setFloatValue=function(b,c){if((0>=b)&&(b>=19)){throw new DOMException(15)}this.primitiveType=b;this._value=c*this._n[b-1]};this._regd=/[\d\.]+/;this.getFloatValue=function(c){if((0>=c)&&(c>=19)){throw new DOMException(15)}if(this._value||(this._value===0)){return(this._value/this._n[c-1])}else{var b=this.cssText,f=b.slice(-1),e=0,d=+(b.match(this._regd));d=isNaN(d)?0:d;if(f>="0"&&f<="9"){e=1;if(c===1){c=b=f=e=void 0;return d}}else{if(f==="%"){d*=this._percent;e=2}else{if((f==="m")&&(b.charAt(b.length-2)==="e")){d*=this._empercent;e=3}else{if((f==="x")&&(b.charAt(b.length-2)==="e")){e=4}else{if((f==="x")&&(b.charAt(b.length-2)==="p")){e=5}else{if((f==="m")&&(b.charAt(b.length-2)==="c")){e=6}else{if((f==="m")&&(b.charAt(b.length-2)==="m")){e=7}else{if(f==="n"){e=8}else{if(f==="t"){e=9}else{if(f==="c"){e=10}}}}}}}}}}d=d*this._n[e-1]/this._n[c-1];b=f=e=c=void 0;return d}};this.setStringValue=function(c,b){if(18>=c&&c>=23){throw new DOMException(15)}this._value=b};this.getStringValue=function(b){if(18>=b&&b>=23){throw new DOMException(15)}return(this._value)};this.getCounterValue=function(){if(this.primitiveType!==23){throw new DOMException(15)}return(new Counter())};this.getRectValue=function(){if(this.primitiveType!==24){throw new DOMException(15)}return(new Rect())};this.getRGBColorValue=function(){if(this.primitiveType!==25){throw new DOMException(15)}var b=new RGBColor(),c=this.cssText,d=SVGColor.prototype._keywords[c];if(c.indexOf("%",5)>0){c=c.replace(/[\d.]+%/g,function(e){return Math.round((2.55*parseFloat(e)))})}else{if(c.indexOf("#")>-1){c=c.replace(/[\da-f][\da-f]/gi,function(e){return parseInt(e,16)})}}d=d||c.match(/\d+/g);b.red.setFloatValue(1,parseFloat(d[0]));b.green.setFloatValue(1,parseFloat(d[1]));b.blue.setFloatValue(1,parseFloat(d[2]));d=c=void 0;return(b)}}).apply(CSSPrimitiveValue.prototype);function CSSValueList(){this.cssValueType=2;this.length=0}CSSValueList.prototype=Object._create(CSSValue);CSSValueList.prototype.item=function(b){return(this[b])};function RGBColor(){var b=CSSPrimitiveValue;this.red=new b();this.green=new b();this.blue=new b();b=void 0;this.red.primitiveType=this.green.primitiveType=this.blue.primitiveType=1}function Rect(){var b=CSSPrimitiveValue;this.top=new b();this.right=new b();this.bottom=new b();this.left=new b();b=void 0}function Counter(){this.identifier=this.listStyle=this.separator=""}function ElementCSSInlineStyle(){var b=CSSStyleDeclaration;this.style=new b();this._attributeStyle=new b();b=void 0}var n="none",m="normal",a="auto",CSS2Properties={fill:"black",stroke:n,cursor:a,visibility:"visible",display:"inline-block",opacity:"1",fillOpacity:"1",strokeWidth:"1",strokeDasharray:n,strokeDashoffset:"0",strokeLinecap:"butt",strokeLinejoin:"miter",strokeMiterlimit:"4",strokeOpacity:"1",writingMode:"lr-tb",fontFamily:"serif",fontSize:"12",color:"black",fontSizeAdjust:n,fontStretch:m,fontStyle:m,fontVariant:m,fontWeight:m,font:"inline",stopColor:"black",stopOpacity:"1",textAnchor:"start",azimuth:"center",clip:a,direction:"ltr",letterSpacing:m,lineHeight:m,overflow:"visible",textAlign:"left",textDecoration:n,textIndent:"0",textShadow:n,textTransform:n,unicodeBidi:m,verticalAlign:"baseline",whiteSpace:m,wordSpacing:m,zIndex:a,mask:n,markerEnd:n,markerMid:n,markerStart:n,fillRule:"nonzero",enableBackground:"accumulate",filter:n,floodColor:"black",floodOpacity:"1",lightingColor:"white",pointerEvents:"visiblePainted",colorInterpolation:"sRGB",colorInterpolationFilters:"linearRGB",colorProfile:a,colorRendering:a,imageRendering:a,marker:"",shapeRendering:a,textRendering:a,alignmentBaseline:"",baselineShift:"baseline",dominantBaseline:a,glyphOrientationHorizontal:"0deg",glyphOrientationVertical:a,kerning:a};n=m=a=void 0;CSS2Properties.visibility._n=1;function CSSStyleSheet(){StyleSheet.apply(this);this.ownerRule=null;this.cssRules=[]}CSSStyleSheet.prototype=Object._create(StyleSheet);CSSStyleSheet.prototype.insertRule=function(g,e){var k=new CSSStyleRule(),b=k.style,h,f=g.match(/\{[\s\S]+\}/),c;k.parentStyleSheet=this;b.cssText=g;f=f.replace(/^[^a-z\-]+/,"").replace(/\:\s+/g,":").replace(/\s*;[^a-z\-]*/g,";");h=f.split(";");for(var d=0,j=h.length;d<j;++d){ai=h[d],c=ai.split(":");if(ai!==""){b.setProperty(c[0],c[1])}ai=c=void 0}h=f=b=void 0;this.cssRules.splice(e,k,1)};CSSStyleSheet.prototype.deleteRule=function(b){this.cssRules.splice(b,1)};Document.prototype.defaultView=new ViewCSS();function ViewCSS(){}ViewCSS.prototype.getComputedStyle=function(c,g){var e=new CSSStyleDeclaration(),d,f,b=1;e.getPropertyCSSValue=(function(h,i){return function(j){var p=h,o=null,q;while(p&&(!o||(o.cssValueType===0))){if(p._runtimeStyle&&p._runtimeStyle[j]){o=p._runtimeStyle.getPropertyCSSValue(j)}else{if(p.style&&p.style[j]){o=p.style.getPropertyCSSValue(j)}else{if(p._attributeStyle&&p._attributeStyle[j]){o=p._attributeStyle.getPropertyCSSValue(j)}else{if(p._rules){for(var l=0,k=p._rules.length;l<k;++l){p._rules[l].style[j]&&(o=p._rules[l].style.getPropertyCSSValue(j))}}}}}p=p.parentNode}if(!o||(o.cssValueType===0)){i&&(o=i[j])}if(o&&o.setRGBColor&&((o.paintType===102)||(o.colorType===3))){o.setRGBColor(this.getPropertyValue("color"))}else{if(o&&(o._em||o._ex||o["_%"])){p=h;q=1;while(p){if(p.style._list._fontSize){q=p.style._list._fontSize;break}p=p.parentNode}if(o._em){q*=o._em}else{if(o._ex){q*=o._ex*0.5}else{if(o["_%"]){q*=o["_%"]/100}}}o.cssText="font-size:"+q+"px"}}p=void 0;return o}})(c,this._defaultCSS);d=c;while(d){if(d.style){f=d.style._list._opacity||d._attributeStyle._list._opacity;b*=f||1}d=d.parentNode}e._list._opacity=b;d=pelt=b=f=void 0;e._document=c.ownerDocument;return e};Document.prototype.getOverrideStyle=function(c,f){var b=c;if(!!b._runtimeStyle){return(b._runtimeStyle)}else{var e=new CSSStyleDeclaration(),d=e.setProperty;b._runtimeStyle=e}e.setProperty=(function(g,h){return function(r,u,t){g.call(h,r,u,t);var p=c,j=p._tar,o=false,q=false;if((p.localName==="g")||(p.localName==="a")){var k=p.getElementsByTagNameNS("http://www.w3.org/2000/svg","*");if(k){for(var l=0,v=k.length;l<v;++l){var s=k[l];s.getScreenCTM&&NAIBU._setPaint(s,s.getScreenCTM());s=void 0}k=void 0}j=null}if(!j){return}p.getScreenCTM&&NAIBU._setPaint(p,p.getScreenCTM());j=p=u=void 0}})(d,e);return e};DOMImplementation.createCSSStyleSheet=function(h,g){var f=new CSSStyleSheet();f.title=h;var b=new MediaList();b.mediaText=g;if(g&&(g!=="")){var c=g.split(",");for(var e=0,d=c.length;e<d;++e){b.appendMedium(c[e])}}f.media=b;return f};function TimeEvent(){Event.apply(this);this.view;this.detail}TimeEvent.counstructor=Event;TimeEvent.prototype=Object._create(Event);TimeEvent.prototype.initTimeEvent=function(c,d,b){this.type=c;this.view=d;this.detail=b};var NAIBU={};function SVGException(b){this.code=b;this.message=(this.code===0)?"SVG Wrong Type Error":(this.code===1)?"SVG Invalid Value Error":(this.code===2)?"SVG　Matrix Not Invertable":""}SVGException.prototype=Object._create(Error);function SVGElement(){Element.call(this);SVGStylable.call(this);this.transform=new SVGAnimatedTransformList();this.addEventListener("DOMAttrModified",function(evt){if(evt.eventPhase===3){return}var name=evt.attrName,tar=evt.target,evn=evt.newValue;if(!!CSS2Properties[name]||(name.indexOf("-")>-1)){tar._attributeStyle.setProperty(name,evn,"")}if(evt.relatedNode.localName==="id"){tar.id=evn}else{if((name==="transform")&&!!tar.transform){var degR=tar._degReg,coma=evn.match(tar._comaReg),list=evn.match(tar._strReg),a,b,c,d,e,f,lis,com,deg,rad,degli,s,cm,degz,etod=tar.ownerDocument.documentElement,ttb=tar.transform.baseVal;for(var j=0,cli=coma.length;j<cli;j++){s=etod.createSVGTransform();lis=list[j],com=coma[j];deg=lis.match(degR);degli=deg.length;if(degli===6){cm=s.matrix;cm.a=+(deg[0]);cm.b=+(deg[1]);cm.c=+(deg[2]);cm.d=+(deg[3]);cm.e=+(deg[4]);cm.f=+(deg[5])}else{if(degli===3){degz=+(deg[0]);s.setRotate(degz,+(deg[1]),+(deg[2]))}else{if(degli<=2){degz=+(deg[0]);if(com==="translate"){s.setTranslate(degz,+(deg[1]||0))}else{if(com==="scale"){s.setScale(degz,+(deg[1]||deg[0]))}else{if(com==="rotate"){s.setRotate(degz,0,0)}else{if(com==="skewX"){s.setSkewX(degz)}else{if(com==="skewY"){s.setSkewY(degz)}}}}}}}}ttb.appendItem(s)}degR=coma=list=a=b=c=d=e=f=lis=com=deg=rad=degli=s=cm=degz=etod=ttb=void 0}else{if(name==="style"){var style=tar.style,a,ai,m;style.cssText=evn;if(evn!==""){a=evn.replace(tar._shouReg,"").replace(tar._conReg,":").replace(tar._bouReg,";").split(";");for(var i=0,ali=a.length;i<ali;++i){ai=a[i],m=ai.split(":");if(ai!==""){style.setProperty(m[0],m[1])}ai=m=void 0}}a=style=void 0}else{if(name==="class"){tar.className.baseVal=evn}else{if(name.indexOf("on")===0){NAIBU._temp_doc=tar.ownerDocument;NAIBU.eval("with(NAIBU._temp_doc){document._s = function(evt){"+evn+"}}");var v=name.slice(2);v=(v==="load")?"SVGLoad":(v==="unload")?"SVGUnload":(v==="abort")?"SVGAbort":(v==="error")?"SVGError":(v==="resize")?"SVGResize":(v==="scroll")?"SVGScroll":(v==="zoom")?"SVGZoom":(v==="begin")?"beginEvent":(v==="end")?"endEvent":(v==="repeat")?"repeatEvent":v;tar.addEventListener(v,document._s,false)}else{if(evt.relatedNode.nodeName==="xml:base"){tar.xmlbase=evn}else{if(!!tar[name]&&(tar[name] instanceof SVGAnimatedLength)){var tea=tar[name],tod=tar.nearestViewportElement||tar.ownerDocument.documentElement,tvw=tod.viewport.width,tvh=tod.viewport.height,s,n=evn.slice(-2),m=n.charAt(1),_parseFloat=parseFloat,type=(m>="0"&&m<="9")?1:(m==="%")?2:(n==="em")?3:(n==="ex")?4:(n==="px")?5:(n==="cm")?6:(n==="mm")?7:(n==="in")?8:(n==="pt")?9:(n==="pc")?10:1;if(type===2){if(tar._x1width[name]){tea.baseVal._percent=tvw*0.01}else{if(tar._y1height[name]){tea.baseVal._percent=tvh*0.01}else{tea.baseVal._percent=Math.sqrt((tvw*tvw+tvh*tvh)/2)*0.01}}}s=_parseFloat(evn);s=isNaN(s)?0:s;tea.baseVal.newValueSpecifiedUnits(type,s);tea=tod=tvw=tvh=n=type=_parseFloat=s=void 0}}}}}}}evt=_parseFloat=evn=name=tar=v=null},false)}SVGElement.prototype=Object._create(Element);SVGElement.prototype._inserted__=function(b){var f=b.nextSibling,e=b._tar,c=b.parentNode._tar,d=null;if(e&&c){if(!f){c.appendChild(e)}else{while(f){if(f._tar&&f._tar.parentNode){d=f._tar;break}f=f.nextSibling}d&&(c=d.parentNode);c.insertBefore(e,d)}}f=e=c=d=void 0};NAIBU.eval=function(c){var d=document,b=d.createElement("script");b.text=c;(d.documentElement||d.body).appendChild(b)};(function(){this._degReg=/[\-\d\.e]+/g;this._comaReg=/[A-Za-z]+(?=\s*\()/g;this._strReg=/\([^\)]+\)/g;this._syouReg=/^[^a-z\-]+/;this._conReg=/\:\s+/g;this._bouReg=/\s*;[^a-z\-]*/g;this._cacheMatrix=null;this._x1width={x:1,x1:1,x2:1,width:1,cx:1};this._y1height={y:1,y1:1,y2:1,height:1,cy:1};this.id=null;this.xmlbase=null;this.ownerSVGElement;this.viewportElement;this.nearestViewportElement=null;this.farthestViewportElement=null;this.getBBox=function(){var p=new SVGRect(),e=this._tar.path.value,c=this.ownerDocument.documentElement.viewport,b=c.width,k=c.height,o=0,h=0,l=e.match(/[0-9\-]+/g),g,f;for(var d=0,j=l.length;d<j;d+=2){g=+(l[d]),f=+(l[d+1]);b=b>g?g:b;k=k>f?f:k;o=o>g?o:g;h=h>f?h:f}p.x=b;p.y=k;p.width=o-b;p.height=h-k;g=f=e=l=b=k=o=h=c=void 0;return p};this.getCTM=function(){var c,b;if(this._cacheMatrix){c=this._cacheMatrix}else{b=this.transform.baseVal.consolidate();if(b){b=b.matrix}else{b=this.ownerDocument.documentElement.createSVGMatrix()}if(this.parentNode&&!!this.parentNode.getCTM){c=this.parentNode.getCTM().multiply(b)}else{c=b}b=void 0;this._cacheMatrix=c}return c};this.getScreenCTM=function(){if(!this.parentNode){return null}return((this.nearestViewportElement||this.ownerDocument.documentElement).getScreenCTM().multiply(this.getCTM()))};this.getTransformToElement=function(b){var c=this.getScreenCTM().inverse().multiply(b.getScreenCTM());return c}}).apply(SVGElement.prototype);function SVGAnimatedBoolean(){this.animVal=this.baseVal=true}function SVGAnimatedString(){this.animVal=this.baseVal=""}function SVGStringList(){}SVGStringList.prototype=Object._create(Array);(function(){this.numberOfItems=0;this.clear=function(){for(var b=0,c=this.length;b<c;++b){delete this[b]}this.numberOfItems=0};this.initialize=function(b){this.clear();this[0]=b;this.numberOfItems=1;return b};this.getItem=function(b){if(b>=this.numberOfItems||b<0){throw (new DOMException(1))}else{return(this[b])}};this.insertItemBefore=function(c,b){if(b>=this.numberOfItems){this.appendItem(c)}else{this.splice(b,1,c,this.getItem[b]);++this.numberOfItems}return c};this.replaceItem=function(c,b){if(b>=this.numberOfItems||b<0){throw (new DOMException(1))}else{this.splice(b,1,c)}return c};this.removeItem=function(b){if(b>=this.numberOfItems||b<0){throw (new DOMException(1))}else{this.splice(b,1);--this.numberOfItems}return newItem};this.appendItem=function(b){this[this.numberOfItems]=b;++this.numberOfItems}}).apply(SVGStringList.prototype);function SVGAnimatedEnumeration(){this.baseVal=0;this.animVal=0}function SVGAnimatedInteger(){this.baseVal=0;this.animVal=0}function SVGNumber(){this.value=0}function SVGAnimatedNumber(){this.baseVal=this.animVal=0}function SVGNumberList(){}function SVGAnimatedNumberList(){this.animVal=this.baseVal=new SVGNumberList()}function SVGLength(){}SVGLength.prototype={unitType:0,value:0,valueInSpecifiedUnits:0,valueAsString:"0",_percent:0.01,_fontSize:12,newValueSpecifiedUnits:function(b,d){var e=1,c="";if(b===1){}else{if(b===5){c="px"}else{if(b===2){e=this._percent;c="%"}else{if(b===3){e=this._fontSize;c="em"}else{if(b===4){e=this._fontSize*0.5;c="ex"}else{if(b===6){e=35.43307;c="cm"}else{if(b===7){e=3.543307;c="mm"}else{if(b===8){e=90;c="in"}else{if(b===9){e=1.25;c="pt"}else{if(b===10){e=15;c="pc"}else{throw new DOMException(9)}}}}}}}}}}this.unitType=b;this.value=d*e;this.valueInSpecifiedUnits=d;this.valueAsString=d+c;d=b=e=c=void 0},convertToSpecifiedUnits:function(c){if(this.value===0){this.newValueSpecifiedUnits(c,0);return}var b=this.value;this.newValueSpecifiedUnits(c,this.valueInSpecifiedUnits);b=b/this.value*this.valueInSpecifiedUnits;this.newValueSpecifiedUnits(c,b)},_emToUnit:function(b){if((this.unitType===3)||(this.unitType===4)){this._fontSize=b;this.newValueSpecifiedUnits(this.unitType,this.valueInSpecifiedUnits)}}};function SVGAnimatedLength(){this.animVal;this.baseVal=new SVGLength();this.baseVal.unitType=1}function SVGLengthList(){}function SVGAnimatedLengthList(){this.animVal=this.baseVal=new SVGLengthList()}function SVGAngle(){}SVGAngle.prototype={unitType:0,value:0,valueInSpecifiedUnits:0,valueAsString:"0",newValueSpecifiedUnits:function(b,d){var e=1,c="";if(b===1){}else{if(b===2){c="deg"}else{if(b===3){e=Math.PI/180;c="rad"}else{if(b===4){e=9/10;c="grad"}else{throw new DOMException(9)}}}}this.unitType=b;this.value=d*e;this.valueInSpecifiedUnits=d;this.valueAsString=d+c;e=c=void 0},convertToSpecifiedUnits:function(c){if(this.value===0){this.newValueSpecifiedUnits(c,0);return}var b=this.value;this.newValueSpecifiedUnits(c,this.valueInSpecifiedUnits);b=b/this.value*this.valueInSpecifiedUnits;this.newValueSpecifiedUnits(c,b)}};function SVGAnimatedAngle(){this.baseVal=new SVGAngle();this.animVal=this.baseVal}function SVGColor(){CSSValue.apply(this);this.rgbColor=new RGBColor()}SVGColor.prototype=Object._create(CSSValue);(function(){this.colorType=0;this.iccColor=null;this._regD=/\d+/g;this._regDP=/[\d.]+%/g;this._exceptionsvg=1;this.setRGBColor=function(i){var e,d,h,f,c;if(!i||(typeof i!=="string")){throw new SVGException(this._exceptionsvg)}e=this._keywords[i];if(e){}else{if(i.indexOf("%",5)>0){i=i.replace(this._regDP,function(b){return Math.round((2.55*parseFloat(b)))});e=i.match(this._regD)}else{if(i.indexOf("#")===0){e=[];d=parseInt;if(i.length<5){h=i.charAt(1);f=i.charAt(2);c=i.charAt(3);i="#"+h+h+f+f+c+c}e[0]=d(i.slice(1,3),16)+"";e[1]=d(i.slice(3,5),16)+"";e[2]=d(i.slice(5,7),16)+"";h=f=c=void 0}else{e=i.match(this._regD);if(!e||(e.length<3)){i=void 0;throw new SVGException(this._exceptionsvg)}}}}i=this.rgbColor;i.red.setFloatValue(1,e[0]);i.green.setFloatValue(1,e[1]);i.blue.setFloatValue(1,e[2]);i=e=d=void 0};this.setColor=function(b,c,d){this.colorType=b;if((b===1)&&d){throw new SVGException(this._exceptionsvg)}else{if(b===1){this.setRGBColor(c)}else{if(c&&(b===3)){this.setRGBColor(c)}else{if((b===0)&&(c||d)){throw new SVGException(this._exceptionsvg)}else{if((b===2)&&(c||!d)){throw new SVGException(this._exceptionsvg)}}}}}b=c=void 0};this._keywords={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],grey:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagree:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]}}).apply(SVGColor.prototype);function SVGRect(){this.x=0;this.y=0;this.width=0;this.height=0}function SVGAnimatedRect(){this.animVal=this.baseVal=new SVGRect()}function SVGStylable(){this.className=new SVGAnimatedString();this.style=new CSSStyleDeclaration();this._attributeStyle=new CSSStyleDeclaration()}SVGElement.prototype.getPresentationAttribute=function(b){var c=this._attributeStyle.getPropertyCSSValue(b);if(c){return c}else{return null}};function SVGURIReference(){this.href=new SVGAnimatedString();this._instance=null;this._text="";this.addEventListener("DOMAttrModified",function(b){if((b.relatedNode.namespaceURI==="http://www.w3.org/1999/xlink")&&(b.attrName==="xlink:href")){b.target.href.baseVal=b.newValue;b.target.ownerDocument.documentElement._svgload_limited++}b=void 0},false);this.addEventListener("DOMNodeInserted",function(c){var b=c.target;if(c.eventPhase===3){return}b.addEventListener("DOMNodeInsertedIntoDocument",function(k){var r=k.target,g=location.href,s=r.href.baseVal,z=r.ownerDocument,d=z.URL,f=/\.+\//g,q=/\/[^\/]+?(\/[^\/]*?)$/,l,u,e,w,v,h,A,o,p,j,t,i;if(s!==""){e=r.xmlbase;if(!e){w=r.parentNode;v=null;while(!v&&w){v=w.xmlbase;w=w.parentNode}e=v}l=function(B,C){if(s.indexOf(":")>-1){h=s}else{if(B.indexOf(":")>-1){C=B}else{f.lastIndex=0;while(f.exec(B)){C=C.replace(q,"$1")}C=C.replace(/\/[^\/]+?$/,"/");C=C+B.replace(f,"")}}return C};g=l(d,g);if(e){g=l(e,g)}if(s.indexOf("#")===0){h=s}else{if(!h){g=g.replace(/\/[^\/]+?$/,"/");f.lastIndex=0;while(f.exec(s)){g=g.replace(q,"$1")}h=g+s.replace(f,"")}}u=r.getAttributeNS("http://www.w3.org/1999/xlink","show")||"embed";if(u==="replace"){r._tar.setAttribute("href",h)}else{if(u==="new"){r._tar.setAttribute("target","_blank");r._tar.setAttribute("href",h)}else{if(u==="embed"){A=NAIBU.xmlhttp;o=h.indexOf("#");if(o>-1){p=h.slice(o+1);h=h.replace(/#.+$/,"")}else{p=null}if(s.indexOf("#")===0){j=z.getElementById(p);r._instance=j;i=SVGURIReference;SVGURIReference=function(){};t=z.createEvent("SVGEvents");t.initEvent("S_Load",false,false);r.dispatchEvent(t);SVGURIReference=i;A=void 0}else{if(h.indexOf("data:")>-1){r._tar.src=h;A=void 0}else{if((h.indexOf("http:")>-1)){if((r.localName==="image")&&(h.indexOf(".svg")===-1)){r._tar.src=h}else{r.ownerDocument.documentElement._svgload_limited++;A.open("GET",h,true);A.setRequestHeader("X-Requested-With","XMLHttpRequest");A.onreadystatechange=function(){if((A.readyState===4)&&(A.status===200)){var B=A.getResponseHeader("Content-Type")||"text",F,H,D,C,E,G;if((B.indexOf("text")>-1)||(B.indexOf("xml")>-1)||(B.indexOf("script")>-1)){if(r.localName!=="script"&&r.localName!=="style"){F=new ActiveXObject("MSXML2.DomDocument");H=A.responseText.replace(/!DOCTYPE/,"!--").replace(/(dtd">|\]>)/,"-->");E=NAIBU.doc;E.async=E.validateOnParse=E.resolveExternals=E.preserveWhiteSpace=false;F.loadXML(H);D=F.documentElement;G=SVGURIReference;SVGURIReference=function(){};r._instance=r.ownerDocument.importNode(D,true);SVGURIReference=G;if(p){r._instance=r._instance.ownerDocument.getElementById(p)}}else{r._text=A.responseText}}else{if(!!r._tar){r._tar.src=h}}C=r.ownerDocument.createEvent("SVGEvents");C.initEvent("S_Load",false,false);r.dispatchEvent(C);r.ownerDocument.documentElement._svgload_limited--;if(r.ownerDocument.documentElement._svgload_limited<0){C=r.ownerDocument.createEvent("SVGEvents");C.initEvent("SVGLoad",false,false);r.ownerDocument.documentElement.dispatchEvent(C)}B=F=H=C=G=E=void 0;A.onreadystatechange=NAIBU.emptyFunction;A=void 0}};A.send(null)}}}}}}}r.ownerDocument.documentElement._svgload_limited--;r=void 0}k=g=s=e=l=w=d=v=f=h=o=p=z=j=t=u=i=void 0},false);b=c=void 0},false)}function SVGCSSRule(){CSSRule.apply(this);this.COLOR_PROFILE_RULE=7}SVGCSSRule.prototype=Object._create(CSSRule);function SVGDocument(){Document.apply(this);DocumentStyle.apply(this);this.title="";this.referrer=document.referrer;this.domain=document.domain;this.URL=document.location;this.rootElement}SVGDocument.prototype=Object._create(Document);SVGDocument.prototype._domnodeEvent=function(){var b=this.createEvent("MutationEvents");b.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);return b};function SVGSVGElement(c){SVGElement.apply(this,arguments);c&&(this._tar=c.createElement("v:group"));c=void 0;this._svgload_limited=0;var b=SVGAnimatedLength;this.x=new b();this.y=new b();this.width=new b();this.height=new b();b=void 0;this.contentScriptType="application/ecmascript";this.contentStyleType="text/css";this.viewport=this.createSVGRect();this.useCurrentView=false;this.currentView=new SVGViewSpec(this);this.currentScale=1;this.currentTranslate=this.createSVGPoint();this.viewBox=this.currentView.viewBox;this.preserveAspectRatio=this.currentView.preserveAspectRatio;this.zoomAndPan=1;this._tx=0;this._ty=0;this._currentTime=0;this.addEventListener("DOMAttrModified",function(l){if(l.eventPhase===3){return}var g=l.target,e=l.attrName,f,k,h,i,j,d;if(e==="viewBox"){g._cacheScreenCTM=null;f=g.viewBox.baseVal;k=l.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/);f.x=parseFloat(k[0]);f.y=parseFloat(k[1]);f.width=parseFloat(k[2]);f.height=parseFloat(k[3]);g.viewBox.baseVal._isUsed=1}else{if(e==="preserveAspectRatio"){g._cacheScreenCTM=null;h=l.newValue;i=g.preserveAspectRatio.baseVal;j=1;d=0;if(!!h.match(/x(Min|Mid|Max)Y(Min|Mid|Max)(?:\s+(meet|slice))?/)){switch(RegExp.$1){case"Min":j+=1;break;case"Mid":j+=2;break;case"Max":j+=3;break}switch(RegExp.$2){case"Min":break;case"Mid":j+=3;break;case"Max":j+=6;break}if(RegExp.$3==="slice"){d=2}else{d=1}}i.align=j;i.meetOrSlice=d}else{if(e==="width"){g.viewport.width=g.width.baseVal.value}else{if(e==="height"){g.viewport.height=g.height.baseVal.value}}}}l=e=f=k=h=i=j=d=void 0},false);this.addEventListener("DOMNodeInserted",function(e){if(e.eventPhase===2){var d=e.target;d.addEventListener("DOMNodeInserted",function(f){if(f.eventPhase===1){f.target.nearestViewportElement=d}},true);d._getCTM=d.getCTM;d.getCTM=function(){if(!this._cacheMatrix){var f=this.getScreenCTM(),g=this.ownerDocument.defaultView.getComputedStyle(this,""),h=parseFloat(g.getPropertyValue("font-size"));this.x.baseVal._emToUnit(h);this.y.baseVal._emToUnit(h);f=f.translate(this.x.baseVal.value,this.y.baseVal.value);this._cacheMatrix=this._getCTM().multiply(f)}return(this._cacheMatrix)};d._inserted__(d);e=d.ownerDocument.createEvent("SVGEvents");e.initEvent("SVGLoad",false,false);d.dispatchEvent(e);e=void 0}},false);this.addEventListener("SVGLoad",function(d){d.target.addEventListener("DOMAttrModified",function(p){var k,q,f,l;if(p.eventPhase===3){k=p.target;if(k.parentNode){q=k.ownerDocument._domnodeEvent();q.target=k;q.eventPhase=2;f=k._capter;for(var g=0,e=f.length;g<e;++g){if(f[g]){f[g].handleEvent(q)}}if(((k.localName==="g")||(k.localName==="a"))&&(k.namespaceURI==="http://www.w3.org/2000/svg")){k._cacheMatrix=void 0;if(k.firstChild){l=k.getElementsByTagNameNS("http://www.w3.org/2000/svg","*");for(var h=0,o=l.length;h<o;++h){k=l[h];k._cacheMatrix=void 0;q=k.ownerDocument.createEvent("MutationEvents");q.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);q.target=k;q.eventPhase=2;f=k._capter;for(var g=0,e=f.length;g<e;++g){if(f[g]){f[g].handleEvent(q)}}}}}}}q=k=p=f=l=void 0},false);d.target.addEventListener("DOMNodeRemovedFromDocument",function(f){var e=f.target;e._tar&&e._tar.parentNode&&e._tar.parentNode.removeChild(e._tar);f=e=void 0},true);d=void 0},false)}SVGSVGElement.prototype=Object._create(SVGElement);(function(b){b.forceRedraw=function(){};b.getCurrentTime=function(){return(this._currentTime)};b.setCurrentTime=function(c){this._currentTime=c};b.createSVGNumber=function(){var c=new SVGNumber();c.value=0;return c};b.createSVGAngle=function(){var c=new SVGAngle();c.value=0;c.unitType=1;return c};b.createSVGLength=function(){var c=new SVGLength();c.unitType=1;return c};b.createSVGPoint=function(){return new SVGPoint()};b.createSVGMatrix=function(){return new SVGMatrix()};b.createSVGRect=function(){return new SVGRect()};b.createSVGTransform=function(){var c=this.createSVGTransformFromMatrix(this.createSVGMatrix());return c};b.createSVGTransformFromMatrix=function(c){var d=new SVGTransform();d.setMatrix(c);return d};b.getScreenCTM=function(){if(!!this._cacheScreenCTM){return(this._cacheScreenCTM)}var p=this.viewport.width,v=this.viewport.height,s,l,q,d,c,e,i,g,o,h,r,u,t,f;if(!this.useCurrentView){s=this.viewBox.baseVal;l=this.preserveAspectRatio.baseVal}else{s=this.currentView.viewBox.baseVal;l=this.currentView.preserveAspectRatio.baseVal}if(!!!s._isUsed){this._tx=this._ty=0;q=this.createSVGMatrix();this._cacheScreenCTM=q;return q}else{d=s.x;c=s.y;e=s.width;i=s.height;g=p/e;o=v/i;h=1;r=1;u=0;t=0;if(l.align===1){h=g;r=o;u=-d*h;t=-c*r}else{var k=(l.align+1)%3+1;var j=Math.round(l.align/3);switch(l.meetOrSlice){case 1:h=r=Math.min(g,o);break;case 2:h=r=Math.max(g,o);break}u=-d*h;t=-c*r;switch(k){case 1:break;case 2:u+=(p-e*h)/2;break;case 3:u+=p-e*h;break}switch(j){case 1:break;case 2:t+=(v-i*r)/2;break;case 3:t+=v-i*r;break}}}this._tx=u;this._ty=t;f=this._tar.style;f.marginLeft=u+"px";f.marginTop=t+"px";q=this.createSVGMatrix();q.a=h;q.d=r;this._cacheScreenCTM=q;p=v=s=l=d=c=e=i=g=o=h=r=u=t=f=void 0;return q}})(SVGSVGElement.prototype);function SVGFitToViewBox(){this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio()}function SVGViewSpec(b){SVGFitToViewBox.apply(this,arguments);this.transform=new SVGTransformList();this.viewTarget=b;this.viewBoxString=this.preserveAspectRatioString=this.transformString=this.viewTargetString=""}SVGViewSpec.prototype=Object._create(SVGFitToViewBox);function SVGGElement(b){SVGElement.apply(this);this._tar=b.createElement("v:group");b=void 0;this.addEventListener("DOMNodeInserted",function(e){var c=e.target;if(e.eventPhase===3){return}var h=c.nextSibling,g=c._tar,d=c.parentNode._tar,f=null;if(g&&d){if(!h){d.appendChild(g)}else{while(h){if(h._tar&&h._tar.parentNode){f=h._tar;break}h=h.nextSibling}f&&(d=f.parentNode);d.insertBefore(g,f)}}h=g=d=f=void 0},false)}SVGGElement.prototype=Object._create(SVGElement);function SVGDefsElement(){SVGElement.apply(this);this.style.setProperty("display","none")}SVGDefsElement.prototype=Object._create(SVGElement);function SVGDescElement(){SVGElement.apply(this)}SVGDescElement.prototype=Object._create(SVGElement);function SVGTitleElement(){SVGElement.apply(this);this.addEventListener("DOMCharacterDataModified",function(b){b.target.ownerDocument.title=b.target.firstChild.nodeValue},false)}SVGTitleElement.prototype=Object._create(SVGElement);function SVGSymbolElement(b){SVGElement.apply(this,arguments)}SVGSymbolElement.prototype=Object._create(SVGElement);function SVGUseElement(){SVGGElement.apply(this,arguments);var b=SVGAnimatedLength;this.x=new b();this.y=new b();this.width=new b();this.height=new b();b=void 0;this.instanceRoot=new SVGElement();this.animatedInstanceRoot=new SVGElement();this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===3){return}c.target.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed")},false);this.addEventListener("S_Load",function(j){var g=j.target,c=g.ownerDocument.defaultView.getComputedStyle(g,""),k=parseFloat(c.getPropertyValue("font-size")),l=g.ownerDocument.documentElement.createSVGTransform(),h=g._instance,f,d,e,i;g.x.baseVal._emToUnit(k);g.y.baseVal._emToUnit(k);g.width.baseVal._emToUnit(k);g.height.baseVal._emToUnit(k);g.instanceRoot=g.animatedInstanceRoot=g.ownerDocument.importNode(h,true);l.setTranslate(g.x.baseVal.value,g.y.baseVal.value);g.transform.baseVal.appendItem(l);if(g._instance.localName==="symbol"){f=g.ownerDocument.createElementNS("http://www.w3.org/2000/svg","svg");f.addEventListener("DOMNodeInsertedIntoDocument",function(o){o.target.nearestViewportElement=o.currentTarget},true);g._tar.appendChild(f._tar);i=g.getScreenCTM();f.setAttributeNS(null,"width",g.width.baseVal.value);f.setAttributeNS(null,"height",g.height.baseVal.value);h.hasAttributeNS(null,"viewBox")&&f.setAttributeNS(null,"viewBox",h.getAttributeNS(null,"viewBox"));h.hasAttributeNS(null,"preserveAspectRatio")&&f.setAttributeNS(null,"preserveAspectRatio",h.getAttributeNS(null,"preserveAspectRatio"));f._cacheScreenCTM=i.multiply(f.getScreenCTM());d=g.instanceRoot.firstChild;while(d){e=d.nextSibling;f.appendChild(d);d.getScreenCTM&&d.getScreenCTM();d=e}g.appendChild(f)}else{g.appendChild(g.instanceRoot)}j=l=g=evtt=c=k=f=d=e=i=void 0},false);SVGURIReference.apply(this)}SVGUseElement.prototype=Object._create(SVGElement);function SVGImageElement(c){SVGElement.apply(this,arguments);this._tar=c.createElement("v:image");var b=SVGAnimatedLength;this.x=new b();this.y=new b();this.width=new b();this.height=new b();c=b=void 0;this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.addEventListener("DOMNodeInserted",function(e){if(e.eventPhase===3){return}var d=e.target;d.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed");if(d.nextSibling){if(!!d.parentNode._tar&&!!d.nextSibling._tar){d.parentNode._tar.insertBefore(d._tar,d.nextSibling._tar)}}else{if(!!d.parentNode._tar){d.parentNode._tar.appendChild(d._tar)}}d.addEventListener("DOMNodeInsertedIntoDocument",d._imageo,false);e=d=void 0},false);SVGURIReference.apply(this)}SVGImageElement.prototype=Object._create(SVGElement);SVGImageElement.prototype._imageo=function(i){var f=i.target,c=f.ownerDocument.defaultView.getComputedStyle(f,""),j=parseFloat(c.getPropertyValue("font-size")),g=f._tar.style,e=f.getScreenCTM(),d=f.ownerDocument.documentElement.createSVGPoint(),h=parseFloat(c.getPropertyValue("fill-opacity")),b;f.x.baseVal._emToUnit(j);f.y.baseVal._emToUnit(j);f.width.baseVal._emToUnit(j);f.height.baseVal._emToUnit(j);g.position="absolute";d.x=f.x.baseVal.value;d.y=f.y.baseVal.value;d=d.matrixTransform(e);g.left=d.x+"px";g.top=d.y+"px";g.width=f.width.baseVal.value*e.a+"px";g.height=f.height.baseVal.value*e.d+"px";if(h!==1){g.filter="progid:DXImageTransform.Microsoft.Alpha";b=f._tar.filters.item("DXImageTransform.Microsoft.Alpha");b.Style=0;b.Opacity=h*100;b=void 0}i=f=c=j=g=e=d=h=void 0};function SVGSwitchElement(b){SVGElement.apply(this);this._tar=b.createElement("v:group");b=void 0;this.addEventListener("DOMNodeInserted",function(d){var c=d.target;if(d.eventPhase===3){return}c._inserted__(c);d=c=void 0},false)}SVGSwitchElement.prototype=Object._create(SVGElement);var sieb_s;function GetSVGDocument(b){this._tar=b;this._next=null}function _ca_(){var b=NAIBU._that;if((b.xmlhttp.readyState===4)&&(b.xmlhttp.status===200)){b._ca()}b=void 0}GetSVGDocument.prototype={_init:function(){var c=NAIBU.xmlhttp,b=this._tar,d=(this._tar.nodeName==="OBJECT")?"data":"src";b.style.display="none";this._baseURL=b.getAttribute(d);c.open("GET",this._baseURL,true);c.setRequestHeader("X-Requested-With","XMLHttpRequest");this.xmlhttp=c;NAIBU._that=this;c.onreadystatechange=_ca_;c.send(null);c=b=d=void 0},_ca:function(){var u=this._tar.previousSibling,K=u.contentWindow,f;if(K){K.screen.updateInterval=999;f=K.document;f.write("");f.close()}else{f=document}var J=f.namespaces;if(J&&!J.v){J.add("v","urn:schemas-microsoft-com:vml");J.add("o","urn:schemas-microsoft-com:office:office");var l=f.createStyleSheet(),j="behavior: url(#default#VML);display: inline-block;} ";l.cssText="v\\:rect{"+j+"v\\:image{"+j+"v\\:fill{"+j+"v\\:stroke{"+j+"o\\:opacity2{"+j+"dn\\:defs{display:none}v\\:group{text-indent:0px;position:relative;width:100%;height:100%;"+j+"v\\:shape{width:100%;height:100%;"+j;J=l=j=void 0}DOMImplementation._doc_=f;var G=this.xmlhttp.responseText,B=this._tar,O=DOMImplementation.createDocument("http://www.w3.org/2000/svg","svg"),I=O.documentElement,q=I.viewport,z,C,F,r,L,X,R=I._tar,o=f.createElement("div"),aa=f.createElement("v:group"),A=f.createElement("v:rect"),Q,t,g,v,ac,U,Z,ab,Y,H,k,e,V,E,N,T=parseFloat,p=NAIBU.doc||this.xmlhttp.responseXML,d=f.createElement("div");if(!p){this.xmlhttp.onreadystatechange=NAIBU.emptyFunction;return}O.URL=this._baseURL;O._iframe=u;d.setAttribute("id","_NAIBU_outline");f.body.appendChild(d);o.style.margin="-1px,0px,0px,-1px";if(K){f.body.style.backgroundColor=B.parentNode.currentStyle.backgroundColor}p.async=p.validateOnParse=p.resolveExternals=false;p.preserveWhiteSpace=true;p.loadXML(G.replace(/^[\s\S]*?<svg/,"<svg"));screen.updateInterval=999;if(p.doctype){var P=G,M=p.doctype.entities,D;for(var W=0;W<M.length;++W){D=M.item(W);P=P.replace((new RegExp("&"+D.nodeName+";","g")),D.firstChild.xml)}p.loadXML(P);P=M=D=void 0}q.top=q.left=0;q.width=B.clientWidth;q.height=B.clientHeight;if(q.height<24){q.height=screen.availHeight}if(I.viewport.height<24){I.viewport.height=screen.width}z=B.getAttribute("width");C=B.getAttribute("height");z&&I.setAttributeNS(null,"width",z);C&&I.setAttributeNS(null,"height",C);F=p.documentElement.firstChild;r=p.documentElement.attributes;for(var W=0,b=r.length;W<b;++W){I.setAttributeNodeNS(O.importNode(r[W],false))}G=r=void 0;aa.style.width=q.width+"px";aa.style.height=q.height+"px";aa.coordsize=q.width+" "+q.height;o.appendChild(aa);if(K){f.body.appendChild(o)}else{this._tar.parentNode.insertBefore(o,this._tar)}aa.appendChild(R);while(F){I.appendChild(O.importNode(F,true));F=F.nextSibling}F=void 0;O._window=K;Q=I.ownerDocument.defaultView.getComputedStyle(I,"");t=T(Q.getPropertyValue("font-size"));I.x.baseVal._emToUnit(t);I.y.baseVal._emToUnit(t);I.width.baseVal._emToUnit(t);I.height.baseVal._emToUnit(t);g=I.width.baseVal.value;v=I.height.baseVal.value;U=A.style;U.position="absolute";L=q.width;X=q.height;U.width=L+"px";U.height=X+"px";U.zIndex=-1;A.stroked=A.filled="false";I._tar.appendChild(A);ac=I._tar.style;ac.visibility="visible";ac.position="absolute";ac.overflow="hidden";Z=L>g?g:L;ab=X>v?v:X;U=A.currentStyle;k=T(U.left);e=T(U.top);V=-I._tx;bt=-I._ty;if(k!==0&&!isNaN(k)){V=k;aa.style.left=-V+"px"}if(e!==0&&!isNaN(k)){bt=e;aa.style.top=-bt+"px"}H=V+Z+1;Y=bt+ab+1;ac.clip="rect("+bt+"px "+H+"px "+Y+"px "+V+"px)";this._document=O;N=function(){if("_svgload_limited" in O.documentElement){O.documentElement._svgload_limited--;if(O.documentElement._svgload_limited<0){var h=O.createEvent("SVGEvents");h.initEvent("SVGLoad",false,false);O.documentElement.dispatchEvent(h);h=void 0}}};E=O.documentElement._tar.getElementsByTagName("div");for(var W=0,S;E[W];++W){S=E[W];if(S.firstChild.nodeName!=="shape"){var c=S.style;c.left=T(c.left)-V+"px";c.top=T(c.top)-bt+"px"}}K&&K.scroll(-O.documentElement._tx,-O.documentElement._ty);O._isLoaded=1;O.defaultView._cache=O.defaultView._cache_ele=null;d=f=evt=p=B=I=q=z=C=R=o=aa=A=g=v=Q=t=void 0;ac=U=E=S=W=c=k=e=V=bt=E=T=L=X=Z=ab=Y=H=void 0;this.xmlhttp.onreadystatechange=NAIBU.emptyFunction;if(this._next){N();K&&(u.contentWindow.screen.updateInterval=0);N=u=K=O=void 0;this._next._init()}else{if(O.implementation._buffer_){screen.updateInterval=0;NAIBU._buff_num=0;NAIBU._buff=setInterval(function(){var af=NAIBU._buff_num,h=DOMImplementation._buffer_,ae=h?h.length:0,ad,s;if(ae===0){clearInterval(NAIBU._buff);N();N=O=h=af=void 0}else{for(var w=0;w<50;++w){ad=h[af];s=h[af+1];ad.dispatchEvent(s);af+=2;ad=s=void 0;if(af>=ae){clearInterval(NAIBU._buff);N();DOMImplementation._buffer_=null;NAIBU.Time.start();N=O=h=af=ae=void 0;return}}NAIBU._buff_num=af}h=af=ae=void 0},1);u=K=void 0}else{N();N=u=K=O=void 0;NAIBU.Time.start()}delete NAIBU.doc}},getSVGDocument:function(){return(this._document)}};NAIBU.emptyFunction=function(){};function SVGStyleElement(b){SVGElement.apply(this);LinkStyle.apply(this);this.xmlspace;this.type="text/css";this.media;this.title;SVGURIReference.apply(this);this.addEventListener("DOMAttrModified",function(c){if(c.attrName==="type"){c.target.type=c.newValue}else{if(c.attrName==="title"){c.target.title=c.newValue}}c=void 0},false);this.addEventListener("S_Load",function(t){var p=t.target,r=p.sheet,c=p._text,g=p.ownerDocument,d=b.createElement("style"),s,o,h,f;NAIBU._temp_doc=g;r=g.styleSheets[g.styleSheets.length]=DOMImplementation.createCSSStyleSheet(p.title,p.media);r.ownerNode=p;b.documentElement.firstChild.appendChild(d);d.styleSheet.cssText=c;for(var l=0,u=d.styleSheet.rules,q=u.length;l<q;++l){s=u[l];h=new CSSStyleRule();h.selectorText=s.selectorText;h.style.cssText=s.style.cssText;o=h.style.cssText.split(";");for(var k=0,e=o.length;k<e;++k){f=o[k].split(": ");h.style.setProperty(f[0],f[1])}r.cssRules[r.cssRules.length]=h}g.documentElement.addEventListener("DOMNodeInsertedIntoDocument",function(D){var A=D.target,C=A.ownerDocument,E=C.styleSheets[0]?C.styleSheets[0].cssRules:[],v,j,z=".,.";if(A.className){z=A.className.baseVal||z}for(var w=0,B=E.length;w<B;++w){v=E[w].selectorText;j=A._rules||[];if((v.indexOf("."+z)>-1)||(v.indexOf("#"+A.id)>-1)||(A.nodeName===v)){j[j.length]=E[w]}A._rules=j}A=C=E=void 0},true);p=t=d=r=c=g=l=u=q=void 0},false);this.addEventListener("DOMNodeInserted",function(d){var c=d.target;if(d.eventPhase===3){if(c.nodeName==="#cdata-section"){d.currentTarget._text=c.data}return}c.addEventListener("DOMNodeInsertedIntoDocument",function(g){var f=g.target;if((g.eventPhase===2)&&!f.getAttributeNodeNS("http://www.w3.org/1999/xlink","xlink:href")){var e=f.ownerDocument.createEvent("SVGEvents");e.initEvent("S_Load",false,false);g.currentTarget.dispatchEvent(e)}f=g=void 0},false)},false)}SVGStyleElement.prototype=Object._create(SVGElement);function SVGPoint(){}SVGPoint.prototype.x=SVGPoint.prototype.y=0;SVGPoint.prototype.matrixTransform=function(b){if(!isFinite(b.a)||!isFinite(b.b)||!isFinite(b.c)||!isFinite(b.d)||!isFinite(b.e)||!isFinite(b.f)){throw (new Error("Type Error: 引数の値がNumber型ではありません"))}var c=new SVGPoint();c.x=b.a*this.x+b.c*this.y+b.e;c.y=b.b*this.x+b.d*this.y+b.f;return c};function SVGPointList(){}function SVGMatrix(){}SVGMatrix.prototype={a:1,b:0,c:0,d:1,e:0,f:0,multiply:function(c){var f=new SVGMatrix(),b=c,e=isFinite,d=this;if(!e(b.a)||!e(b.b)||!e(b.c)||!e(b.d)||!e(b.e)||!e(b.f)){throw (new Error("Type Error: 引数の値がNumber型ではありません"))}f.a=d.a*b.a+d.c*b.b;f.b=d.b*b.a+d.d*b.b;f.c=d.a*b.c+d.c*b.d;f.d=d.b*b.c+d.d*b.d;f.e=d.a*b.e+d.c*b.f+d.e;f.f=d.b*b.e+d.d*b.f+d.f;b=d=c=e=void 0;return f},inverse:function(){var b=new SVGMatrix(),c=this._determinant();if(c!==0){b.a=this.d/c;b.b=-this.b/c;b.c=-this.c/c;b.d=this.a/c;b.e=(this.c*this.f-this.d*this.e)/c;b.f=(this.b*this.e-this.a*this.f)/c;return b}else{throw (new SVGException(2))}},translate:function(c,e){var b=new SVGMatrix();b.e=c;b.f=e;var d=this.multiply(b);b=void 0;return d},scale:function(d){var b=new SVGMatrix();b.a=d;b.d=d;var c=this.multiply(b);b=void 0;return c},scaleNonUniform:function(c,e){var b=new SVGMatrix();b.a=c;b.d=e;var d=this.multiply(b);b=void 0;return d},rotate:function(e){var c=new SVGMatrix(),b=e/180*Math.PI;c.a=Math.cos(b);c.b=Math.sin(b);c.c=-c.b;c.d=c.a;var d=this.multiply(c);c=b=void 0;return d},rotateFromVector:function(d,f){if((d===0)||(f===0)||!isFinite(d)||!isFinite(f)){throw (new SVGException(1))}var c=new SVGMatrix(),b=Math.atan2(f,d);c.a=Math.cos(b);c.b=Math.sin(b);c.c=-c.b;c.d=c.a;var e=this.multiply(c);c=b=void 0;return e},flipX:function(){var b=new SVGMatrix();b.a=-b.a;var c=this.multiply(b);b=void 0;return c},flipY:function(){var b=new SVGMatrix();b.d=-b.d;var c=this.multiply(b);b=void 0;return c},skewX:function(e){var c=new SVGMatrix(),b=e/180*Math.PI;c.c=Math.tan(b);var d=this.multiply(c);c=void 0;return d},skewY:function(e){var c=new SVGMatrix(),b=e/180*Math.PI;c.b=Math.tan(b);var d=this.multiply(c);c=void 0;return d},_determinant:function(){return(this.a*this.d-this.b*this.c)}};function SVGTransform(){this.matrix=new SVGMatrix()}SVGTransform.SVG_TRANSFORM_UNKNOWN=0;SVGTransform.SVG_TRANSFORM_MATRIX=1;SVGTransform.SVG_TRANSFORM_TRANSLATE=2;SVGTransform.SVG_TRANSFORM_SCALE=3;SVGTransform.SVG_TRANSFORM_ROTATE=4;SVGTransform.SVG_TRANSFORM_SKEWX=5;SVGTransform.SVG_TRANSFORM_SKEWY=6;SVGTransform.prototype={_matrix:(new SVGMatrix()),type:0,angle:0,setMatrix:function(b){this.type=1;this.matrix=this._matrix.multiply(b)},setTranslate:function(c,b){this.type=2;this.matrix=this._matrix.translate(c,b)},setScale:function(c,b){this.type=3;this.matrix=this._matrix.scaleNonUniform(c,b)},setRotate:function(c,b,d){this.angle=c;this.type=4;this.matrix=this._matrix.rotate(c);this.matrix.e=(1-this.matrix.a)*b-this.matrix.c*d;this.matrix.f=-this.matrix.b*b+(1-this.matrix.d)*d},setSkewX:function(b){this.angle=b;this.type=5;this.matrix=this._matrix.skewX(b)},setSkewY:function(b){this.angle=b;this.type=6;this.matrix=this._matrix.skewY(b)}};function SVGTransformList(){}SVGTransformList.prototype.createSVGTransformFromMatrix=function(b){var c=new SVGTransform();c.setMatrix(b);return c};SVGTransformList.prototype.consolidate=function(){if(this.numberOfItems===0){return null}else{var e=new SVGTransform(),c=e.matrix,f;if(this.numberOfItems===1){f=this.getItem(0).matrix;c.a=f.a;c.b=f.b;c.c=f.c;c.d=f.d;c.e=f.e;c.f=f.f}else{for(var d=0,b=this.numberOfItems;d<b;++d){c=c.multiply(this.getItem(d).matrix)}e.matrix=c}e.type=1;c=f=void 0;return e}};function SVGAnimatedTransformList(){this.animVal=this.baseVal=new SVGTransformList()}function SVGPreserveAspectRatio(){this.align=6;this.meetOrSlice=1}function SVGAnimatedPreserveAspectRatio(){this.animVal=this.baseVal=new SVGPreserveAspectRatio()}function SVGPathSeg(){this.pathSegType=0;this.pathSegTypeAsLetter=null}function SVGPathSegClosePath(){}SVGPathSegClosePath.prototype={pathSegType:1,pathSegTypeAsLetter:"z"};function SVGPathSegMovetoAbs(){}SVGPathSegMovetoAbs.prototype={pathSegType:2,pathSegTypeAsLetter:"M"};function SVGPathSegMovetoRel(){}SVGPathSegMovetoRel.prototype={pathSegType:3,pathSegTypeAsLetter:"m"};function SVGPathSegLinetoAbs(){}SVGPathSegLinetoAbs.prototype={pathSegType:4,pathSegTypeAsLetter:"L"};function SVGPathSegLinetoRel(){}SVGPathSegLinetoRel.prototype={pathSegType:5,pathSegTypeAsLetter:"l"};function SVGPathSegCurvetoCubicAbs(){}SVGPathSegCurvetoCubicAbs.prototype={pathSegType:6,pathSegTypeAsLetter:"C"};function SVGPathSegCurvetoCubicRel(){}SVGPathSegCurvetoCubicRel.prototype={pathSegType:7,pathSegTypeAsLetter:"c"};function SVGPathSegCurvetoQuadraticAbs(){this.pathSegType=8;this.pathSegTypeAsLetter="Q"}function SVGPathSegCurvetoQuadraticRel(){this.pathSegType=9;this.pathSegTypeAsLetter="q"}function SVGPathSegArcAbs(){}SVGPathSegArcAbs.prototype={largeArcFlag:true,sweepFlag:true,pathSegType:10,pathSegTypeAsLetter:"A"};function SVGPathSegArcRel(){}SVGPathSegArcRel.prototype={largeArcFlag:true,sweepFlag:true,pathSegType:11,pathSegTypeAsLetter:"a"};function SVGPathSegLinetoHorizontalAbs(){this.pathSegType=12;this.pathSegTypeAsLetter="H"}function SVGPathSegLinetoHorizontalRel(){this.pathSegType=13;this.pathSegTypeAsLetter="h"}function SVGPathSegLinetoVerticalAbs(){this.pathSegType=14;this.pathSegTypeAsLetter="V"}function SVGPathSegLinetoVerticalRel(){this.pathSegType=15;this.pathSegTypeAsLetter="v"}function SVGPathSegCurvetoCubicSmoothAbs(){this.pathSegType=16;this.pathSegTypeAsLetter="S"}function SVGPathSegCurvetoCubicSmoothRel(){this.pathSegType=17;this.pathSegTypeAsLetter="s"}function SVGPathSegCurvetoQuadraticSmoothAbs(){this.pathSegType=18;this.pathSegTypeAsLetter="T"}function SVGPathSegCurvetoQuadraticSmoothRel(){this.pathSegType=19;this.pathSegTypeAsLetter="t"}function SVGPathSegList(){}for(var prop in SVGStringList.prototype){SVGNumberList.prototype[prop]=SVGLengthList.prototype[prop]=SVGPointList.prototype[prop]=SVGTransformList.prototype[prop]=SVGPathSegList.prototype[prop]=SVGStringList.prototype[prop]}prop=void 0;(function(d,c){NAIBU.freeArg=function(){b=d=c=void 0};NAIBU._setPaint=function(N,L){if(!N._tar){return}var R=N.ownerDocument,j=R._document_,e=N._tar,Q=R.defaultView.getComputedStyle(N,""),J=Q.getPropertyCSSValue("fill"),u=Q.getPropertyCSSValue("stroke"),s=J.paintType,O=u.paintType,F,D,v=1,H="color",A,r,K,E,p,C,I,f,l,o,G,z,P,B,k,q;while(e.firstChild){e.removeChild(e.firstChild)}if((s===1)||(s===102)){if(s===102){Q.setProperty(H,Q.getPropertyValue(H))}F=j.createElement("v:fill");D=J.rgbColor;v=1;F.setAttribute(H,"rgb("+D.red.getFloatValue(v)+","+D.green.getFloatValue(v)+","+D.blue.getFloatValue(v)+")");K=+(Q.getPropertyValue("fill-opacity"))*Q._list._opacity;if(K<1){F.setAttribute("opacity",K+"")}e.appendChild(F);F=D=K=void 0}else{if(J.uri){A=R.getElementById(J.uri);if(A){r=R._domnodeEvent();r._tar=j.createElement("v:fill");r._style=Q;r._ttar=N;A.dispatchEvent(r);if(A.localName!=="radialGradient"){e.appendChild(r._tar)}A=r=void 0}}else{e.filled="false"}}if((O===1)||(O===102)){if(O===102){Q.setProperty(H,Q.getPropertyValue(H))}f=j.createElement("v:stroke");G=Q.getPropertyCSSValue("stroke-width");z=R.documentElement.viewport.width;P=R.documentElement.viewport.height;G._percent=c.sqrt((z*z+P*P)/2);B=G.getFloatValue(1)*c.sqrt(c.abs(L._determinant()));f.setAttribute("weight",B+"px");G=z=P=void 0;if(!u.uri){D=u.rgbColor;f.setAttribute(H,"rgb("+D.red.getFloatValue(v)+","+D.green.getFloatValue(v)+","+D.blue.getFloatValue(v)+")");l=+(Q.getPropertyValue("stroke-opacity"))*(+(Q.getPropertyValue("opacity")));if(B<1){l*=B}if(l<1){f.setAttribute("opacity",l+"")}D=l=void 0}f.setAttribute("miterlimit",Q.getPropertyValue("stroke-miterlimit"));f.setAttribute("joinstyle",Q.getPropertyValue("stroke-linejoin"));if(Q.getPropertyValue("stroke-linecap")==="butt"){f.setAttribute("endcap","flat")}else{f.setAttribute("endcap",Q.getPropertyValue("stroke-linecap"))}k=Q.getPropertyValue("stroke-dasharray");if(k!=="none"){if(k.indexOf(",")>0){E=k.split(",");for(var M=0,g=E.length;M<g;++M){E[M]=c.ceil(+(E[M])/parseFloat(Q.getPropertyValue("stroke-width")))}q=E.join(" ");if(E.length%2===1){q+=" "+q}}f.setAttribute("dashstyle",q);k=E=void 0}e.appendChild(f);f=k=void 0}else{e.stroked="false"}if(e.style){p=Q.getPropertyCSSValue("cursor");if(p&&!p._isDefault){e.style.cursor=p.cssText.split(":")[1]}C=Q.getPropertyCSSValue("visibility");if(C&&!C._isDefault){e.style.visibility=C.cssText.split(":")[1]}I=Q.getPropertyCSSValue("display");if(I&&!I._isDefault&&(I.cssText.indexOf("none")>-1)){e.style.display="none"}else{if(I&&!I._isDefault&&(I.cssText.indexOf("inline-block")===-1)){e.style.display="inline-block"}}}R=j=e=J=u=O=s=Q=p=N=L=C=I=v=void 0};function b(f){SVGElement.apply(this);this._tar=f.createElement("v:shape");var e=SVGPathSegList;this.pathSegList=new e();this.animatedPathSegList=this.pathSegList;this.normalizedPathSegList=new e();e=f=void 0;this.animatedNormalizedPathSegList=this.normalizedPathSegList;this.pathLength=new SVGAnimatedNumber();this.addEventListener("DOMAttrModified",this._attrModi,false);this.addEventListener("DOMNodeInserted",this._nodeInsert,false)}b.prototype=Object._create(SVGElement);(function(e){e._attrModi=function(I){var N=I.target;if(I.attrName==="d"&&I.newValue!==""){var F=N.normalizedPathSegList,M=N.pathSegList;if(F.numberOfItems>0){F.clear();M.clear()}var T=N._com,Q=T.isSp,u=I.newValue.replace(T.isRa," -").replace(T.isRb," ").replace(T.isRc,",$1 ").replace(T.isRd,",$1 1").replace(T.isRe,"").replace(/\.(\d+)\./g,".$1 0.").replace(/[^\w\d\+\-\.\,\n\r\s].*/,"").split(","),k=u.length,z=T._isZ,C=T._isM,J=T._isC,D=T._isL,q=N.createSVGPathSegCurvetoCubicAbs,O=N.createSVGPathSegLinetoAbs,K,p;for(var S=0;S<k;++S){var t=u[S].match(Q),P;for(var R=1,g=t[0],H=t.length;R<H;++R){if(J[g]){P=q(+t[R+4],+t[R+5],+t[R],+t[R+1],+t[R+2],+t[R+3]);R+=5}else{if(D[g]){P=O(+t[R],+t[R+1]);++R}else{if(C[g]){P=N.createSVGPathSegMovetoAbs(+t[R],+t[R+1]);++R}else{if(z[g]){P=N.createSVGPathSegClosePath()}else{if(g==="A"){K=t[R+3];if(K.length>1&&(+K>=0)){t.splice(R+3,1,K.charAt(0),K.slice(1));++H}p=t[R+4];if(p.length>1&&(+p>=0)){t.splice(R+4,1,p.charAt(0),p.slice(1));++H}K=t[R+3];p=t[R+4];if(((+K<0)||(+K>1))||((+p<0)||(+p>1))){R+=6;continue}P=N.createSVGPathSegArcAbs(+t[R+5],+t[R+6],+t[R],+t[R+1],+t[R+2],+K,+p);R+=6}else{if(g==="m"){P=N.createSVGPathSegMovetoRel(+t[R],+t[R+1]);++R}else{if(g==="l"){P=N.createSVGPathSegLinetoRel(+t[R],+t[R+1]);++R}else{if(g==="c"){P=N.createSVGPathSegCurvetoCubicRel(+t[R+4],+t[R+5],+t[R],+t[R+1],+t[R+2],+t[R+3]);R+=5}else{if(g==="Q"){P=N.createSVGPathSegCurvetoQuadraticAbs(+t[R+2],+t[R+3],+t[R],+t[R+1]);R+=3}else{if(g==="q"){P=N.createSVGPathSegCurvetoQuadraticRel(+t[R+2],+t[R+3],+t[R],+t[R+1]);R+=3}else{if(g==="a"){K=t[R+3];if(K.length>1&&(+K>=0)){t.splice(R+3,1,K.charAt(0),K.slice(1));++H}p=t[R+4];if(p.length>1&&(+p>=0)){t.splice(R+4,1,p.charAt(0),p.slice(1));++H}K=t[R+3];p=t[R+4];if(((+K<0)||(+K>1))||((+p<0)||(+p>1))){R+=6;continue}P=N.createSVGPathSegArcRel(+t[R+5],+t[R+6],+t[R],+t[R+1],+t[R+2],+K,+p);R+=6}else{if(g==="S"){P=N.createSVGPathSegCurvetoCubicSmoothAbs(+t[R+2],+t[R+3],+t[R],+t[R+1]);R+=3}else{if(g==="s"){P=N.createSVGPathSegCurvetoCubicSmoothRel(+t[R+2],+t[R+3],+t[R],+t[R+1]);R+=3}else{if(g==="T"){P=N.createSVGPathSegCurvetoQuadraticSmoothAbs(+t[R],+t[R+1]);++R}else{if(g==="t"){P=N.createSVGPathSegCurvetoQuadraticSmoothRel(+t[R],+t[R+1]);++R}else{if(g==="H"){P=N.createSVGPathSegLinetoHorizontalAbs(+t[R])}else{if(g==="h"){P=N.createSVGPathSegLinetoHorizontalRel(+t[R])}else{if(g==="V"){P=N.createSVGPathSegLinetoVerticalAbs(+t[R])}else{if(g==="v"){P=N.createSVGPathSegLinetoVerticalRel(+t[R])}else{P=new SVGPathSeg()}}}}}}}}}}}}}}}}}}}M.appendItem(P)}}t=P=Q=u=void 0;var B=0,A=0,L=0,w=0,o=0,l=0;for(var R=0,r=M.numberOfItems;R<r;++R){var f=M.getItem(R),U=f.pathSegType,g=f.pathSegTypeAsLetter;if(U===0){}else{var G=B,E=A;if(U%2===1){B+=f.x;A+=f.y}else{B=f.x;A=f.y}if(J[g]){F.appendItem(f)}else{if(D[g]){F.appendItem(f)}else{if(C[g]){if(R!==0){var h=M.getItem(R-1);if(h.pathSegTypeAsLetter==="M"){F.appendItem(O(B,A));continue}}o=B;l=A;F.appendItem(f)}else{if(g==="m"){if(R!==0){var h=M.getItem(R-1);if(h.pathSegTypeAsLetter==="m"){F.appendItem(O(B,A));continue}}o=B;l=A;F.appendItem(N.createSVGPathSegMovetoAbs(B,A))}else{if(g==="l"){F.appendItem(O(B,A))}else{if(g==="c"){F.appendItem(q(B,A,f.x1+G,f.y1+E,f.x2+G,f.y2+E))}else{if(z[g]){B=o;A=l;F.appendItem(f)}else{if(g==="Q"){L=2*B-f.x1;w=2*A-f.y1;F.appendItem(q(B,A,(G+2*f.x1)/3,(E+2*f.y1)/3,(2*f.x1+B)/3,(2*f.y1+A)/3))}else{if(g==="q"){var v=f.x1+G,V=f.y1+E;L=2*B-v;w=2*A-V;F.appendItem(q(B,A,(G+2*v)/3,(E+2*V)/3,(2*v+B)/3,(2*V+A)/3));v=V=void 0}else{if(g==="A"||g==="a"){(function(X,au,at,ax,av,aD,aw){if(X.r1===0||X.r2===0){return}var aI=X.sweepFlag,aM=X.angle,al=c.abs(X.r1),ak=c.abs(X.r2),ar=(ax-au)/2,aq=(av-at)/2,W=c.cos(aM*c.PI/180),aA=c.sin(aM*c.PI/180),az=W*ar+aA*aq,aj=-1*aA*ar+W*aq,ah=az*az,ac=aj*aj,ay=al*al,af=ak*ak,aQ=ah/ay+ac/af,aJ;if(aQ>1){al=c.sqrt(aQ)*al;ak=c.sqrt(aQ)*ak;aJ=0}else{var ae=1;if(X.largeArcFlag===aI){ae=-1}aJ=ae*c.sqrt((ay*af-ay*ac-af*ah)/(ay*ac+af*ah))}var ao=aJ*al*aj/ak,s=-1*aJ*ak*az/al,aL=W*ao-aA*s+(ax+au)/2,aK=aA*ao+W*s+(av+at)/2,Z=c.atan2((aj-s)/ak,(az-ao)/al)-c.atan2(0,1),aN=(Z>=0)?Z:2*c.PI+Z,Z=c.atan2((-aj-s)/ak,(-az-ao)/al)-c.atan2((aj-s)/ak,(az-ao)/al),ad=(Z>=0)?Z:2*c.PI+Z;if(!aI&&ad>0){ad-=2*c.PI}else{if(aI&&ad<0){ad+=2*c.PI}}var aa=ad*2/c.PI,aB=c.ceil(aa<0?-1*aa:aa),aC=ad/aB,aG=8/3*c.sin(aC/4)*c.sin(aC/4)/c.sin(aC/2),aF=W*al,aE=W*ak,j=aA*al,i=aA*ak,ap=c.cos(aN),ag=c.sin(aN),an=ax-aG*(aF*ag+i*ap),aP=av-aG*(j*ag-aE*ap);for(var aH=0;aH<aB;++aH){aN+=aC;ap=c.cos(aN);ag=c.sin(aN);var am=aF*ap-i*ag+aL,aO=j*ap+aE*ag+aK,ab=-aG*(aF*ag+i*ap),Y=-aG*(j*ag-aE*ap);aw.appendItem(q(am,aO,an,aP,am-ab,aO-Y));an=am+ab;aP=aO+Y}X=au=at=ax=av=aD=aw=void 0})(f,B,A,G,E,N,F)}else{if(g==="S"){if(R!==0){var h=F.getItem(F.numberOfItems-1);if(h.pathSegTypeAsLetter==="C"){var v=2*h.x-h.x2,V=2*h.y-h.y2}else{var v=G,V=E}}else{var v=G,V=E}F.appendItem(q(B,A,v,V,f.x2,f.y2));v=V=void 0}else{if(g==="s"){if(R!==0){var h=F.getItem(F.numberOfItems-1);if(h.pathSegTypeAsLetter==="C"){var v=2*h.x-h.x2,V=2*h.y-h.y2}else{var v=G,V=E}}else{var v=G,V=E}F.appendItem(q(B,A,v,V,f.x2+G,f.y2+E));v=V=void 0}else{if(g==="T"||g==="t"){if(R!==0){var h=M.getItem(R-1);if("QqTt".indexOf(h.pathSegTypeAsLetter)>-1){}else{L=G,w=E}}else{L=G,w=E}F.appendItem(q(B,A,(G+2*L)/3,(E+2*w)/3,(2*L+B)/3,(2*w+A)/3));L=2*B-L;w=2*A-w;xx1=yy1=void 0}else{if(g==="H"||g==="h"){F.appendItem(O(B,E));A=E}else{if(g==="V"||g==="v"){F.appendItem(O(G,A));B=G}}}}}}}}}}}}}}}}}}I=N=T=B=A=L=w=o=l=F=M=f=g=U=z=C=D=J=P=q=O=void 0};e._nodeInsert=function(h){var f=h.target;if(h.eventPhase===3){return}var k=f.nextSibling,j=f._tar,g=f.parentNode._tar,i=null;if(j&&g){if(!k){g.appendChild(j)}else{while(k){if(k._tar&&k._tar.parentNode){i=k._tar;break}k=k.nextSibling}i&&(g=i.parentNode);g.insertBefore(j,i)}}k=j=g=i=void 0;f.addEventListener("DOMNodeInsertedIntoDocument",f._nodeInsertInto,false);h=f=void 0};e._nodeInsertInto=function(q){var u=q.target,s=u.getScreenCTM(),o=u.normalizedPathSegList,A=[],h=s.a,g=s.b,H=s.c,G=s.d,F=s.e,E=s.f,j=u._com._nameCom,l=u._com._isZ,w=u._com._isC,p;for(var v=0,r=o.numberOfItems;v<r;++v){var k=o[v],D=k.x,B=k.y,z=k.pathSegTypeAsLetter;if(w[z]){A[v]=["c",(h*k.x1+H*k.y1+F)|0,(g*k.x1+G*k.y1+E)|0,(h*k.x2+H*k.y2+F)|0,(g*k.x2+G*k.y2+E)|0,(h*D+H*B+F)|0,(g*D+G*B+E)|0].join(" ")}else{if(!l[z]){p=j[z];p+=(h*D+H*B+F)|0;p+=" ";p+=(g*D+G*B+E)|0;A[v]=p}else{A[v]=" x "}}}var C=u.ownerDocument.documentElement,f=u._tar;A.push(" e");f.path=A.join(" ");f.coordsize=C.width.baseVal.value+" "+C.height.baseVal.value;NAIBU._setPaint(u,s);delete u._cacheMatrix;q=u=A=p=D=B=s=o=x=y=mr=h=g=H=G=F=E=C=l=w=v=r=z=k=j=f=void 0};e._com={_nameCom:{C:"c",L:"l",M:"m"},_isZ:{z:1,Z:1},_isC:{C:1},_isL:{L:1},_isM:{M:1},isRa:/\-/g,isRb:/,/g,isRc:/([a-yA-Y])/g,isRd:/([zZ])/g,isRe:/,/,isSp:/\S+/g};e.getTotalLength=function(){var k=0,g=this.normalizedPathSegList;for(var j=1,l=g.numberOfItems,h=null;j<l;++j){var f=g.getItem(j);if(f.pathSegType===4){var o=g.getItem(j-1);k+=c.sqrt(c.pow((f.x-o.x),2)+c.pow((f.y-o.y),2))}else{if(f.pathSegType===6){}else{if(f.pathSegType===1){var o=g.getItem(j-1),h=g.getItem(0);k+=c.sqrt(c.pow((o.x-h.x),2)+c.pow((o.y-h.y),2))}}}}this.pathLength.baseVal=k;return k};e.getPointAtLength=function(i){var j=this.getPathSegAtLength(i),p=0,o=0,g=this.normalizedPathSegList,k=g.getItem(j),u=this.ownerDocument.documentElement.createSVGPoint();if((j-1)<=0){u.x=k.x;u.y=k.y;return u}var f=g.getItem(j-1);if(k.pathSegType===4){var l=c.sqrt(c.pow((k.x-f.x),2)+c.pow((k.y-f.y),2));var r=(l+this._dis)/l;u.x=f.x+r*(k.x-f.x);u.y=f.y+r*(k.y-f.y)}else{if(k.pathSegType===6){var q=0;q+=c.sqrt(c.pow((k.x1-f.x),2)+c.pow((k.y1-f.y),2));q+=c.sqrt(c.pow((k.x2-k.x1),2)+c.pow((k.y2-k.y1),2));q+=c.sqrt(c.pow((k.x2-k.x1),2)+c.pow((k.y2-k.y1),2));q+=c.sqrt(c.pow((k.x-f.x),2)+c.pow((k.y-f.y),2));var l=q/2;var r=(l+this._dis)/l;u.x=(3*k.x1+k.x-3*k.x2-f.x)*c.pow(r,3)+3*(f.x-2*k.x1+k.x2)*c.pow(r,2)+3*(k.x1-f.x)*r+f.x;u.y=(3*k.y1+k.y-3*k.y2-f.y)*c.pow(r,3)+3*(f.y-2*k.y1+k.y2)*c.pow(r,2)+3*(k.y1-f.y)*r+f.y}else{if(k.pathSegType===2){u.x=k.x;u.y=k.y}else{if(k.pathSegType===1){var h=g.getItem(0),l=c.sqrt(c.pow((k.x-mx.x),2)+c.pow((k.y-h.y),2));var r=(l+this._dis)/l;u.x=h.x+r*(k.x-h.x);u.y=h.y+r*(k.y-h.y)}}}}return u};e.getPathSegAtLength=function(o){var g=this.normalizedPathSegList;for(var j=0,k=g.numberOfItems,h=null;j<k;++j){var f=g.getItem(j);if(f.pathSegType===4){var l=g.getItem(j-1);o-=c.sqrt(c.pow((f.x-l.x),2)+c.pow((f.y-l.y),2))}else{if(f.pathSegType===6){}else{if(f.pathSegType===1){var l=g.getItem(j-1),h=g.getItem(0);o-=c.sqrt(c.pow((l.x-h.x),2)+c.pow((l.y-h.y),2))}}}if(o<=0){this._dis=o;o=void 0;return j}}return(g.numberOfItems-1)};e.createSVGPathSegClosePath=function(){var f=SVGPathSegClosePath;return(new f())};e.createSVGPathSegMovetoAbs=function(f,i){var h=SVGPathSegMovetoAbs,g=new h();g.x=f;g.y=i;return g};e.createSVGPathSegMovetoRel=function(f,h){var g=new SVGPathSegMovetoRel();g.x=f;g.y=h;return g};e.createSVGPathSegLinetoAbs=function(f,h){var g=new SVGPathSegLinetoAbs();g.x=f;g.y=h;return g};e.createSVGPathSegLinetoRel=function(f,h){var g=new SVGPathSegLinetoRel();g.x=f;g.y=h;return g};e.createSVGPathSegCurvetoCubicAbs=function(g,o,i,l,h,j){var f=SVGPathSegCurvetoCubicAbs,k=new f();k.x=g;k.y=o;k.x1=i;k.y1=l;k.x2=h;k.y2=j;return k};e.createSVGPathSegCurvetoCubicRel=function(f,l,h,k,g,i){var j=new SVGPathSegCurvetoCubicRel();j.x=f;j.y=l;j.x1=h;j.y1=k;j.x2=g;j.y2=i;return j};e.createSVGPathSegCurvetoQuadraticAbs=function(f,j,g,i){var h=new SVGPathSegCurvetoQuadraticAbs();h.x=f;h.y=j;h.x1=g;h.y1=i;return h};e.createSVGPathSegCurvetoQuadraticRel=function(f,j,g,i){var h=new SVGPathSegCurvetoQuadraticRel();h.x=f;h.y=j;h.x1=g;h.y1=i;return h};e.createSVGPathSegArcAbs=function(f,o,h,g,l,k,j){var i=new SVGPathSegArcAbs();i.x=f;i.y=o;i.r1=h;i.r2=g;i.angle=l;i.largeArcFlag=k;i.sweepFlag=j;return i};e.createSVGPathSegArcRel=function(f,o,h,g,l,k,j){var i=new SVGPathSegArcRel();i.x=f;i.y=o;i.r1=h;i.r2=g;i.angle=l;i.largeArcFlag=k;i.sweepFlag=j;return i};e.createSVGPathSegLinetoHorizontalAbs=function(f){var g=new SVGPathSegLinetoHorizontalAbs();g.x=f;g.y=0;return g};e.createSVGPathSegLinetoHorizontalRel=function(f){var g=new SVGPathSegLinetoHorizontalRel();g.x=f;g.y=0;return g};e.createSVGPathSegLinetoVerticalAbs=function(g){var f=new SVGPathSegLinetoVerticalAbs();f.x=0;f.y=g;return f};e.createSVGPathSegLinetoVerticalRel=function(g){var f=new SVGPathSegLinetoVerticalRel();f.x=0;f.y=g;return f};e.createSVGPathSegCurvetoCubicSmoothAbs=function(f,j,g,h){var i=new SVGPathSegCurvetoCubicSmoothAbs();i.x=f;i.y=j;i.x2=g;i.y2=h;return i};e.createSVGPathSegCurvetoCubicSmoothRel=function(f,j,g,h){var i=new SVGPathSegCurvetoCubicSmoothRel();i.x=f;i.y=j;i.x2=g;i.y2=h;return i};e.createSVGPathSegCurvetoQuadraticSmoothAbs=function(f,h){var g=new SVGPathSegCurvetoQuadraticSmoothAbs();g.x=f;g.y=h;return g};e.createSVGPathSegCurvetoQuadraticSmoothRel=function(f,h){var g=new SVGPathSegCurvetoQuadraticSmoothRel();g.x=f;g.y=h;return g}})(b.prototype);NAIBU.SVGPathElement=b})(document,Math);function SVGRectElement(c){SVGElement.apply(this);this._tar=c.createElement("v:shape");var b=SVGAnimatedLength;this.x=new b();this.y=new b();this.width=new b();this.height=new b();this.rx=new b();this.ry=new b();c=b=void 0;this.addEventListener("DOMNodeInserted",function(f){if(f.eventPhase===3){return}var d=f.target,i=d.nextSibling,h=d._tar,e=d.parentNode._tar,g=null;if(h&&e){if(!i){e.appendChild(h)}else{while(i){if(i._tar&&i._tar.parentNode){g=i._tar;break}i=i.nextSibling}g&&(e=g.parentNode);e.insertBefore(h,g)}}i=h=e=g=void 0;d.addEventListener("DOMNodeInsertedIntoDocument",function(E){var L=E.target,N=L.ownerDocument.defaultView.getComputedStyle(L,""),o=parseFloat(N.getPropertyValue("font-size"));L.x.baseVal._emToUnit(o);L.y.baseVal._emToUnit(o);L.width.baseVal._emToUnit(o);L.height.baseVal._emToUnit(o);var r=L.getAttributeNS(null,"rx"),q=L.getAttributeNS(null,"ry"),A=L.x.baseVal.value,z=L.y.baseVal.value,u=A+L.width.baseVal.value,X=z+L.height.baseVal.value,O;if((r||q)&&(r!=="0")&&(q!=="0")){L.rx.baseVal._emToUnit(o);L.ry.baseVal._emToUnit(o);var k=L.rx.baseVal,j=L.ry.baseVal,T=L.width.baseVal.value,l=L.height.baseVal.value;k.value=r?k.value:j.value;j.value=q?j.value:k.value;if(k.value>T/2){k.value=T/2}if(j.value>l/2){j.value=l/2}var v=k.value,J=j.value,t=v*0.55228,s=J*0.55228,W=u-v,S=A+v,R=z+J,Q=X-J;O=["m",S,z,"l",W,z,"c",W+t,z,u,R-s,u,R,"l",u,Q,"c",u,Q+s,W+t,X,W,X,"l",S,X,"c",S-t,X,A,Q+s,A,Q,"l",A,R,"c",A,R-s,S-t,z,S,z]}else{O=["m",A,z,"l",A,X,u,X,u,z,"x e"]}var D=L.ownerDocument.documentElement,V=L.getScreenCTM(),P,G,F,C=L._tar,U=L.ownerDocument.documentElement,B=U.width.baseVal.value,M=U.height.baseVal.value,H=Math.round;for(var K=0,I=O.length;K<I;){if(isNaN(O[K])){++K;continue}G=D.createSVGPoint();G.x=O[K];G.y=O[K+1];F=G.matrixTransform(V);O[K]=H(F.x);++K;O[K]=H(F.y);++K;G=F=void 0}P=O.join(" ");C.path=P;C.coordsize=B+" "+M;NAIBU._setPaint(L,V);delete L._cacheMatrix;E=L=N=O=H=P=C=U=o=void 0},false);f=d=void 0},false)}SVGRectElement.prototype=Object._create(SVGElement);function SVGCircleElement(c){SVGElement.apply(this);this._tar=c.createElement("v:shape");var b=SVGAnimatedLength;this.cx=new b();this.cy=new b();this.r=new b();c=b=void 0;this.addEventListener("DOMNodeInserted",function(f){if(f.eventPhase===3){return}var d=f.target,i=d.nextSibling,h=d._tar,e=d.parentNode._tar,g=null;if(h&&e){if(!i){e.appendChild(h)}else{while(i){if(i._tar&&i._tar.parentNode){g=i._tar;break}i=i.nextSibling}g&&(e=g.parentNode);e.insertBefore(h,g)}}i=h=e=g=void 0;d.addEventListener("DOMNodeInsertedIntoDocument",function(A){var H=A.target,J=H.ownerDocument.defaultView.getComputedStyle(H,""),k=parseFloat(J.getPropertyValue("font-size"));H.cx.baseVal._emToUnit(k);H.cy.baseVal._emToUnit(k);H.r.baseVal._emToUnit(k);var l=H.cx.baseVal.value,j=H.cy.baseVal.value,q=ry=H.r.baseVal.value,B=j-ry,o=l-q,t=j+ry,M=l+q,s=q*0.55228,r=ry*0.55228,K=["m",l,B,"c",l-s,B,o,j-r,o,j,o,j+r,l-s,t,l,t,l+s,t,M,j+r,M,j,M,j-r,l+s,B,l,B,"x e"];var z=H.ownerDocument.documentElement,O=H.getScreenCTM(),E=Math.round;for(var G=0,F=K.length;G<F;){if(isNaN(K[G])){++G;continue}var D=z.createSVGPoint();D.x=K[G];D.y=K[G+1];var C=D.matrixTransform(O);K[G]=E(C.x);++G;K[G]=E(C.y);++G;D=C=void 0}var L=K.join(" "),v=H._tar,N=H.ownerDocument.documentElement,u=N.width.baseVal.value,I=N.height.baseVal.value;v.path=L;v.coordsize=u+" "+I;NAIBU._setPaint(H,O);delete H._cacheMatrix;A=H=K=E=J=k=L=v=void 0},false);f=d=void 0},false)}SVGCircleElement.prototype=Object._create(SVGElement);function SVGEllipseElement(c){SVGElement.apply(this);this._tar=c.createElement("v:shape");var b=SVGAnimatedLength;this.cx=new b();this.cy=new b();this.rx=new b();this.ry=new b();c=b=void 0;this.addEventListener("DOMNodeInserted",function(f){if(f.eventPhase===3){return}var d=f.target,i=d.nextSibling,h=d._tar,e=d.parentNode._tar,g=null;if(h&&e){if(!i){e.appendChild(h)}else{while(i){if(i._tar&&i._tar.parentNode){g=i._tar;break}i=i.nextSibling}g&&(e=g.parentNode);e.insertBefore(h,g)}}i=h=e=g=void 0;d.addEventListener("DOMNodeInsertedIntoDocument",function(B){var I=B.target,K=I.ownerDocument.defaultView.getComputedStyle(I,""),k=parseFloat(K.getPropertyValue("font-size"));I.cx.baseVal._emToUnit(k);I.cy.baseVal._emToUnit(k);I.rx.baseVal._emToUnit(k);I.ry.baseVal._emToUnit(k);var l=I.cx.baseVal.value,j=I.cy.baseVal.value,r=I.rx.baseVal.value,q=I.ry.baseVal.value,C=j-q,o=l-r,u=j+q,N=l+r,t=r*0.55228,s=q*0.55228,L=["m",l,C,"c",l-t,C,o,j-s,o,j,o,j+s,l-t,u,l,u,l+t,u,N,j+s,N,j,N,j-s,l+t,C,l,C,"x e"];var A=I.ownerDocument.documentElement,P=I.getScreenCTM(),F=Math.round;for(var H=0,G=L.length;H<G;){if(isNaN(L[H])){++H;continue}var E=A.createSVGPoint();E.x=L[H];E.y=L[H+1];var D=E.matrixTransform(P);L[H]=F(D.x);++H;L[H]=F(D.y);++H;E=D=void 0}var M=L.join(" "),z=I._tar,O=I.ownerDocument.documentElement,v=O.width.baseVal.value,J=O.height.baseVal.value;z.path=M;z.coordsize=v+" "+J;NAIBU._setPaint(I,P);delete I._cacheMatrix;B=z=I=K=k=M=L=F=P=v=J=void 0},false);f=d=void 0},false)}SVGEllipseElement.prototype=Object._create(SVGElement);function SVGLineElement(c){SVGElement.apply(this);this._tar=c.createElement("v:shape");var b=SVGAnimatedLength;this.x1=new b();this.y1=new b();this.x2=new b();this.y2=new b();c=b=void 0;this.addEventListener("DOMNodeInserted",function(f){if(f.eventPhase===3){return}var d=f.target,i=d.nextSibling,h=d._tar,e=d.parentNode._tar,g=null;if(h&&e){if(!i){e.appendChild(h)}else{while(i){if(i._tar&&i._tar.parentNode){g=i._tar;break}i=i.nextSibling}g&&(e=g.parentNode);e.insertBefore(h,g)}}i=h=e=g=void 0;d.addEventListener("DOMNodeInsertedIntoDocument",function(v){var t=v.target,j=t.ownerDocument.defaultView.getComputedStyle(t,""),B=parseFloat(j.getPropertyValue("font-size"));t.x1.baseVal._emToUnit(B);t.y1.baseVal._emToUnit(B);t.x2.baseVal._emToUnit(B);t.y2.baseVal._emToUnit(B);var q=t.ownerDocument.documentElement,r=t.getScreenCTM(),z="m ",l=Math.round,k=q.createSVGPoint();k.x=t.x1.baseVal.value;k.y=t.y1.baseVal.value;var o=k.matrixTransform(r);z+=l(o.x)+" "+l(o.y)+" l ";k.x=t.x2.baseVal.value;k.y=t.y2.baseVal.value;o=k.matrixTransform(r);z+=l(o.x)+" "+l(o.y);k=o=void 0;var A=t._tar,u=q.width.baseVal.value,s=q.height.baseVal.value;A.path=z;A.coordsize=u+" "+s;NAIBU._setPaint(t,r);delete t._cacheMatrix;v=A=t=j=B=z=list=l=r=q=u=s=void 0},false);f=d=void 0},false)}SVGLineElement.prototype=Object._create(SVGElement);NAIBU._GenericSVGPolyElement=function(c,b){SVGElement.apply(this);this._tar=c.createElement("v:shape");c=void 0;this.animatedPoints=this.points=new SVGPointList();this.addEventListener("DOMAttrModified",function(e){var d=e.target;if(e.attrName==="points"){var l=d.points,h=d.ownerDocument.documentElement,j=e.newValue.replace(/^\s+|\s+$/g,"").replace(/\-/g," -").split(/[\s,]+/);for(var g=0,k,f=j.length;g<f;g+=2){if(isNaN(j[g])){--g;continue}k=h.createSVGPoint();k.x=parseFloat(j[g]);k.y=parseFloat(j[g+1]);l.appendItem(k)}}e=d=j=l=h=k=void 0},false);this.addEventListener("DOMNodeInserted",function(e){if(e.eventPhase===3){return}var d=e.target;d._inserted__(d);d.addEventListener("DOMNodeInsertedIntoDocument",function(z){var s=z.target,u=s.points,o=s.getScreenCTM(),g=Math.round;for(var l=0,t=[],r=u.numberOfItems;l<r;++l){var f=u.getItem(l),k=f.matrixTransform(o);t[2*l]=g(k.x);t[2*l+1]=g(k.y);f=k=void 0}t.splice(2,0,"l");var A="m"+t.join(" ")+b,B=s._tar,j=s.ownerDocument.documentElement,v=j.width.baseVal.value,q=j.height.baseVal.value;B.path=A;B.coordsize=v+" "+q;NAIBU._setPaint(s,o);delete s._cacheMatrix;z=B=s=A=t=g=o=v=q=j=void 0},false);e=d=void 0},false)};function SVGPolylineElement(b){NAIBU._GenericSVGPolyElement.call(this,b,"e");b=void 0}SVGPolylineElement.prototype=Object._create(SVGElement);function SVGPolygonElement(b){NAIBU._GenericSVGPolyElement.call(this,b,"x e");b=void 0}SVGPolygonElement.prototype=Object._create(SVGElement);function SVGTextContentElement(b){SVGElement.apply(this);this.textLength=new SVGAnimatedLength();this.lengthAdjust=new SVGAnimatedEnumeration(0);this.addEventListener("DOMNodeInserted",function(o){var h=o.target,l=o.currentTarget,g=o.eventPhase;if((g===1)&&(h.localName==="a")&&(h.namespaceURI==="http://www.w3.org/2000/svg")&&h.firstChild){h=h.firstChild}if((g===1)&&(h.nodeType===3)&&!!!h._tars){h._tars=[];var e=h.data.replace(/^[\r\n\s]+|[\r\n\s]+$/g,"").replace(/[\r\n\s]+/g," ");h.data=e;h.length=e.length;e=e.split("");for(var f=0,c=e.length;f<c;++f){var j=b.createElement("div"),k=j.style;k.position="absolute";k.textIndent=k.marginLeft=k.marginRight=k.marginTop=k.paddingTop=k.paddingLeft="0px";k.whiteSpace="nowrap";j.appendChild(b.createTextNode(e[f]));h._tars[h._tars.length]=j}e=void 0}o=h=l=g=void 0},true);this.addEventListener("DOMNodeInserted",function(c){if((c.eventPhase===3)&&(c.target.nodeType===3)){c.currentTarget._length=null;c=void 0}},false);this.addEventListener("DOMNodeRemoved",function(d){var c=d.target;if(d.eventPhase===3){d.currentTarget._length=null;c=d=void 0}},false)}(function(c){var b;b=c.prototype=Object._create(SVGElement);b._list=null;b._length=null;b._stx=b._sty=0;b._chars=0;b._isYokogaki=true;b.getNumberOfChars=function(){if(this._length){return(this._length)}else{var d=0,e=function(g){var f=d;while(g){if(g.length&&(g.nodeType===3)){f+=g.length}else{if(g.getNumberOfChars){f+=g.getNumberOfChars()}else{if(g.firstChild&&(g.nodeType===1)){d=f;e(g.firstChild);f=d}}}g=g.nextSibling}d=f;g=f=void 0};e(this.firstChild);e=void 0;this._length=d;return d}};b.getComputedTextLength=function(){var d=this.textLength.baseVal;if((d.value===0)&&(this.getNumberOfChars()>0)){d.newValueSpecifiedUnits(1,this.getSubStringLength(0,this.getNumberOfChars()))}d=void 0;return(this.textLength.baseVal.value)};b.getSubStringLength=function(f,i){if(i===0){return 0}var h=this.getNumberOfChars();if(h<(i+f)){i=h-f+1}var d=this.getEndPositionOfChar(i+f-1),e=this.getStartPositionOfChar(f);if(this._isYokogaki){var g=d.x-e.x}else{g=d.y-e.y}h=d=e=void 0;return g};b.getStartPositionOfChar=function(e){if(e>this.getNumberOfChars()||e<0){throw (new DOMException(1))}else{var N=this,o=N.firstChild,h=N.parentNode;if(!!!N._list){N._list=[];var E=N._chars,B=N._stx,A=N._sty,H=0,O=N.ownerDocument.defaultView.getComputedStyle(N,null),u=((O.getPropertyValue("writing-mode"))==="lr-tb")?true:false,k=parseFloat(O.getPropertyValue("font-size")),S=N.x.baseVal,R=N.y.baseVal,I=N.dx.baseVal,G=N.dy.baseVal;if(h&&((h.localName==="text")||(h.localName==="tspan"))){var Q=h.x.baseVal,P=h.y.baseVal,v=h.dx.baseVal,t=h.dy.baseVal}else{Q=P=v=t={numberOfItems:0}}var q="f ijltIr.,:;'-\"()",j="1234567890abcdeghknopquvxyz",l=k*0.5,w=k*0.2,D=(N.localName==="text"),d,g,f,F,L,K,z,r;if(u&&D){A+=w}else{if(D){B-=l}}while(o){if(o.nodeType===3){d=o._tars;for(var M=0,J=d.length;M<J;++M){if(H<Q.numberOfItems-E){B=Q.getItem(H).value;if(!u){B-=l}}else{if(H<S.numberOfItems){B=S.getItem(H).value;if(!u){B-=l}}}if(H<P.numberOfItems-E){A=P.getItem(H).value;if(u){A+=w}}else{if(H<R.numberOfItems){A=R.getItem(H).value;if(u){A+=w}}}if(H<v.numberOfItems-E){B+=v.getItem(H).value}else{if(H<I.numberOfItems){B+=I.getItem(H).value}}if(H<t.numberOfItems-E){A+=t.getItem(H).value}else{if(H<G.numberOfItems){A+=G.getItem(H).value}}g=0;if(u){f=o.data.charAt(M);if(q.indexOf(f)>-1){g=k*0.68}else{if(f==="s"){g=k*0.52}else{if((f==="C")||(f==="D")||(f==="M")||(f==="W")||(f==="G")||(f==="m")){g=w}else{if(j.indexOf(f)>-1){g=k*0.45}else{g=k*0.3}}}}}z=N._list;z[z.length]=B;z[z.length]=A;z[z.length]=k-g;if(u){B+=k;B-=g}else{A+=k}++H}E+=J;if(o.parentNode&&(o.parentNode.localName==="a")){o=o.parentNode}o=o.nextSibling}else{if(((o.localName==="tspan")||(o.localName==="tref"))&&(o.namespaceURI==="http://www.w3.org/2000/svg")&&o.firstChild){o._stx=B;o._sty=A;o._chars=E;F=o.getStartPositionOfChar(o.getNumberOfChars());L=K=0;z=o._list;if(u){L=z[z.length-1]}else{K=z[z.length-1]}B=z[z.length-3]+L;A=z[z.length-2]+K;N._list=N._list.concat(z);r=o.getNumberOfChars();H+=r;E+=r;o=o.nextSibling}else{if((o.localName==="a")&&(o.namespaceURI==="http://www.w3.org/2000/svg")&&o.firstChild){o=o.firstChild}else{o=o.nextSibling}}}}N._isYokogaki=u}N=o=D=l=w=h=Q=P=S=R=E=O=B=A=u=q=j=d=g=f=F=L=K=z=r=void 0;var C=this.ownerDocument.documentElement.createSVGPoint();C.x=this._list[e*3];C.y=this._list[e*3+1];C=C.matrixTransform(this.getScreenCTM());return C}};b.getEndPositionOfChar=function(d){if(d>this.getNumberOfChars()||d<0){throw (new DOMException(1))}else{var e=this.getStartPositionOfChar(d);var f=this._list[d*3+2]*Math.sqrt(Math.abs(this.getScreenCTM()._determinant()));if(this._isYokogaki){e.x+=f}else{e.y+=f}return e}};b.getExtentOfChar=function(d){};b.getRotationOfChar=function(d){};b.getCharNumAtPosition=function(d){};b.selectSubString=function(d,e){};c=b=void 0})(SVGTextContentElement);function SVGTextPositioningElement(c){SVGTextContentElement.apply(this,arguments);var b=SVGAnimatedLengthList;this.x=new b();this.y=new b();this.dx=new b();this.dy=new b();b=void 0;this.rotate=new SVGAnimatedNumberList();this.addEventListener("DOMAttrModified",function(r){var l=r.target,f=r.attrName,j=l.ownerDocument.documentElement,h=parseFloat;if((f==="x")||(f==="y")||(f==="dx")||(f==="dy")){var p=r.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/),t=l[f].baseVal;for(var k=0,e=p.length;k<e;++k){var q=j.createSVGLength(),g=p[k].slice(-1),o=0;if(g>="0"&&g<="9"){o=1}else{if(g==="%"){if((f==="x")||(f==="dx")){q._percent*=j.viewport.width}else{if((f==="y")||(f==="dy")){q._percent*=j.viewport.height}}o=2}else{g=p[k].slice(-2);if(g==="em"){var d=l.ownerDocument.defaultView.getComputedStyle(l,null);q._percent*=h(d.getPropertyValue("font-size"));d=void 0;o=3}else{if(g==="ex"){o=4}else{if(g==="px"){o=5}else{if(g==="cm"){o=6}else{if(g==="mm"){o=7}else{if(g==="in"){o=8}else{if(g==="pt"){o=9}else{if(g==="pc"){o=10}}}}}}}}}}var u=h(p[k]);u=isNaN(u)?0:u;q.newValueSpecifiedUnits(o,u);t.appendItem(q)}l._list=null}r=l=void 0},false);this.addEventListener("DOMNodeInserted",function(e){if(e.eventPhase===3){var d=e.target;if(d.nodeType!==3){d._list=void 0;e.currentTarget._list=null}e=d=void 0}},false);if(c){this._tar=c.createElement("v:group");this._doc=c}this.addEventListener("DOMNodeInserted",function(f){if(f.eventPhase===3){return}var d=f.target,i=d.nextSibling,h=d._tar,e=d.parentNode._tar,g=null;if(h&&e){if(!i){e.appendChild(h)}else{while(i){if(i._tar&&i._tar.parentNode){g=i._tar;break}i=i.nextSibling}g&&(e=g.parentNode);e.insertBefore(h,g)}}i=h=e=g=void 0;d.addEventListener("DOMNodeInsertedIntoDocument",d._texto,false);f=d=void 0},false)}SVGTextPositioningElement.prototype=Object._create(SVGTextContentElement);SVGTextPositioningElement.prototype._texto=function(J){var O=J.target,b=O.firstChild,F=O._tar,Q=O.ownerDocument.defaultView.getComputedStyle(O,null),C=Math.sqrt(Math.abs(O.getScreenCTM()._determinant())),R=parseFloat(Q.getPropertyValue("font-size"))*C,q=-R-5+"px",M=R+10+"px",u=O.ownerDocument.documentElement,K=F,Y=O.getComputedTextLength(),f=Q.getPropertyValue("text-anchor"),N=(f==="middle"),E=(f==="end"),e=Q.getPropertyValue("text-decoration"),A=F.style,t=[],z=parseFloat(Q.getPropertyValue("letter-spacing")),v=parseFloat(Q.getPropertyValue("word-spacing"));A.fontSize=R+"px";A.fontFamily=Q.getPropertyValue("font-family");A.fontStyle=Q.getPropertyValue("font-style");A.fontWeight=Q.getPropertyValue("font-weight");if(isFinite(z)){A.letterSpacing=z*C+"px"}if(isFinite(parseFloat(v))){A.wordSpacing=v*C+"px"}for(var X=0,W=0,r=O.getNumberOfChars();X<r;++X){if(b){if(!!b._tars&&(b._tars.length!==0)){var L=(X>W)?X-W:W-X;var H=b._tars[L].style,P=O.getStartPositionOfChar(X);H.position="absolute";if(O._isYokogaki){if(N){P.x-=Y/2}else{if(E){P.x-=Y}}}else{if(N){P.y-=Y/2}else{if(E){P.y-=Y}}}H.left=P.x+"px";H.top=P.y+"px";H.width=H.height="0px";H.marginTop=O._isYokogaki?q:"-5px";H.lineHeight=M;H.textDecoration=e;H.display="none";F.appendChild(b._tars[L]);H=P=void 0}if(b.nodeName==="#text"){if((b.data.length+W)<=X+1){W=W+b.data.length;if(b.data===""){--X}if(b.parentNode.localName==="a"){b=b.parentNode;F=K}b=b.nextSibling}}else{if(!!b.getNumberOfChars){if((b.getNumberOfChars()+W)<=X+1){W=W+b.getNumberOfChars();b=b.nextSibling}}else{if((b.localName==="a")&&(b.namespaceURI==="http://www.w3.org/2000/svg")&&b.firstChild){F=b._tar;b=b.firstChild;t[t.length]=b;if(X===0){--X}else{X-=2}}}}}}var G=Q.getPropertyValue("fill"),g=Q.getPropertyCSSValue("cursor"),U=Q.getPropertyCSSValue("visibility"),o=Q.getPropertyCSSValue("display"),D=O._tar.style,c=O.firstChild._tars,B="",S,I=function(p){if(O._isYokogaki&&(O.firstChild.nodeName==="#text")){var l=O;while(O&&O.x){if((O.localName!=="a")&&((O.x.baseVal.numberOfItems>1)||(O.y.baseVal.numberOfItems>1))){return}O=O.parentNode}O=l;for(var j=1,Z=p.length;j<Z;++j){S=p[j];S.firstChild&&(B+=S.firstChild.data);S.parentNode.removeChild(S)}if(p[0]&&p[0].replaceChild){p[0].replaceChild(O._doc.createTextNode(B),p[0].firstChild)}l=B=void 0}};if(c&&c[0]){B=c[0].innerText.charAt(0)}c&&I(c);if(G==="none"){D.color="transparent"}else{if(G.indexOf("url")===-1){D.color=G}else{D.color="black"}}if(g&&!g._isDefault){var d=g.cssText;D.cursor=d.split(":")[1];d=void 0}var h=true,s="block";if(F.lastChild){if(F.lastChild.nodeName!=="rect"){h=false}}else{h=false}if(!h){var w=O._doc.createElement("v:rect"),V=w.style;V.width=V.height="1px";V.left=V.top="0px";w.stroked=w.filled="false";F.appendChild(w)}if(U&&!U._isDefault){D.visibility=U.cssText.split(":")[1]}if(o&&!o._isDefault&&(o.cssText.indexOf("none")>-1)){s="none"}else{if(o&&!o._isDefault){s="block"}}var k=O._tar.firstChild,W=0;while(k){k.style.display=s;k=k.nextSibling}while(t[W]){c=t[W]._tars;B=c[0]?c[0].innerText.charAt(0):"";I(c);for(var T=0,r=c.length;T<r;++T){c[T].style.display=s}T=void 0;++W}delete O._cacheMatrix;f=E=N=q=M=I=t=h=J=O=Q=e=tpp=K=Q=G=g=o=U=A=w=V=s=c=k=z=C=void 0};function SVGTextElement(b){SVGTextPositioningElement.apply(this,arguments)}SVGTextElement.prototype=Object._create(SVGTextPositioningElement);function SVGTSpanElement(){SVGTextElement.apply(this,arguments)}SVGTSpanElement.prototype=Object._create(SVGTextPositioningElement);function SVGTRefElement(b){SVGTextPositioningElement.apply(this,arguments);this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===3){return}c.target.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed")},false);this.addEventListener("S_Load",function(d){var c=d.target,e=c._instance.firstChild;while(e&&(e.nodeName!=="#text")){e=e.nextSibling}e&&c.parentNode.insertBefore(c.ownerDocument.importNode(e,false),c);d.target=c.parentNode;c.parentNode._texto(d);c=e=evtt=void 0},false);SVGURIReference.apply(this)}SVGTRefElement.prototype=Object._create(SVGTextPositioningElement);function SVGTextPathElement(){SVGTextContentElement.apply(this,arguments);this.startOffset;this.method;this.spacing;SVGURIReference.apply(this)}SVGTextPathElement.prototype=Object._create(SVGTextContentElement);(function(b){})(SVGTextPathElement);function SVGPaint(){SVGColor.apply(this)}(function(c){var b;b=c.prototype=Object._create(SVGColor);b.paintType=0;b.uri=null;b.setUri=function(d){this.setPaint(103,d,null,null)};b.setPaint=function(d,f,e,g){if((d<101&&f)||(d>102&&!f)){throw new SVGException(1)}this.uri=f;this.paintType=d;if(d===102){d=3}this.setColor(d,e,g)};c=b=void 0})(SVGPaint);function SVGMarkerElement(c){SVGSVGElement.call(this,c);c=void 0;var b=SVGAnimatedLength;this.refX=new b();this.refY=new b();this.markerUnits=new SVGAnimatedEnumeration();this.markerUnits.baseVal=2;this.markerWidth=new b();this.markerHeight=new b();this.refX.baseVal.newValueSpecifiedUnits(1,0);this.refY.baseVal.newValueSpecifiedUnits(1,0);this.markerWidth.baseVal.newValueSpecifiedUnits(1,3);this.markerHeight.baseVal.newValueSpecifiedUnits(1,3);b=void 0;this.orientType=new SVGAnimatedEnumeration();this.orientType.baseVal=2;this.orientAngle=new SVGAnimatedAngle();this.addEventListener("DOMAttrModified",function(e){var d=e.target,f=e.newValue,g;if(e.attrName==="orient"){if(f==="auto"){d.setOrientToAuto()}else{g=d.ownerDocument.documentElement.createSVGAngle();g.newValueSpecifiedUnits(1,+f);d.setOrientToAngle(g)}}else{if(e.attrName==="markerUnits"){if(f==="strokeWidth"){d.markerUnits.baseVal=2}else{d.markerUnits.baseVal=1}}}},false);this.addEventListener("DOMNodeInsertedIntoDocument",function(d){var e=NAIBU._setPaint,f=d.target.getAttributeNS(null,"id");NAIBU._setPaint=(function(g,h){return function(D,I){g(D,I);var r=D.ownerDocument,j=r.documentElement,E=r.defaultView.getComputedStyle(D,""),C=E.getPropertyValue("marker-start").slice(5,-1),K=E.getPropertyValue("marker-end").slice(5,-1),G=E.getPropertyValue("marker-mid").slice(5,-1),q,s,l,i,k,o,F,I,H,p,J,z,B,v,w,A=function(t,L){s=q.cloneNode(true);l=r.createElementNS("http://www.w3.org/2000/svg","g");while(s.lastChild){l.appendChild(s.lastChild)}i=l.transform.baseVal;o=D.transform.baseVal.consolidate()||r.documentElement.createSVGMatrix();if(q.markerUnits.baseVal===2){F=E.getPropertyCSSValue("stroke-width").getFloatValue(1)}else{F=1}if(q.hasAttributeNS(null,"viewBox")){q.viewport.width=q.markerWidth.baseVal.value;q.viewport.height=q.markerHeight.baseVal.value;I=j.getScreenCTM.apply(q)}else{I=j.createSVGMatrix()}if(q.orientType.baseVal===1){angle=Math.atan2(J[1].y-J[0].y,J[1].x-J[0].x)*180/Math.PI}else{angle=q.orientAngle.baseVal.value}i.appendItem(i.createSVGTransformFromMatrix(o.translate(t,L).rotate(angle).scale(F).multiply(I).translate(-q.refX.baseVal.value,-q.refY.baseVal.value)));H=r.defaultView.getComputedStyle(q,"");p=l.style;z=/([A-Z])/;B=/\-/;for(var u in CSS2Properties){if(CSS2Properties.hasOwnProperty(u)&&(u!=="_list")){u=u.replace(z,"-");if(RegExp.$1){v="-"+RegExp.$1.toLowerCase()}else{v="-"}u=u.replace(B,v);p.setProperty(u,H.getPropertyValue(u),"")}}D.parentNode.insertBefore(l,D.nextSibling)};if(C===h){q=r.getElementById(C);if(D.normalizedPathSegList||D.points){k=D.normalizedPathSegList||D.points;J=[k.getItem(0),k.getItem(1)];if(!J[1].x){J[1]=J[0]}}else{if(D.x1){J=[{x:D.x1.baseVal.value,y:D.y1.baseVal.value},{x:D.x2.baseVal.value,y:D.y2.baseVal.value}]}}A(J[0].x,J[0].y)}if(K===h){q=r.getElementById(K);if(D.normalizedPathSegList||D.points){k=D.normalizedPathSegList||D.points;J=[k.getItem(k.numberOfItems-2),k.getItem(k.numberOfItems-1)];if(!J[1].x){J[1]=k.getItem(0)}}else{if(D.x1){J=[{x:D.x1.baseVal.value,y:D.y1.baseVal.value},{x:D.x2.baseVal.value,y:D.y2.baseVal.value}]}}A(J[1].x,J[1].y)}if(G===h){q=r.getElementById(G)}r=j=E=H=p=C=K=G=q=s=l=I=F=i=k=o=J=z=B=v=w=A=void 0}})(e,f)},false)}(function(b){b.prototype=Object._create(SVGSVGElement);b.prototype.getScreenCTM=SVGElement.prototype.getScreenCTM;b.prototype.setOrientToAuto=function(){this.orientType.baseVal=1};b.prototype.setOrientToAngle=function(c){this.orientType.baseVal=2;this.orientAngle.baseVal=c}})(SVGMarkerElement);function SVGColorProfileElement(){SVGElement.apply(this);this._local;this.name;this.renderingIntent;SVGURIReference.apply(this)}SVGColorProfileElement.prototype=Object._create(SVGElement);function SVGColorProfileRule(){SVGCSSRule.apply(this);this.src;this.name;this.renderingIntent}SVGColorProfileRule.prototype=Object._create(SVGCSSRule);function SVGGradientElement(){SVGElement.apply(this);SVGURIReference.apply(this);this.gradientUnits=new SVGAnimatedEnumeration();this.gradientTransform=new SVGAnimatedTransformList();this.spreadMethod=new SVGAnimatedEnumeration();this.addEventListener("DOMNodeInsertedIntoDocument",function(l){var e=l.target,j=l._tar,k=l._style,c=e,v,f,d,q=[],g=[],b=[],p,w,h,s,r;if(!j||!e){e=j=k=c=v=f=d=q=g=b=void 0;return}if(e._instance){c=e._instance}f=c.getElementsByTagNameNS("http://www.w3.org/2000/svg","stop");if(!f){j=k=v=e=c=f=q=g=b=void 0;return}d=f.length;for(var u=0;u<d;++u){p=f[u];w=p.ownerDocument.defaultView.getComputedStyle(p,"");h=w.getPropertyCSSValue("stop-color");if(h&&(h.colorType===3)){w.setProperty("color",w.getPropertyValue("color"))}q[u]="rgb("+h.rgbColor.red.getFloatValue(1)+","+h.rgbColor.green.getFloatValue(1)+","+h.rgbColor.blue.getFloatValue(1)+")";g[u]=p.offset.baseVal.toPrecision(2)+" "+q[u];b[u]=(w.getPropertyValue("stop-opacity")||1)*k.getPropertyValue("fill-opacity")*k.getPropertyValue("opacity")}j.method="none";j.color=q[0];j.color2=q[d-1];if(d>2){j.colors=g.slice(1,-1).join(",");s=b[d-1]+"";r=b[0]+""}else{r=b[d-1]+"";s=b[0]+""}j.opacity=s;j["o:opacity2"]=r;e._color=q;var o=c.getAttributeNS(null,"gradientTransform");if(o){e.setAttributeNS(null,"transform",o)}e=c=j=f=d=q=g=b=l=k=v=p=w=h=s=r=void 0},false)}SVGGradientElement.prototype=Object._create(SVGElement);function SVGLinearGradientElement(){SVGGradientElement.apply(this);var b=SVGAnimatedLength;this.x1=new b();this.y1=new b();this.x2=new b();this.y2=new b();b=void 0;this.addEventListener("DOMNodeInsertedIntoDocument",function(c){var h=c.target,f=c._tar,g=270;if(!!!f){return}var d=h.ownerDocument.defaultView.getComputedStyle(h,"");var e=parseFloat(d.getPropertyValue("font-size"));h.x1.baseVal._emToUnit(e);h.y1.baseVal._emToUnit(e);h.x2.baseVal._emToUnit(e);h.y2.baseVal._emToUnit(e);g=270-Math.atan2(h.y2.baseVal.value-h.y1.baseVal.value,h.x2.baseVal.value-h.x1.baseVal.value)*180/Math.PI;if(g>=360){g-=360}f.setAttribute("type","gradient");f.setAttribute("angle",g+"");c=f=h=g=d=e=void 0},false)}SVGLinearGradientElement.prototype=Object._create(SVGGradientElement);function SVGRadialGradientElement(c){SVGGradientElement.apply(this);var b=SVGAnimatedLength;this.cx=new b();this.cy=new b();this.r=new b();this.fx=new b();this.fy=new b();b=void 0;this.cx.baseVal.value=this.cy.baseVal.value=this.r.baseVal.value=0.5;this.addEventListener("DOMNodeInsertedIntoDocument",function(B){var l=B.target,X=B._tar,D=B._ttar;if(!!!X){return}X.setAttribute("type","gradientTitle");X.setAttribute("focus","100%");X.setAttribute("focusposition","0.5 0.5");if(D.localName==="rect"){var L=l.ownerDocument.defaultView.getComputedStyle(D,""),k=parseFloat(L.getPropertyValue("font-size"));l.cx.baseVal._emToUnit(k);l.cy.baseVal._emToUnit(k);l.r.baseVal._emToUnit(k);l.fx.baseVal._emToUnit(k);l.fy.baseVal._emToUnit(k);var v=l.cx.baseVal.value,t=l.cy.baseVal.value,H=l.r.baseVal.value,A,z;A=z=H;var F=D.getBBox(),q=D.ownerDocument.documentElement.viewport,T=q.width|0,I=q.height|0,N=0,d=0,U=l.getAttributeNS(null,"gradientUnits");if(!U||U==="objectBoundingBox"){v=v>1?v/100:v;t=t>1?t/100:t;H=H>1?H/100:H;var O=F.x,K=F.y,S=F.width,Q=F.height;v=v*S+O;t=t*Q+K;A=H*S;z=H*Q;O=K=S=Q=void 0}var C=D.getScreenCTM().multiply(l.getCTM());T=v-A;I=t-z;N=v+A;d=t+z;var j=A*0.55228,g=z*0.55228,u=["m",v,I,"c",v-j,I,T,t-g,T,t,T,t+g,v-j,d,v,d,v+j,d,N,t+g,N,t,N,t-g,v+j,I,v,I,"x e"];for(var P=0,M=u.length;P<M;){if(isNaN(u[P])){++P;continue}var J=l.ownerDocument.documentElement.createSVGPoint();J.x=parseFloat(u[P]);J.y=parseFloat(u[P+1]);var f=J.matrixTransform(C);u[P]=f.x|0;P++;u[P]=f.y|0;P++;J=f=void 0}var W=u.join(" "),e=c.getElementById("_NAIBU_outline"),E=c.createElement("div"),s=E.style;s.position="absolute";s.display="inline-block";var G=q.width,R=q.height;s.textAlign="left";s.top=s.left="0px";s.width=G+"px";s.height=R+"px";e.appendChild(E);s.filter="progid:DXImageTransform.Microsoft.Compositor";E.filters.item("DXImageTransform.Microsoft.Compositor").Function=23;var o='<v:shape style="display:inline-block; position:relative; antialias:false; top:0px; left:0px;" coordsize="'+G+" "+R+'" path="'+W+'" stroked="f">'+X.outerHTML+"</v:shape>",V=D._tar.path.value;E.innerHTML='<v:shape style="display:inline-block; position:relative; top:0px; left:0px;" coordsize="'+G+" "+R+'" path="'+V+'" stroked="f" fillcolor="'+l._color[l._color.length-1]+'" ></v:shape>';E.filters[0].apply();E.innerHTML=o;E.filters[0].play();D._tar.parentNode.insertBefore(E,D._tar);D._tar.filled="false";W=e=E=L=k=s=o=V=u=gt=v=t=H=G=R=C=void 0}else{if(!X.parentNode){D._tar.appendChild(X)}}B=D=X=gard=void 0},false)}SVGRadialGradientElement.prototype=Object._create(SVGGradientElement);function SVGStopElement(){SVGElement.apply(this);this.offset=new SVGAnimatedNumber();this.addEventListener("DOMAttrModified",function(b){if(b.attrName==="offset"){var c=b.newValue;if(c.slice(-1)!=="%"){b.target.offset.baseVal=+c}else{b.target.offset.baseVal=parseFloat(c)/100}}b=void 0},false)}SVGStopElement.prototype=Object._create(SVGElement);function SVGPatternElement(){SVGElement.apply(this);var b=SVGAnimatedLength;this.patternUnits=new SVGAnimatedEnumeration();this.patternContentUnits=new SVGAnimatedEnumeration();this.patternTransform=new SVGAnimatedTransformList();this.x=new b();this.y=new b();this.width=new b();this.height=new b();b=void 0;SVGURIReference.apply(this);this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.zoomAndPan=1}SVGPatternElement.prototype=Object._create(SVGElement);function SVGClipPathElement(){SVGElement.apply(this);this.clipPathUnits=new SVGAnimatedEnumeration()}SVGClipPathElement.prototype=Object._create(SVGElement);function SVGMaskElement(){SVGElement.apply(this);var b=SVGAnimatedLength;this.maskUnits=new SVGAnimatedEnumeration();this.maskContentUnits=new SVGAnimatedEnumeration();this.x=new b();this.y=new b();this.width=new b();this.height=new b();b=void 0}SVGMaskElement.prototype=Object._create(SVGElement);function SVGFilterElement(){SVGElement.apply(this);var b=SVGAnimatedLength;this.filterUnits=new SVGAnimatedEnumeration();this.primitiveUnits=new SVGAnimatedEnumeration();this.x=new b();this.y=new b();this.width=new b();this.height=new b();b=void 0;this.filterResX=new SVGAnimatedInteger();this.filterResY=new SVGAnimatedInteger();SVGURIReference.apply(this)}SVGFilterElement.prototype=Object._create(SVGElement);function SVGFilterPrimitiveStandardAttributes(c){SVGStylable.apply(this,arguments);this._tar=c;var b=SVGAnimatedLength;this.x=new b();this.y=new b();this.width=new b();this.height=new b();this.result=new b();b=void 0}SVGFilterPrimitiveStandardAttributes.prototype=Object._create(SVGStylable);function SVGFEBlendElement(){SVGElement.apply(this);this.in1=new SVGAnimatedString();this.in2=new SVGAnimatedString();this.mode=new SVGAnimatedEnumeration();this._fpsa=SVGFilterPrimitiveStandardAttributes(this)}SVGFEBlendElement.prototype=Object._create(SVGElement);function SVGFEGaussianBlurElement(){SVGElement.apply(this);this.in1=new SVGAnimatedString();this.stdDeviationX=new SVGAnimatedNumber();this.stdDeviationY=new SVGAnimatedNumber();this._fpsa=SVGFilterPrimitiveStandardAttributes(this)}SVGFEGaussianBlurElement.prototype=Object._create(SVGElement);SVGFEGaussianBlurElement.prototype.setStdDeviation=function(c,b){};function SVGCursorElement(){SVGElement.apply(this);this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();SVGURIReference.apply(this)}SVGCursorElement.prototype=Object._create(SVGElement);function SVGAElement(b){SVGElement.apply(this);this._tar=b.createElement("a");b=void 0;this.target=new SVGAnimatedString();this.target.baseVal="_self";this.addEventListener("DOMAttrModified",function(d){var c=d.target;if(d.eventPhase===3){return}if(d.attrName==="target"){c.target.baseVal=d.newValue}else{if(d.attrName==="xlink:title"){c._tar.setAttribute("title",d.newValue)}}d=void 0},false);this.addEventListener("DOMNodeInserted",function(d){var c=d.target;if(d.eventPhase===3){return}if(c.nextSibling){if(c.parentNode._tar&&c.nextSibling._tar){c.parentNode._tar.insertBefore(c._tar,c.nextSibling._tar)}}else{if(c.parentNode._tar){c.parentNode._tar.appendChild(c._tar)}}var f=c._tar.style;f.cursor="hand";f.left="0px";f.top="0px";f.textDecoration="none";f=void 0;var g=c.target.baseVal,e="replace";if(g==="_blank"){e="new"}c.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show",e);c._tar.style.color=c.ownerDocument.defaultView.getComputedStyle(c,"").getPropertyValue("fill");c=d=void 0},false);this.addEventListener("DOMNodeInsertedIntoDocument",function(d){var c=d.target;if(!!c._tar&&(c.nodeType===1)){var e=c._tar.style;e.cursor="hand";e.textDecoration="none";e=void 0}c=d=void 0;return},true);this.addEventListener("DOMNodeInsertedIntoDocument",function(d){var c=d.target;c._tar.setAttribute("target",c.target.baseVal);if(c.href.baseVal.indexOf(".svg")!==-1){c.addEventListener("click",function(f){var e=f.target,h=document.body,g,i;h.lastChild.innerHTML="<object data='"+e.href.baseVal.split("#")[0]+"' width='"+screen.width+"' height='"+screen.height+"' type='image/svg+xml'></object>";if(e.target.baseVal==="_self"){i=e.ownerDocument._iframe;i.parentNode.insertBefore(h.lastChild.firstChild,i);g=i.nextSibling;if(g&&(g.tagName==="OBJECT")){i.previousSibling.setAttribute("width",g.getAttribute("width"));i.previousSibling.setAttribute("height",g.getAttribute("height"));i.parentNode.removeChild(g)}g=NAIBU._search([i.previousSibling]);i.parentNode.removeChild(i)}else{h.appendChild(h.lastChild.firstChild);while(h.firstChild!==h.lastChild){h.removeChild(h.firstChild)}g=NAIBU._search([h.lastChild])}NAIBU.doc=new ActiveXObject("MSXML2.DomDocument");f.preventDefault();g._next={_init:(function(j){return(function(){document.title=j.getSVGDocument().title;j=void 0})})(g)};g._init();h=g=i=void 0},false)}c=void 0},false);SVGURIReference.apply(this)}SVGAElement.prototype=Object._create(SVGElement);function SVGViewElement(){SVGElement.apply(this);this.viewTarget=new SVGStringList();this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.zoomAndPan=1}SVGViewElement.prototype=Object._create(SVGElement);function SVGScriptElement(){SVGElement.apply(this);this.type;SVGURIReference.apply(this);this.addEventListener("DOMAttrModified",function(evt){if(evt.attrName==="type"){evt.target.type=evt.newValue}evt=void 0},false);this.addEventListener("S_Load",function(evt){var tar=evt.target,script=tar._text;var tod=tar.ownerDocument;NAIBU._temp_doc=tod;script=script.replace(/function\s+([^\s\(]+)\(/g,"document.$1 || (document.$1 = $1);function $1(");script="with({NAIBU:NAIBU, document:NAIBU._temp_doc, window:this}){(function(){"+script+"\n})();}";try{NAIBU.eval(script)}catch(e){script=script.replace(/([^a-zA-Z])document\./g,"$1NAIBU._temp_doc.");NAIBU.eval(script)}tar=evt=script=void 0},false);this.addEventListener("DOMNodeInserted",function(evt){var tar=evt.target,cur;if(evt.eventPhase===3){if(tar.data&&/[a-z]/.test(tar.data)){cur=evt.currentTarget;cur._text=tar.data;evt=tar.ownerDocument.createEvent("SVGEvents");evt.initEvent("S_Load",false,false);cur.dispatchEvent(evt)}evt=tar=cur=void 0;return}tar.addEventListener("DOMNodeInsertedIntoDocument",function(evt){var tar=evt.target;if(evt.eventPhase===2&&!tar.getAttributeNodeNS("http://www.w3.org/1999/xlink","xlink:href")){var evtt=tar.ownerDocument.createEvent("SVGEvents");evtt.initEvent("S_Load",false,false);evt.currentTarget.dispatchEvent(evtt)}tar=evt=evtt=void 0},false)},false)}SVGScriptElement.prototype=Object._create(SVGElement);function SVGEvent(){Event.apply(this)}SVGEvent.prototype=Object._create(Event);function SVGZoomEvent(){UIEvent.apply(this);this.zoomRectScreen=new SVGRect();this.previousScale=this.newScale=1;this.previousTranslate=new SVGPoint();this.newTranslate=new SVGPoint()}SVGZoomEvent.prototype=Object._create(UIEvent);function SVGAnimationElement(){SVGElement.apply(this);this.style.setProperty=function(){};this._tar=null;this.targetElement;this._begin=this._end=this._repeatCount=this._repeatDur=this._dur=this._resatrt=null;this._currentFrame=0;this._isRepeat=false;this._numRepeat=0;this._isStarted=false;this._start=this._finish=this._starting=null;this._activeDur=0;this._from=this._to=this._values=this._by=null;this._keyTimes=null;this.addEventListener("beginEvent",function(r){try{var k=r.target,c=k.getStartTime(),l=k._dur,b=k._getOffset(l),h=k._finish,p=k._end,d=k._repeatDur,g=k._repeatCount,s=null;if(h){for(var j=0,q=h.length;j<q;++j){if(h[j]>=c){h=h[j];break}}}else{p=null}var f=h-c;if((d==="indefinite")||(g==="indefinite")){s=(p)?f:null}else{if(l==="indefinite"){s=(!g&&!p)?null:(g&&!p)?k._getOffset(d):(!g&&p)?f:(k._getOffset(d)>f)?k._getOffset(d):f}else{s=(l&&!d&&!g&&!p)?b:(l&&!d&&g&&!p)?b*(+g):(l&&d&&!g&&!p)?k._getOffset(d):(l&&!d&&!g&&p&&(b>f))?b:((l&&!d&&!g&&p)&&(b<=f))?f:(l&&d&&g&&!p&&(+g*b>k._getOffset(d)))?+g*b:(l&&d&&g&&!p&&(+g*b<=k._getOffset(d)))?k._getOffset(d):(l&&d&&g&&p&&(+g*b>Math.min(+d,f)))?+g*b:(l&&d&&g&&p&&(+g*b<=Math.min(+d,f)))?Math.min(k._getOffset(d),f):(l&&d&&!g&&p&&(k._getOffset(d)>f))?k._getOffset(d):(l&&d&&!g&&p&&(k._getOffset(d)<=f))?f:(l&&!d&&g&&p&&(+g*b>f))?+g*b:(l&&!d&&g&&p&&(+g*b<=f))?f:null}}}catch(o){k.endElementAt(1);throw new DOMException(11)}if((s||(s===0))&&isFinite(s)){p||k.endElementAt(s);k._activeDur=s}k=c=b=l=h=p=d=g=s=f=void 0},false);this.addEventListener("DOMAttrModified",function(c){if(c.eventPhase===3){return}var b=c.target,d=c.attrName,g=c.newValue;if(d==="begin"){b._begin=g.replace(/\s+/g,"").split(";")}else{if(d==="end"){b._end=g.replace(/\s+/g,"").split(";")}else{if(d==="dur"){b._dur=g}else{if(d==="repeatCount"){b._repeatCount=g;b._isRepeat=true}else{if(d==="repeatDur"){b._repeatCount=g;b._isRepeat=true}else{if(d==="from"){b._from=g}else{if(d==="to"){b._to=g}else{if(d==="values"){b._values=g.split(";")}else{if(d==="by"){b._by=g}else{if(d==="keyTimes"){var f=g.split(";");b._keyTimes=[];for(var e=0;e<f.length;++e){b._keyTimes[e]=parseFloat(f[e])}f=void 0}else{if(d==="restart"){b._restart=g}}}}}}}}}}}c=g=void 0},false);this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===3){return}var b=c.target;b.addEventListener("DOMNodeInsertedIntoDocument",function(e){var d=e.target;if(d._values){}else{if(d._from&&d._to){d._values=[d._from,d._to]}else{if(d._from&&d._by){var l=parseFloat(d._from)+parseFloat(d._by),f=d._from.match(/\D+/)||[""];d._values=[d._from,l+f[0]]}else{if(d._to){d._values=[null,d._to]}else{if(d._by){d._values=[null,null,d._by]}else{if(!d.hasChildNodes()&&!d.hasAttributeNS(null,"path")){return d}}}}}}var j=d,h=function(t,o,s){var r=function(){var v=t.indexOf(".");if((v>0)&&(/[a-z]/i).test(t.charAt(v+1))){return(t.slice(0,v))}v=nn=void 0;return""},u;if(isFinite(parseFloat(t))){j[o](s)}else{if(t.indexOf("repeat(")>-1){var i=parseFloat(t.slice(7)),q=(function(w,v,z){return function(A){if(i===A.target._numRepeat){w[v](z)}}})(j,o,s),u=r();if(u){j.ownerDocument.getElementById(u).addEventListener("repeatEvent",q)}else{j.addEventListener("repeatEvent",q)}}else{if(/\.(begin|end)/.test(t)){u=r();if(u){var q=(function(w,v,z){return function(A){w[v](z)}})(j,o,s),p="";/\.(begin|end)/.test(t);if(RegExp.$1==="begin"){p="beginEvent"}else{if(RegExp.$1==="end"){p="endEvent"}}j.ownerDocument.getElementById(u).addEventListener(p,q,false)}}else{if(t.indexOf("wallclock(")===0){}else{if(t==="indefinite"){}else{if(t.indexOf("accesskey(")>-1){}else{u=r();var q=(function(w,v,z){return function(A){w[v](z)}})(j,o,s);if(u&&t.match(/\.([a-z]+)/i)){j.ownerDocument.getElementById(u).addEventListener(RegExp.$1,q)}else{if(t){j.targetElement.addEventListener(t.match(/^[a-z]+/i)[0],q)}}}}}}}}t=r=u=void 0};if(d._begin){for(var g=0,k=d._begin.length;g<k;++g){h(d._begin[g],"beginElementAt",d._getOffset(d._begin[g]))}}else{d.beginElementAt(0)}if(d._end){for(var g=0,k=d._end.length;g<k;++g){h(d._end[g],"endElementAt",d._getOffset(d._end[g]))}}j=void 0;if(d.hasAttributeNS("http://www.w3.org/1999/xlink","xlink:href")){d.targetElement=d.ownerDocument.getElementById(d.getAttributeNS("http://www.w3.org/1999/xlink","xlink:href").slice(1))}else{d.targetElement=d.parentNode}e=d=void 0},false);c=b=void 0},false)}(function(b){SVGAnimationElement.prototype=b;b.beginElement=function(){var d=this.ownerDocument,c=d.createEvent("TimeEvents");this._starting=d.documentElement.getCurrentTime();if(this._isStarted&&((this._restart==="never")||((this._restart==="whenNotActive")&&(this.getCurrentTime()>0)))){return}if(this.getCurrentTime()>0){this.endElement()}c.initTimeEvent("beginEvent",d.defaultView,0);this.dispatchEvent(c);this._start&&this._start.shift();this._isStarted=true;d=c=void 0};b.endElement=function(){var d=this.ownerDocument,c=d.createEvent("TimeEvents");c.initTimeEvent("endEvent",d.defaultView,0);this.dispatchEvent(c);this._finish&&this._finish.shift();this._currentFrame=0};b.beginElementAt=function(f){var c=this.ownerDocument.documentElement.getCurrentTime(),g=this._start||[];for(var e=0,d=g.length;e<d;++e){if(g[e]===(f+c)){c=g=f=void 0;return}}g.push(f+c);g.sort(function(i,h){return i-h});this._start=g;c=g=f=void 0};b.endElementAt=function(e){var c=this.ownerDocument.documentElement.getCurrentTime(),g=this._finish||[];for(var d=0,f=g.length;d<f;++d){if(g[d]===(e+c)){c=g=e=void 0;return}}g.push(e+c);g.sort(function(i,h){return i-h});this._finish=g;c=start=e=void 0};b._eventRegExp=/(mouse|activ|clic|begi|en)[a-z]+/;b._timeRegExp=/[\-\d\.]+(h|min|s|ms)?$/;b._unit={h:3600000,min:60000,s:1000};b._getOffset=function(e){var c=null,f=[e.indexOf("+"),e.indexOf("-")],d;if(f[0]>-1){d=e.slice(f[0]);c=parseFloat(d)}else{if(f[1]>-1){d=e.slice(f[1]);c=parseFloat(d)}else{d=e;c=parseFloat(e)}}if(isFinite(c)){if(/\d+\:(\d\d)\:([\d\.]+)$/.test(d)){c=(c*3600+parseInt(RegExp.$1,10)*60+parseFloat(RegExp.$2))*1000}else{if(/\d\d\:([\d\.]+)$/.test(d)){c=(c*60+parseFloat(RegExp.$1))*1000}else{if(/(h|min|s)$/.test(d)){c*=this._unit[RegExp.$1]}}}if(isFinite(c)){c*=0.8;return c}}return 0};b.getStartTime=function(){if(this._starting||(this._starting===0)){return(this._starting)}else{throw new DOMException(11)}};b.getCurrentTime=function(){return(this._currentFrame*125*0.8)};b.getSimpleDuration=function(){if(!this._dur&&!this._finish&&(this._dur==="indefinite")){throw new DOMException(9)}else{return(this._getOffset(this._dur))}}})(Object._create(SVGElement));NAIBU.Time={currentFrame:0,Max:17000,start:function(){if(NAIBU.Clip.length>0){screen.updateInterval=42;window.onscroll=function(){screen.updateInterval=0;screen.updateInterval=42};NAIBU.stop=setInterval((function(){try{var d=NAIBU.Time.currentFrame,f=NAIBU.Clip,r=d*100;if(d>NAIBU.Time.Max){clearInterval(NAIBU.stop)}f[0]&&f[0].ownerDocument.documentElement.setCurrentTime(r);for(var g=0,k=f.length;g<k;++g){var q=f[g],l=r+100,p=r-100;if(q._start){var b=q._start[0];if(b&&q._finish&&(b===q._finish[0])){q.endElement()}if((b||(b===0))&&(p<=b)&&(b<r)){q.beginElement()}b=void 0}if(q._isRepeat&&(q.getCurrentTime()>=q.getSimpleDuration()*q._numRepeat)){var h=q.ownerDocument,o=h.createEvent("TimeEvents");++q._numRepeat;o.initTimeEvent("repeatEvent",h.defaultView,q._numRepeat);q.dispatchEvent(o);h=o=void 0}if(q._finish&&(q.getCurrentTime()!==0)){var c=q._finish[0];if((c||(c===0))&&(p<=c)&&(c<=r)){q.endElement()}c=void 0}if(q._frame){++q._currentFrame;q._frame()}}++NAIBU.Time.currentFrame;d=f=r=q=p=l=void 0}catch(j){}}),1)}else{window.onscroll=function(){screen.updateInterval=0;window.onscroll=NAIBU.emptyFunction}}}};NAIBU.Clip=[];function SVGAnimateElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._valueList=[];this._isDiscrete=false;this.addEventListener("DOMAttrModified",function(b){if(b.eventPhase===3){return}if((b.attrName==="calcMode")&&(b.newValue==="discrete")){b.target._isDiscrete=true}},false);this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===3){return}var b=c.target;b.addEventListener("DOMNodeInsertedIntoDocument",function(r){var k=r.target,p=k.getAttributeNS(null,"attributeName"),s=k.targetElement,l=s[p];var h=s.cloneNode(false);if(!k._values[0]){var f=s.ownerDocument.defaultView.getComputedStyle(s,"");k._values[0]=s.getAttributeNS(null,p)||f.getPropertyValue(p);if(!k._values[1]&&k._values[2]){var q=parseFloat(k._values[0])+parseFloat(k._values[2]),o=k._values[0].match(/\D+/)||[""];k._values[1]=q+o[0];k._values.pop();q=o=void 0}}if(("animatedPoints" in s)&&(p==="points")){s.animatedPoints=h.points;for(var j=0,g=k._values,e=g.length;j<e;++j){var d=s.cloneNode(false);delete d._tar;d.setAttributeNS(null,"points",g[j]);k._valueList[k._valueList.length]=d.points}}else{if(!!l){l.animVal=h[p].baseVal;for(var j=0,g=k._values,e=g.length;j<e;++j){var d=s.cloneNode(false);delete d._tar;d.setAttributeNS(null,p,g[j]);k._valueList[k._valueList.length]=d[p].baseVal}}else{if(!!CSS2Properties[p]||p.indexOf("-")>-1){for(var j=0,g=k._values,e=g.length;j<e;++j){if((p==="fill")||(p==="stroke")||(p==="stop-color")){k._valueList[j]=new SVGPaint();k._valueList[j].setPaint(1,null,g[j],null)}else{k._valueList[j]=parseFloat(g[j])}}}else{if(("normalizedPathSegList" in s)&&(p==="d")){s.animatedNormalizedPathSegList=h.normalizedPathSegList;for(var j=0,g=k._values,e=g.length;j<e;++j){var d=s.cloneNode(false);delete d._tar;d.setAttributeNS(null,"d",g[j]);k._valueList[k._valueList.length]=d.normalizedPathSegList}}else{h=void 0;return}}}}r=l=d=h=void 0},false)},false);this.addEventListener("beginEvent",function(d){var c=d.target,e=c.getAttributeNS(null,"attributeName"),g=c.targetElement.attributes.getNamedItemNS(null,e),f=c.targetElement,b=f[e];c._frame=function(){var o=c,p=o._isRepeat?o.getSimpleDuration():o._activeDur,k=o._valueList.length-1,j=o.getCurrentTime();o._activeDur||(p=0);p*=0.8;if((k!==-1)&&(p!==0)&&(j<=p)){if(o._isDiscrete){++k}var w=Math.floor((j*k)/p);if(w===k){w-=1}}else{return}var u=o.ownerDocument._domnodeEvent();if(o._keyTimes){var q=(o._keyTimes[w+1]-o._keyTimes[w])*p;var h=o._keyTimes[w]}else{var q=p/k;var h=w/k}if(("animatedPoints" in f)&&(e==="points")){var i=f.points;f.points=f.animatedPoints;f.dispatchEvent(u);f.animatedPoints=f.points;f.points=i}else{if(!!b){var i=b.baseVal,l=b.animVal;var s=o._valueList[w].value;if(!o._isDiscrete){var r=o._valueList[w+1].value,t=s+(r-s)*(j-h*p)/q}else{var t=s}l.newValueSpecifiedUnits(i.unitType,t);b.baseVal=l;l=void 0;f.dispatchEvent(u);b.animVal=b.baseVal;b.baseVal=i;q=void 0}else{if(!!CSS2Properties[e]||e.indexOf("-")>-1){var i=null;var s=o._valueList[w].value,r=o._valueList[w+1].value;if(!o._isDiscrete){var t=s+(r-s)*(j-h*p)/q}else{var t=s}}else{if(("normalizedPathSegList" in f)&&(e==="d")){var i=f.normalizedPathSegList;f.normalizedPathSegList=f.animatedNormalizedPathSegList;f.dispatchEvent(u);f.animatedNormalizedPathSegList=f.normalizedPathSegList;f.normalizedPathSegList=i}}}}u=o=s=r=t=p=k=w=j=void 0};d=vir=void 0},false);this.addEventListener("endEvent",function(c){var b=c.target,d=b.getAttributeNS(null,"fill");if(!d||(d==="remove")){var c=b.ownerDocument._domnodeEvent();b.targetElement.dispatchEvent(c);c=void 0;b._frame&&b._frame()}delete b._frame},false);this.addEventListener("repeatEvent",function(c){var b=c.target},false)}SVGAnimateElement.prototype=Object._create(SVGAnimationElement);function SVGSetElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._to="";this.addEventListener("DOMAttrModified",function(c){var b=c.target,d=c.attrName;if(d==="to"){b._to=c.newValue}b=d=void 0},false);this.addEventListener("beginEvent",function(d){var c=d.target;c._currentFrame=1;if(c.targetElement){var e=c.getAttributeNS(null,"attributeName"),h=c.targetElement.attributes.getNamedItemNS(null,e),b=c.targetElement[e];if(!!CSS2Properties[e]||e.indexOf("-")>-1){c._prestyle=c.ownerDocument.defaultView.getComputedStyle(c.targetElement,"").getPropertyValue(e);var f=c.ownerDocument.getOverrideStyle(c.targetElement,"");f.setProperty(e,c.getAttributeNS(null,"to"),null);f=void 0}else{if(!!b){var g=b.baseVal;if(g instanceof SVGLength){b.baseVal=c.ownerDocument.documentElement.createSVGLength()}else{if(g instanceof SVGRect){b.baseVal=c.ownerDocument.documentElement.createSVGRect()}}var d=c.ownerDocument.createEvent("MutationEvents");d.initMutationEvent("DOMAttrModified",true,false,h,h,c._to,e,1);c.targetElement.dispatchEvent(d);d=void 0;b.animVal=b.baseVal;b.baseVal=g}}}d=c=e=void 0},false);this.addEventListener("endEvent",function(d){var c=d.target,g=c.getAttributeNS(null,"fill");if(!g||(g==="remove")){var e=c.getAttributeNS(null,"attributeName"),f=c.ownerDocument.getOverrideStyle(c.targetElement,"");if(c._prestyle){f.setProperty(e,c._prestyle,null)}else{var b=c.ownerDocument._domnodeEvent();c.targetElement.dispatchEvent(b)}e=f=b=void 0}c=g=void 0},false);this.addEventListener("repeatEvent",function(c){var b=c.target,d=b.getAttributeNS(null,"attributeName"),e=b.ownerDocument.defaultView.getComputedStyle(b.targetElement,"")},false)}SVGSetElement.prototype=new SVGAnimationElement(1);function SVGAnimateMotionElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this.addEventListener("DOMAttrModified",function(c){if(c.eventPhase===3){return}var b=c.target,e=c.attrName;if(e==="path"){var f=b.ownerDocument.createElementNS("http://www.w3.org/2000/svg","path");f.setAttributeNS(null,"d",c.newValue);b._path=f;f=void 0}},false);this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===3){return}var b=c.target;b.addEventListener("DOMNodeInsertedIntoDocument",function(e){var d=[],h;if(b._values){for(var f=0,j=b._values,g=j.length;f<g;++f){h=j[f];h=h.split(",");d[f]=[+h[0],+h[1]]}b._valueList=d}},false)},false);this.addEventListener("beginEvent",function(c){var b=c.target,d=b.targetElement.transform;d.animVal=new SVGTransformList();if(d.baseVal.numberOfItems!==0){d.animVal.initialize(d.baseVal.createSVGTransformFromMatrix(d.baseVal.consolidate().matrix))}else{d.animVal.appendItem(b.ownerDocument.documentElement.createSVGTransform())}b._frame=function(){var s=b,o=s._path,t=s._isRepeat?s.getSimpleDuration():s._activeDur,q=t*0.8,g=s.getCurrentTime(),v;s._activeDur||(q=0);if(t===0){t=void 0;return}if(o){var w=o.getTotalLength()*g/q,f=o.getPointAtLength(w),z=s.targetElement.transform;z.animVal.getItem(z.animVal.numberOfItems-1).setTranslate(f.x,f.y);var e=z.baseVal;z.baseVal=z.animVal;s.targetElement._cacheMatrix=null;var u=s.ownerDocument.createEvent("MutationEvents");u.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);s.targetElement.dispatchEvent(u);z.baseVal=e;u=e=z=w=f=void 0}else{if(b._valueList){var r=0,w=0,k=b._valueList,h=k.length-1;if((h!==-1)&&(q!==0)&&(g<=q)){v=Math.floor((g*h)/q);if(v===h){v-=1}}else{return}for(var l=1,j=k.length;l<j;l+=2){r+=Math.sqrt(Math.pow(k[l][1]-k[l-1][1],2)+Math.pow(k[l][0]-k[l-1][0],2))}for(var l=1;l<v;l+=2){w+=Math.sqrt(Math.pow(k[l][1]-k[l-1][1],2)+Math.pow(k[l][0]-k[l-1][0],2))}var f=b.ownerDocument.documentElement.createSVGPoint(),z=s.targetElement.transform;w=(w/r)*q;f.x=k[v][0]+(k[v+1][0]-k[v][0])*(g-w)/q;f.y=k[v][1]+(k[v+1][1]-k[v][1])*(g-w)/q;z.animVal.getItem(z.animVal.numberOfItems-1).setTranslate(f.x,f.y);var e=z.baseVal;z.baseVal=z.animVal;s.targetElement._cacheMatrix=void 0;var u=s.ownerDocument.createEvent("MutationEvents");u.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);s.targetElement.dispatchEvent(u);z.baseVal=e;u=e=z=w=f=l=void 0}}};c=d=tpn=tgsd=void 0},false);this.addEventListener("endEvent",function(e){var c=e.target,f=c.targetElement.transform,g=c.getAttributeNS(null,"fill"),h=c._valueList,d;if(!g||(g==="remove")){var b=c.ownerDocument._domnodeEvent();c.targetElement.dispatchEvent(b);c._frame&&c._frame()}else{f.animVal.getItem(f.animVal.numberOfItems-1).setTranslate(h[h.length-1][0],h[h.length-1][1]);d=f.baseVal;f.baseVal=f.animVal;var b=c.ownerDocument._domnodeEvent();c.targetElement.dispatchEvent(b);f.baseVal=d}delete c._frame;e=b=f=g=c=h=d=void 0},false);this.addEventListener("repeatEvent",function(c){var b=c.target},false)}SVGAnimateMotionElement.prototype=Object._create(SVGAnimationElement);function SVGMPathElement(){SVGElement.apply(this);SVGURIReference.apply(this)}SVGMPathElement.prototype=Object._create(SVGElement);function SVGAnimateColorElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._valueList=[];this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===3){return}var b=c.target;b.addEventListener("DOMNodeInsertedIntoDocument",function(p){var k=p.target,l=k.getAttributeNS(null,"attributeName"),q=k.targetElement,g=k.ownerDocument.defaultView.getComputedStyle(q,""),j,d;if(!k._values[0]){k._values[0]=g.getPropertyValue(l)}for(var h=0,f=k._values,e=f.length;h<e;++h){var o=new SVGColor();if(k._values[h]==="currentColor"){o.setRGBColor(g.getPropertyValue("color")||"black")}else{if(k._values[h]==="inherit"){j=g.getPropertyCSSValue(l);d=j.cssValueType;j.cssValueType=0;o=g.getPropertyCSSValue(l);j.cssValueType=d}else{o.setRGBColor(k._values[h])}}k._valueList[k._valueList.length]=o;o=void 0}k=q=g=j=d=l=void 0},false)},false);this.addEventListener("beginEvent",function(c){var b=c.target,e=b.getAttributeNS(null,"attributeName"),f=b.ownerDocument.getOverrideStyle(b.targetElement,""),d=b.ownerDocument.defaultView.getComputedStyle(b.targetElement,"");b._frame=function(){var B=b;var w=B._isRepeat?B.getSimpleDuration():B._activeDur,l=B._valueList.length-1,k=B.getCurrentTime(),C,z,j;B._activeDur||(w=0);w*=0.8;if((l!==-1)&&(w!==0)&&(k<=w)){C=Math.floor((k*l)/w);if(C===l){C-=1}}else{return}if(b._keyTimes){z=(b._keyTimes[C+1]-b._keyTimes[C])*w;j=b._keyTimes[C]}else{z=w/l;j=C/l}var o=B._valueList[C].rgbColor,s=B._valueList[C+1].rgbColor,q=(k-j*w)/z,t=1,v=o.red.getFloatValue(t),i=o.green.getFloatValue(t),p=o.blue.getFloatValue(t),h=v+(s.red.getFloatValue(t)-v)*q,u=i+(s.green.getFloatValue(t)-i)*q,A=p+(s.blue.getFloatValue(t)-p)*q;f.setProperty(e,"rgb("+Math.ceil(h)+","+Math.ceil(u)+","+Math.ceil(A)+")",null);B=w=l=k=o=s=v=i=p=t=h=u=A=C=void 0};b._frame()},false);this.addEventListener("endEvent",function(d){var c=d.target,e=c.getAttributeNS(null,"fill");if(!e||(e==="remove")){var b=c.ownerDocument._domnodeEvent();c.targetElement.dispatchEvent(b);c._frame&&c._frame()}delete c._frame;d=b=c=e=void 0},false);this.addEventListener("repeatEvent",function(c){var b=c.target},false)}SVGAnimateColorElement.prototype=Object._create(SVGAnimationElement);function SVGAnimateTransformElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this.addEventListener("beginEvent",function(c){var b=c.target,d=b.targetElement.transform;d.animVal=new SVGTransformList();if(d.baseVal.numberOfItems!==0){d.animVal.initialize(d.baseVal.createSVGTransformFromMatrix(d.baseVal.getItem(0).matrix))}d.animVal.appendItem(b.ownerDocument.documentElement.createSVGTransform())},false);this.addEventListener("endEvent",function(d){var c=d.target,e=c.getAttributeNS(null,"fill");if(!e||(e==="remove")){var b=c.ownerDocument._domnodeEvent();c.targetElement.dispatchEvent(b);c._frame&&c._frame()}delete c._frame;d=b=c=e=void 0},false);this.addEventListener("repeatEvent",function(c){var b=c.target},false)}SVGAnimateTransformElement.prototype=Object._create(SVGAnimationElement);function SVGFontElement(){SVGElement.apply(this);this._isExternal=0;this.addEventListener("DOMNodeInserted",function(c){var b=c.target;if(c.eventPhase===3){return}b.addEventListener("DOMNodeInsertedIntoDocument",function(e){var d=e.target,f="http://www.w3.org/2000/svg",h=d.getElementsByTagNameNS(f,"font-face").item(0);var g=function(t){var q=t.target;var o=h.getAttributeNS(null,"font-family");var r=d.ownerDocument.getElementsByTagNameNS(f,"text");for(var p=0,s=d,k=r.length;p<k;++p){var l=r[p],j=s.ownerDocument.defaultView.getComputedStyle(l,"");if(j.getPropertyValue("font-family",null).indexOf(o)>-1){NAIBU._noie_createFont(l,s,true)}}t=d=q=curt=textElments=f=s=void 0};if(!h.__isLinked||d._isExternal){d.ownerDocument.documentElement._svgload_limited=0;d.ownerDocument.documentElement.addEventListener("SVGLoad",g,false)}},false)},false)}SVGFontElement.prototype=Object._create(SVGElement);function SVGGlyphElement(){SVGElement.apply(this)}SVGGlyphElement.prototype=Object._create(SVGElement);function SVGMissingGlyphElement(){SVGElement.apply(this)}SVGMissingGlyphElement.prototype=Object._create(SVGElement);function SVGHKernElement(){SVGElement.apply(this)}SVGHKernElement.prototype=Object._create(SVGElement);function SVGVKernElement(){SVGElement.apply(this)}SVGVKernElement.prototype=Object._create(SVGElement);function SVGFontFaceElement(){SVGElement.apply(this);this._isLinked=0;this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===3){if(b.target.localName==="font-face-uri"){b.currentTarget._isLinked=1}return}},false)}SVGFontFaceElement.prototype=Object._create(SVGElement);function SVGFontFaceSrcElement(){SVGElement.apply(this)}SVGFontFaceSrcElement.prototype=Object._create(SVGElement);function SVGFontFaceUriElement(){SVGElement.apply(this);this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===3){return}b.target.ownerDocument.documentElement._svgload_limited--;b.target.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed")},false);this.addEventListener("S_Load",function(c){var b=c.target,d=b.parentNode.parentNode.parentNode;if(d.localName==="defs"){d=b.parentNode.parentNode}b._instance._isExternal=1;d.parentNode.appendChild(b._instance);c=b=d=void 0},false);SVGURIReference.apply(this)}SVGFontFaceUriElement.prototype=Object._create(SVGElement);function SVGFontFaceFormatElement(){SVGElement.apply(this)}SVGFontFaceFormatElement.prototype=Object._create(SVGElement);function SVGFontFaceNameElement(){SVGElement.apply(this)}SVGFontFaceNameElement.prototype=Object._create(SVGElement);function SVGDefinitionSrcElement(){SVGElement.apply(this)}SVGDefinitionSrcElement.prototype=Object._create(SVGElement);function SVGForeignObjectElement(c){this._tar=c.createElement("v:group");SVGElement.apply(this);var b=SVGAnimatedLength;this.x=new b();this.y=new b();this.width=new b();this.height=new b();b=void 0;this.addEventListener("DOMNodeInserted",function(e){var d=e.target;if(e.eventPhase===3){return}d._inserted__(d);d.addEventListener("DOMNodeInsertedIntoDocument",SVGImageElement.prototype._imageo,false);e=d=void 0},false);this.addEventListener("DOMNodeInsertedIntoDocument",function(q){if(q.eventPhase===1){var o=q.target;if((o.nodeType===1)&&!o._tar&&o.namespaceURI==="http://www.w3.org/1999/xhtml"){if("html|body|head".indexOf(o.localName)>-1){o._tar=c.createElement("div");o._tar.appendChild(c.createElement("v:shape"))}else{o._tar=c.createElement(o.localName);if(o.localName==="div"){o._tar.appendChild(c.createElement("v:shape"))}}}else{if((o.nodeType===3)&&!o._tar){o._tar=c.createTextNode(o.data)}}var f=o.nextSibling,e=o._tar,p=o.parentNode._tar,k=null;if(e&&p){if(!f){p.appendChild(e)}else{while(f){if(f._tar&&f._tar.parentNode){k=f._tar;break}f=f.nextSibling}k&&(p=k.parentNode);p.insertBefore(e,k)}}f=e=p=k=void 0;var j=o.attributes;if(o._tar){for(var h=0;h<j.length;++h){o._tar.setAttribute(j[h].localName,j[h].nodeValue)}}var d=true;if(o._tar.lastChild){if(o._tar.lastChild.nodeName!=="rect"){d=false}}else{d=false}if(!d){var l=c.createElement("v:rect"),g=l.style;g.width=g.height="1px";g.left=g.top="0px";l.stroked=l.filled="false";o._tar.appendChild(l)}o=j=void 0}},true)}SVGForeignObjectElement.prototype=Object._create(SVGElement);DOMImplementation["http://www.w3.org/2000/svg"]={Document:SVGDocument,svg:SVGSVGElement,g:SVGGElement,path:NAIBU.SVGPathElement,title:SVGTitleElement,desc:SVGDescElement,defs:SVGDefsElement,linearGradient:SVGLinearGradientElement,radialGradient:SVGRadialGradientElement,stop:SVGStopElement,rect:SVGRectElement,circle:SVGCircleElement,ellipse:SVGEllipseElement,polyline:SVGPolylineElement,polygon:SVGPolygonElement,text:SVGTextElement,tspan:SVGTSpanElement,image:SVGImageElement,line:SVGLineElement,a:SVGAElement,animateColor:SVGAnimateColorElement,animate:SVGAnimateElement,animateMotion:SVGAnimateMotionElement,animateTransform:SVGAnimateTransformElement,clipPath:SVGClipPathElement,colorProfile:SVGColorProfileElement,cursor:SVGCursorElement,definitionSrc:SVGDefinitionSrcElement,feBlend:SVGFEBlendElement,feGaussianBlur:SVGFEGaussianBlurElement,filter:SVGFilterElement,font:SVGFontElement,"font-face":SVGFontFaceElement,"font-face-format":SVGFontFaceFormatElement,"font-face-name":SVGFontFaceNameElement,"font-face-src":SVGFontFaceSrcElement,"font-face-uri":SVGFontFaceUriElement,foreignObject:SVGForeignObjectElement,glyph:SVGGlyphElement,hkern:SVGHKernElement,marker:SVGMarkerElement,mask:SVGMaskElement,missingGlyph:SVGMissingGlyphElement,mpath:SVGMPathElement,script:SVGScriptElement,set:SVGSetElement,style:SVGStyleElement,"switch":SVGSwitchElement,symbol:SVGSymbolElement,textPath:SVGTextPathElement,tref:SVGTRefElement,use:SVGUseElement,view:SVGViewElement,vkern:SVGVKernElement,pattern:SVGPatternElement};NAIBU._fontSearchURI=function(b){var g=b.target.ownerDocument;var c=g.getElementsByTagNameNS("http://www.w3.org/2000/svg","font-face-uri");for(var e=0;e<c.length;++e){var h=c[e].getAttributeNS("http://www.w3.org/1999/xlink","href"),f=h.split(":")[1],d=NAIBU.xmlhttp;d.open("GET",h.replace(/#.+$/,""),true);d.setRequestHeader("X-Requested-With","XMLHttpRequest");d.onreadystatechange=function(){if((d.readyState===4)&&(d.status===200)){var i=(new DOMParser()).parseFromString(d.responseText,"text/xml");NAIBU._font({document:i,docu:g,id:f});d=g=i=void 0}};d.send(null)}};NAIBU._font=function(h){var l=h.document,f="http://www.w3.org/2000/svg";var e=l.getElementsByTagNameNS(f,"font").item(0);var g=e.getElementsByTagNameNS(f,"font-face").item(0).getAttributeNS(null,"font-family");if(g&&(e.getAttributeNS(null,"id")===h.id)){var k=h.docu.getElementsByTagNameNS(f,"text");for(var j=0,d=k.length;j<d;++j){var c=k[j],b=h.docu.defaultView.getComputedStyle(c,"");if(b.getPropertyValue("font-family",null).indexOf(g)>-1){NAIBU._noie_createFont(c,e,false)}}}l=h=void 0};NAIBU._noie_createFont=function(b,N,k){var G=b.ownerDocument.defaultView.getComputedStyle(b,""),O="http://www.w3.org/2000/svg",H=b.getAttributeNS(null,"writing-mode")||b.parentNode.getAttributeNS(null,"writing-mode"),o=H?"vert-adv-y":"horiz-adv-x",v=b.firstChild,P,h=N.getElementsByTagNameNS(O,"glyph"),L=parseFloat(N.getElementsByTagNameNS(O,"font-face").item(0).getAttributeNS(null,"units-per-em")||1000),F=parseFloat((N.getAttributeNS(null,o)||L)),e=parseFloat(b.getAttributeNS(null,"x")||0),d=parseFloat(b.getAttributeNS(null,"y")||0),p=parseFloat(G.getPropertyValue("font-size")),z=p/L,g=false,f=["fill","fill-opacity","stroke","stroke-width","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-dasharray","stroke-opacity","opacity","cursor"];if(h.length>60){return}if(/a/[-1]==="a"){g=true}else{if(k||H){g=true}}if(g){while(v){if(!h){break}P=v.data;if(P!==void 0){var R=[],D=[];for(var J=0,A=h.length;J<A;++J){var t=h[J],r=t.getAttributeNS(null,"unicode")||"なし";var s=t.getAttributeNS(null,"orientation"),M=true,l=true;if(s){if(s==="h"){M=false}}else{l=false}if((H&&M)||!(H||M)||!l){var w=P.indexOf(r);while(w>-1){R[w]=parseFloat(t.getAttributeNS(null,o)||F);D[w]=t.getAttributeNS(null,"d");w=P.indexOf(r,w+1)}}}for(var J=0,K=0;J<P.length;++J){if(R[J]!==void 0){var E=b.ownerDocument.createElementNS(O,"path");var u=b.ownerDocument.documentElement.createSVGMatrix();u.a=z;u.d=-z;for(var I=0;I<f.length;++I){var Q=f[I],c=b.getAttributeNS(null,Q)||G.getPropertyValue(Q);if(Q==="stroke-width"){c=G.getPropertyCSSValue(Q).getFloatValue(1)/z;c+=""}if(c){E.setAttributeNS(null,Q,c)}}if(H){var B=d+K*z,C=e;if("、。".indexOf(P.charAt(J))>-1){var q=p/Math.SQRT2;C+=q;B-=q;q=void 0}u.e=C;u.f=B}else{u.e=e+K*z;u.f=d}E.setAttributeNS(null,"transform","matrix("+u.a+","+u.b+","+u.c+","+u.d+","+u.e+","+u.f+")");E.setAttributeNS(null,"d",D[J]);b.parentNode.insertBefore(E,b);K+=R[J];u=void 0}}K=R=D=void 0}else{if("tspan|a".indexOf(v.localName)>-1){NAIBU._noie_createFont(v,N,k)}}v=v.nextSibling}if(k){var G=b.ownerDocument.getOverrideStyle(b,null);G.setProperty("visibility","hidden");G=void 0}else{b.setAttributeNS(null,"opacity","0")}}P=H=o=L=F=e=d=p=G=O=v=void 0};(function(){var e=new CSSStyleDeclaration(),j=e._list,h=0,f=/([A-Z])/,g=/\-/,b,d;for(var c in CSS2Properties){if(CSS2Properties.hasOwnProperty(c)){d=c.replace(f,"-");if(!!RegExp.$1){b="-"+RegExp.$1.toLowerCase()}else{b="-"}d=d.replace(g,b);e.setProperty(d,CSS2Properties[c]);j[d]=j[h];j[h]._isDefault=1;++h;c=d=b=void 0}}j._opacity=1;j._fontSize=12;CSS2Properties._list=j;Document.prototype.defaultView._defaultCSS=j;e=h=f=g=j=null})();NAIBU.addEvent=function(b,c){if(window.addEventListener){window.addEventListener(b,c,false)}else{if(window.attachEvent){window.attachEvent("on"+b,c)}else{window["on"+b]=c}}if(sieb_s){c()}};function unsvgtovml(){try{if("stop" in NAIBU){clearInterval(NAIBU.stop)}window.onscroll=NAIBU.emptyFunction;window.detachEvent("onload",NAIBU._main);NAIBU.freeArg();delete Object._create;Document._destroy();Element=SVGElement=Attr=NamedNodeMap=CSS2Properties=CSSValue=CSSPrimitiveValue=NAIBU.xmlhttp=Node=Event=NAIBU=STLog=SVGColor=SVGPaint=void 0;Array=ActiveXObject=void 0}catch(b){}}NAIBU._main=function(){var F,c=document;try{if(XMLHttpRequest){F=false}else{F=new ActiveXObject("Msxml2.XMLHTTP")}}catch(A){try{F=new ActiveXObject("Microsoft.XMLHTTP")}catch(k){F=false}}if(!F){try{F=new XMLHttpRequest()}catch(A){F=false}}NAIBU.xmlhttp=F;var f,o=c.namespaces;if(o&&!o.v){try{NAIBU.doc=new ActiveXObject("MSXML2.DomDocument")}catch(A){}f=NAIBU.doc;o.add("v","urn:schemas-microsoft-com:vml");o.add("o","urn:schemas-microsoft-com:office:office");var p=c.createStyleSheet(),g="behavior: url(#default#VML);display: inline-block;} ";p.cssText="v\\:rect{"+g+"v\\:image{"+g+"v\\:fill{"+g+"v\\:stroke{"+g+"o\\:opacity2{"+g+"dn\\:defs{display:none}v\\:group{text-indent:0px;position:relative;width:100%;height:100%;"+g+"v\\:shape{width:100%;height:100%;"+g}var B=c.getElementsByTagName("script");for(var u=0;B[u];++u){var v=B[u],w=v.type;if(v.type==="image/svg+xml"){var C=v.text;if(sieb_s&&C.match(/&lt;svg/)){C=C.replace(/<.+?>/g,"");C=C.replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&quot;/g,'"').replace(/&amp;/g,"&")}if(NAIBU.isMSIE){var G=new GetSVGDocument(v);G.xmlhttp={readyState:4,status:200,responseText:C.replace(/\shref=/g," target='_top' xlink:href=")};G._ca()}else{var d=location.href.replace(/\/[^\/]+?$/,"/");C=C.replace(/\shref=(['"a-z]+?):\/\//g," target='_top' xlink:href=$1://").replace(/\shref=(.)/g," target='_top' xlink:href=$1"+d);var l=NAIBU.textToSVG(C,v.getAttribute("width"),v.getAttribute("height"));v.parentNode.insertBefore(l,v)}v=C=void 0}w=void 0}NAIBU.doc=f;f=o=B=void 0;if(F&&NAIBU.isMSIE){if(!!c.createElementNS&&!!c.createElementNS("http://www.w3.org/2000/svg","svg").createSVGRect){}else{var q=c.getElementsByTagName("object"),l=[],h=[],z=function(t){var I,E,H,e="width",s="height";l||(l=[]);c||(c=document);for(var j=0;t[j];++j){E=t[j];l[l.length]=new GetSVGDocument(E);I=c.createElement("iframe");I.style.cssText=E.style.cssText;I.style.background="black";H=E.getAttribute(e);H&&I.setAttribute(e,H);H=E.getAttribute(s);H&&I.setAttribute(s,H);I.marginWidth=I.marginHeight="0px";I.scrolling="no";I.frameBorder="0";E.parentNode.insertBefore(I,E)}j=E=I=t=e=s=void 0;return l[l.length-1]};z(q);var D=c.getElementsByTagName("img"),b=c.getElementsByTagName("embed");for(var u=0,r=0;D[u];++u){if(D[u].getAttribute("src").indexOf(".svg")>-1){h[r]=D[u];++r}}z(h);z(b);NAIBU._search=z;q=b=h=D=z=void 0;for(var u=0;u<l.length;++u){if(u<l.length-1){l[u]._next=l[u+1]}}if(u>0){l[0]._init()}l=void 0}}else{var q=c.getElementsByTagName("object");for(var u=0;u<q.length;++u){if(q[u].contentDocument){NAIBU._fontSearchURI({target:{ownerDocument:q[u].contentDocument}})}else{if(q[u].getSVGDocument){q[u].getSVGDocument()._docElement.addEventListener("SVGLoad",NAIBU._fontSearchURI,false)}else{}}}}F=c=void 0};NAIBU.addEvent("load",NAIBU._main);NAIBU.utf16=function(b){return unescape(b)};NAIBU.unescapeUTF16=function(b){return b.replace(/%u\w\w\w\w/g,NAIBU.utf16)};NAIBU.textToSVG=function(f,b,d){if(navigator.userAgent.indexOf("WebKit")>-1||navigator.userAgent.indexOf("Safari")>-1){var e="data:image/svg+xml;charset=utf-8,"+NAIBU.unescapeUTF16(escape(f));var c=document.createElement("object");c.setAttribute("data",e);c.setAttribute("width",b);c.setAttribute("height",d);c.setAttribute("type","image/svg+xml");return c}else{var g=(new DOMParser()).parseFromString(f,"text/xml");return(document.importNode(g.documentElement,true))}};NAIBU.addEvent("unload",unsvgtovml);
NAIBU.isMSIE=/*@cc_on!@*/false;