/*SIE-SVG without Plugin under LGPL2.1 & GPL2.0 & Mozilla Public Lisence
 *公式ページは http://sie.sourceforge.jp/
 *利用方法は <script defer="defer" type="text/javascript" src="sie-mini.js"></script>
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla SVG Cairo Renderer project.
 *
 * The Initial Developer of the Original Code is IBM Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Parts of this file contain code derived from the following files(s)
 * of the Mozilla SVG project (these parts are Copyright (C) by their
 * respective copyright-holders):
 *    layout/svg/renderer/src/libart/nsSVGLibartBPathBuilder.cpp
 *
 * Contributor(s):DHRNAME revulo bellbind
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
function DOMException(b){Error.apply(this,arguments);this.code=b;var a=["","Index Size Error","DOMString Size Error","Hierarchy Request Error","Wrong　Document　Error","Invalid　Character　Error","No Data Allowed　Error","No Modification Allowed Error","Not Found Error","Not Supported　Error","Inuse　Attribute　Error","Invalid State　Error","Syntax Error","Invalid Modification　Error","Namespace Error","Invalid Access Error"];this.message=a[b];return this}DOMException.INDEX_SIZE_ERR=1;DOMException.DOMSTRING_SIZE_ERR=2;DOMException.HIERARCHY_REQUEST_ERR=3;DOMException.WRONG_DOCUMENT_ERR=4;DOMException.INVALID_CHARACTER_ERR=5;DOMException.NO_DATA_ALLOWED_ERR=6;DOMException.NO_MODIFICATION_ALLOWED_ERR=7;DOMException.NOT_FOUND_ERR=8;DOMException.NOT_SUPPORTED_ERR=9;DOMException.INUSE_ATTRIBUTE_ERR=10;DOMException.INVALID_STATE_ERR=11;DOMException.SYNTAX_ERR=12;DOMException.INVALID_MODIFICATION_ERR=13;DOMException.NAMESPACE_ERR=14;DOMException.INVALID_ACCESS_ERR=15;DOMException.prototype=new Error();DOMImplementation={hasFeature:function(b,a){switch(b){case"CORE":case"XML":case"Events":case"StyleSheets":case"org.w3c.svg.static":case"org.w3c.dom.svg.static":return true;default:if(a==="2.0"){return true}else{return false}}},createDocumentType:function(c,d,a){var b=new Node();b.publicId=d;b.systemId=a;return b},createDocument:function(c,f,a){try{var b;if(c){b=new (DOMImplementation[c].Document)}else{b=new Document()}b.implementation=this;b.doctype=a;b.documentElement=b.createElementNS(c,f);return b}catch(d){alert(d.message)}},"http://www.w3.org/2000/xmlns":{}};function Node(){this.childNodes=[];this._capter=[];return this}Node.ELEMENT_NODE=1;Node.ATTRIBUTE_NODE=2;Node.TEXT_NODE=3;Node.CDATA_SECTION_NODE=4;Node.ENTITY_REFERENCE_NODE=5;Node.ENTITY_NODE=6;Node.PROCESSING_INSTRUCTION_NODE=7;Node.COMMENT_NODE=8;Node.DOCUMENT_NODE=9;Node.DOCUMENT_TYPE_NODE=10;Node.DOCUMENT_FRAGMENT_NODE=11;Node.NOTATION_NODE=12;Node.prototype={tar:null,firstChild:null,previousSibling:null,nextSibling:null,attributes:null,namespaceURI:null,localName:null,lastChild:null,prefix:null,ownerDocument:null,parentNode:null,replaceChild:function(a,c){this.insertBefore(a,c);var b=this.removeChild(c);return b},appendChild:function(a){this.insertBefore(a,null);return a},hasChildNodes:function(){if(this.childNodes.length>0){return true}else{return false}},cloneNode:function(a){if("ownerDocument" in this){var b=this.ownerDocument.importNode(this,a)}else{b=new Node()}return b},normalize:function(){var f=this.childNodes;try{for(var b=f.length-1;b<0;--b){var d=f[b],a=d.nextSibling;if(a){if(d.nodeType===Node.TEXT_NODE&&a.nodeType===Node.TEXT_NODE){d.appendData(a.data);d.legnth=d.data.length;this.removeChild(a)}else{d.normalize()}}else{d.normalize()}}}catch(c){}},isSupported:function(b,a){return(this.ownerDocument.implementation.hasFeature(b+"",a+""))},hasAttributes:function(){if(this.attributes.length>0){return true}else{return false}}};Array.prototype.item=function(a){return(this[a])};function NamedNodeMap(){return this}Array.prototype._copyNode=function __nnmp_c(d,b){for(var c=0,a=d.length;c<a;c++){this[c]=d[c].cloneNode(b)}};NamedNodeMap.prototype={length:0,getNamedItem:function(a){},setNamedItem:function(a){},removeNamedItem:function(a){},item:function(a){return this[a]},getNamedItemNS:function(d,c){var b;for(var e=0,a=this.length;e<a;e++){b=this[e];if(b.namespaceURI===d&&b.localName===c){this._num=e;return b}}e=b=null;return null},setNamedItemNS:function(a){var b=this.getNamedItemNS(a.namespaceURI,a.localName),c;if(b){c=this[this._num];this[this._num]=a;a=b=null;return c}else{if(a.ownerElement!==void 0){throw (new DOMException(DOMException.INUSE_ATTRIBUTE_ERR))}this[this.length]=a;this.length+=1;a=null;return null}},removeNamedItemNS:function(b,a){var c=this.getNamedItemNS(b,a);if(!c){throw (new DOMException(DOMException.NOT_FOUND_ERR))}else{var d=this[this._num];delete (this[this._num]);this.length-=1;tgas=null;return d}},_copyNode:Array.prototype._copyNode};function CharacterData(){Node.apply(this);return this}CharacterData.prototype=new Node();CharacterData.constructor=Node;CharacterData.prototype.length=0;CharacterData.prototype.substringData=function(c,b){if(c<0||b<0||c>this.length){throw (new DOMException(INDEX_SIZE_ERR))}if(c+b>this.length){b=this.length-c}var a=this.data.substr(c,b);return a};CharacterData.prototype.replaceData=function(c,b,a){if(c<0||b<0||c>this.length){throw (new DOMException(INDEX_SIZE_ERR))}this.deleteData(c,b);this.insertData(c,a)};function Attr(){Node.apply(this);delete this._capter;return this}Attr.prototype=new Node();Attr.constructor=Node;Attr.prototype.nodeType=Node.ATTRIBUTE_NODE;Attr.prototype.nodeValue=null;function Element(){Node.apply(this);this.attributes=new NamedNodeMap();return this}Element.prototype=new Node();Element.constructor=Node;Element.prototype.nodeType=Node.ELEMENT_NODE;Element.prototype.nodeValue=null;Element.prototype.getAttribute=function(a){return(this.getAttributeNS("http://www.w3.org/2000/svg",a))};Element.prototype.setAttribute=function(a,b){this.setAttributeNS(null,a,b)};Element.prototype.removeAttribute=function(a){this.removeAttributeNS(null,a)};Element.prototype.getAttributeNode=function(a){};Element.prototype.setAttributeNode=function(a){};Element.prototype.removeAttributeNode=function(a){var b=this.attributes.removeNamedItemNS(a.namespaceURI,a.localName);return b};Element.prototype.getElementsByTagName=function(a){};Element.prototype.getAttributeNS=function(b,a){var c=this.getAttributeNodeNS(b,a);if(!c){return null}else{return(c.nodeValue)}};Element.prototype.setAttributeNS=function(a,d,b){var c=this.ownerDocument.createAttributeNS(a,d);c.nodeValue=b+"";c.value=b+"";this.setAttributeNodeNS(c)};Element.prototype.removeAttributeNS=function(b,a){};Element.prototype.getAttributeNodeNS=function(b,a){var c=this.attributes.getNamedItemNS(b,a);return c};Element.prototype.getElementsByTagNameNS=function(c,f){var t=[],e=0;var a=this.childNodes;for(var h=0,b=a.length;h<b;h++){var k=a[h];if(k.nodeType===Node.ELEMENT_NODE){var r=(c==="*")?k.namespaceURI:c;var q=(f==="*")?k.localName:f;if((k.namespaceURI===r)&&(k.localName===q)){t[e]=k;e++}var o=k.getElementsByTagNameNS(c,f);if(o){for(var g=0,l=o.length;g<l;++g){t[t.length]=o[g]}e+=o.length}r=q=o=null}}a=h=g=b=l=null;if(e===0){return null}return t};Element.prototype.hasAttribute=function(a){return(this.hasAttributeNS("http://www.w3.org/2000/svg",a))};Element.prototype.hasAttributeNS=function(b,a){if(this.getAttributeNodeNS(b,a)){return true}else{return false}};function Text(){return this}Text.prototype=new CharacterData();Text.constructor=CharacterData;Text.prototype.nodeType=Node.TEXT_NODE;Text.prototype.nodeName="#text";Text.prototype.splitText=function(d){var c=this.substringData(0,d-1);this.replaceData(0,this.length-1,c);var a="";if(this.length!==d){a=this.substringData(d,this.length-1)}var b=this.ownerDocument.createTextNode(a);if(this.parentNode){this.parentNode.insertBefore(b,this.nextSibling)}return b};function Comment(){return this}Comment.prototype=new CharacterData();Comment.constructor=CharacterData;Comment.prototype.nodeType=Node.COMMENT_NODE;Comment.prototype.nodeName="#comment";function CDATASection(){this.nodeType=Node.CDATA_SECTION_NODE;this.nodeName="#cdata-section";return this}CDATASection.prototype=new Text();CDATASection.constructor=Text;function DocumentType(){this.name="";this.entities=new NamedNodeMap();this.notations=new NamedNodeMap();this.publicId="";this.systemId="";this.internalSubset="";this.nodeValue=null;this.nodeType=Node.DOCUMENT_TYPE_NODE;return this}DocumentType.prototype=new Node();DocumentType.constructor=Node;function Notation(){this.publicId=null;this.systemId=null;this.nodeValue=null;this.nodeType=Node.NOTATION_NODE;return this}Notation.prototype=new Node();Notation.constructor=Node;function Entity(){this.publicId=null;this.systemId=null;this.notationName=null;this.nodeValue=null;this.nodeType=Node.ENTITY_NODE;return this}Entity.prototype=new Node();Entity.constructor=Node;function EntityReference(){this.nodeValue=null;this.nodeType=Node.ENTITY_REFERENCE_NODE;return this}EntityReference.prototype=new Node();EntityReference.constructor=Node;function ProcessingInstruction(){this.nodeType=Node.PROCESSING_INSTRUCTION_NODE;return this}ProcessingInstruction.prototype=new Node();ProcessingInstruction.constructor=Node;function DocumentFragment(){this.nodeName="#document-fragment";this.nodeValue=null;this.nodeType=Node.DOCUMENT_FRAGMENT_NODE;return this}DocumentFragment.prototype=new Node();DocumentFragment.constructor=Node;function Document(){this.nodeName="#document";this.nodeValue=null;this.nodeType=Node.DOCUMENT_NODE;this._id={};return this}Document.prototype=new Node();Document.constructor=Node;Document.prototype.createElement=function(a){};Document.prototype.createDocumentFragment=function(){var a=new DocumentFragment();a.ownerDocument=this;return a};Document.prototype.createTextNode=function(b){var a=new Text();a.data=a.nodeValue=b+"";a.length=a.data.length;a.ownerDocument=this;return a};Document.prototype.createComment=function(b){var a=new Comment();a.data=a.nodeValue=b;a.length=b.length;a.ownerDocument=this;return a};Document.prototype.createCDATASection=function(b){var a=new CDATASection();a.data=a.nodeValue=b;a.length=b.length;a.ownerDocument=this;return a};Document.prototype.createProcessingInstruction=function(c,b){var a=new ProcessingInstruction();a.target=a.nodeName=c;a.data=a.nodeValue=b;a.ownerDocument=this;return a};Document.prototype.createAttribute=function(a){};Document.prototype.createEntityReference=function(a){var b=new EntityReference();b.nodeName=a;b.ownerDocument=this;return b};Document.prototype.getElementsByTagName=function(a){};Document.prototype.importNode=function(k,l){var q,b=k.nodeType,f,h,o,d,c,a;if(b===1){q=this.createElementNS(k.namespaceURI,k.nodeName);f=k.attributes;for(var e=0,j=f.length;e<j;++e){h=this.importNode(f[e],false);q.setAttributeNodeNS(h)}if(l){o=k.firstChild;while(o){d=this.importNode(o,true);q.appendChild(d);o=o.nextSibling}}e=j=null}else{if(b===2){c=k.namespaceURI;c=(c==="")?null:c;q=this.createAttributeNS(c,k.nodeName);q.nodeValue=k.nodeValue}else{if(b===3){q=this.createTextNode(k.data)}else{if(b===8){q=this.createComment(k.data)}else{if(b===Node.DOCUMENT_FRAGMENT_NODE){q=this.createDocumentFragment();if(l){a=k.childNodes;for(var e=0,g=a.length;e<g;e++){d=this.importNode(a[e],true);q.appendChild(d)}}e=g=null}else{if(b===Node.CDATA_SECTION_NODE){q=this.createCDATASection(k.data)}else{if(b===Node.ENTITY_REFERENCE_NODE){q=this.createEntityReference(k.nodeName);if(l){o=k.firstChild;while(o){d=this.importNode(o,true);q.appendChild(d);o=o.nextSibling}}}else{if(b===Node.ENTITY_NODE){q=new Entity();q.publicId=k.publicId;q.systemId=k.systemId;q.notationName=k.notationName}else{if(b===Node.PROCESSING_INSTRUCTION_NODE){q=this.createProcessingInstruction(k.nodeName,k.nodeValue)}else{if(b===Node.NOTATION_NODE){q=new Notation();q.publicId=k.publicId;q.systemId=k.systemId}else{throw (new DOMException(DOMException.NOT_SUPPORTED_ERR))}}}}}}}}}}k=l=b=f=h=o=d=c=a=null;return q};Document.prototype.createElementNS=function(b,g){var e,d=null,a=null;if(!g){throw (new DOMException(DOMException.INVALID_CHARACTER_ERR))}if(g.indexOf(":")!==-1){var f=g.split(":");d=f[0];a=f[1]}else{a=g}var h=false;if(b){var c=this.implementation;if(!!c[b]){if(!!c[b][a]){h=true}}}if(h){e=new (c[b][a])}else{e=new Element()}e.namespaceURI=b;e.nodeName=e.tagName=g;e.localName=a;e.prefix=d;e.ownerDocument=this;c=b=g=d=a=h=null;return e};Document.prototype.createAttributeNS=function(b,d){var a=new Attr(),c;a.namespaceURI=b;a.nodeName=a.name=d;if(d.indexOf(":")!==-1){c=d.split(":");a.prefix=c[0];a.localName=c[1]}else{a.prefix=null;a.localName=d}a.ownerDocument=this;c=d=null;return a};Document.prototype.getElementsByTagNameNS=function(b,a){var c=this.documentElement.getElementsByTagNameNS(b,a);return c};Document.prototype.getElementById=function(a){var b=!!this._id[a]?this._id[a]:null;return b};function STLog(a){this.jo=a;if(this.jo){this.p=document.createElement("div");this.p.innerHTML="<h1>例外処理のログ</h1>";document.body.insertBefore(this.p,document.body.firstChild)}return this}STLog.prototype.add=function(b,a){if(this.jo){this.p.innerHTML+="<p>"+a+":"+b.message+"</p>"}};function EventException(){DOMException.call(this,arguments);if(this.code===0){this.message="Uuspecified Event Type Error"}return this}EventException.UNSPECIFIED_EVENT_TYPE_ERR=0;EventException.prototype=new DOMException();EventException.constructor=DOMException;Node.prototype.addEventListener=function(d,f,a){this.removeEventListener(d,f,a);var c=new EventListener(a,d,f),b=d.charAt(0),e;this._capter[this._capter.length]=c;if((b!=="D")&&(b!=="S")&&(d!=="beginEvent")&&(d!=="endEvent")&&(d!=="repeatEvent")){e=this;e._tar&&e._tar.attachEvent("on"+d,(function(g){return function(){var h=g.ownerDocument.createEvent("MouseEvents");h.initMouseEvent(d,true,true,g.ownerDocument.defaultView,0);g.dispatchEvent(h);h=null}})(e))}c=b=e=null};Node.prototype.removeEventListener=function(d,f,a){var e=this._capter;for(var c=0,b=e.length;c<b;c++){if(e[c].listener===f){e[c]=null}}c=b=e=null};Node.prototype.dispatchEvent=function(k){if(!k.type||k.type===""){throw new EventException(EventException.UNSPECIFIED_EVENT_TYPE_ERR)}var b=this,c=this.ownerDocument,g=k.timeStamp,l=k.type,o=k.bubbles,d,i=1,f;if(!c._isLoaded){if(k.type==="SVGLoad"){c._isLoaded=1}if(!c._limit_time_){c._limit_time_=g}else{if((g-c._limit_time_)>1000){d=c.implementation._buffer_||[];d[d.length]=this;d[d.length]=k;c.implementation._buffer_=d;return true}}}k.target=this;k.eventPhase=1;c["3"]=null;while(b.parentNode){b.parentNode["1"]=b;b["3"]=b.parentNode;b=b.parentNode}c["1"]=b;b["3"]=c;while(c){k.currentTarget=c;if(c===this){i=2}k.eventPhase=i;f=c._capter;for(var e=0,a=f.length;e<a;++e){if(f[e]&&(l===f[e]._type)){f[e].handleEvent(k)}}if(k._stop){break}if(c===this){if(!o){break}i=3}c=c[i]}var h=k._default;k=b=f=n=c=i=d=e=a=l=g=o=null;return h};function EventListener(a,b,c){this._cap=a;this._type=b;this._listener=c;return this}EventListener.prototype={handleEvent:function(a){try{var d=a.eventPhase,b=this._cap;if(d===1){b=b?false:true}if(!b&&(a.type===this._type)){this._listener(a)}a=d=b=null}catch(c){}}};function Event(){return this}Event.CAPTURING_PHASE=1;Event.AT_TARGET=2;Event.BUBBLING_PHASE=3;Event.prototype={timeStamp:0,type:null,target:null,currentTarget:null,eventPhase:Event.CAPTURING_PHASE,bubbles:false,cancelable:false,_stop:false,_default:true,stopPropagation:function(){this._stop=true},preventDefault:function(){this._default=false;window.event.returnValue=false},initEvent:function(a,c,b){this.type=a;this.bubbles=c;this.cancelable=b}};Document.prototype.createEvent=function(b){var a;if(b==="MutationEvents"){a=new MutationEvent()}else{if(b==="MouseEvents"){a=new MouseEvent()}else{if(b==="UIEvents"){a=new UIEvent()}else{if(b==="SVGEvents"){a=new SVGEvent()}else{if(b==="TimeEvents"){a=new TimeEvent()}else{a=new Event()}}}}}a.type=b;a.timeStamp=+(new Date());return a};function UIEvent(){Event.call(this,arguments);this.view;this.detail=0;return this}UIEvent.prototype=new Event();UIEvent.constructor=Event;UIEvent.prototype.initUIEvent=function(b,e,d,c,a){this.initEvent(b,e,d);this.detail=a;this.view=c};function MouseEvent(a){UIEvent.call(this,arguments);this.screenX;this.screenY;this.clientX=0;this.clientY=0;this.ctrlKey=false;this.shiftKey=false;this.altKey=false;this.metaKey=false;this.button;this.relatedTarget;return this}MouseEvent.prototype=new UIEvent();MouseEvent.constructor=UIEvent;MouseEvent.prototype.initMouseEvent=function(q,d,l,e,h,k,f,a,j,g,r,c,o,i,b){this.initUIEvent(q,d,l,e,h);this.screenX=k;this.screenY=f;this.clientX=a;this.clientY=j;this.ctrlKey=g;this.shiftKey=c;this.altKey=r;this.metaKey=o;this.button=i;this.relatedTarget=b};function MutationEvent(){Event.call(this);return this}MutationEvent.prototype=new Event();MutationEvent.constructor=Event;(function(){this.initMutationEvent=function(a,f,e,b,h,c,d,g){this.initEvent(a,f,e);this.relatedNode=b;this.prevValue=h;this.newValue=c;this.attrName=d;this.attrChange=g;a=f=e=b=h=c=d=g=null};this.relatedNode=null;this.prevValue=null;this.newValue=null;this.attrName=null;this.attrChange=2}).apply(MutationEvent.prototype);MutationEvent.MODIFICATION=1;MutationEvent.ADDITION=2;MutationEvent.REMOVAL=3;Element.prototype.setAttributeNodeNS=function(c){if(c.ownerDocument!==this.ownerDocument){throw (new DOMException(DOMException.WRONG_DOCUMENT_ERR))}var b=this.attributes.setNamedItemNS(c);c.ownerElement=this;if(c.localName==="id"){this.ownerDocument._id[c.nodeValue]=this}var a=this.ownerDocument.createEvent("MutationEvents");if(!b){a.initEvent("DOMAttrModified",true,false);a.relatedNode=c;a.newValue=c.nodeValue;a.attrName=c.nodeName}else{a.initMutationEvent("DOMAttrModified",true,false,c,b.nodeValue,c.nodeValue,c.nodeName,MutationEvent.MODIFICATION)}this.dispatchEvent(a);a=null;return b};Node.prototype.insertBefore=function(b,c){var l=this.parentNode,f,o,d=this,q,k,j;if(l){while(!l){if(l===b){throw (new DOMException(DOMException.HIERARCHY_REQUEST_ERR))}l=l.parentNode}}if(this.ownerDocument!==b.ownerDocument){throw (new DOMException(DOMException.WRONG_DOCUMENT_ERR))}if(b.parentNode===this){this.removeChild(b)}if(!c){this.childNodes[this.childNodes.length]=b;if(this.lastChild){b.previousSibling=this.lastChild;this.lastChild.nextSibling=b}}else{if(c.parentNode!==this){throw (new DOMException(DOMException.NOT_FOUND_ERR))}this.childNodes.splice(c._num,1,b,c);f=c.previousSibling;if(f){f.nextSibling=b}c.previousSibling=b}b.nextSibling=c;this.firstChild=this.childNodes[0];this.lastChild=this.childNodes[this.childNodes.length-1];b.parentNode=this;if((b.nodeType===5)||(b.nodeType===11)){var a=b.childNodes.concat([]);for(var e=0,h=a.length;e<h;e++){this.insertBefore(a[e],b)}a=null}o=this.ownerDocument.createEvent("MutationEvents");o.initMutationEvent("DOMNodeInserted",true,false,this,null,null,null,null);b.dispatchEvent(o);do{q=d;d=d.parentNode}while(d);if(q!==this.ownerDocument.documentElement){o=q=null;return b}o=this.ownerDocument.createEvent("MutationEvents");o.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);b.dispatchEvent(o);if(!b.hasChildNodes()){return b}k=b.getElementsByTagNameNS("*","*");if(k){for(var e=0,g=k.length;e<g;++e){j=k[e];j.dispatchEvent(o);j=null}}o=k=null;l=f=d=q=j=null;return b};Node.prototype.removeChild=function(f){if(!(f instanceof Node)){throw (new Error())}var a=this.ownerDocument.createEvent("MutationEvents");a.initMutationEvent("DOMNodeRemovedFromDocument",false,false,null,null,null,null,null);f.dispatchEvent(a);var c=f.getElementsByTagNameNS("*","*");if(c){a.initMutationEvent("DOMNodeRemovedFromDocument",false,false,null,null,null,null,null);for(var b=0,e=c.length;b<e;++b){var d=c[b];a.target=d;d.dispatchEvent(a);d=null}}a.initMutationEvent("DOMNodeRemoved",true,false,this,null,null,null,null);f.dispatchEvent(a);a=c=null;if(f.parentNode===this){this.childNodes.splice(f._num,1)}else{throw (new DOMException(DOMException.NOT_FOUND_ERR))}if(f.ownerDocument!==this.ownerDocument){throw (new Error())}return f};CharacterData.prototype.appendData=function(a){var c=this.data,b;this.data+=a;this.length=this.data.length;b=this.ownerDocument.createEvent("MutationEvents");b.initMutationEvent("DOMCharacterDataModified",true,false,null,c,this.data,null,null);this.parentNode.dispatchEvent(b);b=a=c=null};CharacterData.prototype.insertData=function(f,a){var c=this.data,e=this.substring(0,f-1),d=this.substring(f,this.length-f),b;this.data=e+this.data+d;this.length=this.data.length;b=this.ownerDocument.createEvent("MutationEvents");b.initMutationEvent("DOMCharacterDataModified",true,false,null,c,this.data,null,null);this.parentNode.dispatchEvent(b);b=a=c=e=d=null};CharacterData.prototype.deleteData=function(c,b){var a=this.data;pre=this.substring(0,c-1),next=this.substring(c+b,this.length-1),evt;if(c+b>this.length){next=""}this.data=pre+next;this.length=this.data.length;evt=this.ownerDocument.createEvent("MutationEvents");evt.initMutationEvent("DOMCharacterDataModified",true,false,null,a,this.data,null,null);this.parentNode.dispatchEvent(evt);evt=a=null};function StyleSheet(){this.type="text/css";this.disabled=false;this.ownerNode=null;this.parentStyleSheet=null;this.href=null;this.title="";this.media=new MediaList();return this}function MediaList(){this.mediaText="";this.length=0;return this}MediaList.prototype={item:function(a){return(this[a])},deleteMedium:function(a){for(var b=0,c=this.length;b<c;++b){if(this[b]===a){delete this[b];--this.length;return}}throw (new DOMException(DOMException.NOT_FOUND_ERR))},appendMedium:function(a){this[this.length]=a;++this.length}};function LinkStyle(){this.sheet=new StyleSheet();return this}function DocumentStyle(){this.styleSheets=[];return this}function CSSRule(){this.cssText="";this.parentStyleSheet;this.parentRule=null;return this}CSSRule.UNKNOWN_RULE=0;CSSRule.STYLE_RULE=1;CSSRule.CHARSET_RULE=2;CSSRule.IMPORT_RULE=3;CSSRule.MEDIA_RULE=4;CSSRule.FONT_FACE_RULE=5;CSSRule.PAGE_RULE=6;function CSSStyleRule(){CSSRule.call(this,arguments);this.type=CSSRule.STYLE_RULE;this.selectorText="";this.style=new CSSStyleDeclaration();this.style.parentRule=this;return this}CSSStyleRule.prototype=new CSSRule();CSSStyleRule.constructor=CSSRule;function CSSMediaRule(){CSSRule.call(this,arguments);this.type=CSSRule.MEDIA_RULE;this.media=new MediaList();this.cssRules=[];return this}CSSMediaRule.prototype=new CSSRule();CSSMediaRule.constructor=CSSRule;CSSMediaRule.prototype.insertRule=function(b,a){this.cssRules.splice(a,b,1);this.media.appendMedium(b);return this};CSSMediaRule.prototype.deleteRule=function(a){};function CSSFontFaceRule(){CSSRule.call(this,arguments);this.type=CSSRule.FONT_FACE_RULE;this.style;return this}CSSFontFaceRule.prototype=new CSSRule();CSSFontFaceRule.constructor=CSSRule;function CSSPageRule(){CSSRule.call(this,arguments);this.type=CSSRule.PAGE_RULE;this.selectorText="";this.style;return this}CSSPageRule.prototype=new CSSRule();CSSPageRule.constructor=CSSRule;function CSSImportRule(){CSSRule.call(this,arguments);this.type=CSSRule.IMPORT_RULE;this.href="";this.media=new MediaList();this.styleSheet=null;return this}CSSImportRule.prototype=new CSSRule();CSSImportRule.constructor=CSSRule;function CSSCharsetRule(){CSSRule.call(this,arguments);this.type=CSSRule.CHARSET_RULE;this.encoding="";return this}CSSCharsetRule.prototype=new CSSRule();CSSCharsetRule.constructor=CSSRule;function CSSUnknownRule(){CSSRule.call(this,arguments);this.type=CSSRule.UNKNOWN_RULE;return this}CSSUnknownRule.prototype=new CSSRule();CSSUnknownRule.constructor=CSSRule;function CSSStyleDeclaration(){this._list=[];this._def=this._list._fontSize=this._list._opacity=null;return this}CSSStyleDeclaration.prototype={cssText:"",length:0,parentRule:null,getPropertyValue:function(b){var c=this.getPropertyCSSValue(b);if(c){var a=c.cssText;return(a.substring(a.indexOf(":")+1,a.length))}else{return""}},getPropertyCSSValue:function(b){var f=b;b+=":";if(b===":"){return null}for(var c=0,e=this._list.length;c<e;++c){var d=this._list[c],a=d.cssText;if(a.indexOf(b)>-1){d._empercents=this._list._fontSize;a=f=b=null;return d}}if(this._def){a=b=null;return(this._def[f])}f=b=null;return null},removeProperty:function(a){var b=this.getPropertyCSSValue(a);if(b){this._list.splice(b._num,1);--this.length}},getPropertyPriority:function(a){var b=this.getPropertyCSSValue(a);if(b){return(b._priority)}else{return""}},setProperty:function(g,j,i){var d="";if(!!this[g]){var b=this.getPropertyCSSValue(g)}else{var b=null}d+=g;d+=":";d+=j;if(b){b._priority=i;b.cssText=d;var a=b}else{if((g==="fill")||(g==="stroke")){var a=new SVGPaint();var h=SVGPaint.SVG_PAINTTYPE_UNKNOWN,c=null,e=null;if(j==="none"){h=SVGPaint.SVG_PAINTTYPE_NONE}else{if(j==="currentColor"){h=SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR;e=this.getPropertyValue("color")}else{var f=/url\(#([^)]+)/;if(f.test(j)){h=SVGPaint.SVG_PAINTTYPE_URI;c=RegExp.$1}else{h=SVGPaint.SVG_PAINTTYPE_RGBCOLOR;e=j}}}a.setPaint(h,c,e,null);h=c=e=null}else{if(g==="color"){var a=new CSSPrimitiveValue();var l=this.getPropertyCSSValue("fill"),k=this.getPropertyCSSValue("stroke");if(l){if(l.paintType===SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR){l.setPaint(l.paintType,null,j,null)}}else{if(k){if(k.paintType===SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR){k.setPaint(l.paintType,null,j,null)}}}}else{var a=new CSSPrimitiveValue()}}a._priority=i;a.cssText=d;a._num=this._list.length;this._list[a._num]=a;this[g]=1;++this.length}if(j==="inherit"){a.cssValueType=CSSValue.CSS_INHERIT}else{if(g==="opacity"){this._list._opacity=parseFloat(j)}else{if(g==="font-size"){if(/(%|em)/.test(j)){this._list.fontSize=parseFloat(j)}}}}d=null},item:function(a){if(a>=this.length){var b=""}else{var b=this._list[a].cssText.substring(0,this._list[a].cssText.indexOf(":"))}return b}};function CSSValue(){return this}CSSValue.CSS_INHERIT=0;CSSValue.CSS_PRIMITIVE_VALUE=1;CSSValue.CSS_VALUE_LIST=2;CSSValue.CSS_CUSTOM=3;CSSValue.prototype={cssText:"",cssValueType:CSSValue.CSS_CUSTOM};function CSSPrimitiveValue(){return this}CSSPrimitiveValue.CSS_UNKNOWN=0;CSSPrimitiveValue.CSS_NUMBER=1;CSSPrimitiveValue.CSS_PERCENTAGE=2;CSSPrimitiveValue.CSS_EMS=3;CSSPrimitiveValue.CSS_EXS=4;CSSPrimitiveValue.CSS_PX=5;CSSPrimitiveValue.CSS_CM=6;CSSPrimitiveValue.CSS_MM=7;CSSPrimitiveValue.CSS_IN=8;CSSPrimitiveValue.CSS_PT=9;CSSPrimitiveValue.CSS_PC=10;CSSPrimitiveValue.CSS_DEG=11;CSSPrimitiveValue.CSS_RAD=12;CSSPrimitiveValue.CSS_GRAD=13;CSSPrimitiveValue.CSS_MS=14;CSSPrimitiveValue.CSS_S=15;CSSPrimitiveValue.CSS_HZ=16;CSSPrimitiveValue.CSS_KHZ=17;CSSPrimitiveValue.CSS_DIMENSION=18;CSSPrimitiveValue.CSS_STRING=19;CSSPrimitiveValue.CSS_URI=20;CSSPrimitiveValue.CSS_IDENT=21;CSSPrimitiveValue.CSS_ATTR=22;CSSPrimitiveValue.CSS_COUNTER=23;CSSPrimitiveValue.CSS_RECT=24;CSSPrimitiveValue.CSS_RGBCOLOR=25;CSSPrimitiveValue.prototype=new CSSValue();CSSPrimitiveValue.constructor=CSSValue;CSSPrimitiveValue.prototype._n=[1,0.01,1,1,1,35.43307,3.543307,90,1.25,15,1,180/Math.PI,90/100,1,1000,1,1000,1];CSSPrimitiveValue.prototype.cssValueType=CSSValue.CSS_PRIMITIVE_VALUE;CSSPrimitiveValue.prototype.primitiveType=CSSPrimitiveValue.CSS_UNKNOWN;CSSPrimitiveValue.prototype._value=1;CSSPrimitiveValue.prototype._percent=0;CSSPrimitiveValue.prototype._empercent=0;CSSPrimitiveValue.prototype.setFloatValue=function(a,b){if(CSSPrimitiveValue.CSS_UNKNOWN>=a&&a>=CSSPrimitiveValue.CSS_STRING){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}this.primitiveType=a;this._value=b*this._n[a-1]};CSSPrimitiveValue.prototype.getFloatValue=function(b){if(CSSPrimitiveValue.CSS_UNKNOWN>=b&&b>=CSSPrimitiveValue.CSS_STRING){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}var e=this.cssText.match(/\D+$/),d=0,a=parseFloat;var c=a(this.cssText.match(/[\d\.]+/));c=isNaN(c)?0:c;if(!!e){e=e[0]}if(!e){d=CSSPrimitiveValue.CSS_NUMBER}else{if(e==="%"){c*=this._percent;d=CSSPrimitiveValue.CSS_PERCENTAGE}else{if(e==="em"){c*=this._empercent;d=CSSPrimitiveValue.CSS_EMS}else{if(e==="ex"){d=CSSPrimitiveValue.CSS_EXS}else{if(e==="px"){d=CSSPrimitiveValue.CSS_PX}else{if(e==="cm"){d=CSSPrimitiveValue.CSS_CM}else{if(e==="mm"){d=CSSPrimitiveValue.CSS_MM}else{if(e==="in"){d=CSSPrimitiveValue.CSS_IN}else{if(e==="pt"){d=CSSPrimitiveValue.CSS_PT}else{if(e==="pc"){d=CSSPrimitiveValue.CSS_PC}}}}}}}}}}this.setFloatValue(d,c);return(this._value/this._n[b-1])};CSSPrimitiveValue.prototype.setStringValue=function(b,a){if(CSSPrimitiveValue.CSS_DIMENSION>=b&&b>=CSSPrimitiveValue.CSS_COUNTER){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}this.cssText=a};CSSPrimitiveValue.prototype.getStringValue=function(){if(CSSPrimitiveValue.CSS_DIMENSION>=stringType&&stringType>=CSSPrimitiveValue.CSS_COUNTER){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}return(this.cssText)};CSSPrimitiveValue.prototype.getCounterValue=function(){if(this.primitiveType!==CSSPrimitiveValue.CSS_COUNTER){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}return(new Counter())};CSSPrimitiveValue.prototype.getRectValue=function(){if(this.primitiveType!==CSSPrimitiveValue.CSS_RECT){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}return(new Rect())};CSSPrimitiveValue.prototype.getRGBColorValue=function(){if(this.primitiveType!==CSSPrimitiveValue.CSS_RGBCOLOR){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}var a=new RGBColor();var b=this.cssText;var c=SVGColor.prototype._keywords[b];if(c!==void 0){b=c}if(b.indexOf("%",5)>0){b=b.replace(/[\d.]+%/g,function(e){return Math.round((2.55*parseFloat(e)))})}else{if(b.indexOf("#")>-1){b=b.replace(/[\da-f][\da-f]/gi,function(e){return parseInt(e,16)})}}var d=b.match(/\d+/g);a.red.setFloatValue(CSSPrimitiveValue.CSS_NUMBER,parseFloat(d[0]));a.green.setFloatValue(CSSPrimitiveValue.CSS_NUMBER,parseFloat(d[1]));a.blue.setFloatValue(CSSPrimitiveValue.CSS_NUMBER,parseFloat(d[2]));d=b=null;return(a)};function CSSValueList(){this.cssValueType=CSSValue.CSS_VALUE_LIST;this.length=0;return this}CSSValueList.prototype=new CSSValue();CSSValueList.constructor=CSSValue;CSSValueList.prototype.item=function(a){return(this[a])};function RGBColor(){this.red=new CSSPrimitiveValue();this.green=new CSSPrimitiveValue();this.blue=new CSSPrimitiveValue();return this}function Rect(){this.top=new CSSPrimitiveValue();this.right=new CSSPrimitiveValue();this.bottom=new CSSPrimitiveValue();this.left=new CSSPrimitiveValue();return this}function Counter(){this.identifier="";this.listStyle="";this.separator="";return this}function ElementCSSInlineStyle(){this.style=new CSSStyleDeclaration();this._attributeStyle=new CSSStyleDeclaration();return this}var CSS2Properties={fill:"black",stroke:"none",cursor:"auto",visibility:"visiblee",display:"inline-block",opacity:"1",fillOpacity:"1",strokeWidth:"1",strokeDasharray:"none",strokeDashoffset:"0",strokeLinecap:"butt",strokeLinejoin:"miter",strokeMiterlimit:"4",strokeOpacity:"1",writingMode:"lr-tb",fontFamily:"serif",fontSize:"12",color:"black",fontSizeAdjust:"none",fontStretch:"normal",fontStyle:"normal",fontVariant:"normal",fontWeight:"normal",font:"inline",stopColor:"black",stopOpacity:"1",textAnchor:"start",azimuth:"center",clip:"auto",direction:"ltr",letterSpacing:"normal",lineHeight:"normal",overflow:"visible",textAlign:"left",textDecoration:"none",textIndent:"0",textShadow:"none",textTransform:"none",unicodeBidi:"normal",verticalAlign:"baseline",whiteSpace:"normal",wordSpacing:"normal",zIndex:"auto",mask:"none",enableBackground:"accumulate",filter:"none",floodColor:"black",floodOpacity:"1",lightingColor:"white",pointerEvents:"visiblePainted",colorInterpolation:"sRGB",colorInterpolationFilters:"linearRGB",colorProfile:"auto",colorRendering:"auto",imageRendering:"auto",marker:"",markerEnd:"none",markerMid:"none",markerStart:"none",shapeRendering:"auto",textRendering:"auto",alignmentBaseline:"",baselineShift:"baseline",dominantBaseline:"auto",glyphOrientationHorizontal:"0deg",glyphOrientationVertical:"auto",kerning:"auto",fillRule:"nonzero"};CSS2Properties.visibility._n=1;function CSSStyleSheet(){this.ownerRule=null;this.cssRules=[];return this}CSSStyleSheet.prototype=new StyleSheet();CSSStyleSheet.constructor=StyleSheet;CSSStyleSheet.prototype.insertRule=function(c,a){var b=new CSSStyleRule();b.parentStyleSheet=this;b.cssText=c;this.cssRules.splice(a,b,1)};CSSStyleSheet.prototype.deleteRule=function(a){this.cssRules.splice(a,1)};Document.prototype.defaultView=new ViewCSS();function ViewCSS(){return this}ViewCSS.prototype.getComputedStyle=function(h,g){if(!!h._currentStyle){return(h._currentStyle)}var t=new CSSStyleDeclaration();h._currentStyle=t;var d=h.parentNode;if(d){var e=this.getComputedStyle(d,g)._list}else{var e={length:0,_opacity:1,_fontSize:12}}var b=t._list;if(!!h.style){var l=h.style._list,a=h._attributeStyle._list,r=CSSValue.CSS_INHERIT;for(var k=0,o=l.length;k<o;++k){b[b.length]=l[k]}for(var k=0,o=a.length;k<o;++k){b[b.length]=a[k]}l=a=null;for(var k=0,j=b.length;k<j;++k){if(b[k].cssValueType===r){b.splice(k,1);--j}}}for(var k=0,f=e.length;k<f;++k){b[b.length]=e[k]}if(h._runtimeStyle){b=h._runtimeStyle._list.concat(b)}t._def=this._defaultCSS;t._list=b;if(!!h.style){var c=h.style._list._opacity||h._attributeStyle._list._opacity}else{var c=1}t._list._opacity=e._opacity*(c||1);t._list._fontSize=e._fontSize;d=c=e=b=null;t._document=h.ownerDocument;return t};Document.prototype.getOverrideStyle=function(b,e){var a=b;if(!!a._runtimeStyle){return(a._runtimeStyle)}else{var d=new CSSStyleDeclaration(),c=d.setProperty;a._runtimeStyle=d}d.setProperty=function(l,r,q){c.call(d,l,r,q);var k=b,f=k._tar,j=isStroke=false;delete k._currentStyle;if((k.localName==="g")||(k.localName==="a")){var g=k.getElementsByTagNameNS("http://www.w3.org/2000/svg","*");if(g){for(var h=0,s=g.length;h<s;++h){var o=g[h];delete o._currentStyle;NAIBU._setPaint(o,o.getScreenCTM());o=null}g=null}f=null}if(!f){return}NAIBU._setPaint(k,k.getScreenCTM());f=k=r=null};return d};DOMImplementation.createCSSStyleSheet=function(g,f){var e=new CSSStyleSheet();e.title=g;var a=new MediaList();a.mediaText=f;if(f!==""){var b=f.split(",");for(var d=0,c=b.length;d<c;++d){a.appendMedium(b[d])}}e.media=a;return e};function ElementTimeControl(a){this._tar=a;this._begin=0;this._end=null;return this}ElementTimeControl.prototype={beginElement:function(){var b=this.ownerDocument,a=b.createEvent("TimeEvents");a.initTimeEvent("beginEvent",b.defaultView,0);this.dispatchEvent(a)},endElement:function(){var b=this.ownerDocument,a=b.createEvent("TimeEvents");a.initTimeEvent("endEvent",b.defaultView,0);this.dispatchEvent(a)},beginElementAt:function(b){var a=this.ownerDocument.documentElement.getCurrentTime();this._begin=b+a},endElementAt:function(b){var a=this.ownerDocument.documentElement.getCurrentTime();this._end=b+a}};function TimeEvent(){Event.apply(this);this.view;this.detail;return this}TimeEvent.counstructor=Event;TimeEvent.prototype=new Event();TimeEvent.prototype.initTimeEvent=function(b,c,a){this.type=b;this.view=c;this.detail=a};var NAIBU={};function SVGException(a){this.code=a;if(this.code===SVGException.SVG_WRONG_TYPE_ERR){this.message="SVG Wrong Type Error"}else{if(this.code===SVGException.SVG_INVALID_VALUE_ERR){this.message="SVG Invalid Value Error"}else{if(this.code===SVGException.SVG_MATRIX_NOT_INVERTABLE){this.message="SVG　Matrix Not Invertable"}}}return this}SVGException.constructor=Error;SVGException.prototype=new Error();SVGException.SVG_WRONG_TYPE_ERR=0;SVGException.SVG_INVALID_VALUE_ERR=1;SVGException.SVG_MATRIX_NOT_INVERTABLE=2;function SVGElement(){Element.call(this);SVGStylable.call(this);this.transform=new SVGAnimatedTransformList();this.addEventListener("DOMAttrModified",function(evt){if(evt.eventPhase===Event.BUBBLING_PHASE){return}var name=evt.attrName,tar=evt.target;if(!!CSS2Properties[name]||name.indexOf("-")>-1){tar._attributeStyle.setProperty(name,evt.newValue,"")}if(evt.relatedNode.localName==="id"){tar.id=evt.newValue}else{if(name==="transform"&&!!tar.transform){var tft=evt.newValue,degR=tar._degReg,coma=tft.match(tar._comaReg),list=tft.match(tar._strReg),a,b,c,d,e,f,lis,com,deg,rad,degli,s,cm,degz;for(var j=0,cli=coma.length;j<cli;j++){s=evt.target.ownerDocument.documentElement.createSVGTransform();lis=list[j],com=coma[j];deg=lis.match(degR);degli=deg.length;if(degli===6){cm=s.matrix;cm.a=+(deg[0]);cm.b=+(deg[1]);cm.c=+(deg[2]);cm.d=+(deg[3]);cm.e=+(deg[4]);cm.f=+(deg[5])}else{if(degli===3){degz=+(deg[0]);s.setRotate(degz,+(deg[1]),+(deg[2]))}else{if(degli<=2){degz=+(deg[0]);if(com==="translate"){s.setTranslate(degz,+(deg[1]||0))}else{if(com==="scale"){s.setScale(degz,+(deg[1]||deg[0]))}else{if(com==="rotate"){s.setRotate(degz,0,0)}else{if(com==="skewX"){s.setSkewX(degz)}else{if(com==="skewY"){s.setSkewY(degz)}}}}}}}}tar.transform.baseVal.appendItem(s)}tft=degR=coma=list=a=b=c=d=e=f=lis=com=deg=rad=degli=s=cm=degz=null}else{if(name==="style"){var sc=evt.newValue,style=tar.style,a,ai,m;style.cssText=sc;if(sc!==""){sc=sc.replace(tar._shouReg,"").replace(tar._conReg,":").replace(tar._bouReg,";");a=sc.split(";");for(var i=0,ali=a.length;i<ali;++i){ai=a[i],m=ai.split(":");if(ai!==""){style.setProperty(m[0],m[1])}ai=m=null}}a=sc=style=null}else{if(name==="class"){tar.className=evt.newValue}else{if(name.indexOf("on")===0){eval("document._s = (function(evt){"+evt.newValue+"})");var v=name.substring(2,name.length);if(v==="load"){v="SVGLoad"}else{if(v==="unload"){v="SVGUnload"}else{if(v==="abort"){v="SVGAbort"}else{if(v==="error"){v="SVGError"}else{if(v==="resize"){v="SVGResize"}else{if(v==="scroll"){v="SVGScroll"}else{if(v==="zoom"){v="SVGZoom"}else{if(v==="begin"){v="beginEvent"}else{if(v==="end"){v="endEvent"}else{if(v==="repeat"){v="repeatEvent"}}}}}}}}}}tar.addEventListener(v,document._s,false)}else{if(evt.relatedNode.nodeName==="xml:base"){tar.xmlbase=evt.newValue}else{if(!!tar[name]){var tea=tar[name],tod=tar.ownerDocument.documentElement,tvw=tod.viewport.width,tvh=tod.viewport.height,n,type,_parseFloat,s;if(tea instanceof SVGAnimatedLength){n=evt.newValue.match(tar._NaNReg);type=1;_parseFloat=parseFloat;if(!!n){n=n[0]}if(n==="%"){if(tar._x1width[name]){tea.baseVal._percent=tvw*0.01}else{if(tar._y1height[name]){tea.baseVal._percent=tvh*0.01}else{tea.baseVal._percent=Math.sqrt((tvw*tvw+tvh*tvh)/2)*0.01}}type=2}else{if(n==="em"){type=3}else{if(n==="ex"){type=4}else{if(n==="px"){type=5}else{if(n==="cm"){type=6}else{if(n==="mm"){type=7}else{if(n==="in"){type=8}else{if(n==="pt"){type=9}else{if(n==="pc"){type=10}}}}}}}}}s=_parseFloat(evt.newValue);s=isNaN(s)?0:s;tea.baseVal.newValueSpecifiedUnits(type,s)}tea=tod=tvw=tvh=n=type=_parseFloat=s=null}}}}}}}evt=_parseFloat=name=tar=null},false);return this}SVGElement.constructor=Element;SVGElement.prototype=new Element();(function(){this._degReg=/[\-\d\.e]+/g;this._comaReg=/[A-Za-z]+(?=\s*\()/g;this._strReg=/\([^\)]+\)/g;this._syouReg=/^[^a-z\-]+/;this._conReg=/\:\s+/g;this._bouReg=/\s*;[^a-z\-]*/g;this._NaNReg=/\D+$/;this._cacheMatrix=null;this._x1width={x:1,x1:1,x2:1,width:1,cx:1};this._y1height={y:1,y1:1,y2:1,height:1,cy:1};this.id=null;this.xmlbase=null;this.ownerSVGElement;this.viewportElement;this.nearestViewportElement=null;this.farthestViewportElement=null;this.getBBox=function(){var o=new SVGRect(),d=this._tar.path.value,b=this.ownerDocument.documentElement.viewport,a=b.width,j=b.height,l=0,g=0,k=d.match(/[0-9\-]+/g),f,e;for(var c=0,h=k.length;c<h;c+=2){f=+(k[c]),e=+(k[c+1]);a=a>f?f:a;j=j>e?e:j;l=l>f?l:f;g=g>e?g:e}o.x=a;o.y=j;o.width=l-a;o.height=g-j;f=e=d=k=a=j=l=g=b=null;return o};this.getCTM=function(){var b,a;if(!!this._cacheMatrix){b=this._cacheMatrix}else{a=this.transform.baseVal.consolidate();if(a){a=a.matrix}else{a=this.ownerDocument.documentElement.createSVGMatrix()}if(this.parentNode&&!!this.parentNode.getCTM){b=this.parentNode.getCTM().multiply(a)}else{b=a}a=null;this._cacheMatrix=b}return b};this.getScreenCTM=function(){if(!this.parentNode){return null}var a=this.nearestViewportElement||this.ownerDocument.documentElement;var b=a.getScreenCTM().multiply(this.getCTM());a=null;return b};this.getTransformToElement=function(a){var b=this.getScreenCTM().inverse().multiply(a.getScreenCTM());return b}}).apply(SVGElement.prototype);function SVGAnimatedBoolean(){this.animVal=this.baseVal=true;return this}function SVGAnimatedString(){this.animVal=this.baseVal="";return this}function SVGStringList(){return this}SVGStringList.prototype=new Array();(function(){this.numberOfItems=0;this.clear=function(){for(var a=0,b=this.length;a<b;++a){delete this[a]}this.numberOfItems=0};this.initialize=function(a){this.clear();this[0]=a;this.numberOfItems=1;return a};this.getItem=function(a){if(a>=this.numberOfItems||a<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{return(this[a])}};this.insertItemBefore=function(b,a){if(a>=this.numberOfItems){this.appendItem(b)}else{this.splice(a,1,b,this.getItem[a]);++this.numberOfItems}return b};this.replaceItem=function(b,a){if(a>=this.numberOfItems||a<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{this.splice(a,1,b)}return b};this.removeItem=function(a){if(a>=this.numberOfItems||a<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{this.splice(a,1);--this.numberOfItems}return newItem};this.appendItem=function(a){this[this.numberOfItems]=a;++this.numberOfItems}}).apply(SVGStringList.prototype);function SVGAnimatedEnumeration(){this.baseVal=0;this.animVal=0;return this}function SVGAnimatedInteger(){this.baseVal=0;this.animVal=0;return this}function SVGNumber(){this.value=0;return this}function SVGAnimatedNumber(){this.baseVal=this.animVal=0;return this}function SVGNumberList(){return this}for(var prop in SVGStringList.prototype){SVGNumberList.prototype[prop]=SVGStringList.prototype[prop]}function SVGAnimatedNumberList(){this.animVal=this.baseVal=new SVGNumberList();return this}function SVGLength(){return this}SVGLength.SVG_LENGTHTYPE_UNKNOWN=0;SVGLength.SVG_LENGTHTYPE_NUMBER=1;SVGLength.SVG_LENGTHTYPE_PERCENTAGE=2;SVGLength.SVG_LENGTHTYPE_EMS=3;SVGLength.SVG_LENGTHTYPE_EXS=4;SVGLength.SVG_LENGTHTYPE_PX=5;SVGLength.SVG_LENGTHTYPE_CM=6;SVGLength.SVG_LENGTHTYPE_MM=7;SVGLength.SVG_LENGTHTYPE_IN=8;SVGLength.SVG_LENGTHTYPE_PT=9;SVGLength.SVG_LENGTHTYPE_PC=10;SVGLength.prototype={unitType:SVGLength.SVG_LENGTHTYPE_UNKNOWN,value:0,valueInSpecifiedUnits:SVGLength.SVG_LENGTHTYPE_UNKNOWN,valueAsString:"0",_percent:0.01,_fontSize:12,newValueSpecifiedUnits:function(a,c){var d=1,b="";if(a===1){}else{if(a===5){b="px"}else{if(a===2){d=this._percent;b="%"}else{if(a===3){d=this._fontSize;b="em"}else{if(a===4){d=this._fontSize*0.5;b="ex"}else{if(a===6){d=35.43307;b="cm"}else{if(a===7){d=3.543307;b="mm"}else{if(a===8){d=90;b="in"}else{if(a===9){d=1.25;b="pt"}else{if(a===10){d=15;b="pc"}else{throw new DOMException(DOMException.NOT_SUPPORTED_ERR)}}}}}}}}}}this.unitType=a;this.value=c*d;this.valueInSpecifiedUnits=c;this.valueAsString=c+b;c=a=d=b=null},convertToSpecifiedUnits:function(b){if(this.value===0){this.newValueSpecifiedUnits(b,0);return}var a=this.value;this.newValueSpecifiedUnits(b,this.valueInSpecifiedUnits);a=a/this.value*this.valueInSpecifiedUnits;this.newValueSpecifiedUnits(b,a)},_emToUnit:function(a){if((this.unitType===3)||(this.unitType===4)){this._fontSize=a;this.newValueSpecifiedUnits(this.unitType,this.valueInSpecifiedUnits)}}};function SVGAnimatedLength(){this.animVal;this.baseVal=new SVGLength();this.baseVal.unitType=1;return this}function SVGLengthList(){return this}for(var prop in SVGStringList.prototype){SVGLengthList.prototype[prop]=SVGStringList.prototype[prop]}function SVGAnimatedLengthList(){this.animVal=this.baseVal=new SVGLengthList();return this}function SVGAngle(){this.unitType=0;this.value=0;this.valueInSpecifiedUnits;this.valueAsString;return this}SVGAngle.prototype={newValueSpecifiedUnits:function(a,c){var d=1,b="";if(a===SVGAngle.SVG_ANGLETYPE_DEG){b="deg"}else{if(a===SVGAngle.SVG_ANGLETYPE_RAD){d=Math.PI/180;b="rad"}else{if(a===SVGAngle.SVG_ANGLETYPE_GRAD){d=9/10;b="grad"}}}this.unitType=a;this.value=c*d;this.valueInSpecifiedUnits=c;this.valuAsString=c+b;d=b=null},convertToSpecifiedUnits:function(a){this.newValueSpecifiedUnits(a,this.valueInSpecifiedUnits)}};SVGAngle.SVG_ANGLETYPE_UNKNOWN=0;SVGAngle.SVG_ANGLETYPE_UNSPECIFIED=1;SVGAngle.SVG_ANGLETYPE_DEG=2;SVGAngle.SVG_ANGLETYPE_RAD=3;SVGAngle.SVG_ANGLETYPE_GRAD=4;function SVGAnimatedAngle(){this.baseVal=new SVGAngle();this.animVal=this.baseVal;return this}function SVGColor(){CSSValue.call(this,arguments);this.colorType=0;this.rgbColor=new RGBColor();this.iccColor;return this}SVGColor.SVG_COLORTYPE_UNKNOWN=0;SVGColor.SVG_COLORTYPE_RGBCOLOR=1;SVGColor.SVG_COLORTYPE_RGBCOLOR_ICCCOLOR=2;SVGColor.SVG_COLORTYPE_CURRENTCOLOR=3;SVGColor.prototype=new CSSValue();SVGColor.constructor=CSSValue;SVGColor.prototype.setRGBColor=function(i){var j=this._keywords[i],e,d,h,f,a,k;if(j!==void 0){i=j}if(i.indexOf("%",5)>0){i=i.replace(/[\d.]+%/g,function(b){return Math.round((2.55*parseFloat(b)))});e=i.match(/\d+/g)}else{if(i.indexOf("#")===0){e=[];d=parseInt;h=i.charAt(1);f=i.charAt(2);a=i.charAt(3);if(i.length<5){k="#"+h+h+f+f+a+a;i=k;k=null}e[0]=d(h+i.charAt(2),16)+"";e[1]=d(i.charAt(3)+i.charAt(4),16)+"";e[2]=d(i.charAt(5)+i.charAt(6),16)+"";h=f=a=null}else{e=i.match(/\d+/g);if(!!!e){i=null;return}}}this.rgbColor.red.cssText=e[0];this.rgbColor.green.cssText=e[1];this.rgbColor.blue.cssText=e[2];i=j=e=d=null};SVGColor.prototype.setColor=function(a,b,c){this.colorType=a;if((a===1)||(a===3)){this.setRGBColor(b)}a=b=null};SVGColor.prototype._keywords={aliceblue:"rgb(240, 248, 255)",antiquewhite:"rgb(250, 235, 215)",aqua:"rgb( 0, 255, 255)",aquamarine:"rgb(127, 255, 212)",azure:"rgb(240, 255, 255)",beige:"rgb(245, 245, 220)",bisque:"rgb(255, 228, 196)",black:"rgb( 0, 0, 0)",blanchedalmond:"rgb(255, 235, 205)",blue:"rgb( 0, 0, 255)",blueviolet:"rgb(138, 43, 226)",brown:"rgb(165, 42, 42)",burlywood:"rgb(222, 184, 135)",cadetblue:"rgb( 95, 158, 160)",chartreuse:"rgb(127, 255, 0)",chocolate:"rgb(210, 105, 30)",coral:"rgb(255, 127, 80)",cornflowerblue:"rgb(100, 149, 237)",cornsilk:"rgb(255, 248, 220)",crimson:"rgb(220, 20, 60)",cyan:"rgb( 0, 255, 255)",darkblue:"rgb( 0, 0, 139)",darkcyan:"rgb( 0, 139, 139)",darkgoldenrod:"rgb(184, 134, 11)",darkgray:"rgb(169, 169, 169)",darkgreen:"rgb( 0, 100, 0)",darkgrey:"rgb(169, 169, 169)",darkkhaki:"rgb(189, 183, 107)",darkmagenta:"rgb(139, 0, 139)",darkolivegreen:"rgb( 85, 107, 47)",darkorange:"rgb(255, 140, 0)",darkorchid:"rgb(153, 50, 204)",darkred:"rgb(139, 0, 0)",darksalmon:"rgb(233, 150, 122)",darkseagreen:"rgb(143, 188, 143)",darkslateblue:"rgb( 72, 61, 139)",darkslategray:"rgb( 47, 79, 79)",darkslategrey:"rgb( 47, 79, 79)",darkturquoise:"rgb( 0, 206, 209)",darkviolet:"rgb(148, 0, 211)",deeppink:"rgb(255, 20, 147)",deepskyblue:"rgb( 0, 191, 255)",dimgray:"rgb(105, 105, 105)",dimgrey:"rgb(105, 105, 105)",dodgerblue:"rgb( 30, 144, 255)",firebrick:"rgb(178, 34, 34)",floralwhite:"rgb(255, 250, 240)",forestgreen:"rgb( 34, 139, 34)",fuchsia:"rgb(255, 0, 255)",gainsboro:"rgb(220, 220, 220)",ghostwhite:"rgb(248, 248, 255)",gold:"rgb(255, 215, 0)",goldenrod:"rgb(218, 165, 32)",gray:"rgb(128, 128, 128)",grey:"rgb(128, 128, 128)",green:"rgb( 0, 128, 0)",greenyellow:"rgb(173, 255, 47)",honeydew:"rgb(240, 255, 240)",hotpink:"rgb(255, 105, 180)",indianred:"rgb(205, 92, 92)",indigo:"rgb( 75, 0, 130)",ivory:"rgb(255, 255, 240)",khaki:"rgb(240, 230, 140)",lavender:"rgb(230, 230, 250)",lavenderblush:"rgb(255, 240, 245)",lawngreen:"rgb(124, 252, 0)",lemonchiffon:"rgb(255, 250, 205)",lightblue:"rgb(173, 216, 230)",lightcoral:"rgb(240, 128, 128)",lightcyan:"rgb(224, 255, 255)",lightgoldenrodyellow:"rgb(250, 250, 210)",lightgray:"rgb(211, 211, 211)",lightgreen:"rgb(144, 238, 144)",lightgrey:"rgb(211, 211, 211)",lightpink:"rgb(255, 182, 193)",lightsalmon:"rgb(255, 160, 122)",lightseagree:"rgb( 32, 178, 170)",lightskyblue:"rgb(135, 206, 250)",lightslategray:"rgb(119, 136, 153)",lightslategrey:"rgb(119, 136, 153)",lightsteelblue:"rgb(176, 196, 222)",lightyellow:"rgb(255, 255, 224)",lime:"rgb( 0, 255, 0)",limegreen:"rgb( 50, 205, 50)",linen:"rgb(250, 240, 230)",magenta:"rgb(255, 0, 255)",maroon:"rgb(128, 0, 0)",mediumaquamarine:"rgb(102, 205, 170)",mediumblue:"rgb( 0, 0, 205)",mediumorchid:"rgb(186, 85, 211)",mediumpurple:"rgb(147, 112, 219)",mediumseagreen:"rgb( 60, 179, 113)",mediumslateblue:"rgb(123, 104, 238)",mediumspringgreen:"rgb( 0, 250, 154)",mediumturquoise:"rgb( 72, 209, 204)",mediumvioletred:"rgb(199, 21, 133)",midnightblue:"rgb( 25, 25, 112)",mintcream:"rgb(245, 255, 250)",mistyrose:"rgb(255, 228, 225)",moccasin:"rgb(255, 228, 181)",navajowhite:"rgb(255, 222, 173)",navy:"rgb( 0, 0, 128)",oldlace:"rgb(253, 245, 230)",olive:"rgb(128, 128, 0)",olivedrab:"rgb(107, 142, 35)",orange:"rgb(255, 165, 0)",orangered:"rgb(255, 69, 0)",orchid:"rgb(218, 112, 214)",palegoldenrod:"rgb(238, 232, 170)",palegreen:"rgb(152, 251, 152)",paleturquoise:"rgb(175, 238, 238)",palevioletred:"rgb(219, 112, 147)",papayawhip:"rgb(255, 239, 213)",peachpuff:"rgb(255, 218, 185)",peru:"rgb(205, 133, 63)",pink:"rgb(255, 192, 203)",plum:"rgb(221, 160, 221)",powderblue:"rgb(176, 224, 230)",purple:"rgb(128, 0, 128)",red:"rgb(255, 0, 0)",rosybrown:"rgb(188, 143, 143)",royalblue:"rgb( 65, 105, 225)",saddlebrown:"rgb(139, 69, 19)",salmon:"rgb(250, 128, 114)",sandybrown:"rgb(244, 164, 96)",seagreen:"rgb( 46, 139, 87)",seashell:"rgb(255, 245, 238)",sienna:"rgb(160, 82, 45)",silver:"rgb(192, 192, 192)",skyblue:"rgb(135, 206, 235)",slateblue:"rgb(106, 90, 205)",slategray:"rgb(112, 128, 144)",slategrey:"rgb(112, 128, 144)",snow:"rgb(255, 250, 250)",springgreen:"rgb( 0, 255, 127)",steelblue:"rgb( 70, 130, 180)",tan:"rgb(210, 180, 140)",teal:"rgb( 0, 128, 128)",thistle:"rgb(216, 191, 216)",tomato:"rgb(255, 99, 71)",turquoise:"rgb( 64, 224, 208)",violet:"rgb(238, 130, 238)",wheat:"rgb(245, 222, 179)",white:"rgb(255, 255, 255)",whitesmoke:"rgb(245, 245, 245)",yellow:"rgb(255, 255, 0)",yellowgreen:"rgb(154, 205, 50)"};function SVGRect(){this.x=0;this.y=0;this.width=0;this.height=0;return this}function SVGAnimatedRect(){this.animVal=this.baseVal=new SVGRect();return this}SVGUnitTypes={SVG_UNIT_TYPE_UNKNOWN:0,SVG_UNIT_TYPE_USERSPACEONUSE:1,SVG_UNIT_TYPE_OBJECTBOUNDINGBOX:2};function SVGStylable(){this.className=new SVGAnimatedString();this.style=new CSSStyleDeclaration();this._attributeStyle=new CSSStyleDeclaration()}SVGElement.prototype.getPresentationAttribute=function(a){var b=this._attributeStyle.getPropertyCSSValue(a);if(b){return b}else{return null}};function SVGURIReference(){this.href=new SVGAnimatedString();this._instance=null;this._text="";this.addEventListener("DOMAttrModified",function(a){if(a.relatedNode.namespaceURI==="http://www.w3.org/1999/xlink"&&a.attrName==="xlink:href"){a.target.href.baseVal=a.newValue;a.target.ownerDocument.documentElement._svgload_limited++}a=null},false);this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===Event.BUBBLING_PHASE){return}a.addEventListener("DOMNodeInsertedIntoDocument",function(r){var i=r.target,f,c=i.href.baseVal,q,g,u,l,s,h,e,k,d,o,t,j;if(c!==""){g=i.xmlbase;if(!g){u=i.parentNode;l=null;while(!l&&u){l=u.xmlbase;u=u.parentNode}f=l;if(!l){if(c.indexOf("#")!==0){s=location.href;f=s.replace(/\/[^\/]+?$/,"/")}else{f=location.href}}}else{f=g}if(c.indexOf(":")!==-1){f=""}h=f+c;q=i.getAttributeNS("http://www.w3.org/1999/xlink","show")||"embed";if(c.indexOf(".")===0){h=c}if(q==="replace"){i._tar.setAttribute("href",h)}else{if(q==="new"){i._tar.setAttribute("target","_blank");i._tar.setAttribute("href",h)}else{if(q==="embed"){e=NAIBU.xmlhttp;k=h.indexOf("#");if(k>-1){d=h.substring(k+1,h.length);h=h.replace(/#.+$/,"")}else{d=null}if(c.indexOf("#")===0){o=i.ownerDocument;t=o.getElementById(d);i._instance=t;j=o.createEvent("SVGEvents");j.initEvent("SVGLoad",false,false);i.dispatchEvent(j)}else{if(h.indexOf("data:")>-1){i._tar.src=h}else{if((h.indexOf("http:")>-1)||(h.indexOf(".")===0)){if(i.localName==="image"){i._tar.src=h}e.open("GET",h,false);e.setRequestHeader("X-Requested-With","XMLHttpRequest");e.onreadystatechange=function(){if(e.readyState===4&&e.status===200){var v=e.getResponseHeader("Content-Type")||"text",A,B,z,w;if((v.indexOf("text")>-1)||(v.indexOf("xml")>-1)||(v.indexOf("script")>-1)){if(i.localName!=="script"&&i.localName!=="style"){A=new ActiveXObject("MSXML2.DomDocument");B=e.responseText.replace(/!DOCTYPE/,"!--").replace(/(dtd">|\]>)/,"-->");NAIBU.doc.async=false;NAIBU.doc.validateOnParse=false;NAIBU.doc.resolveExternals=false;NAIBU.doc.preserveWhiteSpace=false;A.loadXML(B);z=A.documentElement;i._instance=i.ownerDocument.importNode(z,true);if(d){i._instance=i._instance.ownerDocument.getElementById(d)}}else{i._text=e.responseText}}else{if(!!i._tar){i._tar.src=h}}w=i.ownerDocument.createEvent("SVGEvents");w.initEvent("SVGLoad",false,false);i.dispatchEvent(w);v=A=B=w=null;e.onreadystatechange=NAIBU.emptyFunction}};e.send(null)}}}}}}}r=i=f=c=g=u=l=s=h=e=k=d=o=t=j=q=null},false);a=b=null},false);return this}function SVGCSSRule(){CSSRule.apply(this,arguments);this.COLOR_PROFILE_RULE=7;return this}SVGCSSRule.constructor=CSSRule;SVGCSSRule.prototype=new CSSRule();function SVGDocument(){Document.apply(this,arguments);this.title="";this.referrer=document.referrer;this.domain=document.domain;this.URL=document.location;this.rootElement;return this}SVGDocument.constructor=Document;SVGDocument.prototype=new Document();function SVGSVGElement(){SVGElement.apply(this,arguments);this._tar=document.createElement("v:group");this._svgload_limited=0;this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.contentScriptType="application/ecmascript";this.contentStyleType="text/css";this.viewport=this.createSVGRect();this.useCurrentView=false;this.currentView=new SVGViewSpec(this);this.currentScale=1;this.currentTranslate=this.createSVGPoint();this.viewBox=this.currentView.viewBox;this.preserveAspectRatio=this.currentView.preserveAspectRatio;this.zoomAndPan=SVGZoomAndPan.SVG_ZOOMANDPAN_DISABLE;this._tx=0;this._ty=0;this._currentTime=0;this.addEventListener("DOMAttrModified",function(i){if(i.eventPhase===Event.BUBBLING_PHASE){return}var d=i.target,b=i.attrName,c,h,e,f,g,a;if(b==="viewBox"){d._cacheScreenCTM=null;c=d.viewBox.baseVal;h=i.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/);c.x=parseFloat(h[0]);c.y=parseFloat(h[1]);c.width=parseFloat(h[2]);c.height=parseFloat(h[3]);d.viewBox.baseVal._isUsed=1}else{if(b==="preserveAspectRatio"){d._cacheScreenCTM=null;e=i.newValue;f=d.preserveAspectRatio.baseVal;g=1;a=SVGPreserveAspectRatio.SVG_MEETORSLICE_UNKNOWN;if(!!e.match(/x(Min|Mid|Max)Y(Min|Mid|Max)(?:\s+(meet|slice))?/)){switch(RegExp.$1){case"Min":g+=1;break;case"Mid":g+=2;break;case"Max":g+=3;break}switch(RegExp.$2){case"Min":break;case"Mid":g+=3;break;case"Max":g+=6;break}if(RegExp.$3==="slice"){a=SVGPreserveAspectRatio.SVG_MEETORSLICE_SLICE}else{a=SVGPreserveAspectRatio.SVG_MEETORSLICE_MEET}}f.align=g;f.meetOrSlice=a}else{if(b==="width"){d.viewport.width=d.width.baseVal.value}else{if(b==="height"){d.viewport.height=d.height.baseVal.value}}}}i=b=c=h=e=f=g=a=null},false);this.addEventListener("SVGLoad",function(a){a.target.addEventListener("DOMAttrModified",function(d){if(d.eventPhase===Event.BUBBLING_PHASE){var c=d.target,b;if(c.parentNode){b=c.ownerDocument.createEvent("MutationEvents");b.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);b.target=c;b.eventPhase=Event.AT_TARGET;var g=c._capter;for(var e=0,f=g.length;e<f;++e){if(g[e]){g[e].handleEvent(b)}}b=null}c=null}d=null},false);a=null},true);return this}SVGSVGElement.constructor=SVGElement;SVGSVGElement.prototype=new SVGElement();SVGSVGElement.prototype.forceRedraw=function(){};SVGSVGElement.prototype.getCurrentTime=function(){return(this._currentTime)};SVGSVGElement.prototype.setCurrentTime=function(a){this._currentTime=a};SVGSVGElement.prototype.createSVGNumber=function(){var a=new SVGNumber();a.value=0;return a};SVGSVGElement.prototype.createSVGLength=function(){var a=new SVGLength();a.unitType=1;return a};SVGSVGElement.prototype.createSVGPoint=function(){return new SVGPoint()};SVGSVGElement.prototype.createSVGMatrix=function(){return new SVGMatrix()};SVGSVGElement.prototype.createSVGRect=function(){return new SVGRect()};SVGSVGElement.prototype.createSVGTransform=function(){var a=this.createSVGTransformFromMatrix(this.createSVGMatrix());return a};SVGSVGElement.prototype.createSVGTransformFromMatrix=function(a){var b=new SVGTransform();b.setMatrix(a);return b};SVGSVGElement.prototype.getScreenCTM=function(){if(!!this._cacheScreenCTM){return(this._cacheScreenCTM)}var l=this.viewport.width,u=this.viewport.height,r,j,o,b,a,c,g,e,k,f,q,t,s,d;if(!this.useCurrentView){r=this.viewBox.baseVal;j=this.preserveAspectRatio.baseVal}else{r=this.currentView.viewBox.baseVal;j=this.currentView.preserveAspectRatio.baseVal}if(!!!r._isUsed){this._tx=this._ty=0;o=this.createSVGMatrix();this._cacheScreenCTM=o;return o}else{b=r.x;a=r.y;c=r.width;g=r.height;e=l/c;k=u/g;f=1;q=1;t=0;s=0;if(j.align===1){f=e;q=k;t=-b*f;s=-a*q}else{var i=(j.align+1)%3+1;var h=Math.round(j.align/3);switch(j.meetOrSlice){case 1:f=q=Math.min(e,k);break;case 2:f=q=Math.max(e,k);break}t=-b*f;s=-a*q;switch(i){case 1:break;case 2:t+=(l-c*f)/2;break;case 3:t+=l-c*f;break}switch(h){case 1:break;case 2:s+=(u-g*q)/2;break;case 3:s+=u-g*q;break}}}this._tx=t;this._ty=s;d=this._tar.style;d.marginLeft=t+"px";d.marginTop=s+"px";o=this.createSVGMatrix();o.a=f;o.d=q;this._cacheScreenCTM=o;l=u=r=j=b=a=c=g=e=k=f=q=t=s=d=null;return o};SVGZoomAndPan={SVG_ZOOMANDPAN_UNKNOWN:0,SVG_ZOOMANDPAN_DISABLE:1,SVG_ZOOMANDPAN_MAGNIFY:2};function SVGFitToViewBox(){this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();return this}function SVGViewSpec(a){SVGFitToViewBox.apply(this,arguments);this.transform=new SVGTransformList();this.viewTarget=a;this.viewBoxString="";this.preserveAspectRatioString="";this.transformString="";this.viewTargetString="";return this}SVGViewSpec.constructor=SVGFitToViewBox;SVGViewSpec.prototype=new SVGFitToViewBox();function SVGGElement(){SVGElement.apply(this);this._tar=document.createElement("v:group");this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===3){return}var d=a.nextSibling,e=a.parentNode,c=true;if(d&&d._tar&&e._tar&&(d._tar.parentNode===e._tar)){e._tar.insertBefore(a._tar,d._tar)}else{if(d&&!d._tar&&e._tar){while(d){if(d._tar&&(d._tar.parentNode===e._tar)){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}}else{if(!d&&e._tar){e._tar.appendChild(a._tar)}}}d=e=c=null;a.addEventListener("DOMAttrModified",function(h){if(h.eventPhase===Event.BUBBLING_PHASE){return}var g=h.target;var l=g.getElementsByTagNameNS("http://www.w3.org/2000/svg","*");if(l){g._currentStyle=g._cacheMatrix=null;var f=g.ownerDocument.createEvent("MutationEvents");f.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);for(var k=0,j=l.length;k<j;++k){var o=l[k];o._currentStyle=o._cacheMatrix=null;o.dispatchEvent(f);o=null}f=null}h=g=l=null},false);b=a=null},false);return this}SVGGElement.constructor=SVGElement;SVGGElement.prototype=new SVGElement();function SVGDefsElement(){SVGElement.apply(this,arguments);this.style.setProperty("display","none");return this}SVGDefsElement.constructor=SVGElement;SVGDefsElement.prototype=new SVGElement();function SVGDescElement(){SVGElement.apply(this,arguments);return this}SVGDescElement.constructor=SVGElement;SVGDescElement.prototype=new SVGElement();function SVGTitleElement(){SVGElement.apply(this,arguments);this.addEventListener("DOMCharacterDataModified",function(a){a.target.ownerDocument.title=a.target.firstChild.nodeValue},false);return this}SVGTitleElement.constructor=SVGElement;SVGTitleElement.prototype=new SVGElement();function SVGSymbolElement(){SVGElement.apply(this,arguments);SVGURIReference.apply(this);return this}SVGDefsElement.constructor=SVGElement;SVGDefsElement.prototype=new SVGElement();function SVGUseElement(){SVGGElement.apply(this,arguments);this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.instanceRoot=new SVGElementInstance();this.animatedInstanceRoot=new SVGElementInstance();this.addEventListener("DOMNodeInserted",function(a){if(a.eventPhase===Event.BUBBLING_PHASE){return}a.target.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed")},false);this.addEventListener("SVGLoad",function(c){var b=c.target,e=b.ownerDocument.defaultView.getComputedStyle(b,""),f=parseFloat(e.getPropertyValue("font-size")),a=b.transform.baseVal,d=b.ownerDocument.documentElement.createSVGTransform();b.x.baseVal._emToUnit(f);b.y.baseVal._emToUnit(f);b.width.baseVal._emToUnit(f);b.height.baseVal._emToUnit(f);b.instanceRoot=b.animatedInstanceRoot=b.ownerDocument.importNode(b._instance,true);d.setTranslate(b.x.baseVal.value,b.y.baseVal.value);a.appendItem(d);b.appendChild(b.instanceRoot);c=d=b=evtt=a=e=f=null},false);SVGURIReference.apply(this);return this}SVGUseElement.constructor=SVGElement;SVGUseElement.prototype=new SVGElement();function SVGElementInstance(){Node.apply(this,arguments);this.correspondingElement;this.correspondingUseElement;this.parentNode;this.childNodes;this.firstChild;this.lastChild;this.previousSibling;this.nextSibling;return this}SVGElementInstance.prototype=new Node();function SVGElementInstanceList(){this.length=0;return this}SVGElementInstanceList.prototype.item=function(a){return(this[a])};function SVGImageElement(){SVGElement.apply(this,arguments);this._tar=document.createElement("v:image");this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;a.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed");if(a.nextSibling){if(!!a.parentNode._tar&&!!a.nextSibling._tar){a.parentNode._tar.insertBefore(a._tar,a.nextSibling._tar)}}else{if(!!a.parentNode._tar){a.parentNode._tar.appendChild(a._tar)}}a.addEventListener("DOMNodeInsertedIntoDocument",function(j){var g=j.target,d=g.ownerDocument.defaultView.getComputedStyle(g,""),k=parseFloat(d.getPropertyValue("font-size")),h=g._tar.style,f=g.getScreenCTM(),e=g.ownerDocument.documentElement.createSVGPoint(),i=parseFloat(d.getPropertyValue("fill-opacity")),c;g.x.baseVal._emToUnit(k);g.y.baseVal._emToUnit(k);g.width.baseVal._emToUnit(k);g.height.baseVal._emToUnit(k);h.position="absolute";e.x=g.x.baseVal.value;e.y=g.y.baseVal.value;e=e.matrixTransform(f);h.left=e.x+"px";h.top=e.y+"px";h.width=g.width.baseVal.value*f.a+"px";h.height=g.height.baseVal.value*f.d+"px";if(i!==1){h.filter="progid:DXImageTransform.Microsoft.Alpha";c=g._tar.filters.item("DXImageTransform.Microsoft.Alpha");c.Style=0;c.Opacity=i*100;c=null}j=g=d=k=h=f=e=i=null},false);b=a=null},false);SVGURIReference.apply(this);return this}SVGImageElement.constructor=SVGElement;SVGImageElement.prototype=new SVGElement();function SVGSwitchElement(){SVGElement.apply(this,arguments);return this}SVGSwitchElement.constructor=SVGElement;SVGSwitchElement.prototype=new SVGElement();var sieb_s;function GetSVGDocument(a){this._tar=a;this._next=null;return this}GetSVGDocument.prototype={_init:function(){var b=NAIBU.xmlhttp,a=this._tar,c=this,d;if(this._tar.nodeName==="OBJECT"){d="data"}else{d="src"}b.open("GET",a.getAttribute(d),true);a.style.display="none";b.setRequestHeader("X-Requested-With","XMLHttpRequest");this.xmlhttp=b;b.onreadystatechange=function(){c._ca()};b.send(null);a=d=null},_ca:function(){if((this.xmlhttp.readyState===4)&&(this.xmlhttp.status===200)){var C=this.xmlhttp.responseText,t=this._tar,J=DOMImplementation.createDocument("http://www.w3.org/2000/svg","svg"),G=J.documentElement,j=G.viewport,q,u,B,N,k,E,M=G._tar,g=document.createElement("div"),X=document.createElement("v:group"),r=document.createElement("v:rect"),L,l,H,T,e,o,Z,V,Q,W,Y,f,d,R,D,U,z,P=parseFloat;NAIBU.doc.async=false;NAIBU.doc.validateOnParse=false;NAIBU.doc.resolveExternals=false;NAIBU.doc.preserveWhiteSpace=true;NAIBU.doc.loadXML(C);screen.updateInterval=999;if(/&[^;]+;/.test(C)){var K=C;var I=(NAIBU.doc.doctype)?NAIBU.doc.doctype.entities:{length:0};for(var S=0;S<I.length;S++){var v=I.item(S);var c=new RegExp("&"+v.nodeName+";","g");K=K.replace(c,v.firstChild.xml)}NAIBU.doc.loadXML(K);K=null}j.top=0;j.left=0;j.width=t.clientWidth;j.height=t.clientHeight;if(j.height<24){j.height=screen.availHeight}if(G.viewport.height<24){G.viewport.height=screen.width}q=t.getAttribute("width");u=t.getAttribute("height");if(q){G.setAttributeNS(null,"width",q)}if(u){G.setAttributeNS(null,"height",u)}B=NAIBU.doc.documentElement.firstChild;k=NAIBU.doc.documentElement.attributes;for(var S=0,a=k.length;S<a;++S){E=J.importNode(k[S],false);G.setAttributeNodeNS(E)}C=k=null;X.style.width=j.width+"px";X.style.height=j.height+"px";X.coordsize=j.width+" "+j.height;g.appendChild(X);t.parentNode.insertBefore(g,t);X.appendChild(M);while(B){N=J.importNode(B,true);G.appendChild(N);B=B.nextSibling}B=null;L=G.ownerDocument.defaultView.getComputedStyle(G,"");l=parseFloat(L.getPropertyValue("font-size"));G.x.baseVal._emToUnit(l);G.y.baseVal._emToUnit(l);G.width.baseVal._emToUnit(l);G.height.baseVal._emToUnit(l);H=j.width;T=j.height;e=G.width.baseVal.value;o=G.height.baseVal.value;r.style.position="absolute";r.style.width=H+"px";r.style.height=T+"px";r.style.zIndex=-1;r.stroked="false";r.filled="false";G._tar.appendChild(r);Z=G._tar.style;V=t.style;Z.visibility="visible";Z.position="absolute";Z.overflow="hidden";Q=r.currentStyle;W=H>e?e:H;Y=T>o?o:T;f=parseFloat(Q.left);d=parseFloat(Q.top);R=-G._tx;bt=-G._ty;if(f!==0&&!isNaN(f)){R=f;X.style.left=-R+"px"}if(d!==0&&!isNaN(f)){bt=d;X.style.top=-bt+"px"}D=R+W+1;U=bt+Y+1;Z.clip="rect("+bt+"px "+D+"px "+U+"px "+R+"px)";this._document=J;if("_svgload_limited" in J.documentElement){J.documentElement._svgload_limited--;if(J.documentElement._svgload_limited<0){var A=J.createEvent("SVGEvents");A.initEvent("SVGLoad",false,false);J.documentElement.dispatchEvent(A)}}z=J.documentElement._tar.getElementsByTagName("div");for(var S=0,F=z.length;S<F;++S){var O=z[S];if(O.firstChild.nodeName!=="shape"){var b=O.style;b.left=P(b.left)+R+"px";b.top=P(b.top)+bt+"px";b=null}}J.defaultView._cache=J.defaultView._cache_ele=null;A=t=G=j=q=u=N=E=M=g=X=r=H=T=e=o=L=l=null;Z=V=Q=W=Y=z=f=d=R=bt=U=D=null;z=P=null;this.xmlhttp.onreadystatechange=NAIBU.emptyFunction;if(this._next){J=null;this._next._init()}else{if(J.implementation._buffer_){screen.updateInterval=0;NAIBU._buff_num=0;NAIBU._buff=setInterval(function(){if(DOMImplementation._buffer_.length===0){clearInterval(Event._buff)}else{var ab=NAIBU._buff_num;for(var w=0;w<50;++w){var aa=DOMImplementation._buffer_[ab],h=DOMImplementation._buffer_[ab+1];aa.dispatchEvent(h);ab+=2;aa=h=null;if(ab>=DOMImplementation._buffer_.length){clearInterval(NAIBU._buff);DOMImplementation._buffer_=null;NAIBU.Time.start();return}}NAIBU._buff_num=ab;ab=null}},1);J=null}else{J=null;NAIBU.Time.start()}delete NAIBU.doc}}},getSVGDocument:function(){return(this._document)}};NAIBU.emptyFunction=function(){};function SVGStyleElement(){SVGElement.apply(this,arguments);this.xmlspace;this.type="text/css";this.media;this.title;return this}SVGStyleElement.constructor=SVGElement;SVGStyleElement.prototype=new SVGElement();function SVGPoint(){return this}SVGPoint.prototype.x=SVGPoint.prototype.y=0;SVGPoint.prototype.matrixTransform=function(b){var a=parseInt(b.a*this.x+b.c*this.y+b.e);var d=parseInt(b.b*this.x+b.d*this.y+b.f);if((-1<a)&&(a<1)){a=1}if((-1<d)&&(d<1)){d=1}var c=new SVGPoint();c.x=a;c.y=d;return c};function SVGPointList(){return this}for(var prop in SVGStringList.prototype){SVGPointList.prototype[prop]=SVGStringList.prototype[prop]}function SVGMatrix(){return this}SVGMatrix.prototype={a:1,b:0,c:0,d:1,e:0,f:0,multiply:function(b){var c=new SVGMatrix(),a=b;if(!isFinite(a.a)||!isFinite(a.b)||!isFinite(a.c)||!isFinite(a.d)||!isFinite(a.e)||!isFinite(a.f)){throw (new Error("引数の値がNumber型ではありません"))}c.a=this.a*a.a+this.c*a.b;c.b=this.b*a.a+this.d*a.b;c.c=this.a*a.c+this.c*a.d;c.d=this.b*a.c+this.d*a.d;c.e=this.a*a.e+this.c*a.f+this.e;c.f=this.b*a.e+this.d*a.f+this.f;a=b=null;return c},inverse:function(){var a=new SVGMatrix(),b=this._determinant();if(b!==0){a.a=this.d/b;a.b=-this.b/b;a.c=-this.c/b;a.d=this.a/b;a.e=(this.c*this.f-this.d*this.e)/b;a.f=(this.b*this.e-this.a*this.f)/b;return a}else{throw (new SVGException(SVGException.SVG_MATRIX_NOT_INVERTABLE))}},translate:function(b,d){var a=new SVGMatrix();a.e=b;a.f=d;var c=this.multiply(a);a=null;return c},scale:function(c){var a=new SVGMatrix();a.a=c;a.d=c;var b=this.multiply(a);a=null;return b},scaleNonUniform:function(b,d){var a=new SVGMatrix();a.a=b;a.d=d;var c=this.multiply(a);a=null;return c},rotate:function(d){var b=new SVGMatrix(),a=d/180*Math.PI;b.a=Math.cos(a);b.b=Math.sin(a);b.c=-b.b;b.d=b.a;var c=this.multiply(b);b=a=null;return c},rotateFromVector:function(c,e){if((c===0)||(e===0)||!isFinite(c)||!isFinite(e)){throw (new SVGException(SVGException.SVG_INVALID_VALUE_ERR))}var b=new SVGMatrix(),a=Math.atan2(e,c);b.a=Math.cos(a);b.b=Math.sin(a);b.c=-b.b;b.d=b.a;var d=this.multiply(b);b=a=null;return d},flipX:function(){var a=new SVGMatrix();a.a=-a.a;var b=this.multiply(a);a=null;return b},flipY:function(){var a=new SVGMatrix();a.d=-a.d;var b=this.multiply(a);a=null;return b},skewX:function(d){var b=new SVGMatrix(),a=d/180*Math.PI;b.c=Math.tan(a);var c=this.multiply(b);b=null;return c},skewY:function(d){var b=new SVGMatrix(),a=d/180*Math.PI;b.b=Math.tan(a);var c=this.multiply(b);b=null;return c},_determinant:function(){return(this.a*this.d-this.b*this.c)}};function SVGTransform(){this.matrix=new SVGMatrix();return this}SVGTransform.SVG_TRANSFORM_UNKNOWN=0;SVGTransform.SVG_TRANSFORM_MATRIX=1;SVGTransform.SVG_TRANSFORM_TRANSLATE=2;SVGTransform.SVG_TRANSFORM_SCALE=3;SVGTransform.SVG_TRANSFORM_ROTATE=4;SVGTransform.SVG_TRANSFORM_SKEWX=5;SVGTransform.SVG_TRANSFORM_SKEWY=6;SVGTransform.prototype={_matrix:(new SVGMatrix()),type:SVGTransform.SVG_TRANSFORM_UNKNOWN,angle:0,setMatrix:function(a){this.type=SVGTransform.SVG_TRANSFORM_MATRIX;this.matrix=this._matrix.multiply(a)},setTranslate:function(b,a){this.type=SVGTransform.SVG_TRANSFORM_TRANSLATE;this.matrix=this._matrix.translate(b,a)},setScale:function(b,a){this.type=SVGTransform.SVG_TRANSFORM_SCALE;this.matrix=this._matrix.scaleNonUniform(b,a)},setRotate:function(b,a,c){this.angle=b;this.type=SVGTransform.SVG_TRANSFORM_ROTATE;this.matrix=this._matrix.rotate(b);this.matrix.e=(1-this.matrix.a)*a-this.matrix.c*c;this.matrix.f=-this.matrix.b*a+(1-this.matrix.d)*c},setSkewX:function(a){this.angle=a;this.type=SVGTransform.SVG_TRANSFORM_SKEWX;this.matrix=this._matrix.skewX(a)},setSkewY:function(a){this.angle=a;this.type=SVGTransform.SVG_TRANSFORM_SKEWY;this.matrix=this._matrix.skewY(a)}};function SVGTransformList(){return this}for(var prop in SVGStringList.prototype){SVGTransformList.prototype[prop]=SVGStringList.prototype[prop]}SVGTransformList.prototype.createSVGTransformFromMatrix=function(a){var b=new SVGTransform();b.setMatrix(a);return b};SVGTransformList.prototype.consolidate=function(){if(this.numberOfItems===0){return null}else{var d=this.getItem(0),b=d.matrix;for(var c=1,a=this.numberOfItems;c<a;++c){b=b.multiply(this.getItem(c).matrix)}d.setMatrix(b);this.initialize(d);return d}};function SVGAnimatedTransformList(){this.animVal=this.baseVal=new SVGTransformList();return this}function SVGPreserveAspectRatio(){this.align=SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMID;this.meetOrSlice=SVGPreserveAspectRatio.SVG_MEETORSLICE_MEET;return this}SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_UNKNOWN=0;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_NONE=1;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMIN=2;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMIN=3;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMIN=4;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMID=5;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMID=6;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMID=7;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMAX=8;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMAX=9;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMAX=10;SVGPreserveAspectRatio.SVG_MEETORSLICE_UNKNOWN=0;SVGPreserveAspectRatio.SVG_MEETORSLICE_MEET=1;SVGPreserveAspectRatio.SVG_MEETORSLICE_SLICE=2;function SVGAnimatedPreserveAspectRatio(){this.animVal=this.baseVal=new SVGPreserveAspectRatio();return this}function SVGPathSeg(){this.pathSegType=SVGPathSeg.PATHSEG_UNKNOWN;this.pathSegTypeAsLetter=null;return this}SVGPathSeg.PATHSEG_UNKNOWN=0;SVGPathSeg.PATHSEG_CLOSEPATH=1;SVGPathSeg.PATHSEG_MOVETO_ABS=2;SVGPathSeg.PATHSEG_MOVETO_REL=3;SVGPathSeg.PATHSEG_LINETO_ABS=4;SVGPathSeg.PATHSEG_LINETO_REL=5;SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS=6;SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL=7;SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS=8;SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL=9;SVGPathSeg.PATHSEG_ARC_ABS=10;SVGPathSeg.PATHSEG_ARC_REL=11;SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS=12;SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL=13;SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS=14;SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL=15;SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS=16;SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL=17;SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS=18;SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL=19;function SVGPathSegClosePath(){return this}SVGPathSegClosePath.prototype={pathSegType:SVGPathSeg.PATHSEG_CLOSEPATH,pathSegTypeAsLetter:"z"};function SVGPathSegMovetoAbs(){this.x;this.y;return this}SVGPathSegMovetoAbs.prototype={pathSegType:SVGPathSeg.PATHSEG_MOVETO_ABS,pathSegTypeAsLetter:"M"};function SVGPathSegMovetoRel(){this.x;this.y;return this}SVGPathSegMovetoRel.prototype={pathSegType:SVGPathSeg.PATHSEG_MOVETO_REL,pathSegTypeAsLetter:"m"};function SVGPathSegLinetoAbs(){this.x;this.y;return this}SVGPathSegLinetoAbs.prototype={pathSegType:SVGPathSeg.PATHSEG_LINETO_ABS,pathSegTypeAsLetter:"L"};function SVGPathSegLinetoRel(){this.x;this.y;return this}SVGPathSegLinetoRel.prototype={pathSegType:SVGPathSeg.PATHSEG_LINETO_REL,pathSegTypeAsLetter:"l"};function SVGPathSegCurvetoCubicAbs(){this.x;this.y;this.x1;this.y1;this.x2;this.y2;return this}SVGPathSegCurvetoCubicAbs.prototype={pathSegType:SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS,pathSegTypeAsLetter:"C"};function SVGPathSegCurvetoCubicRel(){this.x;this.y;this.x1;this.y1;this.x2;this.y2;return this}SVGPathSegCurvetoCubicRel.prototype={pathSegType:SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL,pathSegTypeAsLetter:"c"};function SVGPathSegCurvetoQuadraticAbs(){this.x;this.y;this.x1;this.y1;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS;this.pathSegTypeAsLetter="Q";return this}function SVGPathSegCurvetoQuadraticRel(){this.x;this.y;this.x1;this.y1;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL;this.pathSegTypeAsLetter="q";return this}function SVGPathSegArcAbs(){this.x;this.y;this.r1;this.r2;this.angle;return this}SVGPathSegArcAbs.prototype={largeArcFlag:true,sweepFlag:true,pathSegType:SVGPathSeg.PATHSEG_ARC_ABS,pathSegTypeAsLetter:"A"};function SVGPathSegArcRel(){this.x;this.y;this.r1;this.r2;this.angle;return this}SVGPathSegArcRel.prototype={largeArcFlag:true,sweepFlag:true,pathSegType:SVGPathSeg.PATHSEG_ARC_REL,pathSegTypeAsLetter:"a"};function SVGPathSegLinetoHorizontalAbs(){this.x;this.pathSegType=SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS;this.pathSegTypeAsLetter="H";return this}function SVGPathSegLinetoHorizontalRel(){this.x;this.pathSegType=SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL;this.pathSegTypeAsLetter="h";return this}function SVGPathSegLinetoVerticalAbs(){this.y;this.pathSegType=SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS;this.pathSegTypeAsLetter="V";return this}function SVGPathSegLinetoVerticalRel(){this.y;this.pathSegType=SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL;this.pathSegTypeAsLetter="v";return this}function SVGPathSegCurvetoCubicSmoothAbs(){this.x;this.y;this.x2;this.y2;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS;this.pathSegTypeAsLetter="S";return this}function SVGPathSegCurvetoCubicSmoothRel(){this.x;this.y;this.x2;this.y2;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL;this.pathSegTypeAsLetter="s";return this}function SVGPathSegCurvetoQuadraticSmoothAbs(){this.x;this.y;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS;this.pathSegTypeAsLetter="T";return this}function SVGPathSegCurvetoQuadraticSmoothRel(){this.x;this.y;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL;this.pathSegTypeAsLetter="t";return this}function SVGPathSegList(){return this}for(var prop in SVGStringList.prototype){SVGPathSegList.prototype[prop]=SVGStringList.prototype[prop]}(function(d,a,c){NAIBU._setPaint=function(M,K){var P=M.ownerDocument,e=M._tar;if(!e){return}var O=P.defaultView.getComputedStyle(M,"");var I=O.getPropertyCSSValue("fill"),s=O.getPropertyCSSValue("stroke");if(I.paintType===1||I.paintType===102){if(I.paintType===102){O.setProperty("color",O.getPropertyValue("color"))}if(!!M._fillElement){var F=M._fillElement;var z=e.getElementsByTagName("fill");if(z.length>0){e.removeChild(z[0])}z=null}else{var F=d.createElement("v:fill")}var D=I.rgbColor,u=1;F.setAttribute("color","rgb("+D.red.getFloatValue(u)+","+D.green.getFloatValue(u)+","+D.blue.getFloatValue(u)+")");var J=+(O.getPropertyValue("fill-opacity"))*O._list._opacity;if(J<1){F.setAttribute("opacity",J+"")}if(!!!M._fillElement){e.appendChild(F);M._fillElement=F}else{e.appendChild(F)}F=D=u=J=null}else{if(I.uri){var A=P.getElementById(I.uri);if(A){var r=P.createEvent("MutationEvents");r.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);r._tar=!!M._fillElement?M._fillElement:d.createElement("v:fill");r._style=O,r._ttar=M;A.dispatchEvent(r);if(A.localName!=="radialGradient"&&!!!M._fillElement){e.appendChild(r._tar);M._fillElement=r._tar}A=r=null}}else{e.filled="false"}}if(s.paintType===1||s.paintType===102){if(s.paintType===102){O.setProperty("color",O.getPropertyValue("color"))}if(!!M._strokeElement){var f=M._strokeElement;var o=e.getElementsByTagName("stroke");if(o.length>0){e.removeChild(o[0])}o=null}else{var f=d.createElement("v:stroke")}var G=O.getPropertyCSSValue("stroke-width"),v=P.documentElement.viewport.width,N=P.documentElement.viewport.height;G._percent=c.sqrt((v*v+N*N)/2);var C=G.getFloatValue(CSSPrimitiveValue.CSS_NUMBER)*c.sqrt(c.abs(K._determinant()));f.setAttribute("weight",C+"px");G=v=N=null;if(!s.uri){var D=s.rgbColor,u=1;f.setAttribute("color","rgb("+D.red.getFloatValue(u)+","+D.green.getFloatValue(u)+","+D.blue.getFloatValue(u)+")");var k=+(O.getPropertyValue("stroke-opacity"))*(+(O.getPropertyValue("opacity")));if(C<1){k*=C}if(k<1){f.setAttribute("opacity",k+"")}D=u=k=null}f.setAttribute("miterlimit",O.getPropertyValue("stroke-miterlimit"));f.setAttribute("joinstyle",O.getPropertyValue("stroke-linejoin"));if(O.getPropertyValue("stroke-linecap")==="butt"){f.setAttribute("endcap","flat")}else{f.setAttribute("endcap",O.getPropertyValue("stroke-linecap"))}var j=O.getPropertyValue("stroke-dasharray");if(j!=="none"){if(j.indexOf(",")>0){var E=j.split(",");for(var L=0,g=E.length;L<g;++L){E[L]=c.ceil(+(E[L])/parseFloat(O.getPropertyValue("stroke-width")))}var q=E.join(" ");if(E.length%2===1){q+=" "+q}}f.setAttribute("dashstyle",q);j=E=null}if(!!!M._strokeElement){e.appendChild(f);M._strokeElement=f}else{e.appendChild(f)}f=j=null}else{e.stroked="false"}var l=O.getPropertyValue("cursor");if(l!=="auto"&&l!==""){e.style.cursor=l}var B=O.getPropertyValue("visibility");if(B!=="visiblee"){e.style.visibility=B}var H=O.getPropertyValue("display");if(H==="none"){e.style.display="none"}else{if(H!=="inline-block"){e.style.display="inline-block"}}P=e=I=s=O=l=M=K=B=H=null};function b(){SVGElement.apply(this);this._tar=d.createElement("v:shape");this.pathSegList=new SVGPathSegList();this.animatedPathSegList=this.pathSegList;this.normalizedPathSegList=new SVGPathSegList();this.animatedNormalizedPathSegList=this.normalizedPathSegList;this.pathLength=new SVGAnimatedNumber();this.addEventListener("DOMAttrModified",function(H){var M=H.target;if(H.attrName==="d"&&H.newValue!==""){var A=M.normalizedPathSegList,B=M.pathSegList,G=[];if(A.numberOfItems>0){A.clear();B.clear()}var v=M._com,r=v.isSp,U=H.newValue.replace(v.isRa," -").replace(v.isRb," ").replace(v.isRc,",$1 ").replace(v.isRd,",$1 1").replace(v.isRe,"").split(",");for(var N=0,T=U.length;N<T;++N){G[N]=U[N].match(r);for(var L=1,E=G[N].length;L<E;++L){G[N][L]=+(G[N][L])}}r=U=null;var z=v._isZ,I=v._isM,Q=v._isC,J=v._isL;for(var N=0,o=G.length;N<o;++N){var P=G[N],F;for(var L=1,R=P[0],E=P.length;L<E;++L){if(I[R]){F=M.createSVGPathSegMovetoAbs(P[L],P[L+1]);++L}else{if(R==="m"){F=M.createSVGPathSegMovetoRel(P[L],P[L+1]);++L}else{if(J[R]){F=M.createSVGPathSegLinetoAbs(P[L],P[L+1]);++L}else{if(R==="l"){F=M.createSVGPathSegLinetoRel(P[L],P[L+1]);++L}else{if(Q[R]){F=M.createSVGPathSegCurvetoCubicAbs(P[L+4],P[L+5],P[L],P[L+1],P[L+2],P[L+3]);L+=5}else{if(R==="c"){F=M.createSVGPathSegCurvetoCubicRel(P[L+4],P[L+5],P[L],P[L+1],P[L+2],P[L+3]);L+=5}else{if(R==="Q"){F=M.createSVGPathSegCurvetoQuadraticAbs(P[L+2],P[L+3],P[L],P[L+1]);L+=3}else{if(R==="q"){F=M.createSVGPathSegCurvetoQuadraticRel(P[L+2],P[L+3],P[L],P[L+1]);L+=3}else{if(R==="A"){F=M.createSVGPathSegArcAbs(P[L+5],P[L+6],P[L],P[L+1],P[L+2],P[L+3],P[L+4]);L+=6}else{if(R==="a"){F=M.createSVGPathSegArcRel(P[L+5],P[L+6],P[L],P[L+1],P[L+2],P[L+3],P[L+4]);L+=6}else{if(z[R]){F=M.createSVGPathSegClosePath()}else{if(R==="S"){F=M.createSVGPathSegCurvetoCubicSmoothAbs(P[L+2],P[L+3],P[L],P[L+1]);L+=3}else{if(R==="s"){F=M.createSVGPathSegCurvetoCubicSmoothRel(P[L+2],P[L+3],P[L],P[L+1]);L+=3}else{if(R==="T"){F=M.createSVGPathSegCurvetoQuadraticSmoothAbs(P[L],P[L+1]);++L}else{if(R==="t"){F=M.createSVGPathSegCurvetoQuadraticSmoothRel(P[L],P[L+1]);++L}else{if(R==="H"){F=M.createSVGPathSegLinetoHorizontalAbs(P[L])}else{if(R==="h"){F=M.createSVGPathSegLinetoHorizontalRel(P[L])}else{if(R==="V"){F=M.createSVGPathSegLinetoVerticalAbs(P[L])}else{if(R==="v"){F=M.createSVGPathSegLinetoVerticalRel(P[L])}else{F=new SVGPathSeg()}}}}}}}}}}}}}}}}}}}B.appendItem(F)}}G=null;var l=0,g=0,C=0,S=0,k=0,f=0;for(var L=0,K=B.numberOfItems;L<K;++L){var u=B.getItem(L),e=u.pathSegType,R=u.pathSegTypeAsLetter;if(e===SVGPathSeg.PATHSEG_UNKNOWN){}else{var t=l,q=g;if(e%2===1){l+=u.x;g+=u.y}else{l=u.x;g=u.y}if(I[R]){if(L!==0){var w=B.getItem(L-1);if(w.pathSegTypeAsLetter==="M"){A.appendItem(M.createSVGPathSegLinetoAbs(l,g));continue}}k=l;f=g;A.appendItem(u)}else{if(R==="m"){if(L!==0){var w=B.getItem(L-1);if(w.pathSegTypeAsLetter==="m"){A.appendItem(M.createSVGPathSegLinetoAbs(l,g));continue}}k=l;f=g;A.appendItem(M.createSVGPathSegMovetoAbs(l,g))}else{if(J[R]){A.appendItem(u)}else{if(R==="l"){A.appendItem(M.createSVGPathSegLinetoAbs(l,g))}else{if(Q[R]){A.appendItem(u)}else{if(R==="c"){A.appendItem(M.createSVGPathSegCurvetoCubicAbs(l,g,u.x1+t,u.y1+q,u.x2+t,u.y2+q))}else{if(z[R]){l=k;g=f;A.appendItem(u)}else{if(R==="Q"){C=2*l-u.x1;S=2*g-u.y1;A.appendItem(M.createSVGPathSegCurvetoCubicAbs(l,g,(t+2*u.x1)/3,(q+2*u.y1)/3,(2*u.x1+l)/3,(2*u.y1+g)/3))}else{if(R==="q"){var O=u.x1+t,h=u.y1+q;C=2*l-O;S=2*g-h;A.appendItem(M.createSVGPathSegCurvetoCubicAbs(l,g,(t+2*O)/3,(q+2*h)/3,(2*O+l)/3,(2*h+g)/3));O=h=null}else{if(R==="A"||R==="a"){(function(V,aq,ap,au,ar,aA,at){if(V.r1===0||V.r2===0){return}var aF=V.sweepFlag,aJ=V.angle,ai=c.abs(V.r1),ah=c.abs(V.r2),ao=(au-aq)/2,an=(ar-ap)/2,D=c.cos(aJ*c.PI/180),ax=c.sin(aJ*c.PI/180),aw=D*ao+ax*an,ag=-1*ax*ao+D*an,af=aw*aw,aa=ag*ag,av=ai*ai,ad=ah*ah,aN=af/av+aa/ad,aG;if(aN>1){ai=c.sqrt(aN)*ai;ah=c.sqrt(aN)*ah;aG=0}else{var ac=1;if(V.largeArcFlag===aF){ac=-1}aG=ac*c.sqrt((av*ad-av*aa-ad*af)/(av*aa+ad*af))}var al=aG*ai*ag/ah,s=-1*aG*ah*aw/ai,aI=D*al-ax*s+(au+aq)/2,aH=ax*al+D*s+(ar+ap)/2,X=c.atan2((ag-s)/ah,(aw-al)/ai)-c.atan2(0,1),aK=(X>=0)?X:2*c.PI+X,X=c.atan2((-ag-s)/ah,(-aw-al)/ai)-c.atan2((ag-s)/ah,(aw-al)/ai),ab=(X>=0)?X:2*c.PI+X;if(!aF&&ab>0){ab-=2*c.PI}else{if(aF&&ab<0){ab+=2*c.PI}}var Y=ab*2/c.PI,ay=c.ceil(Y<0?-1*Y:Y),az=ab/ay,aD=8/3*c.sin(az/4)*c.sin(az/4)/c.sin(az/2),aC=D*ai,aB=D*ah,j=ax*ai,i=ax*ah,am=c.cos(aK),ae=c.sin(aK),ak=au-aD*(aC*ae+i*am),aM=ar-aD*(j*ae-aB*am);for(var aE=0;aE<ay;++aE){aK+=az;am=c.cos(aK);ae=c.sin(aK);var aj=aC*am-i*ae+aI,aL=j*am+aB*ae+aH,Z=-aD*(aC*ae+i*am),W=-aD*(j*ae-aB*am);at.appendItem(aA.createSVGPathSegCurvetoCubicAbs(aj,aL,ak,aM,aj-Z,aL-W));ak=aj+Z;aM=aL+W}})(u,l,g,t,q,M,A)}else{if(R==="S"){if(L!==0){var w=A.getItem(A.numberOfItems-1);if(w.pathSegTypeAsLetter==="C"){var O=2*w.x-w.x2,h=2*w.y-w.y2}else{var O=t,h=q}}else{var O=t,h=q}A.appendItem(M.createSVGPathSegCurvetoCubicAbs(l,g,O,h,u.x2,u.y2));O=h=null}else{if(R==="s"){if(L!==0){var w=A.getItem(A.numberOfItems-1);if(w.pathSegTypeAsLetter==="C"){var O=2*w.x-w.x2,h=2*w.y-w.y2}else{var O=t,h=q}}else{var O=t,h=q}A.appendItem(M.createSVGPathSegCurvetoCubicAbs(l,g,O,h,u.x2+t,u.y2+q));O=h=null}else{if(R==="T"||R==="t"){if(L!==0){var w=B.getItem(L-1);if("QqTt".indexOf(w.pathSegTypeAsLetter)>-1){}else{C=t,S=q}}else{C=t,S=q}A.appendItem(M.createSVGPathSegCurvetoCubicAbs(l,g,(t+2*C)/3,(q+2*S)/3,(2*C+l)/3,(2*S+g)/3));C=2*l-C;S=2*g-S;xx1=yy1=null}else{if(R==="H"||R==="h"){A.appendItem(M.createSVGPathSegLinetoAbs(l,q));g=q}else{if(R==="V"||R==="v"){A.appendItem(M.createSVGPathSegLinetoAbs(t,g));l=t}}}}}}}}}}}}}}}}}}H=M=v=l=g=C=S=k=f=A=B=u=R=e=z=I=J=Q=F=null},false);this.addEventListener("DOMNodeInserted",function(f){var e=f.target;if(f.eventPhase===3){return}var h=e.nextSibling,i=e.parentNode,g=true;if(h&&h._tar&&i._tar&&(h._tar.parentNode===i._tar)){i._tar.insertBefore(e._tar,h._tar)}else{if(h&&!h._tar&&i._tar){while(h){if(h._tar&&(h._tar.parentNode===i._tar)){i._tar.insertBefore(e._tar,h._tar);g=false}h=h.nextSibling}if(g){i._tar.appendChild(e._tar)}}else{if(!h&&i._tar){i._tar.appendChild(e._tar)}}}h=i=g=null;e.addEventListener("DOMNodeInsertedIntoDocument",function(v){var C=v.target,B=C.getScreenCTM(),r=C.normalizedPathSegList,A=a,H=[],k=B.a,j=B.b,M=B.c,L=B.d,K=B.e,J=B.f,l=C._com._nameCom,q=C._com._isZ,F=C._com._isC;for(var D=0,z=r.numberOfItems;D<z;++D){var o=r[D],G=o.pathSegTypeAsLetter,u=l[G];if(F[G]){u+=([A(k*o.x1+M*o.y1+K,10),A(j*o.x1+L*o.y1+J,10),A(k*o.x2+M*o.y2+K,10),A(j*o.x2+L*o.y2+J,10),A(k*o.x+M*o.y+K,10),A(j*o.x+L*o.y+J,10)]).join(" ")}else{if(!q[G]){u+=A(k*o.x+M*o.y+K,10)+" "+A(j*o.x+L*o.y+J,10)}}H[D]=u}var I=C.ownerDocument.documentElement,s=I.width.baseVal.value,E=I.height.baseVal.value;H[H.length]=" e";C._tar.path=H.join(" ");C._tar.coordsize=s+" "+E;NAIBU._setPaint(C,B);delete C._cacheMatrix,C._currentStyle;v=C=H=u=s=E=B=r=x=y=A=k=j=M=L=K=J=I=q=F=D=z=G=o=l=null},false);f=e=null},false);return this}b.constructor=SVGElement;b.prototype=new SVGElement();b.prototype._com={_nameCom:{z:" x ",Z:" x ",C:"c",L:"l",M:"m"},_isZ:{z:1,Z:1},_isC:{C:1},_isL:{L:1},_isM:{M:1},isRa:/\-/g,isRb:/,/g,isRc:/([a-yA-Y])/g,isRd:/([zZ])/g,isRe:/,/,isSp:/\S+/g};b.prototype.getTotalLength=function(){var k=0,g=this.normalizedPathSegList;for(var j=1,l=g.numberOfItems,h=null;j<l;++j){var f=g.getItem(j);if(f.pathSegType===SVGPathSeg.PATHSEG_LINETO_ABS){var o=g.getItem(j-1);k+=c.sqrt(c.pow((f.x-o.x),2)+c.pow((f.y-o.y),2))}else{if(f.pathSegType===SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS){var o=g.getItem(j-1),e=0;e+=c.sqrt(c.pow((f.x1-o.x),2)+c.pow((f.y1-o.y),2));e+=c.sqrt(c.pow((f.x2-f.x1),2)+c.pow((f.y2-f.y1),2));e+=c.sqrt(c.pow((f.x2-f.x1),2)+c.pow((f.y2-f.y1),2));e+=c.sqrt(c.pow((f.x-o.x),2)+c.pow((f.y-o.y),2));k+=e/2}else{if(f.pathSegType===SVGPathSeg.PATHSEG_CLOSEPATH){var o=g.getItem(j-1),h=g.getItem(0);k+=c.sqrt(c.pow((o.x-h.x),2)+c.pow((o.y-h.y),2))}}}}this.pathLength.baseVal=k;return k};b.prototype.getPointAtLength=function(h){var i=this.getPathSegAtLength(h),o=0,l=0,f=this.normalizedPathSegList,j=f.getItem(i);var u=this.ownerDocument.documentElement.createSVGPoint();if((i-1)<=0){u.x=j.x;u.y=j.y;return u}var e=f.getItem(i-1);if(j.pathSegType===SVGPathSeg.PATHSEG_LINETO_ABS){var k=c.sqrt(c.pow((j.x-e.x),2)+c.pow((j.y-e.y),2));var r=(k+this._dis)/k;u.x=e.x+r*(j.x-e.x);u.y=e.y+r*(j.y-e.y)}else{if(j.pathSegType===SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS){var q=0;q+=c.sqrt(c.pow((j.x1-e.x),2)+c.pow((j.y1-e.y),2));q+=c.sqrt(c.pow((j.x2-j.x1),2)+c.pow((j.y2-j.y1),2));q+=c.sqrt(c.pow((j.x2-j.x1),2)+c.pow((j.y2-j.y1),2));q+=c.sqrt(c.pow((j.x-e.x),2)+c.pow((j.y-e.y),2));var k=q/2;var r=(k+this._dis)/k;u.x=(3*j.x1+j.x-3*j.x2-e.x)*c.pow(r,3)+3*(e.x-2*j.x1+j.x2)*c.pow(r,2)+3*(j.x1-e.x)*r+e.x;u.y=(3*j.y1+j.y-3*j.y2-e.y)*c.pow(r,3)+3*(e.y-2*j.y1+j.y2)*c.pow(r,2)+3*(j.y1-e.y)*r+e.y}else{if(j.pathSegType===SVGPathSeg.MOVETO_ABS){u.x=j.x;u.y=j.y}else{if(j.pathSegType===SVGPathSeg.PATHSEG_CLOSEPATH){var g=f.getItem(0),k=c.sqrt(c.pow((j.x-mx.x),2)+c.pow((j.y-g.y),2));var r=(k+this._dis)/k;u.x=g.x+r*(j.x-g.x);u.y=g.y+r*(j.y-g.y)}}}}return u};b.prototype.getPathSegAtLength=function(o){var g=this.normalizedPathSegList;for(var j=0,k=g.numberOfItems,h=null;j<k;++j){var f=g.getItem(j);if(f.pathSegType===SVGPathSeg.PATHSEG_LINETO_ABS){var l=g.getItem(j-1);o-=c.sqrt(c.pow((f.x-l.x),2)+c.pow((f.y-l.y),2))}else{if(f.pathSegType===SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS){var l=g.getItem(j-1),e=0;e+=c.sqrt(c.pow((f.x1-l.x),2)+c.pow((f.y1-l.y),2));e+=c.sqrt(c.pow((f.x2-f.x1),2)+c.pow((f.y2-f.y1),2));e+=c.sqrt(c.pow((f.x2-f.x1),2)+c.pow((f.y2-f.y1),2));e+=c.sqrt(c.pow((f.x-l.x),2)+c.pow((f.y-l.y),2));o-=e/2;e=null}else{if(f.pathSegType===SVGPathSeg.PATHSEG_CLOSEPATH){var l=g.getItem(j-1),h=g.getItem(0);o-=c.sqrt(c.pow((l.x-h.x),2)+c.pow((l.y-h.y),2))}}}if(o<=0){this._dis=o;o=null;return j}}return(g.numberOfItems-1)};b.prototype.createSVGPathSegClosePath=function(){var e=SVGPathSegClosePath;return(new e())};b.prototype.createSVGPathSegMovetoAbs=function(e,h){var g=SVGPathSegMovetoAbs,f=new g();f.x=e;f.y=h;return f};b.prototype.createSVGPathSegMovetoRel=function(e,g){var f=new SVGPathSegMovetoRel();f.x=e;f.y=g;return f};b.prototype.createSVGPathSegLinetoAbs=function(e,g){var f=new SVGPathSegLinetoAbs();f.x=e;f.y=g;return f};b.prototype.createSVGPathSegLinetoRel=function(e,g){var f=new SVGPathSegLinetoRel();f.x=e;f.y=g;return f};b.prototype.createSVGPathSegCurvetoCubicAbs=function(f,l,h,k,g,i){var e=SVGPathSegCurvetoCubicAbs,j=new e();j.x=f;j.y=l;j.x1=h;j.y1=k;j.x2=g;j.y2=i;return j};b.prototype.createSVGPathSegCurvetoCubicRel=function(e,k,g,j,f,h){var i=new SVGPathSegCurvetoCubicRel();i.x=e;i.y=k;i.x1=g;i.y1=j;i.x2=f;i.y2=h;return i};b.prototype.createSVGPathSegCurvetoQuadraticAbs=function(e,i,f,h){var g=new SVGPathSegCurvetoQuadraticAbs();g.x=e;g.y=i;g.x1=f;g.y1=h;return g};b.prototype.createSVGPathSegCurvetoQuadraticRel=function(e,i,f,h){var g=new SVGPathSegCurvetoQuadraticRel();g.x=e;g.y=i;g.x1=f;g.y1=h;return g};b.prototype.createSVGPathSegArcAbs=function(e,l,g,f,k,j,i){var h=new SVGPathSegArcAbs();h.x=e;h.y=l;h.r1=g;h.r2=f;h.angle=k;h.largeArcFlag=j;h.sweepFlag=i;return h};b.prototype.createSVGPathSegArcRel=function(e,l,g,f,k,j,i){var h=new SVGPathSegArcRel();h.x=e;h.y=l;h.r1=g;h.r2=f;h.angle=k;h.largeArcFlag=j;h.sweepFlag=i;return h};b.prototype.createSVGPathSegLinetoHorizontalAbs=function(e){var f=new SVGPathSegLinetoHorizontalAbs();f.x=e;f.y=0;return f};b.prototype.createSVGPathSegLinetoHorizontalRel=function(e){var f=new SVGPathSegLinetoHorizontalRel();f.x=e;f.y=0;return f};b.prototype.createSVGPathSegLinetoVerticalAbs=function(f){var e=new SVGPathSegLinetoVerticalAbs();e.x=0;e.y=f;return e};b.prototype.createSVGPathSegLinetoVerticalRel=function(f){var e=new SVGPathSegLinetoVerticalRel();e.x=0;e.y=f;return e};b.prototype.createSVGPathSegCurvetoCubicSmoothAbs=function(e,i,f,g){var h=new SVGPathSegCurvetoCubicSmoothAbs();h.x=e;h.y=i;h.x2=f;h.y2=g;return h};b.prototype.createSVGPathSegCurvetoCubicSmoothRel=function(e,i,f,g){var h=new SVGPathSegCurvetoCubicSmoothRel();h.x=e;h.y=i;h.x2=f;h.y2=g;return h};b.prototype.createSVGPathSegCurvetoQuadraticSmoothAbs=function(e,g){var f=new SVGPathSegCurvetoQuadraticSmoothAbs();f.x=e;f.y=g;return f};b.prototype.createSVGPathSegCurvetoQuadraticSmoothRel=function(e,g){var f=new SVGPathSegCurvetoQuadraticSmoothRel();f.x=e;f.y=g;return f};NAIBU.SVGPathElement=b})(document,parseInt,Math);function SVGRectElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.rx=new SVGAnimatedLength();this.ry=new SVGAnimatedLength();this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===3){return}var d=a.nextSibling,e=a.parentNode,c=true;if(d&&d._tar&&e._tar&&(d._tar.parentNode===e._tar)){e._tar.insertBefore(a._tar,d._tar)}else{if(d&&!d._tar&&e._tar){while(d){if(d._tar&&(d._tar.parentNode===e._tar)){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}}else{if(!d&&e._tar){e._tar.appendChild(a._tar)}}}d=e=c=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(C){var I=C.target,K=I.ownerDocument.defaultView.getComputedStyle(I,"");var k=parseFloat(K.getPropertyValue("font-size"));I.x.baseVal._emToUnit(k);I.y.baseVal._emToUnit(k);I.width.baseVal._emToUnit(k);I.height.baseVal._emToUnit(k);var o=I.getAttributeNS(null,"rx"),l=I.getAttributeNS(null,"ry");var v=I.x.baseVal.value,u=I.y.baseVal.value,s=v+I.width.baseVal.value,U=u+I.height.baseVal.value;var L;if((o||l)&&(o!=="0")&&(l!=="0")){I.rx.baseVal._emToUnit(k);I.ry.baseVal._emToUnit(k);var g=I.rx.baseVal,f=I.ry.baseVal;g.value=o?g.value:f.value;f.value=l?f.value:g.value;var Q=I.width.baseVal.value,j=I.height.baseVal.value;if(g.value>Q/2){g.value=Q/2}if(f.value>j/2){f.value=j/2}var t=g.value,G=f.value;var r=t*0.55228,q=G*0.55228;var T=s-t,P=v+t,O=u+G,N=U-G;L=["m",P,u,"l",T,u,"c",T+r,u,s,O-q,s,O,"l",s,N,"c",s,N+q,T+r,U,T,U,"l",P,U,"c",P-r,U,v,N+q,v,N,"l",v,O,"c",v,O-q,P-r,u,P,u]}else{L=["m",v,u,"l",v,U,s,U,s,u,"x e"]}var B=I.ownerDocument.documentElement,S=I.getScreenCTM();for(var H=0,F=L.length;H<F;){if(isNaN(L[H])){++H;continue}var E=B.createSVGPoint();E.x=L[H];E.y=L[H+1];var D=E.matrixTransform(S);L[H]=D.x;++H;L[H]=D.y;++H;E=D=null}var M=L.join(" ");var A=I._tar,R=I.ownerDocument.documentElement;var z=R.width.baseVal.value,J=R.height.baseVal.value;A.path=M;A.coordsize=z+" "+J;NAIBU._setPaint(I,S);delete I._cacheMatrix,I._currentStyle;C=I=K=L=M=A=R=k=null},false);b=a=null},false);return this}SVGRectElement.constructor=SVGElement;SVGRectElement.prototype=new SVGElement();function SVGCircleElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.cx=new SVGAnimatedLength();this.cy=new SVGAnimatedLength();this.r=new SVGAnimatedLength();this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===3){return}var d=a.nextSibling,e=a.parentNode,c=true;if(d&&d._tar&&e._tar&&(d._tar.parentNode===e._tar)){e._tar.insertBefore(a._tar,d._tar)}else{if(d&&!d._tar&&e._tar){while(d){if(d._tar&&(d._tar.parentNode===e._tar)){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}}else{if(!d&&e._tar){e._tar.appendChild(a._tar)}}}d=e=c=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(v){var D=v.target,G=D.ownerDocument.defaultView.getComputedStyle(D,"");var g=parseFloat(G.getPropertyValue("font-size"));D.cx.baseVal._emToUnit(g);D.cy.baseVal._emToUnit(g);D.r.baseVal._emToUnit(g);var j=D.cx.baseVal.value,f=D.cy.baseVal.value,l=ry=D.r.baseVal.value;var z=f-ry,k=j-l,r=f+ry,J=j+l;var q=l*0.55228,o=ry*0.55228;var H=["m",j,z,"c",j-q,z,k,f-o,k,f,k,f+o,j-q,r,j,r,j+q,r,J,f+o,J,f,J,f-o,j+q,z,j,z,"x e"];var u=D.ownerDocument.documentElement,L=D.getScreenCTM();for(var E=0,C=H.length;E<C;){if(isNaN(H[E])){++E;continue}var B=u.createSVGPoint();B.x=H[E];B.y=H[E+1];var A=B.matrixTransform(L);H[E]=A.x;++E;H[E]=A.y;++E;B=A=null}var I=H.join(" ");var t=D._tar,K=D.ownerDocument.documentElement;var s=K.width.baseVal.value,F=K.height.baseVal.value;t.path=I;t.coordsize=s+" "+F;NAIBU._setPaint(D,L);delete D._cacheMatrix,D._currentStyle;v=D=H=G=g=I=t=null},false);b=a=null},false);return this}SVGCircleElement.constructor=SVGElement;SVGCircleElement.prototype=new SVGElement();function SVGEllipseElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.cx=new SVGAnimatedLength();this.cy=new SVGAnimatedLength();this.rx=new SVGAnimatedLength();this.ry=new SVGAnimatedLength();this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===3){return}var d=a.nextSibling,e=a.parentNode,c=true;if(d&&d._tar&&e._tar&&(d._tar.parentNode===e._tar)){e._tar.insertBefore(a._tar,d._tar)}else{if(d&&!d._tar&&e._tar){while(d){if(d._tar&&(d._tar.parentNode===e._tar)){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}}else{if(!d&&e._tar){e._tar.appendChild(a._tar)}}}d=e=c=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(z){var F=z.target,H=F.ownerDocument.defaultView.getComputedStyle(F,"");var g=parseFloat(H.getPropertyValue("font-size"));F.cx.baseVal._emToUnit(g);F.cy.baseVal._emToUnit(g);F.rx.baseVal._emToUnit(g);F.ry.baseVal._emToUnit(g);var j=F.cx.baseVal.value,f=F.cy.baseVal.value,o=F.rx.baseVal.value,l=F.ry.baseVal.value;var A=f-l,k=j-o,s=f+l,K=j+o;var r=o*0.55228,q=l*0.55228;var I=["m",j,A,"c",j-r,A,k,f-q,k,f,k,f+q,j-r,s,j,s,j+r,s,K,f+q,K,f,K,f-q,j+r,A,j,A,"x e"];var v=F.ownerDocument.documentElement,M=F.getScreenCTM();for(var E=0,D=I.length;E<D;){if(isNaN(I[E])){++E;continue}var C=v.createSVGPoint();C.x=I[E];C.y=I[E+1];var B=C.matrixTransform(M);I[E]=B.x;++E;I[E]=B.y;++E;C=B=null}var J=I.join(" ");var u=F._tar,L=F.ownerDocument.documentElement;var t=L.width.baseVal.value,G=L.height.baseVal.value;u.path=J;u.coordsize=t+" "+G;NAIBU._setPaint(F,M);delete F._cacheMatrix,F._currentStyle;z=u=F=H=g=J=I=M=t=G=null},false);b=a=null},false);return this}SVGEllipseElement.constructor=SVGElement;SVGEllipseElement.prototype=new SVGElement();function SVGLineElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.x1=new SVGAnimatedLength();this.y1=new SVGAnimatedLength();this.x2=new SVGAnimatedLength();this.y2=new SVGAnimatedLength();this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===3){return}var d=a.nextSibling,e=a.parentNode,c=true;if(d&&d._tar&&e._tar&&(d._tar.parentNode===e._tar)){e._tar.insertBefore(a._tar,d._tar)}else{if(d&&!d._tar&&e._tar){while(d){if(d._tar&&(d._tar.parentNode===e._tar)){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}}else{if(!d&&e._tar){e._tar.appendChild(a._tar)}}}d=e=c=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(r){var o=r.target,f=o.ownerDocument.defaultView.getComputedStyle(o,"");var u=parseFloat(f.getPropertyValue("font-size"));o.x1.baseVal._emToUnit(u);o.y1.baseVal._emToUnit(u);o.x2.baseVal._emToUnit(u);o.y2.baseVal._emToUnit(u);var j=o.ownerDocument.documentElement,k=o.getScreenCTM();var s="m ";var g=j.createSVGPoint();g.x=o.x1.baseVal.value;g.y=o.y1.baseVal.value;var i=g.matrixTransform(k);s+=i.x+" "+i.y+" l ";g.x=o.x2.baseVal.value;g.y=o.y2.baseVal.value;i=g.matrixTransform(k);s+=i.x+" "+i.y;g=i=null;var t=o._tar,q=j.width.baseVal.value,l=j.height.baseVal.value;t.path=s;t.coordsize=q+" "+l;NAIBU._setPaint(o,k);delete o._cacheMatrix,o._currentStyle;r=t=o=f=u=s=list=k=j=q=l=null},false);b=a=null},false);return this}SVGLineElement.constructor=SVGElement;SVGLineElement.prototype=new SVGElement();function SVGPolylineElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.animatedPoints=this.points=new SVGPointList();this.addEventListener("DOMAttrModified",function(b){var a=b.target;if(b.attrName==="points"){var h=a.points,e=a.ownerDocument.documentElement;var f=b.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/);for(var d=0,g,c=f.length;d<c;d+=2){if(isNaN(f[d])){--d;continue}g=e.createSVGPoint();g.x=parseFloat(f[d]);g.y=parseFloat(f[d+1]);h.appendItem(g)}}b=a=f=h=e=g=null},false);this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===3){return}var d=a.nextSibling,e=a.parentNode,c=true;if(d&&d._tar&&e._tar&&(d._tar.parentNode===e._tar)){e._tar.insertBefore(a._tar,d._tar)}else{if(d&&!d._tar&&e._tar){while(d){if(d._tar&&(d._tar.parentNode===e._tar)){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}}else{if(!d&&e._tar){e._tar.appendChild(a._tar)}}}d=e=c=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(v){var r=v.target,t=r.points;var l=r.getScreenCTM();for(var k=0,s=[],q=t.numberOfItems;k<q;++k){var f=t.getItem(k);var j=f.matrixTransform(l);s[2*k]=j.x;s[2*k+1]=j.y;f=j=null}s.splice(2,0,"l");var z="m"+s.join(" ")+"e";var A=r._tar,g=r.ownerDocument.documentElement;var u=g.width.baseVal.value,o=g.height.baseVal.value;A.path=z;A.coordsize=u+" "+o;NAIBU._setPaint(r,l);delete r._cacheMatrix,r._currentStyle;v=A=r=z=s=l=u=o=null},false);b=a=null},false);return this}SVGPolylineElement.constructor=SVGElement;SVGPolylineElement.prototype=new SVGElement();function SVGPolygonElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.animatedPoints=this.points=new SVGPointList();this.addEventListener("DOMAttrModified",function(b){var a=b.target;if(b.attrName==="points"){var h=a.points,e=a.ownerDocument.documentElement;var f=b.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/);for(var d=0,g,c=f.length;d<c;d+=2){if(isNaN(f[d])){--d;continue}g=e.createSVGPoint();g.x=parseFloat(f[d]);g.y=parseFloat(f[d+1]);h.appendItem(g)}}b=a=f=h=e=g=null},false);this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;var d=a.nextSibling,e=a.parentNode;if(d&&!!e._tar){if(!!!d._tar){var c=true;while(d){if(!!d._tar){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}c=null}else{e._tar.insertBefore(a._tar,d._tar)}}else{if(!!e._tar){e._tar.appendChild(a._tar)}}d=e=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(v){var r=v.target,t=r.points;var l=r.getScreenCTM();for(var k=0,s=[],q=t.numberOfItems;k<q;++k){var f=t.getItem(k);var j=f.matrixTransform(l);s[2*k]=j.x;s[2*k+1]=j.y;f=j=null}s.splice(2,0,"l");var z="m"+s.join(" ")+"x e";var A=r._tar,g=r.ownerDocument.documentElement;var u=g.width.baseVal.value,o=g.height.baseVal.value;A.path=z;A.coordsize=u+" "+o;NAIBU._setPaint(r,l);delete r._cacheMatrix,r._currentStyle;v=A=r=z=s=l=u=o=null},false);b=a=null},false);return this}SVGPolygonElement.constructor=SVGElement;SVGPolygonElement.prototype=new SVGElement();function SVGTextContentElement(){SVGElement.apply(this);this._list=null;this._length=0;this._stx=this._sty=0;this._chars=0;this.textLength=new SVGAnimatedLength();this.lengthAdjust=new SVGAnimatedEnumeration(SVGTextContentElement.LENGTHADJUST_UNKNOWN);this._isYokogaki=true;this.addEventListener("DOMNodeInserted",function(c){var b=c.target,j=c.currentTarget;if((c.eventPhase===Event.CAPTURING_PHASE)&&(b.localName==="a")&&(b.namespaceURI==="http://www.w3.org/2000/svg")&&b.firstChild){b=b.firstChild}if((c.eventPhase===Event.CAPTURING_PHASE)&&(b.nodeType===Node.TEXT_NODE)&&!!!b._tars){b._tars=[];var g=b.data.replace(/^\s+/,"").replace(/\s+$/,"");b.data=g;g=g.split("");for(var e=0,a=g.length;e<a;++e){var h=document.createElement("div"),f=h.style;f.position="absolute";f.marginLeft=f.marginRight=f.marginTop="0px";f.paddingTop=f.paddingLeft="0px";f.whiteSpace="nowrap";f.textIndent="0px";h.appendChild(document.createTextNode(g[e]));b._tars[b._tars.length]=h}g=null;j._length+=b._tars.length}else{if((c.eventPhase===Event.CAPTURING_PHASE)&&(b instanceof SVGTextContentElement)&&!!!b._tars){j._length+=b._length}}c=b=j=null},true);return this}SVGTextContentElement.constructor=SVGElement;SVGTextContentElement.prototype=new SVGElement();SVGTextContentElement.LENGTHADJUST_UNKNOWN=0;SVGTextContentElement.LENGTHADJUST_SPACING=1;SVGTextContentElement.LENGTHADJUST_SPACINGANDGLYPHS=2;SVGTextContentElement.prototype.getNumberOfChars=function(){return(this._length)};SVGTextContentElement.prototype.getComputedTextLength=function(){var a=this.textLength.baseVal;if((a.value===0)&&(this.getNumberOfChars()>0)){a.newValueSpecifiedUnits(SVGLength.SVG_LENGTHTYPE_NUMBER,this.getSubStringLength(0,this.getNumberOfChars()))}a=null;return(this.textLength.baseVal.value)};SVGTextContentElement.prototype.getSubStringLength=function(c,f){if(f===0){return 0}var e=this.getNumberOfChars();if(e<(f+c)){f=e-c+1}var a=this.getEndPositionOfChar(f+c-1),b=this.getStartPositionOfChar(c);if(this._isYokogaki){var d=a.x-b.x}else{var d=a.y-b.y}e=a=b=null;return d};SVGTextContentElement.prototype.getStartPositionOfChar=function(b){if(b>this.getNumberOfChars()||b<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{var H=this,h=H.firstChild,e=H.parentNode;if(!!!H._list){H._list=[];var v=H._chars;var t=H._stx,r=H._sty,A=0;var I=H.ownerDocument.defaultView.getComputedStyle(H,null);var o=((I.getPropertyValue("writing-mode"))==="lr-tb")?true:false;var g=parseFloat(I.getPropertyValue("font-size"));var M=H.x.baseVal,L=H.y.baseVal,B=H.dx.baseVal,z=H.dy.baseVal;if(e&&((e.localName==="text")||(e.localName==="tspan"))){var K=e.x.baseVal,J=e.y.baseVal,q=e.dx.baseVal,l=e.dy.baseVal}else{var K=J=q=l={numberOfItems:0}}var j="f ijltIr.,:;'-\"()",f="1234567890abcdeghknopquvxyz";if(o&&(H.localName==="text")){r+=g*0.2}else{if(H.localName==="text"){t-=g*0.5}}while(h){if(h.nodeType===Node.TEXT_NODE){var a=h._tars;for(var G=0,D=a.length;G<D;++G){if(A<K.numberOfItems-v){t=K.getItem(A).value;if(!o){t-=g*0.5}}else{if(A<M.numberOfItems){t=M.getItem(A).value;if(!o){t-=g*0.5}}}if(A<J.numberOfItems-v){r=J.getItem(A).value;if(o){r+=g*0.2}}else{if(A<L.numberOfItems){r=L.getItem(A).value;if(o){r+=g*0.2}}}if(A<q.numberOfItems-v){t+=q.getItem(A).value}else{if(A<B.numberOfItems){t+=B.getItem(A).value}}if(A<l.numberOfItems-v){r+=l.getItem(A).value}else{if(A<z.numberOfItems){r+=z.getItem(A).value}}var d=0;if(o){var c=h.data.charAt(G);if(j.indexOf(c)>-1){d=g*0.68}else{if(c==="s"){d=g*0.52}else{if((c==="C")||(c==="D")||(c==="M")||(c==="W")||(c==="G")||(c==="m")){d=g*0.2}else{if(f.indexOf(c)>-1){d=g*0.45}else{d=g*0.3}}}}var C=c.charCodeAt(0);if((12288<=C)&&(C<=65533)){d=-g*0.01;if((c==="う")||(c==="く")||(c==="し")||(c==="ち")){d+=g*0.2}}C=null}H._list[H._list.length]=t;H._list[H._list.length]=r;H._list[H._list.length]=g-d;if(o){t+=g;t-=d}else{r+=g}++A}v+=D;if(h.parentNode&&(h.parentNode.localName==="a")){h=h.parentNode}h=h.nextSibling}else{if((h.localName==="tspan")&&(h.namespaceURI==="http://www.w3.org/2000/svg")&&h.firstChild){h._stx=t;h._sty=r;h._chars=v;var w=h.getStartPositionOfChar(h.getNumberOfChars());var F=0,E=0;if(o){F=h._list[h._list.length-1]}else{E=h._list[h._list.length-1]}t=h._list[h._list.length-3]+F;r=h._list[h._list.length-2]+E;H._list=H._list.concat(h._list);var k=h.getNumberOfChars();A+=k;v+=k;w=k=null;h=h.nextSibling}else{if((h.localName==="a")&&(h.namespaceURI==="http://www.w3.org/2000/svg")&&h.firstChild){h=h.firstChild}else{h=h.nextSibling}}}}H._isYokogaki=o;H=h=e=K=J=M=L=v=I=t=r=o=null}var u=this.ownerDocument.documentElement.createSVGPoint();u.x=this._list[b*3];u.y=this._list[b*3+1];u=u.matrixTransform(this.getScreenCTM());return u}};SVGTextContentElement.prototype.getEndPositionOfChar=function(a){if(a>this.getNumberOfChars()||a<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{var b=this.getStartPositionOfChar(a);var c=this._list[a*3+2]*Math.sqrt(Math.abs(this.getScreenCTM()._determinant()));if(this._isYokogaki){b.x+=c}else{b.y+=c}return b}};SVGTextContentElement.prototype.getExtentOfChar=function(a){};SVGTextContentElement.prototype.getRotationOfChar=function(a){};SVGTextContentElement.prototype.getCharNumAtPosition=function(a){};SVGTextContentElement.prototype.selectSubString=function(a,b){};function SVGTextPositioningElement(){SVGTextContentElement.apply(this);this.x=new SVGAnimatedLengthList();this.y=new SVGAnimatedLengthList();this.dx=new SVGAnimatedLengthList();this.dy=new SVGAnimatedLengthList();this.rotate=new SVGAnimatedNumberList();this.addEventListener("DOMAttrModified",function(o){var h=o.target,c=o.attrName,f=h.ownerDocument.documentElement;var e=parseFloat;if((c==="x")||(c==="y")||(c==="dx")||(c==="dy")){var k=o.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/),q=h[c].baseVal;for(var g=0,b=k.length;g<b;++g){var l=f.createSVGLength();var d=k[g].match(/\D+$/),j=0;if(!!d){d=d[0]}if(!d){j=SVGLength.SVG_LENGTHTYPE_NUMBER}else{if(d==="%"){if((c==="x")||(c==="dx")){l._percent*=f.viewport.width}else{if((c==="y")||(c==="dy")){l._percent*=f.viewport.height}}j=SVGLength.SVG_LENGTHTYPE_PERCENTAGE}else{if(d==="em"){var a=h.ownerDocument.defaultView.getComputedStyle(h,null);l._percent*=e(a.getPropertyValue("font-size"));a=null;j=SVGLength.SVG_LENGTHTYPE_EMS}else{if(d==="ex"){j=SVGLength.SVG_LENGTHTYPE_EXS}else{if(d==="px"){j=SVGLength.SVG_LENGTHTYPE_PX}else{if(d==="cm"){j=SVGLength.SVG_LENGTHTYPE_CM}else{if(d==="mm"){j=SVGLength.SVG_LENGTHTYPE_MM}else{if(d==="in"){j=SVGLength.SVG_LENGTHTYPE_IN}else{if(d==="pt"){j=SVGLength.SVG_LENGTHTYPE_PT}else{if(d==="pc"){j=SVGLength.SVG_LENGTHTYPE_PC}}}}}}}}}}var r=e(k[g]);r=isNaN(r)?0:r;l.newValueSpecifiedUnits(j,r);q.appendItem(l)}h._list=null}o=h=null},false);this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){var a=b.target;if(a.nodeType!==Node.TEXT_NODE){a._list=null;b.currentTarget._list=null}b=a=null}},false);return this}SVGTextPositioningElement.constructor=SVGTextContentElement;SVGTextPositioningElement.prototype=new SVGTextContentElement();function SVGTextElement(){SVGTextPositioningElement.apply(this);this._tar=document.createElement("v:group");this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===3){return}var a=b.target;var d=a.nextSibling,e=a.parentNode,c=true;if(d&&d._tar&&e._tar&&(d._tar.parentNode===e._tar)){e._tar.insertBefore(a._tar,d._tar)}else{if(d&&!d._tar&&e._tar){while(d){if(d._tar&&(d._tar.parentNode===e._tar)){e._tar.insertBefore(a._tar,d._tar);c=false}d=d.nextSibling}if(c){e._tar.appendChild(a._tar)}}else{if(!d&&e._tar){e._tar.appendChild(a._tar)}}}d=e=c=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(v){var E=v.target,l=E.firstChild,o=E._tar;o.style.cssText=E.style.cssText;var G=E.ownerDocument.defaultView.getComputedStyle(E,null);var z=parseFloat(G.getPropertyValue("font-size"))*Math.sqrt(Math.abs(E.getScreenCTM()._determinant()));o.style.fontSize=z+"px";o.style.fontFamily=G.getPropertyValue("font-family");var H=E.ownerDocument.documentElement,r=o;var f=E.getComputedTextLength(),q=G.getPropertyValue("text-anchor");for(var F=0,D=0,B=E.getNumberOfChars();F<B;++F){if(l){if(!!l._tars&&(l._tars.length!==0)){var s=(F>D)?F-D:D-F;var t=l._tars[s].style,w=E.getStartPositionOfChar(F);t.position="absolute";if(E._isYokogaki){if(q==="middle"){w.x-=f/2}else{if(q==="end"){w.x-=f}}}else{if(q==="middle"){w.y-=f/2}else{if(q==="end"){w.y-=f}}}t.left=w.x+"px";t.top=w.y+"px";t.width="0px";t.height="0px";t.marginTop=E._isYokogaki?-z+"px":"0px";t.lineHeight=z+"px";o.appendChild(l._tars[s]);t=w=null}if(l.nodeName==="#text"){if((l.data.length+D)<=F+1){D=D+l.data.length;if(l.parentNode.localName==="a"){l=l.parentNode;o=r}l=l.nextSibling}}else{if(!!l.getNumberOfChars){if((l.getNumberOfChars()+D)<=F+1){D=D+l.getNumberOfChars();l=l.nextSibling}}else{if((l.localName==="a")&&(l.namespaceURI==="http://www.w3.org/2000/svg")&&l.firstChild){o=l._tar;l=l.firstChild;F-=2}}}}}var C=G.getPropertyValue("fill");if(C==="none"){E._tar.style.color="transparent"}else{if(C.indexOf("url")===-1){E._tar.style.color=C}else{E._tar.style.color="black"}}var k=G.getPropertyValue("cursor");if(k!=="auto"&&k!==""){E._tar.style.cursor=k}var u=G.getPropertyValue("visibility");if(u!=="visiblee"){E._tar.style.visibility=u}var h=true;if(o.lastChild){if(o.lastChild.nodeName!=="rect"){h=false}}else{h=false}if(!h){var A=document.createElement("v:rect");var g=A.style;g.width="1px";g.height="1px";g.left="0px";g.top="0px";A.stroked="false";A.filled="false";o.appendChild(A)}delete E._cacheMatrix,E._currentStyle;h=v=E=G=tpp=r=null},false);b=a=null},false);return this}SVGTextElement.constructor=SVGTextPositioningElement;SVGTextElement.prototype=new SVGTextPositioningElement();function SVGTSpanElement(){SVGTextElement.apply(this,arguments);return this}SVGTSpanElement.constructor=SVGTextPositioningElement;SVGTSpanElement.prototype=new SVGTextPositioningElement();function SVGTRefElement(){SVGTextPositioningElement.apply(this,arguments);SVGURIReference.apply(this,arguments);return this}SVGTRefElement.constructor=SVGTextPositioningElement;SVGTRefElement.prototype=new SVGTextPositioningElement();function SVGTextPathElement(){SVGTextContentElement.apply(this,arguments);this.startOffset;this.method;this.spacing;SVGURIReference.apply(this,arguments);return this}SVGTextPathElement.constructor=SVGTextContentElement;SVGTextPathElement.prototype=new SVGTextContentElement();SVGTextPathElement.TEXTPATH_METHODTYPE_UNKNOWN=0;SVGTextPathElement.TEXTPATH_METHODTYPE_ALIGN=1;SVGTextPathElement.TEXTPATH_METHODTYPE_STRETCH=2;SVGTextPathElement.TEXTPATH_SPACINGTYPE_UNKNOWN=0;SVGTextPathElement.TEXTPATH_SPACINGTYPE_AUTO=1;SVGTextPathElement.TEXTPATH_SPACINGTYPE_EXACT=2;function SVGAltGlyphElement(){SVGTextPositioningElement.apply(this,arguments);this.glyphRef;this.format;SVGURIReference.apply(this,arguments);return this}SVGAltGlyphElement.constructor=SVGTextPositioningElement;SVGAltGlyphElement.prototype=new SVGTextPositioningElement();function SVGAltGlyphDefElement(){SVGElement.apply(this,arguments);return this}SVGAltGlyphDefElement.constructor=SVGElement;SVGAltGlyphDefElement.prototype=new SVGElement();function SVGAltGlyphItemElement(){SVGElement.apply(this,arguments);return this}SVGAltGlyphItemElement.constructor=SVGElement;SVGAltGlyphItemElement.prototype=new SVGElement();function SVGGlyphRefElement(){SVGElement.apply(this,arguments);this.glyphRef;this.format;this.x;this.y;this.dx;this.dy;SVGURIReference.apply(this,arguments);return this}SVGGlyphRefElement.constructor=SVGElement;SVGGlyphRefElement.prototype=new SVGElement();function SVGPaint(){SVGColor.apply(this,arguments);this.paintType=SVGPaint.SVG_PAINTTYPE_UNKNOWN;this.uri=null;return this}SVGPaint.constructor=SVGColor;SVGPaint.prototype=new SVGColor();SVGPaint.SVG_PAINTTYPE_UNKNOWN=0;SVGPaint.SVG_PAINTTYPE_RGBCOLOR=1;SVGPaint.SVG_PAINTTYPE_RGBCOLOR_ICCCOLOR=2;SVGPaint.SVG_PAINTTYPE_NONE=101;SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR=102;SVGPaint.SVG_PAINTTYPE_URI_NONE=103;SVGPaint.SVG_PAINTTYPE_URI_CURRENTCOLOR=104;SVGPaint.SVG_PAINTTYPE_URI_RGBCOLOR=105;SVGPaint.SVG_PAINTTYPE_URI_RGBCOLOR_ICCCOLOR=106;SVGPaint.SVG_PAINTTYPE_URI=107;SVGPaint.prototype.setUri=function(a){this.setPaint(SVGPaint.SVG_PAINTTYPE_URI_NONE,a,null,null)};SVGPaint.prototype.setPaint=function(a,c,b,d){if((a<101&&c)||(a>102&&!c)){throw new SVGException(SVGException.SVG_INVALID_VALUE_ERR)}this.uri=c;this.paintType=a;if(a===SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR){a=SVGColor.SVG_COLORTYPE_CURRENTCOLOR}this.setColor(a,b,d)};function SVGMarkerElement(){SVGElement.apply(this,arguments);this.refX=new SVGAnimatedLength();this.refY=new SVGAnimatedLength();this.markerUnits=new SVGAnimatedEnumeration();this.markerWidth=new SVGAnimatedLength();this.markerHeight=new SVGAnimatedLength();this.orientType=new SVGAnimatedEnumeration();this.orientAngle=new SVGAnimatedAngle();this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.zoomAndPan=SVGZoomAndPan.SVG_ZOOMANDPAN_DISABLE;return this}SVGMarkerElement.SVG_MARKERUNITS_UNKNOWN=0;SVGMarkerElement.SVG_MARKERUNITS_USERSPACEONUSE=1;SVGMarkerElement.SVG_MARKERUNITS_STROKEWIDTH=2;SVGMarkerElement.SVG_MARKER_ORIENT_UNKNOWN=0;SVGMarkerElement.SVG_MARKER_ORIENT_AUTO=1;SVGMarkerElement.SVG_MARKER_ORIENT_ANGLE=2;SVGMarkerElement.constructor=SVGElement;SVGMarkerElement.prototype=new SVGElement();SVGMarkerElement.prototype.setOrientToAuto=function(){};SVGMarkerElement.prototype.setOrientToAngle=function(a){};function SVGColorProfileElement(){SVGElement.apply(this);this._local;this.name;this.renderingIntent;SVGURIReference.apply(this,arguments);return this}SVGColorProfileElement.constructor=SVGElement;SVGColorProfileElement.prototype=new SVGElement();function SVGColorProfileRule(){SVGCSSRule.apply(this);this.src;this.name;this.renderingIntent;return this}SVGColorProfileRule.constructor=SVGCSSRule;SVGColorProfileRule.prototype=new SVGCSSRule();function SVGGradientElement(){SVGElement.apply(this,arguments);SVGURIReference.apply(this,arguments);this.gradientUnits=new SVGAnimatedEnumeration();this.gradientTransform=new SVGAnimatedTransformList();this.spreadMethod=new SVGAnimatedEnumeration();this.addEventListener("DOMNodeInsertedIntoDocument",function(l){var k=l.target,r=l._tar,q=l._style;if(!!!r){return}if(k){var g=k;while(g&&!g.hasChildNodes()){var b=g.getAttributeNS("http://www.w3.org/1999/xlink","href");if(b){b.match(/#(.+)/);g=l.target.ownerDocument.getElementById(RegExp.$1)}else{break}}var o=g.getElementsByTagNameNS("http://www.w3.org/2000/svg","stop");if(!o){k=g=o=null;return}var c=o.length;var e=[],a=[],h=[];for(var f=0;f<c;++f){var j=o[f],d=j.ownerDocument.defaultView.getComputedStyle(j,"");e[f]=d.getPropertyValue("stop-color");a[f]=j.offset.baseVal+" "+e[f];h[f]=(d.getPropertyValue("stop-opacity")||1)*q.getPropertyValue("fill-opacity")*q.getPropertyValue("opacity")}r.setAttribute("method","none");r.setAttribute("color",e[0]);r.setAttribute("color2",e[c-1]);r.setAttribute("colors",a.join(","));r.setAttribute("opacity",h[c-1]+"");r.setAttribute("o:opacity2",h[0]+"");k._color=e;k=r=o=lengh=e=a=h=null}l=q=null},false);return this}SVGGradientElement.constructor=SVGElement;SVGGradientElement.prototype=new SVGElement();SVGGradientElement.SVG_SPREADMETHOD_UNKNOWN=0;SVGGradientElement.SVG_SPREADMETHOD_PAD=1;SVGGradientElement.SVG_SPREADMETHOD_REFLECT=2;SVGGradientElement.SVG_SPREADMETHOD_REPEAT=3;function SVGLinearGradientElement(){SVGGradientElement.apply(this,arguments);this.x1=new SVGAnimatedLength();this.y1=new SVGAnimatedLength();this.x2=new SVGAnimatedLength();this.y2=new SVGAnimatedLength();this.addEventListener("DOMNodeInsertedIntoDocument",function(a){var f=a.target,d=a._tar,e=270;if(!!!d){return}var b=f.ownerDocument.defaultView.getComputedStyle(f,"");var c=parseFloat(b.getPropertyValue("font-size"));f.x1.baseVal._emToUnit(c);f.y1.baseVal._emToUnit(c);f.x2.baseVal._emToUnit(c);f.y2.baseVal._emToUnit(c);e=270-Math.atan2(f.y2.baseVal.value-f.y1.baseVal.value,f.x2.baseVal.value-f.x1.baseVal.value)*180/Math.PI;if(e>=360){e-=360}d.setAttribute("type","gradient");d.setAttribute("angle",e+"");a=d=f=e=b=c=null},false);return this}SVGLinearGradientElement.constructor=SVGGradientElement;SVGLinearGradientElement.prototype=new SVGGradientElement();function SVGRadialGradientElement(){SVGGradientElement.apply(this);this.cx=new SVGAnimatedLength();this.cy=new SVGAnimatedLength();this.r=new SVGAnimatedLength();this.fx=new SVGAnimatedLength();this.fy=new SVGAnimatedLength();this.cx.baseVal.value=this.cy.baseVal.value=this.r.baseVal.value=0.5;this.addEventListener("DOMNodeInsertedIntoDocument",function(z){var j=z.target,V=z._tar,B=z._ttar;if(!!!V){return}V.setAttribute("type","gradientTitle");V.setAttribute("focus","100%");V.setAttribute("focusposition","0.5 0.5");if(B.localName==="rect"){var J=j.ownerDocument.defaultView.getComputedStyle(B,"");var g=parseFloat(J.getPropertyValue("font-size"));j.cx.baseVal._emToUnit(g);j.cy.baseVal._emToUnit(g);j.r.baseVal._emToUnit(g);j.fx.baseVal._emToUnit(g);j.fy.baseVal._emToUnit(g);var t=j.cx.baseVal.value,q=j.cy.baseVal.value;var F=j.r.baseVal.value,v,u;v=u=F;var D=B.getBBox();var l=B.ownerDocument.documentElement.viewport;var R=l.width|0,G=l.height|0,L=0,a=0;var S=j.getAttributeNS(null,"gradientUnits");if(!S||S==="objectBoundingBox"){t=t>1?t/100:t;q=q>1?q/100:q;F=F>1?F/100:F;var M=D.x,I=D.y,Q=D.width,O=D.height;t=t*Q+M;q=q*O+I;v=F*Q;u=F*O;M=I=Q=O=null}var c=j.getAttributeNS(null,"gradientTransform");if(c){j.setAttributeNS(null,"transform",c)}var A=B.getScreenCTM().multiply(j.getCTM());R=t-v;G=q-u;L=t+v;a=q+u;var f=v*0.55228,e=u*0.55228;var s=["m",t,G,"c",t-f,G,R,q-e,R,q,R,q+e,t-f,a,t,a,t+f,a,L,q+e,L,q,L,q-e,t+f,G,t,G,"x e"];for(var N=0,K=s.length;N<K;){if(isNaN(s[N])){++N;continue}var H=j.ownerDocument.documentElement.createSVGPoint();H.x=parseFloat(s[N]);H.y=parseFloat(s[N+1]);var d=H.matrixTransform(A);s[N]=d.x;N++;s[N]=d.y;N++;H=d=null}var U=s.join(" ");var b=document.getElementById("_NAIBU_outline");var C=document.createElement("div"),o=C.style;o.position="absolute";o.display="inline-block";var E=l.width,P=l.height;o.textAlign="left";o.top="0px";o.left="0px";o.width=E+"px";o.height=P+"px";b.appendChild(C);o.filter="progid:DXImageTransform.Microsoft.Compositor";C.filters.item("DXImageTransform.Microsoft.Compositor").Function=23;var k='<v:shape style="display:inline-block; position:relative; antialias:false; top:0px; left:0px;" coordsize="'+E+" "+P+'" path="'+U+'" stroked="f">'+V.outerHTML+"</v:shape>";var T=B._tar.path.value;C.innerHTML='<v:shape style="display:inline-block; position:relative; top:0px; left:0px;" coordsize="'+E+" "+P+'" path="'+T+'" stroked="f" fillcolor="'+j._color[j._color.length-1]+'" ></v:shape>';C.filters[0].apply();C.innerHTML=k;C.filters[0].play();B._tar.parentNode.insertBefore(C,B._tar);B._tar.filled="false";U=b=C=J=g=o=k=T=s=c=t=q=F=E=P=A=null}else{if(!V.parentNode){B._tar.appendChild(V)}}z=B=V=gard=null},false);return this}SVGRadialGradientElement.constructor=SVGGradientElement;SVGRadialGradientElement.prototype=new SVGGradientElement();function SVGStopElement(){SVGElement.apply(this,arguments);this.offset=new SVGAnimatedNumber();this.addEventListener("DOMAttrModified",function(a){if(a.attrName==="offset"){a.target.offset.baseVal=parseFloat(a.newValue)}a=null},false);return this}SVGStopElement.constructor=SVGElement;SVGStopElement.prototype=new SVGElement();function SVGPatternElement(){SVGElement.apply(this,arguments);this.patternUnits=new SVGAnimatedEnumeration();this.patternContentUnits=new SVGAnimatedEnumeration();this.patternTransform=new SVGAnimatedTransformList();this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();SVGURIReference.apply(this,arguments);this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.zoomAndPan=SVGZoomAndPan.SVG_ZOOMANDPAN_DISABLE;return this}SVGPatternElement.constructor=SVGElement;SVGPatternElement.prototype=new SVGElement();function SVGClipPathElement(){SVGElement.apply(this,arguments);this.clipPathUnits=new SVGAnimatedEnumeration();return this}SVGClipPathElement.constructor=SVGElement;SVGClipPathElement.prototype=new SVGElement();function SVGMaskElement(){SVGElement.apply(this,arguments);this.maskUnits=new SVGAnimatedEnumeration();this.maskContentUnits=new SVGAnimatedEnumeration();this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();return this}SVGMaskElement.constructor=SVGElement;SVGMaskElement.prototype=new SVGElement();function SVGFilterElement(){SVGElement.apply(this,arguments);this.filterUnits=new SVGAnimatedEnumeration();this.primitiveUnits=new SVGAnimatedEnumeration();this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.filterResX=new SVGAnimatedInteger();this.filterResY=new SVGAnimatedInteger();SVGURIReference.apply(this,arguments);return this}SVGFilterElement.constructor=SVGElement;SVGFilterElement.prototype=new SVGElement();function SVGFilterPrimitiveStandardAttributes(a){SVGStylable.apply(this,arguments);this._tar=a;this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.result=new SVGAnimatedLength()}SVGFilterPrimitiveStandardAttributes.constructor=SVGStylable;SVGFilterPrimitiveStandardAttributes.prototype=new SVGStylable();function SVGFEBlendElement(){SVGElement.apply(this,arguments);this.in1=new SVGAnimatedString();this.in2=new SVGAnimatedString();this.mode=new SVGAnimatedEnumeration();this._fpsa=SVGFilterPrimitiveStandardAttributes(this);return this}SVGFEBlendElement.constructor=SVGElement;SVGFEBlendElement.prototype=new SVGElement();SVGFEBlendElement.SVG_FEBLEND_MODE_UNKNOWN=0;SVGFEBlendElement.SVG_FEBLEND_MODE_NORMAL=1;SVGFEBlendElement.SVG_FEBLEND_MODE_MULTIPLY=2;SVGFEBlendElement.SVG_FEBLEND_MODE_SCREEN=3;SVGFEBlendElement.SVG_FEBLEND_MODE_DARKEN=4;SVGFEBlendElement.SVG_FEBLEND_MODE_LIGHTEN=5;function SVGFEGaussianBlurElement(){SVGElement.apply(this,arguments);this.in1=new SVGAnimatedString();this.stdDeviationX=new SVGAnimatedNumber();this.stdDeviationY=new SVGAnimatedNumber();this._fpsa=SVGFilterPrimitiveStandardAttributes(this);return this}SVGFEGaussianBlurElement.constructor=SVGElement;SVGFEGaussianBlurElement.prototype=new SVGElement();SVGFEGaussianBlurElement.prototype.setStdDeviation=function(b,a){};function SVGCursorElement(){SVGElement.apply(this,arguments);this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();SVGURIReference.apply(this,arguments);return this}SVGCursorElement.constructor=SVGElement;SVGCursorElement.prototype=new SVGElement();function SVGAElement(){SVGElement.apply(this);this._tar=document.createElement("a");this.target=new SVGAnimatedString();this.addEventListener("DOMAttrModified",function(b){var a=b.target;if(b.eventPhase===Event.BUBBLING_PHASE){return}if(b.attrName==="target"){a.target.baseVal=b.newValue}else{if(b.attrName==="xlink:title"){a._tar.setAttribute("title",b.newValue)}}b=null},false);this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===Event.BUBBLING_PHASE){return}if(a.nextSibling){if(!!a.parentNode._tar&&!!a.nextSibling._tar){a.parentNode._tar.insertBefore(a._tar,a.nextSibling._tar)}}else{if(!!a.parentNode._tar){a.parentNode._tar.appendChild(a._tar)}}var d=a._tar.style;d.cursor="hand";d.left="0px";d.top="0px";d.textDecoration="none";d=null;var e=a.target.baseVal;var c="replace";if(e==="_blank"){c="new"}a.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show",c);a.addEventListener("DOMAttrModified",function(h){var g=h.target;var l=g.getElementsByTagNameNS("http://www.w3.org/2000/svg","*");if(l){var f=g.ownerDocument.createEvent("MutationEvents");f.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);for(var k=0,j=l.length;k<j;++k){var o=l[k];o.dispatchEvent(f);o=null}f=null}h=g=l=null},false);a=b=null},false);this.addEventListener("DOMNodeInsertedIntoDocument",function(b){var a=b.target;if(!!a._tar&&(a.nodeType===Node.ELEMENT_NODE)){var c=a._tar.style;c.cursor="hand";c.textDecoration="none";c=null}a=b=null;return},true);SVGURIReference.apply(this,arguments);return this}SVGAElement.constructor=SVGElement;SVGAElement.prototype=new SVGElement();function SVGViewElement(){SVGElement.apply(this,arguments);this.viewTarget=new SVGStringList();this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.zoomAndPan=SVGZoomAndPan.SVG_ZOOMANDPAN_DISABLE;return this}SVGViewElement.constructor=SVGElement;SVGViewElement.prototype=new SVGElement();function SVGScriptElement(){SVGElement.apply(this);this.type;SVGURIReference.apply(this,arguments);this.addEventListener("DOMAttrModified",function(evt){if(evt.attrName==="type"){evt.target.type=evt.newValue}evt=null},false);this.addEventListener("SVGLoad",function(evt){var tar=evt.target,script=tar._text;var tod=tar.ownerDocument;NAIBU._temp_doc=tod;script=script.replace(/function\s+(\w+)/g,"$1 = function");script="(function(document){"+script+"})(NAIBU._temp_doc);";eval(script);tod.documentElement._svgload_limited--;if(tod.documentElement._svgload_limited<0){evt=tod.createEvent("SVGEvents");evt.initEvent("SVGLoad",false,false);tod.documentElement.dispatchEvent(evt)}tar=evt=script=null},false);this.addEventListener("DOMNodeInserted",function(evt){var tar=evt.target;if(evt.eventPhase===Event.BUBBLING_PHASE){if(tar.nodeName==="#cdata-section"){evt.currentTarget._text=tar.data}return}tar.addEventListener("DOMNodeInsertedIntoDocument",function(evt){var tar=evt.target;if(evt.eventPhase===Event.AT_TARGET&&!tar.getAttributeNodeNS("http://www.w3.org/1999/xlink","xlink:href")){var evtt=tar.ownerDocument.createEvent("SVGEvents");evtt.initEvent("SVGLoad",false,false);evt.currentTarget.dispatchEvent(evtt)}tar=evt=null},false)},false);return this}SVGScriptElement.constructor=SVGElement;SVGScriptElement.prototype=new SVGElement();function SVGEvent(){Event.apply(this,arguments);return this}SVGEvent.constructor=Event;SVGEvent.prototype=new Event();function SVGZoomEvent(){UIEvent.apply(this,arguments);this.zoomRectScreen=new SVGRect();this.previousScale=1;this.previousTranslate=new SVGPoint();this.newScale=1;this.newTranslate=new SVGPoint();return this}SVGZoomEvent.constructor=UIEvent;SVGZoomEvent.prototype=new UIEvent();function SVGAnimationElement(a){if(!!a){return this}SVGElement.apply(this);this.style.setProperty=function(){};this._tar=null;this.targetElement;this._beginValue="0ms";this._endValue=null;this._currentFrame=0;this._currentCount=0;this._maxCount=0;this._maxDur=0;this._isRepeat=false;this._simpleDuration=null;this._begin=null;this._end=null;this._from=this._to=this._values=this._by=null;this._keyTimes=null;this.addEventListener("beginEvent",function(c){var b=c.target;if(!b.isRepeat){b.endElementAt(b.getSimpleDuration())}else{b.beginElementAt(b.getSimpleDuration());if(b.getCurrentTime()!==0){var d=b.ownerDocument,c=d.createEvent("TimeEvents");b._currentCount++;c.initTimeEvent("repeatEvent",d.defaultView,b._currentCount);b.dispatchEvent(c)}}},false);this.addEventListener("DOMAttrModified",function(c){if(c.eventPhase===Event.BUBBLING_PHASE){return}var b=c.target,d=c.attrName;if(d==="begin"){b._beginValue=c.newValue}else{if(d==="end"){b._endValue=c.newValue}else{if(d==="dur"){b._simpleDuration=b._getOffset(c.newValue)}else{if(d==="repeatCount"){b._maxCount=parseFloat(c.newValue);b._isRepeat=true}else{if(d==="repeatDur"){b._maxDur=parseFloat(c.newValue);b._isRepeat=true}else{if(d==="from"){b._from=c.newValue}else{if(d==="to"){b._to=c.newValue}else{if(d==="values"){b._values=c.newValue.split(";")}else{if(d==="by"){b._by=c.newValue}else{if(d==="keyTimes"){var f=c.newValue.split(";");b._keyTimes=[];for(var e=0;e<f.length;++e){b._keyTimes[e]=parseFloat(f[e])}f=null}}}}}}}}}}c=null},false);this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===Event.BUBBLING_PHASE){return}var b=c.target;b.addEventListener("DOMNodeInsertedIntoDocument",function(e){var d=e.target;if(d._values){}else{if(d._from&&d._to){d._values=[d._from,d._to]}else{if(d._from&&d._by){var g=parseFloat(d._from)+parseFloat(d._by),f=d._from.match(/\D+/)||[""];d._values=[d._from,g+f[0]]}else{if(d._to){d._values=[null,d._to]}else{if(d._by){d._values=[null,null,d._by]}else{if(!d.hasChildNodes()&&!d.hasAttributeNS(null,"path")){return this}}}}}}if(d.hasAttributeNS("http://www.w3.org/1999/xlink","xlink:href")){d.targetElement=d.ownerDocument.getElementById(d.getAttributeNS("http://www.w3.org/1999/xlink","xlink:href").substring(1))}else{d.targetElement=d.parentNode}d._eventSync(d._beginValue,(function(k,i,h,j){h.addEventListener(j.match(k._eventRegExp)[0],function(){if(i!==0){k.beginElementAt(i)}else{k._begin=NAIBU.Time.currentFrame;k.beginElement();k._currentFrame++}},false)}),"beginElementAt");if(d._endValue){d._eventSync(d._endValue,(function(k,i,h,j){h.addEventListener(j.match(k._eventRegExp)[0],function(){k.endElementAt(i)},false)}),"endElementAt")}e=d=null},false);c=b=null},false);this.addEventListener("repeatEvent",function(c){var b=c.target;if((b._currentCount>=b._maxCount)||(b.getCurrentTime()>=(b._maxDur+b.getStartTime()))){b._isRepeat=false}},false);return this}SVGAnimationElement.constructor=SVGElement;SVGAnimationElement.prototype=new SVGElement();SVGAnimationElement.prototype.beginElement=function(){var b=this.ownerDocument,a=b.createEvent("TimeEvents");a.initTimeEvent("beginEvent",b.defaultView,0);this.dispatchEvent(a)};SVGAnimationElement.prototype.endElement=function(){var b=this.ownerDocument,a=b.createEvent("TimeEvents");a.initTimeEvent("endEvent",b.defaultView,0);this.dispatchEvent(a)};SVGAnimationElement.prototype.beginElementAt=function(b){var a=this.ownerDocument.documentElement.getCurrentTime();this._begin=b+a};SVGAnimationElement.prototype.endElementAt=function(b){var a=this.ownerDocument.documentElement.getCurrentTime();this._end=b+a};SVGAnimationElement.prototype._eventRegExp=/(mouse|activ|clic)[a-z]+/;SVGAnimationElement.prototype._timeRegExp=/[\-\d\.]+(h|min|s|ms)?/;SVGAnimationElement.prototype._unit={h:2880000,min:48000,s:800,ms:0.8};SVGAnimationElement.prototype._getOffset=function(a){var c=parseFloat(a.match(this._timeRegExp));if(!isNaN(c)&&RegExp.$1){var b=c*this._unit[RegExp.$1]}else{if(!isNaN(c)){var b=c}else{var b=0}}c=a=null;return b};SVGAnimationElement.prototype._eventSync=function(c,d,b){var e=this._getOffset(c);this._begin=NAIBU.Time.Max;if(/(mouse|activ|click)/.test(c)){var a;if(/([^;]+)\.\D/.test(c)){a=this.ownerDocument.getElementById(RegExp.$1)}else{a=this.targetElement}if(!e&&e!==0){e=NAIBU.Time.Max}d(this,e,a,c)}else{if(!e&&(c!=="undefined")&&(e!==0)){this._begin=0}else{this[b](e)}}};SVGAnimationElement.prototype.getStartTime=function(){if(!!this._begin||this._begin===0){return(this._begin)}else{throw new DOMException(DOMException.INVALID_STATE_ERR)}};SVGAnimationElement.prototype.getCurrentTime=function(){return(this._currentFrame*125*0.8)};SVGAnimationElement.prototype.getSimpleDuration=function(){if(!!!this._simpleDuration&&!!!this._end&&this._simpleDuration!==0){throw new DOMException(DOMException.NOT_SUPPORTED_ERR)}else{if(!!this._simpleDuration&&!!this._end){var a=(this._simpleDuration>this._end-this._begin)?this._end-this._begin:this._simpleDuration}else{var a=!!this._end?this._end-this._begin:this._simpleDuration}}return a};NAIBU.Time={currentFrame:0,Max:7000,start:function(){if(NAIBU.Clip.length>0){screen.updateInterval=42;window.onscroll=function(){screen.updateInterval=0;screen.updateInterval=42};NAIBU.stop=setInterval((function(){var b=NAIBU.Time.currentFrame++;var f=NAIBU.Clip;var e=b*100;if(b>NAIBU.Time.Max){clearInterval(NAIBU.stop)}for(var d=0,a=f.length;d<a;++d){var c=f[d];c.ownerDocument.documentElement.setCurrentTime(e);if("_begin" in c){if(c.getStartTime()<=e){if(c.getCurrentTime()===0){c.beginElement()}c._currentFrame++}if(c._end&&(c._end<=e)&&(c.getCurrentTime()!==0)){c.endElement();if(!!c._frame){c._frame()}c._currentFrame=0;delete c._begin;c._end=null}else{if(!!c._frame){c._frame()}}}c=null}}),1)}else{window.onscroll=function(){screen.updateInterval=0;window.onscroll=NAIBU.emptyFunction}}}};NAIBU.Clip=[];function SVGAnimateElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._valueList=[];this._isDiscrete=false;this.addEventListener("DOMAttrModified",function(a){if(a.eventPhase===Event.BUBBLING_PHASE){return}if((a.attrName==="calcMode")&&(a.newValue==="discrete")){a.target._isDiscrete=true}},false);this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;a.addEventListener("DOMNodeInsertedIntoDocument",function(q){var h=q.target,k=h.getAttributeNS(null,"attributeName"),r=h.targetElement,j=r[k];var f=r.cloneNode(false);if(!h._values[0]){h._values[0]=r.getAttributeNS(null,k)||r.style.getPropertyValue(k);if(!h._values[1]){var o=parseFloat(h._values[0])+parseFloat(h._values[2]),l=h._values[0].match(/\D+/)||[""];h._values[1]=o+l[0];h._values.pop();o=l=null}}if(!!j){j.animVal=f[k].baseVal;for(var g=0,e=h._values,d=e.length;g<d;++g){var c=r.cloneNode(false);delete c._tar;c.setAttributeNS(null,k,e[g]);h._valueList[h._valueList.length]=c[k].baseVal}}else{if(!!CSS2Properties[k]||k.indexOf("-")>-1){for(var g=0,e=h._values,d=e.length;g<d;++g){h._valueList[g]=parseFloat(e[g])}}else{if("animatedPoints" in r){r.animatedPoints=f.points;for(var g=0,e=h._values,d=e.length;g<d;++g){var c=r.cloneNode(false);delete c._tar;c.setAttributeNS(null,"points",e[g]);h._valueList[h._valueList.length]=c.points}}else{if("normalizedPathSegList" in r){r.animatedNormalizedPathSegList=f.normalizedPathSegList;for(var g=0,e=h._values,d=e.length;g<d;++g){var c=r.cloneNode(false);delete c._tar;c.setAttributeNS(null,"d",e[g]);h._valueList[h._valueList.length]=c.normalizedPathSegList}}else{f=null;return}}}}q=j=c=f=null},false)},false);this.addEventListener("beginEvent",function(c){var b=c.target;var d=b.getAttributeNS(null,"attributeName"),f=b.targetElement.attributes.getNamedItemNS(null,d);var e=b.targetElement,a=e[d];b._frame=function(){var l=b.getSimpleDuration()*0.8,j=b._valueList.length-1,i=b.getCurrentTime();if((j!==-1)&&(l!==0)&&(i<=l)){if(b._isDiscrete){++j}var u=Math.floor((i*j)/l);if(u===j){u-=1}}else{return}var t=b.ownerDocument.createEvent("MutationEvents");t.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);if(b._keyTimes){var o=(b._keyTimes[u+1]-b._keyTimes[u])*l;var g=b._keyTimes[u]}else{var o=l/j;var g=u/j}if(!!a){var h=a.baseVal,k=a.animVal;var r=b._valueList[u].value;if(!b._isDiscrete){var q=b._valueList[u+1].value,s=r+(q-r)*(i-g*l)/o}else{var s=r}k.newValueSpecifiedUnits(h.unitType,s);a.baseVal=k;k=null;e.dispatchEvent(t);a.animVal=a.baseVal;a.baseVal=h;o=null}else{if(!!CSS2Properties[d]||d.indexOf("-")>-1){var h=null;var r=b._valueList[u].value,q=b._valueList[u+1].value;if(!b._isDiscrete){var s=r+(q-r)*(i-g*l)/o}else{var s=r}}else{if("animatedPoints" in e){var h=e.points;e.points=e.animatedPoints;e.dispatchEvent(t);e.animatedPoints=e.points;e.points=h}else{if("normalizedPathSegList" in e){var h=e.normalizedPathSegList;e.normalizedPathSegList=e.animatedNormalizedPathSegList;e.dispatchEvent(t);e.animatedNormalizedPathSegList=e.normalizedPathSegList;e.normalizedPathSegList=h}}}}t=r=q=s=l=j=u=i=null};c=vir=null},false);this.addEventListener("endEvent",function(b){var a=b.target,c=a.getAttributeNS(null,"fill");if(!c||(c==="remove")){var b=a.ownerDocument.createEvent("MutationEvents");b.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);a.targetElement.dispatchEvent(b);b=null}},false);this.addEventListener("repeatEvent",function(b){var a=b.target},false);return this}SVGAnimateElement.constructor=SVGAnimationElement;SVGAnimateElement.prototype=new SVGAnimationElement(1);function SVGSetElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._to="";this.addEventListener("DOMAttrModified",function(b){var a=b.target,c=b.attrName;if(c==="to"){a._to=b.newValue}a=c=null},false);this.addEventListener("beginEvent",function(c){var b=c.target;if(b.targetElement){var d=b.getAttributeNS(null,"attributeName"),g=b.targetElement.attributes.getNamedItemNS(null,d);var a=b.targetElement[d];if(!!a){var f=a.baseVal;if(f instanceof SVGLength){a.baseVal=b.ownerDocument.documentElement.createSVGLength()}else{if(f instanceof SVGRect){a.baseVal=b.ownerDocument.documentElement.createSVGRect()}}var c=b.ownerDocument.createEvent("MutationEvents");c.initMutationEvent("DOMAttrModified",true,false,g,g,b._to,d,MutationEvent.MODIFICATION);b.targetElement.dispatchEvent(c);c=null;a.animVal=a.baseVal;a.baseVal=f}else{var e=b.ownerDocument.getOverrideStyle(b.targetElement,"");e.setProperty(d,b.getAttributeNS(null,"to"),null);e=null}}c=b=d=null},false);this.addEventListener("endEvent",function(c){var b=c.target,f=b.getAttributeNS(null,"fill");if(!f||(f==="remove")){var d=b.getAttributeNS(null,"attributeName"),e=b.ownerDocument.defaultView.getComputedStyle(b.targetElement,"");b.targetElement.style.setProperty(d,e.getPropertyValue(d),null);var a=b.ownerDocument.createEvent("MutationEvents");a.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);b.targetElement.dispatchEvent(a);d=e=a=null}b=f=null},false);this.addEventListener("repeatEvent",function(b){var a=b.target,c=a.getAttributeNS(null,"attributeName"),d=a.ownerDocument.defaultView.getComputedStyle(a.targetElement,"")},false);return this}SVGSetElement.constructor=SVGAnimationElement;SVGSetElement.prototype=new SVGAnimationElement(1);function SVGAnimateMotionElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this.addEventListener("DOMAttrModified",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target,c=b.attrName;if(c==="path"){var e=a.ownerDocument.createElementNS("http://www.w3.org/2000/svg","path");e.setAttributeNS(null,"d",b.newValue);a._path=e;e=null}},false);this.addEventListener("beginEvent",function(b){var a=b.target,c=a.targetElement.transform;c.animVal=new SVGTransformList();if(c.baseVal.numberOfItems!==0){c.animVal.initialize(c.baseVal.createSVGTransformFromMatrix(c.baseVal.getItem(0).matrix))}c.animVal.appendItem(a.ownerDocument.documentElement.createSVGTransform());a._frame=function(){var f=a,e=f._path;if(!!e){var j=f.getSimpleDuration();if(j===0){j=null;return}var g=(e.getTotalLength()/j)*f.getCurrentTime()/125*0.8;var k=e.getPointAtLength(g),h=f.targetElement.transform;k=k.matrixTransform(f.targetElement.getScreenCTM());h.animVal.getItem(h.animVal.numberOfItems-1).setTranslate(k.x,k.y);var i=h.baseVal;h.baseVal=h.animVal;var d=f.ownerDocument.createEvent("MutationEvents");d.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);f.targetElement.dispatchEvent(d);h.baseVal=i;d=i=h=g=j=k=null}};b=c=null},false);this.addEventListener("endEvent",function(c){var b=c.target,d=b.targetElement.transform;d.animVal=d.baseVal;var a=b.ownerDocument.createEvent("MutationEvents");a.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);b.targetElement.dispatchEvent(a);b._frame=c=a=null},false);this.addEventListener("repeatEvent",function(b){var a=b.target},false);return this}SVGAnimateMotionElement.constructor=SVGAnimationElement;SVGAnimateMotionElement.prototype=new SVGAnimationElement(1);function SVGMPathElement(){SVGElement.apply(this);SVGURIReference.apply(this);return this}SVGMPathElement.constructor=SVGElement;SVGMPathElement.prototype=new SVGElement();function SVGAnimateColorElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._valueList=[];this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;a.addEventListener("DOMNodeInsertedIntoDocument",function(k){var g=k.target,h=g.getAttributeNS(null,"attributeName"),l=g.targetElement;var e=g.ownerDocument.defaultView.getComputedStyle(l,"");if(!g._values[0]){g._values[0]=e.getPropertyValue(h)}for(var f=0,d=g._values,c=d.length;f<c;++f){var j=new SVGColor();j.setRGBColor(g._values[f]);g._valueList[g._valueList.length]=j;j=null}},false)},false);this.addEventListener("beginEvent",function(b){var a=b.target,d=a.getAttributeNS(null,"attributeName");var e=a.ownerDocument.getOverrideStyle(a.targetElement,"");var c=a.ownerDocument.defaultView.getComputedStyle(a.targetElement,"");if(a._values[0]!==null){e.setProperty(d,a._values[0],null)}a._frame=function(){var B=a;var w=B.getSimpleDuration()*0.8,k=B._valueList.length-1,j=B.getCurrentTime();if((k!==-1)&&(w!==0)&&(j<=w)){var C=Math.floor((j*k)/w);if(C===k){C-=1}}else{return}if(a._keyTimes){var z=(a._keyTimes[C+1]-a._keyTimes[C])*w;var i=a._keyTimes[C]}else{var z=w/k;var i=C/k}var l=B._valueList[C].rgbColor,s=B._valueList[C+1].rgbColor,q=(j-i*w)/z,t=CSSPrimitiveValue.CSS_NUMBER;var v=l.red.getFloatValue(t),h=l.green.getFloatValue(t),o=l.blue.getFloatValue(t);var f=v+(s.red.getFloatValue(t)-v)*q;var u=h+(s.green.getFloatValue(t)-h)*q;var A=o+(s.blue.getFloatValue(t)-o)*q;e.setProperty(d,"rgb("+Math.ceil(f)+","+Math.ceil(u)+","+Math.ceil(A)+")",null);B=w=k=j=l=s=v=h=o=t=f=u=A=null}},false);this.addEventListener("endEvent",function(c){var b=c.target;var a=b.ownerDocument.createEvent("MutationEvents");a.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);b.targetElement.dispatchEvent(a);b._frame=c=a=null},false);this.addEventListener("repeatEvent",function(b){var a=b.target},false);return this}SVGAnimateColorElement.constructor=SVGAnimationElement;SVGAnimateColorElement.prototype=new SVGAnimationElement(1);function SVGAnimateTransformElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this.addEventListener("beginEvent",function(b){var a=b.target,c=a.targetElement.transform;c.animVal=new SVGTransformList();if(c.baseVal.numberOfItems!==0){c.animVal.initialize(c.baseVal.createSVGTransformFromMatrix(c.baseVal.getItem(0).matrix))}c.animVal.appendItem(a.ownerDocument.documentElement.createSVGTransform())},false);this.addEventListener("endEvent",function(b){var a=b.target},false);this.addEventListener("repeatEvent",function(b){var a=b.target},false);return this}SVGAnimateTransformElement.constructor=SVGAnimationElement;SVGAnimateTransformElement.prototype=new SVGAnimationElement(1);function SVGFontElement(){SVGElement.apply(this);this._isExternal=0;this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===Event.BUBBLING_PHASE){return}a.addEventListener("DOMNodeInsertedIntoDocument",function(d){var c=d.target,e="http://www.w3.org/2000/svg",g=c.getElementsByTagNameNS(e,"font-face").item(0);var f=function(t){var q=t.target;var l=g.getAttributeNS(null,"font-family");var r=c.ownerDocument.getElementsByTagNameNS(e,"text");for(var o=0,s=c,j=r.length;o<j;++o){var k=r[o],h=s.ownerDocument.defaultView.getComputedStyle(k,"");if(h.getPropertyValue("font-family",null).indexOf(l)>-1){NAIBU._noie_createFont(k,s,true)}}t=c=q=curt=textElments=e=s=null};if(!g.__isLinked||c._isExternal){c.ownerDocument.documentElement._svgload_limited=0;c.ownerDocument.documentElement.addEventListener("SVGLoad",f,false)}},false)},false);return this}SVGFontElement.constructor=SVGElement;SVGFontElement.prototype=new SVGElement();function SVGGlyphElement(){SVGElement.apply(this);return this}SVGGlyphElement.constructor=SVGElement;SVGGlyphElement.prototype=new SVGElement();function SVGMissingGlyphElement(){SVGElement.apply(this);return this}SVGMissingGlyphElement.constructor=SVGElement;SVGMissingGlyphElement.prototype=new SVGElement();function SVGHKernElement(){SVGElement.apply(this);return this}SVGHKernElement.constructor=SVGElement;SVGHKernElement.prototype=new SVGElement();function SVGVKernElement(){SVGElement.apply(this);return this}SVGVKernElement.constructor=SVGElement;SVGVKernElement.prototype=new SVGElement();function SVGFontFaceElement(){SVGElement.apply(this);this._isLinked=0;this.addEventListener("DOMNodeInserted",function(a){if(a.eventPhase===Event.BUBBLING_PHASE){if(a.target.localName==="font-face-uri"){a.currentTarget._isLinked=1}return}},false);return this}SVGFontFaceElement.constructor=SVGElement;SVGFontFaceElement.prototype=new SVGElement();function SVGFontFaceSrcElement(){SVGElement.apply(this);return this}SVGFontFaceSrcElement.constructor=SVGElement;SVGFontFaceSrcElement.prototype=new SVGElement();function SVGFontFaceUriElement(){SVGElement.apply(this);this.addEventListener("DOMNodeInserted",function(a){if(a.eventPhase===Event.BUBBLING_PHASE){return}a.target.ownerDocument.documentElement._svgload_limited--;a.target.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed")},false);this.addEventListener("SVGLoad",function(b){var a=b.target,c=a.parentNode.parentNode.parentNode;if(c.localName==="defs"){c=a.parentNode.parentNode}a._instance._isExternal=1;c.parentNode.appendChild(a._instance);b=a=c=null},false);SVGURIReference.apply(this);return this}SVGFontFaceUriElement.constructor=SVGElement;SVGFontFaceUriElement.prototype=new SVGElement();function SVGFontFaceFormatElement(){SVGElement.apply(this);return this}SVGFontFaceFormatElement.constructor=SVGElement;SVGFontFaceFormatElement.prototype=new SVGElement();function SVGFontFaceNameElement(){SVGElement.apply(this);return this}SVGFontFaceNameElement.constructor=SVGElement;SVGFontFaceNameElement.prototype=new SVGElement();function SVGDefinitionSrcElement(){SVGElement.apply(this);return this}SVGDefinitionSrcElement.constructor=SVGElement;SVGDefinitionSrcElement.prototype=new SVGElement();function SVGMetadataElement(){SVGElement.apply(this);return this}SVGMetadataElement.constructor=SVGElement;SVGMetadataElement.prototype=new SVGElement();function SVGForeignObjectElement(){SVGElement.apply(this);this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();return this}SVGForeignObjectElement.constructor=SVGElement;SVGForeignObjectElement.prototype=new SVGElement();DOMImplementation["http://www.w3.org/2000/svg"]={Document:SVGDocument,svg:SVGSVGElement,g:SVGGElement,path:NAIBU.SVGPathElement,title:SVGTitleElement,desc:SVGDescElement,defs:SVGDefsElement,linearGradient:SVGLinearGradientElement,radialGradient:SVGRadialGradientElement,stop:SVGStopElement,rect:SVGRectElement,circle:SVGCircleElement,ellipse:SVGEllipseElement,polyline:SVGPolylineElement,polygon:SVGPolygonElement,text:SVGTextElement,tspan:SVGTSpanElement,image:SVGImageElement,line:SVGLineElement,a:SVGAElement,altGlyphDef:SVGAltGlyphDefElement,altGlyph:SVGAltGlyphElement,altGlyphItem:SVGAltGlyphItemElement,animateColor:SVGAnimateColorElement,animate:SVGAnimateElement,animateMotion:SVGAnimateMotionElement,animateTransform:SVGAnimateTransformElement,clipPath:SVGClipPathElement,colorProfile:SVGColorProfileElement,cursor:SVGCursorElement,definitionSrc:SVGDefinitionSrcElement,feBlend:SVGFEBlendElement,feGaussianBlur:SVGFEGaussianBlurElement,filter:SVGFilterElement,font:SVGFontElement,"font-face":SVGFontFaceElement,"font-face-format":SVGFontFaceFormatElement,"font-face-name":SVGFontFaceNameElement,"font-face-src":SVGFontFaceSrcElement,"font-face-uri":SVGFontFaceUriElement,foreignObject:SVGForeignObjectElement,glyph:SVGGlyphElement,glyphRef:SVGGlyphRefElement,hkern:SVGHKernElement,marker:SVGMarkerElement,mask:SVGMaskElement,metadata:SVGMetadataElement,missingGlyph:SVGMissingGlyphElement,mpath:SVGMPathElement,script:SVGScriptElement,set:SVGSetElement,style:SVGStyleElement,"switch":SVGSwitchElement,textPath:SVGTextPathElement,tref:SVGTRefElement,use:SVGUseElement,view:SVGViewElement,vkern:SVGVKernElement,pattern:SVGPatternElement};NAIBU._fontSearchURI=function(a){var f=a.target.ownerDocument;var b=f.getElementsByTagNameNS("http://www.w3.org/2000/svg","font-face-uri");for(var d=0;d<b.length;++d){var g=b[d].getAttributeNS("http://www.w3.org/1999/xlink","href");var e=g.substring(g.indexOf("#")+1,g.length);var c=NAIBU.xmlhttp;c.open("GET",g.replace(/#.+$/,""),true);c.setRequestHeader("X-Requested-With","XMLHttpRequest");c.onreadystatechange=function(){if((c.readyState===4)&&(c.status===200)){var h=(new DOMParser()).parseFromString(c.responseText,"text/xml");NAIBU._font({document:h,docu:f,id:e});c=f=h=null}};c.send(null)}};NAIBU._font=function(g){var k=g.document,e="http://www.w3.org/2000/svg";var d=k.getElementsByTagNameNS(e,"font").item(0);var f=d.getElementsByTagNameNS(e,"font-face").item(0).getAttributeNS(null,"font-family");if(f&&(d.getAttributeNS(null,"id")===g.id)){var j=g.docu.getElementsByTagNameNS(e,"text");for(var h=0,c=j.length;h<c;++h){var b=j[h],a=g.docu.defaultView.getComputedStyle(b,"");if(a.getPropertyValue("font-family",null).indexOf(f)>-1){NAIBU._noie_createFont(b,d,false)}}}k=g=null};NAIBU._noie_createFont=function(a,P,h){var I=a.ownerDocument.defaultView.getComputedStyle(a,""),Q="http://www.w3.org/2000/svg";var J=a.getAttributeNS(null,"writing-mode")||a.parentNode.getAttributeNS(null,"writing-mode"),l=J?"vert-adv-y":"horiz-adv-x";var w=a.firstChild,R,g=P.getElementsByTagNameNS(Q,"glyph");var N=parseFloat(P.getElementsByTagNameNS(Q,"font-face").item(0).getAttribute("units-per-em")||1000);var H=parseFloat((P.getAttributeNS(null,l)||N));var d=parseFloat(a.getAttributeNS(null,"x")||0),o=parseFloat(I.getPropertyValue("font-size")),c=parseFloat(a.getAttributeNS(null,"y")||0),B=o/N;var f=false,e=["fill","fill-opacity","stroke","stroke-width","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-dasharray","stroke-opacity","opacity","cursor"];if(h){var z="n"+Math.random();a._tar.firstChild.setAttribute("id",z);var u=document.getElementById(z);o=parseFloat(u.currentStyle.fontSize);B=o/N;z=u=null}if(/a/[-1]==="a"){f=true}else{if(h||J){f=true}}if(f){while(w){if(!g){break}R=w.data;if(R!==void 0){var T=[],F=[];for(var L=0,D=g.length;L<D;++L){var t=g[L],r=t.getAttributeNS(null,"unicode")||"なし";var s=t.getAttributeNS(null,"orientation"),O=true,k=true;if(s){if(s==="h"){O=false}}else{k=false}if((J&&O)||!(J||O)||!k){var A=R.indexOf(r);while(A>-1){T[A]=parseFloat(t.getAttributeNS(null,l)||H);F[A]=t.getAttributeNS(null,"d");A=R.indexOf(r,A+1)}}}for(var L=0,M=0;L<R.length;++L){if(T[L]!==void 0){var G=a.ownerDocument.createElementNS(Q,"path");var v=a.ownerDocument.documentElement.createSVGMatrix();v.a=B;v.d=-B;for(var K=0;K<e.length;++K){var S=e[K],b=a.getAttributeNS(null,S);if(b){G.setAttributeNS(null,S,b)}}if(J){var C=c+M*B,E=d;if("、。".indexOf(R.charAt(L))>-1){var q=o/Math.SQRT2;E+=q;C-=q;q=null}v.e=E;v.f=C}else{v.e=d+M*B;v.f=c}G.setAttributeNS(null,"transform","matrix("+v.a+","+v.b+","+v.c+","+v.d+","+v.e+","+v.f+")");G.setAttributeNS(null,"d",F[L]);a.parentNode.insertBefore(G,a);M+=T[L];v=null}}M=T=F=null}else{if("tspan|a".indexOf(w.localName)>-1){NAIBU._noie_createFont(w,P,h)}}w=w.nextSibling}if(h){var I=a.ownerDocument.getOverrideStyle(a,null);I.setProperty("visibility","hidden");I=null}else{a.setAttributeNS(null,"opacity","0")}}R=J=l=N=H=d=c=o=I=Q=w=null};(function(){var d=new CSSStyleDeclaration(),e=0;for(var c in CSS2Properties){if(CSS2Properties.hasOwnProperty(c)){var b=c.replace(/([A-Z])/,"-");if(!!RegExp.$1){var a="-"+RegExp.$1.toLowerCase()}else{var a="-"}b=b.replace(/\-/,a);d.setProperty(b,CSS2Properties[c]);d._list[b]=d._list[e];++e;p=m=c=b=a=null}}d._list._opacity=1;d._list._fontSize=12;CSS2Properties._list=d._list;Document.prototype.defaultView._defaultCSS=d._list;d=null})();NAIBU.addEvent=function(a,b){if(window.addEventListener){window.addEventListener(a,b,false)}else{if(window.attachEvent){window.attachEvent("on"+a,b)}else{window["on"+a]=b}}if(sieb_s){b()}};function unsvgtovml(){try{if("stop" in NAIBU){clearInterval(NAIBU.stop)}window.onscroll=NAIBU.emptyFunction;window.detachEvent("onload",NAIBU._main);Element=SVGElement=Attr=NamedNodeMap=CSS2Properties=CSSValue=CSSPrimitiveValue=NAIBU.xmlhttp=Node=Event=NAIBU=stlog=STLog=SVGColor=SVGPaint=null;Array=ActiveXObject=null}catch(a){}}NAIBU._main=(function(){stlog=new STLog(false);var f;try{f=new ActiveXObject("Msxml2.XMLHTTP")}catch(l){try{f=new ActiveXObject("Microsoft.XMLHTTP")}catch(v){f=false}}if(!f){try{f=new XMLHttpRequest()}catch(l){f=false}}NAIBU.xmlhttp=f;var h;if(("namespaces" in document)&&!document.namespaces.v){NAIBU.doc=new ActiveXObject("MSXML2.DomDocument");h=NAIBU.doc;document.namespaces.add("v","urn:schemas-microsoft-com:vml");document.namespaces.add("o","urn:schemas-microsoft-com:office:office");var t=document.createStyleSheet();var o="behavior: url(#default#VML);display: inline-block;} ";t.cssText="v\\:rect{"+o+"v\\:image{"+o+"v\\:fill{"+o+"v\\:stroke{"+o+"o\\:opacity2{"+o+"dn\\:defs{display:none}v\\:group{text-indent:0px;position:relative;width:100%;height:100%;"+o+"v\\:shape{width:100%;height:100%;"+o}var g=document.getElementsByTagName("script");for(var j=0;j<g.length;++j){var q=g[j].type;if(g[j].type==="image/svg+xml"){var k=g[j].text;if(sieb_s&&k.match(/&lt;svg/)){k=k.replace(/<.+?>/g,"");k=k.replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&quot;/g,'"').replace(/&amp;/g,"&")}if(NAIBU.isMSIE){var a=new GetSVGDocument(g[j]);a.xmlhttp={readyState:4,status:200,responseText:k.replace(/\shref=/g," target='_top' xlink:href=")};a._ca()}else{var d=location.href.replace(/\/[^\/]+?$/,"/");k=k.replace(/\shref=(['"a-z]+?):\/\//g," target='_top' xlink:href=$1://").replace(/\shref=(.)/g," target='_top' xlink:href=$1"+d);var u=NAIBU.textToSVG(k,g[j].getAttribute("width"),g[j].getAttribute("height"));g[j].parentNode.insertBefore(u,g[j])}k=null}q=null}NAIBU.doc=h;h=g=null;if(f&&NAIBU.isMSIE){if(!!document.createElementNS){if(!!document.createElementNS("http://www.w3.org/2000/svg","svg").createSVGRect){}}else{var r=document.createElement("div");r.setAttribute("id","_NAIBU_outline");document.body.appendChild(r);var c=document.getElementsByTagName("object"),b=document.getElementsByTagName("embed");var j=0,u=[];for(;j<c.length;++j){u[u.length]=new GetSVGDocument(c[j])}for(j=0;j<b.length;++j){u[u.length]=new GetSVGDocument(b[j])}for(j=0;j<u.length;++j){if(j<u.length-1){u[j]._next=u[j+1]}}if(j>0){u[0]._init()}u=null}}else{var c=document.getElementsByTagName("object");for(var j=0;j<c.length;++j){if(c[j].contentDocument){NAIBU._fontSearchURI({target:{ownerDocument:c[j].contentDocument}})}else{if(c[j].getSVGDocument){c[j].getSVGDocument().documentElement.addEventListener("SVGLoad",NAIBU._fontSearchURI,false)}else{}}}}f=null});NAIBU.addEvent("load",NAIBU._main);NAIBU.utf16=function(a){return unescape(a)};NAIBU.unescapeUTF16=function(a){return a.replace(/%u\w\w\w\w/g,NAIBU.utf16)};NAIBU.textToSVG=function(e,a,c){if(navigator.userAgent.indexOf("WebKit")>-1||navigator.userAgent.indexOf("Safari")>-1){var d="data:image/svg+xml;charset=utf-8,"+NAIBU.unescapeUTF16(escape(e));var b=document.createElement("object");b.setAttribute("data",d);b.setAttribute("width",a);b.setAttribute("height",c);b.setAttribute("type","image/svg+xml");return b}else{var f=(new DOMParser()).parseFromString(e,"text/xml");return(document.importNode(f.documentElement,true))}};NAIBU.addEvent("unload",unsvgtovml);
NAIBU.isMSIE=/*@cc_on!@*/false;