/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jdbcacsess.gui.CellEditorSqlTable;
import jdbcacsess.gui.CellRendererSqlTable;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.sql.ColumnInfo;
import jdbcacsess.sql.ColumnInfoTable;
import jdbcacsess.sql.SqlExec;
import jdbcacsess.sql.column.GetColumnResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnInfoResult
extends ColumnInfo {
    private String columnClassName;
    private Class<?> columnClass;
    public GetColumnResultSet getColumnResultSet;
    public Method methodOfResultSet;
    private TableCellRenderer tableCellRenderer;
    private TableCellEditor tableCellEditor;
    private int precision = 0;
    private int scale = 0;
    private static Map<String, Class<?>> primitiveMap = new HashMap();
    private boolean existsSqlMapping = false;

    static {
        primitiveMap.put("byte", Byte.class);
        primitiveMap.put("short", Short.class);
        primitiveMap.put("int", Integer.class);
        primitiveMap.put("long", Long.class);
        primitiveMap.put("float", Float.class);
        primitiveMap.put("double", Double.class);
        primitiveMap.put("char", Character.class);
        primitiveMap.put("boolean", Boolean.class);
    }

    public ColumnInfoResult(int columnIndex, String columnName, int columnType, String columnTypeName, int nullable, String columnClassName, int precision, int scale) {
        super(columnIndex, columnName, columnType, columnTypeName, nullable);
        this.columnClassName = columnClassName;
        this.precision = precision;
        this.scale = scale;
        this.setTableCellRenderer(new CellRendererSqlTable());
        this.setTableCellEditor(new CellEditorSqlTable());
    }

    public ColumnInfoResult(ColumnInfoTable cit) {
        this(cit.getColumnIndex(), cit.getColumnName(), cit.getSqlType().getValue(), cit.getColumnTypeName(), 0, String.class.getName(), 0, 0);
    }

    public Class<?> getColumnClass() {
        if (this.columnClass == null) {
            String name = this.columnClassName == null ? "java.lang.Object" : this.columnClassName;
            this.columnClass = primitiveMap.get(this.columnClassName);
            if (this.columnClass == null) {
                try {
                    this.columnClass = SqlExec.classForName(name);
                }
                catch (ClassNotFoundException e) {
                    JDialogMessage.errorDialog(e);
                    this.columnClass = Object.class;
                }
            }
        }
        return this.columnClass;
    }

    public void setColumnClass(Class<?> columnClass) {
        this.columnClassName = columnClass.getName();
        this.columnClass = null;
    }

    public void setColumnClassName(String columnClassName) {
        this.columnClassName = columnClassName;
        this.columnClass = null;
    }

    public String getColumnClassName() {
        return this.columnClassName;
    }

    @Override
    public String getColumnComment() {
        String str = super.getColumnComment();
        if (this.precision <= 0) {
            return str;
        }
        if (this.scale <= 0) {
            return String.valueOf(str) + "(" + this.precision + ")";
        }
        return String.valueOf(str) + "(" + this.precision + "." + this.scale + ")";
    }

    public void setTableCellRenderer(TableCellRenderer tableCellRenderer) {
        this.tableCellRenderer = tableCellRenderer;
    }

    public TableCellRenderer getTableCellRenderer() {
        return this.tableCellRenderer;
    }

    public void setTableCellEditor(TableCellEditor tableCellEditor) {
        this.tableCellEditor = tableCellEditor;
    }

    public TableCellEditor getTableCellEditor() {
        return this.tableCellEditor;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public Constructor getConstructor() {
        Constructor<Object> constructor = null;
        try {
            constructor = this.getColumnClass().getConstructor(String.class);
        }
        catch (Exception e) {
            if (!this.isExistsSqlMapping()) {
                JDialogMessage.infoDialog(String.valueOf(this.getColumnClass().getName()) + "\u306f\u3001String \u3092\u5f15\u6570\u3068\u3059\u308b\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u3092\u6301\u3063\u3066\u3044\u306a\u3044\u306e\u3067\u3001\u66f4\u65b0\u6642\u30a8\u30e9\u30fc\u304c\u8d77\u304d\u308b\u304b\u3082\u3057\u308c\u307e\u305b\u3093\u3002\n" + "\u300cSQL\u30de\u30c3\u30d4\u30f3\u30b0\u8a2d\u5b9a\u300d\u3067\u3001\u53d6\u5f97\u30af\u30e9\u30b9\u3068sql.Types\u5024\u3092\u8a2d\u5b9a\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002\n\n" + "\u4f8b\u3048\u3070\u3001\u53d6\u5f97\u30af\u30e9\u30b9= toString() , sql.Types\u5024= Types.VARCHAR \u7b49\u3067\u3059\u3002", "\u5f37\u5236\u7684\u306bString\u3068\u3057\u3066\u66f4\u65b0");
            }
            try {
                constructor = String.class.getConstructor(String.class);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        Logger.global.fine("constructor:" + constructor);
        return constructor;
    }

    public boolean isExistsSqlMapping() {
        return this.existsSqlMapping;
    }

    public void setExistsSqlMapping(boolean existsSqlMapping) {
        this.existsSqlMapping = existsSqlMapping;
    }
}

