/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui.cell;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import jdbcacsess.gui.CellRendererDataBaseObject;

public class JPanelSqlData
extends JPanel {
    static Map<String, String> arrayPrimitiveClassNameMap = new HashMap<String, String>();
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane = null;
    private JTree jTree = null;
    private DefaultMutableTreeNode rootTreeNode;
    private DefaultTreeModel treeModel;

    static {
        arrayPrimitiveClassNameMap.put("[Z", "boolean[]");
        arrayPrimitiveClassNameMap.put("[B", "byte[]");
        arrayPrimitiveClassNameMap.put("[C", "char[]");
        arrayPrimitiveClassNameMap.put("[D", "double[]");
        arrayPrimitiveClassNameMap.put("[F", "float[]");
        arrayPrimitiveClassNameMap.put("[I", "int[]");
        arrayPrimitiveClassNameMap.put("[J", "long[]");
        arrayPrimitiveClassNameMap.put("[S", "short[]");
    }

    public JPanelSqlData() {
        this.initialize();
        this.jTree.setRowHeight(this.getFontMetrics(CellRendererDataBaseObject.treeFontPrim).getHeight());
        this.jTree.setModel(null);
        this.jTree.setToggleClickCount(1);
        this.jTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                DefaultMutableTreeNode dummyChild = (DefaultMutableTreeNode)node.getFirstChild();
                if (dummyChild.getUserObject() != null) {
                    return;
                }
                JPanelSqlData.this.addObject(node);
                node.remove(dummyChild);
                JPanelSqlData.this.treeModel.reload(node);
            }

            public void treeCollapsed(TreeExpansionEvent e) {
            }
        });
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJScrollPane(), "Center");
    }

    public void setTopObject(String fieldName, Class cls, Object obj) {
        DefaultMutableTreeNode dummyChild;
        this.rootTreeNode = this.addChileNode(fieldName, cls, obj);
        if (this.rootTreeNode.getChildCount() != 0 && (dummyChild = (DefaultMutableTreeNode)this.rootTreeNode.getFirstChild()).getUserObject() == null) {
            this.rootTreeNode.remove(dummyChild);
        }
        this.addObject(this.rootTreeNode);
        this.treeModel = new DefaultTreeModel(this.rootTreeNode);
        this.jTree.setModel(this.treeModel);
    }

    private void addObject(DefaultMutableTreeNode node) {
        Object obj = ((SqlData)node.getUserObject()).getObject();
        if (obj == null) {
            return;
        }
        Class<?> cls = obj.getClass();
        while (cls != Object.class) {
            Field[] fieldArray = cls.getDeclaredFields();
            int n = 0;
            int n2 = fieldArray.length;
            while (n < n2) {
                Field field = fieldArray[n];
                field.setAccessible(true);
                try {
                    node.add(this.addChileNode(field.getName(), field.getType(), field.get(obj)));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                ++n;
            }
            cls = cls.getSuperclass();
        }
    }

    private DefaultMutableTreeNode addChileNode(String fieldName, Class cls, Object obj) {
        if (obj == null) {
            return new DefaultMutableTreeNode(new SqlDataNull(fieldName, cls));
        }
        if (cls.isPrimitive()) {
            return new DefaultMutableTreeNode(new SqlDataPrimitive(fieldName, obj));
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new SqlData(fieldName, obj));
        if (!cls.isArray()) {
            node.add(new DefaultMutableTreeNode(null));
            return node;
        }
        boolean primitive = arrayPrimitiveClassNameMap.containsKey(obj.getClass().getName());
        int j = 0;
        while (j < Array.getLength(obj)) {
            Object arrayObj = Array.get(obj, j);
            if (arrayObj == null) {
                DefaultMutableTreeNode arrayNode = new DefaultMutableTreeNode(new SqlDataNull("(" + j + ")", cls.getComponentType()));
                node.add(arrayNode);
            } else {
                String arrayStringName = "(" + j + ")";
                DefaultMutableTreeNode arrayNode = null;
                if (primitive) {
                    arrayNode = new DefaultMutableTreeNode(new SqlDataPrimitive(arrayStringName, arrayObj));
                    node.add(arrayNode);
                } else {
                    node.add(this.addChileNode(arrayStringName, cls.getComponentType(), arrayObj));
                }
            }
            if (j > 999) break;
            ++j;
        }
        return node;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTree());
        }
        return this.jScrollPane;
    }

    private JTree getJTree() {
        if (this.jTree == null) {
            this.jTree = new JTree();
        }
        return this.jTree;
    }

    class SqlData {
        String fieldName;
        Object object;

        public SqlData(String fieldName, Object object) {
            this.fieldName = fieldName;
            this.object = object;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.fieldName);
            sb.append(" ");
            String className = this.object.getClass().getName();
            String value = arrayPrimitiveClassNameMap.get(className);
            sb.append(value == null ? className : value);
            try {
                if (this.object.getClass().getMethod("toString", null).getDeclaringClass() != Object.class) {
                    sb.append("  : ");
                    sb.append(this.object.toString());
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return sb.toString();
        }

        public Object getObject() {
            return this.object;
        }
    }

    class SqlDataPrimitive
    extends SqlData {
        public SqlDataPrimitive(String fieldName, Object object) {
            super(fieldName, object);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.fieldName);
            sb.append("  : ");
            sb.append(this.object);
            return sb.toString();
        }
    }

    class SqlDataNull
    extends SqlData {
        Class cls;

        public SqlDataNull(String fieldName, Class cls) {
            super(fieldName, null);
            this.cls = cls;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.fieldName);
            sb.append(" " + this.cls.getName());
            sb.append("  : #NULL#");
            return sb.toString();
        }
    }
}

