/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.sql.ColumnInfoTable;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlExec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPanelConditionTable
extends JPanel {
    private static final long serialVersionUID = 7919683889963770593L;
    private SchemaTableName schemaTableName;
    private ActionListener whereActionListener;
    private MouseListener joinPointerMouseListener;
    private String tableAlias;

    JPanelConditionTable(SchemaTableName stn, ActionListener whereActionListener, String tableAlias, MouseListener joinPointerMouseListener) {
        this.schemaTableName = stn;
        this.whereActionListener = whereActionListener;
        this.tableAlias = tableAlias;
        this.joinPointerMouseListener = joinPointerMouseListener;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EtchedBorder(0));
        JLabel label = new JLabel(stn.getCompleteTableName());
        label.setBorder(new EmptyBorder(2, 1, 3, 1));
        this.add(label);
        try {
            for (ColumnInfoTable cit : SqlExec.getColumnMames(this.schemaTableName)) {
                JPanelConditionColumn jpanel = new JPanelConditionColumn(cit);
                this.add(jpanel);
            }
        }
        catch (SQLException e) {
            JDialogMessage.sqlErrorDialog(e, "\u30ab\u30e9\u30e0\u60c5\u5831\u53d6\u5f97\u5931\u6557");
        }
        this.add(Box.createVerticalGlue());
    }

    public void setColumnInfoTables(ArrayList<ColumnInfoTable> columnInfoTables) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component component = componentArray[n];
            if (component instanceof JPanelConditionColumn) {
                JPanelConditionColumn jPanelConditionColumn = (JPanelConditionColumn)component;
                boolean hit = false;
                for (ColumnInfoTable cit : columnInfoTables) {
                    if (cit != jPanelConditionColumn.getColumnInfoTable()) continue;
                    hit = true;
                    break;
                }
                if (!hit) {
                    jPanelConditionColumn.jToggleButtonColumn.setSelected(false);
                }
            }
            ++n;
        }
    }

    SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    String getTableAlias() {
        return this.tableAlias;
    }

    SelectColumns getSelectColumns(boolean allColumnsAstar) {
        SelectColumns rtn = new SelectColumns();
        Component[] componentArray = this.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component component = componentArray[n];
            if (component instanceof JPanelConditionColumn) {
                JPanelConditionColumn jPanelConditionColumn = (JPanelConditionColumn)component;
                if (jPanelConditionColumn.isSelectColumn()) {
                    rtn.columnInfoTables.add(jPanelConditionColumn.getColumnInfoTable());
                } else {
                    rtn.allSelected = false;
                }
            }
            ++n;
        }
        if (allColumnsAstar && rtn.allSelected) {
            rtn.columnInfoTables.clear();
        }
        return rtn;
    }

    SelectColumns getSelectColumns() {
        SelectColumns rtn = new SelectColumns();
        Component[] componentArray = this.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component component = componentArray[n];
            if (component instanceof JPanelConditionColumn) {
                JPanelConditionColumn jPanelConditionColumn = (JPanelConditionColumn)component;
                if (jPanelConditionColumn.isSelectColumn()) {
                    rtn.columnInfoTables.add(jPanelConditionColumn.getColumnInfoTable());
                } else {
                    rtn.allSelected = false;
                }
            }
            ++n;
        }
        return rtn;
    }

    boolean isUseJoinPointer() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            JPanelConditionColumn jPanelConditionColumn;
            Component component = componentArray[n];
            if (component instanceof JPanelConditionColumn && (jPanelConditionColumn = (JPanelConditionColumn)component).isSelectJoinPointer()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public JPanelConditionColumn.JToggleButtonJoinPointer getJoinPointer(String columnName, String side) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            JPanelConditionColumn jPanelConditionColumn;
            Component component = componentArray[n];
            if (component instanceof JPanelConditionColumn && (jPanelConditionColumn = (JPanelConditionColumn)component).getColumnInfoTable().getColumnName().equals(columnName)) {
                return jPanelConditionColumn.searchJoinPointer(side);
            }
            ++n;
        }
        return null;
    }

    class SelectColumns {
        boolean allSelected = true;
        ArrayList<ColumnInfoTable> columnInfoTables = new ArrayList();

        SelectColumns() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JoinStatus {
        OUTER_NONE,
        OUTER_EQUAL,
        OUTER_ALL;


        public static JoinStatus defaultValueOf(String str) {
            try {
                return JoinStatus.valueOf(str);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return OUTER_NONE;
            }
        }
    }

    public class JPanelConditionColumn
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private ColumnInfoTable columnInfoTable;
        private JToggleButtonJoinPointer jToggleButtonJoinPointer1;
        private JToggleButtonJoinPointer jToggleButtonJoinPointer2;
        private JToggleButtonColumn jToggleButtonColumn;
        private JToggleButtonJoinPointer jToggleButtonJoinPointer3;
        private JToggleButtonJoinPointer jToggleButtonJoinPointer4;

        public JPanelConditionColumn(ColumnInfoTable _colInfo) {
            this.initialize();
            this.columnInfoTable = _colInfo;
            this.jToggleButtonColumn.setText(this.columnInfoTable.getColumnName());
            if (this.columnInfoTable.isPrimaryKey()) {
                this.jToggleButtonColumn.setFont(this.jToggleButtonColumn.getFont().deriveFont(1));
            } else {
                this.jToggleButtonColumn.setFont(this.jToggleButtonColumn.getFont().deriveFont(0));
            }
            this.jToggleButtonColumn.setSelected(true);
        }

        private void initialize() {
            this.setAlignmentX(0.0f);
            this.setLayout(new BoxLayout(this, 2));
            this.jToggleButtonJoinPointer1 = new JToggleButtonJoinPointer("left");
            this.jToggleButtonJoinPointer2 = new JToggleButtonJoinPointer("left2");
            this.jToggleButtonColumn = new JToggleButtonColumn();
            this.jToggleButtonJoinPointer3 = new JToggleButtonJoinPointer("right");
            this.jToggleButtonJoinPointer4 = new JToggleButtonJoinPointer("right2");
            this.jToggleButtonColumn.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent arg0) {
                }

                public void mouseEntered(MouseEvent arg0) {
                    if ((arg0.getModifiers() & 4) != 0) {
                        JPanelConditionColumn.this.jToggleButtonColumn.setSelected(!JPanelConditionColumn.this.jToggleButtonColumn.isSelected());
                    }
                }

                public void mouseExited(MouseEvent arg0) {
                }

                public void mousePressed(MouseEvent arg0) {
                    if ((arg0.getModifiers() & 4) != 0) {
                        JPanelConditionColumn.this.jToggleButtonColumn.setSelected(!JPanelConditionColumn.this.jToggleButtonColumn.isSelected());
                    }
                }

                public void mouseReleased(MouseEvent arg0) {
                }
            });
            this.add(this.jToggleButtonJoinPointer1);
            this.add(this.jToggleButtonJoinPointer2);
            this.add(this.jToggleButtonColumn);
            this.add(this.jToggleButtonJoinPointer3);
            this.add(this.jToggleButtonJoinPointer4);
        }

        public JToggleButtonJoinPointer searchJoinPointer(String side) {
            if (this.jToggleButtonJoinPointer1.getSide().equals(side)) {
                return this.jToggleButtonJoinPointer1;
            }
            if (this.jToggleButtonJoinPointer2.getSide().equals(side)) {
                return this.jToggleButtonJoinPointer2;
            }
            if (this.jToggleButtonJoinPointer3.getSide().equals(side)) {
                return this.jToggleButtonJoinPointer3;
            }
            if (this.jToggleButtonJoinPointer4.getSide().equals(side)) {
                return this.jToggleButtonJoinPointer4;
            }
            return null;
        }

        public ColumnInfoTable getColumnInfoTable() {
            return this.columnInfoTable;
        }

        public boolean isSelectColumn() {
            return this.jToggleButtonColumn.isSelected();
        }

        public boolean isSelectJoinPointer() {
            return this.jToggleButtonJoinPointer1.isSelected() | this.jToggleButtonJoinPointer3.isSelected();
        }

        public class JToggleButtonColumn
        extends JToggleButton {
            private static final long serialVersionUID = 2164596673577865176L;

            JToggleButtonColumn() {
                this.setMargin(new Insets(1, 1, 1, 1));
            }
        }

        public class JToggleButtonJoinPointer
        extends JToggleButton {
            private static final long serialVersionUID = 8576629740563464503L;
            private String side;
            private JoinStatus joinStatus;
            private Point point = new Point();

            JToggleButtonJoinPointer(String side) {
                this.setJoinStatus(JoinStatus.OUTER_NONE);
                this.setMargin(new Insets(1, 1, 1, 1));
                this.addActionListener(JPanelConditionTable.this.whereActionListener);
                this.side = side;
                this.addMouseListener(JPanelConditionTable.this.joinPointerMouseListener);
                this.setFont(new Font("Monospaced", 0, 9));
            }

            public JPanelConditionTable getJPanelColumns() {
                return JPanelConditionTable.this;
            }

            public ColumnInfoTable getColumnInfoTable() {
                return JPanelConditionColumn.this.columnInfoTable;
            }

            public Point getConnecterPoint() {
                Point p = this.getLocationOnScreen();
                Point rp = this.getRootPane().getLocationOnScreen();
                int x = p.x - rp.x;
                int y = p.y - rp.y;
                this.point.setLocation(x + this.getWidth() / 2, y + this.getHeight() / 2);
                return this.point;
            }

            public String getSide() {
                return this.side;
            }

            public JoinStatus getJoinStatus() {
                return this.joinStatus;
            }

            public void setJoinStatus(JoinStatus joinStatus) {
                this.joinStatus = joinStatus;
                switch (this.joinStatus) {
                    case OUTER_NONE: {
                        this.setText("\u30fb");
                        break;
                    }
                    case OUTER_EQUAL: {
                        this.setText("\u25cb");
                        break;
                    }
                    case OUTER_ALL: {
                        this.setText("\u25cf");
                        break;
                    }
                }
            }
        }
    }
}

