/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.xml.transform.TransformerException;
import jdbcacsess.SettingFile;
import jdbcacsess.csv.CsvInfo;
import jdbcacsess.csv.CsvInputImportToDB;
import jdbcacsess.csv.CsvMode;
import jdbcacsess.csv.JDialogCsv;
import jdbcacsess.csv.JFrameImportHistory;
import jdbcacsess.dbconnect.JDialogConnect;
import jdbcacsess.gui.JFrameAboutBox;
import jdbcacsess.gui.JFrameSetting;
import jdbcacsess.gui.JPanelDatabaseMetaData;
import jdbcacsess.gui.JPanelEditButton;
import jdbcacsess.gui.JPanelPrepareStatementLog;
import jdbcacsess.gui.JPanelResultSetMetaData;
import jdbcacsess.gui.JTreeDataBaseObjects;
import jdbcacsess.gui.SqlStatementObserver;
import jdbcacsess.gui.TabWinManager;
import jdbcacsess.gui.TabWinMode;
import jdbcacsess.gui.cell.JFrameViewerHex;
import jdbcacsess.gui.common.ComponentProperty;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.gui.common.JFrameBase;
import jdbcacsess.gui.common.JPopupMenuCnageUI;
import jdbcacsess.sql.SqlExec;

public class JFrameMain
extends JFrameBase {
    private static final long serialVersionUID = -398926768714658758L;
    private JPanel jContentPane = null;
    private JLabel jLabelStatusBar = null;
    private JPanel jPanel = null;
    private JPanelEditButton jPanelEditButton = null;
    private JTreeDataBaseObjects jTreeDataBaseObjects = null;
    private JMenuBar jMenuBarBase = null;
    private JMenu jMenuFile = null;
    private JMenu jMenuHelp1 = null;
    private JMenuItem jMenuItemFileConnect = null;
    private JMenuItem jMenuItemFileDisConnect = null;
    private JMenuItem jMenuItemFileCsvImport = null;
    private JMenuItem jMenuItemFileExit = null;
    private JMenuItem jMenuItemHelpAbout = null;
    private JScrollPane jScrollPane = null;
    private JSplitPane jSplitPaneBase = null;
    private TabWinManager tabWinManager;
    private SqlStatementObserver sqlStatementObserver;
    private JMenu jMenuNew = null;
    private JMenuItem jMenuItemAutoCommit = null;
    private JMenuItem jMenuItemManualCommit = null;
    private JMenu jMenuDisplay = null;
    private JMenuItem jMenuItemChangeWin = null;
    private JMenuItem jMenuItemChangeTab = null;
    private JMenuItem jMenuItemWinSort = null;
    private JMenuItem jMenuItemCsvImportHistory = null;
    private JCheckBoxMenuItem jCheckBoxMenuItemDebug = null;
    public static String fontFamilyName = "Monospaced";
    public static boolean debugMode = false;
    public static int binaryDataSize = 100;
    private JMenu jMenuChangeUI = null;
    private JRadioButtonMenuItem jRadioButtonMenuItem = null;
    private JMenuItem jMenuItemHexViewer = null;
    private JMenu jMenuBinaryData = null;
    private JRadioButtonMenuItem jRadioButtonMenuItemNoLimit = null;
    private JRadioButtonMenuItem jRadioButtonMenuItemLimit1KB = null;
    private JRadioButtonMenuItem jRadioButtonMenuItemLimit100KB = null;
    private JRadioButtonMenuItem jRadioButtonMenuItemLimit100B = null;
    private JRadioButtonMenuItem jRadioButtonMenuItemLimit10KB = null;
    private JMenuItem jMenuItemSetting = null;
    private static JPanelPrepareStatementLog jPanelPrepareStatementLog;
    private static JPanelResultSetMetaData jPanelResultSetMetaData;
    private JPanelDatabaseMetaData jPanelDatabaseMetaData = null;

    public JFrameMain() {
        this.actionPerformedConnect();
        this.initialize();
        this.jTreeDataBaseObjects.requestFocusInWindow();
    }

    private void initialize() {
        this.setSize(800, 600);
        this.setContentPane(this.getJContentPane());
        this.setJMenuBar(this.getJMenuBarBase());
        this.setTitle("JdbcAcsess");
        ComponentProperty cp = this.init();
        Integer divider = cp.getToInteger(this.getClass(), "divider");
        if (divider != null) {
            this.jSplitPaneBase.setDividerLocation(divider);
        }
        this.sqlStatementObserver = new SqlStatementObserver();
        this.sqlStatementObserver.addObserver(this.jTreeDataBaseObjects);
        this.sqlStatementObserver.addObserver(this.jPanelEditButton);
        this.tabWinManager = new TabWinManager(this.sqlStatementObserver);
        this.jSplitPaneBase.setRightComponent(this.tabWinManager.getPane().getJComponentPane());
        this.setVisible(true);
        if (SqlExec.isConnect()) {
            this.jTreeDataBaseObjects.setTree();
        }
        this.setMessage(SqlExec.getConnectString());
    }

    public TabWinManager getTabWinManager() {
        return this.tabWinManager;
    }

    public void frameClosing() {
        if (SqlExec.isConnect()) {
            SqlExec.disconnect();
        }
        this.tabWinManager.allPaneClosed();
        ComponentProperty cp = new ComponentProperty();
        cp.put(this.getClass(), "divider", this.jSplitPaneBase.getDividerLocation());
        SettingFile xml = SettingFile.getInstance();
        try {
            xml.save();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private void actionPerformedNewWindow(boolean antoCommit) {
        this.tabWinManager.newPanel(antoCommit);
    }

    private void actionPerformedTabWin(TabWinMode tw) {
        if (this.tabWinManager.getPane().isTabWinModeEqual(tw)) {
            return;
        }
        Component c = this.jSplitPaneBase.getRightComponent();
        int size = this.jSplitPaneBase.getDividerLocation();
        if (c != null) {
            this.jSplitPaneBase.remove(c);
        }
        this.jSplitPaneBase.setRightComponent(this.tabWinManager.changeTabWin(tw));
        this.jSplitPaneBase.setDividerLocation(size);
        this.jSplitPaneBase.validate();
    }

    private void actionPerformedSort() {
        this.tabWinManager.sortWindow();
    }

    private boolean actionPerformedConnect() {
        JDialogConnect jdc = new JDialogConnect();
        if (!jdc.isAnsOK()) {
            return false;
        }
        this.setMessage(SqlExec.getConnectString());
        return true;
    }

    private void actionPerformedDisConnect(ActionEvent e) {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            return;
        }
        this.setMessage(" ");
        this.tabWinManager.allPaneClosed();
        SqlExec.disconnect();
        this.jTreeDataBaseObjects.clearTree();
        if (!SqlExec.isConnect()) {
            this.setMessage("DB\u5207\u65ad\u3057\u307e\u3057\u305f");
        }
    }

    private void actionPerformedCsvImport(ActionEvent e) {
        if (!SqlExec.isConnect()) {
            JDialogMessage.notConnectErrorDialog();
            return;
        }
        this.setMessage(" ");
        JDialogCsv dlg = new JDialogCsv(CsvMode.IMPORT);
        CsvInfo csvInfo = dlg.getCsvInfo();
        if (csvInfo == null) {
            return;
        }
        new Thread(new CsvInputImportToDB(csvInfo)).start();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jLabelStatusBar = new JLabel();
            this.jLabelStatusBar.setFont(new Font("Dialog", 0, 14));
            this.jLabelStatusBar.setText(" ");
            this.jLabelStatusBar.setName("statusBar");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJSplitPaneBase(), "Center");
            this.jContentPane.add((Component)this.jLabelStatusBar, "South");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJPanelEditButton(), "North");
            this.jPanel.add((Component)this.getJScrollPane(), "Center");
        }
        return this.jPanel;
    }

    private JPanelEditButton getJPanelEditButton() {
        if (this.jPanelEditButton == null) {
            this.jPanelEditButton = new JPanelEditButton();
        }
        return this.jPanelEditButton;
    }

    private JTreeDataBaseObjects getJTreeDataBaseObjects() {
        if (this.jTreeDataBaseObjects == null) {
            this.jTreeDataBaseObjects = new JTreeDataBaseObjects();
        }
        return this.jTreeDataBaseObjects;
    }

    private JSplitPane getJSplitPaneBase() {
        if (this.jSplitPaneBase == null) {
            this.jSplitPaneBase = new JSplitPane();
            this.jSplitPaneBase.setDividerLocation(150);
            this.jSplitPaneBase.setOneTouchExpandable(true);
            this.jSplitPaneBase.setDividerSize(7);
            this.jSplitPaneBase.setLeftComponent(this.getJPanel());
        }
        return this.jSplitPaneBase;
    }

    private void actionPerformedHelpAbout(ActionEvent e) {
        JFrameAboutBox dlg = JFrameAboutBox.getInstance();
        dlg.setVisible(true);
    }

    public void setMessage(String msg) {
        if (this.jLabelStatusBar != null) {
            this.jLabelStatusBar.setText(msg);
        }
    }

    private JMenuBar getJMenuBarBase() {
        if (this.jMenuBarBase == null) {
            this.jMenuBarBase = new JMenuBar();
            this.jMenuBarBase.add(this.getJMenuFile());
            this.jMenuBarBase.add(this.getJMenuDisplay());
            this.jMenuBarBase.add(this.getJMenuHelp1());
        }
        return this.jMenuBarBase;
    }

    private JMenu getJMenuFile() {
        if (this.jMenuFile == null) {
            this.jMenuFile = new JMenu();
            this.jMenuFile.setText("\u30d5\u30a1\u30a4\u30eb(F)");
            this.jMenuFile.setMnemonic(70);
            this.jMenuFile.add(this.getJMenuNew());
            this.jMenuFile.add(this.getJMenuItemFileConnect());
            this.jMenuFile.add(this.getJMenuItemFileDisConnect());
            this.jMenuFile.add(this.getJMenuItemFileCsvImport());
            this.jMenuFile.add(this.getJMenuItemCsvImportHistory());
            this.jMenuFile.add(this.getJMenuItemHexViewer());
            this.jMenuFile.add(this.getJMenuItemFileExit());
        }
        return this.jMenuFile;
    }

    private JMenu getJMenuHelp1() {
        if (this.jMenuHelp1 == null) {
            this.jMenuHelp1 = new JMenu();
            this.jMenuHelp1.setText("\u30d8\u30eb\u30d7(H)");
            this.jMenuHelp1.setMnemonic(72);
            this.jMenuHelp1.add(this.getJCheckBoxMenuItemDebug());
            this.jMenuHelp1.add(this.getJMenuItemHelpAbout());
        }
        return this.jMenuHelp1;
    }

    private JMenuItem getJMenuItemFileConnect() {
        if (this.jMenuItemFileConnect == null) {
            this.jMenuItemFileConnect = new JMenuItem();
            this.jMenuItemFileConnect.setText("\u63a5\u7d9a...(C)");
            this.jMenuItemFileConnect.setMnemonic(67);
            this.jMenuItemFileConnect.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean rtn = JFrameMain.this.actionPerformedConnect();
                    if (!rtn) {
                        return;
                    }
                    JFrameMain.this.jTreeDataBaseObjects.clearTree();
                    JFrameMain.this.tabWinManager.allDisconnect();
                    JFrameMain.this.jTreeDataBaseObjects.setTree();
                    if (JFrameMain.this.tabWinManager.getExecSqlListCnt() == 0) {
                        JFrameMain.this.tabWinManager.newPanel(true);
                        JFrameMain.this.tabWinManager.newPanel(true);
                        JFrameMain.this.tabWinManager.newPanel(true);
                        JFrameMain.this.tabWinManager.newPanel(true);
                    }
                }
            });
        }
        return this.jMenuItemFileConnect;
    }

    private JMenuItem getJMenuItemFileDisConnect() {
        if (this.jMenuItemFileDisConnect == null) {
            this.jMenuItemFileDisConnect = new JMenuItem();
            this.jMenuItemFileDisConnect.setText("\u5207\u65ad(D)");
            this.jMenuItemFileDisConnect.setMnemonic(68);
            this.jMenuItemFileDisConnect.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedDisConnect(e);
                }
            });
        }
        return this.jMenuItemFileDisConnect;
    }

    private JMenuItem getJMenuItemFileCsvImport() {
        if (this.jMenuItemFileCsvImport == null) {
            this.jMenuItemFileCsvImport = new JMenuItem();
            this.jMenuItemFileCsvImport.setText("CSV\u5165\u529b...(I)");
            this.jMenuItemFileCsvImport.setMnemonic(73);
            this.jMenuItemFileCsvImport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedCsvImport(e);
                }
            });
        }
        return this.jMenuItemFileCsvImport;
    }

    private JMenuItem getJMenuItemFileExit() {
        if (this.jMenuItemFileExit == null) {
            this.jMenuItemFileExit = new JMenuItem();
            this.jMenuItemFileExit.setText("\u7d42\u4e86(X)");
            this.jMenuItemFileExit.setMnemonic(88);
            this.jMenuItemFileExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.closeAnotherFrame();
                    JFrameMain.this.closeFrame();
                }
            });
        }
        return this.jMenuItemFileExit;
    }

    private JMenuItem getJMenuItemHelpAbout() {
        if (this.jMenuItemHelpAbout == null) {
            this.jMenuItemHelpAbout = new JMenuItem();
            this.jMenuItemHelpAbout.setText("\u3053\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306b\u3064\u3044\u3066(A)");
            this.jMenuItemHelpAbout.setMnemonic(65);
            this.jMenuItemHelpAbout.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedHelpAbout(e);
                }
            });
        }
        return this.jMenuItemHelpAbout;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTreeDataBaseObjects());
        }
        return this.jScrollPane;
    }

    private JMenu getJMenuNew() {
        if (this.jMenuNew == null) {
            this.jMenuNew = new JMenu();
            this.jMenuNew.setText("\u65b0\u898f(N)");
            this.jMenuNew.setMnemonic(78);
            this.jMenuNew.add(this.getJMenuItemAutoCommit());
            this.jMenuNew.add(this.getJMenuItemManualCommit());
        }
        return this.jMenuNew;
    }

    private JMenuItem getJMenuItemAutoCommit() {
        if (this.jMenuItemAutoCommit == null) {
            this.jMenuItemAutoCommit = new JMenuItem();
            this.jMenuItemAutoCommit.setText("AutoCommit");
            this.jMenuItemAutoCommit.setMnemonic(65);
            this.jMenuItemAutoCommit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedNewWindow(true);
                }
            });
        }
        return this.jMenuItemAutoCommit;
    }

    private JMenuItem getJMenuItemManualCommit() {
        if (this.jMenuItemManualCommit == null) {
            this.jMenuItemManualCommit = new JMenuItem();
            this.jMenuItemManualCommit.setText("ManualCommit");
            this.jMenuItemManualCommit.setMnemonic(77);
            this.jMenuItemManualCommit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedNewWindow(false);
                }
            });
        }
        return this.jMenuItemManualCommit;
    }

    private JMenu getJMenuDisplay() {
        if (this.jMenuDisplay == null) {
            this.jMenuDisplay = new JMenu();
            this.jMenuDisplay.setText("\u8868\u793a(V)");
            this.jMenuDisplay.setMnemonic(86);
            this.jMenuDisplay.add(this.getJMenuItemChangeTab());
            this.jMenuDisplay.addSeparator();
            this.jMenuDisplay.add(this.getJMenuItemChangeWin());
            this.jMenuDisplay.add(this.getJMenuItemWinSort());
            this.jMenuDisplay.addSeparator();
            this.jMenuDisplay.add(this.getJMenuChangeUI());
            this.jMenuDisplay.add(this.getJMenuBinaryData());
            this.jMenuDisplay.add(this.getJMenuItemSetting());
        }
        return this.jMenuDisplay;
    }

    private JMenuItem getJMenuItemChangeTab() {
        if (this.jMenuItemChangeWin == null) {
            this.jMenuItemChangeWin = new JMenuItem();
            this.jMenuItemChangeWin.setText("\u30bf\u30d6\u306b\u5207\u66ff(T)");
            this.jMenuItemChangeWin.setMnemonic(84);
            this.jMenuItemChangeWin.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedTabWin(TabWinMode.TAB);
                }
            });
        }
        return this.jMenuItemChangeWin;
    }

    private JMenuItem getJMenuItemChangeWin() {
        if (this.jMenuItemChangeTab == null) {
            this.jMenuItemChangeTab = new JMenuItem();
            this.jMenuItemChangeTab.setText("\u30a6\u30a3\u30f3\u30c9\u30a6\u306b\u5207\u66ff(W)");
            this.jMenuItemChangeTab.setMnemonic(87);
            this.jMenuItemChangeTab.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedTabWin(TabWinMode.WIN);
                }
            });
        }
        return this.jMenuItemChangeTab;
    }

    private JMenuItem getJMenuItemWinSort() {
        if (this.jMenuItemWinSort == null) {
            this.jMenuItemWinSort = new JMenuItem();
            this.jMenuItemWinSort.setText("\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u6574\u5217(S)");
            this.jMenuItemWinSort.setMnemonic(83);
            this.jMenuItemWinSort.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedSort();
                }
            });
        }
        return this.jMenuItemWinSort;
    }

    private JMenuItem getJMenuItemCsvImportHistory() {
        if (this.jMenuItemCsvImportHistory == null) {
            this.jMenuItemCsvImportHistory = new JMenuItem();
            this.jMenuItemCsvImportHistory.setText("CSV\u5165\u529b\u5c65\u6b74...(H)");
            this.jMenuItemCsvImportHistory.setMnemonic(72);
            this.jMenuItemCsvImportHistory.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameImportHistory.getInstance().setVisible(true);
                }
            });
        }
        return this.jMenuItemCsvImportHistory;
    }

    public static JPanelPrepareStatementLog getInstanceJPanelPrepareStatementLog() {
        if (jPanelPrepareStatementLog == null) {
            jPanelPrepareStatementLog = new JPanelPrepareStatementLog();
        }
        return jPanelPrepareStatementLog;
    }

    public static JPanelResultSetMetaData getInstanceJPanelResultSetMetaData() {
        if (jPanelResultSetMetaData == null) {
            jPanelResultSetMetaData = new JPanelResultSetMetaData();
        }
        return jPanelResultSetMetaData;
    }

    private JCheckBoxMenuItem getJCheckBoxMenuItemDebug() {
        if (this.jCheckBoxMenuItemDebug == null) {
            this.jCheckBoxMenuItemDebug = new JCheckBoxMenuItem();
            this.jCheckBoxMenuItemDebug.setText("\u30c7\u30d0\u30c3\u30af\u30e2\u30fc\u30c9(D)");
            this.jCheckBoxMenuItemDebug.setMnemonic(68);
            this.jCheckBoxMenuItemDebug.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        debugMode = true;
                        JFrameMain.this.tabWinManager.addPanel(JFrameMain.getInstanceJPanelPrepareStatementLog());
                        JFrameMain.this.tabWinManager.addPanel(JFrameMain.getInstanceJPanelResultSetMetaData());
                        JFrameMain.this.jPanelDatabaseMetaData = new JPanelDatabaseMetaData();
                        JFrameMain.this.tabWinManager.addPanel(JFrameMain.this.jPanelDatabaseMetaData);
                        try {
                            JFrameMain.this.jPanelDatabaseMetaData.setData(SqlExec.getDatabaseMetaData());
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        debugMode = false;
                        JFrameMain.this.tabWinManager.disposePanel(JFrameMain.getInstanceJPanelPrepareStatementLog());
                        JFrameMain.this.tabWinManager.disposePanel(JFrameMain.getInstanceJPanelResultSetMetaData());
                        JFrameMain.this.tabWinManager.disposePanel(JFrameMain.this.jPanelDatabaseMetaData);
                        JFrameMain.jPanelPrepareStatementLog = null;
                        JFrameMain.jPanelResultSetMetaData = null;
                        JFrameMain.this.jPanelDatabaseMetaData = null;
                    }
                }
            });
        }
        return this.jCheckBoxMenuItemDebug;
    }

    private JMenu getJMenuChangeUI() {
        if (this.jMenuChangeUI == null) {
            UIManager.LookAndFeelInfo[] infos;
            this.jMenuChangeUI = new JMenu();
            this.jMenuChangeUI.setText("UI\u5207\u66ff(C)");
            this.jMenuChangeUI.setMnemonic(67);
            ButtonGroup group = new ButtonGroup();
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = infos = UIManager.getInstalledLookAndFeels();
            int n = 0;
            int n2 = lookAndFeelInfoArray.length;
            while (n < n2) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n];
                JRadioButtonMenuItem item = new JRadioButtonMenuItem();
                item.setText(info.getName());
                item.setActionCommand(info.getClassName());
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JFrameMain.this.actionPerformedChnageUI(e);
                    }
                });
                group.add(item);
                this.jMenuChangeUI.add(item);
                if (UIManager.getLookAndFeel().getClass().getName().equals(info.getClassName())) {
                    item.setSelected(true);
                }
                ++n;
            }
            this.jMenuChangeUI.add(this.getJRadioButtonMenuItem());
            group.add(this.jRadioButtonMenuItem);
        }
        return this.jMenuChangeUI;
    }

    protected void actionPerformedChnageUI(ActionEvent e) {
        try {
            UIManager.setLookAndFeel(e.getActionCommand());
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e1) {
            e1.printStackTrace();
        }
        SwingUtilities.updateComponentTreeUI(this);
        JPopupMenuCnageUI.changeUI();
        JFrameBase.changeUI();
        new ComponentProperty().put(UIManager.class, "className", UIManager.getLookAndFeel().getClass().getName());
    }

    private JRadioButtonMenuItem getJRadioButtonMenuItem() {
        if (this.jRadioButtonMenuItem == null) {
            this.jRadioButtonMenuItem = new JRadioButtonMenuItem();
            this.jRadioButtonMenuItem.setText("Synth...");
            this.jRadioButtonMenuItem.setVisible(false);
            this.jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SynthLookAndFeel synth = new SynthLookAndFeel();
                    try {
                        synth.load(this.getClass().getResourceAsStream("file1.xml"), this.getClass());
                        UIManager.setLookAndFeel(synth);
                    }
                    catch (IllegalArgumentException e1) {
                        e1.printStackTrace();
                    }
                    catch (ParseException e1) {
                        e1.printStackTrace();
                    }
                    catch (UnsupportedLookAndFeelException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.jRadioButtonMenuItem;
    }

    private JMenuItem getJMenuItemHexViewer() {
        if (this.jMenuItemHexViewer == null) {
            this.jMenuItemHexViewer = new JMenuItem();
            this.jMenuItemHexViewer.setText("\u30d0\u30a4\u30ca\u30ea\u30d3\u30e5\u30fc\u30ef[File]...(V)");
            this.jMenuItemHexViewer.setMnemonic(86);
            this.jMenuItemHexViewer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameMain.this.actionPerformedHexViewer();
                }
            });
        }
        return this.jMenuItemHexViewer;
    }

    protected void actionPerformedHexViewer() {
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
                JFrameViewerHex oh = JFrameViewerHex.getInstance();
                oh.setInputStream(is);
                oh.setDataSize(f.length());
                oh.setDataSource(f.getAbsolutePath());
                oh.output();
            }
            catch (FileNotFoundException e) {
                JDialogMessage.errorDialog(e);
            }
            catch (IOException e) {
                JDialogMessage.errorDialog(e);
            }
        }
    }

    private JMenu getJMenuBinaryData() {
        if (this.jMenuBinaryData == null) {
            this.jMenuBinaryData = new JMenu();
            this.jMenuBinaryData.setText("\u30d0\u30a4\u30ca\u30ea\u691c\u7d22\u7d50\u679c\u306e\u8aad\u8fbc\u91cf(R)");
            this.jMenuBinaryData.setMnemonic(82);
            this.jMenuBinaryData.setToolTipText("<html>\u753b\u9762\u8868\u793a\u6642\u306e\u307f\u6709\u52b9\u3067\u3059\u3002<br><strong>\uff23\uff33\uff36\u51fa\u529b\u6642\u306f\u5e38\u306b\u300e\u5168\u3066\u8aad\u8fbc\u300f</strong>\u3067\u884c\u306a\u308f\u308c\u307e\u3059\u3002</htmb>");
            this.jMenuBinaryData.add(this.getJRadioButtonMenuItemNoLimit());
            this.jMenuBinaryData.add(this.getJRadioButtonMenuItemLimit100B());
            this.jMenuBinaryData.add(this.getJRadioButtonMenuItemLimit1KB());
            this.jMenuBinaryData.add(this.getJRadioButtonMenuItemLimit10KB());
            this.jMenuBinaryData.add(this.getJRadioButtonMenuItemLimit100KB());
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.getJRadioButtonMenuItemNoLimit());
            bg.add(this.getJRadioButtonMenuItemLimit100B());
            bg.add(this.getJRadioButtonMenuItemLimit1KB());
            bg.add(this.getJRadioButtonMenuItemLimit10KB());
            bg.add(this.getJRadioButtonMenuItemLimit100KB());
        }
        return this.jMenuBinaryData;
    }

    private JRadioButtonMenuItem getJRadioButtonMenuItemNoLimit() {
        if (this.jRadioButtonMenuItemNoLimit == null) {
            this.jRadioButtonMenuItemNoLimit = new JRadioButtonMenuItem();
            this.jRadioButtonMenuItemNoLimit.setText("\u5168\u3066\u8aad\u8fbc");
            this.jRadioButtonMenuItemNoLimit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    binaryDataSize = 0;
                }
            });
        }
        return this.jRadioButtonMenuItemNoLimit;
    }

    private JRadioButtonMenuItem getJRadioButtonMenuItemLimit100B() {
        if (this.jRadioButtonMenuItemLimit100B == null) {
            this.jRadioButtonMenuItemLimit100B = new JRadioButtonMenuItem();
            this.jRadioButtonMenuItemLimit100B.setText("100Byte\u8fc4\u8aad\u8fbc");
            this.jRadioButtonMenuItemLimit100B.setSelected(true);
            this.jRadioButtonMenuItemLimit100B.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    binaryDataSize = 100;
                }
            });
        }
        return this.jRadioButtonMenuItemLimit100B;
    }

    private JRadioButtonMenuItem getJRadioButtonMenuItemLimit1KB() {
        if (this.jRadioButtonMenuItemLimit1KB == null) {
            this.jRadioButtonMenuItemLimit1KB = new JRadioButtonMenuItem();
            this.jRadioButtonMenuItemLimit1KB.setText("1KByte\u8fc4\u8aad\u8fbc");
            this.jRadioButtonMenuItemLimit1KB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    binaryDataSize = 1024;
                }
            });
        }
        return this.jRadioButtonMenuItemLimit1KB;
    }

    private JRadioButtonMenuItem getJRadioButtonMenuItemLimit10KB() {
        if (this.jRadioButtonMenuItemLimit10KB == null) {
            this.jRadioButtonMenuItemLimit10KB = new JRadioButtonMenuItem();
            this.jRadioButtonMenuItemLimit10KB.setText("10KByte\u8fc4\u8aad\u8fbc");
            this.jRadioButtonMenuItemLimit10KB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    binaryDataSize = 10240;
                }
            });
        }
        return this.jRadioButtonMenuItemLimit10KB;
    }

    private JRadioButtonMenuItem getJRadioButtonMenuItemLimit100KB() {
        if (this.jRadioButtonMenuItemLimit100KB == null) {
            this.jRadioButtonMenuItemLimit100KB = new JRadioButtonMenuItem();
            this.jRadioButtonMenuItemLimit100KB.setText("100KByte\u8fc4\u8aad\u8fbc");
            this.jRadioButtonMenuItemLimit100KB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    binaryDataSize = 102400;
                }
            });
        }
        return this.jRadioButtonMenuItemLimit100KB;
    }

    private JMenuItem getJMenuItemSetting() {
        if (this.jMenuItemSetting == null) {
            this.jMenuItemSetting = new JMenuItem();
            this.jMenuItemSetting.setText("\u8a2d\u5b9a...");
            this.jMenuItemSetting.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFrameSetting jd = JFrameSetting.getInstance();
                    jd.setVisible(true);
                }
            });
        }
        return this.jMenuItemSetting;
    }

    public static Component serachComponent(Component component, Class c) {
        Logger.global.finest(" serachComponent:component=" + component.getClass().getName() + " Class=" + c.getClass().getName());
        if (component.getClass() == c) {
            return component;
        }
        Container parent = component.getParent();
        if (parent == null) {
            return null;
        }
        return JFrameMain.serachComponent(parent, c);
    }
}

