/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.dbconnect;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBMSinfo {
    private String classPath;
    private String url;
    private String DBMSname;

    public static ArrayList<String> getDBMSList() throws SAXException, IOException {
        DBMSinfo dbmsInfo = new DBMSinfo();
        XMLReader parser = XMLReaderFactory.createXMLReader();
        DBMSlisSAXHandler handler = dbmsInfo.new DBMSlisSAXHandler();
        parser.setContentHandler(handler);
        InputStream fs = DBMSinfo.class.getResourceAsStream("DBMS.xml");
        InputSource in = new InputSource(new InputStreamReader(fs));
        parser.parse(in);
        return handler.getDBMSnames();
    }

    public String getDBMSname() {
        return this.DBMSname;
    }

    public void setDBMSname(String sname) throws SAXException, IOException {
        this.DBMSname = sname;
        this.url = "";
        this.classPath = "";
        if (this.DBMSname == null) {
            return;
        }
        if (this.DBMSname.equals("")) {
            return;
        }
        XMLReader parser = XMLReaderFactory.createXMLReader();
        DBMSkeySAXHandler handler = new DBMSkeySAXHandler();
        handler.setDBMSname(this.getDBMSname());
        parser.setContentHandler(handler);
        InputStream fs = this.getClass().getResourceAsStream("DBMS.xml");
        InputSource in = new InputSource(new InputStreamReader(fs));
        parser.parse(in);
        this.url = "jdbc" + ("".equals(handler.getSubprotocol()) ? "" : ":" + handler.getSubprotocol()) + ("".equals(handler.getSubname()) ? "" : ":" + handler.getSubname());
        this.classPath = handler.getDriver();
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DBMSlisSAXHandler
    extends DefaultHandler {
        ArrayList<String> DBMSnames;

        DBMSlisSAXHandler() {
        }

        ArrayList<String> getDBMSnames() {
            return this.DBMSnames;
        }

        @Override
        public void startDocument() {
            this.DBMSnames = new ArrayList();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
            if (qName.equals("DBMS")) {
                int i = 0;
                while (i < attributes.getLength()) {
                    String attrQName = attributes.getQName(i);
                    String attrValue = attributes.getValue(i);
                    if (attrQName.equals("name")) {
                        this.DBMSnames.add(attrValue);
                    }
                    ++i;
                }
            }
        }
    }

    class DBMSkeySAXHandler
    extends DefaultHandler {
        private String DBMSname;
        private StringBuffer sb;
        private boolean searchHit;
        private String subprotocol;
        private String subname;
        private String driver;

        DBMSkeySAXHandler() {
        }

        void setDBMSname(String str) {
            this.DBMSname = str;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
            this.sb = new StringBuffer();
            if (!qName.equals("DBMS")) {
                return;
            }
            int i = 0;
            while (i < attributes.getLength()) {
                String attrQName = attributes.getQName(i);
                String attrValue = attributes.getValue(i);
                if (attrQName.equals("name")) {
                    this.searchHit = attrValue.equals(this.DBMSname);
                }
                ++i;
            }
        }

        public void characters(char[] ch, int offset, int length) {
            this.sb.append(ch, offset, length);
        }

        public void endElement(String uri, String localName, String qName) {
            if (!this.searchHit) {
                return;
            }
            if (qName.equals("subprotocol")) {
                this.subprotocol = this.sb.toString();
            }
            if (qName.equals("subname")) {
                this.subname = this.sb.toString();
            }
            if (qName.equals("driver")) {
                this.driver = this.sb.toString();
            }
        }

        String getDriver() {
            return this.driver;
        }

        String getSubname() {
            return this.subname;
        }

        String getSubprotocol() {
            return this.subprotocol;
        }
    }
}

