/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.csv;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import jdbcacsess.PrefixStringBuffer;
import jdbcacsess.gui.JFrameSetting;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.ColumnInfoTable;
import jdbcacsess.sql.PrepareExecute;
import jdbcacsess.sql.PrepareExecuteStatement;
import jdbcacsess.sql.SchemaTableName;
import jdbcacsess.sql.SqlExec;
import jdbcacsess.sql.SqlMappingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvImportSqlExecute {
    private SchemaTableName tbl;
    private ArrayList<String> lowHeader;
    private ArrayList<String> primeKeys;
    private ArrayList<ColumnInfoTable> columnInfoTables;
    private ArrayList<ColumnInfoResult> columnInfoResult;
    private ArrayList<Integer> primeIdxOnCsv;
    private ArrayList<Integer> primeIdxOnTable;
    private ArrayList<Integer> columnIdxOnTable;
    private Connection con;
    private String nullValue;
    private PrepareExecuteStatement insertOvpCmd = null;
    private PrepareExecuteStatement insertCavCmd = null;
    private PrepareExecuteStatement updateCmd = null;
    private PrepareExecuteStatement selectCountCmd = null;

    public CsvImportSqlExecute(Connection con, SchemaTableName tbl, Vector<String> rowHeader) throws SQLException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.con = con;
        this.tbl = tbl;
        this.lowHeader = new ArrayList();
        for (String str : rowHeader) {
            this.lowHeader.add(SqlExec.convertStoresIdentifiers(str));
        }
        this.columnInfoTables = SqlExec.getColumnMames(tbl);
        if (this.columnInfoTables.isEmpty()) {
            throw new SQLException("\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093[" + tbl.toString() + "]");
        }
        this.columnInfoResult = new ArrayList();
        SqlMappingInfo smi = new SqlMappingInfo();
        this.primeKeys = new ArrayList();
        for (ColumnInfoTable cit : this.columnInfoTables) {
            ColumnInfoResult cir = new ColumnInfoResult(cit);
            smi.search(cir, false);
            this.columnInfoResult.add(cir);
            if (!cit.isPrimaryKey()) continue;
            this.primeKeys.add(cit.getColumnName());
        }
        this.primeIdxOnCsv = new ArrayList();
        this.primeIdxOnTable = new ArrayList();
        for (String str : this.primeKeys) {
            int idx = rowHeader.indexOf(str);
            if (idx != -1) {
                this.primeIdxOnCsv.add(idx);
            }
            if ((idx = this.indexOfcolumnInfoTables(str)) == -1) continue;
            this.primeIdxOnTable.add(idx);
        }
        this.columnIdxOnTable = new ArrayList();
        for (String str : rowHeader) {
            int idx = this.indexOfcolumnInfoTables(str);
            if (idx == -1) continue;
            this.columnIdxOnTable.add(idx);
        }
        this.nullValue = JFrameSetting.getColumnOutNullValue();
    }

    private int indexOfcolumnInfoTables(String columnName) {
        int i = 0;
        while (i < this.columnInfoTables.size()) {
            ColumnInfoTable element = this.columnInfoTables.get(i);
            if (element.getColumnName().equals(columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String hasAllColumn() {
        for (String str : this.lowHeader) {
            if (this.indexOfcolumnInfoTables(str) != -1) continue;
            return "\u30ab\u30e9\u30e0\u540d:[" + str + "] \u30c6\u30fc\u30d6\u30eb\u540d:[" + this.tbl + "]";
        }
        return "";
    }

    public String hasPrimeKey() {
        if (this.primeKeys.size() == 0) {
            return "\u4e3b\u30ad\u30fc\u304c\u7121\u3044\u30c6\u30fc\u30d6\u30eb\u306fupdate\u6307\u5b9a\u51fa\u6765\u307e\u305b\u3093";
        }
        for (String str : this.primeKeys) {
            if (this.lowHeader.indexOf(str) != -1) continue;
            return "\u30ab\u30e9\u30e0\u540d:[" + str + "] \u30c6\u30fc\u30d6\u30eb\u540d:[" + this.tbl + "]";
        }
        return "";
    }

    public int execInsertOnlyValuePhrase(Vector<String> items) throws SQLException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.insertOvpCmd == null) {
            this.insertOvpCmd = new PrepareExecuteStatement();
            this.insertOvpCmd.addStm("INSERT INTO " + this.tbl.getCompleteTableName());
            this.insertOvpCmd.addStm(this.editValuesPhrase(items.size()));
            this.insertOvpCmd.prepare(this.con);
        }
        int columnInfoTableIdx = 0;
        while (columnInfoTableIdx < items.size()) {
            this.addItemValue(this.insertOvpCmd, items.get(columnInfoTableIdx), columnInfoTableIdx);
            ++columnInfoTableIdx;
        }
        return this.insertOvpCmd.executeUpdate();
    }

    private String editValuesPhrase(int size) {
        PrefixStringBuffer psb = new PrefixStringBuffer(" VALUES(", ",");
        int i = 0;
        while (i < size) {
            psb.appendItem("?");
            ++i;
        }
        return psb.append(")").getString();
    }

    public int execInsertColumnAndValue(Vector<String> items) throws SQLException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.columnIdxOnTable.size() != items.size()) {
            throw new SQLException("\u898b\u51fa\u3057\u9805\u76ee\u6570:" + this.columnIdxOnTable.size() + "\u3000\u3068\u660e\u7d30\u9805\u76ee\u6570:" + items.size() + "\u3000\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
        }
        if (this.insertCavCmd == null) {
            this.insertCavCmd = new PrepareExecuteStatement();
            this.insertCavCmd.addStm("INSERT INTO " + this.tbl.getCompleteTableName());
            PrefixStringBuffer psb = new PrefixStringBuffer(" (", ",");
            for (Integer idx : this.columnIdxOnTable) {
                psb.appendItem(this.columnInfoTables.get(idx).getColumnName());
            }
            this.insertCavCmd.addStm(psb.append(")").getString());
            this.insertCavCmd.addStm(this.editValuesPhrase(items.size()));
            this.insertCavCmd.prepare(this.con);
        }
        int i = 0;
        while (i < items.size()) {
            this.addItemValue(this.insertCavCmd, items.get(i), this.columnIdxOnTable.get(i));
            ++i;
        }
        return this.insertCavCmd.executeUpdate();
    }

    public int execUpdate(Vector<String> items) throws SQLException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.columnIdxOnTable.size() != items.size()) {
            throw new SQLException("\u898b\u51fa\u3057\u9805\u76ee\u6570:" + this.columnIdxOnTable.size() + "\u3000\u3068\u660e\u7d30\u9805\u76ee\u6570:" + items.size() + "\u3000\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
        }
        if (this.updateCmd == null) {
            this.updateCmd = new PrepareExecuteStatement();
            this.updateCmd.addStm("UPDATE " + this.tbl.getCompleteTableName());
            PrefixStringBuffer psb = new PrefixStringBuffer(" SET ", " ,");
            int i = 0;
            while (i < items.size()) {
                psb.appendItem(this.columnInfoTables.get(this.columnIdxOnTable.get(i)) + "=?");
                ++i;
            }
            this.updateCmd.addStm(psb.getString());
            psb = new PrefixStringBuffer(" WHERE ", " AND ");
            for (Integer idx : this.primeIdxOnCsv) {
                psb.appendItem(String.valueOf(this.lowHeader.get(idx)) + "=?");
            }
            this.updateCmd.addStm(psb.getString());
            this.updateCmd.prepare(this.con);
        }
        int i = 0;
        while (i < items.size()) {
            this.addItemValue(this.updateCmd, items.get(i), this.columnIdxOnTable.get(i));
            ++i;
        }
        i = 0;
        while (i < this.primeIdxOnCsv.size()) {
            int primeIdx_csv = this.primeIdxOnCsv.get(i);
            int primeIdx_table = this.primeIdxOnTable.get(i);
            this.addItemValue(this.updateCmd, items.get(primeIdx_csv), primeIdx_table);
            ++i;
        }
        return this.updateCmd.executeUpdate();
    }

    public int querySelectCount(Vector<String> items) throws SQLException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.selectCountCmd == null) {
            this.selectCountCmd = new PrepareExecuteStatement();
            this.selectCountCmd.addStm("SELECT COUNT(*) FROM " + this.tbl.getCompleteTableName());
            PrefixStringBuffer psb = new PrefixStringBuffer(" WHERE ", " AND ");
            for (Integer idx : this.primeIdxOnCsv) {
                psb.appendItem(String.valueOf(this.lowHeader.get(idx)) + "=?");
            }
            this.selectCountCmd.addStm(psb.getString());
            this.selectCountCmd.prepare(this.con);
        }
        int i = 0;
        while (i < this.primeIdxOnCsv.size()) {
            int primeIdx_csv = this.primeIdxOnCsv.get(i);
            int primeIdx_table = this.primeIdxOnTable.get(i);
            this.addItemValue(this.selectCountCmd, items.get(primeIdx_csv), primeIdx_table);
            ++i;
        }
        ResultSet rs = this.selectCountCmd.executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    private void addItemValue(PrepareExecute cmd, String item, int columnInfoTableIdx) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ColumnInfoResult cir = this.columnInfoResult.get(columnInfoTableIdx);
        if (item.equals(this.nullValue)) {
            cmd.addParm(null, cir);
            return;
        }
        Object value = cir.getConstructor().newInstance(item);
        cmd.addParm(value, cir);
    }
}

