/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import jdbcacsess.sql.DBObject;
import jdbcacsess.sql.DBObjectCatalogs;
import jdbcacsess.sql.DBObjects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObjectSchemas
extends DBObjects {
    static final String[] header = new String[]{"TABLE_SCHEM", "TABLE_CATALOG"};
    DBObjectCatalogs.DBObjectCatalog dBObjectCatalog;
    private ArrayList<DBObject> schemas = new ArrayList();

    public DBObjectSchemas(DBObjectCatalogs.DBObjectCatalog dBObjectCatalog, DatabaseMetaData dmd) throws SQLException {
        this.dBObjectCatalog = dBObjectCatalog;
        ResultSet rs = dmd.getSchemas();
        while (rs.next()) {
            this.schemas.add(new DBObjectSchema(rs));
        }
        rs.close();
        if (this.schemas.size() == 0) {
            this.schemas.add(new DBObjectSchema());
        }
    }

    public ArrayList<DBObject> getDBObjects() {
        return this.schemas;
    }

    @Override
    public String toString() {
        return "SCHEMA";
    }

    public class DBObjectSchema
    extends DBObject {
        private String schemaName;
        private String catalogName;

        public DBObjectSchema(ResultSet rs) throws SQLException {
            int colCnt = rs.getMetaData().getColumnCount();
            if (colCnt > 0) {
                this.schemaName = rs.getString(1);
            }
            if (colCnt > 1) {
                this.catalogName = rs.getString(2);
            }
        }

        public DBObjectSchema() {
        }

        public String[] getDetail() {
            String[] rtn = new String[]{this.catalogName, this.schemaName};
            return rtn;
        }

        public String toString() {
            if (this.schemaName == null) {
                return "(null)";
            }
            return this.schemaName;
        }

        public String[] getHeader() {
            return header;
        }

        public String getCatalogName() {
            return this.catalogName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public DBObjectCatalogs.DBObjectCatalog getDBObjectCatalog() {
            return DBObjectSchemas.this.dBObjectCatalog;
        }
    }
}

