/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import jdbcacsess.sql.DBObject;
import jdbcacsess.sql.DBObjects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObjectCatalogs
extends DBObjects {
    static final String[] header = new String[]{"TABLE_CAT"};
    private ArrayList<DBObject> catalogs = new ArrayList();

    public DBObjectCatalogs(DatabaseMetaData dmd) throws SQLException {
        ResultSet rs = dmd.getCatalogs();
        while (rs.next()) {
            this.catalogs.add(new DBObjectCatalog(rs));
        }
        rs.close();
        if (this.catalogs.size() == 0) {
            this.catalogs.add(new DBObjectCatalog());
        }
    }

    public ArrayList<DBObject> getDBObjects() {
        return this.catalogs;
    }

    @Override
    public String toString() {
        return "CATALOG";
    }

    public class DBObjectCatalog
    extends DBObject {
        private String catalogName;

        public DBObjectCatalog() throws SQLException {
        }

        public DBObjectCatalog(ResultSet rs) throws SQLException {
            int colCnt = rs.getMetaData().getColumnCount();
            if (colCnt > 0) {
                this.catalogName = rs.getString(1);
            }
        }

        public String[] getDetail() {
            String[] rtn = new String[]{this.catalogName};
            return rtn;
        }

        public String toString() {
            if (this.catalogName == null) {
                return "(null)";
            }
            return this.catalogName;
        }

        public String[] getHeader() {
            return header;
        }

        public String getCatalogName() {
            return this.catalogName;
        }
    }
}

