/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jdbcacsess.InfoListSetting;
import jdbcacsess.gui.CellRendererSqlTableArray;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.gui.common.ConstSqlTypes;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.SqlExec;
import jdbcacsess.sql.column.GetColumnBinary;
import jdbcacsess.sql.column.GetColumnBlob;
import jdbcacsess.sql.column.GetColumnBytesOrBinaryStream;
import jdbcacsess.sql.column.GetColumnResultSet;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlMappingInfo
extends InfoListSetting<SqlMappingInfo> {
    public static final String BASETABNAME = "sqlmappinginfo";
    private static Map<String, Class<?>> primitiveMap = new HashMap();
    private String cellEditorClassName;
    private String cellRendererClassName;
    private String dbms;
    private Boolean enable = true;
    private String getResultSetClassName;
    private String resultSetMethodName;
    private String type = "";
    private ConstSqlTypes sqlTypes = ConstSqlTypes.UNUSE;

    static {
        primitiveMap.put("byte", Byte.class);
        primitiveMap.put("short", Short.class);
        primitiveMap.put("int", Integer.class);
        primitiveMap.put("long", Long.class);
        primitiveMap.put("float", Float.class);
        primitiveMap.put("double", Double.class);
        primitiveMap.put("char", Character.class);
        primitiveMap.put("boolean", Boolean.class);
    }

    public static String editKey(String dbms, String type) {
        return String.valueOf(dbms) + "#$#" + type;
    }

    public SqlMappingInfo() {
        Element e = this.topElement();
        if (e.getElementsByTagName(this.getBaseTagName()).getLength() == 0) {
            this.save("Oracle", "BINARY_DOUBLE", "getDouble", "", ConstSqlTypes.UNUSE);
            this.save("Oracle", "BINARY_FLOAT", "getFloat", "", ConstSqlTypes.UNUSE);
            this.save("Oracle", "DATE", "", "jdbcacsess.sql.column.GetColumnTimestampSS", ConstSqlTypes.UNUSE);
            this.save("Oracle", "TIMESTAMP", "getTimestamp", "", ConstSqlTypes.UNUSE);
            this.save("Oracle", "TIMESTAMPTZ", "getString", "", ConstSqlTypes.UNUSE);
            this.save("Oracle", "TIMESTAMPLTZ", "", "jdbcacsess.sql.column.GetColumnOracleTIMESTAMPLTZ", ConstSqlTypes.UNUSE);
            this.save("MySQL", "BIT", "", "jdbcacsess.sql.column.GetColumnBytesOrBinaryStream", ConstSqlTypes.UNUSE);
            this.save("MySQL", "DATETIME", "", "jdbcacsess.sql.column.GetColumnTimestampSS", ConstSqlTypes.UNUSE);
            this.save("MySQL", "TIMESTAMP", "", "jdbcacsess.sql.column.GetColumnTimestampSS", ConstSqlTypes.UNUSE);
            this.save("MySQL", "YEAR", "", "jdbcacsess.sql.column.GetColumnDateYYYY", ConstSqlTypes.UNUSE);
            this.save("PostgreSQL", "interval", "", "org.postgresql.util.PGInterval", ConstSqlTypes.UNUSE);
            this.save("PostgreSQL", "timetz", "getString", "", ConstSqlTypes.TIME);
            this.save("PostgreSQL", "timestamptz", "getString", "", ConstSqlTypes.TIMESTAMP);
            this.save("PostgreSQL", "box", "", "org.postgresql.geometric.PGbox", ConstSqlTypes.UNUSE);
            this.save("PostgreSQL", "circle", "", "org.postgresql.geometric.PGcircle", ConstSqlTypes.UNUSE);
            this.save("PostgreSQL", "lseg", "", "org.postgresql.geometric.PGlseg", ConstSqlTypes.UNUSE);
            this.save("PostgreSQL", "path", "", "org.postgresql.geometric.PGpath", ConstSqlTypes.UNUSE);
            this.save("PostgreSQL", "point", "", "org.postgresql.geometric.PGpoint", ConstSqlTypes.UNUSE);
            this.save("PostgreSQL", "polygon", "", "org.postgresql.geometric.PGpolygon", ConstSqlTypes.UNUSE);
            this.save("PostgreSQL", "bit", "getString", "", ConstSqlTypes.VARCHAR);
            this.save("PostgreSQL", "varbit", "getString", "", ConstSqlTypes.VARCHAR);
            this.save("PostgreSQL", "cidr", "getString", "", ConstSqlTypes.UNUSE);
            this.save("PostgreSQL", "inet", "getString", "", ConstSqlTypes.UNUSE);
            this.save("PostgreSQL", "macaddr", "getString", "", ConstSqlTypes.UNUSE);
        }
    }

    @Override
    public void addToElement(Element element) {
        element.setAttribute("dbms", this.getDbms());
        element.setAttribute("type", this.getType());
        element.setAttribute("getResultSetClassName", this.getGetResultSetClassName());
        element.setAttribute("methodName", this.getResultSetMethodName());
        element.setAttribute("cellRendererClassName", this.getCellRendererClassName());
        element.setAttribute("cellEditorClassName", this.getCellEditorClassName());
        element.setAttribute("enable", this.getEnable().toString());
        element.setAttribute("sqlTypes", this.getSqlTypes().toString());
    }

    @Override
    protected String getBaseTagName() {
        return BASETABNAME;
    }

    @Override
    protected SqlMappingInfo getInstance() {
        return new SqlMappingInfo();
    }

    @Override
    public String getKeyValue() {
        return SqlMappingInfo.editKey(this.getDbms(), this.getType());
    }

    @Override
    public void setFromElement(Element element) {
        this.setDbms(element.getAttribute("dbms"));
        this.setType(element.getAttribute("type"));
        this.setGetResultSetClassName(element.getAttribute("getResultSetClassName"));
        this.setResultSetMethodName(element.getAttribute("methodName"));
        this.setCellRendererClassName(element.getAttribute("cellRendererClassName"));
        this.setCellEditorClassName(element.getAttribute("cellEditorClassName"));
        this.setEnable(new Boolean(element.getAttribute("enable")));
        this.setSqlTypes(ConstSqlTypes.searchName(element.getAttribute("sqlTypes")));
    }

    @Override
    protected void setKeyValue(String key) {
        StringTokenizer st = new StringTokenizer(key, "#$#");
        if (st.hasMoreTokens()) {
            this.setDbms(st.nextToken());
            if (st.hasMoreTokens()) {
                this.setType(st.nextToken());
            }
        }
    }

    public String getCellEditorClassName() {
        return this.cellEditorClassName;
    }

    public String getCellRendererClassName() {
        return this.cellRendererClassName;
    }

    public String getDbms() {
        return this.dbms;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public String getGetResultSetClassName() {
        return this.getResultSetClassName;
    }

    public Method getResultSetMethod() throws SecurityException, NoSuchMethodException {
        if (this.getResultSetMethodName().equals("")) {
            return null;
        }
        Method rtn = ResultSet.class.getMethod(this.getResultSetMethodName(), Integer.TYPE);
        return rtn;
    }

    public String getResultSetMethodName() {
        return this.resultSetMethodName;
    }

    public String getType() {
        return this.type;
    }

    private void save(String dbms, String type, String method, String cls, ConstSqlTypes sqlTypes) {
        this.setDbms(dbms);
        this.setType(type);
        this.setResultSetMethodName(method);
        this.setGetResultSetClassName(cls);
        this.setSqlTypes(sqlTypes);
        this.currentDataSave();
    }

    private Object instanceForClassname(String className) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class c = SqlExec.classForName(className);
        return c.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public void search(ColumnInfoResult colInfoResult, boolean binaryDatalimit) throws SecurityException, ClassNotFoundException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SQLException {
        Class<?> c;
        SqlMappingInfo smi;
        int binaryDataSize = 0;
        if (binaryDatalimit) {
            binaryDataSize = JFrameMain.binaryDataSize;
        }
        if ((smi = (SqlMappingInfo)this.getInfoMap().get(SqlMappingInfo.editKey(SqlExec.getDatabaseProductName(), colInfoResult.columnTypeName))) != null && smi.getEnable().booleanValue()) {
            if (!smi.getResultSetClassName.equals("")) {
                colInfoResult.methodOfResultSet = null;
                colInfoResult.setColumnClass(smi.getResultSetClassName);
                if (GetColumnResultSet.class.isAssignableFrom(colInfoResult.getColumnClass())) {
                    colInfoResult.getColumnResultSet = (GetColumnResultSet)colInfoResult.getColumnClass().newInstance();
                }
            } else {
                colInfoResult.methodOfResultSet = smi.getResultSetMethod();
                colInfoResult.setColumnClass(smi.getResultSetMethod().getReturnType());
            }
            if (smi.getSqlTypes() != ConstSqlTypes.JDBC) {
                colInfoResult.setSqlType(smi.getSqlTypes());
            }
            if (!smi.getCellRendererClassName().equals("")) {
                colInfoResult.setTableCellRenderer((TableCellRenderer)this.instanceForClassname(smi.getCellRendererClassName()));
            }
            if (!smi.getCellEditorClassName().equals("")) {
                colInfoResult.setTableCellEditor((TableCellEditor)this.instanceForClassname(smi.getCellEditorClassName()));
            }
        } else if (GetColumnBinary.isBinaryClassName(colInfoResult.getColumnClass().getName()) || colInfoResult.getSqlType().getCategoly() == ConstSqlTypes.Categoly.BIN) {
            if (colInfoResult.getSqlType() == ConstSqlTypes.BLOB) {
                colInfoResult.setColumnClass(GetColumnBlob.class);
                colInfoResult.getColumnResultSet = new GetColumnBlob(binaryDataSize);
            } else {
                colInfoResult.setColumnClass(GetColumnBytesOrBinaryStream.class);
                colInfoResult.getColumnResultSet = new GetColumnBytesOrBinaryStream(binaryDataSize);
            }
        }
        if (Array.class.isAssignableFrom(c = colInfoResult.getColumnClass())) {
            colInfoResult.setTableCellRenderer(new CellRendererSqlTableArray());
        }
        if (c.isPrimitive() && !c.isArray()) {
            colInfoResult.setColumnClass(primitiveMap.get(c.getName()));
        }
    }

    public void setCellEditorClassName(String cellEditorClass) {
        this.cellEditorClassName = cellEditorClass;
    }

    public void setCellRendererClassName(String cellRendererClass) {
        this.cellRendererClassName = cellRendererClass;
    }

    public void setDbms(String dbms) {
        this.dbms = dbms;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setGetResultSetClassName(String getResultSetClass) {
        this.getResultSetClassName = getResultSetClass;
    }

    public void setResultSetMethodName(String method) {
        this.resultSetMethodName = method;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ConstSqlTypes getSqlTypes() {
        return this.sqlTypes;
    }

    public void setSqlTypes(ConstSqlTypes sqlTypes) {
        this.sqlTypes = sqlTypes;
    }
}

