/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import jdbcacsess.JdbcacsessException;
import jdbcacsess.gui.JDialogPrepareParameter;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.sql.ColumnInfoResult;
import jdbcacsess.sql.JFrameResultSetMD;
import jdbcacsess.sql.PrepareExecute;
import jdbcacsess.sql.QueryExecuteListener;
import jdbcacsess.sql.QueryExecuteStatus;
import jdbcacsess.sql.SqlAnalyze;
import jdbcacsess.sql.SqlMappingInfo;
import jdbcacsess.sql.column.GetColumnResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryExecuteBase {
    private int cnt;
    private ResultSet resultSet = null;
    PrepareExecute prepareExecuteStatement = null;
    private Object source;
    private SqlAnalyze sqlAnalyze;
    private Connection con = null;
    private ArrayList<ColumnInfoResult> selectColmunInfos;
    private ArrayList<QueryExecuteListener> listeners;
    private SqlMappingInfo sqlMappingInfo;
    private boolean binaryDatalimit;
    private ArrayList<Object> rowData;

    protected QueryExecuteBase(Object source, SqlAnalyze sqlAnalyze, Connection con) {
        this.source = source;
        this.sqlAnalyze = sqlAnalyze;
        this.con = con;
        this.binaryDatalimit = false;
        this.listeners = new ArrayList();
        this.sqlMappingInfo = new SqlMappingInfo();
    }

    public void addQueryExecuteListener(QueryExecuteListener listener) {
        this.listeners.add(listener);
    }

    protected boolean initProc() throws Exception {
        JDialogPrepareParameter jdpp;
        this.cnt = 0;
        this.prepareExecuteStatement = new PrepareExecute();
        this.prepareExecuteStatement.addStm(this.sqlAnalyze.getSqlStatement());
        this.prepareExecuteStatement.prepare(this.con);
        if (this.prepareExecuteStatement.isHavingInputParameter() && !(jdpp = new JDialogPrepareParameter(this.prepareExecuteStatement)).isExecuteAns()) {
            return false;
        }
        this.resultSet = this.prepareExecuteStatement.executeQuery();
        this.openSqlCursor();
        this.sqlAnalyze.setSelectColmunInfo(this.selectColmunInfos);
        for (QueryExecuteListener listener : this.listeners) {
            listener.init();
        }
        for (QueryExecuteListener listener : this.listeners) {
            listener.setResultHeader(this.selectColmunInfos, this.sqlAnalyze);
        }
        return true;
    }

    protected void resultProc() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SQLException, IOException {
        this.getQueryReslut();
        for (QueryExecuteListener listener : this.listeners) {
            listener.setResultDetail(this.rowData);
        }
    }

    protected boolean queryNext() throws SQLException {
        if (this.resultSet == null) {
            return false;
        }
        if (this.resultSet.next()) {
            return true;
        }
        this.closeSqlCursor();
        return false;
    }

    protected void endProc(boolean runner, boolean err) {
        QueryExecuteStatus bs = new QueryExecuteStatus(this.source, this.cnt, runner, this.sqlAnalyze, err);
        for (QueryExecuteListener listener : this.listeners) {
            listener.completeQuery(bs);
        }
        try {
            this.closeSqlCursor();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void errorProc(Exception e) {
        e.printStackTrace();
        for (QueryExecuteListener listener : this.listeners) {
            listener.errorException(e);
        }
    }

    protected void statusProc(boolean runner, boolean err) {
        for (QueryExecuteListener listener : this.listeners) {
            listener.status(new QueryExecuteStatus(this.source, this.cnt, runner, this.sqlAnalyze, err));
        }
    }

    private void openSqlCursor() throws Exception {
        this.selectColmunInfos = new ArrayList();
        int col = this.resultSet.getMetaData().getColumnCount();
        ResultSetMetaData rsm = this.resultSet.getMetaData();
        int i = 1;
        while (i <= col) {
            ColumnInfoResult colInfo = new ColumnInfoResult(i, rsm.getColumnName(i), rsm.getColumnType(i), rsm.getColumnTypeName(i), rsm.isNullable(i), rsm.getColumnClassName(i), rsm.getPrecision(i), rsm.getScale(i));
            this.sqlMappingInfo.search(colInfo, this.binaryDatalimit);
            this.selectColmunInfos.add(colInfo);
            ++i;
        }
        this.rowData = new ArrayList(this.selectColmunInfos.size());
    }

    private void getQueryReslut() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SQLException {
        ++this.cnt;
        this.rowData.clear();
        int i = 1;
        while (i <= this.resultSet.getMetaData().getColumnCount()) {
            if (JFrameMain.debugMode && this.cnt == 1) {
                JFrameResultSetMD a = JFrameResultSetMD.getInstance();
                a.setData(this.resultSet);
            }
            try {
                if (this.resultSet.getMetaData().getColumnType(i) == 2005 || this.selectColmunInfos.get(i - 1).getColumnClass() == Reader.class) {
                    Clob clob = this.resultSet.getClob(i);
                    if (!this.isAddNull(this.rowData, clob)) {
                        this.rowData.add(clob.getSubString(1L, (int)clob.length()));
                    }
                } else {
                    GetColumnResultSet gcrs = this.selectColmunInfos.get((int)(i - 1)).getColumnResultSet;
                    if (gcrs != null) {
                        this.rowData.add(gcrs.getData(this.resultSet, i));
                    } else {
                        Object obj;
                        Method method = this.selectColmunInfos.get((int)(i - 1)).methodOfResultSet;
                        if (method != null) {
                            obj = method.invoke((Object)this.resultSet, i);
                            if (!this.isAddNull(this.rowData, obj)) {
                                this.rowData.add(obj);
                            }
                        } else {
                            obj = this.resultSet.getObject(i);
                            if (!this.isAddNull(this.rowData, obj)) {
                                this.rowData.add(obj);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                this.rowData.add(new JdbcacsessException(e));
            }
            ++i;
        }
    }

    private boolean isAddNull(ArrayList<Object> rowData, Object data) throws SQLException {
        if (this.resultSet.wasNull() || data == null) {
            rowData.add(null);
            return true;
        }
        return false;
    }

    private void closeSqlCursor() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.prepareExecuteStatement != null) {
            this.prepareExecuteStatement.close();
        }
    }

    public boolean isBinaryDatalimit() {
        return this.binaryDatalimit;
    }

    public void setBinaryDatalimit(boolean binaryDatalimit) {
        this.binaryDatalimit = binaryDatalimit;
    }
}

