/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import jdbcacsess.gui.JFrameMain;
import jdbcacsess.gui.common.ConstSqlTypes;
import jdbcacsess.gui.common.JDialogMessage;
import jdbcacsess.sql.JDialogPrepareStatementLog;
import jdbcacsess.sql.column.Binary;
import jdbcacsess.sql.column.BinaryInputStream;
import jdbcacsess.sql.column.CharacterInputStream;

public class PrepareExecute {
    ArrayList<PrepareExecuteParm> parmList;
    private PreparedStatement preparedStatement = null;
    StringBuffer statement = new StringBuffer();

    public PrepareExecute() {
        this.parmList = new ArrayList();
    }

    public void addStm(String stm) {
        this.statement.append(stm);
    }

    public String getStm() {
        return this.statement.toString();
    }

    public void addParm(Object value, ConstSqlTypes targetSqlType) {
        this.parmList.add(new PrepareExecuteParm(value, targetSqlType));
    }

    public void prepare(Connection con) throws SQLException {
        Logger.global.fine(con + " " + this.statement.toString());
        this.preparedStatement = con.prepareStatement(this.statement.toString());
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet rs = null;
        try {
            try {
                this.setParm();
                rs = this.preparedStatement.executeQuery();
            }
            catch (OutOfMemoryError err) {
                throw new SQLException(err.getMessage());
            }
        }
        finally {
            this.clearParm();
        }
        return rs;
    }

    public int executeUpdate() throws SQLException {
        int cnt;
        try {
            try {
                this.setParm();
                cnt = this.preparedStatement.executeUpdate();
            }
            catch (OutOfMemoryError err) {
                throw new SQLException(err.getMessage());
            }
        }
        finally {
            this.clearParm();
        }
        return cnt;
    }

    private void setParm() throws SQLException {
        int i = 0;
        while (i < this.parmList.size()) {
            Object value = this.parmList.get((int)i).x;
            ConstSqlTypes targetSqlType = this.parmList.get((int)i).targetSqlType;
            if (value == null) {
                this.preparedStatement.setNull(i + 1, 0);
            } else if (value instanceof BinaryInputStream) {
                BinaryInputStream bis = (BinaryInputStream)value;
                this.preparedStatement.setBinaryStream(i + 1, bis.getInputStream(), bis.getSize());
            } else if (value instanceof CharacterInputStream) {
                CharacterInputStream cis = (CharacterInputStream)value;
                this.preparedStatement.setCharacterStream(i + 1, cis.getReader(), cis.getSize());
            } else if (value instanceof Binary) {
                this.preparedStatement.setBytes(i + 1, ((Binary)value).getValue());
            } else if (targetSqlType == ConstSqlTypes.UNUSE) {
                this.preparedStatement.setObject(i + 1, value);
            } else {
                this.preparedStatement.setObject(i + 1, value, targetSqlType.getValue());
            }
            ++i;
        }
        if (JFrameMain.debugMode) {
            StringBuilder sb = new StringBuilder("PrepareExecute:" + this.statement + "#");
            for (PrepareExecuteParm o : this.parmList) {
                sb.append(o.x == null ? "null" : String.valueOf(o.x.toString()) + ":" + (Object)((Object)o.targetSqlType));
                sb.append("$");
            }
            sb.append("\n");
            JDialogPrepareStatementLog a = JDialogPrepareStatementLog.getInstance();
            a.appendLog(sb);
        }
    }

    private void clearParm() throws SQLException {
        for (PrepareExecuteParm item : this.parmList) {
            if (item instanceof BinaryInputStream) {
                BinaryInputStream bis = (BinaryInputStream)((Object)item);
                try {
                    bis.getInputStream().close();
                }
                catch (IOException e) {
                    JDialogMessage.errorDialog(e);
                }
            }
            if (!(item instanceof CharacterInputStream)) continue;
            CharacterInputStream cis = (CharacterInputStream)((Object)item);
            try {
                cis.getReader().close();
            }
            catch (IOException e) {
                JDialogMessage.errorDialog(e);
            }
        }
        this.parmList.clear();
        this.preparedStatement.clearParameters();
    }

    public int prepareExecuteUpdate(Connection con) throws SQLException {
        this.prepare(con);
        return this.executeUpdate();
    }

    public void close() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isHavingInputParameter() {
        try {
            ParameterMetaData pmd = this.preparedStatement.getParameterMetaData();
            if (pmd == null) {
                return false;
            }
            int i = 1;
            while (true) {
                if (i >= pmd.getParameterCount() + 1) {
                    return false;
                }
                if (pmd.getParameterMode(i) == 1) {
                    return true;
                }
                ++i;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    class PrepareExecuteParm {
        Object x;
        ConstSqlTypes targetSqlType;

        public PrepareExecuteParm(Object x, ConstSqlTypes targetSqlType) {
            this.x = x;
            this.targetSqlType = targetSqlType;
        }
    }
}

