/*
 * Decompiled with CFR 0.152.
 */
package jdbcacsess.sql;

import java.util.Comparator;
import jdbcacsess.gui.common.ConstSqlTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnInfo {
    protected int columnIndex = 0;
    protected String columnName = "";
    protected ConstSqlTypes sqlType;
    protected String columnTypeName = "";
    protected boolean nullable = false;
    private boolean primaryKey = false;
    private String remarks = "";

    public ColumnInfo(int index, String name, int sqlTypes, String typeName, int nullable) {
        this.columnIndex = index;
        this.columnName = name;
        this.sqlType = ConstSqlTypes.searchTypes(sqlTypes);
        this.columnTypeName = typeName;
        this.nullable = nullable == 1;
    }

    public String getColumnComment() {
        return " #" + this.columnIndex + " " + (this.primaryKey ? "<STRONG>" : "") + this.columnName + (this.primaryKey ? "</STRONG>" : "") + " : " + this.columnTypeName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public ConstSqlTypes getSqlType() {
        return this.sqlType;
    }

    public String getColumnTypeName() {
        return this.columnTypeName;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primKey) {
        this.primaryKey = primKey;
    }

    public String toString() {
        return this.columnName;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setSqlType(ConstSqlTypes sqlType) {
        this.sqlType = sqlType;
    }

    public static Comparator<ColumnInfo> getComparatorByPosition() {
        Comparator<ColumnInfo> rtn = new Comparator<ColumnInfo>(){

            @Override
            public int compare(ColumnInfo o1, ColumnInfo o2) {
                return o1.getColumnIndex() - o2.getColumnIndex();
            }
        };
        return rtn;
    }

    public static Comparator<ColumnInfo> getComparatorByColumnName() {
        Comparator<ColumnInfo> rtn = new Comparator<ColumnInfo>(){

            @Override
            public int compare(ColumnInfo o1, ColumnInfo o2) {
                return o1.getColumnName().compareTo(o2.getColumnName());
            }
        };
        return rtn;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? "" : remarks;
    }
}

